# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetCustomRoutingAcceleratorResult',
    'AwaitableGetCustomRoutingAcceleratorResult',
    'get_custom_routing_accelerator',
    'get_custom_routing_accelerator_output',
]

@pulumi.output_type
class GetCustomRoutingAcceleratorResult:
    """
    A collection of values returned by getCustomRoutingAccelerator.
    """
    def __init__(__self__, arn=None, attributes=None, dns_name=None, enabled=None, hosted_zone_id=None, id=None, ip_address_type=None, ip_sets=None, name=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if attributes and not isinstance(attributes, list):
            raise TypeError("Expected argument 'attributes' to be a list")
        pulumi.set(__self__, "attributes", attributes)
        if dns_name and not isinstance(dns_name, str):
            raise TypeError("Expected argument 'dns_name' to be a str")
        pulumi.set(__self__, "dns_name", dns_name)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if hosted_zone_id and not isinstance(hosted_zone_id, str):
            raise TypeError("Expected argument 'hosted_zone_id' to be a str")
        pulumi.set(__self__, "hosted_zone_id", hosted_zone_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_address_type and not isinstance(ip_address_type, str):
            raise TypeError("Expected argument 'ip_address_type' to be a str")
        pulumi.set(__self__, "ip_address_type", ip_address_type)
        if ip_sets and not isinstance(ip_sets, list):
            raise TypeError("Expected argument 'ip_sets' to be a list")
        pulumi.set(__self__, "ip_sets", ip_sets)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> str:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def attributes(self) -> Sequence['outputs.GetCustomRoutingAcceleratorAttributeResult']:
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> str:
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="hostedZoneId")
    def hosted_zone_id(self) -> str:
        return pulumi.get(self, "hosted_zone_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> str:
        return pulumi.get(self, "ip_address_type")

    @property
    @pulumi.getter(name="ipSets")
    def ip_sets(self) -> Sequence['outputs.GetCustomRoutingAcceleratorIpSetResult']:
        return pulumi.get(self, "ip_sets")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        return pulumi.get(self, "tags")


class AwaitableGetCustomRoutingAcceleratorResult(GetCustomRoutingAcceleratorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCustomRoutingAcceleratorResult(
            arn=self.arn,
            attributes=self.attributes,
            dns_name=self.dns_name,
            enabled=self.enabled,
            hosted_zone_id=self.hosted_zone_id,
            id=self.id,
            ip_address_type=self.ip_address_type,
            ip_sets=self.ip_sets,
            name=self.name,
            tags=self.tags)


def get_custom_routing_accelerator(arn: Optional[str] = None,
                                   name: Optional[str] = None,
                                   tags: Optional[Mapping[str, str]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCustomRoutingAcceleratorResult:
    """
    Provides information about a Global Accelerator custom routing accelerator.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    config = pulumi.Config()
    accelerator_arn = config.get("acceleratorArn")
    if accelerator_arn is None:
        accelerator_arn = ""
    accelerator_name = config.get("acceleratorName")
    if accelerator_name is None:
        accelerator_name = ""
    example = aws.globalaccelerator.get_custom_routing_accelerator(arn=accelerator_arn,
        name=accelerator_name)
    ```


    :param str arn: Full ARN of the custom routing accelerator.
    :param str name: Unique name of the custom routing accelerator.
           
           > **NOTE:** When both `arn` and `name` are specified, `arn` takes precedence.
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['name'] = name
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:globalaccelerator/getCustomRoutingAccelerator:getCustomRoutingAccelerator', __args__, opts=opts, typ=GetCustomRoutingAcceleratorResult).value

    return AwaitableGetCustomRoutingAcceleratorResult(
        arn=pulumi.get(__ret__, 'arn'),
        attributes=pulumi.get(__ret__, 'attributes'),
        dns_name=pulumi.get(__ret__, 'dns_name'),
        enabled=pulumi.get(__ret__, 'enabled'),
        hosted_zone_id=pulumi.get(__ret__, 'hosted_zone_id'),
        id=pulumi.get(__ret__, 'id'),
        ip_address_type=pulumi.get(__ret__, 'ip_address_type'),
        ip_sets=pulumi.get(__ret__, 'ip_sets'),
        name=pulumi.get(__ret__, 'name'),
        tags=pulumi.get(__ret__, 'tags'))


@_utilities.lift_output_func(get_custom_routing_accelerator)
def get_custom_routing_accelerator_output(arn: Optional[pulumi.Input[Optional[str]]] = None,
                                          name: Optional[pulumi.Input[Optional[str]]] = None,
                                          tags: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCustomRoutingAcceleratorResult]:
    """
    Provides information about a Global Accelerator custom routing accelerator.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    config = pulumi.Config()
    accelerator_arn = config.get("acceleratorArn")
    if accelerator_arn is None:
        accelerator_arn = ""
    accelerator_name = config.get("acceleratorName")
    if accelerator_name is None:
        accelerator_name = ""
    example = aws.globalaccelerator.get_custom_routing_accelerator(arn=accelerator_arn,
        name=accelerator_name)
    ```


    :param str arn: Full ARN of the custom routing accelerator.
    :param str name: Unique name of the custom routing accelerator.
           
           > **NOTE:** When both `arn` and `name` are specified, `arn` takes precedence.
    """
    ...
