# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPrincipalPolicySimulationResult',
    'AwaitableGetPrincipalPolicySimulationResult',
    'get_principal_policy_simulation',
    'get_principal_policy_simulation_output',
]

@pulumi.output_type
class GetPrincipalPolicySimulationResult:
    """
    A collection of values returned by getPrincipalPolicySimulation.
    """
    def __init__(__self__, action_names=None, additional_policies_jsons=None, all_allowed=None, caller_arn=None, contexts=None, id=None, permissions_boundary_policies_jsons=None, policy_source_arn=None, resource_arns=None, resource_handling_option=None, resource_owner_account_id=None, resource_policy_json=None, results=None):
        if action_names and not isinstance(action_names, list):
            raise TypeError("Expected argument 'action_names' to be a list")
        pulumi.set(__self__, "action_names", action_names)
        if additional_policies_jsons and not isinstance(additional_policies_jsons, list):
            raise TypeError("Expected argument 'additional_policies_jsons' to be a list")
        pulumi.set(__self__, "additional_policies_jsons", additional_policies_jsons)
        if all_allowed and not isinstance(all_allowed, bool):
            raise TypeError("Expected argument 'all_allowed' to be a bool")
        pulumi.set(__self__, "all_allowed", all_allowed)
        if caller_arn and not isinstance(caller_arn, str):
            raise TypeError("Expected argument 'caller_arn' to be a str")
        pulumi.set(__self__, "caller_arn", caller_arn)
        if contexts and not isinstance(contexts, list):
            raise TypeError("Expected argument 'contexts' to be a list")
        pulumi.set(__self__, "contexts", contexts)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if permissions_boundary_policies_jsons and not isinstance(permissions_boundary_policies_jsons, list):
            raise TypeError("Expected argument 'permissions_boundary_policies_jsons' to be a list")
        pulumi.set(__self__, "permissions_boundary_policies_jsons", permissions_boundary_policies_jsons)
        if policy_source_arn and not isinstance(policy_source_arn, str):
            raise TypeError("Expected argument 'policy_source_arn' to be a str")
        pulumi.set(__self__, "policy_source_arn", policy_source_arn)
        if resource_arns and not isinstance(resource_arns, list):
            raise TypeError("Expected argument 'resource_arns' to be a list")
        pulumi.set(__self__, "resource_arns", resource_arns)
        if resource_handling_option and not isinstance(resource_handling_option, str):
            raise TypeError("Expected argument 'resource_handling_option' to be a str")
        pulumi.set(__self__, "resource_handling_option", resource_handling_option)
        if resource_owner_account_id and not isinstance(resource_owner_account_id, str):
            raise TypeError("Expected argument 'resource_owner_account_id' to be a str")
        pulumi.set(__self__, "resource_owner_account_id", resource_owner_account_id)
        if resource_policy_json and not isinstance(resource_policy_json, str):
            raise TypeError("Expected argument 'resource_policy_json' to be a str")
        pulumi.set(__self__, "resource_policy_json", resource_policy_json)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)

    @property
    @pulumi.getter(name="actionNames")
    def action_names(self) -> Sequence[str]:
        return pulumi.get(self, "action_names")

    @property
    @pulumi.getter(name="additionalPoliciesJsons")
    def additional_policies_jsons(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "additional_policies_jsons")

    @property
    @pulumi.getter(name="allAllowed")
    def all_allowed(self) -> bool:
        """
        `true` if all of the simulation results have decision "allowed", or `false` otherwise.
        """
        return pulumi.get(self, "all_allowed")

    @property
    @pulumi.getter(name="callerArn")
    def caller_arn(self) -> Optional[str]:
        return pulumi.get(self, "caller_arn")

    @property
    @pulumi.getter
    def contexts(self) -> Optional[Sequence['outputs.GetPrincipalPolicySimulationContextResult']]:
        return pulumi.get(self, "contexts")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="permissionsBoundaryPoliciesJsons")
    def permissions_boundary_policies_jsons(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "permissions_boundary_policies_jsons")

    @property
    @pulumi.getter(name="policySourceArn")
    def policy_source_arn(self) -> str:
        return pulumi.get(self, "policy_source_arn")

    @property
    @pulumi.getter(name="resourceArns")
    def resource_arns(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "resource_arns")

    @property
    @pulumi.getter(name="resourceHandlingOption")
    def resource_handling_option(self) -> Optional[str]:
        return pulumi.get(self, "resource_handling_option")

    @property
    @pulumi.getter(name="resourceOwnerAccountId")
    def resource_owner_account_id(self) -> Optional[str]:
        return pulumi.get(self, "resource_owner_account_id")

    @property
    @pulumi.getter(name="resourcePolicyJson")
    def resource_policy_json(self) -> Optional[str]:
        return pulumi.get(self, "resource_policy_json")

    @property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetPrincipalPolicySimulationResultResult']:
        """
        A set of result objects, one for each of the simulated requests, with the following nested attributes:
        """
        return pulumi.get(self, "results")


class AwaitableGetPrincipalPolicySimulationResult(GetPrincipalPolicySimulationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPrincipalPolicySimulationResult(
            action_names=self.action_names,
            additional_policies_jsons=self.additional_policies_jsons,
            all_allowed=self.all_allowed,
            caller_arn=self.caller_arn,
            contexts=self.contexts,
            id=self.id,
            permissions_boundary_policies_jsons=self.permissions_boundary_policies_jsons,
            policy_source_arn=self.policy_source_arn,
            resource_arns=self.resource_arns,
            resource_handling_option=self.resource_handling_option,
            resource_owner_account_id=self.resource_owner_account_id,
            resource_policy_json=self.resource_policy_json,
            results=self.results)


def get_principal_policy_simulation(action_names: Optional[Sequence[str]] = None,
                                    additional_policies_jsons: Optional[Sequence[str]] = None,
                                    caller_arn: Optional[str] = None,
                                    contexts: Optional[Sequence[pulumi.InputType['GetPrincipalPolicySimulationContextArgs']]] = None,
                                    permissions_boundary_policies_jsons: Optional[Sequence[str]] = None,
                                    policy_source_arn: Optional[str] = None,
                                    resource_arns: Optional[Sequence[str]] = None,
                                    resource_handling_option: Optional[str] = None,
                                    resource_owner_account_id: Optional[str] = None,
                                    resource_policy_json: Optional[str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPrincipalPolicySimulationResult:
    """
    Runs a simulation of the IAM policies of a particular principal against a given hypothetical request.

    You can use this data source in conjunction with
    Preconditions and Postconditions so that your configuration can test either whether it should have sufficient access to do its own work, or whether policies your configuration declares itself are sufficient for their intended use elsewhere.

    > **Note:** Correctly using this data source requires familiarity with various details of AWS Identity and Access Management, and how various AWS services integrate with it. For general information on the AWS IAM policy simulator, see [Testing IAM policies with the IAM policy simulator](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_testing-policies.html). This data source wraps the `iam:SimulatePrincipalPolicy` API action described on that page.

    ## Example Usage


    :param Sequence[str] action_names: A set of IAM action names to run simulations for. Each entry in this set adds an additional hypothetical request to the simulation.
           
           Action names consist of a service prefix and an action verb separated by a colon, such as `s3:GetObject`. Refer to [Actions, resources, and condition keys for AWS services](https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html) to see the full set of possible IAM action names across all AWS services.
    :param Sequence[str] additional_policies_jsons: A set of additional principal policy documents to include in the simulation. The simulator will behave as if each of these policies were associated with the object specified in `policy_source_arn`, allowing you to test the effect of hypothetical policies not yet created.
    :param str caller_arn: The ARN of an user that will appear as the "caller" of the simulated requests. If you do not specify `caller_arn` then the simulation will use the `policy_source_arn` instead, if it contains a user ARN.
    :param Sequence[pulumi.InputType['GetPrincipalPolicySimulationContextArgs']] contexts: Each `context` block defines an entry in the table of additional context keys in the simulated request.
           
           IAM uses context keys for both custom conditions and for interpolating dynamic request-specific values into policy values. If you use policies that include those features then you will need to provide suitable example values for those keys to achieve a realistic simulation.
    :param Sequence[str] permissions_boundary_policies_jsons: A set of [permissions boundary policy documents](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html) to include in the simulation.
    :param str policy_source_arn: The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the IAM user, group, or role whose policies will be included in the simulation.
           
           You must closely match the form of the real service request you are simulating in order to achieve a realistic result. You can use the following additional arguments to specify other characteristics of the simulated requests:
    :param Sequence[str] resource_arns: A set of ARNs of resources to include in the simulation.
           
           This argument is important for actions that have either required or optional resource types listed in [Actions, resources, and condition keys for AWS services](https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html), and you must provide ARNs that identify AWS objects of the appropriate types for the chosen actions.
           
           The policy simulator only automatically loads policies associated with the `policy_source_arn`, so if your given resources have their own resource-level policy then you'll also need to provide that explicitly using the `resource_policy_json` argument to achieve a realistic simulation.
    :param str resource_handling_option: Specifies a special simulation type to run. Some EC2 actions require special simulation behaviors and a particular set of resource ARNs to achieve a realistic result.
           
           For more details, see the `ResourceHandlingOption` request parameter for [the underlying `iam:SimulatePrincipalPolicy` action](https://docs.aws.amazon.com/IAM/latest/APIReference/API_SimulatePrincipalPolicy.html).
    :param str resource_owner_account_id: An AWS account ID to use for any resource ARN in `resource_arns` that doesn't include its own AWS account ID. If unspecified, the simulator will use the account ID from the `caller_arn` argument as a placeholder.
    :param str resource_policy_json: An IAM policy document representing the resource-level policy of all of the resources specified in `resource_arns`.
           
           The policy simulator cannot automatically load policies that are associated with individual resources, as described in the documentation for `resource_arns` above.
    """
    __args__ = dict()
    __args__['actionNames'] = action_names
    __args__['additionalPoliciesJsons'] = additional_policies_jsons
    __args__['callerArn'] = caller_arn
    __args__['contexts'] = contexts
    __args__['permissionsBoundaryPoliciesJsons'] = permissions_boundary_policies_jsons
    __args__['policySourceArn'] = policy_source_arn
    __args__['resourceArns'] = resource_arns
    __args__['resourceHandlingOption'] = resource_handling_option
    __args__['resourceOwnerAccountId'] = resource_owner_account_id
    __args__['resourcePolicyJson'] = resource_policy_json
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:iam/getPrincipalPolicySimulation:getPrincipalPolicySimulation', __args__, opts=opts, typ=GetPrincipalPolicySimulationResult).value

    return AwaitableGetPrincipalPolicySimulationResult(
        action_names=pulumi.get(__ret__, 'action_names'),
        additional_policies_jsons=pulumi.get(__ret__, 'additional_policies_jsons'),
        all_allowed=pulumi.get(__ret__, 'all_allowed'),
        caller_arn=pulumi.get(__ret__, 'caller_arn'),
        contexts=pulumi.get(__ret__, 'contexts'),
        id=pulumi.get(__ret__, 'id'),
        permissions_boundary_policies_jsons=pulumi.get(__ret__, 'permissions_boundary_policies_jsons'),
        policy_source_arn=pulumi.get(__ret__, 'policy_source_arn'),
        resource_arns=pulumi.get(__ret__, 'resource_arns'),
        resource_handling_option=pulumi.get(__ret__, 'resource_handling_option'),
        resource_owner_account_id=pulumi.get(__ret__, 'resource_owner_account_id'),
        resource_policy_json=pulumi.get(__ret__, 'resource_policy_json'),
        results=pulumi.get(__ret__, 'results'))


@_utilities.lift_output_func(get_principal_policy_simulation)
def get_principal_policy_simulation_output(action_names: Optional[pulumi.Input[Sequence[str]]] = None,
                                           additional_policies_jsons: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                           caller_arn: Optional[pulumi.Input[Optional[str]]] = None,
                                           contexts: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetPrincipalPolicySimulationContextArgs']]]]] = None,
                                           permissions_boundary_policies_jsons: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                           policy_source_arn: Optional[pulumi.Input[str]] = None,
                                           resource_arns: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                           resource_handling_option: Optional[pulumi.Input[Optional[str]]] = None,
                                           resource_owner_account_id: Optional[pulumi.Input[Optional[str]]] = None,
                                           resource_policy_json: Optional[pulumi.Input[Optional[str]]] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPrincipalPolicySimulationResult]:
    """
    Runs a simulation of the IAM policies of a particular principal against a given hypothetical request.

    You can use this data source in conjunction with
    Preconditions and Postconditions so that your configuration can test either whether it should have sufficient access to do its own work, or whether policies your configuration declares itself are sufficient for their intended use elsewhere.

    > **Note:** Correctly using this data source requires familiarity with various details of AWS Identity and Access Management, and how various AWS services integrate with it. For general information on the AWS IAM policy simulator, see [Testing IAM policies with the IAM policy simulator](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_testing-policies.html). This data source wraps the `iam:SimulatePrincipalPolicy` API action described on that page.

    ## Example Usage


    :param Sequence[str] action_names: A set of IAM action names to run simulations for. Each entry in this set adds an additional hypothetical request to the simulation.
           
           Action names consist of a service prefix and an action verb separated by a colon, such as `s3:GetObject`. Refer to [Actions, resources, and condition keys for AWS services](https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html) to see the full set of possible IAM action names across all AWS services.
    :param Sequence[str] additional_policies_jsons: A set of additional principal policy documents to include in the simulation. The simulator will behave as if each of these policies were associated with the object specified in `policy_source_arn`, allowing you to test the effect of hypothetical policies not yet created.
    :param str caller_arn: The ARN of an user that will appear as the "caller" of the simulated requests. If you do not specify `caller_arn` then the simulation will use the `policy_source_arn` instead, if it contains a user ARN.
    :param Sequence[pulumi.InputType['GetPrincipalPolicySimulationContextArgs']] contexts: Each `context` block defines an entry in the table of additional context keys in the simulated request.
           
           IAM uses context keys for both custom conditions and for interpolating dynamic request-specific values into policy values. If you use policies that include those features then you will need to provide suitable example values for those keys to achieve a realistic simulation.
    :param Sequence[str] permissions_boundary_policies_jsons: A set of [permissions boundary policy documents](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html) to include in the simulation.
    :param str policy_source_arn: The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the IAM user, group, or role whose policies will be included in the simulation.
           
           You must closely match the form of the real service request you are simulating in order to achieve a realistic result. You can use the following additional arguments to specify other characteristics of the simulated requests:
    :param Sequence[str] resource_arns: A set of ARNs of resources to include in the simulation.
           
           This argument is important for actions that have either required or optional resource types listed in [Actions, resources, and condition keys for AWS services](https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html), and you must provide ARNs that identify AWS objects of the appropriate types for the chosen actions.
           
           The policy simulator only automatically loads policies associated with the `policy_source_arn`, so if your given resources have their own resource-level policy then you'll also need to provide that explicitly using the `resource_policy_json` argument to achieve a realistic simulation.
    :param str resource_handling_option: Specifies a special simulation type to run. Some EC2 actions require special simulation behaviors and a particular set of resource ARNs to achieve a realistic result.
           
           For more details, see the `ResourceHandlingOption` request parameter for [the underlying `iam:SimulatePrincipalPolicy` action](https://docs.aws.amazon.com/IAM/latest/APIReference/API_SimulatePrincipalPolicy.html).
    :param str resource_owner_account_id: An AWS account ID to use for any resource ARN in `resource_arns` that doesn't include its own AWS account ID. If unspecified, the simulator will use the account ID from the `caller_arn` argument as a placeholder.
    :param str resource_policy_json: An IAM policy document representing the resource-level policy of all of the resources specified in `resource_arns`.
           
           The policy simulator cannot automatically load policies that are associated with individual resources, as described in the documentation for `resource_arns` above.
    """
    ...
