# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['CertificateArgs', 'Certificate']

@pulumi.input_type
class CertificateArgs:
    def __init__(__self__, *,
                 active: pulumi.Input[bool],
                 ca_pem: Optional[pulumi.Input[str]] = None,
                 certificate_pem: Optional[pulumi.Input[str]] = None,
                 csr: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Certificate resource.
        :param pulumi.Input[bool] active: Boolean flag to indicate if the certificate should be active
        :param pulumi.Input[str] ca_pem: The CA certificate for the certificate to be registered. If this is set, the CA needs to be registered with AWS IoT beforehand.
        :param pulumi.Input[str] certificate_pem: The certificate to be registered. If `ca_pem` is unspecified, review
               [RegisterCertificateWithoutCA](https://docs.aws.amazon.com/iot/latest/apireference/API_RegisterCertificateWithoutCA.html).
               If `ca_pem` is specified, review
               [RegisterCertificate](https://docs.aws.amazon.com/iot/latest/apireference/API_RegisterCertificate.html)
               for more information on registering a certificate.
        :param pulumi.Input[str] csr: The certificate signing request. Review
               [CreateCertificateFromCsr](https://docs.aws.amazon.com/iot/latest/apireference/API_CreateCertificateFromCsr.html)
               for more information on generating a certificate from a certificate signing request (CSR).
               If none is specified both the certificate and keys will be generated, review [CreateKeysAndCertificate](https://docs.aws.amazon.com/iot/latest/apireference/API_CreateKeysAndCertificate.html)
               for more information on generating keys and a certificate.
        """
        pulumi.set(__self__, "active", active)
        if ca_pem is not None:
            pulumi.set(__self__, "ca_pem", ca_pem)
        if certificate_pem is not None:
            pulumi.set(__self__, "certificate_pem", certificate_pem)
        if csr is not None:
            pulumi.set(__self__, "csr", csr)

    @property
    @pulumi.getter
    def active(self) -> pulumi.Input[bool]:
        """
        Boolean flag to indicate if the certificate should be active
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: pulumi.Input[bool]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter(name="caPem")
    def ca_pem(self) -> Optional[pulumi.Input[str]]:
        """
        The CA certificate for the certificate to be registered. If this is set, the CA needs to be registered with AWS IoT beforehand.
        """
        return pulumi.get(self, "ca_pem")

    @ca_pem.setter
    def ca_pem(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_pem", value)

    @property
    @pulumi.getter(name="certificatePem")
    def certificate_pem(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate to be registered. If `ca_pem` is unspecified, review
        [RegisterCertificateWithoutCA](https://docs.aws.amazon.com/iot/latest/apireference/API_RegisterCertificateWithoutCA.html).
        If `ca_pem` is specified, review
        [RegisterCertificate](https://docs.aws.amazon.com/iot/latest/apireference/API_RegisterCertificate.html)
        for more information on registering a certificate.
        """
        return pulumi.get(self, "certificate_pem")

    @certificate_pem.setter
    def certificate_pem(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_pem", value)

    @property
    @pulumi.getter
    def csr(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate signing request. Review
        [CreateCertificateFromCsr](https://docs.aws.amazon.com/iot/latest/apireference/API_CreateCertificateFromCsr.html)
        for more information on generating a certificate from a certificate signing request (CSR).
        If none is specified both the certificate and keys will be generated, review [CreateKeysAndCertificate](https://docs.aws.amazon.com/iot/latest/apireference/API_CreateKeysAndCertificate.html)
        for more information on generating keys and a certificate.
        """
        return pulumi.get(self, "csr")

    @csr.setter
    def csr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "csr", value)


@pulumi.input_type
class _CertificateState:
    def __init__(__self__, *,
                 active: Optional[pulumi.Input[bool]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 ca_pem: Optional[pulumi.Input[str]] = None,
                 certificate_pem: Optional[pulumi.Input[str]] = None,
                 csr: Optional[pulumi.Input[str]] = None,
                 private_key: Optional[pulumi.Input[str]] = None,
                 public_key: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Certificate resources.
        :param pulumi.Input[bool] active: Boolean flag to indicate if the certificate should be active
        :param pulumi.Input[str] arn: The ARN of the created certificate.
        :param pulumi.Input[str] ca_pem: The CA certificate for the certificate to be registered. If this is set, the CA needs to be registered with AWS IoT beforehand.
        :param pulumi.Input[str] certificate_pem: The certificate to be registered. If `ca_pem` is unspecified, review
               [RegisterCertificateWithoutCA](https://docs.aws.amazon.com/iot/latest/apireference/API_RegisterCertificateWithoutCA.html).
               If `ca_pem` is specified, review
               [RegisterCertificate](https://docs.aws.amazon.com/iot/latest/apireference/API_RegisterCertificate.html)
               for more information on registering a certificate.
        :param pulumi.Input[str] csr: The certificate signing request. Review
               [CreateCertificateFromCsr](https://docs.aws.amazon.com/iot/latest/apireference/API_CreateCertificateFromCsr.html)
               for more information on generating a certificate from a certificate signing request (CSR).
               If none is specified both the certificate and keys will be generated, review [CreateKeysAndCertificate](https://docs.aws.amazon.com/iot/latest/apireference/API_CreateKeysAndCertificate.html)
               for more information on generating keys and a certificate.
        :param pulumi.Input[str] private_key: When neither CSR nor certificate is provided, the private key.
        :param pulumi.Input[str] public_key: When neither CSR nor certificate is provided, the public key.
        """
        if active is not None:
            pulumi.set(__self__, "active", active)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if ca_pem is not None:
            pulumi.set(__self__, "ca_pem", ca_pem)
        if certificate_pem is not None:
            pulumi.set(__self__, "certificate_pem", certificate_pem)
        if csr is not None:
            pulumi.set(__self__, "csr", csr)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean flag to indicate if the certificate should be active
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the created certificate.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="caPem")
    def ca_pem(self) -> Optional[pulumi.Input[str]]:
        """
        The CA certificate for the certificate to be registered. If this is set, the CA needs to be registered with AWS IoT beforehand.
        """
        return pulumi.get(self, "ca_pem")

    @ca_pem.setter
    def ca_pem(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_pem", value)

    @property
    @pulumi.getter(name="certificatePem")
    def certificate_pem(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate to be registered. If `ca_pem` is unspecified, review
        [RegisterCertificateWithoutCA](https://docs.aws.amazon.com/iot/latest/apireference/API_RegisterCertificateWithoutCA.html).
        If `ca_pem` is specified, review
        [RegisterCertificate](https://docs.aws.amazon.com/iot/latest/apireference/API_RegisterCertificate.html)
        for more information on registering a certificate.
        """
        return pulumi.get(self, "certificate_pem")

    @certificate_pem.setter
    def certificate_pem(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_pem", value)

    @property
    @pulumi.getter
    def csr(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate signing request. Review
        [CreateCertificateFromCsr](https://docs.aws.amazon.com/iot/latest/apireference/API_CreateCertificateFromCsr.html)
        for more information on generating a certificate from a certificate signing request (CSR).
        If none is specified both the certificate and keys will be generated, review [CreateKeysAndCertificate](https://docs.aws.amazon.com/iot/latest/apireference/API_CreateKeysAndCertificate.html)
        for more information on generating keys and a certificate.
        """
        return pulumi.get(self, "csr")

    @csr.setter
    def csr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "csr", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[str]]:
        """
        When neither CSR nor certificate is provided, the private key.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[str]]:
        """
        When neither CSR nor certificate is provided, the public key.
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key", value)


class Certificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[bool]] = None,
                 ca_pem: Optional[pulumi.Input[str]] = None,
                 certificate_pem: Optional[pulumi.Input[str]] = None,
                 csr: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates and manages an AWS IoT certificate.

        ## Example Usage
        ### With CSR

        ```python
        import pulumi
        import pulumi_aws as aws

        cert = aws.iot.Certificate("cert",
            csr=(lambda path: open(path).read())("/my/csr.pem"),
            active=True)
        ```
        ### Without CSR

        ```python
        import pulumi
        import pulumi_aws as aws

        cert = aws.iot.Certificate("cert", active=True)
        ```
        ### From existing certificate without a CA

        ```python
        import pulumi
        import pulumi_aws as aws

        cert = aws.iot.Certificate("cert",
            certificate_pem=(lambda path: open(path).read())("/my/cert.pem"),
            active=True)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] active: Boolean flag to indicate if the certificate should be active
        :param pulumi.Input[str] ca_pem: The CA certificate for the certificate to be registered. If this is set, the CA needs to be registered with AWS IoT beforehand.
        :param pulumi.Input[str] certificate_pem: The certificate to be registered. If `ca_pem` is unspecified, review
               [RegisterCertificateWithoutCA](https://docs.aws.amazon.com/iot/latest/apireference/API_RegisterCertificateWithoutCA.html).
               If `ca_pem` is specified, review
               [RegisterCertificate](https://docs.aws.amazon.com/iot/latest/apireference/API_RegisterCertificate.html)
               for more information on registering a certificate.
        :param pulumi.Input[str] csr: The certificate signing request. Review
               [CreateCertificateFromCsr](https://docs.aws.amazon.com/iot/latest/apireference/API_CreateCertificateFromCsr.html)
               for more information on generating a certificate from a certificate signing request (CSR).
               If none is specified both the certificate and keys will be generated, review [CreateKeysAndCertificate](https://docs.aws.amazon.com/iot/latest/apireference/API_CreateKeysAndCertificate.html)
               for more information on generating keys and a certificate.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages an AWS IoT certificate.

        ## Example Usage
        ### With CSR

        ```python
        import pulumi
        import pulumi_aws as aws

        cert = aws.iot.Certificate("cert",
            csr=(lambda path: open(path).read())("/my/csr.pem"),
            active=True)
        ```
        ### Without CSR

        ```python
        import pulumi
        import pulumi_aws as aws

        cert = aws.iot.Certificate("cert", active=True)
        ```
        ### From existing certificate without a CA

        ```python
        import pulumi
        import pulumi_aws as aws

        cert = aws.iot.Certificate("cert",
            certificate_pem=(lambda path: open(path).read())("/my/cert.pem"),
            active=True)
        ```

        :param str resource_name: The name of the resource.
        :param CertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[bool]] = None,
                 ca_pem: Optional[pulumi.Input[str]] = None,
                 certificate_pem: Optional[pulumi.Input[str]] = None,
                 csr: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CertificateArgs.__new__(CertificateArgs)

            if active is None and not opts.urn:
                raise TypeError("Missing required property 'active'")
            __props__.__dict__["active"] = active
            __props__.__dict__["ca_pem"] = None if ca_pem is None else pulumi.Output.secret(ca_pem)
            __props__.__dict__["certificate_pem"] = None if certificate_pem is None else pulumi.Output.secret(certificate_pem)
            __props__.__dict__["csr"] = csr
            __props__.__dict__["arn"] = None
            __props__.__dict__["private_key"] = None
            __props__.__dict__["public_key"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["caPem", "certificatePem", "privateKey", "publicKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Certificate, __self__).__init__(
            'aws:iot/certificate:Certificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active: Optional[pulumi.Input[bool]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            ca_pem: Optional[pulumi.Input[str]] = None,
            certificate_pem: Optional[pulumi.Input[str]] = None,
            csr: Optional[pulumi.Input[str]] = None,
            private_key: Optional[pulumi.Input[str]] = None,
            public_key: Optional[pulumi.Input[str]] = None) -> 'Certificate':
        """
        Get an existing Certificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] active: Boolean flag to indicate if the certificate should be active
        :param pulumi.Input[str] arn: The ARN of the created certificate.
        :param pulumi.Input[str] ca_pem: The CA certificate for the certificate to be registered. If this is set, the CA needs to be registered with AWS IoT beforehand.
        :param pulumi.Input[str] certificate_pem: The certificate to be registered. If `ca_pem` is unspecified, review
               [RegisterCertificateWithoutCA](https://docs.aws.amazon.com/iot/latest/apireference/API_RegisterCertificateWithoutCA.html).
               If `ca_pem` is specified, review
               [RegisterCertificate](https://docs.aws.amazon.com/iot/latest/apireference/API_RegisterCertificate.html)
               for more information on registering a certificate.
        :param pulumi.Input[str] csr: The certificate signing request. Review
               [CreateCertificateFromCsr](https://docs.aws.amazon.com/iot/latest/apireference/API_CreateCertificateFromCsr.html)
               for more information on generating a certificate from a certificate signing request (CSR).
               If none is specified both the certificate and keys will be generated, review [CreateKeysAndCertificate](https://docs.aws.amazon.com/iot/latest/apireference/API_CreateKeysAndCertificate.html)
               for more information on generating keys and a certificate.
        :param pulumi.Input[str] private_key: When neither CSR nor certificate is provided, the private key.
        :param pulumi.Input[str] public_key: When neither CSR nor certificate is provided, the public key.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CertificateState.__new__(_CertificateState)

        __props__.__dict__["active"] = active
        __props__.__dict__["arn"] = arn
        __props__.__dict__["ca_pem"] = ca_pem
        __props__.__dict__["certificate_pem"] = certificate_pem
        __props__.__dict__["csr"] = csr
        __props__.__dict__["private_key"] = private_key
        __props__.__dict__["public_key"] = public_key
        return Certificate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def active(self) -> pulumi.Output[bool]:
        """
        Boolean flag to indicate if the certificate should be active
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the created certificate.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="caPem")
    def ca_pem(self) -> pulumi.Output[Optional[str]]:
        """
        The CA certificate for the certificate to be registered. If this is set, the CA needs to be registered with AWS IoT beforehand.
        """
        return pulumi.get(self, "ca_pem")

    @property
    @pulumi.getter(name="certificatePem")
    def certificate_pem(self) -> pulumi.Output[str]:
        """
        The certificate to be registered. If `ca_pem` is unspecified, review
        [RegisterCertificateWithoutCA](https://docs.aws.amazon.com/iot/latest/apireference/API_RegisterCertificateWithoutCA.html).
        If `ca_pem` is specified, review
        [RegisterCertificate](https://docs.aws.amazon.com/iot/latest/apireference/API_RegisterCertificate.html)
        for more information on registering a certificate.
        """
        return pulumi.get(self, "certificate_pem")

    @property
    @pulumi.getter
    def csr(self) -> pulumi.Output[Optional[str]]:
        """
        The certificate signing request. Review
        [CreateCertificateFromCsr](https://docs.aws.amazon.com/iot/latest/apireference/API_CreateCertificateFromCsr.html)
        for more information on generating a certificate from a certificate signing request (CSR).
        If none is specified both the certificate and keys will be generated, review [CreateKeysAndCertificate](https://docs.aws.amazon.com/iot/latest/apireference/API_CreateKeysAndCertificate.html)
        for more information on generating keys and a certificate.
        """
        return pulumi.get(self, "csr")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[str]:
        """
        When neither CSR nor certificate is provided, the private key.
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> pulumi.Output[str]:
        """
        When neither CSR nor certificate is provided, the public key.
        """
        return pulumi.get(self, "public_key")

