# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TopicRuleArgs', 'TopicRule']

@pulumi.input_type
class TopicRuleArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 sql: pulumi.Input[str],
                 sql_version: pulumi.Input[str],
                 cloudwatch_alarms: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleCloudwatchAlarmArgs']]]] = None,
                 cloudwatch_logs: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleCloudwatchLogArgs']]]] = None,
                 cloudwatch_metrics: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleCloudwatchMetricArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dynamodbs: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleDynamodbArgs']]]] = None,
                 dynamodbv2s: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleDynamodbv2Args']]]] = None,
                 elasticsearch: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleElasticsearchArgs']]]] = None,
                 error_action: Optional[pulumi.Input['TopicRuleErrorActionArgs']] = None,
                 firehoses: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleFirehoseArgs']]]] = None,
                 https: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleHttpArgs']]]] = None,
                 iot_analytics: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleIotAnalyticArgs']]]] = None,
                 iot_events: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleIotEventArgs']]]] = None,
                 kafkas: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleKafkaArgs']]]] = None,
                 kineses: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleKinesisArgs']]]] = None,
                 lambdas: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleLambdaArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 republishes: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleRepublishArgs']]]] = None,
                 s3: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleS3Args']]]] = None,
                 sns: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleSnsArgs']]]] = None,
                 sqs: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleSqsArgs']]]] = None,
                 step_functions: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleStepFunctionArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timestreams: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleTimestreamArgs']]]] = None):
        """
        The set of arguments for constructing a TopicRule resource.
        :param pulumi.Input[bool] enabled: Specifies whether the rule is enabled.
        :param pulumi.Input[str] sql: The SQL statement used to query the topic. For more information, see AWS IoT SQL Reference (http://docs.aws.amazon.com/iot/latest/developerguide/iot-rules.html#aws-iot-sql-reference) in the AWS IoT Developer Guide.
        :param pulumi.Input[str] sql_version: The version of the SQL rules engine to use when evaluating the rule.
        :param pulumi.Input[str] description: The description of the rule.
        :param pulumi.Input['TopicRuleErrorActionArgs'] error_action: Configuration block with error action to be associated with the rule. See the documentation for `cloudwatch_alarm`, `cloudwatch_logs`, `cloudwatch_metric`, `dynamodb`, `dynamodbv2`, `elasticsearch`, `firehose`, `http`, `iot_analytics`, `iot_events`, `kafka`, `kinesis`, `lambda`, `republish`, `s3`, `sns`, `sqs`, `step_functions`, `timestream` configuration blocks for further configuration details.
        :param pulumi.Input[str] name: The name of the rule.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "sql", sql)
        pulumi.set(__self__, "sql_version", sql_version)
        if cloudwatch_alarms is not None:
            pulumi.set(__self__, "cloudwatch_alarms", cloudwatch_alarms)
        if cloudwatch_logs is not None:
            pulumi.set(__self__, "cloudwatch_logs", cloudwatch_logs)
        if cloudwatch_metrics is not None:
            pulumi.set(__self__, "cloudwatch_metrics", cloudwatch_metrics)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dynamodbs is not None:
            pulumi.set(__self__, "dynamodbs", dynamodbs)
        if dynamodbv2s is not None:
            pulumi.set(__self__, "dynamodbv2s", dynamodbv2s)
        if elasticsearch is not None:
            pulumi.set(__self__, "elasticsearch", elasticsearch)
        if error_action is not None:
            pulumi.set(__self__, "error_action", error_action)
        if firehoses is not None:
            pulumi.set(__self__, "firehoses", firehoses)
        if https is not None:
            pulumi.set(__self__, "https", https)
        if iot_analytics is not None:
            pulumi.set(__self__, "iot_analytics", iot_analytics)
        if iot_events is not None:
            pulumi.set(__self__, "iot_events", iot_events)
        if kafkas is not None:
            pulumi.set(__self__, "kafkas", kafkas)
        if kineses is not None:
            pulumi.set(__self__, "kineses", kineses)
        if lambdas is not None:
            pulumi.set(__self__, "lambdas", lambdas)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if republishes is not None:
            pulumi.set(__self__, "republishes", republishes)
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)
        if sns is not None:
            pulumi.set(__self__, "sns", sns)
        if sqs is not None:
            pulumi.set(__self__, "sqs", sqs)
        if step_functions is not None:
            pulumi.set(__self__, "step_functions", step_functions)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timestreams is not None:
            pulumi.set(__self__, "timestreams", timestreams)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Specifies whether the rule is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def sql(self) -> pulumi.Input[str]:
        """
        The SQL statement used to query the topic. For more information, see AWS IoT SQL Reference (http://docs.aws.amazon.com/iot/latest/developerguide/iot-rules.html#aws-iot-sql-reference) in the AWS IoT Developer Guide.
        """
        return pulumi.get(self, "sql")

    @sql.setter
    def sql(self, value: pulumi.Input[str]):
        pulumi.set(self, "sql", value)

    @property
    @pulumi.getter(name="sqlVersion")
    def sql_version(self) -> pulumi.Input[str]:
        """
        The version of the SQL rules engine to use when evaluating the rule.
        """
        return pulumi.get(self, "sql_version")

    @sql_version.setter
    def sql_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "sql_version", value)

    @property
    @pulumi.getter(name="cloudwatchAlarms")
    def cloudwatch_alarms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleCloudwatchAlarmArgs']]]]:
        return pulumi.get(self, "cloudwatch_alarms")

    @cloudwatch_alarms.setter
    def cloudwatch_alarms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleCloudwatchAlarmArgs']]]]):
        pulumi.set(self, "cloudwatch_alarms", value)

    @property
    @pulumi.getter(name="cloudwatchLogs")
    def cloudwatch_logs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleCloudwatchLogArgs']]]]:
        return pulumi.get(self, "cloudwatch_logs")

    @cloudwatch_logs.setter
    def cloudwatch_logs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleCloudwatchLogArgs']]]]):
        pulumi.set(self, "cloudwatch_logs", value)

    @property
    @pulumi.getter(name="cloudwatchMetrics")
    def cloudwatch_metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleCloudwatchMetricArgs']]]]:
        return pulumi.get(self, "cloudwatch_metrics")

    @cloudwatch_metrics.setter
    def cloudwatch_metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleCloudwatchMetricArgs']]]]):
        pulumi.set(self, "cloudwatch_metrics", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def dynamodbs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleDynamodbArgs']]]]:
        return pulumi.get(self, "dynamodbs")

    @dynamodbs.setter
    def dynamodbs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleDynamodbArgs']]]]):
        pulumi.set(self, "dynamodbs", value)

    @property
    @pulumi.getter
    def dynamodbv2s(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleDynamodbv2Args']]]]:
        return pulumi.get(self, "dynamodbv2s")

    @dynamodbv2s.setter
    def dynamodbv2s(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleDynamodbv2Args']]]]):
        pulumi.set(self, "dynamodbv2s", value)

    @property
    @pulumi.getter
    def elasticsearch(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleElasticsearchArgs']]]]:
        return pulumi.get(self, "elasticsearch")

    @elasticsearch.setter
    def elasticsearch(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleElasticsearchArgs']]]]):
        pulumi.set(self, "elasticsearch", value)

    @property
    @pulumi.getter(name="errorAction")
    def error_action(self) -> Optional[pulumi.Input['TopicRuleErrorActionArgs']]:
        """
        Configuration block with error action to be associated with the rule. See the documentation for `cloudwatch_alarm`, `cloudwatch_logs`, `cloudwatch_metric`, `dynamodb`, `dynamodbv2`, `elasticsearch`, `firehose`, `http`, `iot_analytics`, `iot_events`, `kafka`, `kinesis`, `lambda`, `republish`, `s3`, `sns`, `sqs`, `step_functions`, `timestream` configuration blocks for further configuration details.
        """
        return pulumi.get(self, "error_action")

    @error_action.setter
    def error_action(self, value: Optional[pulumi.Input['TopicRuleErrorActionArgs']]):
        pulumi.set(self, "error_action", value)

    @property
    @pulumi.getter
    def firehoses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleFirehoseArgs']]]]:
        return pulumi.get(self, "firehoses")

    @firehoses.setter
    def firehoses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleFirehoseArgs']]]]):
        pulumi.set(self, "firehoses", value)

    @property
    @pulumi.getter
    def https(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleHttpArgs']]]]:
        return pulumi.get(self, "https")

    @https.setter
    def https(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleHttpArgs']]]]):
        pulumi.set(self, "https", value)

    @property
    @pulumi.getter(name="iotAnalytics")
    def iot_analytics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleIotAnalyticArgs']]]]:
        return pulumi.get(self, "iot_analytics")

    @iot_analytics.setter
    def iot_analytics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleIotAnalyticArgs']]]]):
        pulumi.set(self, "iot_analytics", value)

    @property
    @pulumi.getter(name="iotEvents")
    def iot_events(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleIotEventArgs']]]]:
        return pulumi.get(self, "iot_events")

    @iot_events.setter
    def iot_events(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleIotEventArgs']]]]):
        pulumi.set(self, "iot_events", value)

    @property
    @pulumi.getter
    def kafkas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleKafkaArgs']]]]:
        return pulumi.get(self, "kafkas")

    @kafkas.setter
    def kafkas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleKafkaArgs']]]]):
        pulumi.set(self, "kafkas", value)

    @property
    @pulumi.getter
    def kineses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleKinesisArgs']]]]:
        return pulumi.get(self, "kineses")

    @kineses.setter
    def kineses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleKinesisArgs']]]]):
        pulumi.set(self, "kineses", value)

    @property
    @pulumi.getter
    def lambdas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleLambdaArgs']]]]:
        return pulumi.get(self, "lambdas")

    @lambdas.setter
    def lambdas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleLambdaArgs']]]]):
        pulumi.set(self, "lambdas", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def republishes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleRepublishArgs']]]]:
        return pulumi.get(self, "republishes")

    @republishes.setter
    def republishes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleRepublishArgs']]]]):
        pulumi.set(self, "republishes", value)

    @property
    @pulumi.getter
    def s3(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleS3Args']]]]:
        return pulumi.get(self, "s3")

    @s3.setter
    def s3(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleS3Args']]]]):
        pulumi.set(self, "s3", value)

    @property
    @pulumi.getter
    def sns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleSnsArgs']]]]:
        return pulumi.get(self, "sns")

    @sns.setter
    def sns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleSnsArgs']]]]):
        pulumi.set(self, "sns", value)

    @property
    @pulumi.getter
    def sqs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleSqsArgs']]]]:
        return pulumi.get(self, "sqs")

    @sqs.setter
    def sqs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleSqsArgs']]]]):
        pulumi.set(self, "sqs", value)

    @property
    @pulumi.getter(name="stepFunctions")
    def step_functions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleStepFunctionArgs']]]]:
        return pulumi.get(self, "step_functions")

    @step_functions.setter
    def step_functions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleStepFunctionArgs']]]]):
        pulumi.set(self, "step_functions", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timestreams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleTimestreamArgs']]]]:
        return pulumi.get(self, "timestreams")

    @timestreams.setter
    def timestreams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleTimestreamArgs']]]]):
        pulumi.set(self, "timestreams", value)


@pulumi.input_type
class _TopicRuleState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 cloudwatch_alarms: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleCloudwatchAlarmArgs']]]] = None,
                 cloudwatch_logs: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleCloudwatchLogArgs']]]] = None,
                 cloudwatch_metrics: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleCloudwatchMetricArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dynamodbs: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleDynamodbArgs']]]] = None,
                 dynamodbv2s: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleDynamodbv2Args']]]] = None,
                 elasticsearch: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleElasticsearchArgs']]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 error_action: Optional[pulumi.Input['TopicRuleErrorActionArgs']] = None,
                 firehoses: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleFirehoseArgs']]]] = None,
                 https: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleHttpArgs']]]] = None,
                 iot_analytics: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleIotAnalyticArgs']]]] = None,
                 iot_events: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleIotEventArgs']]]] = None,
                 kafkas: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleKafkaArgs']]]] = None,
                 kineses: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleKinesisArgs']]]] = None,
                 lambdas: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleLambdaArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 republishes: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleRepublishArgs']]]] = None,
                 s3: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleS3Args']]]] = None,
                 sns: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleSnsArgs']]]] = None,
                 sql: Optional[pulumi.Input[str]] = None,
                 sql_version: Optional[pulumi.Input[str]] = None,
                 sqs: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleSqsArgs']]]] = None,
                 step_functions: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleStepFunctionArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timestreams: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleTimestreamArgs']]]] = None):
        """
        Input properties used for looking up and filtering TopicRule resources.
        :param pulumi.Input[str] arn: The ARN of the topic rule
        :param pulumi.Input[str] description: The description of the rule.
        :param pulumi.Input[bool] enabled: Specifies whether the rule is enabled.
        :param pulumi.Input['TopicRuleErrorActionArgs'] error_action: Configuration block with error action to be associated with the rule. See the documentation for `cloudwatch_alarm`, `cloudwatch_logs`, `cloudwatch_metric`, `dynamodb`, `dynamodbv2`, `elasticsearch`, `firehose`, `http`, `iot_analytics`, `iot_events`, `kafka`, `kinesis`, `lambda`, `republish`, `s3`, `sns`, `sqs`, `step_functions`, `timestream` configuration blocks for further configuration details.
        :param pulumi.Input[str] name: The name of the rule.
        :param pulumi.Input[str] sql: The SQL statement used to query the topic. For more information, see AWS IoT SQL Reference (http://docs.aws.amazon.com/iot/latest/developerguide/iot-rules.html#aws-iot-sql-reference) in the AWS IoT Developer Guide.
        :param pulumi.Input[str] sql_version: The version of the SQL rules engine to use when evaluating the rule.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if cloudwatch_alarms is not None:
            pulumi.set(__self__, "cloudwatch_alarms", cloudwatch_alarms)
        if cloudwatch_logs is not None:
            pulumi.set(__self__, "cloudwatch_logs", cloudwatch_logs)
        if cloudwatch_metrics is not None:
            pulumi.set(__self__, "cloudwatch_metrics", cloudwatch_metrics)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dynamodbs is not None:
            pulumi.set(__self__, "dynamodbs", dynamodbs)
        if dynamodbv2s is not None:
            pulumi.set(__self__, "dynamodbv2s", dynamodbv2s)
        if elasticsearch is not None:
            pulumi.set(__self__, "elasticsearch", elasticsearch)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if error_action is not None:
            pulumi.set(__self__, "error_action", error_action)
        if firehoses is not None:
            pulumi.set(__self__, "firehoses", firehoses)
        if https is not None:
            pulumi.set(__self__, "https", https)
        if iot_analytics is not None:
            pulumi.set(__self__, "iot_analytics", iot_analytics)
        if iot_events is not None:
            pulumi.set(__self__, "iot_events", iot_events)
        if kafkas is not None:
            pulumi.set(__self__, "kafkas", kafkas)
        if kineses is not None:
            pulumi.set(__self__, "kineses", kineses)
        if lambdas is not None:
            pulumi.set(__self__, "lambdas", lambdas)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if republishes is not None:
            pulumi.set(__self__, "republishes", republishes)
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)
        if sns is not None:
            pulumi.set(__self__, "sns", sns)
        if sql is not None:
            pulumi.set(__self__, "sql", sql)
        if sql_version is not None:
            pulumi.set(__self__, "sql_version", sql_version)
        if sqs is not None:
            pulumi.set(__self__, "sqs", sqs)
        if step_functions is not None:
            pulumi.set(__self__, "step_functions", step_functions)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timestreams is not None:
            pulumi.set(__self__, "timestreams", timestreams)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the topic rule
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="cloudwatchAlarms")
    def cloudwatch_alarms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleCloudwatchAlarmArgs']]]]:
        return pulumi.get(self, "cloudwatch_alarms")

    @cloudwatch_alarms.setter
    def cloudwatch_alarms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleCloudwatchAlarmArgs']]]]):
        pulumi.set(self, "cloudwatch_alarms", value)

    @property
    @pulumi.getter(name="cloudwatchLogs")
    def cloudwatch_logs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleCloudwatchLogArgs']]]]:
        return pulumi.get(self, "cloudwatch_logs")

    @cloudwatch_logs.setter
    def cloudwatch_logs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleCloudwatchLogArgs']]]]):
        pulumi.set(self, "cloudwatch_logs", value)

    @property
    @pulumi.getter(name="cloudwatchMetrics")
    def cloudwatch_metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleCloudwatchMetricArgs']]]]:
        return pulumi.get(self, "cloudwatch_metrics")

    @cloudwatch_metrics.setter
    def cloudwatch_metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleCloudwatchMetricArgs']]]]):
        pulumi.set(self, "cloudwatch_metrics", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def dynamodbs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleDynamodbArgs']]]]:
        return pulumi.get(self, "dynamodbs")

    @dynamodbs.setter
    def dynamodbs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleDynamodbArgs']]]]):
        pulumi.set(self, "dynamodbs", value)

    @property
    @pulumi.getter
    def dynamodbv2s(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleDynamodbv2Args']]]]:
        return pulumi.get(self, "dynamodbv2s")

    @dynamodbv2s.setter
    def dynamodbv2s(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleDynamodbv2Args']]]]):
        pulumi.set(self, "dynamodbv2s", value)

    @property
    @pulumi.getter
    def elasticsearch(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleElasticsearchArgs']]]]:
        return pulumi.get(self, "elasticsearch")

    @elasticsearch.setter
    def elasticsearch(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleElasticsearchArgs']]]]):
        pulumi.set(self, "elasticsearch", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the rule is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="errorAction")
    def error_action(self) -> Optional[pulumi.Input['TopicRuleErrorActionArgs']]:
        """
        Configuration block with error action to be associated with the rule. See the documentation for `cloudwatch_alarm`, `cloudwatch_logs`, `cloudwatch_metric`, `dynamodb`, `dynamodbv2`, `elasticsearch`, `firehose`, `http`, `iot_analytics`, `iot_events`, `kafka`, `kinesis`, `lambda`, `republish`, `s3`, `sns`, `sqs`, `step_functions`, `timestream` configuration blocks for further configuration details.
        """
        return pulumi.get(self, "error_action")

    @error_action.setter
    def error_action(self, value: Optional[pulumi.Input['TopicRuleErrorActionArgs']]):
        pulumi.set(self, "error_action", value)

    @property
    @pulumi.getter
    def firehoses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleFirehoseArgs']]]]:
        return pulumi.get(self, "firehoses")

    @firehoses.setter
    def firehoses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleFirehoseArgs']]]]):
        pulumi.set(self, "firehoses", value)

    @property
    @pulumi.getter
    def https(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleHttpArgs']]]]:
        return pulumi.get(self, "https")

    @https.setter
    def https(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleHttpArgs']]]]):
        pulumi.set(self, "https", value)

    @property
    @pulumi.getter(name="iotAnalytics")
    def iot_analytics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleIotAnalyticArgs']]]]:
        return pulumi.get(self, "iot_analytics")

    @iot_analytics.setter
    def iot_analytics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleIotAnalyticArgs']]]]):
        pulumi.set(self, "iot_analytics", value)

    @property
    @pulumi.getter(name="iotEvents")
    def iot_events(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleIotEventArgs']]]]:
        return pulumi.get(self, "iot_events")

    @iot_events.setter
    def iot_events(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleIotEventArgs']]]]):
        pulumi.set(self, "iot_events", value)

    @property
    @pulumi.getter
    def kafkas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleKafkaArgs']]]]:
        return pulumi.get(self, "kafkas")

    @kafkas.setter
    def kafkas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleKafkaArgs']]]]):
        pulumi.set(self, "kafkas", value)

    @property
    @pulumi.getter
    def kineses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleKinesisArgs']]]]:
        return pulumi.get(self, "kineses")

    @kineses.setter
    def kineses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleKinesisArgs']]]]):
        pulumi.set(self, "kineses", value)

    @property
    @pulumi.getter
    def lambdas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleLambdaArgs']]]]:
        return pulumi.get(self, "lambdas")

    @lambdas.setter
    def lambdas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleLambdaArgs']]]]):
        pulumi.set(self, "lambdas", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def republishes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleRepublishArgs']]]]:
        return pulumi.get(self, "republishes")

    @republishes.setter
    def republishes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleRepublishArgs']]]]):
        pulumi.set(self, "republishes", value)

    @property
    @pulumi.getter
    def s3(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleS3Args']]]]:
        return pulumi.get(self, "s3")

    @s3.setter
    def s3(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleS3Args']]]]):
        pulumi.set(self, "s3", value)

    @property
    @pulumi.getter
    def sns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleSnsArgs']]]]:
        return pulumi.get(self, "sns")

    @sns.setter
    def sns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleSnsArgs']]]]):
        pulumi.set(self, "sns", value)

    @property
    @pulumi.getter
    def sql(self) -> Optional[pulumi.Input[str]]:
        """
        The SQL statement used to query the topic. For more information, see AWS IoT SQL Reference (http://docs.aws.amazon.com/iot/latest/developerguide/iot-rules.html#aws-iot-sql-reference) in the AWS IoT Developer Guide.
        """
        return pulumi.get(self, "sql")

    @sql.setter
    def sql(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sql", value)

    @property
    @pulumi.getter(name="sqlVersion")
    def sql_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the SQL rules engine to use when evaluating the rule.
        """
        return pulumi.get(self, "sql_version")

    @sql_version.setter
    def sql_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sql_version", value)

    @property
    @pulumi.getter
    def sqs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleSqsArgs']]]]:
        return pulumi.get(self, "sqs")

    @sqs.setter
    def sqs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleSqsArgs']]]]):
        pulumi.set(self, "sqs", value)

    @property
    @pulumi.getter(name="stepFunctions")
    def step_functions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleStepFunctionArgs']]]]:
        return pulumi.get(self, "step_functions")

    @step_functions.setter
    def step_functions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleStepFunctionArgs']]]]):
        pulumi.set(self, "step_functions", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def timestreams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleTimestreamArgs']]]]:
        return pulumi.get(self, "timestreams")

    @timestreams.setter
    def timestreams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TopicRuleTimestreamArgs']]]]):
        pulumi.set(self, "timestreams", value)


class TopicRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloudwatch_alarms: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleCloudwatchAlarmArgs']]]]] = None,
                 cloudwatch_logs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleCloudwatchLogArgs']]]]] = None,
                 cloudwatch_metrics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleCloudwatchMetricArgs']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dynamodbs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleDynamodbArgs']]]]] = None,
                 dynamodbv2s: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleDynamodbv2Args']]]]] = None,
                 elasticsearch: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleElasticsearchArgs']]]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 error_action: Optional[pulumi.Input[pulumi.InputType['TopicRuleErrorActionArgs']]] = None,
                 firehoses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleFirehoseArgs']]]]] = None,
                 https: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleHttpArgs']]]]] = None,
                 iot_analytics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleIotAnalyticArgs']]]]] = None,
                 iot_events: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleIotEventArgs']]]]] = None,
                 kafkas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleKafkaArgs']]]]] = None,
                 kineses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleKinesisArgs']]]]] = None,
                 lambdas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleLambdaArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 republishes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleRepublishArgs']]]]] = None,
                 s3: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleS3Args']]]]] = None,
                 sns: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleSnsArgs']]]]] = None,
                 sql: Optional[pulumi.Input[str]] = None,
                 sql_version: Optional[pulumi.Input[str]] = None,
                 sqs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleSqsArgs']]]]] = None,
                 step_functions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleStepFunctionArgs']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timestreams: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleTimestreamArgs']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        mytopic = aws.sns.Topic("mytopic")
        myerrortopic = aws.sns.Topic("myerrortopic")
        assume_role = aws.iam.get_policy_document(statements=[aws.iam.GetPolicyDocumentStatementArgs(
            effect="Allow",
            principals=[aws.iam.GetPolicyDocumentStatementPrincipalArgs(
                type="Service",
                identifiers=["iot.amazonaws.com"],
            )],
            actions=["sts:AssumeRole"],
        )])
        role = aws.iam.Role("role", assume_role_policy=assume_role.json)
        rule = aws.iot.TopicRule("rule",
            description="Example rule",
            enabled=True,
            sql="SELECT * FROM 'topic/test'",
            sql_version="2016-03-23",
            sns=[aws.iot.TopicRuleSnsArgs(
                message_format="RAW",
                role_arn=role.arn,
                target_arn=mytopic.arn,
            )],
            error_action=aws.iot.TopicRuleErrorActionArgs(
                sns=aws.iot.TopicRuleErrorActionSnsArgs(
                    message_format="RAW",
                    role_arn=role.arn,
                    target_arn=myerrortopic.arn,
                ),
            ))
        iam_policy_for_lambda_policy_document = mytopic.arn.apply(lambda arn: aws.iam.get_policy_document_output(statements=[aws.iam.GetPolicyDocumentStatementArgs(
            effect="Allow",
            actions=["sns:Publish"],
            resources=[arn],
        )]))
        iam_policy_for_lambda_role_policy = aws.iam.RolePolicy("iamPolicyForLambdaRolePolicy",
            role=role.id,
            policy=iam_policy_for_lambda_policy_document.json)
        ```

        ## Import

        Using `pulumi import`, import IoT Topic Rules using the `name`. For example:

        ```sh
         $ pulumi import aws:iot/topicRule:TopicRule rule <name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the rule.
        :param pulumi.Input[bool] enabled: Specifies whether the rule is enabled.
        :param pulumi.Input[pulumi.InputType['TopicRuleErrorActionArgs']] error_action: Configuration block with error action to be associated with the rule. See the documentation for `cloudwatch_alarm`, `cloudwatch_logs`, `cloudwatch_metric`, `dynamodb`, `dynamodbv2`, `elasticsearch`, `firehose`, `http`, `iot_analytics`, `iot_events`, `kafka`, `kinesis`, `lambda`, `republish`, `s3`, `sns`, `sqs`, `step_functions`, `timestream` configuration blocks for further configuration details.
        :param pulumi.Input[str] name: The name of the rule.
        :param pulumi.Input[str] sql: The SQL statement used to query the topic. For more information, see AWS IoT SQL Reference (http://docs.aws.amazon.com/iot/latest/developerguide/iot-rules.html#aws-iot-sql-reference) in the AWS IoT Developer Guide.
        :param pulumi.Input[str] sql_version: The version of the SQL rules engine to use when evaluating the rule.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TopicRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        mytopic = aws.sns.Topic("mytopic")
        myerrortopic = aws.sns.Topic("myerrortopic")
        assume_role = aws.iam.get_policy_document(statements=[aws.iam.GetPolicyDocumentStatementArgs(
            effect="Allow",
            principals=[aws.iam.GetPolicyDocumentStatementPrincipalArgs(
                type="Service",
                identifiers=["iot.amazonaws.com"],
            )],
            actions=["sts:AssumeRole"],
        )])
        role = aws.iam.Role("role", assume_role_policy=assume_role.json)
        rule = aws.iot.TopicRule("rule",
            description="Example rule",
            enabled=True,
            sql="SELECT * FROM 'topic/test'",
            sql_version="2016-03-23",
            sns=[aws.iot.TopicRuleSnsArgs(
                message_format="RAW",
                role_arn=role.arn,
                target_arn=mytopic.arn,
            )],
            error_action=aws.iot.TopicRuleErrorActionArgs(
                sns=aws.iot.TopicRuleErrorActionSnsArgs(
                    message_format="RAW",
                    role_arn=role.arn,
                    target_arn=myerrortopic.arn,
                ),
            ))
        iam_policy_for_lambda_policy_document = mytopic.arn.apply(lambda arn: aws.iam.get_policy_document_output(statements=[aws.iam.GetPolicyDocumentStatementArgs(
            effect="Allow",
            actions=["sns:Publish"],
            resources=[arn],
        )]))
        iam_policy_for_lambda_role_policy = aws.iam.RolePolicy("iamPolicyForLambdaRolePolicy",
            role=role.id,
            policy=iam_policy_for_lambda_policy_document.json)
        ```

        ## Import

        Using `pulumi import`, import IoT Topic Rules using the `name`. For example:

        ```sh
         $ pulumi import aws:iot/topicRule:TopicRule rule <name>
        ```

        :param str resource_name: The name of the resource.
        :param TopicRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TopicRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloudwatch_alarms: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleCloudwatchAlarmArgs']]]]] = None,
                 cloudwatch_logs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleCloudwatchLogArgs']]]]] = None,
                 cloudwatch_metrics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleCloudwatchMetricArgs']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dynamodbs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleDynamodbArgs']]]]] = None,
                 dynamodbv2s: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleDynamodbv2Args']]]]] = None,
                 elasticsearch: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleElasticsearchArgs']]]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 error_action: Optional[pulumi.Input[pulumi.InputType['TopicRuleErrorActionArgs']]] = None,
                 firehoses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleFirehoseArgs']]]]] = None,
                 https: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleHttpArgs']]]]] = None,
                 iot_analytics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleIotAnalyticArgs']]]]] = None,
                 iot_events: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleIotEventArgs']]]]] = None,
                 kafkas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleKafkaArgs']]]]] = None,
                 kineses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleKinesisArgs']]]]] = None,
                 lambdas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleLambdaArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 republishes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleRepublishArgs']]]]] = None,
                 s3: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleS3Args']]]]] = None,
                 sns: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleSnsArgs']]]]] = None,
                 sql: Optional[pulumi.Input[str]] = None,
                 sql_version: Optional[pulumi.Input[str]] = None,
                 sqs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleSqsArgs']]]]] = None,
                 step_functions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleStepFunctionArgs']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timestreams: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleTimestreamArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TopicRuleArgs.__new__(TopicRuleArgs)

            __props__.__dict__["cloudwatch_alarms"] = cloudwatch_alarms
            __props__.__dict__["cloudwatch_logs"] = cloudwatch_logs
            __props__.__dict__["cloudwatch_metrics"] = cloudwatch_metrics
            __props__.__dict__["description"] = description
            __props__.__dict__["dynamodbs"] = dynamodbs
            __props__.__dict__["dynamodbv2s"] = dynamodbv2s
            __props__.__dict__["elasticsearch"] = elasticsearch
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["error_action"] = error_action
            __props__.__dict__["firehoses"] = firehoses
            __props__.__dict__["https"] = https
            __props__.__dict__["iot_analytics"] = iot_analytics
            __props__.__dict__["iot_events"] = iot_events
            __props__.__dict__["kafkas"] = kafkas
            __props__.__dict__["kineses"] = kineses
            __props__.__dict__["lambdas"] = lambdas
            __props__.__dict__["name"] = name
            __props__.__dict__["republishes"] = republishes
            __props__.__dict__["s3"] = s3
            __props__.__dict__["sns"] = sns
            if sql is None and not opts.urn:
                raise TypeError("Missing required property 'sql'")
            __props__.__dict__["sql"] = sql
            if sql_version is None and not opts.urn:
                raise TypeError("Missing required property 'sql_version'")
            __props__.__dict__["sql_version"] = sql_version
            __props__.__dict__["sqs"] = sqs
            __props__.__dict__["step_functions"] = step_functions
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timestreams"] = timestreams
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(TopicRule, __self__).__init__(
            'aws:iot/topicRule:TopicRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            cloudwatch_alarms: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleCloudwatchAlarmArgs']]]]] = None,
            cloudwatch_logs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleCloudwatchLogArgs']]]]] = None,
            cloudwatch_metrics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleCloudwatchMetricArgs']]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            dynamodbs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleDynamodbArgs']]]]] = None,
            dynamodbv2s: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleDynamodbv2Args']]]]] = None,
            elasticsearch: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleElasticsearchArgs']]]]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            error_action: Optional[pulumi.Input[pulumi.InputType['TopicRuleErrorActionArgs']]] = None,
            firehoses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleFirehoseArgs']]]]] = None,
            https: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleHttpArgs']]]]] = None,
            iot_analytics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleIotAnalyticArgs']]]]] = None,
            iot_events: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleIotEventArgs']]]]] = None,
            kafkas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleKafkaArgs']]]]] = None,
            kineses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleKinesisArgs']]]]] = None,
            lambdas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleLambdaArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            republishes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleRepublishArgs']]]]] = None,
            s3: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleS3Args']]]]] = None,
            sns: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleSnsArgs']]]]] = None,
            sql: Optional[pulumi.Input[str]] = None,
            sql_version: Optional[pulumi.Input[str]] = None,
            sqs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleSqsArgs']]]]] = None,
            step_functions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleStepFunctionArgs']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            timestreams: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TopicRuleTimestreamArgs']]]]] = None) -> 'TopicRule':
        """
        Get an existing TopicRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The ARN of the topic rule
        :param pulumi.Input[str] description: The description of the rule.
        :param pulumi.Input[bool] enabled: Specifies whether the rule is enabled.
        :param pulumi.Input[pulumi.InputType['TopicRuleErrorActionArgs']] error_action: Configuration block with error action to be associated with the rule. See the documentation for `cloudwatch_alarm`, `cloudwatch_logs`, `cloudwatch_metric`, `dynamodb`, `dynamodbv2`, `elasticsearch`, `firehose`, `http`, `iot_analytics`, `iot_events`, `kafka`, `kinesis`, `lambda`, `republish`, `s3`, `sns`, `sqs`, `step_functions`, `timestream` configuration blocks for further configuration details.
        :param pulumi.Input[str] name: The name of the rule.
        :param pulumi.Input[str] sql: The SQL statement used to query the topic. For more information, see AWS IoT SQL Reference (http://docs.aws.amazon.com/iot/latest/developerguide/iot-rules.html#aws-iot-sql-reference) in the AWS IoT Developer Guide.
        :param pulumi.Input[str] sql_version: The version of the SQL rules engine to use when evaluating the rule.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TopicRuleState.__new__(_TopicRuleState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["cloudwatch_alarms"] = cloudwatch_alarms
        __props__.__dict__["cloudwatch_logs"] = cloudwatch_logs
        __props__.__dict__["cloudwatch_metrics"] = cloudwatch_metrics
        __props__.__dict__["description"] = description
        __props__.__dict__["dynamodbs"] = dynamodbs
        __props__.__dict__["dynamodbv2s"] = dynamodbv2s
        __props__.__dict__["elasticsearch"] = elasticsearch
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["error_action"] = error_action
        __props__.__dict__["firehoses"] = firehoses
        __props__.__dict__["https"] = https
        __props__.__dict__["iot_analytics"] = iot_analytics
        __props__.__dict__["iot_events"] = iot_events
        __props__.__dict__["kafkas"] = kafkas
        __props__.__dict__["kineses"] = kineses
        __props__.__dict__["lambdas"] = lambdas
        __props__.__dict__["name"] = name
        __props__.__dict__["republishes"] = republishes
        __props__.__dict__["s3"] = s3
        __props__.__dict__["sns"] = sns
        __props__.__dict__["sql"] = sql
        __props__.__dict__["sql_version"] = sql_version
        __props__.__dict__["sqs"] = sqs
        __props__.__dict__["step_functions"] = step_functions
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timestreams"] = timestreams
        return TopicRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the topic rule
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="cloudwatchAlarms")
    def cloudwatch_alarms(self) -> pulumi.Output[Optional[Sequence['outputs.TopicRuleCloudwatchAlarm']]]:
        return pulumi.get(self, "cloudwatch_alarms")

    @property
    @pulumi.getter(name="cloudwatchLogs")
    def cloudwatch_logs(self) -> pulumi.Output[Optional[Sequence['outputs.TopicRuleCloudwatchLog']]]:
        return pulumi.get(self, "cloudwatch_logs")

    @property
    @pulumi.getter(name="cloudwatchMetrics")
    def cloudwatch_metrics(self) -> pulumi.Output[Optional[Sequence['outputs.TopicRuleCloudwatchMetric']]]:
        return pulumi.get(self, "cloudwatch_metrics")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def dynamodbs(self) -> pulumi.Output[Optional[Sequence['outputs.TopicRuleDynamodb']]]:
        return pulumi.get(self, "dynamodbs")

    @property
    @pulumi.getter
    def dynamodbv2s(self) -> pulumi.Output[Optional[Sequence['outputs.TopicRuleDynamodbv2']]]:
        return pulumi.get(self, "dynamodbv2s")

    @property
    @pulumi.getter
    def elasticsearch(self) -> pulumi.Output[Optional[Sequence['outputs.TopicRuleElasticsearch']]]:
        return pulumi.get(self, "elasticsearch")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[bool]:
        """
        Specifies whether the rule is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="errorAction")
    def error_action(self) -> pulumi.Output[Optional['outputs.TopicRuleErrorAction']]:
        """
        Configuration block with error action to be associated with the rule. See the documentation for `cloudwatch_alarm`, `cloudwatch_logs`, `cloudwatch_metric`, `dynamodb`, `dynamodbv2`, `elasticsearch`, `firehose`, `http`, `iot_analytics`, `iot_events`, `kafka`, `kinesis`, `lambda`, `republish`, `s3`, `sns`, `sqs`, `step_functions`, `timestream` configuration blocks for further configuration details.
        """
        return pulumi.get(self, "error_action")

    @property
    @pulumi.getter
    def firehoses(self) -> pulumi.Output[Optional[Sequence['outputs.TopicRuleFirehose']]]:
        return pulumi.get(self, "firehoses")

    @property
    @pulumi.getter
    def https(self) -> pulumi.Output[Optional[Sequence['outputs.TopicRuleHttp']]]:
        return pulumi.get(self, "https")

    @property
    @pulumi.getter(name="iotAnalytics")
    def iot_analytics(self) -> pulumi.Output[Optional[Sequence['outputs.TopicRuleIotAnalytic']]]:
        return pulumi.get(self, "iot_analytics")

    @property
    @pulumi.getter(name="iotEvents")
    def iot_events(self) -> pulumi.Output[Optional[Sequence['outputs.TopicRuleIotEvent']]]:
        return pulumi.get(self, "iot_events")

    @property
    @pulumi.getter
    def kafkas(self) -> pulumi.Output[Optional[Sequence['outputs.TopicRuleKafka']]]:
        return pulumi.get(self, "kafkas")

    @property
    @pulumi.getter
    def kineses(self) -> pulumi.Output[Optional[Sequence['outputs.TopicRuleKinesis']]]:
        return pulumi.get(self, "kineses")

    @property
    @pulumi.getter
    def lambdas(self) -> pulumi.Output[Optional[Sequence['outputs.TopicRuleLambda']]]:
        return pulumi.get(self, "lambdas")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def republishes(self) -> pulumi.Output[Optional[Sequence['outputs.TopicRuleRepublish']]]:
        return pulumi.get(self, "republishes")

    @property
    @pulumi.getter
    def s3(self) -> pulumi.Output[Optional[Sequence['outputs.TopicRuleS3']]]:
        return pulumi.get(self, "s3")

    @property
    @pulumi.getter
    def sns(self) -> pulumi.Output[Optional[Sequence['outputs.TopicRuleSns']]]:
        return pulumi.get(self, "sns")

    @property
    @pulumi.getter
    def sql(self) -> pulumi.Output[str]:
        """
        The SQL statement used to query the topic. For more information, see AWS IoT SQL Reference (http://docs.aws.amazon.com/iot/latest/developerguide/iot-rules.html#aws-iot-sql-reference) in the AWS IoT Developer Guide.
        """
        return pulumi.get(self, "sql")

    @property
    @pulumi.getter(name="sqlVersion")
    def sql_version(self) -> pulumi.Output[str]:
        """
        The version of the SQL rules engine to use when evaluating the rule.
        """
        return pulumi.get(self, "sql_version")

    @property
    @pulumi.getter
    def sqs(self) -> pulumi.Output[Optional[Sequence['outputs.TopicRuleSqs']]]:
        return pulumi.get(self, "sqs")

    @property
    @pulumi.getter(name="stepFunctions")
    def step_functions(self) -> pulumi.Output[Optional[Sequence['outputs.TopicRuleStepFunction']]]:
        return pulumi.get(self, "step_functions")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def timestreams(self) -> pulumi.Output[Optional[Sequence['outputs.TopicRuleTimestream']]]:
        return pulumi.get(self, "timestreams")

