# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GrantConstraintArgs',
    'GetSecretSecretArgs',
    'GetSecretsSecretArgs',
]

@pulumi.input_type
class GrantConstraintArgs:
    def __init__(__self__, *,
                 encryption_context_equals: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 encryption_context_subset: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] encryption_context_equals: A list of key-value pairs that must match the encryption context in subsequent cryptographic operation requests. The grant allows the operation only when the encryption context in the request is the same as the encryption context specified in this constraint. Conflicts with `encryption_context_subset`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] encryption_context_subset: A list of key-value pairs that must be included in the encryption context of subsequent cryptographic operation requests. The grant allows the cryptographic operation only when the encryption context in the request includes the key-value pairs specified in this constraint, although it can include additional key-value pairs. Conflicts with `encryption_context_equals`.
        """
        if encryption_context_equals is not None:
            pulumi.set(__self__, "encryption_context_equals", encryption_context_equals)
        if encryption_context_subset is not None:
            pulumi.set(__self__, "encryption_context_subset", encryption_context_subset)

    @property
    @pulumi.getter(name="encryptionContextEquals")
    def encryption_context_equals(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A list of key-value pairs that must match the encryption context in subsequent cryptographic operation requests. The grant allows the operation only when the encryption context in the request is the same as the encryption context specified in this constraint. Conflicts with `encryption_context_subset`.
        """
        return pulumi.get(self, "encryption_context_equals")

    @encryption_context_equals.setter
    def encryption_context_equals(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "encryption_context_equals", value)

    @property
    @pulumi.getter(name="encryptionContextSubset")
    def encryption_context_subset(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A list of key-value pairs that must be included in the encryption context of subsequent cryptographic operation requests. The grant allows the cryptographic operation only when the encryption context in the request includes the key-value pairs specified in this constraint, although it can include additional key-value pairs. Conflicts with `encryption_context_equals`.
        """
        return pulumi.get(self, "encryption_context_subset")

    @encryption_context_subset.setter
    def encryption_context_subset(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "encryption_context_subset", value)


@pulumi.input_type
class GetSecretSecretArgs:
    def __init__(__self__, *,
                 name: str,
                 payload: str,
                 context: Optional[Mapping[str, str]] = None,
                 grant_tokens: Optional[Sequence[str]] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "payload", payload)
        if context is not None:
            pulumi.set(__self__, "context", context)
        if grant_tokens is not None:
            pulumi.set(__self__, "grant_tokens", grant_tokens)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def payload(self) -> str:
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: str):
        pulumi.set(self, "payload", value)

    @property
    @pulumi.getter
    def context(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "context")

    @context.setter
    def context(self, value: Optional[Mapping[str, str]]):
        pulumi.set(self, "context", value)

    @property
    @pulumi.getter(name="grantTokens")
    def grant_tokens(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "grant_tokens")

    @grant_tokens.setter
    def grant_tokens(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "grant_tokens", value)


@pulumi.input_type
class GetSecretsSecretArgs:
    def __init__(__self__, *,
                 name: str,
                 payload: str,
                 context: Optional[Mapping[str, str]] = None,
                 encryption_algorithm: Optional[str] = None,
                 grant_tokens: Optional[Sequence[str]] = None,
                 key_id: Optional[str] = None):
        """
        :param str name: Name to export this secret under in the attributes.
        :param str payload: Base64 encoded payload, as returned from a KMS encrypt operation.
        :param Mapping[str, str] context: An optional mapping that makes up the Encryption Context for the secret.
        :param str encryption_algorithm: The encryption algorithm that will be used to decrypt the ciphertext. This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key. Valid Values: SYMMETRIC_DEFAULT | RSAES_OAEP_SHA_1 | RSAES_OAEP_SHA_256 | SM2PKE
        :param Sequence[str] grant_tokens: An optional list of Grant Tokens for the secret.
        :param str key_id: Specifies the KMS key that AWS KMS uses to decrypt the ciphertext. This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key.
               
               For more information on `context` and `grant_tokens` see the [KMS
               Concepts](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html)
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "payload", payload)
        if context is not None:
            pulumi.set(__self__, "context", context)
        if encryption_algorithm is not None:
            pulumi.set(__self__, "encryption_algorithm", encryption_algorithm)
        if grant_tokens is not None:
            pulumi.set(__self__, "grant_tokens", grant_tokens)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name to export this secret under in the attributes.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def payload(self) -> str:
        """
        Base64 encoded payload, as returned from a KMS encrypt operation.
        """
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: str):
        pulumi.set(self, "payload", value)

    @property
    @pulumi.getter
    def context(self) -> Optional[Mapping[str, str]]:
        """
        An optional mapping that makes up the Encryption Context for the secret.
        """
        return pulumi.get(self, "context")

    @context.setter
    def context(self, value: Optional[Mapping[str, str]]):
        pulumi.set(self, "context", value)

    @property
    @pulumi.getter(name="encryptionAlgorithm")
    def encryption_algorithm(self) -> Optional[str]:
        """
        The encryption algorithm that will be used to decrypt the ciphertext. This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key. Valid Values: SYMMETRIC_DEFAULT | RSAES_OAEP_SHA_1 | RSAES_OAEP_SHA_256 | SM2PKE
        """
        return pulumi.get(self, "encryption_algorithm")

    @encryption_algorithm.setter
    def encryption_algorithm(self, value: Optional[str]):
        pulumi.set(self, "encryption_algorithm", value)

    @property
    @pulumi.getter(name="grantTokens")
    def grant_tokens(self) -> Optional[Sequence[str]]:
        """
        An optional list of Grant Tokens for the secret.
        """
        return pulumi.get(self, "grant_tokens")

    @grant_tokens.setter
    def grant_tokens(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "grant_tokens", value)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[str]:
        """
        Specifies the KMS key that AWS KMS uses to decrypt the ciphertext. This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key.

        For more information on `context` and `grant_tokens` see the [KMS
        Concepts](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html)
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: Optional[str]):
        pulumi.set(self, "key_id", value)


