# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'DataLakeSettingsCreateDatabaseDefaultPermission',
    'DataLakeSettingsCreateTableDefaultPermission',
    'PermissionsDataLocation',
    'PermissionsDatabase',
    'PermissionsLfTag',
    'PermissionsLfTagPolicy',
    'PermissionsLfTagPolicyExpression',
    'PermissionsTable',
    'PermissionsTableWithColumns',
    'ResourceLfTagsDatabase',
    'ResourceLfTagsLfTag',
    'ResourceLfTagsTable',
    'ResourceLfTagsTableWithColumns',
    'GetDataLakeSettingsCreateDatabaseDefaultPermissionResult',
    'GetDataLakeSettingsCreateTableDefaultPermissionResult',
    'GetPermissionsDataLocationResult',
    'GetPermissionsDatabaseResult',
    'GetPermissionsLfTagResult',
    'GetPermissionsLfTagPolicyResult',
    'GetPermissionsLfTagPolicyExpressionResult',
    'GetPermissionsTableResult',
    'GetPermissionsTableWithColumnsResult',
]

@pulumi.output_type
class DataLakeSettingsCreateDatabaseDefaultPermission(dict):
    def __init__(__self__, *,
                 permissions: Optional[Sequence[str]] = None,
                 principal: Optional[str] = None):
        """
        :param Sequence[str] permissions: List of permissions that are granted to the principal. Valid values may include `ALL`, `SELECT`, `ALTER`, `DROP`, `DELETE`, `INSERT`, `DESCRIBE`, and `CREATE_TABLE`. For more details, see [Lake Formation Permissions Reference](https://docs.aws.amazon.com/lake-formation/latest/dg/lf-permissions-reference.html).
        :param str principal: Principal who is granted permissions. To enforce metadata and underlying data access control only by IAM on new databases and tables set `principal` to `IAM_ALLOWED_PRINCIPALS` and `permissions` to `["ALL"]`.
        """
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if principal is not None:
            pulumi.set(__self__, "principal", principal)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[Sequence[str]]:
        """
        List of permissions that are granted to the principal. Valid values may include `ALL`, `SELECT`, `ALTER`, `DROP`, `DELETE`, `INSERT`, `DESCRIBE`, and `CREATE_TABLE`. For more details, see [Lake Formation Permissions Reference](https://docs.aws.amazon.com/lake-formation/latest/dg/lf-permissions-reference.html).
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter
    def principal(self) -> Optional[str]:
        """
        Principal who is granted permissions. To enforce metadata and underlying data access control only by IAM on new databases and tables set `principal` to `IAM_ALLOWED_PRINCIPALS` and `permissions` to `["ALL"]`.
        """
        return pulumi.get(self, "principal")


@pulumi.output_type
class DataLakeSettingsCreateTableDefaultPermission(dict):
    def __init__(__self__, *,
                 permissions: Optional[Sequence[str]] = None,
                 principal: Optional[str] = None):
        """
        :param Sequence[str] permissions: List of permissions that are granted to the principal. Valid values may include `ALL`, `SELECT`, `ALTER`, `DROP`, `DELETE`, `INSERT`, and `DESCRIBE`. For more details, see [Lake Formation Permissions Reference](https://docs.aws.amazon.com/lake-formation/latest/dg/lf-permissions-reference.html).
        :param str principal: Principal who is granted permissions. To enforce metadata and underlying data access control only by IAM on new databases and tables set `principal` to `IAM_ALLOWED_PRINCIPALS` and `permissions` to `["ALL"]`.
        """
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if principal is not None:
            pulumi.set(__self__, "principal", principal)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[Sequence[str]]:
        """
        List of permissions that are granted to the principal. Valid values may include `ALL`, `SELECT`, `ALTER`, `DROP`, `DELETE`, `INSERT`, and `DESCRIBE`. For more details, see [Lake Formation Permissions Reference](https://docs.aws.amazon.com/lake-formation/latest/dg/lf-permissions-reference.html).
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter
    def principal(self) -> Optional[str]:
        """
        Principal who is granted permissions. To enforce metadata and underlying data access control only by IAM on new databases and tables set `principal` to `IAM_ALLOWED_PRINCIPALS` and `permissions` to `["ALL"]`.
        """
        return pulumi.get(self, "principal")


@pulumi.output_type
class PermissionsDataLocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "catalogId":
            suggest = "catalog_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PermissionsDataLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PermissionsDataLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PermissionsDataLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arn: str,
                 catalog_id: Optional[str] = None):
        """
        :param str arn: Amazon Resource Name (ARN) that uniquely identifies the data location resource.
               
               The following argument is optional:
        :param str catalog_id: Identifier for the Data Catalog where the location is registered with Lake Formation. By default, it is the account ID of the caller.
        """
        pulumi.set(__self__, "arn", arn)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        Amazon Resource Name (ARN) that uniquely identifies the data location resource.

        The following argument is optional:
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[str]:
        """
        Identifier for the Data Catalog where the location is registered with Lake Formation. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")


@pulumi.output_type
class PermissionsDatabase(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "catalogId":
            suggest = "catalog_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PermissionsDatabase. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PermissionsDatabase.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PermissionsDatabase.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 catalog_id: Optional[str] = None):
        """
        :param str name: Name of the database resource. Unique to the Data Catalog.
               
               The following argument is optional:
        :param str catalog_id: Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        pulumi.set(__self__, "name", name)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the database resource. Unique to the Data Catalog.

        The following argument is optional:
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[str]:
        """
        Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")


@pulumi.output_type
class PermissionsLfTag(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "catalogId":
            suggest = "catalog_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PermissionsLfTag. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PermissionsLfTag.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PermissionsLfTag.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str],
                 catalog_id: Optional[str] = None):
        """
        :param str key: The key-name for the tag.
        :param Sequence[str] values: A list of possible values an attribute can take.
               
               The following argument is optional:
        :param str catalog_id: Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key-name for the tag.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        A list of possible values an attribute can take.

        The following argument is optional:
        """
        return pulumi.get(self, "values")

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[str]:
        """
        Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")


@pulumi.output_type
class PermissionsLfTagPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceType":
            suggest = "resource_type"
        elif key == "catalogId":
            suggest = "catalog_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PermissionsLfTagPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PermissionsLfTagPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PermissionsLfTagPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expressions: Sequence['outputs.PermissionsLfTagPolicyExpression'],
                 resource_type: str,
                 catalog_id: Optional[str] = None):
        """
        :param Sequence['PermissionsLfTagPolicyExpressionArgs'] expressions: A list of tag conditions that apply to the resource's tag policy. Configuration block for tag conditions that apply to the policy. See `expression` below.
               
               The following argument is optional:
        :param str resource_type: The resource type for which the tag policy applies. Valid values are `DATABASE` and `TABLE`.
        :param str catalog_id: Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        pulumi.set(__self__, "expressions", expressions)
        pulumi.set(__self__, "resource_type", resource_type)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)

    @property
    @pulumi.getter
    def expressions(self) -> Sequence['outputs.PermissionsLfTagPolicyExpression']:
        """
        A list of tag conditions that apply to the resource's tag policy. Configuration block for tag conditions that apply to the policy. See `expression` below.

        The following argument is optional:
        """
        return pulumi.get(self, "expressions")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        The resource type for which the tag policy applies. Valid values are `DATABASE` and `TABLE`.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[str]:
        """
        Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")


@pulumi.output_type
class PermissionsLfTagPolicyExpression(dict):
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str]):
        """
        :param str key: The key-name of an LF-Tag.
        :param Sequence[str] values: A list of possible values of an LF-Tag.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key-name of an LF-Tag.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        A list of possible values of an LF-Tag.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class PermissionsTable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "catalogId":
            suggest = "catalog_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PermissionsTable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PermissionsTable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PermissionsTable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: str,
                 catalog_id: Optional[str] = None,
                 name: Optional[str] = None,
                 wildcard: Optional[bool] = None):
        """
        :param str database_name: Name of the database for the table. Unique to a Data Catalog.
        :param str catalog_id: Identifier for the Data Catalog. By default, it is the account ID of the caller.
        :param str name: Name of the table.
        :param bool wildcard: Whether to use a wildcard representing every table under a database. Defaults to `false`.
               
               The following arguments are optional:
        """
        pulumi.set(__self__, "database_name", database_name)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if wildcard is not None:
            pulumi.set(__self__, "wildcard", wildcard)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        Name of the database for the table. Unique to a Data Catalog.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[str]:
        """
        Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the table.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def wildcard(self) -> Optional[bool]:
        """
        Whether to use a wildcard representing every table under a database. Defaults to `false`.

        The following arguments are optional:
        """
        return pulumi.get(self, "wildcard")


@pulumi.output_type
class PermissionsTableWithColumns(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "catalogId":
            suggest = "catalog_id"
        elif key == "columnNames":
            suggest = "column_names"
        elif key == "excludedColumnNames":
            suggest = "excluded_column_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PermissionsTableWithColumns. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PermissionsTableWithColumns.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PermissionsTableWithColumns.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: str,
                 name: str,
                 catalog_id: Optional[str] = None,
                 column_names: Optional[Sequence[str]] = None,
                 excluded_column_names: Optional[Sequence[str]] = None,
                 wildcard: Optional[bool] = None):
        """
        :param str database_name: Name of the database for the table with columns resource. Unique to the Data Catalog.
        :param str name: Name of the table resource.
        :param str catalog_id: Identifier for the Data Catalog. By default, it is the account ID of the caller.
        :param Sequence[str] column_names: Set of column names for the table.
        :param Sequence[str] excluded_column_names: Set of column names for the table to exclude. If `excluded_column_names` is included, `wildcard` must be set to `true` to avoid the provider reporting a difference.
        :param bool wildcard: Whether to use a column wildcard. If `excluded_column_names` is included, `wildcard` must be set to `true` to avoid the provider reporting a difference.
               
               The following arguments are optional:
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "name", name)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if column_names is not None:
            pulumi.set(__self__, "column_names", column_names)
        if excluded_column_names is not None:
            pulumi.set(__self__, "excluded_column_names", excluded_column_names)
        if wildcard is not None:
            pulumi.set(__self__, "wildcard", wildcard)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        Name of the database for the table with columns resource. Unique to the Data Catalog.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the table resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[str]:
        """
        Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter(name="columnNames")
    def column_names(self) -> Optional[Sequence[str]]:
        """
        Set of column names for the table.
        """
        return pulumi.get(self, "column_names")

    @property
    @pulumi.getter(name="excludedColumnNames")
    def excluded_column_names(self) -> Optional[Sequence[str]]:
        """
        Set of column names for the table to exclude. If `excluded_column_names` is included, `wildcard` must be set to `true` to avoid the provider reporting a difference.
        """
        return pulumi.get(self, "excluded_column_names")

    @property
    @pulumi.getter
    def wildcard(self) -> Optional[bool]:
        """
        Whether to use a column wildcard. If `excluded_column_names` is included, `wildcard` must be set to `true` to avoid the provider reporting a difference.

        The following arguments are optional:
        """
        return pulumi.get(self, "wildcard")


@pulumi.output_type
class ResourceLfTagsDatabase(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "catalogId":
            suggest = "catalog_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceLfTagsDatabase. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceLfTagsDatabase.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceLfTagsDatabase.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 catalog_id: Optional[str] = None):
        """
        :param str name: Name of the database resource. Unique to the Data Catalog.
               
               The following argument is optional:
        :param str catalog_id: Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        pulumi.set(__self__, "name", name)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the database resource. Unique to the Data Catalog.

        The following argument is optional:
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[str]:
        """
        Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")


@pulumi.output_type
class ResourceLfTagsLfTag(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "catalogId":
            suggest = "catalog_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceLfTagsLfTag. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceLfTagsLfTag.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceLfTagsLfTag.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: str,
                 value: str,
                 catalog_id: Optional[str] = None):
        """
        :param str key: Key name for an existing LF-tag.
        :param str value: Value from the possible values for the LF-tag.
               
               The following argument is optional:
        :param str catalog_id: Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Key name for an existing LF-tag.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Value from the possible values for the LF-tag.

        The following argument is optional:
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[str]:
        """
        Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")


@pulumi.output_type
class ResourceLfTagsTable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "catalogId":
            suggest = "catalog_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceLfTagsTable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceLfTagsTable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceLfTagsTable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: str,
                 catalog_id: Optional[str] = None,
                 name: Optional[str] = None,
                 wildcard: Optional[bool] = None):
        """
        :param str database_name: Name of the database for the table. Unique to a Data Catalog.
        :param str catalog_id: Identifier for the Data Catalog. By default, it is the account ID of the caller.
        :param str name: Name of the table.
        :param bool wildcard: Whether to use a wildcard representing every table under a database. Defaults to `false`.
               
               The following arguments are optional:
        """
        pulumi.set(__self__, "database_name", database_name)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if wildcard is not None:
            pulumi.set(__self__, "wildcard", wildcard)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        Name of the database for the table. Unique to a Data Catalog.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[str]:
        """
        Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the table.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def wildcard(self) -> Optional[bool]:
        """
        Whether to use a wildcard representing every table under a database. Defaults to `false`.

        The following arguments are optional:
        """
        return pulumi.get(self, "wildcard")


@pulumi.output_type
class ResourceLfTagsTableWithColumns(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "catalogId":
            suggest = "catalog_id"
        elif key == "columnNames":
            suggest = "column_names"
        elif key == "excludedColumnNames":
            suggest = "excluded_column_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceLfTagsTableWithColumns. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceLfTagsTableWithColumns.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceLfTagsTableWithColumns.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: str,
                 name: str,
                 catalog_id: Optional[str] = None,
                 column_names: Optional[Sequence[str]] = None,
                 excluded_column_names: Optional[Sequence[str]] = None,
                 wildcard: Optional[bool] = None):
        """
        :param str database_name: Name of the database for the table with columns resource. Unique to the Data Catalog.
        :param str name: Name of the table resource.
        :param str catalog_id: Identifier for the Data Catalog. By default, it is the account ID of the caller.
        :param Sequence[str] column_names: Set of column names for the table.
        :param Sequence[str] excluded_column_names: Set of column names for the table to exclude. If `excluded_column_names` is included, `wildcard` must be set to `true` to avoid the provider reporting a difference.
        :param bool wildcard: Whether to use a column wildcard. If `excluded_column_names` is included, `wildcard` must be set to `true` to avoid the provider reporting a difference.
               
               The following arguments are optional:
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "name", name)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if column_names is not None:
            pulumi.set(__self__, "column_names", column_names)
        if excluded_column_names is not None:
            pulumi.set(__self__, "excluded_column_names", excluded_column_names)
        if wildcard is not None:
            pulumi.set(__self__, "wildcard", wildcard)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        Name of the database for the table with columns resource. Unique to the Data Catalog.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the table resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[str]:
        """
        Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter(name="columnNames")
    def column_names(self) -> Optional[Sequence[str]]:
        """
        Set of column names for the table.
        """
        return pulumi.get(self, "column_names")

    @property
    @pulumi.getter(name="excludedColumnNames")
    def excluded_column_names(self) -> Optional[Sequence[str]]:
        """
        Set of column names for the table to exclude. If `excluded_column_names` is included, `wildcard` must be set to `true` to avoid the provider reporting a difference.
        """
        return pulumi.get(self, "excluded_column_names")

    @property
    @pulumi.getter
    def wildcard(self) -> Optional[bool]:
        """
        Whether to use a column wildcard. If `excluded_column_names` is included, `wildcard` must be set to `true` to avoid the provider reporting a difference.

        The following arguments are optional:
        """
        return pulumi.get(self, "wildcard")


@pulumi.output_type
class GetDataLakeSettingsCreateDatabaseDefaultPermissionResult(dict):
    def __init__(__self__, *,
                 permissions: Sequence[str],
                 principal: str):
        """
        :param Sequence[str] permissions: List of permissions granted to the principal.
        :param str principal: Principal who is granted permissions.
        """
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "principal", principal)

    @property
    @pulumi.getter
    def permissions(self) -> Sequence[str]:
        """
        List of permissions granted to the principal.
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter
    def principal(self) -> str:
        """
        Principal who is granted permissions.
        """
        return pulumi.get(self, "principal")


@pulumi.output_type
class GetDataLakeSettingsCreateTableDefaultPermissionResult(dict):
    def __init__(__self__, *,
                 permissions: Sequence[str],
                 principal: str):
        """
        :param Sequence[str] permissions: List of permissions granted to the principal.
        :param str principal: Principal who is granted permissions.
        """
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "principal", principal)

    @property
    @pulumi.getter
    def permissions(self) -> Sequence[str]:
        """
        List of permissions granted to the principal.
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter
    def principal(self) -> str:
        """
        Principal who is granted permissions.
        """
        return pulumi.get(self, "principal")


@pulumi.output_type
class GetPermissionsDataLocationResult(dict):
    def __init__(__self__, *,
                 arn: str,
                 catalog_id: str):
        """
        :param str arn: ARN that uniquely identifies the data location resource.
               
               The following argument is optional:
        :param str catalog_id: Identifier for the Data Catalog where the location is registered with Lake Formation. By default, it is the account ID of the caller.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "catalog_id", catalog_id)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        ARN that uniquely identifies the data location resource.

        The following argument is optional:
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> str:
        """
        Identifier for the Data Catalog where the location is registered with Lake Formation. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")


@pulumi.output_type
class GetPermissionsDatabaseResult(dict):
    def __init__(__self__, *,
                 catalog_id: str,
                 name: str):
        """
        :param str catalog_id: Identifier for the Data Catalog. By default, it is the account ID of the caller.
        :param str name: Name of the database resource. Unique to the Data Catalog.
               
               The following argument is optional:
        """
        pulumi.set(__self__, "catalog_id", catalog_id)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> str:
        """
        Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the database resource. Unique to the Data Catalog.

        The following argument is optional:
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetPermissionsLfTagResult(dict):
    def __init__(__self__, *,
                 catalog_id: str,
                 key: str,
                 values: Sequence[str]):
        """
        :param str catalog_id: Identifier for the Data Catalog. By default, it is the account ID of the caller.
        :param str key: Key-name for the tag.
        :param Sequence[str] values: List of possible values an attribute can take.
               
               The following argument is optional:
        """
        pulumi.set(__self__, "catalog_id", catalog_id)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> str:
        """
        Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Key-name for the tag.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        List of possible values an attribute can take.

        The following argument is optional:
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetPermissionsLfTagPolicyResult(dict):
    def __init__(__self__, *,
                 catalog_id: str,
                 expressions: Sequence['outputs.GetPermissionsLfTagPolicyExpressionResult'],
                 resource_type: str):
        """
        :param str catalog_id: Identifier for the Data Catalog. By default, it is the account ID of the caller.
        :param Sequence['GetPermissionsLfTagPolicyExpressionArgs'] expressions: List of tag conditions that apply to the resource's tag policy. Configuration block for tag conditions that apply to the policy. See `expression` below.
               
               The following argument is optional:
        :param str resource_type: Resource type for which the tag policy applies. Valid values are `DATABASE` and `TABLE`.
        """
        pulumi.set(__self__, "catalog_id", catalog_id)
        pulumi.set(__self__, "expressions", expressions)
        pulumi.set(__self__, "resource_type", resource_type)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> str:
        """
        Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter
    def expressions(self) -> Sequence['outputs.GetPermissionsLfTagPolicyExpressionResult']:
        """
        List of tag conditions that apply to the resource's tag policy. Configuration block for tag conditions that apply to the policy. See `expression` below.

        The following argument is optional:
        """
        return pulumi.get(self, "expressions")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        Resource type for which the tag policy applies. Valid values are `DATABASE` and `TABLE`.
        """
        return pulumi.get(self, "resource_type")


@pulumi.output_type
class GetPermissionsLfTagPolicyExpressionResult(dict):
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str]):
        """
        :param str key: Key-name of an LF-Tag.
        :param Sequence[str] values: List of possible values of an LF-Tag.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Key-name of an LF-Tag.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        List of possible values of an LF-Tag.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetPermissionsTableResult(dict):
    def __init__(__self__, *,
                 catalog_id: str,
                 database_name: str,
                 name: str,
                 wildcard: Optional[bool] = None):
        """
        :param str catalog_id: Identifier for the Data Catalog. By default, it is the account ID of the caller.
        :param str database_name: Name of the database for the table. Unique to a Data Catalog.
               
               The following arguments are optional:
        :param str name: Name of the table. At least one of `name` or `wildcard` is required.
        :param bool wildcard: Whether to use a wildcard representing every table under a database. At least one of `name` or `wildcard` is required. Defaults to `false`.
        """
        pulumi.set(__self__, "catalog_id", catalog_id)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "name", name)
        if wildcard is not None:
            pulumi.set(__self__, "wildcard", wildcard)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> str:
        """
        Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        Name of the database for the table. Unique to a Data Catalog.

        The following arguments are optional:
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the table. At least one of `name` or `wildcard` is required.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def wildcard(self) -> Optional[bool]:
        """
        Whether to use a wildcard representing every table under a database. At least one of `name` or `wildcard` is required. Defaults to `false`.
        """
        return pulumi.get(self, "wildcard")


@pulumi.output_type
class GetPermissionsTableWithColumnsResult(dict):
    def __init__(__self__, *,
                 catalog_id: str,
                 database_name: str,
                 name: str,
                 column_names: Optional[Sequence[str]] = None,
                 excluded_column_names: Optional[Sequence[str]] = None,
                 wildcard: Optional[bool] = None):
        """
        :param str catalog_id: Identifier for the Data Catalog. By default, it is the account ID of the caller.
        :param str database_name: Name of the database for the table with columns resource. Unique to the Data Catalog.
        :param str name: Name of the table resource.
               
               The following arguments are optional:
        :param Sequence[str] column_names: Set of column names for the table. At least one of `column_names` or `excluded_column_names` is required.
        :param Sequence[str] excluded_column_names: Set of column names for the table to exclude. At least one of `column_names` or `excluded_column_names` is required.
        :param bool wildcard: Whether to use a wildcard representing every table under a database. At least one of `name` or `wildcard` is required. Defaults to `false`.
        """
        pulumi.set(__self__, "catalog_id", catalog_id)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "name", name)
        if column_names is not None:
            pulumi.set(__self__, "column_names", column_names)
        if excluded_column_names is not None:
            pulumi.set(__self__, "excluded_column_names", excluded_column_names)
        if wildcard is not None:
            pulumi.set(__self__, "wildcard", wildcard)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> str:
        """
        Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        Name of the database for the table with columns resource. Unique to the Data Catalog.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the table resource.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="columnNames")
    def column_names(self) -> Optional[Sequence[str]]:
        """
        Set of column names for the table. At least one of `column_names` or `excluded_column_names` is required.
        """
        return pulumi.get(self, "column_names")

    @property
    @pulumi.getter(name="excludedColumnNames")
    def excluded_column_names(self) -> Optional[Sequence[str]]:
        """
        Set of column names for the table to exclude. At least one of `column_names` or `excluded_column_names` is required.
        """
        return pulumi.get(self, "excluded_column_names")

    @property
    @pulumi.getter
    def wildcard(self) -> Optional[bool]:
        """
        Whether to use a wildcard representing every table under a database. At least one of `name` or `wildcard` is required. Defaults to `false`.
        """
        return pulumi.get(self, "wildcard")


