# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['FunctionArgs', 'Function']

@pulumi.input_type
class FunctionArgs:
    def __init__(__self__, *,
                 role: pulumi.Input[str],
                 architectures: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 code: Optional[pulumi.Input[pulumi.Archive]] = None,
                 code_signing_config_arn: Optional[pulumi.Input[str]] = None,
                 dead_letter_config: Optional[pulumi.Input['FunctionDeadLetterConfigArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input['FunctionEnvironmentArgs']] = None,
                 ephemeral_storage: Optional[pulumi.Input['FunctionEphemeralStorageArgs']] = None,
                 file_system_config: Optional[pulumi.Input['FunctionFileSystemConfigArgs']] = None,
                 handler: Optional[pulumi.Input[str]] = None,
                 image_config: Optional[pulumi.Input['FunctionImageConfigArgs']] = None,
                 image_uri: Optional[pulumi.Input[str]] = None,
                 kms_key_arn: Optional[pulumi.Input[str]] = None,
                 layers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 memory_size: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 package_type: Optional[pulumi.Input[str]] = None,
                 publish: Optional[pulumi.Input[bool]] = None,
                 replace_security_groups_on_destroy: Optional[pulumi.Input[bool]] = None,
                 replacement_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 reserved_concurrent_executions: Optional[pulumi.Input[int]] = None,
                 runtime: Optional[pulumi.Input[Union[str, 'Runtime']]] = None,
                 s3_bucket: Optional[pulumi.Input[str]] = None,
                 s3_key: Optional[pulumi.Input[str]] = None,
                 s3_object_version: Optional[pulumi.Input[str]] = None,
                 skip_destroy: Optional[pulumi.Input[bool]] = None,
                 snap_start: Optional[pulumi.Input['FunctionSnapStartArgs']] = None,
                 source_code_hash: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 tracing_config: Optional[pulumi.Input['FunctionTracingConfigArgs']] = None,
                 vpc_config: Optional[pulumi.Input['FunctionVpcConfigArgs']] = None):
        """
        The set of arguments for constructing a Function resource.
        :param pulumi.Input[str] role: Amazon Resource Name (ARN) of the function's execution role. The role provides the function's identity and access to AWS services and resources.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input[str]]] architectures: Instruction set architecture for your Lambda function. Valid values are `["x86_64"]` and `["arm64"]`. Default is `["x86_64"]`. Removing this attribute, function's architecture stay the same.
        :param pulumi.Input[pulumi.Archive] code: Path to the function's deployment package within the local filesystem. Exactly one of `filename`, `image_uri`, or `s3_bucket` must be specified.
        :param pulumi.Input[str] code_signing_config_arn: To enable code signing for this function, specify the ARN of a code-signing configuration. A code-signing configuration includes a set of signing profiles, which define the trusted publishers for this function.
        :param pulumi.Input['FunctionDeadLetterConfigArgs'] dead_letter_config: Configuration block. Detailed below.
        :param pulumi.Input[str] description: Description of what your Lambda Function does.
        :param pulumi.Input['FunctionEnvironmentArgs'] environment: Configuration block. Detailed below.
        :param pulumi.Input['FunctionEphemeralStorageArgs'] ephemeral_storage: The amount of Ephemeral storage(`/tmp`) to allocate for the Lambda Function in MB. This parameter is used to expand the total amount of Ephemeral storage available, beyond the default amount of `512`MB. Detailed below.
        :param pulumi.Input['FunctionFileSystemConfigArgs'] file_system_config: Configuration block. Detailed below.
        :param pulumi.Input[str] handler: Function [entrypoint](https://docs.aws.amazon.com/lambda/latest/dg/walkthrough-custom-events-create-test-function.html) in your code.
        :param pulumi.Input['FunctionImageConfigArgs'] image_config: Configuration block. Detailed below.
        :param pulumi.Input[str] image_uri: ECR image URI containing the function's deployment package. Exactly one of `filename`, `image_uri`,  or `s3_bucket` must be specified.
        :param pulumi.Input[str] kms_key_arn: Amazon Resource Name (ARN) of the AWS Key Management Service (KMS) key that is used to encrypt environment variables. If this configuration is not provided when environment variables are in use, AWS Lambda uses a default service key. If this configuration is provided when environment variables are not in use, the AWS Lambda API does not save this configuration and the provider will show a perpetual difference of adding the key. To fix the perpetual difference, remove this configuration.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] layers: List of Lambda Layer Version ARNs (maximum of 5) to attach to your Lambda Function. See [Lambda Layers](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html)
        :param pulumi.Input[int] memory_size: Amount of memory in MB your Lambda Function can use at runtime. Defaults to `128`. See [Limits](https://docs.aws.amazon.com/lambda/latest/dg/limits.html)
        :param pulumi.Input[str] name: Unique name for your Lambda Function.
        :param pulumi.Input[str] package_type: Lambda deployment package type. Valid values are `Zip` and `Image`. Defaults to `Zip`.
        :param pulumi.Input[bool] publish: Whether to publish creation/change as new Lambda Function Version. Defaults to `false`.
        :param pulumi.Input[bool] replace_security_groups_on_destroy: **AWS no longer supports this operation. This attribute now has no effect and will be removed in a future major version.** Whether to replace the security groups on associated lambda network interfaces upon destruction. Removing these security groups from orphaned network interfaces can speed up security group deletion times by avoiding a dependency on AWS's internal cleanup operations. By default, the ENI security groups will be replaced with the `default` security group in the function's VPC. Set the `replacement_security_group_ids` attribute to use a custom list of security groups for replacement.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] replacement_security_group_ids: List of security group IDs to assign to orphaned Lambda function network interfaces upon destruction. `replace_security_groups_on_destroy` must be set to `true` to use this attribute.
        :param pulumi.Input[int] reserved_concurrent_executions: Amount of reserved concurrent executions for this lambda function. A value of `0` disables lambda from being triggered and `-1` removes any concurrency limitations. Defaults to Unreserved Concurrency Limits `-1`. See [Managing Concurrency](https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html)
        :param pulumi.Input[Union[str, 'Runtime']] runtime: Identifier of the function's runtime. See [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_CreateFunction.html#SSS-CreateFunction-request-Runtime) for valid values.
        :param pulumi.Input[str] s3_bucket: S3 bucket location containing the function's deployment package. This bucket must reside in the same AWS region where you are creating the Lambda function. Exactly one of `filename`, `image_uri`, or `s3_bucket` must be specified. When `s3_bucket` is set, `s3_key` is required.
        :param pulumi.Input[str] s3_key: S3 key of an object containing the function's deployment package. When `s3_bucket` is set, `s3_key` is required.
        :param pulumi.Input[str] s3_object_version: Object version containing the function's deployment package. Conflicts with `filename` and `image_uri`.
        :param pulumi.Input[bool] skip_destroy: Set to true if you do not wish the function to be deleted at destroy time, and instead just remove the function from the Pulumi state.
        :param pulumi.Input['FunctionSnapStartArgs'] snap_start: Snap start settings block. Detailed below.
        :param pulumi.Input[str] source_code_hash: Used to trigger updates. Must be set to a base64-encoded SHA256 hash of the package file specified with either `filename` or `s3_key`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[int] timeout: Amount of time your Lambda Function has to run in seconds. Defaults to `3`. See [Limits](https://docs.aws.amazon.com/lambda/latest/dg/limits.html).
        :param pulumi.Input['FunctionTracingConfigArgs'] tracing_config: Configuration block. Detailed below.
        :param pulumi.Input['FunctionVpcConfigArgs'] vpc_config: Configuration block. Detailed below.
        """
        pulumi.set(__self__, "role", role)
        if architectures is not None:
            pulumi.set(__self__, "architectures", architectures)
        if code is not None:
            pulumi.set(__self__, "code", code)
        if code_signing_config_arn is not None:
            pulumi.set(__self__, "code_signing_config_arn", code_signing_config_arn)
        if dead_letter_config is not None:
            pulumi.set(__self__, "dead_letter_config", dead_letter_config)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if ephemeral_storage is not None:
            pulumi.set(__self__, "ephemeral_storage", ephemeral_storage)
        if file_system_config is not None:
            pulumi.set(__self__, "file_system_config", file_system_config)
        if handler is not None:
            pulumi.set(__self__, "handler", handler)
        if image_config is not None:
            pulumi.set(__self__, "image_config", image_config)
        if image_uri is not None:
            pulumi.set(__self__, "image_uri", image_uri)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if layers is not None:
            pulumi.set(__self__, "layers", layers)
        if memory_size is not None:
            pulumi.set(__self__, "memory_size", memory_size)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if package_type is not None:
            pulumi.set(__self__, "package_type", package_type)
        if publish is not None:
            pulumi.set(__self__, "publish", publish)
        if replace_security_groups_on_destroy is not None:
            warnings.warn("""AWS no longer supports this operation. This attribute now has no effect and will be removed in a future major version.""", DeprecationWarning)
            pulumi.log.warn("""replace_security_groups_on_destroy is deprecated: AWS no longer supports this operation. This attribute now has no effect and will be removed in a future major version.""")
        if replace_security_groups_on_destroy is not None:
            pulumi.set(__self__, "replace_security_groups_on_destroy", replace_security_groups_on_destroy)
        if replacement_security_group_ids is not None:
            warnings.warn("""AWS no longer supports this operation. This attribute now has no effect and will be removed in a future major version.""", DeprecationWarning)
            pulumi.log.warn("""replacement_security_group_ids is deprecated: AWS no longer supports this operation. This attribute now has no effect and will be removed in a future major version.""")
        if replacement_security_group_ids is not None:
            pulumi.set(__self__, "replacement_security_group_ids", replacement_security_group_ids)
        if reserved_concurrent_executions is not None:
            pulumi.set(__self__, "reserved_concurrent_executions", reserved_concurrent_executions)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if s3_bucket is not None:
            pulumi.set(__self__, "s3_bucket", s3_bucket)
        if s3_key is not None:
            pulumi.set(__self__, "s3_key", s3_key)
        if s3_object_version is not None:
            pulumi.set(__self__, "s3_object_version", s3_object_version)
        if skip_destroy is not None:
            pulumi.set(__self__, "skip_destroy", skip_destroy)
        if snap_start is not None:
            pulumi.set(__self__, "snap_start", snap_start)
        if source_code_hash is not None:
            pulumi.set(__self__, "source_code_hash", source_code_hash)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if tracing_config is not None:
            pulumi.set(__self__, "tracing_config", tracing_config)
        if vpc_config is not None:
            pulumi.set(__self__, "vpc_config", vpc_config)

    @property
    @pulumi.getter
    def role(self) -> pulumi.Input[str]:
        """
        Amazon Resource Name (ARN) of the function's execution role. The role provides the function's identity and access to AWS services and resources.

        The following arguments are optional:
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[str]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter
    def architectures(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Instruction set architecture for your Lambda function. Valid values are `["x86_64"]` and `["arm64"]`. Default is `["x86_64"]`. Removing this attribute, function's architecture stay the same.
        """
        return pulumi.get(self, "architectures")

    @architectures.setter
    def architectures(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "architectures", value)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[pulumi.Archive]]:
        """
        Path to the function's deployment package within the local filesystem. Exactly one of `filename`, `image_uri`, or `s3_bucket` must be specified.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[pulumi.Archive]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter(name="codeSigningConfigArn")
    def code_signing_config_arn(self) -> Optional[pulumi.Input[str]]:
        """
        To enable code signing for this function, specify the ARN of a code-signing configuration. A code-signing configuration includes a set of signing profiles, which define the trusted publishers for this function.
        """
        return pulumi.get(self, "code_signing_config_arn")

    @code_signing_config_arn.setter
    def code_signing_config_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "code_signing_config_arn", value)

    @property
    @pulumi.getter(name="deadLetterConfig")
    def dead_letter_config(self) -> Optional[pulumi.Input['FunctionDeadLetterConfigArgs']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "dead_letter_config")

    @dead_letter_config.setter
    def dead_letter_config(self, value: Optional[pulumi.Input['FunctionDeadLetterConfigArgs']]):
        pulumi.set(self, "dead_letter_config", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of what your Lambda Function does.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input['FunctionEnvironmentArgs']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input['FunctionEnvironmentArgs']]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> Optional[pulumi.Input['FunctionEphemeralStorageArgs']]:
        """
        The amount of Ephemeral storage(`/tmp`) to allocate for the Lambda Function in MB. This parameter is used to expand the total amount of Ephemeral storage available, beyond the default amount of `512`MB. Detailed below.
        """
        return pulumi.get(self, "ephemeral_storage")

    @ephemeral_storage.setter
    def ephemeral_storage(self, value: Optional[pulumi.Input['FunctionEphemeralStorageArgs']]):
        pulumi.set(self, "ephemeral_storage", value)

    @property
    @pulumi.getter(name="fileSystemConfig")
    def file_system_config(self) -> Optional[pulumi.Input['FunctionFileSystemConfigArgs']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "file_system_config")

    @file_system_config.setter
    def file_system_config(self, value: Optional[pulumi.Input['FunctionFileSystemConfigArgs']]):
        pulumi.set(self, "file_system_config", value)

    @property
    @pulumi.getter
    def handler(self) -> Optional[pulumi.Input[str]]:
        """
        Function [entrypoint](https://docs.aws.amazon.com/lambda/latest/dg/walkthrough-custom-events-create-test-function.html) in your code.
        """
        return pulumi.get(self, "handler")

    @handler.setter
    def handler(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "handler", value)

    @property
    @pulumi.getter(name="imageConfig")
    def image_config(self) -> Optional[pulumi.Input['FunctionImageConfigArgs']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "image_config")

    @image_config.setter
    def image_config(self, value: Optional[pulumi.Input['FunctionImageConfigArgs']]):
        pulumi.set(self, "image_config", value)

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> Optional[pulumi.Input[str]]:
        """
        ECR image URI containing the function's deployment package. Exactly one of `filename`, `image_uri`,  or `s3_bucket` must be specified.
        """
        return pulumi.get(self, "image_uri")

    @image_uri.setter
    def image_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_uri", value)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) of the AWS Key Management Service (KMS) key that is used to encrypt environment variables. If this configuration is not provided when environment variables are in use, AWS Lambda uses a default service key. If this configuration is provided when environment variables are not in use, the AWS Lambda API does not save this configuration and the provider will show a perpetual difference of adding the key. To fix the perpetual difference, remove this configuration.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_arn", value)

    @property
    @pulumi.getter
    def layers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of Lambda Layer Version ARNs (maximum of 5) to attach to your Lambda Function. See [Lambda Layers](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html)
        """
        return pulumi.get(self, "layers")

    @layers.setter
    def layers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "layers", value)

    @property
    @pulumi.getter(name="memorySize")
    def memory_size(self) -> Optional[pulumi.Input[int]]:
        """
        Amount of memory in MB your Lambda Function can use at runtime. Defaults to `128`. See [Limits](https://docs.aws.amazon.com/lambda/latest/dg/limits.html)
        """
        return pulumi.get(self, "memory_size")

    @memory_size.setter
    def memory_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_size", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name for your Lambda Function.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="packageType")
    def package_type(self) -> Optional[pulumi.Input[str]]:
        """
        Lambda deployment package type. Valid values are `Zip` and `Image`. Defaults to `Zip`.
        """
        return pulumi.get(self, "package_type")

    @package_type.setter
    def package_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "package_type", value)

    @property
    @pulumi.getter
    def publish(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to publish creation/change as new Lambda Function Version. Defaults to `false`.
        """
        return pulumi.get(self, "publish")

    @publish.setter
    def publish(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "publish", value)

    @property
    @pulumi.getter(name="replaceSecurityGroupsOnDestroy")
    def replace_security_groups_on_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        **AWS no longer supports this operation. This attribute now has no effect and will be removed in a future major version.** Whether to replace the security groups on associated lambda network interfaces upon destruction. Removing these security groups from orphaned network interfaces can speed up security group deletion times by avoiding a dependency on AWS's internal cleanup operations. By default, the ENI security groups will be replaced with the `default` security group in the function's VPC. Set the `replacement_security_group_ids` attribute to use a custom list of security groups for replacement.
        """
        warnings.warn("""AWS no longer supports this operation. This attribute now has no effect and will be removed in a future major version.""", DeprecationWarning)
        pulumi.log.warn("""replace_security_groups_on_destroy is deprecated: AWS no longer supports this operation. This attribute now has no effect and will be removed in a future major version.""")

        return pulumi.get(self, "replace_security_groups_on_destroy")

    @replace_security_groups_on_destroy.setter
    def replace_security_groups_on_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "replace_security_groups_on_destroy", value)

    @property
    @pulumi.getter(name="replacementSecurityGroupIds")
    def replacement_security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of security group IDs to assign to orphaned Lambda function network interfaces upon destruction. `replace_security_groups_on_destroy` must be set to `true` to use this attribute.
        """
        warnings.warn("""AWS no longer supports this operation. This attribute now has no effect and will be removed in a future major version.""", DeprecationWarning)
        pulumi.log.warn("""replacement_security_group_ids is deprecated: AWS no longer supports this operation. This attribute now has no effect and will be removed in a future major version.""")

        return pulumi.get(self, "replacement_security_group_ids")

    @replacement_security_group_ids.setter
    def replacement_security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "replacement_security_group_ids", value)

    @property
    @pulumi.getter(name="reservedConcurrentExecutions")
    def reserved_concurrent_executions(self) -> Optional[pulumi.Input[int]]:
        """
        Amount of reserved concurrent executions for this lambda function. A value of `0` disables lambda from being triggered and `-1` removes any concurrency limitations. Defaults to Unreserved Concurrency Limits `-1`. See [Managing Concurrency](https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html)
        """
        return pulumi.get(self, "reserved_concurrent_executions")

    @reserved_concurrent_executions.setter
    def reserved_concurrent_executions(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "reserved_concurrent_executions", value)

    @property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input[Union[str, 'Runtime']]]:
        """
        Identifier of the function's runtime. See [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_CreateFunction.html#SSS-CreateFunction-request-Runtime) for valid values.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input[Union[str, 'Runtime']]]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> Optional[pulumi.Input[str]]:
        """
        S3 bucket location containing the function's deployment package. This bucket must reside in the same AWS region where you are creating the Lambda function. Exactly one of `filename`, `image_uri`, or `s3_bucket` must be specified. When `s3_bucket` is set, `s3_key` is required.
        """
        return pulumi.get(self, "s3_bucket")

    @s3_bucket.setter
    def s3_bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3_bucket", value)

    @property
    @pulumi.getter(name="s3Key")
    def s3_key(self) -> Optional[pulumi.Input[str]]:
        """
        S3 key of an object containing the function's deployment package. When `s3_bucket` is set, `s3_key` is required.
        """
        return pulumi.get(self, "s3_key")

    @s3_key.setter
    def s3_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3_key", value)

    @property
    @pulumi.getter(name="s3ObjectVersion")
    def s3_object_version(self) -> Optional[pulumi.Input[str]]:
        """
        Object version containing the function's deployment package. Conflicts with `filename` and `image_uri`.
        """
        return pulumi.get(self, "s3_object_version")

    @s3_object_version.setter
    def s3_object_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3_object_version", value)

    @property
    @pulumi.getter(name="skipDestroy")
    def skip_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true if you do not wish the function to be deleted at destroy time, and instead just remove the function from the Pulumi state.
        """
        return pulumi.get(self, "skip_destroy")

    @skip_destroy.setter
    def skip_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_destroy", value)

    @property
    @pulumi.getter(name="snapStart")
    def snap_start(self) -> Optional[pulumi.Input['FunctionSnapStartArgs']]:
        """
        Snap start settings block. Detailed below.
        """
        return pulumi.get(self, "snap_start")

    @snap_start.setter
    def snap_start(self, value: Optional[pulumi.Input['FunctionSnapStartArgs']]):
        pulumi.set(self, "snap_start", value)

    @property
    @pulumi.getter(name="sourceCodeHash")
    def source_code_hash(self) -> Optional[pulumi.Input[str]]:
        """
        Used to trigger updates. Must be set to a base64-encoded SHA256 hash of the package file specified with either `filename` or `s3_key`.
        """
        return pulumi.get(self, "source_code_hash")

    @source_code_hash.setter
    def source_code_hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_code_hash", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Amount of time your Lambda Function has to run in seconds. Defaults to `3`. See [Limits](https://docs.aws.amazon.com/lambda/latest/dg/limits.html).
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="tracingConfig")
    def tracing_config(self) -> Optional[pulumi.Input['FunctionTracingConfigArgs']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "tracing_config")

    @tracing_config.setter
    def tracing_config(self, value: Optional[pulumi.Input['FunctionTracingConfigArgs']]):
        pulumi.set(self, "tracing_config", value)

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> Optional[pulumi.Input['FunctionVpcConfigArgs']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "vpc_config")

    @vpc_config.setter
    def vpc_config(self, value: Optional[pulumi.Input['FunctionVpcConfigArgs']]):
        pulumi.set(self, "vpc_config", value)


@pulumi.input_type
class _FunctionState:
    def __init__(__self__, *,
                 architectures: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 code: Optional[pulumi.Input[pulumi.Archive]] = None,
                 code_signing_config_arn: Optional[pulumi.Input[str]] = None,
                 dead_letter_config: Optional[pulumi.Input['FunctionDeadLetterConfigArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input['FunctionEnvironmentArgs']] = None,
                 ephemeral_storage: Optional[pulumi.Input['FunctionEphemeralStorageArgs']] = None,
                 file_system_config: Optional[pulumi.Input['FunctionFileSystemConfigArgs']] = None,
                 handler: Optional[pulumi.Input[str]] = None,
                 image_config: Optional[pulumi.Input['FunctionImageConfigArgs']] = None,
                 image_uri: Optional[pulumi.Input[str]] = None,
                 invoke_arn: Optional[pulumi.Input[str]] = None,
                 kms_key_arn: Optional[pulumi.Input[str]] = None,
                 last_modified: Optional[pulumi.Input[str]] = None,
                 layers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 memory_size: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 package_type: Optional[pulumi.Input[str]] = None,
                 publish: Optional[pulumi.Input[bool]] = None,
                 qualified_arn: Optional[pulumi.Input[str]] = None,
                 qualified_invoke_arn: Optional[pulumi.Input[str]] = None,
                 replace_security_groups_on_destroy: Optional[pulumi.Input[bool]] = None,
                 replacement_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 reserved_concurrent_executions: Optional[pulumi.Input[int]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 runtime: Optional[pulumi.Input[Union[str, 'Runtime']]] = None,
                 s3_bucket: Optional[pulumi.Input[str]] = None,
                 s3_key: Optional[pulumi.Input[str]] = None,
                 s3_object_version: Optional[pulumi.Input[str]] = None,
                 signing_job_arn: Optional[pulumi.Input[str]] = None,
                 signing_profile_version_arn: Optional[pulumi.Input[str]] = None,
                 skip_destroy: Optional[pulumi.Input[bool]] = None,
                 snap_start: Optional[pulumi.Input['FunctionSnapStartArgs']] = None,
                 source_code_hash: Optional[pulumi.Input[str]] = None,
                 source_code_size: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 tracing_config: Optional[pulumi.Input['FunctionTracingConfigArgs']] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 vpc_config: Optional[pulumi.Input['FunctionVpcConfigArgs']] = None):
        """
        Input properties used for looking up and filtering Function resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] architectures: Instruction set architecture for your Lambda function. Valid values are `["x86_64"]` and `["arm64"]`. Default is `["x86_64"]`. Removing this attribute, function's architecture stay the same.
        :param pulumi.Input[str] arn: Amazon Resource Name (ARN) of the Amazon EFS Access Point that provides access to the file system.
        :param pulumi.Input[pulumi.Archive] code: Path to the function's deployment package within the local filesystem. Exactly one of `filename`, `image_uri`, or `s3_bucket` must be specified.
        :param pulumi.Input[str] code_signing_config_arn: To enable code signing for this function, specify the ARN of a code-signing configuration. A code-signing configuration includes a set of signing profiles, which define the trusted publishers for this function.
        :param pulumi.Input['FunctionDeadLetterConfigArgs'] dead_letter_config: Configuration block. Detailed below.
        :param pulumi.Input[str] description: Description of what your Lambda Function does.
        :param pulumi.Input['FunctionEnvironmentArgs'] environment: Configuration block. Detailed below.
        :param pulumi.Input['FunctionEphemeralStorageArgs'] ephemeral_storage: The amount of Ephemeral storage(`/tmp`) to allocate for the Lambda Function in MB. This parameter is used to expand the total amount of Ephemeral storage available, beyond the default amount of `512`MB. Detailed below.
        :param pulumi.Input['FunctionFileSystemConfigArgs'] file_system_config: Configuration block. Detailed below.
        :param pulumi.Input[str] handler: Function [entrypoint](https://docs.aws.amazon.com/lambda/latest/dg/walkthrough-custom-events-create-test-function.html) in your code.
        :param pulumi.Input['FunctionImageConfigArgs'] image_config: Configuration block. Detailed below.
        :param pulumi.Input[str] image_uri: ECR image URI containing the function's deployment package. Exactly one of `filename`, `image_uri`,  or `s3_bucket` must be specified.
        :param pulumi.Input[str] invoke_arn: ARN to be used for invoking Lambda Function from API Gateway - to be used in `apigateway.Integration`'s `uri`.
        :param pulumi.Input[str] kms_key_arn: Amazon Resource Name (ARN) of the AWS Key Management Service (KMS) key that is used to encrypt environment variables. If this configuration is not provided when environment variables are in use, AWS Lambda uses a default service key. If this configuration is provided when environment variables are not in use, the AWS Lambda API does not save this configuration and the provider will show a perpetual difference of adding the key. To fix the perpetual difference, remove this configuration.
        :param pulumi.Input[str] last_modified: Date this resource was last modified.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] layers: List of Lambda Layer Version ARNs (maximum of 5) to attach to your Lambda Function. See [Lambda Layers](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html)
        :param pulumi.Input[int] memory_size: Amount of memory in MB your Lambda Function can use at runtime. Defaults to `128`. See [Limits](https://docs.aws.amazon.com/lambda/latest/dg/limits.html)
        :param pulumi.Input[str] name: Unique name for your Lambda Function.
        :param pulumi.Input[str] package_type: Lambda deployment package type. Valid values are `Zip` and `Image`. Defaults to `Zip`.
        :param pulumi.Input[bool] publish: Whether to publish creation/change as new Lambda Function Version. Defaults to `false`.
        :param pulumi.Input[str] qualified_arn: ARN identifying your Lambda Function Version (if versioning is enabled via `publish = true`).
        :param pulumi.Input[str] qualified_invoke_arn: Qualified ARN (ARN with lambda version number) to be used for invoking Lambda Function from API Gateway - to be used in `apigateway.Integration`'s `uri`.
        :param pulumi.Input[bool] replace_security_groups_on_destroy: **AWS no longer supports this operation. This attribute now has no effect and will be removed in a future major version.** Whether to replace the security groups on associated lambda network interfaces upon destruction. Removing these security groups from orphaned network interfaces can speed up security group deletion times by avoiding a dependency on AWS's internal cleanup operations. By default, the ENI security groups will be replaced with the `default` security group in the function's VPC. Set the `replacement_security_group_ids` attribute to use a custom list of security groups for replacement.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] replacement_security_group_ids: List of security group IDs to assign to orphaned Lambda function network interfaces upon destruction. `replace_security_groups_on_destroy` must be set to `true` to use this attribute.
        :param pulumi.Input[int] reserved_concurrent_executions: Amount of reserved concurrent executions for this lambda function. A value of `0` disables lambda from being triggered and `-1` removes any concurrency limitations. Defaults to Unreserved Concurrency Limits `-1`. See [Managing Concurrency](https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html)
        :param pulumi.Input[str] role: Amazon Resource Name (ARN) of the function's execution role. The role provides the function's identity and access to AWS services and resources.
               
               The following arguments are optional:
        :param pulumi.Input[Union[str, 'Runtime']] runtime: Identifier of the function's runtime. See [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_CreateFunction.html#SSS-CreateFunction-request-Runtime) for valid values.
        :param pulumi.Input[str] s3_bucket: S3 bucket location containing the function's deployment package. This bucket must reside in the same AWS region where you are creating the Lambda function. Exactly one of `filename`, `image_uri`, or `s3_bucket` must be specified. When `s3_bucket` is set, `s3_key` is required.
        :param pulumi.Input[str] s3_key: S3 key of an object containing the function's deployment package. When `s3_bucket` is set, `s3_key` is required.
        :param pulumi.Input[str] s3_object_version: Object version containing the function's deployment package. Conflicts with `filename` and `image_uri`.
        :param pulumi.Input[str] signing_job_arn: ARN of the signing job.
        :param pulumi.Input[str] signing_profile_version_arn: ARN of the signing profile version.
               * `snap_start.optimization_status` - Optimization status of the snap start configuration. Valid values are `On` and `Off`.
        :param pulumi.Input[bool] skip_destroy: Set to true if you do not wish the function to be deleted at destroy time, and instead just remove the function from the Pulumi state.
        :param pulumi.Input['FunctionSnapStartArgs'] snap_start: Snap start settings block. Detailed below.
        :param pulumi.Input[str] source_code_hash: Used to trigger updates. Must be set to a base64-encoded SHA256 hash of the package file specified with either `filename` or `s3_key`.
        :param pulumi.Input[int] source_code_size: Size in bytes of the function .zip file.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[int] timeout: Amount of time your Lambda Function has to run in seconds. Defaults to `3`. See [Limits](https://docs.aws.amazon.com/lambda/latest/dg/limits.html).
        :param pulumi.Input['FunctionTracingConfigArgs'] tracing_config: Configuration block. Detailed below.
        :param pulumi.Input[str] version: Latest published version of your Lambda Function.
               * `vpc_config.vpc_id` - ID of the VPC.
        :param pulumi.Input['FunctionVpcConfigArgs'] vpc_config: Configuration block. Detailed below.
        """
        if architectures is not None:
            pulumi.set(__self__, "architectures", architectures)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if code is not None:
            pulumi.set(__self__, "code", code)
        if code_signing_config_arn is not None:
            pulumi.set(__self__, "code_signing_config_arn", code_signing_config_arn)
        if dead_letter_config is not None:
            pulumi.set(__self__, "dead_letter_config", dead_letter_config)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if ephemeral_storage is not None:
            pulumi.set(__self__, "ephemeral_storage", ephemeral_storage)
        if file_system_config is not None:
            pulumi.set(__self__, "file_system_config", file_system_config)
        if handler is not None:
            pulumi.set(__self__, "handler", handler)
        if image_config is not None:
            pulumi.set(__self__, "image_config", image_config)
        if image_uri is not None:
            pulumi.set(__self__, "image_uri", image_uri)
        if invoke_arn is not None:
            pulumi.set(__self__, "invoke_arn", invoke_arn)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if last_modified is not None:
            pulumi.set(__self__, "last_modified", last_modified)
        if layers is not None:
            pulumi.set(__self__, "layers", layers)
        if memory_size is not None:
            pulumi.set(__self__, "memory_size", memory_size)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if package_type is not None:
            pulumi.set(__self__, "package_type", package_type)
        if publish is not None:
            pulumi.set(__self__, "publish", publish)
        if qualified_arn is not None:
            pulumi.set(__self__, "qualified_arn", qualified_arn)
        if qualified_invoke_arn is not None:
            pulumi.set(__self__, "qualified_invoke_arn", qualified_invoke_arn)
        if replace_security_groups_on_destroy is not None:
            warnings.warn("""AWS no longer supports this operation. This attribute now has no effect and will be removed in a future major version.""", DeprecationWarning)
            pulumi.log.warn("""replace_security_groups_on_destroy is deprecated: AWS no longer supports this operation. This attribute now has no effect and will be removed in a future major version.""")
        if replace_security_groups_on_destroy is not None:
            pulumi.set(__self__, "replace_security_groups_on_destroy", replace_security_groups_on_destroy)
        if replacement_security_group_ids is not None:
            warnings.warn("""AWS no longer supports this operation. This attribute now has no effect and will be removed in a future major version.""", DeprecationWarning)
            pulumi.log.warn("""replacement_security_group_ids is deprecated: AWS no longer supports this operation. This attribute now has no effect and will be removed in a future major version.""")
        if replacement_security_group_ids is not None:
            pulumi.set(__self__, "replacement_security_group_ids", replacement_security_group_ids)
        if reserved_concurrent_executions is not None:
            pulumi.set(__self__, "reserved_concurrent_executions", reserved_concurrent_executions)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if s3_bucket is not None:
            pulumi.set(__self__, "s3_bucket", s3_bucket)
        if s3_key is not None:
            pulumi.set(__self__, "s3_key", s3_key)
        if s3_object_version is not None:
            pulumi.set(__self__, "s3_object_version", s3_object_version)
        if signing_job_arn is not None:
            pulumi.set(__self__, "signing_job_arn", signing_job_arn)
        if signing_profile_version_arn is not None:
            pulumi.set(__self__, "signing_profile_version_arn", signing_profile_version_arn)
        if skip_destroy is not None:
            pulumi.set(__self__, "skip_destroy", skip_destroy)
        if snap_start is not None:
            pulumi.set(__self__, "snap_start", snap_start)
        if source_code_hash is not None:
            pulumi.set(__self__, "source_code_hash", source_code_hash)
        if source_code_size is not None:
            pulumi.set(__self__, "source_code_size", source_code_size)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if tracing_config is not None:
            pulumi.set(__self__, "tracing_config", tracing_config)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if vpc_config is not None:
            pulumi.set(__self__, "vpc_config", vpc_config)

    @property
    @pulumi.getter
    def architectures(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Instruction set architecture for your Lambda function. Valid values are `["x86_64"]` and `["arm64"]`. Default is `["x86_64"]`. Removing this attribute, function's architecture stay the same.
        """
        return pulumi.get(self, "architectures")

    @architectures.setter
    def architectures(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "architectures", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) of the Amazon EFS Access Point that provides access to the file system.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[pulumi.Archive]]:
        """
        Path to the function's deployment package within the local filesystem. Exactly one of `filename`, `image_uri`, or `s3_bucket` must be specified.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[pulumi.Archive]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter(name="codeSigningConfigArn")
    def code_signing_config_arn(self) -> Optional[pulumi.Input[str]]:
        """
        To enable code signing for this function, specify the ARN of a code-signing configuration. A code-signing configuration includes a set of signing profiles, which define the trusted publishers for this function.
        """
        return pulumi.get(self, "code_signing_config_arn")

    @code_signing_config_arn.setter
    def code_signing_config_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "code_signing_config_arn", value)

    @property
    @pulumi.getter(name="deadLetterConfig")
    def dead_letter_config(self) -> Optional[pulumi.Input['FunctionDeadLetterConfigArgs']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "dead_letter_config")

    @dead_letter_config.setter
    def dead_letter_config(self, value: Optional[pulumi.Input['FunctionDeadLetterConfigArgs']]):
        pulumi.set(self, "dead_letter_config", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of what your Lambda Function does.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input['FunctionEnvironmentArgs']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input['FunctionEnvironmentArgs']]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> Optional[pulumi.Input['FunctionEphemeralStorageArgs']]:
        """
        The amount of Ephemeral storage(`/tmp`) to allocate for the Lambda Function in MB. This parameter is used to expand the total amount of Ephemeral storage available, beyond the default amount of `512`MB. Detailed below.
        """
        return pulumi.get(self, "ephemeral_storage")

    @ephemeral_storage.setter
    def ephemeral_storage(self, value: Optional[pulumi.Input['FunctionEphemeralStorageArgs']]):
        pulumi.set(self, "ephemeral_storage", value)

    @property
    @pulumi.getter(name="fileSystemConfig")
    def file_system_config(self) -> Optional[pulumi.Input['FunctionFileSystemConfigArgs']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "file_system_config")

    @file_system_config.setter
    def file_system_config(self, value: Optional[pulumi.Input['FunctionFileSystemConfigArgs']]):
        pulumi.set(self, "file_system_config", value)

    @property
    @pulumi.getter
    def handler(self) -> Optional[pulumi.Input[str]]:
        """
        Function [entrypoint](https://docs.aws.amazon.com/lambda/latest/dg/walkthrough-custom-events-create-test-function.html) in your code.
        """
        return pulumi.get(self, "handler")

    @handler.setter
    def handler(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "handler", value)

    @property
    @pulumi.getter(name="imageConfig")
    def image_config(self) -> Optional[pulumi.Input['FunctionImageConfigArgs']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "image_config")

    @image_config.setter
    def image_config(self, value: Optional[pulumi.Input['FunctionImageConfigArgs']]):
        pulumi.set(self, "image_config", value)

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> Optional[pulumi.Input[str]]:
        """
        ECR image URI containing the function's deployment package. Exactly one of `filename`, `image_uri`,  or `s3_bucket` must be specified.
        """
        return pulumi.get(self, "image_uri")

    @image_uri.setter
    def image_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_uri", value)

    @property
    @pulumi.getter(name="invokeArn")
    def invoke_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN to be used for invoking Lambda Function from API Gateway - to be used in `apigateway.Integration`'s `uri`.
        """
        return pulumi.get(self, "invoke_arn")

    @invoke_arn.setter
    def invoke_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "invoke_arn", value)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) of the AWS Key Management Service (KMS) key that is used to encrypt environment variables. If this configuration is not provided when environment variables are in use, AWS Lambda uses a default service key. If this configuration is provided when environment variables are not in use, the AWS Lambda API does not save this configuration and the provider will show a perpetual difference of adding the key. To fix the perpetual difference, remove this configuration.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_arn", value)

    @property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> Optional[pulumi.Input[str]]:
        """
        Date this resource was last modified.
        """
        return pulumi.get(self, "last_modified")

    @last_modified.setter
    def last_modified(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_modified", value)

    @property
    @pulumi.getter
    def layers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of Lambda Layer Version ARNs (maximum of 5) to attach to your Lambda Function. See [Lambda Layers](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html)
        """
        return pulumi.get(self, "layers")

    @layers.setter
    def layers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "layers", value)

    @property
    @pulumi.getter(name="memorySize")
    def memory_size(self) -> Optional[pulumi.Input[int]]:
        """
        Amount of memory in MB your Lambda Function can use at runtime. Defaults to `128`. See [Limits](https://docs.aws.amazon.com/lambda/latest/dg/limits.html)
        """
        return pulumi.get(self, "memory_size")

    @memory_size.setter
    def memory_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_size", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name for your Lambda Function.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="packageType")
    def package_type(self) -> Optional[pulumi.Input[str]]:
        """
        Lambda deployment package type. Valid values are `Zip` and `Image`. Defaults to `Zip`.
        """
        return pulumi.get(self, "package_type")

    @package_type.setter
    def package_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "package_type", value)

    @property
    @pulumi.getter
    def publish(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to publish creation/change as new Lambda Function Version. Defaults to `false`.
        """
        return pulumi.get(self, "publish")

    @publish.setter
    def publish(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "publish", value)

    @property
    @pulumi.getter(name="qualifiedArn")
    def qualified_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN identifying your Lambda Function Version (if versioning is enabled via `publish = true`).
        """
        return pulumi.get(self, "qualified_arn")

    @qualified_arn.setter
    def qualified_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "qualified_arn", value)

    @property
    @pulumi.getter(name="qualifiedInvokeArn")
    def qualified_invoke_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Qualified ARN (ARN with lambda version number) to be used for invoking Lambda Function from API Gateway - to be used in `apigateway.Integration`'s `uri`.
        """
        return pulumi.get(self, "qualified_invoke_arn")

    @qualified_invoke_arn.setter
    def qualified_invoke_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "qualified_invoke_arn", value)

    @property
    @pulumi.getter(name="replaceSecurityGroupsOnDestroy")
    def replace_security_groups_on_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        **AWS no longer supports this operation. This attribute now has no effect and will be removed in a future major version.** Whether to replace the security groups on associated lambda network interfaces upon destruction. Removing these security groups from orphaned network interfaces can speed up security group deletion times by avoiding a dependency on AWS's internal cleanup operations. By default, the ENI security groups will be replaced with the `default` security group in the function's VPC. Set the `replacement_security_group_ids` attribute to use a custom list of security groups for replacement.
        """
        warnings.warn("""AWS no longer supports this operation. This attribute now has no effect and will be removed in a future major version.""", DeprecationWarning)
        pulumi.log.warn("""replace_security_groups_on_destroy is deprecated: AWS no longer supports this operation. This attribute now has no effect and will be removed in a future major version.""")

        return pulumi.get(self, "replace_security_groups_on_destroy")

    @replace_security_groups_on_destroy.setter
    def replace_security_groups_on_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "replace_security_groups_on_destroy", value)

    @property
    @pulumi.getter(name="replacementSecurityGroupIds")
    def replacement_security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of security group IDs to assign to orphaned Lambda function network interfaces upon destruction. `replace_security_groups_on_destroy` must be set to `true` to use this attribute.
        """
        warnings.warn("""AWS no longer supports this operation. This attribute now has no effect and will be removed in a future major version.""", DeprecationWarning)
        pulumi.log.warn("""replacement_security_group_ids is deprecated: AWS no longer supports this operation. This attribute now has no effect and will be removed in a future major version.""")

        return pulumi.get(self, "replacement_security_group_ids")

    @replacement_security_group_ids.setter
    def replacement_security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "replacement_security_group_ids", value)

    @property
    @pulumi.getter(name="reservedConcurrentExecutions")
    def reserved_concurrent_executions(self) -> Optional[pulumi.Input[int]]:
        """
        Amount of reserved concurrent executions for this lambda function. A value of `0` disables lambda from being triggered and `-1` removes any concurrency limitations. Defaults to Unreserved Concurrency Limits `-1`. See [Managing Concurrency](https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html)
        """
        return pulumi.get(self, "reserved_concurrent_executions")

    @reserved_concurrent_executions.setter
    def reserved_concurrent_executions(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "reserved_concurrent_executions", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) of the function's execution role. The role provides the function's identity and access to AWS services and resources.

        The following arguments are optional:
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input[Union[str, 'Runtime']]]:
        """
        Identifier of the function's runtime. See [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_CreateFunction.html#SSS-CreateFunction-request-Runtime) for valid values.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input[Union[str, 'Runtime']]]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> Optional[pulumi.Input[str]]:
        """
        S3 bucket location containing the function's deployment package. This bucket must reside in the same AWS region where you are creating the Lambda function. Exactly one of `filename`, `image_uri`, or `s3_bucket` must be specified. When `s3_bucket` is set, `s3_key` is required.
        """
        return pulumi.get(self, "s3_bucket")

    @s3_bucket.setter
    def s3_bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3_bucket", value)

    @property
    @pulumi.getter(name="s3Key")
    def s3_key(self) -> Optional[pulumi.Input[str]]:
        """
        S3 key of an object containing the function's deployment package. When `s3_bucket` is set, `s3_key` is required.
        """
        return pulumi.get(self, "s3_key")

    @s3_key.setter
    def s3_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3_key", value)

    @property
    @pulumi.getter(name="s3ObjectVersion")
    def s3_object_version(self) -> Optional[pulumi.Input[str]]:
        """
        Object version containing the function's deployment package. Conflicts with `filename` and `image_uri`.
        """
        return pulumi.get(self, "s3_object_version")

    @s3_object_version.setter
    def s3_object_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3_object_version", value)

    @property
    @pulumi.getter(name="signingJobArn")
    def signing_job_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the signing job.
        """
        return pulumi.get(self, "signing_job_arn")

    @signing_job_arn.setter
    def signing_job_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signing_job_arn", value)

    @property
    @pulumi.getter(name="signingProfileVersionArn")
    def signing_profile_version_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the signing profile version.
        * `snap_start.optimization_status` - Optimization status of the snap start configuration. Valid values are `On` and `Off`.
        """
        return pulumi.get(self, "signing_profile_version_arn")

    @signing_profile_version_arn.setter
    def signing_profile_version_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signing_profile_version_arn", value)

    @property
    @pulumi.getter(name="skipDestroy")
    def skip_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true if you do not wish the function to be deleted at destroy time, and instead just remove the function from the Pulumi state.
        """
        return pulumi.get(self, "skip_destroy")

    @skip_destroy.setter
    def skip_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_destroy", value)

    @property
    @pulumi.getter(name="snapStart")
    def snap_start(self) -> Optional[pulumi.Input['FunctionSnapStartArgs']]:
        """
        Snap start settings block. Detailed below.
        """
        return pulumi.get(self, "snap_start")

    @snap_start.setter
    def snap_start(self, value: Optional[pulumi.Input['FunctionSnapStartArgs']]):
        pulumi.set(self, "snap_start", value)

    @property
    @pulumi.getter(name="sourceCodeHash")
    def source_code_hash(self) -> Optional[pulumi.Input[str]]:
        """
        Used to trigger updates. Must be set to a base64-encoded SHA256 hash of the package file specified with either `filename` or `s3_key`.
        """
        return pulumi.get(self, "source_code_hash")

    @source_code_hash.setter
    def source_code_hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_code_hash", value)

    @property
    @pulumi.getter(name="sourceCodeSize")
    def source_code_size(self) -> Optional[pulumi.Input[int]]:
        """
        Size in bytes of the function .zip file.
        """
        return pulumi.get(self, "source_code_size")

    @source_code_size.setter
    def source_code_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "source_code_size", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Amount of time your Lambda Function has to run in seconds. Defaults to `3`. See [Limits](https://docs.aws.amazon.com/lambda/latest/dg/limits.html).
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="tracingConfig")
    def tracing_config(self) -> Optional[pulumi.Input['FunctionTracingConfigArgs']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "tracing_config")

    @tracing_config.setter
    def tracing_config(self, value: Optional[pulumi.Input['FunctionTracingConfigArgs']]):
        pulumi.set(self, "tracing_config", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Latest published version of your Lambda Function.
        * `vpc_config.vpc_id` - ID of the VPC.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> Optional[pulumi.Input['FunctionVpcConfigArgs']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "vpc_config")

    @vpc_config.setter
    def vpc_config(self, value: Optional[pulumi.Input['FunctionVpcConfigArgs']]):
        pulumi.set(self, "vpc_config", value)


class Function(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 architectures: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 code: Optional[pulumi.Input[pulumi.Archive]] = None,
                 code_signing_config_arn: Optional[pulumi.Input[str]] = None,
                 dead_letter_config: Optional[pulumi.Input[pulumi.InputType['FunctionDeadLetterConfigArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[pulumi.InputType['FunctionEnvironmentArgs']]] = None,
                 ephemeral_storage: Optional[pulumi.Input[pulumi.InputType['FunctionEphemeralStorageArgs']]] = None,
                 file_system_config: Optional[pulumi.Input[pulumi.InputType['FunctionFileSystemConfigArgs']]] = None,
                 handler: Optional[pulumi.Input[str]] = None,
                 image_config: Optional[pulumi.Input[pulumi.InputType['FunctionImageConfigArgs']]] = None,
                 image_uri: Optional[pulumi.Input[str]] = None,
                 kms_key_arn: Optional[pulumi.Input[str]] = None,
                 layers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 memory_size: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 package_type: Optional[pulumi.Input[str]] = None,
                 publish: Optional[pulumi.Input[bool]] = None,
                 replace_security_groups_on_destroy: Optional[pulumi.Input[bool]] = None,
                 replacement_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 reserved_concurrent_executions: Optional[pulumi.Input[int]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 runtime: Optional[pulumi.Input[Union[str, 'Runtime']]] = None,
                 s3_bucket: Optional[pulumi.Input[str]] = None,
                 s3_key: Optional[pulumi.Input[str]] = None,
                 s3_object_version: Optional[pulumi.Input[str]] = None,
                 skip_destroy: Optional[pulumi.Input[bool]] = None,
                 snap_start: Optional[pulumi.Input[pulumi.InputType['FunctionSnapStartArgs']]] = None,
                 source_code_hash: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 tracing_config: Optional[pulumi.Input[pulumi.InputType['FunctionTracingConfigArgs']]] = None,
                 vpc_config: Optional[pulumi.Input[pulumi.InputType['FunctionVpcConfigArgs']]] = None,
                 __props__=None):
        """
        Provides a Lambda Function resource. Lambda allows you to trigger execution of code in response to events in AWS, enabling serverless backend solutions. The Lambda Function itself includes source code and runtime configuration.

        For information about Lambda and how to use it, see [What is AWS Lambda?](https://docs.aws.amazon.com/lambda/latest/dg/welcome.html)

        > **NOTE:** Due to [AWS Lambda improved VPC networking changes that began deploying in September 2019](https://aws.amazon.com/blogs/compute/announcing-improved-vpc-networking-for-aws-lambda-functions/), EC2 subnets and security groups associated with Lambda Functions can take up to 45 minutes to successfully delete.

        > **NOTE:** If you get a `KMSAccessDeniedException: Lambda was unable to decrypt the environment variables because KMS access was denied` error when invoking an `lambda.Function` with environment variables, the IAM role associated with the function may have been deleted and recreated _after_ the function was created. You can fix the problem two ways: 1) updating the function's role to another role and then updating it back again to the recreated role, or 2) by using Pulumi to `taint` the function and `apply` your configuration again to recreate the function. (When you create a function, Lambda grants permissions on the KMS key to the function's IAM role. If the IAM role is recreated, the grant is no longer valid. Changing the function's role or recreating the function causes Lambda to update the grant.)

        > To give an external source (like an EventBridge Rule, SNS, or S3) permission to access the Lambda function, use the `lambda.Permission` resource. See [Lambda Permission Model](https://docs.aws.amazon.com/lambda/latest/dg/intro-permission-model.html) for more details. On the other hand, the `role` argument of this resource is the function's execution role for identity and access to AWS services and resources.

        ## Example Usage
        ### Basic Example

        ```python
        import pulumi
        import pulumi_archive as archive
        import pulumi_aws as aws

        assume_role = aws.iam.get_policy_document(statements=[aws.iam.GetPolicyDocumentStatementArgs(
            effect="Allow",
            principals=[aws.iam.GetPolicyDocumentStatementPrincipalArgs(
                type="Service",
                identifiers=["lambda.amazonaws.com"],
            )],
            actions=["sts:AssumeRole"],
        )])
        iam_for_lambda = aws.iam.Role("iamForLambda", assume_role_policy=assume_role.json)
        lambda_ = archive.get_file(type="zip",
            source_file="lambda.js",
            output_path="lambda_function_payload.zip")
        test_lambda = aws.lambda_.Function("testLambda",
            code=pulumi.FileArchive("lambda_function_payload.zip"),
            role=iam_for_lambda.arn,
            handler="index.test",
            runtime="nodejs18.x",
            environment=aws.lambda_.FunctionEnvironmentArgs(
                variables={
                    "foo": "bar",
                },
            ))
        ```
        ### Lambda Layers

        ```python
        import pulumi
        import pulumi_aws as aws

        example_layer_version = aws.lambda_.LayerVersion("exampleLayerVersion")
        # ... other configuration ...
        example_function = aws.lambda_.Function("exampleFunction", layers=[example_layer_version.arn])
        ```
        ### Lambda Ephemeral Storage

        Lambda Function Ephemeral Storage(`/tmp`) allows you to configure the storage upto `10` GB. The default value set to `512` MB.

        ```python
        import pulumi
        import pulumi_aws as aws

        assume_role = aws.iam.get_policy_document(statements=[aws.iam.GetPolicyDocumentStatementArgs(
            effect="Allow",
            principals=[aws.iam.GetPolicyDocumentStatementPrincipalArgs(
                type="Service",
                identifiers=["lambda.amazonaws.com"],
            )],
            actions=["sts:AssumeRole"],
        )])
        iam_for_lambda = aws.iam.Role("iamForLambda", assume_role_policy=assume_role.json)
        test_lambda = aws.lambda_.Function("testLambda",
            code=pulumi.FileArchive("lambda_function_payload.zip"),
            role=iam_for_lambda.arn,
            handler="index.test",
            runtime="nodejs18.x",
            ephemeral_storage=aws.lambda_.FunctionEphemeralStorageArgs(
                size=10240,
            ))
        ```
        ### Lambda File Systems

        Lambda File Systems allow you to connect an Amazon Elastic File System (EFS) file system to a Lambda function to share data across function invocations, access existing data including large files, and save function state.

        ```python
        import pulumi
        import pulumi_aws as aws

        # EFS file system
        efs_for_lambda = aws.efs.FileSystem("efsForLambda", tags={
            "Name": "efs_for_lambda",
        })
        # Mount target connects the file system to the subnet
        alpha = aws.efs.MountTarget("alpha",
            file_system_id=efs_for_lambda.id,
            subnet_id=aws_subnet["subnet_for_lambda"]["id"],
            security_groups=[aws_security_group["sg_for_lambda"]["id"]])
        # EFS access point used by lambda file system
        access_point_for_lambda = aws.efs.AccessPoint("accessPointForLambda",
            file_system_id=efs_for_lambda.id,
            root_directory=aws.efs.AccessPointRootDirectoryArgs(
                path="/lambda",
                creation_info=aws.efs.AccessPointRootDirectoryCreationInfoArgs(
                    owner_gid=1000,
                    owner_uid=1000,
                    permissions="777",
                ),
            ),
            posix_user=aws.efs.AccessPointPosixUserArgs(
                gid=1000,
                uid=1000,
            ))
        # A lambda function connected to an EFS file system
        # ... other configuration ...
        example = aws.lambda_.Function("example",
            file_system_config=aws.lambda_.FunctionFileSystemConfigArgs(
                arn=access_point_for_lambda.arn,
                local_mount_path="/mnt/efs",
            ),
            vpc_config=aws.lambda_.FunctionVpcConfigArgs(
                subnet_ids=[aws_subnet["subnet_for_lambda"]["id"]],
                security_group_ids=[aws_security_group["sg_for_lambda"]["id"]],
            ),
            opts=pulumi.ResourceOptions(depends_on=[alpha]))
        ```
        ### Lambda retries

        Lambda Functions allow you to configure error handling for asynchronous invocation. The settings that it supports are `Maximum age of event` and `Retry attempts` as stated in [Lambda documentation for Configuring error handling for asynchronous invocation](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-async-errors). To configure these settings, refer to the lambda.FunctionEventInvokeConfig resource.
        ## CloudWatch Logging and Permissions

        For more information about CloudWatch Logs for Lambda, see the [Lambda User Guide](https://docs.aws.amazon.com/lambda/latest/dg/monitoring-functions-logs.html).

        ```python
        import pulumi
        import pulumi_aws as aws

        config = pulumi.Config()
        lambda_function_name = config.get("lambdaFunctionName")
        if lambda_function_name is None:
            lambda_function_name = "lambda_function_name"
        # This is to optionally manage the CloudWatch Log Group for the Lambda Function.
        # If skipping this resource configuration, also add "logs:CreateLogGroup" to the IAM policy below.
        example = aws.cloudwatch.LogGroup("example", retention_in_days=14)
        lambda_logging_policy_document = aws.iam.get_policy_document(statements=[aws.iam.GetPolicyDocumentStatementArgs(
            effect="Allow",
            actions=[
                "logs:CreateLogGroup",
                "logs:CreateLogStream",
                "logs:PutLogEvents",
            ],
            resources=["arn:aws:logs:*:*:*"],
        )])
        lambda_logging_policy = aws.iam.Policy("lambdaLoggingPolicy",
            path="/",
            description="IAM policy for logging from a lambda",
            policy=lambda_logging_policy_document.json)
        lambda_logs = aws.iam.RolePolicyAttachment("lambdaLogs",
            role=aws_iam_role["iam_for_lambda"]["name"],
            policy_arn=lambda_logging_policy.arn)
        test_lambda = aws.lambda_.Function("testLambda", opts=pulumi.ResourceOptions(depends_on=[
                lambda_logs,
                example,
            ]))
        ```

        ## Specifying the Deployment Package

        AWS Lambda expects source code to be provided as a deployment package whose structure varies depending on which `runtime` is in use. See [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_CreateFunction.html#SSS-CreateFunction-request-Runtime) for the valid values of `runtime`. The expected structure of the deployment package can be found in [the AWS Lambda documentation for each runtime](https://docs.aws.amazon.com/lambda/latest/dg/deployment-package-v2.html).

        Once you have created your deployment package you can specify it either directly as a local file (using the `filename` argument) or indirectly via Amazon S3 (using the `s3_bucket`, `s3_key` and `s3_object_version` arguments). When providing the deployment package via S3 it may be useful to use the `s3.BucketObjectv2` resource to upload it.

        For larger deployment packages it is recommended by Amazon to upload via S3, since the S3 API has better support for uploading large files efficiently.

        ## Import

        Using `pulumi import`, import Lambda Functions using the `function_name`. For example:

        ```sh
         $ pulumi import aws:lambda/function:Function test_lambda my_test_lambda_function
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] architectures: Instruction set architecture for your Lambda function. Valid values are `["x86_64"]` and `["arm64"]`. Default is `["x86_64"]`. Removing this attribute, function's architecture stay the same.
        :param pulumi.Input[pulumi.Archive] code: Path to the function's deployment package within the local filesystem. Exactly one of `filename`, `image_uri`, or `s3_bucket` must be specified.
        :param pulumi.Input[str] code_signing_config_arn: To enable code signing for this function, specify the ARN of a code-signing configuration. A code-signing configuration includes a set of signing profiles, which define the trusted publishers for this function.
        :param pulumi.Input[pulumi.InputType['FunctionDeadLetterConfigArgs']] dead_letter_config: Configuration block. Detailed below.
        :param pulumi.Input[str] description: Description of what your Lambda Function does.
        :param pulumi.Input[pulumi.InputType['FunctionEnvironmentArgs']] environment: Configuration block. Detailed below.
        :param pulumi.Input[pulumi.InputType['FunctionEphemeralStorageArgs']] ephemeral_storage: The amount of Ephemeral storage(`/tmp`) to allocate for the Lambda Function in MB. This parameter is used to expand the total amount of Ephemeral storage available, beyond the default amount of `512`MB. Detailed below.
        :param pulumi.Input[pulumi.InputType['FunctionFileSystemConfigArgs']] file_system_config: Configuration block. Detailed below.
        :param pulumi.Input[str] handler: Function [entrypoint](https://docs.aws.amazon.com/lambda/latest/dg/walkthrough-custom-events-create-test-function.html) in your code.
        :param pulumi.Input[pulumi.InputType['FunctionImageConfigArgs']] image_config: Configuration block. Detailed below.
        :param pulumi.Input[str] image_uri: ECR image URI containing the function's deployment package. Exactly one of `filename`, `image_uri`,  or `s3_bucket` must be specified.
        :param pulumi.Input[str] kms_key_arn: Amazon Resource Name (ARN) of the AWS Key Management Service (KMS) key that is used to encrypt environment variables. If this configuration is not provided when environment variables are in use, AWS Lambda uses a default service key. If this configuration is provided when environment variables are not in use, the AWS Lambda API does not save this configuration and the provider will show a perpetual difference of adding the key. To fix the perpetual difference, remove this configuration.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] layers: List of Lambda Layer Version ARNs (maximum of 5) to attach to your Lambda Function. See [Lambda Layers](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html)
        :param pulumi.Input[int] memory_size: Amount of memory in MB your Lambda Function can use at runtime. Defaults to `128`. See [Limits](https://docs.aws.amazon.com/lambda/latest/dg/limits.html)
        :param pulumi.Input[str] name: Unique name for your Lambda Function.
        :param pulumi.Input[str] package_type: Lambda deployment package type. Valid values are `Zip` and `Image`. Defaults to `Zip`.
        :param pulumi.Input[bool] publish: Whether to publish creation/change as new Lambda Function Version. Defaults to `false`.
        :param pulumi.Input[bool] replace_security_groups_on_destroy: **AWS no longer supports this operation. This attribute now has no effect and will be removed in a future major version.** Whether to replace the security groups on associated lambda network interfaces upon destruction. Removing these security groups from orphaned network interfaces can speed up security group deletion times by avoiding a dependency on AWS's internal cleanup operations. By default, the ENI security groups will be replaced with the `default` security group in the function's VPC. Set the `replacement_security_group_ids` attribute to use a custom list of security groups for replacement.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] replacement_security_group_ids: List of security group IDs to assign to orphaned Lambda function network interfaces upon destruction. `replace_security_groups_on_destroy` must be set to `true` to use this attribute.
        :param pulumi.Input[int] reserved_concurrent_executions: Amount of reserved concurrent executions for this lambda function. A value of `0` disables lambda from being triggered and `-1` removes any concurrency limitations. Defaults to Unreserved Concurrency Limits `-1`. See [Managing Concurrency](https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html)
        :param pulumi.Input[str] role: Amazon Resource Name (ARN) of the function's execution role. The role provides the function's identity and access to AWS services and resources.
               
               The following arguments are optional:
        :param pulumi.Input[Union[str, 'Runtime']] runtime: Identifier of the function's runtime. See [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_CreateFunction.html#SSS-CreateFunction-request-Runtime) for valid values.
        :param pulumi.Input[str] s3_bucket: S3 bucket location containing the function's deployment package. This bucket must reside in the same AWS region where you are creating the Lambda function. Exactly one of `filename`, `image_uri`, or `s3_bucket` must be specified. When `s3_bucket` is set, `s3_key` is required.
        :param pulumi.Input[str] s3_key: S3 key of an object containing the function's deployment package. When `s3_bucket` is set, `s3_key` is required.
        :param pulumi.Input[str] s3_object_version: Object version containing the function's deployment package. Conflicts with `filename` and `image_uri`.
        :param pulumi.Input[bool] skip_destroy: Set to true if you do not wish the function to be deleted at destroy time, and instead just remove the function from the Pulumi state.
        :param pulumi.Input[pulumi.InputType['FunctionSnapStartArgs']] snap_start: Snap start settings block. Detailed below.
        :param pulumi.Input[str] source_code_hash: Used to trigger updates. Must be set to a base64-encoded SHA256 hash of the package file specified with either `filename` or `s3_key`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[int] timeout: Amount of time your Lambda Function has to run in seconds. Defaults to `3`. See [Limits](https://docs.aws.amazon.com/lambda/latest/dg/limits.html).
        :param pulumi.Input[pulumi.InputType['FunctionTracingConfigArgs']] tracing_config: Configuration block. Detailed below.
        :param pulumi.Input[pulumi.InputType['FunctionVpcConfigArgs']] vpc_config: Configuration block. Detailed below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FunctionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Lambda Function resource. Lambda allows you to trigger execution of code in response to events in AWS, enabling serverless backend solutions. The Lambda Function itself includes source code and runtime configuration.

        For information about Lambda and how to use it, see [What is AWS Lambda?](https://docs.aws.amazon.com/lambda/latest/dg/welcome.html)

        > **NOTE:** Due to [AWS Lambda improved VPC networking changes that began deploying in September 2019](https://aws.amazon.com/blogs/compute/announcing-improved-vpc-networking-for-aws-lambda-functions/), EC2 subnets and security groups associated with Lambda Functions can take up to 45 minutes to successfully delete.

        > **NOTE:** If you get a `KMSAccessDeniedException: Lambda was unable to decrypt the environment variables because KMS access was denied` error when invoking an `lambda.Function` with environment variables, the IAM role associated with the function may have been deleted and recreated _after_ the function was created. You can fix the problem two ways: 1) updating the function's role to another role and then updating it back again to the recreated role, or 2) by using Pulumi to `taint` the function and `apply` your configuration again to recreate the function. (When you create a function, Lambda grants permissions on the KMS key to the function's IAM role. If the IAM role is recreated, the grant is no longer valid. Changing the function's role or recreating the function causes Lambda to update the grant.)

        > To give an external source (like an EventBridge Rule, SNS, or S3) permission to access the Lambda function, use the `lambda.Permission` resource. See [Lambda Permission Model](https://docs.aws.amazon.com/lambda/latest/dg/intro-permission-model.html) for more details. On the other hand, the `role` argument of this resource is the function's execution role for identity and access to AWS services and resources.

        ## Example Usage
        ### Basic Example

        ```python
        import pulumi
        import pulumi_archive as archive
        import pulumi_aws as aws

        assume_role = aws.iam.get_policy_document(statements=[aws.iam.GetPolicyDocumentStatementArgs(
            effect="Allow",
            principals=[aws.iam.GetPolicyDocumentStatementPrincipalArgs(
                type="Service",
                identifiers=["lambda.amazonaws.com"],
            )],
            actions=["sts:AssumeRole"],
        )])
        iam_for_lambda = aws.iam.Role("iamForLambda", assume_role_policy=assume_role.json)
        lambda_ = archive.get_file(type="zip",
            source_file="lambda.js",
            output_path="lambda_function_payload.zip")
        test_lambda = aws.lambda_.Function("testLambda",
            code=pulumi.FileArchive("lambda_function_payload.zip"),
            role=iam_for_lambda.arn,
            handler="index.test",
            runtime="nodejs18.x",
            environment=aws.lambda_.FunctionEnvironmentArgs(
                variables={
                    "foo": "bar",
                },
            ))
        ```
        ### Lambda Layers

        ```python
        import pulumi
        import pulumi_aws as aws

        example_layer_version = aws.lambda_.LayerVersion("exampleLayerVersion")
        # ... other configuration ...
        example_function = aws.lambda_.Function("exampleFunction", layers=[example_layer_version.arn])
        ```
        ### Lambda Ephemeral Storage

        Lambda Function Ephemeral Storage(`/tmp`) allows you to configure the storage upto `10` GB. The default value set to `512` MB.

        ```python
        import pulumi
        import pulumi_aws as aws

        assume_role = aws.iam.get_policy_document(statements=[aws.iam.GetPolicyDocumentStatementArgs(
            effect="Allow",
            principals=[aws.iam.GetPolicyDocumentStatementPrincipalArgs(
                type="Service",
                identifiers=["lambda.amazonaws.com"],
            )],
            actions=["sts:AssumeRole"],
        )])
        iam_for_lambda = aws.iam.Role("iamForLambda", assume_role_policy=assume_role.json)
        test_lambda = aws.lambda_.Function("testLambda",
            code=pulumi.FileArchive("lambda_function_payload.zip"),
            role=iam_for_lambda.arn,
            handler="index.test",
            runtime="nodejs18.x",
            ephemeral_storage=aws.lambda_.FunctionEphemeralStorageArgs(
                size=10240,
            ))
        ```
        ### Lambda File Systems

        Lambda File Systems allow you to connect an Amazon Elastic File System (EFS) file system to a Lambda function to share data across function invocations, access existing data including large files, and save function state.

        ```python
        import pulumi
        import pulumi_aws as aws

        # EFS file system
        efs_for_lambda = aws.efs.FileSystem("efsForLambda", tags={
            "Name": "efs_for_lambda",
        })
        # Mount target connects the file system to the subnet
        alpha = aws.efs.MountTarget("alpha",
            file_system_id=efs_for_lambda.id,
            subnet_id=aws_subnet["subnet_for_lambda"]["id"],
            security_groups=[aws_security_group["sg_for_lambda"]["id"]])
        # EFS access point used by lambda file system
        access_point_for_lambda = aws.efs.AccessPoint("accessPointForLambda",
            file_system_id=efs_for_lambda.id,
            root_directory=aws.efs.AccessPointRootDirectoryArgs(
                path="/lambda",
                creation_info=aws.efs.AccessPointRootDirectoryCreationInfoArgs(
                    owner_gid=1000,
                    owner_uid=1000,
                    permissions="777",
                ),
            ),
            posix_user=aws.efs.AccessPointPosixUserArgs(
                gid=1000,
                uid=1000,
            ))
        # A lambda function connected to an EFS file system
        # ... other configuration ...
        example = aws.lambda_.Function("example",
            file_system_config=aws.lambda_.FunctionFileSystemConfigArgs(
                arn=access_point_for_lambda.arn,
                local_mount_path="/mnt/efs",
            ),
            vpc_config=aws.lambda_.FunctionVpcConfigArgs(
                subnet_ids=[aws_subnet["subnet_for_lambda"]["id"]],
                security_group_ids=[aws_security_group["sg_for_lambda"]["id"]],
            ),
            opts=pulumi.ResourceOptions(depends_on=[alpha]))
        ```
        ### Lambda retries

        Lambda Functions allow you to configure error handling for asynchronous invocation. The settings that it supports are `Maximum age of event` and `Retry attempts` as stated in [Lambda documentation for Configuring error handling for asynchronous invocation](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-async-errors). To configure these settings, refer to the lambda.FunctionEventInvokeConfig resource.
        ## CloudWatch Logging and Permissions

        For more information about CloudWatch Logs for Lambda, see the [Lambda User Guide](https://docs.aws.amazon.com/lambda/latest/dg/monitoring-functions-logs.html).

        ```python
        import pulumi
        import pulumi_aws as aws

        config = pulumi.Config()
        lambda_function_name = config.get("lambdaFunctionName")
        if lambda_function_name is None:
            lambda_function_name = "lambda_function_name"
        # This is to optionally manage the CloudWatch Log Group for the Lambda Function.
        # If skipping this resource configuration, also add "logs:CreateLogGroup" to the IAM policy below.
        example = aws.cloudwatch.LogGroup("example", retention_in_days=14)
        lambda_logging_policy_document = aws.iam.get_policy_document(statements=[aws.iam.GetPolicyDocumentStatementArgs(
            effect="Allow",
            actions=[
                "logs:CreateLogGroup",
                "logs:CreateLogStream",
                "logs:PutLogEvents",
            ],
            resources=["arn:aws:logs:*:*:*"],
        )])
        lambda_logging_policy = aws.iam.Policy("lambdaLoggingPolicy",
            path="/",
            description="IAM policy for logging from a lambda",
            policy=lambda_logging_policy_document.json)
        lambda_logs = aws.iam.RolePolicyAttachment("lambdaLogs",
            role=aws_iam_role["iam_for_lambda"]["name"],
            policy_arn=lambda_logging_policy.arn)
        test_lambda = aws.lambda_.Function("testLambda", opts=pulumi.ResourceOptions(depends_on=[
                lambda_logs,
                example,
            ]))
        ```

        ## Specifying the Deployment Package

        AWS Lambda expects source code to be provided as a deployment package whose structure varies depending on which `runtime` is in use. See [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_CreateFunction.html#SSS-CreateFunction-request-Runtime) for the valid values of `runtime`. The expected structure of the deployment package can be found in [the AWS Lambda documentation for each runtime](https://docs.aws.amazon.com/lambda/latest/dg/deployment-package-v2.html).

        Once you have created your deployment package you can specify it either directly as a local file (using the `filename` argument) or indirectly via Amazon S3 (using the `s3_bucket`, `s3_key` and `s3_object_version` arguments). When providing the deployment package via S3 it may be useful to use the `s3.BucketObjectv2` resource to upload it.

        For larger deployment packages it is recommended by Amazon to upload via S3, since the S3 API has better support for uploading large files efficiently.

        ## Import

        Using `pulumi import`, import Lambda Functions using the `function_name`. For example:

        ```sh
         $ pulumi import aws:lambda/function:Function test_lambda my_test_lambda_function
        ```

        :param str resource_name: The name of the resource.
        :param FunctionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FunctionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 architectures: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 code: Optional[pulumi.Input[pulumi.Archive]] = None,
                 code_signing_config_arn: Optional[pulumi.Input[str]] = None,
                 dead_letter_config: Optional[pulumi.Input[pulumi.InputType['FunctionDeadLetterConfigArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[pulumi.InputType['FunctionEnvironmentArgs']]] = None,
                 ephemeral_storage: Optional[pulumi.Input[pulumi.InputType['FunctionEphemeralStorageArgs']]] = None,
                 file_system_config: Optional[pulumi.Input[pulumi.InputType['FunctionFileSystemConfigArgs']]] = None,
                 handler: Optional[pulumi.Input[str]] = None,
                 image_config: Optional[pulumi.Input[pulumi.InputType['FunctionImageConfigArgs']]] = None,
                 image_uri: Optional[pulumi.Input[str]] = None,
                 kms_key_arn: Optional[pulumi.Input[str]] = None,
                 layers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 memory_size: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 package_type: Optional[pulumi.Input[str]] = None,
                 publish: Optional[pulumi.Input[bool]] = None,
                 replace_security_groups_on_destroy: Optional[pulumi.Input[bool]] = None,
                 replacement_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 reserved_concurrent_executions: Optional[pulumi.Input[int]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 runtime: Optional[pulumi.Input[Union[str, 'Runtime']]] = None,
                 s3_bucket: Optional[pulumi.Input[str]] = None,
                 s3_key: Optional[pulumi.Input[str]] = None,
                 s3_object_version: Optional[pulumi.Input[str]] = None,
                 skip_destroy: Optional[pulumi.Input[bool]] = None,
                 snap_start: Optional[pulumi.Input[pulumi.InputType['FunctionSnapStartArgs']]] = None,
                 source_code_hash: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 tracing_config: Optional[pulumi.Input[pulumi.InputType['FunctionTracingConfigArgs']]] = None,
                 vpc_config: Optional[pulumi.Input[pulumi.InputType['FunctionVpcConfigArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FunctionArgs.__new__(FunctionArgs)

            __props__.__dict__["architectures"] = architectures
            __props__.__dict__["code"] = code
            __props__.__dict__["code_signing_config_arn"] = code_signing_config_arn
            __props__.__dict__["dead_letter_config"] = dead_letter_config
            __props__.__dict__["description"] = description
            __props__.__dict__["environment"] = environment
            __props__.__dict__["ephemeral_storage"] = ephemeral_storage
            __props__.__dict__["file_system_config"] = file_system_config
            __props__.__dict__["handler"] = handler
            __props__.__dict__["image_config"] = image_config
            __props__.__dict__["image_uri"] = image_uri
            __props__.__dict__["kms_key_arn"] = kms_key_arn
            __props__.__dict__["layers"] = layers
            __props__.__dict__["memory_size"] = memory_size
            __props__.__dict__["name"] = name
            __props__.__dict__["package_type"] = package_type
            __props__.__dict__["publish"] = publish
            if replace_security_groups_on_destroy is not None and not opts.urn:
                warnings.warn("""AWS no longer supports this operation. This attribute now has no effect and will be removed in a future major version.""", DeprecationWarning)
                pulumi.log.warn("""replace_security_groups_on_destroy is deprecated: AWS no longer supports this operation. This attribute now has no effect and will be removed in a future major version.""")
            __props__.__dict__["replace_security_groups_on_destroy"] = replace_security_groups_on_destroy
            if replacement_security_group_ids is not None and not opts.urn:
                warnings.warn("""AWS no longer supports this operation. This attribute now has no effect and will be removed in a future major version.""", DeprecationWarning)
                pulumi.log.warn("""replacement_security_group_ids is deprecated: AWS no longer supports this operation. This attribute now has no effect and will be removed in a future major version.""")
            __props__.__dict__["replacement_security_group_ids"] = replacement_security_group_ids
            __props__.__dict__["reserved_concurrent_executions"] = reserved_concurrent_executions
            if role is None and not opts.urn:
                raise TypeError("Missing required property 'role'")
            __props__.__dict__["role"] = role
            __props__.__dict__["runtime"] = runtime
            __props__.__dict__["s3_bucket"] = s3_bucket
            __props__.__dict__["s3_key"] = s3_key
            __props__.__dict__["s3_object_version"] = s3_object_version
            __props__.__dict__["skip_destroy"] = skip_destroy
            __props__.__dict__["snap_start"] = snap_start
            __props__.__dict__["source_code_hash"] = source_code_hash
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["tracing_config"] = tracing_config
            __props__.__dict__["vpc_config"] = vpc_config
            __props__.__dict__["arn"] = None
            __props__.__dict__["invoke_arn"] = None
            __props__.__dict__["last_modified"] = None
            __props__.__dict__["qualified_arn"] = None
            __props__.__dict__["qualified_invoke_arn"] = None
            __props__.__dict__["signing_job_arn"] = None
            __props__.__dict__["signing_profile_version_arn"] = None
            __props__.__dict__["source_code_size"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["version"] = None
        super(Function, __self__).__init__(
            'aws:lambda/function:Function',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            architectures: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            code: Optional[pulumi.Input[pulumi.Archive]] = None,
            code_signing_config_arn: Optional[pulumi.Input[str]] = None,
            dead_letter_config: Optional[pulumi.Input[pulumi.InputType['FunctionDeadLetterConfigArgs']]] = None,
            description: Optional[pulumi.Input[str]] = None,
            environment: Optional[pulumi.Input[pulumi.InputType['FunctionEnvironmentArgs']]] = None,
            ephemeral_storage: Optional[pulumi.Input[pulumi.InputType['FunctionEphemeralStorageArgs']]] = None,
            file_system_config: Optional[pulumi.Input[pulumi.InputType['FunctionFileSystemConfigArgs']]] = None,
            handler: Optional[pulumi.Input[str]] = None,
            image_config: Optional[pulumi.Input[pulumi.InputType['FunctionImageConfigArgs']]] = None,
            image_uri: Optional[pulumi.Input[str]] = None,
            invoke_arn: Optional[pulumi.Input[str]] = None,
            kms_key_arn: Optional[pulumi.Input[str]] = None,
            last_modified: Optional[pulumi.Input[str]] = None,
            layers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            memory_size: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            package_type: Optional[pulumi.Input[str]] = None,
            publish: Optional[pulumi.Input[bool]] = None,
            qualified_arn: Optional[pulumi.Input[str]] = None,
            qualified_invoke_arn: Optional[pulumi.Input[str]] = None,
            replace_security_groups_on_destroy: Optional[pulumi.Input[bool]] = None,
            replacement_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            reserved_concurrent_executions: Optional[pulumi.Input[int]] = None,
            role: Optional[pulumi.Input[str]] = None,
            runtime: Optional[pulumi.Input[Union[str, 'Runtime']]] = None,
            s3_bucket: Optional[pulumi.Input[str]] = None,
            s3_key: Optional[pulumi.Input[str]] = None,
            s3_object_version: Optional[pulumi.Input[str]] = None,
            signing_job_arn: Optional[pulumi.Input[str]] = None,
            signing_profile_version_arn: Optional[pulumi.Input[str]] = None,
            skip_destroy: Optional[pulumi.Input[bool]] = None,
            snap_start: Optional[pulumi.Input[pulumi.InputType['FunctionSnapStartArgs']]] = None,
            source_code_hash: Optional[pulumi.Input[str]] = None,
            source_code_size: Optional[pulumi.Input[int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            timeout: Optional[pulumi.Input[int]] = None,
            tracing_config: Optional[pulumi.Input[pulumi.InputType['FunctionTracingConfigArgs']]] = None,
            version: Optional[pulumi.Input[str]] = None,
            vpc_config: Optional[pulumi.Input[pulumi.InputType['FunctionVpcConfigArgs']]] = None) -> 'Function':
        """
        Get an existing Function resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] architectures: Instruction set architecture for your Lambda function. Valid values are `["x86_64"]` and `["arm64"]`. Default is `["x86_64"]`. Removing this attribute, function's architecture stay the same.
        :param pulumi.Input[str] arn: Amazon Resource Name (ARN) of the Amazon EFS Access Point that provides access to the file system.
        :param pulumi.Input[pulumi.Archive] code: Path to the function's deployment package within the local filesystem. Exactly one of `filename`, `image_uri`, or `s3_bucket` must be specified.
        :param pulumi.Input[str] code_signing_config_arn: To enable code signing for this function, specify the ARN of a code-signing configuration. A code-signing configuration includes a set of signing profiles, which define the trusted publishers for this function.
        :param pulumi.Input[pulumi.InputType['FunctionDeadLetterConfigArgs']] dead_letter_config: Configuration block. Detailed below.
        :param pulumi.Input[str] description: Description of what your Lambda Function does.
        :param pulumi.Input[pulumi.InputType['FunctionEnvironmentArgs']] environment: Configuration block. Detailed below.
        :param pulumi.Input[pulumi.InputType['FunctionEphemeralStorageArgs']] ephemeral_storage: The amount of Ephemeral storage(`/tmp`) to allocate for the Lambda Function in MB. This parameter is used to expand the total amount of Ephemeral storage available, beyond the default amount of `512`MB. Detailed below.
        :param pulumi.Input[pulumi.InputType['FunctionFileSystemConfigArgs']] file_system_config: Configuration block. Detailed below.
        :param pulumi.Input[str] handler: Function [entrypoint](https://docs.aws.amazon.com/lambda/latest/dg/walkthrough-custom-events-create-test-function.html) in your code.
        :param pulumi.Input[pulumi.InputType['FunctionImageConfigArgs']] image_config: Configuration block. Detailed below.
        :param pulumi.Input[str] image_uri: ECR image URI containing the function's deployment package. Exactly one of `filename`, `image_uri`,  or `s3_bucket` must be specified.
        :param pulumi.Input[str] invoke_arn: ARN to be used for invoking Lambda Function from API Gateway - to be used in `apigateway.Integration`'s `uri`.
        :param pulumi.Input[str] kms_key_arn: Amazon Resource Name (ARN) of the AWS Key Management Service (KMS) key that is used to encrypt environment variables. If this configuration is not provided when environment variables are in use, AWS Lambda uses a default service key. If this configuration is provided when environment variables are not in use, the AWS Lambda API does not save this configuration and the provider will show a perpetual difference of adding the key. To fix the perpetual difference, remove this configuration.
        :param pulumi.Input[str] last_modified: Date this resource was last modified.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] layers: List of Lambda Layer Version ARNs (maximum of 5) to attach to your Lambda Function. See [Lambda Layers](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html)
        :param pulumi.Input[int] memory_size: Amount of memory in MB your Lambda Function can use at runtime. Defaults to `128`. See [Limits](https://docs.aws.amazon.com/lambda/latest/dg/limits.html)
        :param pulumi.Input[str] name: Unique name for your Lambda Function.
        :param pulumi.Input[str] package_type: Lambda deployment package type. Valid values are `Zip` and `Image`. Defaults to `Zip`.
        :param pulumi.Input[bool] publish: Whether to publish creation/change as new Lambda Function Version. Defaults to `false`.
        :param pulumi.Input[str] qualified_arn: ARN identifying your Lambda Function Version (if versioning is enabled via `publish = true`).
        :param pulumi.Input[str] qualified_invoke_arn: Qualified ARN (ARN with lambda version number) to be used for invoking Lambda Function from API Gateway - to be used in `apigateway.Integration`'s `uri`.
        :param pulumi.Input[bool] replace_security_groups_on_destroy: **AWS no longer supports this operation. This attribute now has no effect and will be removed in a future major version.** Whether to replace the security groups on associated lambda network interfaces upon destruction. Removing these security groups from orphaned network interfaces can speed up security group deletion times by avoiding a dependency on AWS's internal cleanup operations. By default, the ENI security groups will be replaced with the `default` security group in the function's VPC. Set the `replacement_security_group_ids` attribute to use a custom list of security groups for replacement.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] replacement_security_group_ids: List of security group IDs to assign to orphaned Lambda function network interfaces upon destruction. `replace_security_groups_on_destroy` must be set to `true` to use this attribute.
        :param pulumi.Input[int] reserved_concurrent_executions: Amount of reserved concurrent executions for this lambda function. A value of `0` disables lambda from being triggered and `-1` removes any concurrency limitations. Defaults to Unreserved Concurrency Limits `-1`. See [Managing Concurrency](https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html)
        :param pulumi.Input[str] role: Amazon Resource Name (ARN) of the function's execution role. The role provides the function's identity and access to AWS services and resources.
               
               The following arguments are optional:
        :param pulumi.Input[Union[str, 'Runtime']] runtime: Identifier of the function's runtime. See [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_CreateFunction.html#SSS-CreateFunction-request-Runtime) for valid values.
        :param pulumi.Input[str] s3_bucket: S3 bucket location containing the function's deployment package. This bucket must reside in the same AWS region where you are creating the Lambda function. Exactly one of `filename`, `image_uri`, or `s3_bucket` must be specified. When `s3_bucket` is set, `s3_key` is required.
        :param pulumi.Input[str] s3_key: S3 key of an object containing the function's deployment package. When `s3_bucket` is set, `s3_key` is required.
        :param pulumi.Input[str] s3_object_version: Object version containing the function's deployment package. Conflicts with `filename` and `image_uri`.
        :param pulumi.Input[str] signing_job_arn: ARN of the signing job.
        :param pulumi.Input[str] signing_profile_version_arn: ARN of the signing profile version.
               * `snap_start.optimization_status` - Optimization status of the snap start configuration. Valid values are `On` and `Off`.
        :param pulumi.Input[bool] skip_destroy: Set to true if you do not wish the function to be deleted at destroy time, and instead just remove the function from the Pulumi state.
        :param pulumi.Input[pulumi.InputType['FunctionSnapStartArgs']] snap_start: Snap start settings block. Detailed below.
        :param pulumi.Input[str] source_code_hash: Used to trigger updates. Must be set to a base64-encoded SHA256 hash of the package file specified with either `filename` or `s3_key`.
        :param pulumi.Input[int] source_code_size: Size in bytes of the function .zip file.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[int] timeout: Amount of time your Lambda Function has to run in seconds. Defaults to `3`. See [Limits](https://docs.aws.amazon.com/lambda/latest/dg/limits.html).
        :param pulumi.Input[pulumi.InputType['FunctionTracingConfigArgs']] tracing_config: Configuration block. Detailed below.
        :param pulumi.Input[str] version: Latest published version of your Lambda Function.
               * `vpc_config.vpc_id` - ID of the VPC.
        :param pulumi.Input[pulumi.InputType['FunctionVpcConfigArgs']] vpc_config: Configuration block. Detailed below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FunctionState.__new__(_FunctionState)

        __props__.__dict__["architectures"] = architectures
        __props__.__dict__["arn"] = arn
        __props__.__dict__["code"] = code
        __props__.__dict__["code_signing_config_arn"] = code_signing_config_arn
        __props__.__dict__["dead_letter_config"] = dead_letter_config
        __props__.__dict__["description"] = description
        __props__.__dict__["environment"] = environment
        __props__.__dict__["ephemeral_storage"] = ephemeral_storage
        __props__.__dict__["file_system_config"] = file_system_config
        __props__.__dict__["handler"] = handler
        __props__.__dict__["image_config"] = image_config
        __props__.__dict__["image_uri"] = image_uri
        __props__.__dict__["invoke_arn"] = invoke_arn
        __props__.__dict__["kms_key_arn"] = kms_key_arn
        __props__.__dict__["last_modified"] = last_modified
        __props__.__dict__["layers"] = layers
        __props__.__dict__["memory_size"] = memory_size
        __props__.__dict__["name"] = name
        __props__.__dict__["package_type"] = package_type
        __props__.__dict__["publish"] = publish
        __props__.__dict__["qualified_arn"] = qualified_arn
        __props__.__dict__["qualified_invoke_arn"] = qualified_invoke_arn
        __props__.__dict__["replace_security_groups_on_destroy"] = replace_security_groups_on_destroy
        __props__.__dict__["replacement_security_group_ids"] = replacement_security_group_ids
        __props__.__dict__["reserved_concurrent_executions"] = reserved_concurrent_executions
        __props__.__dict__["role"] = role
        __props__.__dict__["runtime"] = runtime
        __props__.__dict__["s3_bucket"] = s3_bucket
        __props__.__dict__["s3_key"] = s3_key
        __props__.__dict__["s3_object_version"] = s3_object_version
        __props__.__dict__["signing_job_arn"] = signing_job_arn
        __props__.__dict__["signing_profile_version_arn"] = signing_profile_version_arn
        __props__.__dict__["skip_destroy"] = skip_destroy
        __props__.__dict__["snap_start"] = snap_start
        __props__.__dict__["source_code_hash"] = source_code_hash
        __props__.__dict__["source_code_size"] = source_code_size
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["tracing_config"] = tracing_config
        __props__.__dict__["version"] = version
        __props__.__dict__["vpc_config"] = vpc_config
        return Function(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def architectures(self) -> pulumi.Output[Sequence[str]]:
        """
        Instruction set architecture for your Lambda function. Valid values are `["x86_64"]` and `["arm64"]`. Default is `["x86_64"]`. Removing this attribute, function's architecture stay the same.
        """
        return pulumi.get(self, "architectures")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        Amazon Resource Name (ARN) of the Amazon EFS Access Point that provides access to the file system.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def code(self) -> pulumi.Output[Optional[pulumi.Archive]]:
        """
        Path to the function's deployment package within the local filesystem. Exactly one of `filename`, `image_uri`, or `s3_bucket` must be specified.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="codeSigningConfigArn")
    def code_signing_config_arn(self) -> pulumi.Output[Optional[str]]:
        """
        To enable code signing for this function, specify the ARN of a code-signing configuration. A code-signing configuration includes a set of signing profiles, which define the trusted publishers for this function.
        """
        return pulumi.get(self, "code_signing_config_arn")

    @property
    @pulumi.getter(name="deadLetterConfig")
    def dead_letter_config(self) -> pulumi.Output[Optional['outputs.FunctionDeadLetterConfig']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "dead_letter_config")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of what your Lambda Function does.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def environment(self) -> pulumi.Output[Optional['outputs.FunctionEnvironment']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> pulumi.Output['outputs.FunctionEphemeralStorage']:
        """
        The amount of Ephemeral storage(`/tmp`) to allocate for the Lambda Function in MB. This parameter is used to expand the total amount of Ephemeral storage available, beyond the default amount of `512`MB. Detailed below.
        """
        return pulumi.get(self, "ephemeral_storage")

    @property
    @pulumi.getter(name="fileSystemConfig")
    def file_system_config(self) -> pulumi.Output[Optional['outputs.FunctionFileSystemConfig']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "file_system_config")

    @property
    @pulumi.getter
    def handler(self) -> pulumi.Output[Optional[str]]:
        """
        Function [entrypoint](https://docs.aws.amazon.com/lambda/latest/dg/walkthrough-custom-events-create-test-function.html) in your code.
        """
        return pulumi.get(self, "handler")

    @property
    @pulumi.getter(name="imageConfig")
    def image_config(self) -> pulumi.Output[Optional['outputs.FunctionImageConfig']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "image_config")

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> pulumi.Output[Optional[str]]:
        """
        ECR image URI containing the function's deployment package. Exactly one of `filename`, `image_uri`,  or `s3_bucket` must be specified.
        """
        return pulumi.get(self, "image_uri")

    @property
    @pulumi.getter(name="invokeArn")
    def invoke_arn(self) -> pulumi.Output[str]:
        """
        ARN to be used for invoking Lambda Function from API Gateway - to be used in `apigateway.Integration`'s `uri`.
        """
        return pulumi.get(self, "invoke_arn")

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> pulumi.Output[Optional[str]]:
        """
        Amazon Resource Name (ARN) of the AWS Key Management Service (KMS) key that is used to encrypt environment variables. If this configuration is not provided when environment variables are in use, AWS Lambda uses a default service key. If this configuration is provided when environment variables are not in use, the AWS Lambda API does not save this configuration and the provider will show a perpetual difference of adding the key. To fix the perpetual difference, remove this configuration.
        """
        return pulumi.get(self, "kms_key_arn")

    @property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> pulumi.Output[str]:
        """
        Date this resource was last modified.
        """
        return pulumi.get(self, "last_modified")

    @property
    @pulumi.getter
    def layers(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of Lambda Layer Version ARNs (maximum of 5) to attach to your Lambda Function. See [Lambda Layers](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html)
        """
        return pulumi.get(self, "layers")

    @property
    @pulumi.getter(name="memorySize")
    def memory_size(self) -> pulumi.Output[Optional[int]]:
        """
        Amount of memory in MB your Lambda Function can use at runtime. Defaults to `128`. See [Limits](https://docs.aws.amazon.com/lambda/latest/dg/limits.html)
        """
        return pulumi.get(self, "memory_size")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Unique name for your Lambda Function.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="packageType")
    def package_type(self) -> pulumi.Output[Optional[str]]:
        """
        Lambda deployment package type. Valid values are `Zip` and `Image`. Defaults to `Zip`.
        """
        return pulumi.get(self, "package_type")

    @property
    @pulumi.getter
    def publish(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to publish creation/change as new Lambda Function Version. Defaults to `false`.
        """
        return pulumi.get(self, "publish")

    @property
    @pulumi.getter(name="qualifiedArn")
    def qualified_arn(self) -> pulumi.Output[str]:
        """
        ARN identifying your Lambda Function Version (if versioning is enabled via `publish = true`).
        """
        return pulumi.get(self, "qualified_arn")

    @property
    @pulumi.getter(name="qualifiedInvokeArn")
    def qualified_invoke_arn(self) -> pulumi.Output[str]:
        """
        Qualified ARN (ARN with lambda version number) to be used for invoking Lambda Function from API Gateway - to be used in `apigateway.Integration`'s `uri`.
        """
        return pulumi.get(self, "qualified_invoke_arn")

    @property
    @pulumi.getter(name="replaceSecurityGroupsOnDestroy")
    def replace_security_groups_on_destroy(self) -> pulumi.Output[Optional[bool]]:
        """
        **AWS no longer supports this operation. This attribute now has no effect and will be removed in a future major version.** Whether to replace the security groups on associated lambda network interfaces upon destruction. Removing these security groups from orphaned network interfaces can speed up security group deletion times by avoiding a dependency on AWS's internal cleanup operations. By default, the ENI security groups will be replaced with the `default` security group in the function's VPC. Set the `replacement_security_group_ids` attribute to use a custom list of security groups for replacement.
        """
        warnings.warn("""AWS no longer supports this operation. This attribute now has no effect and will be removed in a future major version.""", DeprecationWarning)
        pulumi.log.warn("""replace_security_groups_on_destroy is deprecated: AWS no longer supports this operation. This attribute now has no effect and will be removed in a future major version.""")

        return pulumi.get(self, "replace_security_groups_on_destroy")

    @property
    @pulumi.getter(name="replacementSecurityGroupIds")
    def replacement_security_group_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of security group IDs to assign to orphaned Lambda function network interfaces upon destruction. `replace_security_groups_on_destroy` must be set to `true` to use this attribute.
        """
        warnings.warn("""AWS no longer supports this operation. This attribute now has no effect and will be removed in a future major version.""", DeprecationWarning)
        pulumi.log.warn("""replacement_security_group_ids is deprecated: AWS no longer supports this operation. This attribute now has no effect and will be removed in a future major version.""")

        return pulumi.get(self, "replacement_security_group_ids")

    @property
    @pulumi.getter(name="reservedConcurrentExecutions")
    def reserved_concurrent_executions(self) -> pulumi.Output[Optional[int]]:
        """
        Amount of reserved concurrent executions for this lambda function. A value of `0` disables lambda from being triggered and `-1` removes any concurrency limitations. Defaults to Unreserved Concurrency Limits `-1`. See [Managing Concurrency](https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html)
        """
        return pulumi.get(self, "reserved_concurrent_executions")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[str]:
        """
        Amazon Resource Name (ARN) of the function's execution role. The role provides the function's identity and access to AWS services and resources.

        The following arguments are optional:
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def runtime(self) -> pulumi.Output[Optional[str]]:
        """
        Identifier of the function's runtime. See [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_CreateFunction.html#SSS-CreateFunction-request-Runtime) for valid values.
        """
        return pulumi.get(self, "runtime")

    @property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> pulumi.Output[Optional[str]]:
        """
        S3 bucket location containing the function's deployment package. This bucket must reside in the same AWS region where you are creating the Lambda function. Exactly one of `filename`, `image_uri`, or `s3_bucket` must be specified. When `s3_bucket` is set, `s3_key` is required.
        """
        return pulumi.get(self, "s3_bucket")

    @property
    @pulumi.getter(name="s3Key")
    def s3_key(self) -> pulumi.Output[Optional[str]]:
        """
        S3 key of an object containing the function's deployment package. When `s3_bucket` is set, `s3_key` is required.
        """
        return pulumi.get(self, "s3_key")

    @property
    @pulumi.getter(name="s3ObjectVersion")
    def s3_object_version(self) -> pulumi.Output[Optional[str]]:
        """
        Object version containing the function's deployment package. Conflicts with `filename` and `image_uri`.
        """
        return pulumi.get(self, "s3_object_version")

    @property
    @pulumi.getter(name="signingJobArn")
    def signing_job_arn(self) -> pulumi.Output[str]:
        """
        ARN of the signing job.
        """
        return pulumi.get(self, "signing_job_arn")

    @property
    @pulumi.getter(name="signingProfileVersionArn")
    def signing_profile_version_arn(self) -> pulumi.Output[str]:
        """
        ARN of the signing profile version.
        * `snap_start.optimization_status` - Optimization status of the snap start configuration. Valid values are `On` and `Off`.
        """
        return pulumi.get(self, "signing_profile_version_arn")

    @property
    @pulumi.getter(name="skipDestroy")
    def skip_destroy(self) -> pulumi.Output[Optional[bool]]:
        """
        Set to true if you do not wish the function to be deleted at destroy time, and instead just remove the function from the Pulumi state.
        """
        return pulumi.get(self, "skip_destroy")

    @property
    @pulumi.getter(name="snapStart")
    def snap_start(self) -> pulumi.Output[Optional['outputs.FunctionSnapStart']]:
        """
        Snap start settings block. Detailed below.
        """
        return pulumi.get(self, "snap_start")

    @property
    @pulumi.getter(name="sourceCodeHash")
    def source_code_hash(self) -> pulumi.Output[str]:
        """
        Used to trigger updates. Must be set to a base64-encoded SHA256 hash of the package file specified with either `filename` or `s3_key`.
        """
        return pulumi.get(self, "source_code_hash")

    @property
    @pulumi.getter(name="sourceCodeSize")
    def source_code_size(self) -> pulumi.Output[int]:
        """
        Size in bytes of the function .zip file.
        """
        return pulumi.get(self, "source_code_size")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[Optional[int]]:
        """
        Amount of time your Lambda Function has to run in seconds. Defaults to `3`. See [Limits](https://docs.aws.amazon.com/lambda/latest/dg/limits.html).
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="tracingConfig")
    def tracing_config(self) -> pulumi.Output['outputs.FunctionTracingConfig']:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "tracing_config")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        Latest published version of your Lambda Function.
        * `vpc_config.vpc_id` - ID of the VPC.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> pulumi.Output[Optional['outputs.FunctionVpcConfig']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "vpc_config")

