# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ListenerDefaultActionArgs',
    'ListenerDefaultActionAuthenticateCognitoArgs',
    'ListenerDefaultActionAuthenticateOidcArgs',
    'ListenerDefaultActionFixedResponseArgs',
    'ListenerDefaultActionForwardArgs',
    'ListenerDefaultActionForwardStickinessArgs',
    'ListenerDefaultActionForwardTargetGroupArgs',
    'ListenerDefaultActionRedirectArgs',
    'ListenerRuleActionArgs',
    'ListenerRuleActionAuthenticateCognitoArgs',
    'ListenerRuleActionAuthenticateOidcArgs',
    'ListenerRuleActionFixedResponseArgs',
    'ListenerRuleActionForwardArgs',
    'ListenerRuleActionForwardStickinessArgs',
    'ListenerRuleActionForwardTargetGroupArgs',
    'ListenerRuleActionRedirectArgs',
    'ListenerRuleConditionArgs',
    'ListenerRuleConditionHostHeaderArgs',
    'ListenerRuleConditionHttpHeaderArgs',
    'ListenerRuleConditionHttpRequestMethodArgs',
    'ListenerRuleConditionPathPatternArgs',
    'ListenerRuleConditionQueryStringArgs',
    'ListenerRuleConditionSourceIpArgs',
    'LoadBalancerAccessLogsArgs',
    'LoadBalancerSubnetMappingArgs',
    'TargetGroupHealthCheckArgs',
    'TargetGroupStickinessArgs',
    'TargetGroupTargetFailoverArgs',
]

@pulumi.input_type
class ListenerDefaultActionArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 authenticate_cognito: Optional[pulumi.Input['ListenerDefaultActionAuthenticateCognitoArgs']] = None,
                 authenticate_oidc: Optional[pulumi.Input['ListenerDefaultActionAuthenticateOidcArgs']] = None,
                 fixed_response: Optional[pulumi.Input['ListenerDefaultActionFixedResponseArgs']] = None,
                 forward: Optional[pulumi.Input['ListenerDefaultActionForwardArgs']] = None,
                 order: Optional[pulumi.Input[int]] = None,
                 redirect: Optional[pulumi.Input['ListenerDefaultActionRedirectArgs']] = None,
                 target_group_arn: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: Type of routing action. Valid values are `forward`, `redirect`, `fixed-response`, `authenticate-cognito` and `authenticate-oidc`.
               
               The following arguments are optional:
        :param pulumi.Input['ListenerDefaultActionAuthenticateCognitoArgs'] authenticate_cognito: Configuration block for using Amazon Cognito to authenticate users. Specify only when `type` is `authenticate-cognito`. Detailed below.
        :param pulumi.Input['ListenerDefaultActionAuthenticateOidcArgs'] authenticate_oidc: Configuration block for an identity provider that is compliant with OpenID Connect (OIDC). Specify only when `type` is `authenticate-oidc`. Detailed below.
        :param pulumi.Input['ListenerDefaultActionFixedResponseArgs'] fixed_response: Information for creating an action that returns a custom HTTP response. Required if `type` is `fixed-response`.
        :param pulumi.Input['ListenerDefaultActionForwardArgs'] forward: Configuration block for creating an action that distributes requests among one or more target groups. Specify only if `type` is `forward`. If you specify both `forward` block and `target_group_arn` attribute, you can specify only one target group using `forward` and it must be the same target group specified in `target_group_arn`. Detailed below.
        :param pulumi.Input[int] order: Order for the action. This value is required for rules with multiple actions. The action with the lowest value for order is performed first. Valid values are between `1` and `50000`.
        :param pulumi.Input['ListenerDefaultActionRedirectArgs'] redirect: Configuration block for creating a redirect action. Required if `type` is `redirect`. Detailed below.
        :param pulumi.Input[str] target_group_arn: ARN of the Target Group to which to route traffic. Specify only if `type` is `forward` and you want to route to a single target group. To route to one or more target groups, use a `forward` block instead.
        """
        pulumi.set(__self__, "type", type)
        if authenticate_cognito is not None:
            pulumi.set(__self__, "authenticate_cognito", authenticate_cognito)
        if authenticate_oidc is not None:
            pulumi.set(__self__, "authenticate_oidc", authenticate_oidc)
        if fixed_response is not None:
            pulumi.set(__self__, "fixed_response", fixed_response)
        if forward is not None:
            pulumi.set(__self__, "forward", forward)
        if order is not None:
            pulumi.set(__self__, "order", order)
        if redirect is not None:
            pulumi.set(__self__, "redirect", redirect)
        if target_group_arn is not None:
            pulumi.set(__self__, "target_group_arn", target_group_arn)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of routing action. Valid values are `forward`, `redirect`, `fixed-response`, `authenticate-cognito` and `authenticate-oidc`.

        The following arguments are optional:
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="authenticateCognito")
    def authenticate_cognito(self) -> Optional[pulumi.Input['ListenerDefaultActionAuthenticateCognitoArgs']]:
        """
        Configuration block for using Amazon Cognito to authenticate users. Specify only when `type` is `authenticate-cognito`. Detailed below.
        """
        return pulumi.get(self, "authenticate_cognito")

    @authenticate_cognito.setter
    def authenticate_cognito(self, value: Optional[pulumi.Input['ListenerDefaultActionAuthenticateCognitoArgs']]):
        pulumi.set(self, "authenticate_cognito", value)

    @property
    @pulumi.getter(name="authenticateOidc")
    def authenticate_oidc(self) -> Optional[pulumi.Input['ListenerDefaultActionAuthenticateOidcArgs']]:
        """
        Configuration block for an identity provider that is compliant with OpenID Connect (OIDC). Specify only when `type` is `authenticate-oidc`. Detailed below.
        """
        return pulumi.get(self, "authenticate_oidc")

    @authenticate_oidc.setter
    def authenticate_oidc(self, value: Optional[pulumi.Input['ListenerDefaultActionAuthenticateOidcArgs']]):
        pulumi.set(self, "authenticate_oidc", value)

    @property
    @pulumi.getter(name="fixedResponse")
    def fixed_response(self) -> Optional[pulumi.Input['ListenerDefaultActionFixedResponseArgs']]:
        """
        Information for creating an action that returns a custom HTTP response. Required if `type` is `fixed-response`.
        """
        return pulumi.get(self, "fixed_response")

    @fixed_response.setter
    def fixed_response(self, value: Optional[pulumi.Input['ListenerDefaultActionFixedResponseArgs']]):
        pulumi.set(self, "fixed_response", value)

    @property
    @pulumi.getter
    def forward(self) -> Optional[pulumi.Input['ListenerDefaultActionForwardArgs']]:
        """
        Configuration block for creating an action that distributes requests among one or more target groups. Specify only if `type` is `forward`. If you specify both `forward` block and `target_group_arn` attribute, you can specify only one target group using `forward` and it must be the same target group specified in `target_group_arn`. Detailed below.
        """
        return pulumi.get(self, "forward")

    @forward.setter
    def forward(self, value: Optional[pulumi.Input['ListenerDefaultActionForwardArgs']]):
        pulumi.set(self, "forward", value)

    @property
    @pulumi.getter
    def order(self) -> Optional[pulumi.Input[int]]:
        """
        Order for the action. This value is required for rules with multiple actions. The action with the lowest value for order is performed first. Valid values are between `1` and `50000`.
        """
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "order", value)

    @property
    @pulumi.getter
    def redirect(self) -> Optional[pulumi.Input['ListenerDefaultActionRedirectArgs']]:
        """
        Configuration block for creating a redirect action. Required if `type` is `redirect`. Detailed below.
        """
        return pulumi.get(self, "redirect")

    @redirect.setter
    def redirect(self, value: Optional[pulumi.Input['ListenerDefaultActionRedirectArgs']]):
        pulumi.set(self, "redirect", value)

    @property
    @pulumi.getter(name="targetGroupArn")
    def target_group_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the Target Group to which to route traffic. Specify only if `type` is `forward` and you want to route to a single target group. To route to one or more target groups, use a `forward` block instead.
        """
        return pulumi.get(self, "target_group_arn")

    @target_group_arn.setter
    def target_group_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_group_arn", value)


@pulumi.input_type
class ListenerDefaultActionAuthenticateCognitoArgs:
    def __init__(__self__, *,
                 user_pool_arn: pulumi.Input[str],
                 user_pool_client_id: pulumi.Input[str],
                 user_pool_domain: pulumi.Input[str],
                 authentication_request_extra_params: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 on_unauthenticated_request: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 session_cookie_name: Optional[pulumi.Input[str]] = None,
                 session_timeout: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] user_pool_arn: ARN of the Cognito user pool.
        :param pulumi.Input[str] user_pool_client_id: ID of the Cognito user pool client.
        :param pulumi.Input[str] user_pool_domain: Domain prefix or fully-qualified domain name of the Cognito user pool.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] authentication_request_extra_params: Query parameters to include in the redirect request to the authorization endpoint. Max: 10. Detailed below.
        :param pulumi.Input[str] on_unauthenticated_request: Behavior if the user is not authenticated. Valid values are `deny`, `allow` and `authenticate`.
        :param pulumi.Input[str] scope: Set of user claims to be requested from the IdP.
        :param pulumi.Input[str] session_cookie_name: Name of the cookie used to maintain session information.
        :param pulumi.Input[int] session_timeout: Maximum duration of the authentication session, in seconds.
        """
        pulumi.set(__self__, "user_pool_arn", user_pool_arn)
        pulumi.set(__self__, "user_pool_client_id", user_pool_client_id)
        pulumi.set(__self__, "user_pool_domain", user_pool_domain)
        if authentication_request_extra_params is not None:
            pulumi.set(__self__, "authentication_request_extra_params", authentication_request_extra_params)
        if on_unauthenticated_request is not None:
            pulumi.set(__self__, "on_unauthenticated_request", on_unauthenticated_request)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if session_cookie_name is not None:
            pulumi.set(__self__, "session_cookie_name", session_cookie_name)
        if session_timeout is not None:
            pulumi.set(__self__, "session_timeout", session_timeout)

    @property
    @pulumi.getter(name="userPoolArn")
    def user_pool_arn(self) -> pulumi.Input[str]:
        """
        ARN of the Cognito user pool.
        """
        return pulumi.get(self, "user_pool_arn")

    @user_pool_arn.setter
    def user_pool_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_pool_arn", value)

    @property
    @pulumi.getter(name="userPoolClientId")
    def user_pool_client_id(self) -> pulumi.Input[str]:
        """
        ID of the Cognito user pool client.
        """
        return pulumi.get(self, "user_pool_client_id")

    @user_pool_client_id.setter
    def user_pool_client_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_pool_client_id", value)

    @property
    @pulumi.getter(name="userPoolDomain")
    def user_pool_domain(self) -> pulumi.Input[str]:
        """
        Domain prefix or fully-qualified domain name of the Cognito user pool.

        The following arguments are optional:
        """
        return pulumi.get(self, "user_pool_domain")

    @user_pool_domain.setter
    def user_pool_domain(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_pool_domain", value)

    @property
    @pulumi.getter(name="authenticationRequestExtraParams")
    def authentication_request_extra_params(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Query parameters to include in the redirect request to the authorization endpoint. Max: 10. Detailed below.
        """
        return pulumi.get(self, "authentication_request_extra_params")

    @authentication_request_extra_params.setter
    def authentication_request_extra_params(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "authentication_request_extra_params", value)

    @property
    @pulumi.getter(name="onUnauthenticatedRequest")
    def on_unauthenticated_request(self) -> Optional[pulumi.Input[str]]:
        """
        Behavior if the user is not authenticated. Valid values are `deny`, `allow` and `authenticate`.
        """
        return pulumi.get(self, "on_unauthenticated_request")

    @on_unauthenticated_request.setter
    def on_unauthenticated_request(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "on_unauthenticated_request", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        Set of user claims to be requested from the IdP.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="sessionCookieName")
    def session_cookie_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the cookie used to maintain session information.
        """
        return pulumi.get(self, "session_cookie_name")

    @session_cookie_name.setter
    def session_cookie_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "session_cookie_name", value)

    @property
    @pulumi.getter(name="sessionTimeout")
    def session_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum duration of the authentication session, in seconds.
        """
        return pulumi.get(self, "session_timeout")

    @session_timeout.setter
    def session_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "session_timeout", value)


@pulumi.input_type
class ListenerDefaultActionAuthenticateOidcArgs:
    def __init__(__self__, *,
                 authorization_endpoint: pulumi.Input[str],
                 client_id: pulumi.Input[str],
                 client_secret: pulumi.Input[str],
                 issuer: pulumi.Input[str],
                 token_endpoint: pulumi.Input[str],
                 user_info_endpoint: pulumi.Input[str],
                 authentication_request_extra_params: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 on_unauthenticated_request: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 session_cookie_name: Optional[pulumi.Input[str]] = None,
                 session_timeout: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] authorization_endpoint: Authorization endpoint of the IdP.
        :param pulumi.Input[str] client_id: OAuth 2.0 client identifier.
        :param pulumi.Input[str] client_secret: OAuth 2.0 client secret.
        :param pulumi.Input[str] issuer: OIDC issuer identifier of the IdP.
        :param pulumi.Input[str] token_endpoint: Token endpoint of the IdP.
        :param pulumi.Input[str] user_info_endpoint: User info endpoint of the IdP.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] authentication_request_extra_params: Query parameters to include in the redirect request to the authorization endpoint. Max: 10.
        :param pulumi.Input[str] on_unauthenticated_request: Behavior if the user is not authenticated. Valid values: `deny`, `allow` and `authenticate`
        :param pulumi.Input[str] scope: Set of user claims to be requested from the IdP.
        :param pulumi.Input[str] session_cookie_name: Name of the cookie used to maintain session information.
        :param pulumi.Input[int] session_timeout: Maximum duration of the authentication session, in seconds.
        """
        pulumi.set(__self__, "authorization_endpoint", authorization_endpoint)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret", client_secret)
        pulumi.set(__self__, "issuer", issuer)
        pulumi.set(__self__, "token_endpoint", token_endpoint)
        pulumi.set(__self__, "user_info_endpoint", user_info_endpoint)
        if authentication_request_extra_params is not None:
            pulumi.set(__self__, "authentication_request_extra_params", authentication_request_extra_params)
        if on_unauthenticated_request is not None:
            pulumi.set(__self__, "on_unauthenticated_request", on_unauthenticated_request)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if session_cookie_name is not None:
            pulumi.set(__self__, "session_cookie_name", session_cookie_name)
        if session_timeout is not None:
            pulumi.set(__self__, "session_timeout", session_timeout)

    @property
    @pulumi.getter(name="authorizationEndpoint")
    def authorization_endpoint(self) -> pulumi.Input[str]:
        """
        Authorization endpoint of the IdP.
        """
        return pulumi.get(self, "authorization_endpoint")

    @authorization_endpoint.setter
    def authorization_endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "authorization_endpoint", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[str]:
        """
        OAuth 2.0 client identifier.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Input[str]:
        """
        OAuth 2.0 client secret.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter
    def issuer(self) -> pulumi.Input[str]:
        """
        OIDC issuer identifier of the IdP.
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: pulumi.Input[str]):
        pulumi.set(self, "issuer", value)

    @property
    @pulumi.getter(name="tokenEndpoint")
    def token_endpoint(self) -> pulumi.Input[str]:
        """
        Token endpoint of the IdP.
        """
        return pulumi.get(self, "token_endpoint")

    @token_endpoint.setter
    def token_endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "token_endpoint", value)

    @property
    @pulumi.getter(name="userInfoEndpoint")
    def user_info_endpoint(self) -> pulumi.Input[str]:
        """
        User info endpoint of the IdP.

        The following arguments are optional:
        """
        return pulumi.get(self, "user_info_endpoint")

    @user_info_endpoint.setter
    def user_info_endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_info_endpoint", value)

    @property
    @pulumi.getter(name="authenticationRequestExtraParams")
    def authentication_request_extra_params(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Query parameters to include in the redirect request to the authorization endpoint. Max: 10.
        """
        return pulumi.get(self, "authentication_request_extra_params")

    @authentication_request_extra_params.setter
    def authentication_request_extra_params(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "authentication_request_extra_params", value)

    @property
    @pulumi.getter(name="onUnauthenticatedRequest")
    def on_unauthenticated_request(self) -> Optional[pulumi.Input[str]]:
        """
        Behavior if the user is not authenticated. Valid values: `deny`, `allow` and `authenticate`
        """
        return pulumi.get(self, "on_unauthenticated_request")

    @on_unauthenticated_request.setter
    def on_unauthenticated_request(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "on_unauthenticated_request", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        Set of user claims to be requested from the IdP.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="sessionCookieName")
    def session_cookie_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the cookie used to maintain session information.
        """
        return pulumi.get(self, "session_cookie_name")

    @session_cookie_name.setter
    def session_cookie_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "session_cookie_name", value)

    @property
    @pulumi.getter(name="sessionTimeout")
    def session_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum duration of the authentication session, in seconds.
        """
        return pulumi.get(self, "session_timeout")

    @session_timeout.setter
    def session_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "session_timeout", value)


@pulumi.input_type
class ListenerDefaultActionFixedResponseArgs:
    def __init__(__self__, *,
                 content_type: pulumi.Input[str],
                 message_body: Optional[pulumi.Input[str]] = None,
                 status_code: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] content_type: Content type. Valid values are `text/plain`, `text/css`, `text/html`, `application/javascript` and `application/json`.
               
               The following arguments are optional:
        :param pulumi.Input[str] message_body: Message body.
        :param pulumi.Input[str] status_code: HTTP response code. Valid values are `2XX`, `4XX`, or `5XX`.
        """
        pulumi.set(__self__, "content_type", content_type)
        if message_body is not None:
            pulumi.set(__self__, "message_body", message_body)
        if status_code is not None:
            pulumi.set(__self__, "status_code", status_code)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> pulumi.Input[str]:
        """
        Content type. Valid values are `text/plain`, `text/css`, `text/html`, `application/javascript` and `application/json`.

        The following arguments are optional:
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter(name="messageBody")
    def message_body(self) -> Optional[pulumi.Input[str]]:
        """
        Message body.
        """
        return pulumi.get(self, "message_body")

    @message_body.setter
    def message_body(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_body", value)

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> Optional[pulumi.Input[str]]:
        """
        HTTP response code. Valid values are `2XX`, `4XX`, or `5XX`.
        """
        return pulumi.get(self, "status_code")

    @status_code.setter
    def status_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status_code", value)


@pulumi.input_type
class ListenerDefaultActionForwardArgs:
    def __init__(__self__, *,
                 target_groups: pulumi.Input[Sequence[pulumi.Input['ListenerDefaultActionForwardTargetGroupArgs']]],
                 stickiness: Optional[pulumi.Input['ListenerDefaultActionForwardStickinessArgs']] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ListenerDefaultActionForwardTargetGroupArgs']]] target_groups: Set of 1-5 target group blocks. Detailed below.
               
               The following arguments are optional:
        :param pulumi.Input['ListenerDefaultActionForwardStickinessArgs'] stickiness: Configuration block for target group stickiness for the rule. Detailed below.
        """
        pulumi.set(__self__, "target_groups", target_groups)
        if stickiness is not None:
            pulumi.set(__self__, "stickiness", stickiness)

    @property
    @pulumi.getter(name="targetGroups")
    def target_groups(self) -> pulumi.Input[Sequence[pulumi.Input['ListenerDefaultActionForwardTargetGroupArgs']]]:
        """
        Set of 1-5 target group blocks. Detailed below.

        The following arguments are optional:
        """
        return pulumi.get(self, "target_groups")

    @target_groups.setter
    def target_groups(self, value: pulumi.Input[Sequence[pulumi.Input['ListenerDefaultActionForwardTargetGroupArgs']]]):
        pulumi.set(self, "target_groups", value)

    @property
    @pulumi.getter
    def stickiness(self) -> Optional[pulumi.Input['ListenerDefaultActionForwardStickinessArgs']]:
        """
        Configuration block for target group stickiness for the rule. Detailed below.
        """
        return pulumi.get(self, "stickiness")

    @stickiness.setter
    def stickiness(self, value: Optional[pulumi.Input['ListenerDefaultActionForwardStickinessArgs']]):
        pulumi.set(self, "stickiness", value)


@pulumi.input_type
class ListenerDefaultActionForwardStickinessArgs:
    def __init__(__self__, *,
                 duration: pulumi.Input[int],
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[int] duration: Time period, in seconds, during which requests from a client should be routed to the same target group. The range is 1-604800 seconds (7 days).
               
               The following arguments are optional:
        :param pulumi.Input[bool] enabled: Whether target group stickiness is enabled. Default is `false`.
        """
        pulumi.set(__self__, "duration", duration)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def duration(self) -> pulumi.Input[int]:
        """
        Time period, in seconds, during which requests from a client should be routed to the same target group. The range is 1-604800 seconds (7 days).

        The following arguments are optional:
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: pulumi.Input[int]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether target group stickiness is enabled. Default is `false`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class ListenerDefaultActionForwardTargetGroupArgs:
    def __init__(__self__, *,
                 arn: pulumi.Input[str],
                 weight: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] arn: ARN of the target group.
               
               The following arguments are optional:
        :param pulumi.Input[int] weight: Weight. The range is 0 to 999.
        """
        pulumi.set(__self__, "arn", arn)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Input[str]:
        """
        ARN of the target group.

        The following arguments are optional:
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[int]]:
        """
        Weight. The range is 0 to 999.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "weight", value)


@pulumi.input_type
class ListenerDefaultActionRedirectArgs:
    def __init__(__self__, *,
                 status_code: pulumi.Input[str],
                 host: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 query: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] status_code: HTTP redirect code. The redirect is either permanent (`HTTP_301`) or temporary (`HTTP_302`).
               
               The following arguments are optional:
        :param pulumi.Input[str] host: Hostname. This component is not percent-encoded. The hostname can contain `#{host}`. Defaults to `#{host}`.
        :param pulumi.Input[str] path: Absolute path, starting with the leading "/". This component is not percent-encoded. The path can contain #{host}, #{path}, and #{port}. Defaults to `/#{path}`.
        :param pulumi.Input[str] port: Port. Specify a value from `1` to `65535` or `#{port}`. Defaults to `#{port}`.
        :param pulumi.Input[str] protocol: Protocol. Valid values are `HTTP`, `HTTPS`, or `#{protocol}`. Defaults to `#{protocol}`.
        :param pulumi.Input[str] query: Query parameters, URL-encoded when necessary, but not percent-encoded. Do not include the leading "?". Defaults to `#{query}`.
        """
        pulumi.set(__self__, "status_code", status_code)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if query is not None:
            pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> pulumi.Input[str]:
        """
        HTTP redirect code. The redirect is either permanent (`HTTP_301`) or temporary (`HTTP_302`).

        The following arguments are optional:
        """
        return pulumi.get(self, "status_code")

    @status_code.setter
    def status_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "status_code", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        Hostname. This component is not percent-encoded. The hostname can contain `#{host}`. Defaults to `#{host}`.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Absolute path, starting with the leading "/". This component is not percent-encoded. The path can contain #{host}, #{path}, and #{port}. Defaults to `/#{path}`.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[str]]:
        """
        Port. Specify a value from `1` to `65535` or `#{port}`. Defaults to `#{port}`.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Protocol. Valid values are `HTTP`, `HTTPS`, or `#{protocol}`. Defaults to `#{protocol}`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input[str]]:
        """
        Query parameters, URL-encoded when necessary, but not percent-encoded. Do not include the leading "?". Defaults to `#{query}`.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query", value)


@pulumi.input_type
class ListenerRuleActionArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 authenticate_cognito: Optional[pulumi.Input['ListenerRuleActionAuthenticateCognitoArgs']] = None,
                 authenticate_oidc: Optional[pulumi.Input['ListenerRuleActionAuthenticateOidcArgs']] = None,
                 fixed_response: Optional[pulumi.Input['ListenerRuleActionFixedResponseArgs']] = None,
                 forward: Optional[pulumi.Input['ListenerRuleActionForwardArgs']] = None,
                 order: Optional[pulumi.Input[int]] = None,
                 redirect: Optional[pulumi.Input['ListenerRuleActionRedirectArgs']] = None,
                 target_group_arn: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: The type of routing action. Valid values are `forward`, `redirect`, `fixed-response`, `authenticate-cognito` and `authenticate-oidc`.
        :param pulumi.Input['ListenerRuleActionAuthenticateCognitoArgs'] authenticate_cognito: Information for creating an authenticate action using Cognito. Required if `type` is `authenticate-cognito`.
        :param pulumi.Input['ListenerRuleActionAuthenticateOidcArgs'] authenticate_oidc: Information for creating an authenticate action using OIDC. Required if `type` is `authenticate-oidc`.
        :param pulumi.Input['ListenerRuleActionFixedResponseArgs'] fixed_response: Information for creating an action that returns a custom HTTP response. Required if `type` is `fixed-response`.
        :param pulumi.Input['ListenerRuleActionForwardArgs'] forward: Information for creating an action that distributes requests among one or more target groups. Specify only if `type` is `forward`. If you specify both `forward` block and `target_group_arn` attribute, you can specify only one target group using `forward` and it must be the same target group specified in `target_group_arn`.
        :param pulumi.Input['ListenerRuleActionRedirectArgs'] redirect: Information for creating a redirect action. Required if `type` is `redirect`.
        :param pulumi.Input[str] target_group_arn: The ARN of the Target Group to which to route traffic. Specify only if `type` is `forward` and you want to route to a single target group. To route to one or more target groups, use a `forward` block instead.
        """
        pulumi.set(__self__, "type", type)
        if authenticate_cognito is not None:
            pulumi.set(__self__, "authenticate_cognito", authenticate_cognito)
        if authenticate_oidc is not None:
            pulumi.set(__self__, "authenticate_oidc", authenticate_oidc)
        if fixed_response is not None:
            pulumi.set(__self__, "fixed_response", fixed_response)
        if forward is not None:
            pulumi.set(__self__, "forward", forward)
        if order is not None:
            pulumi.set(__self__, "order", order)
        if redirect is not None:
            pulumi.set(__self__, "redirect", redirect)
        if target_group_arn is not None:
            pulumi.set(__self__, "target_group_arn", target_group_arn)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of routing action. Valid values are `forward`, `redirect`, `fixed-response`, `authenticate-cognito` and `authenticate-oidc`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="authenticateCognito")
    def authenticate_cognito(self) -> Optional[pulumi.Input['ListenerRuleActionAuthenticateCognitoArgs']]:
        """
        Information for creating an authenticate action using Cognito. Required if `type` is `authenticate-cognito`.
        """
        return pulumi.get(self, "authenticate_cognito")

    @authenticate_cognito.setter
    def authenticate_cognito(self, value: Optional[pulumi.Input['ListenerRuleActionAuthenticateCognitoArgs']]):
        pulumi.set(self, "authenticate_cognito", value)

    @property
    @pulumi.getter(name="authenticateOidc")
    def authenticate_oidc(self) -> Optional[pulumi.Input['ListenerRuleActionAuthenticateOidcArgs']]:
        """
        Information for creating an authenticate action using OIDC. Required if `type` is `authenticate-oidc`.
        """
        return pulumi.get(self, "authenticate_oidc")

    @authenticate_oidc.setter
    def authenticate_oidc(self, value: Optional[pulumi.Input['ListenerRuleActionAuthenticateOidcArgs']]):
        pulumi.set(self, "authenticate_oidc", value)

    @property
    @pulumi.getter(name="fixedResponse")
    def fixed_response(self) -> Optional[pulumi.Input['ListenerRuleActionFixedResponseArgs']]:
        """
        Information for creating an action that returns a custom HTTP response. Required if `type` is `fixed-response`.
        """
        return pulumi.get(self, "fixed_response")

    @fixed_response.setter
    def fixed_response(self, value: Optional[pulumi.Input['ListenerRuleActionFixedResponseArgs']]):
        pulumi.set(self, "fixed_response", value)

    @property
    @pulumi.getter
    def forward(self) -> Optional[pulumi.Input['ListenerRuleActionForwardArgs']]:
        """
        Information for creating an action that distributes requests among one or more target groups. Specify only if `type` is `forward`. If you specify both `forward` block and `target_group_arn` attribute, you can specify only one target group using `forward` and it must be the same target group specified in `target_group_arn`.
        """
        return pulumi.get(self, "forward")

    @forward.setter
    def forward(self, value: Optional[pulumi.Input['ListenerRuleActionForwardArgs']]):
        pulumi.set(self, "forward", value)

    @property
    @pulumi.getter
    def order(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "order", value)

    @property
    @pulumi.getter
    def redirect(self) -> Optional[pulumi.Input['ListenerRuleActionRedirectArgs']]:
        """
        Information for creating a redirect action. Required if `type` is `redirect`.
        """
        return pulumi.get(self, "redirect")

    @redirect.setter
    def redirect(self, value: Optional[pulumi.Input['ListenerRuleActionRedirectArgs']]):
        pulumi.set(self, "redirect", value)

    @property
    @pulumi.getter(name="targetGroupArn")
    def target_group_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the Target Group to which to route traffic. Specify only if `type` is `forward` and you want to route to a single target group. To route to one or more target groups, use a `forward` block instead.
        """
        return pulumi.get(self, "target_group_arn")

    @target_group_arn.setter
    def target_group_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_group_arn", value)


@pulumi.input_type
class ListenerRuleActionAuthenticateCognitoArgs:
    def __init__(__self__, *,
                 user_pool_arn: pulumi.Input[str],
                 user_pool_client_id: pulumi.Input[str],
                 user_pool_domain: pulumi.Input[str],
                 authentication_request_extra_params: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 on_unauthenticated_request: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 session_cookie_name: Optional[pulumi.Input[str]] = None,
                 session_timeout: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] user_pool_arn: The ARN of the Cognito user pool.
        :param pulumi.Input[str] user_pool_client_id: The ID of the Cognito user pool client.
        :param pulumi.Input[str] user_pool_domain: The domain prefix or fully-qualified domain name of the Cognito user pool.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] authentication_request_extra_params: The query parameters to include in the redirect request to the authorization endpoint. Max: 10.
        :param pulumi.Input[str] on_unauthenticated_request: The behavior if the user is not authenticated. Valid values: `deny`, `allow` and `authenticate`
        :param pulumi.Input[str] scope: The set of user claims to be requested from the IdP.
        :param pulumi.Input[str] session_cookie_name: The name of the cookie used to maintain session information.
        :param pulumi.Input[int] session_timeout: The maximum duration of the authentication session, in seconds.
        """
        pulumi.set(__self__, "user_pool_arn", user_pool_arn)
        pulumi.set(__self__, "user_pool_client_id", user_pool_client_id)
        pulumi.set(__self__, "user_pool_domain", user_pool_domain)
        if authentication_request_extra_params is not None:
            pulumi.set(__self__, "authentication_request_extra_params", authentication_request_extra_params)
        if on_unauthenticated_request is not None:
            pulumi.set(__self__, "on_unauthenticated_request", on_unauthenticated_request)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if session_cookie_name is not None:
            pulumi.set(__self__, "session_cookie_name", session_cookie_name)
        if session_timeout is not None:
            pulumi.set(__self__, "session_timeout", session_timeout)

    @property
    @pulumi.getter(name="userPoolArn")
    def user_pool_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the Cognito user pool.
        """
        return pulumi.get(self, "user_pool_arn")

    @user_pool_arn.setter
    def user_pool_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_pool_arn", value)

    @property
    @pulumi.getter(name="userPoolClientId")
    def user_pool_client_id(self) -> pulumi.Input[str]:
        """
        The ID of the Cognito user pool client.
        """
        return pulumi.get(self, "user_pool_client_id")

    @user_pool_client_id.setter
    def user_pool_client_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_pool_client_id", value)

    @property
    @pulumi.getter(name="userPoolDomain")
    def user_pool_domain(self) -> pulumi.Input[str]:
        """
        The domain prefix or fully-qualified domain name of the Cognito user pool.
        """
        return pulumi.get(self, "user_pool_domain")

    @user_pool_domain.setter
    def user_pool_domain(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_pool_domain", value)

    @property
    @pulumi.getter(name="authenticationRequestExtraParams")
    def authentication_request_extra_params(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The query parameters to include in the redirect request to the authorization endpoint. Max: 10.
        """
        return pulumi.get(self, "authentication_request_extra_params")

    @authentication_request_extra_params.setter
    def authentication_request_extra_params(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "authentication_request_extra_params", value)

    @property
    @pulumi.getter(name="onUnauthenticatedRequest")
    def on_unauthenticated_request(self) -> Optional[pulumi.Input[str]]:
        """
        The behavior if the user is not authenticated. Valid values: `deny`, `allow` and `authenticate`
        """
        return pulumi.get(self, "on_unauthenticated_request")

    @on_unauthenticated_request.setter
    def on_unauthenticated_request(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "on_unauthenticated_request", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        The set of user claims to be requested from the IdP.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="sessionCookieName")
    def session_cookie_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the cookie used to maintain session information.
        """
        return pulumi.get(self, "session_cookie_name")

    @session_cookie_name.setter
    def session_cookie_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "session_cookie_name", value)

    @property
    @pulumi.getter(name="sessionTimeout")
    def session_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum duration of the authentication session, in seconds.
        """
        return pulumi.get(self, "session_timeout")

    @session_timeout.setter
    def session_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "session_timeout", value)


@pulumi.input_type
class ListenerRuleActionAuthenticateOidcArgs:
    def __init__(__self__, *,
                 authorization_endpoint: pulumi.Input[str],
                 client_id: pulumi.Input[str],
                 client_secret: pulumi.Input[str],
                 issuer: pulumi.Input[str],
                 token_endpoint: pulumi.Input[str],
                 user_info_endpoint: pulumi.Input[str],
                 authentication_request_extra_params: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 on_unauthenticated_request: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 session_cookie_name: Optional[pulumi.Input[str]] = None,
                 session_timeout: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] authorization_endpoint: The authorization endpoint of the IdP.
        :param pulumi.Input[str] client_id: The OAuth 2.0 client identifier.
        :param pulumi.Input[str] client_secret: The OAuth 2.0 client secret.
        :param pulumi.Input[str] issuer: The OIDC issuer identifier of the IdP.
        :param pulumi.Input[str] token_endpoint: The token endpoint of the IdP.
        :param pulumi.Input[str] user_info_endpoint: The user info endpoint of the IdP.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] authentication_request_extra_params: The query parameters to include in the redirect request to the authorization endpoint. Max: 10.
        :param pulumi.Input[str] on_unauthenticated_request: The behavior if the user is not authenticated. Valid values: `deny`, `allow` and `authenticate`
        :param pulumi.Input[str] scope: The set of user claims to be requested from the IdP.
        :param pulumi.Input[str] session_cookie_name: The name of the cookie used to maintain session information.
        :param pulumi.Input[int] session_timeout: The maximum duration of the authentication session, in seconds.
        """
        pulumi.set(__self__, "authorization_endpoint", authorization_endpoint)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret", client_secret)
        pulumi.set(__self__, "issuer", issuer)
        pulumi.set(__self__, "token_endpoint", token_endpoint)
        pulumi.set(__self__, "user_info_endpoint", user_info_endpoint)
        if authentication_request_extra_params is not None:
            pulumi.set(__self__, "authentication_request_extra_params", authentication_request_extra_params)
        if on_unauthenticated_request is not None:
            pulumi.set(__self__, "on_unauthenticated_request", on_unauthenticated_request)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if session_cookie_name is not None:
            pulumi.set(__self__, "session_cookie_name", session_cookie_name)
        if session_timeout is not None:
            pulumi.set(__self__, "session_timeout", session_timeout)

    @property
    @pulumi.getter(name="authorizationEndpoint")
    def authorization_endpoint(self) -> pulumi.Input[str]:
        """
        The authorization endpoint of the IdP.
        """
        return pulumi.get(self, "authorization_endpoint")

    @authorization_endpoint.setter
    def authorization_endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "authorization_endpoint", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[str]:
        """
        The OAuth 2.0 client identifier.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Input[str]:
        """
        The OAuth 2.0 client secret.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter
    def issuer(self) -> pulumi.Input[str]:
        """
        The OIDC issuer identifier of the IdP.
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: pulumi.Input[str]):
        pulumi.set(self, "issuer", value)

    @property
    @pulumi.getter(name="tokenEndpoint")
    def token_endpoint(self) -> pulumi.Input[str]:
        """
        The token endpoint of the IdP.
        """
        return pulumi.get(self, "token_endpoint")

    @token_endpoint.setter
    def token_endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "token_endpoint", value)

    @property
    @pulumi.getter(name="userInfoEndpoint")
    def user_info_endpoint(self) -> pulumi.Input[str]:
        """
        The user info endpoint of the IdP.
        """
        return pulumi.get(self, "user_info_endpoint")

    @user_info_endpoint.setter
    def user_info_endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_info_endpoint", value)

    @property
    @pulumi.getter(name="authenticationRequestExtraParams")
    def authentication_request_extra_params(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The query parameters to include in the redirect request to the authorization endpoint. Max: 10.
        """
        return pulumi.get(self, "authentication_request_extra_params")

    @authentication_request_extra_params.setter
    def authentication_request_extra_params(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "authentication_request_extra_params", value)

    @property
    @pulumi.getter(name="onUnauthenticatedRequest")
    def on_unauthenticated_request(self) -> Optional[pulumi.Input[str]]:
        """
        The behavior if the user is not authenticated. Valid values: `deny`, `allow` and `authenticate`
        """
        return pulumi.get(self, "on_unauthenticated_request")

    @on_unauthenticated_request.setter
    def on_unauthenticated_request(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "on_unauthenticated_request", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        The set of user claims to be requested from the IdP.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="sessionCookieName")
    def session_cookie_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the cookie used to maintain session information.
        """
        return pulumi.get(self, "session_cookie_name")

    @session_cookie_name.setter
    def session_cookie_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "session_cookie_name", value)

    @property
    @pulumi.getter(name="sessionTimeout")
    def session_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum duration of the authentication session, in seconds.
        """
        return pulumi.get(self, "session_timeout")

    @session_timeout.setter
    def session_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "session_timeout", value)


@pulumi.input_type
class ListenerRuleActionFixedResponseArgs:
    def __init__(__self__, *,
                 content_type: pulumi.Input[str],
                 message_body: Optional[pulumi.Input[str]] = None,
                 status_code: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] content_type: The content type. Valid values are `text/plain`, `text/css`, `text/html`, `application/javascript` and `application/json`.
        :param pulumi.Input[str] message_body: The message body.
        :param pulumi.Input[str] status_code: The HTTP response code. Valid values are `2XX`, `4XX`, or `5XX`.
        """
        pulumi.set(__self__, "content_type", content_type)
        if message_body is not None:
            pulumi.set(__self__, "message_body", message_body)
        if status_code is not None:
            pulumi.set(__self__, "status_code", status_code)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> pulumi.Input[str]:
        """
        The content type. Valid values are `text/plain`, `text/css`, `text/html`, `application/javascript` and `application/json`.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter(name="messageBody")
    def message_body(self) -> Optional[pulumi.Input[str]]:
        """
        The message body.
        """
        return pulumi.get(self, "message_body")

    @message_body.setter
    def message_body(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_body", value)

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> Optional[pulumi.Input[str]]:
        """
        The HTTP response code. Valid values are `2XX`, `4XX`, or `5XX`.
        """
        return pulumi.get(self, "status_code")

    @status_code.setter
    def status_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status_code", value)


@pulumi.input_type
class ListenerRuleActionForwardArgs:
    def __init__(__self__, *,
                 target_groups: pulumi.Input[Sequence[pulumi.Input['ListenerRuleActionForwardTargetGroupArgs']]],
                 stickiness: Optional[pulumi.Input['ListenerRuleActionForwardStickinessArgs']] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ListenerRuleActionForwardTargetGroupArgs']]] target_groups: One or more target groups block.
        :param pulumi.Input['ListenerRuleActionForwardStickinessArgs'] stickiness: The target group stickiness for the rule.
        """
        pulumi.set(__self__, "target_groups", target_groups)
        if stickiness is not None:
            pulumi.set(__self__, "stickiness", stickiness)

    @property
    @pulumi.getter(name="targetGroups")
    def target_groups(self) -> pulumi.Input[Sequence[pulumi.Input['ListenerRuleActionForwardTargetGroupArgs']]]:
        """
        One or more target groups block.
        """
        return pulumi.get(self, "target_groups")

    @target_groups.setter
    def target_groups(self, value: pulumi.Input[Sequence[pulumi.Input['ListenerRuleActionForwardTargetGroupArgs']]]):
        pulumi.set(self, "target_groups", value)

    @property
    @pulumi.getter
    def stickiness(self) -> Optional[pulumi.Input['ListenerRuleActionForwardStickinessArgs']]:
        """
        The target group stickiness for the rule.
        """
        return pulumi.get(self, "stickiness")

    @stickiness.setter
    def stickiness(self, value: Optional[pulumi.Input['ListenerRuleActionForwardStickinessArgs']]):
        pulumi.set(self, "stickiness", value)


@pulumi.input_type
class ListenerRuleActionForwardStickinessArgs:
    def __init__(__self__, *,
                 duration: pulumi.Input[int],
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[int] duration: The time period, in seconds, during which requests from a client should be routed to the same target group. The range is 1-604800 seconds (7 days).
        :param pulumi.Input[bool] enabled: Indicates whether target group stickiness is enabled.
        """
        pulumi.set(__self__, "duration", duration)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def duration(self) -> pulumi.Input[int]:
        """
        The time period, in seconds, during which requests from a client should be routed to the same target group. The range is 1-604800 seconds (7 days).
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: pulumi.Input[int]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether target group stickiness is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class ListenerRuleActionForwardTargetGroupArgs:
    def __init__(__self__, *,
                 arn: pulumi.Input[str],
                 weight: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] arn: The Amazon Resource Name (ARN) of the target group.
        :param pulumi.Input[int] weight: The weight. The range is 0 to 999.
        """
        pulumi.set(__self__, "arn", arn)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) of the target group.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[int]]:
        """
        The weight. The range is 0 to 999.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "weight", value)


@pulumi.input_type
class ListenerRuleActionRedirectArgs:
    def __init__(__self__, *,
                 status_code: pulumi.Input[str],
                 host: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 query: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] status_code: The HTTP redirect code. The redirect is either permanent (`HTTP_301`) or temporary (`HTTP_302`).
        :param pulumi.Input[str] host: The hostname. This component is not percent-encoded. The hostname can contain `#{host}`. Defaults to `#{host}`.
        :param pulumi.Input[str] path: The absolute path, starting with the leading "/". This component is not percent-encoded. The path can contain #{host}, #{path}, and #{port}. Defaults to `/#{path}`.
        :param pulumi.Input[str] port: The port. Specify a value from `1` to `65535` or `#{port}`. Defaults to `#{port}`.
        :param pulumi.Input[str] protocol: The protocol. Valid values are `HTTP`, `HTTPS`, or `#{protocol}`. Defaults to `#{protocol}`.
        :param pulumi.Input[str] query: The query parameters, URL-encoded when necessary, but not percent-encoded. Do not include the leading "?". Defaults to `#{query}`.
        """
        pulumi.set(__self__, "status_code", status_code)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if query is not None:
            pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> pulumi.Input[str]:
        """
        The HTTP redirect code. The redirect is either permanent (`HTTP_301`) or temporary (`HTTP_302`).
        """
        return pulumi.get(self, "status_code")

    @status_code.setter
    def status_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "status_code", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname. This component is not percent-encoded. The hostname can contain `#{host}`. Defaults to `#{host}`.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The absolute path, starting with the leading "/". This component is not percent-encoded. The path can contain #{host}, #{path}, and #{port}. Defaults to `/#{path}`.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[str]]:
        """
        The port. Specify a value from `1` to `65535` or `#{port}`. Defaults to `#{port}`.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol. Valid values are `HTTP`, `HTTPS`, or `#{protocol}`. Defaults to `#{protocol}`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input[str]]:
        """
        The query parameters, URL-encoded when necessary, but not percent-encoded. Do not include the leading "?". Defaults to `#{query}`.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query", value)


@pulumi.input_type
class ListenerRuleConditionArgs:
    def __init__(__self__, *,
                 host_header: Optional[pulumi.Input['ListenerRuleConditionHostHeaderArgs']] = None,
                 http_header: Optional[pulumi.Input['ListenerRuleConditionHttpHeaderArgs']] = None,
                 http_request_method: Optional[pulumi.Input['ListenerRuleConditionHttpRequestMethodArgs']] = None,
                 path_pattern: Optional[pulumi.Input['ListenerRuleConditionPathPatternArgs']] = None,
                 query_strings: Optional[pulumi.Input[Sequence[pulumi.Input['ListenerRuleConditionQueryStringArgs']]]] = None,
                 source_ip: Optional[pulumi.Input['ListenerRuleConditionSourceIpArgs']] = None):
        """
        :param pulumi.Input['ListenerRuleConditionHostHeaderArgs'] host_header: Contains a single `values` item which is a list of host header patterns to match. The maximum size of each pattern is 128 characters. Comparison is case insensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). Only one pattern needs to match for the condition to be satisfied.
        :param pulumi.Input['ListenerRuleConditionHttpHeaderArgs'] http_header: HTTP headers to match. HTTP Header block fields documented below.
        :param pulumi.Input['ListenerRuleConditionHttpRequestMethodArgs'] http_request_method: Contains a single `values` item which is a list of HTTP request methods or verbs to match. Maximum size is 40 characters. Only allowed characters are A-Z, hyphen (-) and underscore (\\_). Comparison is case sensitive. Wildcards are not supported. Only one needs to match for the condition to be satisfied. AWS recommends that GET and HEAD requests are routed in the same way because the response to a HEAD request may be cached.
        :param pulumi.Input['ListenerRuleConditionPathPatternArgs'] path_pattern: Contains a single `values` item which is a list of path patterns to match against the request URL. Maximum size of each pattern is 128 characters. Comparison is case sensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). Only one pattern needs to match for the condition to be satisfied. Path pattern is compared only to the path of the URL, not to its query string. To compare against the query string, use a `query_string` condition.
        :param pulumi.Input[Sequence[pulumi.Input['ListenerRuleConditionQueryStringArgs']]] query_strings: Query strings to match. Query String block fields documented below.
        :param pulumi.Input['ListenerRuleConditionSourceIpArgs'] source_ip: Contains a single `values` item which is a list of source IP CIDR notations to match. You can use both IPv4 and IPv6 addresses. Wildcards are not supported. Condition is satisfied if the source IP address of the request matches one of the CIDR blocks. Condition is not satisfied by the addresses in the `X-Forwarded-For` header, use `http_header` condition instead.
               
               > **NOTE::** Exactly one of `host_header`, `http_header`, `http_request_method`, `path_pattern`, `query_string` or `source_ip` must be set per condition.
        """
        if host_header is not None:
            pulumi.set(__self__, "host_header", host_header)
        if http_header is not None:
            pulumi.set(__self__, "http_header", http_header)
        if http_request_method is not None:
            pulumi.set(__self__, "http_request_method", http_request_method)
        if path_pattern is not None:
            pulumi.set(__self__, "path_pattern", path_pattern)
        if query_strings is not None:
            pulumi.set(__self__, "query_strings", query_strings)
        if source_ip is not None:
            pulumi.set(__self__, "source_ip", source_ip)

    @property
    @pulumi.getter(name="hostHeader")
    def host_header(self) -> Optional[pulumi.Input['ListenerRuleConditionHostHeaderArgs']]:
        """
        Contains a single `values` item which is a list of host header patterns to match. The maximum size of each pattern is 128 characters. Comparison is case insensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). Only one pattern needs to match for the condition to be satisfied.
        """
        return pulumi.get(self, "host_header")

    @host_header.setter
    def host_header(self, value: Optional[pulumi.Input['ListenerRuleConditionHostHeaderArgs']]):
        pulumi.set(self, "host_header", value)

    @property
    @pulumi.getter(name="httpHeader")
    def http_header(self) -> Optional[pulumi.Input['ListenerRuleConditionHttpHeaderArgs']]:
        """
        HTTP headers to match. HTTP Header block fields documented below.
        """
        return pulumi.get(self, "http_header")

    @http_header.setter
    def http_header(self, value: Optional[pulumi.Input['ListenerRuleConditionHttpHeaderArgs']]):
        pulumi.set(self, "http_header", value)

    @property
    @pulumi.getter(name="httpRequestMethod")
    def http_request_method(self) -> Optional[pulumi.Input['ListenerRuleConditionHttpRequestMethodArgs']]:
        """
        Contains a single `values` item which is a list of HTTP request methods or verbs to match. Maximum size is 40 characters. Only allowed characters are A-Z, hyphen (-) and underscore (\\_). Comparison is case sensitive. Wildcards are not supported. Only one needs to match for the condition to be satisfied. AWS recommends that GET and HEAD requests are routed in the same way because the response to a HEAD request may be cached.
        """
        return pulumi.get(self, "http_request_method")

    @http_request_method.setter
    def http_request_method(self, value: Optional[pulumi.Input['ListenerRuleConditionHttpRequestMethodArgs']]):
        pulumi.set(self, "http_request_method", value)

    @property
    @pulumi.getter(name="pathPattern")
    def path_pattern(self) -> Optional[pulumi.Input['ListenerRuleConditionPathPatternArgs']]:
        """
        Contains a single `values` item which is a list of path patterns to match against the request URL. Maximum size of each pattern is 128 characters. Comparison is case sensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). Only one pattern needs to match for the condition to be satisfied. Path pattern is compared only to the path of the URL, not to its query string. To compare against the query string, use a `query_string` condition.
        """
        return pulumi.get(self, "path_pattern")

    @path_pattern.setter
    def path_pattern(self, value: Optional[pulumi.Input['ListenerRuleConditionPathPatternArgs']]):
        pulumi.set(self, "path_pattern", value)

    @property
    @pulumi.getter(name="queryStrings")
    def query_strings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ListenerRuleConditionQueryStringArgs']]]]:
        """
        Query strings to match. Query String block fields documented below.
        """
        return pulumi.get(self, "query_strings")

    @query_strings.setter
    def query_strings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ListenerRuleConditionQueryStringArgs']]]]):
        pulumi.set(self, "query_strings", value)

    @property
    @pulumi.getter(name="sourceIp")
    def source_ip(self) -> Optional[pulumi.Input['ListenerRuleConditionSourceIpArgs']]:
        """
        Contains a single `values` item which is a list of source IP CIDR notations to match. You can use both IPv4 and IPv6 addresses. Wildcards are not supported. Condition is satisfied if the source IP address of the request matches one of the CIDR blocks. Condition is not satisfied by the addresses in the `X-Forwarded-For` header, use `http_header` condition instead.

        > **NOTE::** Exactly one of `host_header`, `http_header`, `http_request_method`, `path_pattern`, `query_string` or `source_ip` must be set per condition.
        """
        return pulumi.get(self, "source_ip")

    @source_ip.setter
    def source_ip(self, value: Optional[pulumi.Input['ListenerRuleConditionSourceIpArgs']]):
        pulumi.set(self, "source_ip", value)


@pulumi.input_type
class ListenerRuleConditionHostHeaderArgs:
    def __init__(__self__, *,
                 values: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: List of header value patterns to match. Maximum size of each pattern is 128 characters. Comparison is case insensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). If the same header appears multiple times in the request they will be searched in order until a match is found. Only one pattern needs to match for the condition to be satisfied. To require that all of the strings are a match, create one condition block per string.
               
               
               Query String Value Blocks (for `query_string.values`) support the following:
        """
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def values(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of header value patterns to match. Maximum size of each pattern is 128 characters. Comparison is case insensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). If the same header appears multiple times in the request they will be searched in order until a match is found. Only one pattern needs to match for the condition to be satisfied. To require that all of the strings are a match, create one condition block per string.


        Query String Value Blocks (for `query_string.values`) support the following:
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class ListenerRuleConditionHttpHeaderArgs:
    def __init__(__self__, *,
                 http_header_name: pulumi.Input[str],
                 values: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[str] http_header_name: Name of HTTP header to search. The maximum size is 40 characters. Comparison is case insensitive. Only RFC7240 characters are supported. Wildcards are not supported. You cannot use HTTP header condition to specify the host header, use a `host-header` condition instead.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: List of header value patterns to match. Maximum size of each pattern is 128 characters. Comparison is case insensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). If the same header appears multiple times in the request they will be searched in order until a match is found. Only one pattern needs to match for the condition to be satisfied. To require that all of the strings are a match, create one condition block per string.
        """
        pulumi.set(__self__, "http_header_name", http_header_name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="httpHeaderName")
    def http_header_name(self) -> pulumi.Input[str]:
        """
        Name of HTTP header to search. The maximum size is 40 characters. Comparison is case insensitive. Only RFC7240 characters are supported. Wildcards are not supported. You cannot use HTTP header condition to specify the host header, use a `host-header` condition instead.
        """
        return pulumi.get(self, "http_header_name")

    @http_header_name.setter
    def http_header_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "http_header_name", value)

    @property
    @pulumi.getter
    def values(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of header value patterns to match. Maximum size of each pattern is 128 characters. Comparison is case insensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). If the same header appears multiple times in the request they will be searched in order until a match is found. Only one pattern needs to match for the condition to be satisfied. To require that all of the strings are a match, create one condition block per string.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class ListenerRuleConditionHttpRequestMethodArgs:
    def __init__(__self__, *,
                 values: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: List of header value patterns to match. Maximum size of each pattern is 128 characters. Comparison is case insensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). If the same header appears multiple times in the request they will be searched in order until a match is found. Only one pattern needs to match for the condition to be satisfied. To require that all of the strings are a match, create one condition block per string.
               
               
               Query String Value Blocks (for `query_string.values`) support the following:
        """
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def values(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of header value patterns to match. Maximum size of each pattern is 128 characters. Comparison is case insensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). If the same header appears multiple times in the request they will be searched in order until a match is found. Only one pattern needs to match for the condition to be satisfied. To require that all of the strings are a match, create one condition block per string.


        Query String Value Blocks (for `query_string.values`) support the following:
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class ListenerRuleConditionPathPatternArgs:
    def __init__(__self__, *,
                 values: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: List of header value patterns to match. Maximum size of each pattern is 128 characters. Comparison is case insensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). If the same header appears multiple times in the request they will be searched in order until a match is found. Only one pattern needs to match for the condition to be satisfied. To require that all of the strings are a match, create one condition block per string.
               
               
               Query String Value Blocks (for `query_string.values`) support the following:
        """
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def values(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of header value patterns to match. Maximum size of each pattern is 128 characters. Comparison is case insensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). If the same header appears multiple times in the request they will be searched in order until a match is found. Only one pattern needs to match for the condition to be satisfied. To require that all of the strings are a match, create one condition block per string.


        Query String Value Blocks (for `query_string.values`) support the following:
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class ListenerRuleConditionQueryStringArgs:
    def __init__(__self__, *,
                 value: pulumi.Input[str],
                 key: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] value: Query string value pattern to match.
        :param pulumi.Input[str] key: Query string key pattern to match.
        """
        pulumi.set(__self__, "value", value)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Query string value pattern to match.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Query string key pattern to match.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)


@pulumi.input_type
class ListenerRuleConditionSourceIpArgs:
    def __init__(__self__, *,
                 values: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: List of header value patterns to match. Maximum size of each pattern is 128 characters. Comparison is case insensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). If the same header appears multiple times in the request they will be searched in order until a match is found. Only one pattern needs to match for the condition to be satisfied. To require that all of the strings are a match, create one condition block per string.
               
               
               Query String Value Blocks (for `query_string.values`) support the following:
        """
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def values(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of header value patterns to match. Maximum size of each pattern is 128 characters. Comparison is case insensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). If the same header appears multiple times in the request they will be searched in order until a match is found. Only one pattern needs to match for the condition to be satisfied. To require that all of the strings are a match, create one condition block per string.


        Query String Value Blocks (for `query_string.values`) support the following:
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class LoadBalancerAccessLogsArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 enabled: Optional[pulumi.Input[bool]] = None,
                 prefix: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket: The S3 bucket name to store the logs in.
        :param pulumi.Input[bool] enabled: Boolean to enable / disable `access_logs`. Defaults to `false`, even when `bucket` is specified.
        :param pulumi.Input[str] prefix: The S3 bucket prefix. Logs are stored in the root if not configured.
        """
        pulumi.set(__self__, "bucket", bucket)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        The S3 bucket name to store the logs in.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean to enable / disable `access_logs`. Defaults to `false`, even when `bucket` is specified.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The S3 bucket prefix. Logs are stored in the root if not configured.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix", value)


@pulumi.input_type
class LoadBalancerSubnetMappingArgs:
    def __init__(__self__, *,
                 subnet_id: pulumi.Input[str],
                 allocation_id: Optional[pulumi.Input[str]] = None,
                 ipv6_address: Optional[pulumi.Input[str]] = None,
                 outpost_id: Optional[pulumi.Input[str]] = None,
                 private_ipv4_address: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] subnet_id: ID of the subnet of which to attach to the load balancer. You can specify only one subnet per Availability Zone.
        :param pulumi.Input[str] allocation_id: The allocation ID of the Elastic IP address for an internet-facing load balancer.
        :param pulumi.Input[str] ipv6_address: The IPv6 address. You associate IPv6 CIDR blocks with your VPC and choose the subnets where you launch both internet-facing and internal Application Load Balancers or Network Load Balancers.
        :param pulumi.Input[str] private_ipv4_address: The private IPv4 address for an internal load balancer.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        if allocation_id is not None:
            pulumi.set(__self__, "allocation_id", allocation_id)
        if ipv6_address is not None:
            pulumi.set(__self__, "ipv6_address", ipv6_address)
        if outpost_id is not None:
            pulumi.set(__self__, "outpost_id", outpost_id)
        if private_ipv4_address is not None:
            pulumi.set(__self__, "private_ipv4_address", private_ipv4_address)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        ID of the subnet of which to attach to the load balancer. You can specify only one subnet per Availability Zone.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="allocationId")
    def allocation_id(self) -> Optional[pulumi.Input[str]]:
        """
        The allocation ID of the Elastic IP address for an internet-facing load balancer.
        """
        return pulumi.get(self, "allocation_id")

    @allocation_id.setter
    def allocation_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allocation_id", value)

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv6 address. You associate IPv6 CIDR blocks with your VPC and choose the subnets where you launch both internet-facing and internal Application Load Balancers or Network Load Balancers.
        """
        return pulumi.get(self, "ipv6_address")

    @ipv6_address.setter
    def ipv6_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_address", value)

    @property
    @pulumi.getter(name="outpostId")
    def outpost_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "outpost_id")

    @outpost_id.setter
    def outpost_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "outpost_id", value)

    @property
    @pulumi.getter(name="privateIpv4Address")
    def private_ipv4_address(self) -> Optional[pulumi.Input[str]]:
        """
        The private IPv4 address for an internal load balancer.
        """
        return pulumi.get(self, "private_ipv4_address")

    @private_ipv4_address.setter
    def private_ipv4_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ipv4_address", value)


@pulumi.input_type
class TargetGroupHealthCheckArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 healthy_threshold: Optional[pulumi.Input[int]] = None,
                 interval: Optional[pulumi.Input[int]] = None,
                 matcher: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 unhealthy_threshold: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[bool] enabled: Whether health checks are enabled. Defaults to `true`.
        :param pulumi.Input[int] healthy_threshold: Number of consecutive health check successes required before considering a target healthy. The range is 2-10. Defaults to 3.
        :param pulumi.Input[int] interval: Approximate amount of time, in seconds, between health checks of an individual target. The range is 5-300. For `lambda` target groups, it needs to be greater than the timeout of the underlying `lambda`. Defaults to 30.
        :param pulumi.Input[str] matcher: Response codes to use when checking for a healthy responses from a target. You can specify multiple values (for example, "200,202" for HTTP(s) or "0,12" for GRPC) or a range of values (for example, "200-299" or "0-99"). Required for HTTP/HTTPS/GRPC ALB. Only applies to Application Load Balancers (i.e., HTTP/HTTPS/GRPC) not Network Load Balancers (i.e., TCP).
        :param pulumi.Input[str] path: Destination for the health check request. Required for HTTP/HTTPS ALB and HTTP NLB. Only applies to HTTP/HTTPS.
        :param pulumi.Input[str] port: The port the load balancer uses when performing health checks on targets. Default is traffic-port.
        :param pulumi.Input[str] protocol: Protocol the load balancer uses when performing health checks on targets. Must be either `TCP`, `HTTP`, or `HTTPS`. The TCP protocol is not supported for health checks if the protocol of the target group is HTTP or HTTPS. Defaults to HTTP.
        :param pulumi.Input[int] timeout: Amount of time, in seconds, during which no response from a target means a failed health check. The range is 2–120 seconds. For target groups with a protocol of HTTP, the default is 6 seconds. For target groups with a protocol of TCP, TLS or HTTPS, the default is 10 seconds. For target groups with a protocol of GENEVE, the default is 5 seconds. If the target type is lambda, the default is 30 seconds.
        :param pulumi.Input[int] unhealthy_threshold: Number of consecutive health check failures required before considering a target unhealthy. The range is 2-10. Defaults to 3.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if healthy_threshold is not None:
            pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if matcher is not None:
            pulumi.set(__self__, "matcher", matcher)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if unhealthy_threshold is not None:
            pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether health checks are enabled. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Number of consecutive health check successes required before considering a target healthy. The range is 2-10. Defaults to 3.
        """
        return pulumi.get(self, "healthy_threshold")

    @healthy_threshold.setter
    def healthy_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "healthy_threshold", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[int]]:
        """
        Approximate amount of time, in seconds, between health checks of an individual target. The range is 5-300. For `lambda` target groups, it needs to be greater than the timeout of the underlying `lambda`. Defaults to 30.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter
    def matcher(self) -> Optional[pulumi.Input[str]]:
        """
        Response codes to use when checking for a healthy responses from a target. You can specify multiple values (for example, "200,202" for HTTP(s) or "0,12" for GRPC) or a range of values (for example, "200-299" or "0-99"). Required for HTTP/HTTPS/GRPC ALB. Only applies to Application Load Balancers (i.e., HTTP/HTTPS/GRPC) not Network Load Balancers (i.e., TCP).
        """
        return pulumi.get(self, "matcher")

    @matcher.setter
    def matcher(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "matcher", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Destination for the health check request. Required for HTTP/HTTPS ALB and HTTP NLB. Only applies to HTTP/HTTPS.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[str]]:
        """
        The port the load balancer uses when performing health checks on targets. Default is traffic-port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Protocol the load balancer uses when performing health checks on targets. Must be either `TCP`, `HTTP`, or `HTTPS`. The TCP protocol is not supported for health checks if the protocol of the target group is HTTP or HTTPS. Defaults to HTTP.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Amount of time, in seconds, during which no response from a target means a failed health check. The range is 2–120 seconds. For target groups with a protocol of HTTP, the default is 6 seconds. For target groups with a protocol of TCP, TLS or HTTPS, the default is 10 seconds. For target groups with a protocol of GENEVE, the default is 5 seconds. If the target type is lambda, the default is 30 seconds.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Number of consecutive health check failures required before considering a target unhealthy. The range is 2-10. Defaults to 3.
        """
        return pulumi.get(self, "unhealthy_threshold")

    @unhealthy_threshold.setter
    def unhealthy_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "unhealthy_threshold", value)


@pulumi.input_type
class TargetGroupStickinessArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 cookie_duration: Optional[pulumi.Input[int]] = None,
                 cookie_name: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] type: The type of sticky sessions. The only current possible values are `lb_cookie`, `app_cookie` for ALBs, `source_ip` for NLBs, and `source_ip_dest_ip`, `source_ip_dest_ip_proto` for GWLBs.
        :param pulumi.Input[int] cookie_duration: Only used when the type is `lb_cookie`. The time period, in seconds, during which requests from a client should be routed to the same target. After this time period expires, the load balancer-generated cookie is considered stale. The range is 1 second to 1 week (604800 seconds). The default value is 1 day (86400 seconds).
        :param pulumi.Input[str] cookie_name: Name of the application based cookie. AWSALB, AWSALBAPP, and AWSALBTG prefixes are reserved and cannot be used. Only needed when type is `app_cookie`.
        :param pulumi.Input[bool] enabled: Boolean to enable / disable `stickiness`. Default is `true`.
        """
        pulumi.set(__self__, "type", type)
        if cookie_duration is not None:
            pulumi.set(__self__, "cookie_duration", cookie_duration)
        if cookie_name is not None:
            pulumi.set(__self__, "cookie_name", cookie_name)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of sticky sessions. The only current possible values are `lb_cookie`, `app_cookie` for ALBs, `source_ip` for NLBs, and `source_ip_dest_ip`, `source_ip_dest_ip_proto` for GWLBs.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="cookieDuration")
    def cookie_duration(self) -> Optional[pulumi.Input[int]]:
        """
        Only used when the type is `lb_cookie`. The time period, in seconds, during which requests from a client should be routed to the same target. After this time period expires, the load balancer-generated cookie is considered stale. The range is 1 second to 1 week (604800 seconds). The default value is 1 day (86400 seconds).
        """
        return pulumi.get(self, "cookie_duration")

    @cookie_duration.setter
    def cookie_duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cookie_duration", value)

    @property
    @pulumi.getter(name="cookieName")
    def cookie_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the application based cookie. AWSALB, AWSALBAPP, and AWSALBTG prefixes are reserved and cannot be used. Only needed when type is `app_cookie`.
        """
        return pulumi.get(self, "cookie_name")

    @cookie_name.setter
    def cookie_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cookie_name", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean to enable / disable `stickiness`. Default is `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class TargetGroupTargetFailoverArgs:
    def __init__(__self__, *,
                 on_deregistration: pulumi.Input[str],
                 on_unhealthy: pulumi.Input[str]):
        """
        :param pulumi.Input[str] on_deregistration: Indicates how the GWLB handles existing flows when a target is deregistered. Possible values are `rebalance` and `no_rebalance`. Must match the attribute value set for `on_unhealthy`. Default: `no_rebalance`.
        :param pulumi.Input[str] on_unhealthy: Indicates how the GWLB handles existing flows when a target is unhealthy. Possible values are `rebalance` and `no_rebalance`. Must match the attribute value set for `on_deregistration`. Default: `no_rebalance`.
        """
        pulumi.set(__self__, "on_deregistration", on_deregistration)
        pulumi.set(__self__, "on_unhealthy", on_unhealthy)

    @property
    @pulumi.getter(name="onDeregistration")
    def on_deregistration(self) -> pulumi.Input[str]:
        """
        Indicates how the GWLB handles existing flows when a target is deregistered. Possible values are `rebalance` and `no_rebalance`. Must match the attribute value set for `on_unhealthy`. Default: `no_rebalance`.
        """
        return pulumi.get(self, "on_deregistration")

    @on_deregistration.setter
    def on_deregistration(self, value: pulumi.Input[str]):
        pulumi.set(self, "on_deregistration", value)

    @property
    @pulumi.getter(name="onUnhealthy")
    def on_unhealthy(self) -> pulumi.Input[str]:
        """
        Indicates how the GWLB handles existing flows when a target is unhealthy. Possible values are `rebalance` and `no_rebalance`. Must match the attribute value set for `on_deregistration`. Default: `no_rebalance`.
        """
        return pulumi.get(self, "on_unhealthy")

    @on_unhealthy.setter
    def on_unhealthy(self, value: pulumi.Input[str]):
        pulumi.set(self, "on_unhealthy", value)


