# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetLbsResult',
    'AwaitableGetLbsResult',
    'get_lbs',
    'get_lbs_output',
]

@pulumi.output_type
class GetLbsResult:
    """
    A collection of values returned by getLbs.
    """
    def __init__(__self__, arns=None, id=None, tags=None):
        if arns and not isinstance(arns, list):
            raise TypeError("Expected argument 'arns' to be a list")
        pulumi.set(__self__, "arns", arns)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arns(self) -> Sequence[str]:
        """
        Set of Load Balancer ARNs.
        """
        return pulumi.get(self, "arns")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "tags")


class AwaitableGetLbsResult(GetLbsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLbsResult(
            arns=self.arns,
            id=self.id,
            tags=self.tags)


def get_lbs(tags: Optional[Mapping[str, str]] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLbsResult:
    """
    Use this data source to get a list of Load Balancer ARNs matching the specified criteria. Useful for passing to other
    resources.

    ## Example Usage
    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.lb.get_lbs(tags={
        "elbv2.k8s.aws/cluster": "my-cluster",
    })
    ```


    :param Mapping[str, str] tags: Map of tags, each pair of which must exactly match
           a pair on the desired Load Balancers.
    """
    __args__ = dict()
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:lb/getLbs:getLbs', __args__, opts=opts, typ=GetLbsResult).value

    return AwaitableGetLbsResult(
        arns=pulumi.get(__ret__, 'arns'),
        id=pulumi.get(__ret__, 'id'),
        tags=pulumi.get(__ret__, 'tags'))


@_utilities.lift_output_func(get_lbs)
def get_lbs_output(tags: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetLbsResult]:
    """
    Use this data source to get a list of Load Balancer ARNs matching the specified criteria. Useful for passing to other
    resources.

    ## Example Usage
    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.lb.get_lbs(tags={
        "elbv2.k8s.aws/cluster": "my-cluster",
    })
    ```


    :param Mapping[str, str] tags: Map of tags, each pair of which must exactly match
           a pair on the desired Load Balancers.
    """
    ...
