# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetSlotTypeResult',
    'AwaitableGetSlotTypeResult',
    'get_slot_type',
    'get_slot_type_output',
]

@pulumi.output_type
class GetSlotTypeResult:
    """
    A collection of values returned by getSlotType.
    """
    def __init__(__self__, checksum=None, created_date=None, description=None, enumeration_values=None, id=None, last_updated_date=None, name=None, value_selection_strategy=None, version=None):
        if checksum and not isinstance(checksum, str):
            raise TypeError("Expected argument 'checksum' to be a str")
        pulumi.set(__self__, "checksum", checksum)
        if created_date and not isinstance(created_date, str):
            raise TypeError("Expected argument 'created_date' to be a str")
        pulumi.set(__self__, "created_date", created_date)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if enumeration_values and not isinstance(enumeration_values, list):
            raise TypeError("Expected argument 'enumeration_values' to be a list")
        pulumi.set(__self__, "enumeration_values", enumeration_values)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_updated_date and not isinstance(last_updated_date, str):
            raise TypeError("Expected argument 'last_updated_date' to be a str")
        pulumi.set(__self__, "last_updated_date", last_updated_date)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if value_selection_strategy and not isinstance(value_selection_strategy, str):
            raise TypeError("Expected argument 'value_selection_strategy' to be a str")
        pulumi.set(__self__, "value_selection_strategy", value_selection_strategy)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def checksum(self) -> str:
        """
        Checksum identifying the version of the slot type that was created. The checksum is
        not included as an argument because the resource will add it automatically when updating the slot type.
        """
        return pulumi.get(self, "checksum")

    @property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> str:
        """
        Date when the slot type version was created.
        """
        return pulumi.get(self, "created_date")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the slot type.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enumerationValues")
    def enumeration_values(self) -> Sequence['outputs.GetSlotTypeEnumerationValueResult']:
        """
        Set of EnumerationValue objects that defines the values that
        the slot type can take. Each value can have a set of synonyms, which are additional values that help
        train the machine learning model about the values that it resolves for a slot.
        """
        return pulumi.get(self, "enumeration_values")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastUpdatedDate")
    def last_updated_date(self) -> str:
        """
        Date when the $LATEST version of this slot type was updated.
        """
        return pulumi.get(self, "last_updated_date")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the slot type. The name is not case sensitive.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="valueSelectionStrategy")
    def value_selection_strategy(self) -> str:
        """
        Determines the slot resolution strategy that Amazon Lex
        uses to return slot type values. `ORIGINAL_VALUE` returns the value entered by the user if the user
        value is similar to the slot value. `TOP_RESOLUTION` returns the first value in the resolution list
        if there is a resolution list for the slot, otherwise null is returned.
        """
        return pulumi.get(self, "value_selection_strategy")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Version of the slot type.
        """
        return pulumi.get(self, "version")


class AwaitableGetSlotTypeResult(GetSlotTypeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSlotTypeResult(
            checksum=self.checksum,
            created_date=self.created_date,
            description=self.description,
            enumeration_values=self.enumeration_values,
            id=self.id,
            last_updated_date=self.last_updated_date,
            name=self.name,
            value_selection_strategy=self.value_selection_strategy,
            version=self.version)


def get_slot_type(name: Optional[str] = None,
                  version: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSlotTypeResult:
    """
    Provides details about a specific Amazon Lex Slot Type.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    flower_types = aws.lex.get_slot_type(name="FlowerTypes",
        version="1")
    ```


    :param str name: Name of the slot type. The name is case sensitive.
    :param str version: Version of the slot type.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['version'] = version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:lex/getSlotType:getSlotType', __args__, opts=opts, typ=GetSlotTypeResult).value

    return AwaitableGetSlotTypeResult(
        checksum=pulumi.get(__ret__, 'checksum'),
        created_date=pulumi.get(__ret__, 'created_date'),
        description=pulumi.get(__ret__, 'description'),
        enumeration_values=pulumi.get(__ret__, 'enumeration_values'),
        id=pulumi.get(__ret__, 'id'),
        last_updated_date=pulumi.get(__ret__, 'last_updated_date'),
        name=pulumi.get(__ret__, 'name'),
        value_selection_strategy=pulumi.get(__ret__, 'value_selection_strategy'),
        version=pulumi.get(__ret__, 'version'))


@_utilities.lift_output_func(get_slot_type)
def get_slot_type_output(name: Optional[pulumi.Input[str]] = None,
                         version: Optional[pulumi.Input[Optional[str]]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSlotTypeResult]:
    """
    Provides details about a specific Amazon Lex Slot Type.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    flower_types = aws.lex.get_slot_type(name="FlowerTypes",
        version="1")
    ```


    :param str name: Name of the slot type. The name is case sensitive.
    :param str version: Version of the slot type.
    """
    ...
