# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'BotAbortStatement',
    'BotAbortStatementMessage',
    'BotAliasConversationLogs',
    'BotAliasConversationLogsLogSetting',
    'BotClarificationPrompt',
    'BotClarificationPromptMessage',
    'BotIntent',
    'IntentConclusionStatement',
    'IntentConclusionStatementMessage',
    'IntentConfirmationPrompt',
    'IntentConfirmationPromptMessage',
    'IntentDialogCodeHook',
    'IntentFollowUpPrompt',
    'IntentFollowUpPromptPrompt',
    'IntentFollowUpPromptPromptMessage',
    'IntentFollowUpPromptRejectionStatement',
    'IntentFollowUpPromptRejectionStatementMessage',
    'IntentFulfillmentActivity',
    'IntentFulfillmentActivityCodeHook',
    'IntentRejectionStatement',
    'IntentRejectionStatementMessage',
    'IntentSlot',
    'IntentSlotValueElicitationPrompt',
    'IntentSlotValueElicitationPromptMessage',
    'SlotTypeEnumerationValue',
    'GetSlotTypeEnumerationValueResult',
]

@pulumi.output_type
class BotAbortStatement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "responseCard":
            suggest = "response_card"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotAbortStatement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotAbortStatement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotAbortStatement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 messages: Sequence['outputs.BotAbortStatementMessage'],
                 response_card: Optional[str] = None):
        """
        :param str response_card: The response card. Amazon Lex will substitute session attributes and
               slot values into the response card. For more information, see
               [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html).
               slot values into the response card. For more information, see
               [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html).
        """
        pulumi.set(__self__, "messages", messages)
        if response_card is not None:
            pulumi.set(__self__, "response_card", response_card)

    @property
    @pulumi.getter
    def messages(self) -> Sequence['outputs.BotAbortStatementMessage']:
        return pulumi.get(self, "messages")

    @property
    @pulumi.getter(name="responseCard")
    def response_card(self) -> Optional[str]:
        """
        The response card. Amazon Lex will substitute session attributes and
        slot values into the response card. For more information, see
        [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html).
        slot values into the response card. For more information, see
        [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html).
        """
        return pulumi.get(self, "response_card")


@pulumi.output_type
class BotAbortStatementMessage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"
        elif key == "groupNumber":
            suggest = "group_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotAbortStatementMessage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotAbortStatementMessage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotAbortStatementMessage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content: str,
                 content_type: str,
                 group_number: Optional[int] = None):
        """
        :param str content: The text of the message.
        :param str content_type: The content type of the message string.
        :param int group_number: Identifies the message group that the message belongs to. When a group
               is assigned to a message, Amazon Lex returns one message from each group in the response.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "content_type", content_type)
        if group_number is not None:
            pulumi.set(__self__, "group_number", group_number)

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        The text of the message.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> str:
        """
        The content type of the message string.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="groupNumber")
    def group_number(self) -> Optional[int]:
        """
        Identifies the message group that the message belongs to. When a group
        is assigned to a message, Amazon Lex returns one message from each group in the response.
        """
        return pulumi.get(self, "group_number")


@pulumi.output_type
class BotAliasConversationLogs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "iamRoleArn":
            suggest = "iam_role_arn"
        elif key == "logSettings":
            suggest = "log_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotAliasConversationLogs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotAliasConversationLogs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotAliasConversationLogs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 iam_role_arn: str,
                 log_settings: Optional[Sequence['outputs.BotAliasConversationLogsLogSetting']] = None):
        """
        :param str iam_role_arn: The Amazon Resource Name (ARN) of the IAM role used to write your logs to CloudWatch Logs or an S3 bucket. Must be between 20 and 2048 characters in length.
        :param Sequence['BotAliasConversationLogsLogSettingArgs'] log_settings: The settings for your conversation logs. You can log text, audio, or both. Attributes are documented under log_settings.
        """
        pulumi.set(__self__, "iam_role_arn", iam_role_arn)
        if log_settings is not None:
            pulumi.set(__self__, "log_settings", log_settings)

    @property
    @pulumi.getter(name="iamRoleArn")
    def iam_role_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of the IAM role used to write your logs to CloudWatch Logs or an S3 bucket. Must be between 20 and 2048 characters in length.
        """
        return pulumi.get(self, "iam_role_arn")

    @property
    @pulumi.getter(name="logSettings")
    def log_settings(self) -> Optional[Sequence['outputs.BotAliasConversationLogsLogSetting']]:
        """
        The settings for your conversation logs. You can log text, audio, or both. Attributes are documented under log_settings.
        """
        return pulumi.get(self, "log_settings")


@pulumi.output_type
class BotAliasConversationLogsLogSetting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logType":
            suggest = "log_type"
        elif key == "resourceArn":
            suggest = "resource_arn"
        elif key == "kmsKeyArn":
            suggest = "kms_key_arn"
        elif key == "resourcePrefix":
            suggest = "resource_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotAliasConversationLogsLogSetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotAliasConversationLogsLogSetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotAliasConversationLogsLogSetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination: str,
                 log_type: str,
                 resource_arn: str,
                 kms_key_arn: Optional[str] = None,
                 resource_prefix: Optional[str] = None):
        """
        :param str destination: The destination where logs are delivered. Options are `CLOUDWATCH_LOGS` or `S3`.
        :param str log_type: The type of logging that is enabled. Options are `AUDIO` or `TEXT`.
        :param str resource_arn: The Amazon Resource Name (ARN) of the CloudWatch Logs log group or S3 bucket where the logs are delivered. Must be less than or equal to 2048 characters in length.
        :param str kms_key_arn: The Amazon Resource Name (ARN) of the key used to encrypt audio logs in an S3 bucket. This can only be specified when `destination` is set to `S3`. Must be between 20 and 2048 characters in length.
        :param str resource_prefix: The prefix of the S3 object key for `AUDIO` logs or the log stream name for `TEXT` logs.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "log_type", log_type)
        pulumi.set(__self__, "resource_arn", resource_arn)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if resource_prefix is not None:
            pulumi.set(__self__, "resource_prefix", resource_prefix)

    @property
    @pulumi.getter
    def destination(self) -> str:
        """
        The destination where logs are delivered. Options are `CLOUDWATCH_LOGS` or `S3`.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> str:
        """
        The type of logging that is enabled. Options are `AUDIO` or `TEXT`.
        """
        return pulumi.get(self, "log_type")

    @property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of the CloudWatch Logs log group or S3 bucket where the logs are delivered. Must be less than or equal to 2048 characters in length.
        """
        return pulumi.get(self, "resource_arn")

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the key used to encrypt audio logs in an S3 bucket. This can only be specified when `destination` is set to `S3`. Must be between 20 and 2048 characters in length.
        """
        return pulumi.get(self, "kms_key_arn")

    @property
    @pulumi.getter(name="resourcePrefix")
    def resource_prefix(self) -> Optional[str]:
        """
        The prefix of the S3 object key for `AUDIO` logs or the log stream name for `TEXT` logs.
        """
        return pulumi.get(self, "resource_prefix")


@pulumi.output_type
class BotClarificationPrompt(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxAttempts":
            suggest = "max_attempts"
        elif key == "responseCard":
            suggest = "response_card"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotClarificationPrompt. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotClarificationPrompt.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotClarificationPrompt.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_attempts: int,
                 messages: Sequence['outputs.BotClarificationPromptMessage'],
                 response_card: Optional[str] = None):
        """
        :param int max_attempts: The number of times to prompt the user for information.
        :param str response_card: The response card. Amazon Lex will substitute session attributes and
               slot values into the response card. For more information, see
               [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html).
               slot values into the response card. For more information, see
               [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html).
        """
        pulumi.set(__self__, "max_attempts", max_attempts)
        pulumi.set(__self__, "messages", messages)
        if response_card is not None:
            pulumi.set(__self__, "response_card", response_card)

    @property
    @pulumi.getter(name="maxAttempts")
    def max_attempts(self) -> int:
        """
        The number of times to prompt the user for information.
        """
        return pulumi.get(self, "max_attempts")

    @property
    @pulumi.getter
    def messages(self) -> Sequence['outputs.BotClarificationPromptMessage']:
        return pulumi.get(self, "messages")

    @property
    @pulumi.getter(name="responseCard")
    def response_card(self) -> Optional[str]:
        """
        The response card. Amazon Lex will substitute session attributes and
        slot values into the response card. For more information, see
        [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html).
        slot values into the response card. For more information, see
        [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html).
        """
        return pulumi.get(self, "response_card")


@pulumi.output_type
class BotClarificationPromptMessage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"
        elif key == "groupNumber":
            suggest = "group_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotClarificationPromptMessage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotClarificationPromptMessage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotClarificationPromptMessage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content: str,
                 content_type: str,
                 group_number: Optional[int] = None):
        """
        :param str content: The text of the message.
        :param str content_type: The content type of the message string.
        :param int group_number: Identifies the message group that the message belongs to. When a group
               is assigned to a message, Amazon Lex returns one message from each group in the response.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "content_type", content_type)
        if group_number is not None:
            pulumi.set(__self__, "group_number", group_number)

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        The text of the message.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> str:
        """
        The content type of the message string.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="groupNumber")
    def group_number(self) -> Optional[int]:
        """
        Identifies the message group that the message belongs to. When a group
        is assigned to a message, Amazon Lex returns one message from each group in the response.
        """
        return pulumi.get(self, "group_number")


@pulumi.output_type
class BotIntent(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intentName":
            suggest = "intent_name"
        elif key == "intentVersion":
            suggest = "intent_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotIntent. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotIntent.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotIntent.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 intent_name: str,
                 intent_version: str):
        """
        :param str intent_name: The name of the intent. Must be less than or equal to 100 characters in length.
        :param str intent_version: The version of the intent. Must be less than or equal to 64 characters in length.
        """
        pulumi.set(__self__, "intent_name", intent_name)
        pulumi.set(__self__, "intent_version", intent_version)

    @property
    @pulumi.getter(name="intentName")
    def intent_name(self) -> str:
        """
        The name of the intent. Must be less than or equal to 100 characters in length.
        """
        return pulumi.get(self, "intent_name")

    @property
    @pulumi.getter(name="intentVersion")
    def intent_version(self) -> str:
        """
        The version of the intent. Must be less than or equal to 64 characters in length.
        """
        return pulumi.get(self, "intent_version")


@pulumi.output_type
class IntentConclusionStatement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "responseCard":
            suggest = "response_card"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntentConclusionStatement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntentConclusionStatement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntentConclusionStatement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 messages: Sequence['outputs.IntentConclusionStatementMessage'],
                 response_card: Optional[str] = None):
        """
        :param str response_card: The response card. Amazon Lex will substitute session attributes and
               slot values into the response card. For more information, see
               [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
               slot values into the response card. For more information, see
               [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
               slot values into the response card. For more information, see
               [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
        """
        pulumi.set(__self__, "messages", messages)
        if response_card is not None:
            pulumi.set(__self__, "response_card", response_card)

    @property
    @pulumi.getter
    def messages(self) -> Sequence['outputs.IntentConclusionStatementMessage']:
        return pulumi.get(self, "messages")

    @property
    @pulumi.getter(name="responseCard")
    def response_card(self) -> Optional[str]:
        """
        The response card. Amazon Lex will substitute session attributes and
        slot values into the response card. For more information, see
        [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
        slot values into the response card. For more information, see
        [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
        slot values into the response card. For more information, see
        [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
        """
        return pulumi.get(self, "response_card")


@pulumi.output_type
class IntentConclusionStatementMessage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"
        elif key == "groupNumber":
            suggest = "group_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntentConclusionStatementMessage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntentConclusionStatementMessage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntentConclusionStatementMessage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content: str,
                 content_type: str,
                 group_number: Optional[int] = None):
        """
        :param str content: The text of the message. Must be less than or equal to 1000 characters in length.
        :param str content_type: The content type of the message string.
        :param int group_number: Identifies the message group that the message belongs to. When a group
               is assigned to a message, Amazon Lex returns one message from each group in the response. Must be a number between 1 and 5 (inclusive).
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "content_type", content_type)
        if group_number is not None:
            pulumi.set(__self__, "group_number", group_number)

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        The text of the message. Must be less than or equal to 1000 characters in length.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> str:
        """
        The content type of the message string.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="groupNumber")
    def group_number(self) -> Optional[int]:
        """
        Identifies the message group that the message belongs to. When a group
        is assigned to a message, Amazon Lex returns one message from each group in the response. Must be a number between 1 and 5 (inclusive).
        """
        return pulumi.get(self, "group_number")


@pulumi.output_type
class IntentConfirmationPrompt(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxAttempts":
            suggest = "max_attempts"
        elif key == "responseCard":
            suggest = "response_card"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntentConfirmationPrompt. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntentConfirmationPrompt.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntentConfirmationPrompt.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_attempts: int,
                 messages: Sequence['outputs.IntentConfirmationPromptMessage'],
                 response_card: Optional[str] = None):
        """
        :param int max_attempts: The number of times to prompt the user for information. Must be a number between 1 and 5 (inclusive).
        :param str response_card: The response card. Amazon Lex will substitute session attributes and
               slot values into the response card. For more information, see
               [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
               slot values into the response card. For more information, see
               [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
               slot values into the response card. For more information, see
               [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
        """
        pulumi.set(__self__, "max_attempts", max_attempts)
        pulumi.set(__self__, "messages", messages)
        if response_card is not None:
            pulumi.set(__self__, "response_card", response_card)

    @property
    @pulumi.getter(name="maxAttempts")
    def max_attempts(self) -> int:
        """
        The number of times to prompt the user for information. Must be a number between 1 and 5 (inclusive).
        """
        return pulumi.get(self, "max_attempts")

    @property
    @pulumi.getter
    def messages(self) -> Sequence['outputs.IntentConfirmationPromptMessage']:
        return pulumi.get(self, "messages")

    @property
    @pulumi.getter(name="responseCard")
    def response_card(self) -> Optional[str]:
        """
        The response card. Amazon Lex will substitute session attributes and
        slot values into the response card. For more information, see
        [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
        slot values into the response card. For more information, see
        [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
        slot values into the response card. For more information, see
        [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
        """
        return pulumi.get(self, "response_card")


@pulumi.output_type
class IntentConfirmationPromptMessage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"
        elif key == "groupNumber":
            suggest = "group_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntentConfirmationPromptMessage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntentConfirmationPromptMessage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntentConfirmationPromptMessage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content: str,
                 content_type: str,
                 group_number: Optional[int] = None):
        """
        :param str content: The text of the message. Must be less than or equal to 1000 characters in length.
        :param str content_type: The content type of the message string.
        :param int group_number: Identifies the message group that the message belongs to. When a group
               is assigned to a message, Amazon Lex returns one message from each group in the response. Must be a number between 1 and 5 (inclusive).
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "content_type", content_type)
        if group_number is not None:
            pulumi.set(__self__, "group_number", group_number)

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        The text of the message. Must be less than or equal to 1000 characters in length.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> str:
        """
        The content type of the message string.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="groupNumber")
    def group_number(self) -> Optional[int]:
        """
        Identifies the message group that the message belongs to. When a group
        is assigned to a message, Amazon Lex returns one message from each group in the response. Must be a number between 1 and 5 (inclusive).
        """
        return pulumi.get(self, "group_number")


@pulumi.output_type
class IntentDialogCodeHook(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "messageVersion":
            suggest = "message_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntentDialogCodeHook. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntentDialogCodeHook.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntentDialogCodeHook.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 message_version: str,
                 uri: str):
        """
        :param str message_version: The version of the request-response that you want Amazon Lex to use
               to invoke your Lambda function. For more information, see
               [Using Lambda Functions](https://docs.aws.amazon.com/lex/latest/dg/using-lambda.html). Must be less than or equal to 5 characters in length.
        :param str uri: The Amazon Resource Name (ARN) of the Lambda function.
        """
        pulumi.set(__self__, "message_version", message_version)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="messageVersion")
    def message_version(self) -> str:
        """
        The version of the request-response that you want Amazon Lex to use
        to invoke your Lambda function. For more information, see
        [Using Lambda Functions](https://docs.aws.amazon.com/lex/latest/dg/using-lambda.html). Must be less than or equal to 5 characters in length.
        """
        return pulumi.get(self, "message_version")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        The Amazon Resource Name (ARN) of the Lambda function.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class IntentFollowUpPrompt(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rejectionStatement":
            suggest = "rejection_statement"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntentFollowUpPrompt. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntentFollowUpPrompt.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntentFollowUpPrompt.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 prompt: 'outputs.IntentFollowUpPromptPrompt',
                 rejection_statement: 'outputs.IntentFollowUpPromptRejectionStatement'):
        """
        :param 'IntentFollowUpPromptPromptArgs' prompt: Prompts for information from the user. Attributes are documented under prompt.
        :param 'IntentFollowUpPromptRejectionStatementArgs' rejection_statement: If the user answers "no" to the question defined in the prompt field,
               Amazon Lex responds with this statement to acknowledge that the intent was canceled. Attributes are
               documented below under statement.
        """
        pulumi.set(__self__, "prompt", prompt)
        pulumi.set(__self__, "rejection_statement", rejection_statement)

    @property
    @pulumi.getter
    def prompt(self) -> 'outputs.IntentFollowUpPromptPrompt':
        """
        Prompts for information from the user. Attributes are documented under prompt.
        """
        return pulumi.get(self, "prompt")

    @property
    @pulumi.getter(name="rejectionStatement")
    def rejection_statement(self) -> 'outputs.IntentFollowUpPromptRejectionStatement':
        """
        If the user answers "no" to the question defined in the prompt field,
        Amazon Lex responds with this statement to acknowledge that the intent was canceled. Attributes are
        documented below under statement.
        """
        return pulumi.get(self, "rejection_statement")


@pulumi.output_type
class IntentFollowUpPromptPrompt(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxAttempts":
            suggest = "max_attempts"
        elif key == "responseCard":
            suggest = "response_card"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntentFollowUpPromptPrompt. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntentFollowUpPromptPrompt.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntentFollowUpPromptPrompt.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_attempts: int,
                 messages: Sequence['outputs.IntentFollowUpPromptPromptMessage'],
                 response_card: Optional[str] = None):
        """
        :param int max_attempts: The number of times to prompt the user for information. Must be a number between 1 and 5 (inclusive).
        :param Sequence['IntentFollowUpPromptPromptMessageArgs'] messages: A set of messages, each of which provides a message string and its type.
               You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
               Attributes are documented under message. Must contain between 1 and 15 messages.
        :param str response_card: The response card. Amazon Lex will substitute session attributes and
               slot values into the response card. For more information, see
               [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
        """
        pulumi.set(__self__, "max_attempts", max_attempts)
        pulumi.set(__self__, "messages", messages)
        if response_card is not None:
            pulumi.set(__self__, "response_card", response_card)

    @property
    @pulumi.getter(name="maxAttempts")
    def max_attempts(self) -> int:
        """
        The number of times to prompt the user for information. Must be a number between 1 and 5 (inclusive).
        """
        return pulumi.get(self, "max_attempts")

    @property
    @pulumi.getter
    def messages(self) -> Sequence['outputs.IntentFollowUpPromptPromptMessage']:
        """
        A set of messages, each of which provides a message string and its type.
        You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
        Attributes are documented under message. Must contain between 1 and 15 messages.
        """
        return pulumi.get(self, "messages")

    @property
    @pulumi.getter(name="responseCard")
    def response_card(self) -> Optional[str]:
        """
        The response card. Amazon Lex will substitute session attributes and
        slot values into the response card. For more information, see
        [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
        """
        return pulumi.get(self, "response_card")


@pulumi.output_type
class IntentFollowUpPromptPromptMessage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"
        elif key == "groupNumber":
            suggest = "group_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntentFollowUpPromptPromptMessage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntentFollowUpPromptPromptMessage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntentFollowUpPromptPromptMessage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content: str,
                 content_type: str,
                 group_number: Optional[int] = None):
        """
        :param str content: The text of the message. Must be less than or equal to 1000 characters in length.
        :param str content_type: The content type of the message string.
        :param int group_number: Identifies the message group that the message belongs to. When a group
               is assigned to a message, Amazon Lex returns one message from each group in the response. Must be a number between 1 and 5 (inclusive).
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "content_type", content_type)
        if group_number is not None:
            pulumi.set(__self__, "group_number", group_number)

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        The text of the message. Must be less than or equal to 1000 characters in length.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> str:
        """
        The content type of the message string.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="groupNumber")
    def group_number(self) -> Optional[int]:
        """
        Identifies the message group that the message belongs to. When a group
        is assigned to a message, Amazon Lex returns one message from each group in the response. Must be a number between 1 and 5 (inclusive).
        """
        return pulumi.get(self, "group_number")


@pulumi.output_type
class IntentFollowUpPromptRejectionStatement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "responseCard":
            suggest = "response_card"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntentFollowUpPromptRejectionStatement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntentFollowUpPromptRejectionStatement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntentFollowUpPromptRejectionStatement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 messages: Sequence['outputs.IntentFollowUpPromptRejectionStatementMessage'],
                 response_card: Optional[str] = None):
        """
        :param str response_card: The response card. Amazon Lex will substitute session attributes and
               slot values into the response card. For more information, see
               [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
               slot values into the response card. For more information, see
               [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
               slot values into the response card. For more information, see
               [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
        """
        pulumi.set(__self__, "messages", messages)
        if response_card is not None:
            pulumi.set(__self__, "response_card", response_card)

    @property
    @pulumi.getter
    def messages(self) -> Sequence['outputs.IntentFollowUpPromptRejectionStatementMessage']:
        return pulumi.get(self, "messages")

    @property
    @pulumi.getter(name="responseCard")
    def response_card(self) -> Optional[str]:
        """
        The response card. Amazon Lex will substitute session attributes and
        slot values into the response card. For more information, see
        [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
        slot values into the response card. For more information, see
        [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
        slot values into the response card. For more information, see
        [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
        """
        return pulumi.get(self, "response_card")


@pulumi.output_type
class IntentFollowUpPromptRejectionStatementMessage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"
        elif key == "groupNumber":
            suggest = "group_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntentFollowUpPromptRejectionStatementMessage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntentFollowUpPromptRejectionStatementMessage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntentFollowUpPromptRejectionStatementMessage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content: str,
                 content_type: str,
                 group_number: Optional[int] = None):
        """
        :param str content: The text of the message. Must be less than or equal to 1000 characters in length.
        :param str content_type: The content type of the message string.
        :param int group_number: Identifies the message group that the message belongs to. When a group
               is assigned to a message, Amazon Lex returns one message from each group in the response. Must be a number between 1 and 5 (inclusive).
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "content_type", content_type)
        if group_number is not None:
            pulumi.set(__self__, "group_number", group_number)

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        The text of the message. Must be less than or equal to 1000 characters in length.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> str:
        """
        The content type of the message string.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="groupNumber")
    def group_number(self) -> Optional[int]:
        """
        Identifies the message group that the message belongs to. When a group
        is assigned to a message, Amazon Lex returns one message from each group in the response. Must be a number between 1 and 5 (inclusive).
        """
        return pulumi.get(self, "group_number")


@pulumi.output_type
class IntentFulfillmentActivity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "codeHook":
            suggest = "code_hook"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntentFulfillmentActivity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntentFulfillmentActivity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntentFulfillmentActivity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 code_hook: Optional['outputs.IntentFulfillmentActivityCodeHook'] = None):
        """
        :param str type: How the intent should be fulfilled, either by running a Lambda function or by
               returning the slot data to the client application. Type can be either `ReturnIntent` or `CodeHook`, as documented [here](https://docs.aws.amazon.com/lex/latest/dg/API_FulfillmentActivity.html).
        :param 'IntentFulfillmentActivityCodeHookArgs' code_hook: A description of the Lambda function that is run to fulfill the intent.
               Required if type is CodeHook. Attributes are documented under code_hook.
        """
        pulumi.set(__self__, "type", type)
        if code_hook is not None:
            pulumi.set(__self__, "code_hook", code_hook)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        How the intent should be fulfilled, either by running a Lambda function or by
        returning the slot data to the client application. Type can be either `ReturnIntent` or `CodeHook`, as documented [here](https://docs.aws.amazon.com/lex/latest/dg/API_FulfillmentActivity.html).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="codeHook")
    def code_hook(self) -> Optional['outputs.IntentFulfillmentActivityCodeHook']:
        """
        A description of the Lambda function that is run to fulfill the intent.
        Required if type is CodeHook. Attributes are documented under code_hook.
        """
        return pulumi.get(self, "code_hook")


@pulumi.output_type
class IntentFulfillmentActivityCodeHook(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "messageVersion":
            suggest = "message_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntentFulfillmentActivityCodeHook. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntentFulfillmentActivityCodeHook.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntentFulfillmentActivityCodeHook.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 message_version: str,
                 uri: str):
        """
        :param str message_version: The version of the request-response that you want Amazon Lex to use
               to invoke your Lambda function. For more information, see
               [Using Lambda Functions](https://docs.aws.amazon.com/lex/latest/dg/using-lambda.html). Must be less than or equal to 5 characters in length.
        :param str uri: The Amazon Resource Name (ARN) of the Lambda function.
        """
        pulumi.set(__self__, "message_version", message_version)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="messageVersion")
    def message_version(self) -> str:
        """
        The version of the request-response that you want Amazon Lex to use
        to invoke your Lambda function. For more information, see
        [Using Lambda Functions](https://docs.aws.amazon.com/lex/latest/dg/using-lambda.html). Must be less than or equal to 5 characters in length.
        """
        return pulumi.get(self, "message_version")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        The Amazon Resource Name (ARN) of the Lambda function.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class IntentRejectionStatement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "responseCard":
            suggest = "response_card"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntentRejectionStatement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntentRejectionStatement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntentRejectionStatement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 messages: Sequence['outputs.IntentRejectionStatementMessage'],
                 response_card: Optional[str] = None):
        """
        :param str response_card: The response card. Amazon Lex will substitute session attributes and
               slot values into the response card. For more information, see
               [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
               slot values into the response card. For more information, see
               [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
               slot values into the response card. For more information, see
               [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
        """
        pulumi.set(__self__, "messages", messages)
        if response_card is not None:
            pulumi.set(__self__, "response_card", response_card)

    @property
    @pulumi.getter
    def messages(self) -> Sequence['outputs.IntentRejectionStatementMessage']:
        return pulumi.get(self, "messages")

    @property
    @pulumi.getter(name="responseCard")
    def response_card(self) -> Optional[str]:
        """
        The response card. Amazon Lex will substitute session attributes and
        slot values into the response card. For more information, see
        [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
        slot values into the response card. For more information, see
        [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
        slot values into the response card. For more information, see
        [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
        """
        return pulumi.get(self, "response_card")


@pulumi.output_type
class IntentRejectionStatementMessage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"
        elif key == "groupNumber":
            suggest = "group_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntentRejectionStatementMessage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntentRejectionStatementMessage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntentRejectionStatementMessage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content: str,
                 content_type: str,
                 group_number: Optional[int] = None):
        """
        :param str content: The text of the message. Must be less than or equal to 1000 characters in length.
        :param str content_type: The content type of the message string.
        :param int group_number: Identifies the message group that the message belongs to. When a group
               is assigned to a message, Amazon Lex returns one message from each group in the response. Must be a number between 1 and 5 (inclusive).
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "content_type", content_type)
        if group_number is not None:
            pulumi.set(__self__, "group_number", group_number)

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        The text of the message. Must be less than or equal to 1000 characters in length.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> str:
        """
        The content type of the message string.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="groupNumber")
    def group_number(self) -> Optional[int]:
        """
        Identifies the message group that the message belongs to. When a group
        is assigned to a message, Amazon Lex returns one message from each group in the response. Must be a number between 1 and 5 (inclusive).
        """
        return pulumi.get(self, "group_number")


@pulumi.output_type
class IntentSlot(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "slotConstraint":
            suggest = "slot_constraint"
        elif key == "slotType":
            suggest = "slot_type"
        elif key == "responseCard":
            suggest = "response_card"
        elif key == "sampleUtterances":
            suggest = "sample_utterances"
        elif key == "slotTypeVersion":
            suggest = "slot_type_version"
        elif key == "valueElicitationPrompt":
            suggest = "value_elicitation_prompt"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntentSlot. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntentSlot.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntentSlot.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 slot_constraint: str,
                 slot_type: str,
                 description: Optional[str] = None,
                 priority: Optional[int] = None,
                 response_card: Optional[str] = None,
                 sample_utterances: Optional[Sequence[str]] = None,
                 slot_type_version: Optional[str] = None,
                 value_elicitation_prompt: Optional['outputs.IntentSlotValueElicitationPrompt'] = None):
        """
        :param str name: The name of the intent slot that you want to create. The name is case sensitive. Must be less than or equal to 100 characters in length.
        :param str slot_constraint: Specifies whether the slot is required or optional.
        :param str slot_type: The type of the slot, either a custom slot type that you defined or one of
               the built-in slot types. Must be less than or equal to 100 characters in length.
        :param str description: A description of the bot. Must be less than or equal to 200 characters in length.
        :param int priority: Directs Lex the order in which to elicit this slot value from the user.
               For example, if the intent has two slots with priorities 1 and 2, AWS Lex first elicits a value for
               the slot with priority 1. If multiple slots share the same priority, the order in which Lex elicits
               values is arbitrary. Must be between 1 and 100.
        :param str response_card: The response card. Amazon Lex will substitute session attributes and
               slot values into the response card. For more information, see
               [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
        :param Sequence[str] sample_utterances: If you know a specific pattern with which users might respond to
               an Amazon Lex request for a slot value, you can provide those utterances to improve accuracy. This
               is optional. In most cases, Amazon Lex is capable of understanding user utterances. Must have between 1 and 10 items in the list, and each item must be less than or equal to 200 characters in length.
        :param str slot_type_version: The version of the slot type. Must be less than or equal to 64 characters in length.
        :param 'IntentSlotValueElicitationPromptArgs' value_elicitation_prompt: The prompt that Amazon Lex uses to elicit the slot value
               from the user. Attributes are documented under prompt.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "slot_constraint", slot_constraint)
        pulumi.set(__self__, "slot_type", slot_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if response_card is not None:
            pulumi.set(__self__, "response_card", response_card)
        if sample_utterances is not None:
            pulumi.set(__self__, "sample_utterances", sample_utterances)
        if slot_type_version is not None:
            pulumi.set(__self__, "slot_type_version", slot_type_version)
        if value_elicitation_prompt is not None:
            pulumi.set(__self__, "value_elicitation_prompt", value_elicitation_prompt)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the intent slot that you want to create. The name is case sensitive. Must be less than or equal to 100 characters in length.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="slotConstraint")
    def slot_constraint(self) -> str:
        """
        Specifies whether the slot is required or optional.
        """
        return pulumi.get(self, "slot_constraint")

    @property
    @pulumi.getter(name="slotType")
    def slot_type(self) -> str:
        """
        The type of the slot, either a custom slot type that you defined or one of
        the built-in slot types. Must be less than or equal to 100 characters in length.
        """
        return pulumi.get(self, "slot_type")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of the bot. Must be less than or equal to 200 characters in length.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        Directs Lex the order in which to elicit this slot value from the user.
        For example, if the intent has two slots with priorities 1 and 2, AWS Lex first elicits a value for
        the slot with priority 1. If multiple slots share the same priority, the order in which Lex elicits
        values is arbitrary. Must be between 1 and 100.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="responseCard")
    def response_card(self) -> Optional[str]:
        """
        The response card. Amazon Lex will substitute session attributes and
        slot values into the response card. For more information, see
        [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
        """
        return pulumi.get(self, "response_card")

    @property
    @pulumi.getter(name="sampleUtterances")
    def sample_utterances(self) -> Optional[Sequence[str]]:
        """
        If you know a specific pattern with which users might respond to
        an Amazon Lex request for a slot value, you can provide those utterances to improve accuracy. This
        is optional. In most cases, Amazon Lex is capable of understanding user utterances. Must have between 1 and 10 items in the list, and each item must be less than or equal to 200 characters in length.
        """
        return pulumi.get(self, "sample_utterances")

    @property
    @pulumi.getter(name="slotTypeVersion")
    def slot_type_version(self) -> Optional[str]:
        """
        The version of the slot type. Must be less than or equal to 64 characters in length.
        """
        return pulumi.get(self, "slot_type_version")

    @property
    @pulumi.getter(name="valueElicitationPrompt")
    def value_elicitation_prompt(self) -> Optional['outputs.IntentSlotValueElicitationPrompt']:
        """
        The prompt that Amazon Lex uses to elicit the slot value
        from the user. Attributes are documented under prompt.
        """
        return pulumi.get(self, "value_elicitation_prompt")


@pulumi.output_type
class IntentSlotValueElicitationPrompt(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxAttempts":
            suggest = "max_attempts"
        elif key == "responseCard":
            suggest = "response_card"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntentSlotValueElicitationPrompt. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntentSlotValueElicitationPrompt.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntentSlotValueElicitationPrompt.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_attempts: int,
                 messages: Sequence['outputs.IntentSlotValueElicitationPromptMessage'],
                 response_card: Optional[str] = None):
        """
        :param int max_attempts: The number of times to prompt the user for information. Must be a number between 1 and 5 (inclusive).
        :param str response_card: The response card. Amazon Lex will substitute session attributes and
               slot values into the response card. For more information, see
               [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
               slot values into the response card. For more information, see
               [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
               slot values into the response card. For more information, see
               [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
        """
        pulumi.set(__self__, "max_attempts", max_attempts)
        pulumi.set(__self__, "messages", messages)
        if response_card is not None:
            pulumi.set(__self__, "response_card", response_card)

    @property
    @pulumi.getter(name="maxAttempts")
    def max_attempts(self) -> int:
        """
        The number of times to prompt the user for information. Must be a number between 1 and 5 (inclusive).
        """
        return pulumi.get(self, "max_attempts")

    @property
    @pulumi.getter
    def messages(self) -> Sequence['outputs.IntentSlotValueElicitationPromptMessage']:
        return pulumi.get(self, "messages")

    @property
    @pulumi.getter(name="responseCard")
    def response_card(self) -> Optional[str]:
        """
        The response card. Amazon Lex will substitute session attributes and
        slot values into the response card. For more information, see
        [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
        slot values into the response card. For more information, see
        [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
        slot values into the response card. For more information, see
        [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
        """
        return pulumi.get(self, "response_card")


@pulumi.output_type
class IntentSlotValueElicitationPromptMessage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"
        elif key == "groupNumber":
            suggest = "group_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntentSlotValueElicitationPromptMessage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntentSlotValueElicitationPromptMessage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntentSlotValueElicitationPromptMessage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content: str,
                 content_type: str,
                 group_number: Optional[int] = None):
        """
        :param str content: The text of the message. Must be less than or equal to 1000 characters in length.
        :param str content_type: The content type of the message string.
        :param int group_number: Identifies the message group that the message belongs to. When a group
               is assigned to a message, Amazon Lex returns one message from each group in the response. Must be a number between 1 and 5 (inclusive).
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "content_type", content_type)
        if group_number is not None:
            pulumi.set(__self__, "group_number", group_number)

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        The text of the message. Must be less than or equal to 1000 characters in length.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> str:
        """
        The content type of the message string.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="groupNumber")
    def group_number(self) -> Optional[int]:
        """
        Identifies the message group that the message belongs to. When a group
        is assigned to a message, Amazon Lex returns one message from each group in the response. Must be a number between 1 and 5 (inclusive).
        """
        return pulumi.get(self, "group_number")


@pulumi.output_type
class SlotTypeEnumerationValue(dict):
    def __init__(__self__, *,
                 value: str,
                 synonyms: Optional[Sequence[str]] = None):
        """
        :param str value: The value of the slot type. Must be less than or equal to 140 characters in length.
        :param Sequence[str] synonyms: Additional values related to the slot type value. Each item must be less than or equal to 140 characters in length.
        """
        pulumi.set(__self__, "value", value)
        if synonyms is not None:
            pulumi.set(__self__, "synonyms", synonyms)

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the slot type. Must be less than or equal to 140 characters in length.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def synonyms(self) -> Optional[Sequence[str]]:
        """
        Additional values related to the slot type value. Each item must be less than or equal to 140 characters in length.
        """
        return pulumi.get(self, "synonyms")


@pulumi.output_type
class GetSlotTypeEnumerationValueResult(dict):
    def __init__(__self__, *,
                 synonyms: Sequence[str],
                 value: str):
        pulumi.set(__self__, "synonyms", synonyms)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def synonyms(self) -> Sequence[str]:
        return pulumi.get(self, "synonyms")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


