# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstancePublicPortsArgs', 'InstancePublicPorts']

@pulumi.input_type
class InstancePublicPortsArgs:
    def __init__(__self__, *,
                 instance_name: pulumi.Input[str],
                 port_infos: pulumi.Input[Sequence[pulumi.Input['InstancePublicPortsPortInfoArgs']]]):
        """
        The set of arguments for constructing a InstancePublicPorts resource.
        :param pulumi.Input[str] instance_name: Name of the Lightsail Instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstancePublicPortsPortInfoArgs']]] port_infos: Configuration block with port information. AWS closes all currently open ports that are not included in the `port_info`. Detailed below.
        """
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "port_infos", port_infos)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Input[str]:
        """
        Name of the Lightsail Instance.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="portInfos")
    def port_infos(self) -> pulumi.Input[Sequence[pulumi.Input['InstancePublicPortsPortInfoArgs']]]:
        """
        Configuration block with port information. AWS closes all currently open ports that are not included in the `port_info`. Detailed below.
        """
        return pulumi.get(self, "port_infos")

    @port_infos.setter
    def port_infos(self, value: pulumi.Input[Sequence[pulumi.Input['InstancePublicPortsPortInfoArgs']]]):
        pulumi.set(self, "port_infos", value)


@pulumi.input_type
class _InstancePublicPortsState:
    def __init__(__self__, *,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 port_infos: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePublicPortsPortInfoArgs']]]] = None):
        """
        Input properties used for looking up and filtering InstancePublicPorts resources.
        :param pulumi.Input[str] instance_name: Name of the Lightsail Instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstancePublicPortsPortInfoArgs']]] port_infos: Configuration block with port information. AWS closes all currently open ports that are not included in the `port_info`. Detailed below.
        """
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if port_infos is not None:
            pulumi.set(__self__, "port_infos", port_infos)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Lightsail Instance.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="portInfos")
    def port_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstancePublicPortsPortInfoArgs']]]]:
        """
        Configuration block with port information. AWS closes all currently open ports that are not included in the `port_info`. Detailed below.
        """
        return pulumi.get(self, "port_infos")

    @port_infos.setter
    def port_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePublicPortsPortInfoArgs']]]]):
        pulumi.set(self, "port_infos", value)


class InstancePublicPorts(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 port_infos: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstancePublicPortsPortInfoArgs']]]]] = None,
                 __props__=None):
        """
        Opens ports for a specific Amazon Lightsail instance, and specifies the IP addresses allowed to connect to the instance through the ports, and the protocol.

        > See [What is Amazon Lightsail?](https://lightsail.aws.amazon.com/ls/docs/getting-started/article/what-is-amazon-lightsail) for more information.

        > **Note:** Lightsail is currently only supported in a limited number of AWS Regions, please see ["Regions and Availability Zones in Amazon Lightsail"](https://lightsail.aws.amazon.com/ls/docs/overview/article/understanding-regions-and-availability-zones-in-amazon-lightsail) for more details.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test_instance = aws.lightsail.Instance("testInstance",
            availability_zone=data["aws_availability_zones"]["available"]["names"],
            blueprint_id="amazon_linux_2",
            bundle_id="nano_1_0")
        test_instance_public_ports = aws.lightsail.InstancePublicPorts("testInstancePublicPorts",
            instance_name=test_instance.name,
            port_infos=[aws.lightsail.InstancePublicPortsPortInfoArgs(
                protocol="tcp",
                from_port=80,
                to_port=80,
            )])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] instance_name: Name of the Lightsail Instance.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstancePublicPortsPortInfoArgs']]]] port_infos: Configuration block with port information. AWS closes all currently open ports that are not included in the `port_info`. Detailed below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstancePublicPortsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Opens ports for a specific Amazon Lightsail instance, and specifies the IP addresses allowed to connect to the instance through the ports, and the protocol.

        > See [What is Amazon Lightsail?](https://lightsail.aws.amazon.com/ls/docs/getting-started/article/what-is-amazon-lightsail) for more information.

        > **Note:** Lightsail is currently only supported in a limited number of AWS Regions, please see ["Regions and Availability Zones in Amazon Lightsail"](https://lightsail.aws.amazon.com/ls/docs/overview/article/understanding-regions-and-availability-zones-in-amazon-lightsail) for more details.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test_instance = aws.lightsail.Instance("testInstance",
            availability_zone=data["aws_availability_zones"]["available"]["names"],
            blueprint_id="amazon_linux_2",
            bundle_id="nano_1_0")
        test_instance_public_ports = aws.lightsail.InstancePublicPorts("testInstancePublicPorts",
            instance_name=test_instance.name,
            port_infos=[aws.lightsail.InstancePublicPortsPortInfoArgs(
                protocol="tcp",
                from_port=80,
                to_port=80,
            )])
        ```

        :param str resource_name: The name of the resource.
        :param InstancePublicPortsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstancePublicPortsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 port_infos: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstancePublicPortsPortInfoArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstancePublicPortsArgs.__new__(InstancePublicPortsArgs)

            if instance_name is None and not opts.urn:
                raise TypeError("Missing required property 'instance_name'")
            __props__.__dict__["instance_name"] = instance_name
            if port_infos is None and not opts.urn:
                raise TypeError("Missing required property 'port_infos'")
            __props__.__dict__["port_infos"] = port_infos
        super(InstancePublicPorts, __self__).__init__(
            'aws:lightsail/instancePublicPorts:InstancePublicPorts',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            instance_name: Optional[pulumi.Input[str]] = None,
            port_infos: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstancePublicPortsPortInfoArgs']]]]] = None) -> 'InstancePublicPorts':
        """
        Get an existing InstancePublicPorts resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] instance_name: Name of the Lightsail Instance.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstancePublicPortsPortInfoArgs']]]] port_infos: Configuration block with port information. AWS closes all currently open ports that are not included in the `port_info`. Detailed below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstancePublicPortsState.__new__(_InstancePublicPortsState)

        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["port_infos"] = port_infos
        return InstancePublicPorts(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[str]:
        """
        Name of the Lightsail Instance.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="portInfos")
    def port_infos(self) -> pulumi.Output[Sequence['outputs.InstancePublicPortsPortInfo']]:
        """
        Configuration block with port information. AWS closes all currently open ports that are not included in the `port_info`. Detailed below.
        """
        return pulumi.get(self, "port_infos")

