# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetClusterResult',
    'AwaitableGetClusterResult',
    'get_cluster',
    'get_cluster_output',
]

@pulumi.output_type
class GetClusterResult:
    """
    A collection of values returned by getCluster.
    """
    def __init__(__self__, acl_name=None, arn=None, auto_minor_version_upgrade=None, cluster_endpoints=None, data_tiering=None, description=None, engine_patch_version=None, engine_version=None, final_snapshot_name=None, id=None, kms_key_arn=None, maintenance_window=None, name=None, node_type=None, num_replicas_per_shard=None, num_shards=None, parameter_group_name=None, port=None, security_group_ids=None, shards=None, snapshot_retention_limit=None, snapshot_window=None, sns_topic_arn=None, subnet_group_name=None, tags=None, tls_enabled=None):
        if acl_name and not isinstance(acl_name, str):
            raise TypeError("Expected argument 'acl_name' to be a str")
        pulumi.set(__self__, "acl_name", acl_name)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if auto_minor_version_upgrade and not isinstance(auto_minor_version_upgrade, bool):
            raise TypeError("Expected argument 'auto_minor_version_upgrade' to be a bool")
        pulumi.set(__self__, "auto_minor_version_upgrade", auto_minor_version_upgrade)
        if cluster_endpoints and not isinstance(cluster_endpoints, list):
            raise TypeError("Expected argument 'cluster_endpoints' to be a list")
        pulumi.set(__self__, "cluster_endpoints", cluster_endpoints)
        if data_tiering and not isinstance(data_tiering, bool):
            raise TypeError("Expected argument 'data_tiering' to be a bool")
        pulumi.set(__self__, "data_tiering", data_tiering)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if engine_patch_version and not isinstance(engine_patch_version, str):
            raise TypeError("Expected argument 'engine_patch_version' to be a str")
        pulumi.set(__self__, "engine_patch_version", engine_patch_version)
        if engine_version and not isinstance(engine_version, str):
            raise TypeError("Expected argument 'engine_version' to be a str")
        pulumi.set(__self__, "engine_version", engine_version)
        if final_snapshot_name and not isinstance(final_snapshot_name, str):
            raise TypeError("Expected argument 'final_snapshot_name' to be a str")
        pulumi.set(__self__, "final_snapshot_name", final_snapshot_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kms_key_arn and not isinstance(kms_key_arn, str):
            raise TypeError("Expected argument 'kms_key_arn' to be a str")
        pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if maintenance_window and not isinstance(maintenance_window, str):
            raise TypeError("Expected argument 'maintenance_window' to be a str")
        pulumi.set(__self__, "maintenance_window", maintenance_window)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if node_type and not isinstance(node_type, str):
            raise TypeError("Expected argument 'node_type' to be a str")
        pulumi.set(__self__, "node_type", node_type)
        if num_replicas_per_shard and not isinstance(num_replicas_per_shard, int):
            raise TypeError("Expected argument 'num_replicas_per_shard' to be a int")
        pulumi.set(__self__, "num_replicas_per_shard", num_replicas_per_shard)
        if num_shards and not isinstance(num_shards, int):
            raise TypeError("Expected argument 'num_shards' to be a int")
        pulumi.set(__self__, "num_shards", num_shards)
        if parameter_group_name and not isinstance(parameter_group_name, str):
            raise TypeError("Expected argument 'parameter_group_name' to be a str")
        pulumi.set(__self__, "parameter_group_name", parameter_group_name)
        if port and not isinstance(port, int):
            raise TypeError("Expected argument 'port' to be a int")
        pulumi.set(__self__, "port", port)
        if security_group_ids and not isinstance(security_group_ids, list):
            raise TypeError("Expected argument 'security_group_ids' to be a list")
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        if shards and not isinstance(shards, list):
            raise TypeError("Expected argument 'shards' to be a list")
        pulumi.set(__self__, "shards", shards)
        if snapshot_retention_limit and not isinstance(snapshot_retention_limit, int):
            raise TypeError("Expected argument 'snapshot_retention_limit' to be a int")
        pulumi.set(__self__, "snapshot_retention_limit", snapshot_retention_limit)
        if snapshot_window and not isinstance(snapshot_window, str):
            raise TypeError("Expected argument 'snapshot_window' to be a str")
        pulumi.set(__self__, "snapshot_window", snapshot_window)
        if sns_topic_arn and not isinstance(sns_topic_arn, str):
            raise TypeError("Expected argument 'sns_topic_arn' to be a str")
        pulumi.set(__self__, "sns_topic_arn", sns_topic_arn)
        if subnet_group_name and not isinstance(subnet_group_name, str):
            raise TypeError("Expected argument 'subnet_group_name' to be a str")
        pulumi.set(__self__, "subnet_group_name", subnet_group_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if tls_enabled and not isinstance(tls_enabled, bool):
            raise TypeError("Expected argument 'tls_enabled' to be a bool")
        pulumi.set(__self__, "tls_enabled", tls_enabled)

    @property
    @pulumi.getter(name="aclName")
    def acl_name(self) -> str:
        """
        Name of the Access Control List associated with the cluster.
        """
        return pulumi.get(self, "acl_name")

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        ARN of the cluster.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="autoMinorVersionUpgrade")
    def auto_minor_version_upgrade(self) -> bool:
        """
        True when the cluster allows automatic minor version upgrades.
        """
        return pulumi.get(self, "auto_minor_version_upgrade")

    @property
    @pulumi.getter(name="clusterEndpoints")
    def cluster_endpoints(self) -> Sequence['outputs.GetClusterClusterEndpointResult']:
        return pulumi.get(self, "cluster_endpoints")

    @property
    @pulumi.getter(name="dataTiering")
    def data_tiering(self) -> bool:
        """
        True when data tiering is enabled.
        """
        return pulumi.get(self, "data_tiering")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description for the cluster.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enginePatchVersion")
    def engine_patch_version(self) -> str:
        """
        Patch version number of the Redis engine used by the cluster.
        """
        return pulumi.get(self, "engine_patch_version")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> str:
        """
        Version number of the Redis engine used by the cluster.
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter(name="finalSnapshotName")
    def final_snapshot_name(self) -> str:
        """
        Name of the final cluster snapshot to be created when this resource is deleted. If omitted, no final snapshot will be made.
        """
        return pulumi.get(self, "final_snapshot_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> str:
        """
        ARN of the KMS key used to encrypt the cluster at rest.
        """
        return pulumi.get(self, "kms_key_arn")

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> str:
        """
        Weekly time range during which maintenance on the cluster is performed. Specify as a range in the format `ddd:hh24:mi-ddd:hh24:mi` (24H Clock UTC). Example: `sun:23:00-mon:01:30`.
        """
        return pulumi.get(self, "maintenance_window")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of this node.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> str:
        """
        Compute and memory capacity of the nodes in the cluster.
        """
        return pulumi.get(self, "node_type")

    @property
    @pulumi.getter(name="numReplicasPerShard")
    def num_replicas_per_shard(self) -> int:
        """
        The number of replicas to apply to each shard.
        """
        return pulumi.get(self, "num_replicas_per_shard")

    @property
    @pulumi.getter(name="numShards")
    def num_shards(self) -> int:
        """
        Number of shards in the cluster.
        """
        return pulumi.get(self, "num_shards")

    @property
    @pulumi.getter(name="parameterGroupName")
    def parameter_group_name(self) -> str:
        """
        The name of the parameter group associated with the cluster.
        """
        return pulumi.get(self, "parameter_group_name")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Port number that this node is listening on.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[str]:
        """
        Set of VPC Security Group ID-s associated with this cluster.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter
    def shards(self) -> Sequence['outputs.GetClusterShardResult']:
        """
        Set of shards in this cluster.
        """
        return pulumi.get(self, "shards")

    @property
    @pulumi.getter(name="snapshotRetentionLimit")
    def snapshot_retention_limit(self) -> int:
        """
        The number of days for which MemoryDB retains automatic snapshots before deleting them. When set to `0`, automatic backups are disabled.
        """
        return pulumi.get(self, "snapshot_retention_limit")

    @property
    @pulumi.getter(name="snapshotWindow")
    def snapshot_window(self) -> str:
        """
        Daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your shard. Example: `05:00-09:00`.
        """
        return pulumi.get(self, "snapshot_window")

    @property
    @pulumi.getter(name="snsTopicArn")
    def sns_topic_arn(self) -> str:
        """
        ARN of the SNS topic to which cluster notifications are sent.
        """
        return pulumi.get(self, "sns_topic_arn")

    @property
    @pulumi.getter(name="subnetGroupName")
    def subnet_group_name(self) -> str:
        """
        The name of the subnet group used for the cluster.
        """
        return pulumi.get(self, "subnet_group_name")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        """
        Map of tags assigned to the cluster.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tlsEnabled")
    def tls_enabled(self) -> bool:
        """
        When true, in-transit encryption is enabled for the cluster.
        """
        return pulumi.get(self, "tls_enabled")


class AwaitableGetClusterResult(GetClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClusterResult(
            acl_name=self.acl_name,
            arn=self.arn,
            auto_minor_version_upgrade=self.auto_minor_version_upgrade,
            cluster_endpoints=self.cluster_endpoints,
            data_tiering=self.data_tiering,
            description=self.description,
            engine_patch_version=self.engine_patch_version,
            engine_version=self.engine_version,
            final_snapshot_name=self.final_snapshot_name,
            id=self.id,
            kms_key_arn=self.kms_key_arn,
            maintenance_window=self.maintenance_window,
            name=self.name,
            node_type=self.node_type,
            num_replicas_per_shard=self.num_replicas_per_shard,
            num_shards=self.num_shards,
            parameter_group_name=self.parameter_group_name,
            port=self.port,
            security_group_ids=self.security_group_ids,
            shards=self.shards,
            snapshot_retention_limit=self.snapshot_retention_limit,
            snapshot_window=self.snapshot_window,
            sns_topic_arn=self.sns_topic_arn,
            subnet_group_name=self.subnet_group_name,
            tags=self.tags,
            tls_enabled=self.tls_enabled)


def get_cluster(name: Optional[str] = None,
                tags: Optional[Mapping[str, str]] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClusterResult:
    """
    Provides information about a MemoryDB Cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.memorydb.get_cluster(name="my-cluster")
    ```


    :param str name: Name of the cluster.
    :param Mapping[str, str] tags: Map of tags assigned to the cluster.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:memorydb/getCluster:getCluster', __args__, opts=opts, typ=GetClusterResult).value

    return AwaitableGetClusterResult(
        acl_name=pulumi.get(__ret__, 'acl_name'),
        arn=pulumi.get(__ret__, 'arn'),
        auto_minor_version_upgrade=pulumi.get(__ret__, 'auto_minor_version_upgrade'),
        cluster_endpoints=pulumi.get(__ret__, 'cluster_endpoints'),
        data_tiering=pulumi.get(__ret__, 'data_tiering'),
        description=pulumi.get(__ret__, 'description'),
        engine_patch_version=pulumi.get(__ret__, 'engine_patch_version'),
        engine_version=pulumi.get(__ret__, 'engine_version'),
        final_snapshot_name=pulumi.get(__ret__, 'final_snapshot_name'),
        id=pulumi.get(__ret__, 'id'),
        kms_key_arn=pulumi.get(__ret__, 'kms_key_arn'),
        maintenance_window=pulumi.get(__ret__, 'maintenance_window'),
        name=pulumi.get(__ret__, 'name'),
        node_type=pulumi.get(__ret__, 'node_type'),
        num_replicas_per_shard=pulumi.get(__ret__, 'num_replicas_per_shard'),
        num_shards=pulumi.get(__ret__, 'num_shards'),
        parameter_group_name=pulumi.get(__ret__, 'parameter_group_name'),
        port=pulumi.get(__ret__, 'port'),
        security_group_ids=pulumi.get(__ret__, 'security_group_ids'),
        shards=pulumi.get(__ret__, 'shards'),
        snapshot_retention_limit=pulumi.get(__ret__, 'snapshot_retention_limit'),
        snapshot_window=pulumi.get(__ret__, 'snapshot_window'),
        sns_topic_arn=pulumi.get(__ret__, 'sns_topic_arn'),
        subnet_group_name=pulumi.get(__ret__, 'subnet_group_name'),
        tags=pulumi.get(__ret__, 'tags'),
        tls_enabled=pulumi.get(__ret__, 'tls_enabled'))


@_utilities.lift_output_func(get_cluster)
def get_cluster_output(name: Optional[pulumi.Input[str]] = None,
                       tags: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetClusterResult]:
    """
    Provides information about a MemoryDB Cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.memorydb.get_cluster(name="my-cluster")
    ```


    :param str name: Name of the cluster.
    :param Mapping[str, str] tags: Map of tags assigned to the cluster.
    """
    ...
