# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ClusterBrokerNodeGroupInfo',
    'ClusterBrokerNodeGroupInfoConnectivityInfo',
    'ClusterBrokerNodeGroupInfoConnectivityInfoPublicAccess',
    'ClusterBrokerNodeGroupInfoStorageInfo',
    'ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfo',
    'ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughput',
    'ClusterClientAuthentication',
    'ClusterClientAuthenticationSasl',
    'ClusterClientAuthenticationTls',
    'ClusterConfigurationInfo',
    'ClusterEncryptionInfo',
    'ClusterEncryptionInfoEncryptionInTransit',
    'ClusterLoggingInfo',
    'ClusterLoggingInfoBrokerLogs',
    'ClusterLoggingInfoBrokerLogsCloudwatchLogs',
    'ClusterLoggingInfoBrokerLogsFirehose',
    'ClusterLoggingInfoBrokerLogsS3',
    'ClusterOpenMonitoring',
    'ClusterOpenMonitoringPrometheus',
    'ClusterOpenMonitoringPrometheusJmxExporter',
    'ClusterOpenMonitoringPrometheusNodeExporter',
    'ServerlessClusterClientAuthentication',
    'ServerlessClusterClientAuthenticationSasl',
    'ServerlessClusterClientAuthenticationSaslIam',
    'ServerlessClusterVpcConfig',
    'GetBrokerNodesNodeInfoListResult',
]

@pulumi.output_type
class ClusterBrokerNodeGroupInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientSubnets":
            suggest = "client_subnets"
        elif key == "instanceType":
            suggest = "instance_type"
        elif key == "securityGroups":
            suggest = "security_groups"
        elif key == "azDistribution":
            suggest = "az_distribution"
        elif key == "connectivityInfo":
            suggest = "connectivity_info"
        elif key == "storageInfo":
            suggest = "storage_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterBrokerNodeGroupInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterBrokerNodeGroupInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterBrokerNodeGroupInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_subnets: Sequence[str],
                 instance_type: str,
                 security_groups: Sequence[str],
                 az_distribution: Optional[str] = None,
                 connectivity_info: Optional['outputs.ClusterBrokerNodeGroupInfoConnectivityInfo'] = None,
                 storage_info: Optional['outputs.ClusterBrokerNodeGroupInfoStorageInfo'] = None):
        """
        :param Sequence[str] client_subnets: A list of subnets to connect to in client VPC ([documentation](https://docs.aws.amazon.com/msk/1.0/apireference/clusters.html#clusters-prop-brokernodegroupinfo-clientsubnets)).
        :param str instance_type: Specify the instance type to use for the kafka brokersE.g., kafka.m5.large. ([Pricing info](https://aws.amazon.com/msk/pricing/))
        :param Sequence[str] security_groups: A list of the security groups to associate with the elastic network interfaces to control who can communicate with the cluster.
        :param str az_distribution: The distribution of broker nodes across availability zones ([documentation](https://docs.aws.amazon.com/msk/1.0/apireference/clusters.html#clusters-model-brokerazdistribution)). Currently the only valid value is `DEFAULT`.
        :param 'ClusterBrokerNodeGroupInfoConnectivityInfoArgs' connectivity_info: Information about the cluster access configuration. See below. For security reasons, you can't turn on public access while creating an MSK cluster. However, you can update an existing cluster to make it publicly accessible. You can also create a new cluster and then update it to make it publicly accessible ([documentation](https://docs.aws.amazon.com/msk/latest/developerguide/public-access.html)).
        :param 'ClusterBrokerNodeGroupInfoStorageInfoArgs' storage_info: A block that contains information about storage volumes attached to MSK broker nodes. See below.
        """
        pulumi.set(__self__, "client_subnets", client_subnets)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "security_groups", security_groups)
        if az_distribution is not None:
            pulumi.set(__self__, "az_distribution", az_distribution)
        if connectivity_info is not None:
            pulumi.set(__self__, "connectivity_info", connectivity_info)
        if storage_info is not None:
            pulumi.set(__self__, "storage_info", storage_info)

    @property
    @pulumi.getter(name="clientSubnets")
    def client_subnets(self) -> Sequence[str]:
        """
        A list of subnets to connect to in client VPC ([documentation](https://docs.aws.amazon.com/msk/1.0/apireference/clusters.html#clusters-prop-brokernodegroupinfo-clientsubnets)).
        """
        return pulumi.get(self, "client_subnets")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Specify the instance type to use for the kafka brokersE.g., kafka.m5.large. ([Pricing info](https://aws.amazon.com/msk/pricing/))
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Sequence[str]:
        """
        A list of the security groups to associate with the elastic network interfaces to control who can communicate with the cluster.
        """
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter(name="azDistribution")
    def az_distribution(self) -> Optional[str]:
        """
        The distribution of broker nodes across availability zones ([documentation](https://docs.aws.amazon.com/msk/1.0/apireference/clusters.html#clusters-model-brokerazdistribution)). Currently the only valid value is `DEFAULT`.
        """
        return pulumi.get(self, "az_distribution")

    @property
    @pulumi.getter(name="connectivityInfo")
    def connectivity_info(self) -> Optional['outputs.ClusterBrokerNodeGroupInfoConnectivityInfo']:
        """
        Information about the cluster access configuration. See below. For security reasons, you can't turn on public access while creating an MSK cluster. However, you can update an existing cluster to make it publicly accessible. You can also create a new cluster and then update it to make it publicly accessible ([documentation](https://docs.aws.amazon.com/msk/latest/developerguide/public-access.html)).
        """
        return pulumi.get(self, "connectivity_info")

    @property
    @pulumi.getter(name="storageInfo")
    def storage_info(self) -> Optional['outputs.ClusterBrokerNodeGroupInfoStorageInfo']:
        """
        A block that contains information about storage volumes attached to MSK broker nodes. See below.
        """
        return pulumi.get(self, "storage_info")


@pulumi.output_type
class ClusterBrokerNodeGroupInfoConnectivityInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicAccess":
            suggest = "public_access"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterBrokerNodeGroupInfoConnectivityInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterBrokerNodeGroupInfoConnectivityInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterBrokerNodeGroupInfoConnectivityInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_access: Optional['outputs.ClusterBrokerNodeGroupInfoConnectivityInfoPublicAccess'] = None):
        """
        :param 'ClusterBrokerNodeGroupInfoConnectivityInfoPublicAccessArgs' public_access: Access control settings for brokers. See below.
        """
        if public_access is not None:
            pulumi.set(__self__, "public_access", public_access)

    @property
    @pulumi.getter(name="publicAccess")
    def public_access(self) -> Optional['outputs.ClusterBrokerNodeGroupInfoConnectivityInfoPublicAccess']:
        """
        Access control settings for brokers. See below.
        """
        return pulumi.get(self, "public_access")


@pulumi.output_type
class ClusterBrokerNodeGroupInfoConnectivityInfoPublicAccess(dict):
    def __init__(__self__, *,
                 type: Optional[str] = None):
        """
        :param str type: Public access type. Valida values: `DISABLED`, `SERVICE_PROVIDED_EIPS`.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Public access type. Valida values: `DISABLED`, `SERVICE_PROVIDED_EIPS`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ClusterBrokerNodeGroupInfoStorageInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ebsStorageInfo":
            suggest = "ebs_storage_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterBrokerNodeGroupInfoStorageInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterBrokerNodeGroupInfoStorageInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterBrokerNodeGroupInfoStorageInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ebs_storage_info: Optional['outputs.ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfo'] = None):
        """
        :param 'ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoArgs' ebs_storage_info: A block that contains EBS volume information. See below.
        """
        if ebs_storage_info is not None:
            pulumi.set(__self__, "ebs_storage_info", ebs_storage_info)

    @property
    @pulumi.getter(name="ebsStorageInfo")
    def ebs_storage_info(self) -> Optional['outputs.ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfo']:
        """
        A block that contains EBS volume information. See below.
        """
        return pulumi.get(self, "ebs_storage_info")


@pulumi.output_type
class ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisionedThroughput":
            suggest = "provisioned_throughput"
        elif key == "volumeSize":
            suggest = "volume_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioned_throughput: Optional['outputs.ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughput'] = None,
                 volume_size: Optional[int] = None):
        """
        :param 'ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughputArgs' provisioned_throughput: A block that contains EBS volume provisioned throughput information. To provision storage throughput, you must choose broker type kafka.m5.4xlarge or larger. See below.
        :param int volume_size: The size in GiB of the EBS volume for the data drive on each broker node. Minimum value of `1` and maximum value of `16384`.
        """
        if provisioned_throughput is not None:
            pulumi.set(__self__, "provisioned_throughput", provisioned_throughput)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)

    @property
    @pulumi.getter(name="provisionedThroughput")
    def provisioned_throughput(self) -> Optional['outputs.ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughput']:
        """
        A block that contains EBS volume provisioned throughput information. To provision storage throughput, you must choose broker type kafka.m5.4xlarge or larger. See below.
        """
        return pulumi.get(self, "provisioned_throughput")

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[int]:
        """
        The size in GiB of the EBS volume for the data drive on each broker node. Minimum value of `1` and maximum value of `16384`.
        """
        return pulumi.get(self, "volume_size")


@pulumi.output_type
class ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughput(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "volumeThroughput":
            suggest = "volume_throughput"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 volume_throughput: Optional[int] = None):
        """
        :param bool enabled: Controls whether provisioned throughput is enabled or not. Default value: `false`.
        :param int volume_throughput: Throughput value of the EBS volumes for the data drive on each kafka broker node in MiB per second. The minimum value is `250`. The maximum value varies between broker type. You can refer to the valid values for the maximum volume throughput at the following [documentation on throughput bottlenecks](https://docs.aws.amazon.com/msk/latest/developerguide/msk-provision-throughput.html#throughput-bottlenecks)
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if volume_throughput is not None:
            pulumi.set(__self__, "volume_throughput", volume_throughput)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Controls whether provisioned throughput is enabled or not. Default value: `false`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="volumeThroughput")
    def volume_throughput(self) -> Optional[int]:
        """
        Throughput value of the EBS volumes for the data drive on each kafka broker node in MiB per second. The minimum value is `250`. The maximum value varies between broker type. You can refer to the valid values for the maximum volume throughput at the following [documentation on throughput bottlenecks](https://docs.aws.amazon.com/msk/latest/developerguide/msk-provision-throughput.html#throughput-bottlenecks)
        """
        return pulumi.get(self, "volume_throughput")


@pulumi.output_type
class ClusterClientAuthentication(dict):
    def __init__(__self__, *,
                 sasl: Optional['outputs.ClusterClientAuthenticationSasl'] = None,
                 tls: Optional['outputs.ClusterClientAuthenticationTls'] = None,
                 unauthenticated: Optional[bool] = None):
        """
        :param 'ClusterClientAuthenticationSaslArgs' sasl: Configuration block for specifying SASL client authentication. See below.
        :param 'ClusterClientAuthenticationTlsArgs' tls: Configuration block for specifying TLS client authentication. See below.
        :param bool unauthenticated: Enables unauthenticated access.
        """
        if sasl is not None:
            pulumi.set(__self__, "sasl", sasl)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)
        if unauthenticated is not None:
            pulumi.set(__self__, "unauthenticated", unauthenticated)

    @property
    @pulumi.getter
    def sasl(self) -> Optional['outputs.ClusterClientAuthenticationSasl']:
        """
        Configuration block for specifying SASL client authentication. See below.
        """
        return pulumi.get(self, "sasl")

    @property
    @pulumi.getter
    def tls(self) -> Optional['outputs.ClusterClientAuthenticationTls']:
        """
        Configuration block for specifying TLS client authentication. See below.
        """
        return pulumi.get(self, "tls")

    @property
    @pulumi.getter
    def unauthenticated(self) -> Optional[bool]:
        """
        Enables unauthenticated access.
        """
        return pulumi.get(self, "unauthenticated")


@pulumi.output_type
class ClusterClientAuthenticationSasl(dict):
    def __init__(__self__, *,
                 iam: Optional[bool] = None,
                 scram: Optional[bool] = None):
        """
        :param bool iam: Enables IAM client authentication. Defaults to `false`.
        :param bool scram: Enables SCRAM client authentication via AWS Secrets Manager. Defaults to `false`.
        """
        if iam is not None:
            pulumi.set(__self__, "iam", iam)
        if scram is not None:
            pulumi.set(__self__, "scram", scram)

    @property
    @pulumi.getter
    def iam(self) -> Optional[bool]:
        """
        Enables IAM client authentication. Defaults to `false`.
        """
        return pulumi.get(self, "iam")

    @property
    @pulumi.getter
    def scram(self) -> Optional[bool]:
        """
        Enables SCRAM client authentication via AWS Secrets Manager. Defaults to `false`.
        """
        return pulumi.get(self, "scram")


@pulumi.output_type
class ClusterClientAuthenticationTls(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateAuthorityArns":
            suggest = "certificate_authority_arns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClientAuthenticationTls. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClientAuthenticationTls.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClientAuthenticationTls.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_authority_arns: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] certificate_authority_arns: List of ACM Certificate Authority Amazon Resource Names (ARNs).
        """
        if certificate_authority_arns is not None:
            pulumi.set(__self__, "certificate_authority_arns", certificate_authority_arns)

    @property
    @pulumi.getter(name="certificateAuthorityArns")
    def certificate_authority_arns(self) -> Optional[Sequence[str]]:
        """
        List of ACM Certificate Authority Amazon Resource Names (ARNs).
        """
        return pulumi.get(self, "certificate_authority_arns")


@pulumi.output_type
class ClusterConfigurationInfo(dict):
    def __init__(__self__, *,
                 arn: str,
                 revision: int):
        """
        :param str arn: Amazon Resource Name (ARN) of the MSK Configuration to use in the cluster.
        :param int revision: Revision of the MSK Configuration to use in the cluster.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "revision", revision)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        Amazon Resource Name (ARN) of the MSK Configuration to use in the cluster.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def revision(self) -> int:
        """
        Revision of the MSK Configuration to use in the cluster.
        """
        return pulumi.get(self, "revision")


@pulumi.output_type
class ClusterEncryptionInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionAtRestKmsKeyArn":
            suggest = "encryption_at_rest_kms_key_arn"
        elif key == "encryptionInTransit":
            suggest = "encryption_in_transit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterEncryptionInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterEncryptionInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterEncryptionInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_at_rest_kms_key_arn: Optional[str] = None,
                 encryption_in_transit: Optional['outputs.ClusterEncryptionInfoEncryptionInTransit'] = None):
        """
        :param str encryption_at_rest_kms_key_arn: You may specify a KMS key short ID or ARN (it will always output an ARN) to use for encrypting your data at rest.  If no key is specified, an AWS managed KMS ('aws/msk' managed service) key will be used for encrypting the data at rest.
        :param 'ClusterEncryptionInfoEncryptionInTransitArgs' encryption_in_transit: Configuration block to specify encryption in transit. See below.
        """
        if encryption_at_rest_kms_key_arn is not None:
            pulumi.set(__self__, "encryption_at_rest_kms_key_arn", encryption_at_rest_kms_key_arn)
        if encryption_in_transit is not None:
            pulumi.set(__self__, "encryption_in_transit", encryption_in_transit)

    @property
    @pulumi.getter(name="encryptionAtRestKmsKeyArn")
    def encryption_at_rest_kms_key_arn(self) -> Optional[str]:
        """
        You may specify a KMS key short ID or ARN (it will always output an ARN) to use for encrypting your data at rest.  If no key is specified, an AWS managed KMS ('aws/msk' managed service) key will be used for encrypting the data at rest.
        """
        return pulumi.get(self, "encryption_at_rest_kms_key_arn")

    @property
    @pulumi.getter(name="encryptionInTransit")
    def encryption_in_transit(self) -> Optional['outputs.ClusterEncryptionInfoEncryptionInTransit']:
        """
        Configuration block to specify encryption in transit. See below.
        """
        return pulumi.get(self, "encryption_in_transit")


@pulumi.output_type
class ClusterEncryptionInfoEncryptionInTransit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientBroker":
            suggest = "client_broker"
        elif key == "inCluster":
            suggest = "in_cluster"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterEncryptionInfoEncryptionInTransit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterEncryptionInfoEncryptionInTransit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterEncryptionInfoEncryptionInTransit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_broker: Optional[str] = None,
                 in_cluster: Optional[bool] = None):
        """
        :param str client_broker: Encryption setting for data in transit between clients and brokers. Valid values: `TLS`, `TLS_PLAINTEXT`, and `PLAINTEXT`. Default value is `TLS`.
        :param bool in_cluster: Whether data communication among broker nodes is encrypted. Default value: `true`.
        """
        if client_broker is not None:
            pulumi.set(__self__, "client_broker", client_broker)
        if in_cluster is not None:
            pulumi.set(__self__, "in_cluster", in_cluster)

    @property
    @pulumi.getter(name="clientBroker")
    def client_broker(self) -> Optional[str]:
        """
        Encryption setting for data in transit between clients and brokers. Valid values: `TLS`, `TLS_PLAINTEXT`, and `PLAINTEXT`. Default value is `TLS`.
        """
        return pulumi.get(self, "client_broker")

    @property
    @pulumi.getter(name="inCluster")
    def in_cluster(self) -> Optional[bool]:
        """
        Whether data communication among broker nodes is encrypted. Default value: `true`.
        """
        return pulumi.get(self, "in_cluster")


@pulumi.output_type
class ClusterLoggingInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "brokerLogs":
            suggest = "broker_logs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterLoggingInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterLoggingInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterLoggingInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 broker_logs: 'outputs.ClusterLoggingInfoBrokerLogs'):
        """
        :param 'ClusterLoggingInfoBrokerLogsArgs' broker_logs: Configuration block for Broker Logs settings for logging info. See below.
        """
        pulumi.set(__self__, "broker_logs", broker_logs)

    @property
    @pulumi.getter(name="brokerLogs")
    def broker_logs(self) -> 'outputs.ClusterLoggingInfoBrokerLogs':
        """
        Configuration block for Broker Logs settings for logging info. See below.
        """
        return pulumi.get(self, "broker_logs")


@pulumi.output_type
class ClusterLoggingInfoBrokerLogs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudwatchLogs":
            suggest = "cloudwatch_logs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterLoggingInfoBrokerLogs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterLoggingInfoBrokerLogs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterLoggingInfoBrokerLogs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloudwatch_logs: Optional['outputs.ClusterLoggingInfoBrokerLogsCloudwatchLogs'] = None,
                 firehose: Optional['outputs.ClusterLoggingInfoBrokerLogsFirehose'] = None,
                 s3: Optional['outputs.ClusterLoggingInfoBrokerLogsS3'] = None):
        if cloudwatch_logs is not None:
            pulumi.set(__self__, "cloudwatch_logs", cloudwatch_logs)
        if firehose is not None:
            pulumi.set(__self__, "firehose", firehose)
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)

    @property
    @pulumi.getter(name="cloudwatchLogs")
    def cloudwatch_logs(self) -> Optional['outputs.ClusterLoggingInfoBrokerLogsCloudwatchLogs']:
        return pulumi.get(self, "cloudwatch_logs")

    @property
    @pulumi.getter
    def firehose(self) -> Optional['outputs.ClusterLoggingInfoBrokerLogsFirehose']:
        return pulumi.get(self, "firehose")

    @property
    @pulumi.getter
    def s3(self) -> Optional['outputs.ClusterLoggingInfoBrokerLogsS3']:
        return pulumi.get(self, "s3")


@pulumi.output_type
class ClusterLoggingInfoBrokerLogsCloudwatchLogs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logGroup":
            suggest = "log_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterLoggingInfoBrokerLogsCloudwatchLogs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterLoggingInfoBrokerLogsCloudwatchLogs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterLoggingInfoBrokerLogsCloudwatchLogs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 log_group: Optional[str] = None):
        """
        :param bool enabled: Controls whether provisioned throughput is enabled or not. Default value: `false`.
        :param str log_group: Name of the Cloudwatch Log Group to deliver logs to.
        """
        pulumi.set(__self__, "enabled", enabled)
        if log_group is not None:
            pulumi.set(__self__, "log_group", log_group)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Controls whether provisioned throughput is enabled or not. Default value: `false`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="logGroup")
    def log_group(self) -> Optional[str]:
        """
        Name of the Cloudwatch Log Group to deliver logs to.
        """
        return pulumi.get(self, "log_group")


@pulumi.output_type
class ClusterLoggingInfoBrokerLogsFirehose(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deliveryStream":
            suggest = "delivery_stream"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterLoggingInfoBrokerLogsFirehose. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterLoggingInfoBrokerLogsFirehose.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterLoggingInfoBrokerLogsFirehose.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 delivery_stream: Optional[str] = None):
        """
        :param bool enabled: Controls whether provisioned throughput is enabled or not. Default value: `false`.
        :param str delivery_stream: Name of the Kinesis Data Firehose delivery stream to deliver logs to.
        """
        pulumi.set(__self__, "enabled", enabled)
        if delivery_stream is not None:
            pulumi.set(__self__, "delivery_stream", delivery_stream)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Controls whether provisioned throughput is enabled or not. Default value: `false`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="deliveryStream")
    def delivery_stream(self) -> Optional[str]:
        """
        Name of the Kinesis Data Firehose delivery stream to deliver logs to.
        """
        return pulumi.get(self, "delivery_stream")


@pulumi.output_type
class ClusterLoggingInfoBrokerLogsS3(dict):
    def __init__(__self__, *,
                 enabled: bool,
                 bucket: Optional[str] = None,
                 prefix: Optional[str] = None):
        """
        :param bool enabled: Controls whether provisioned throughput is enabled or not. Default value: `false`.
        :param str bucket: Name of the S3 bucket to deliver logs to.
        :param str prefix: Prefix to append to the folder name.
        """
        pulumi.set(__self__, "enabled", enabled)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Controls whether provisioned throughput is enabled or not. Default value: `false`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def bucket(self) -> Optional[str]:
        """
        Name of the S3 bucket to deliver logs to.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        Prefix to append to the folder name.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class ClusterOpenMonitoring(dict):
    def __init__(__self__, *,
                 prometheus: 'outputs.ClusterOpenMonitoringPrometheus'):
        """
        :param 'ClusterOpenMonitoringPrometheusArgs' prometheus: Configuration block for Prometheus settings for open monitoring. See below.
        """
        pulumi.set(__self__, "prometheus", prometheus)

    @property
    @pulumi.getter
    def prometheus(self) -> 'outputs.ClusterOpenMonitoringPrometheus':
        """
        Configuration block for Prometheus settings for open monitoring. See below.
        """
        return pulumi.get(self, "prometheus")


@pulumi.output_type
class ClusterOpenMonitoringPrometheus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jmxExporter":
            suggest = "jmx_exporter"
        elif key == "nodeExporter":
            suggest = "node_exporter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterOpenMonitoringPrometheus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterOpenMonitoringPrometheus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterOpenMonitoringPrometheus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 jmx_exporter: Optional['outputs.ClusterOpenMonitoringPrometheusJmxExporter'] = None,
                 node_exporter: Optional['outputs.ClusterOpenMonitoringPrometheusNodeExporter'] = None):
        """
        :param 'ClusterOpenMonitoringPrometheusJmxExporterArgs' jmx_exporter: Configuration block for JMX Exporter. See below.
        :param 'ClusterOpenMonitoringPrometheusNodeExporterArgs' node_exporter: Configuration block for Node Exporter. See below.
        """
        if jmx_exporter is not None:
            pulumi.set(__self__, "jmx_exporter", jmx_exporter)
        if node_exporter is not None:
            pulumi.set(__self__, "node_exporter", node_exporter)

    @property
    @pulumi.getter(name="jmxExporter")
    def jmx_exporter(self) -> Optional['outputs.ClusterOpenMonitoringPrometheusJmxExporter']:
        """
        Configuration block for JMX Exporter. See below.
        """
        return pulumi.get(self, "jmx_exporter")

    @property
    @pulumi.getter(name="nodeExporter")
    def node_exporter(self) -> Optional['outputs.ClusterOpenMonitoringPrometheusNodeExporter']:
        """
        Configuration block for Node Exporter. See below.
        """
        return pulumi.get(self, "node_exporter")


@pulumi.output_type
class ClusterOpenMonitoringPrometheusJmxExporter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enabledInBroker":
            suggest = "enabled_in_broker"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterOpenMonitoringPrometheusJmxExporter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterOpenMonitoringPrometheusJmxExporter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterOpenMonitoringPrometheusJmxExporter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled_in_broker: bool):
        """
        :param bool enabled_in_broker: Indicates whether you want to enable or disable the JMX Exporter.
        """
        pulumi.set(__self__, "enabled_in_broker", enabled_in_broker)

    @property
    @pulumi.getter(name="enabledInBroker")
    def enabled_in_broker(self) -> bool:
        """
        Indicates whether you want to enable or disable the JMX Exporter.
        """
        return pulumi.get(self, "enabled_in_broker")


@pulumi.output_type
class ClusterOpenMonitoringPrometheusNodeExporter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enabledInBroker":
            suggest = "enabled_in_broker"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterOpenMonitoringPrometheusNodeExporter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterOpenMonitoringPrometheusNodeExporter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterOpenMonitoringPrometheusNodeExporter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled_in_broker: bool):
        """
        :param bool enabled_in_broker: Indicates whether you want to enable or disable the JMX Exporter.
        """
        pulumi.set(__self__, "enabled_in_broker", enabled_in_broker)

    @property
    @pulumi.getter(name="enabledInBroker")
    def enabled_in_broker(self) -> bool:
        """
        Indicates whether you want to enable or disable the JMX Exporter.
        """
        return pulumi.get(self, "enabled_in_broker")


@pulumi.output_type
class ServerlessClusterClientAuthentication(dict):
    def __init__(__self__, *,
                 sasl: 'outputs.ServerlessClusterClientAuthenticationSasl'):
        """
        :param 'ServerlessClusterClientAuthenticationSaslArgs' sasl: Details for client authentication using SASL. See below.
        """
        pulumi.set(__self__, "sasl", sasl)

    @property
    @pulumi.getter
    def sasl(self) -> 'outputs.ServerlessClusterClientAuthenticationSasl':
        """
        Details for client authentication using SASL. See below.
        """
        return pulumi.get(self, "sasl")


@pulumi.output_type
class ServerlessClusterClientAuthenticationSasl(dict):
    def __init__(__self__, *,
                 iam: 'outputs.ServerlessClusterClientAuthenticationSaslIam'):
        """
        :param 'ServerlessClusterClientAuthenticationSaslIamArgs' iam: Details for client authentication using IAM. See below.
        """
        pulumi.set(__self__, "iam", iam)

    @property
    @pulumi.getter
    def iam(self) -> 'outputs.ServerlessClusterClientAuthenticationSaslIam':
        """
        Details for client authentication using IAM. See below.
        """
        return pulumi.get(self, "iam")


@pulumi.output_type
class ServerlessClusterClientAuthenticationSaslIam(dict):
    def __init__(__self__, *,
                 enabled: bool):
        """
        :param bool enabled: Whether SASL/IAM authentication is enabled or not.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether SASL/IAM authentication is enabled or not.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ServerlessClusterVpcConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetIds":
            suggest = "subnet_ids"
        elif key == "securityGroupIds":
            suggest = "security_group_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerlessClusterVpcConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerlessClusterVpcConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerlessClusterVpcConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_ids: Sequence[str],
                 security_group_ids: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] subnet_ids: A list of subnets in at least two different Availability Zones that host your client applications.
        :param Sequence[str] security_group_ids: Specifies up to five security groups that control inbound and outbound traffic for the serverless cluster.
        """
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[str]:
        """
        A list of subnets in at least two different Availability Zones that host your client applications.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[Sequence[str]]:
        """
        Specifies up to five security groups that control inbound and outbound traffic for the serverless cluster.
        """
        return pulumi.get(self, "security_group_ids")


@pulumi.output_type
class GetBrokerNodesNodeInfoListResult(dict):
    def __init__(__self__, *,
                 attached_eni_id: str,
                 broker_id: float,
                 client_subnet: str,
                 client_vpc_ip_address: str,
                 endpoints: Sequence[str],
                 node_arn: str):
        """
        :param str attached_eni_id: Attached elastic network interface of the broker
        :param float broker_id: ID of the broker
        :param str client_subnet: Client subnet to which this broker node belongs
        :param str client_vpc_ip_address: The client virtual private cloud (VPC) IP address
        :param Sequence[str] endpoints: Set of endpoints for accessing the broker. This does not include ports
        :param str node_arn: ARN of the node
        """
        pulumi.set(__self__, "attached_eni_id", attached_eni_id)
        pulumi.set(__self__, "broker_id", broker_id)
        pulumi.set(__self__, "client_subnet", client_subnet)
        pulumi.set(__self__, "client_vpc_ip_address", client_vpc_ip_address)
        pulumi.set(__self__, "endpoints", endpoints)
        pulumi.set(__self__, "node_arn", node_arn)

    @property
    @pulumi.getter(name="attachedEniId")
    def attached_eni_id(self) -> str:
        """
        Attached elastic network interface of the broker
        """
        return pulumi.get(self, "attached_eni_id")

    @property
    @pulumi.getter(name="brokerId")
    def broker_id(self) -> float:
        """
        ID of the broker
        """
        return pulumi.get(self, "broker_id")

    @property
    @pulumi.getter(name="clientSubnet")
    def client_subnet(self) -> str:
        """
        Client subnet to which this broker node belongs
        """
        return pulumi.get(self, "client_subnet")

    @property
    @pulumi.getter(name="clientVpcIpAddress")
    def client_vpc_ip_address(self) -> str:
        """
        The client virtual private cloud (VPC) IP address
        """
        return pulumi.get(self, "client_vpc_ip_address")

    @property
    @pulumi.getter
    def endpoints(self) -> Sequence[str]:
        """
        Set of endpoints for accessing the broker. This does not include ports
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter(name="nodeArn")
    def node_arn(self) -> str:
        """
        ARN of the node
        """
        return pulumi.get(self, "node_arn")


