# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ConnectorCapacityArgs',
    'ConnectorCapacityAutoscalingArgs',
    'ConnectorCapacityAutoscalingScaleInPolicyArgs',
    'ConnectorCapacityAutoscalingScaleOutPolicyArgs',
    'ConnectorCapacityProvisionedCapacityArgs',
    'ConnectorKafkaClusterArgs',
    'ConnectorKafkaClusterApacheKafkaClusterArgs',
    'ConnectorKafkaClusterApacheKafkaClusterVpcArgs',
    'ConnectorKafkaClusterClientAuthenticationArgs',
    'ConnectorKafkaClusterEncryptionInTransitArgs',
    'ConnectorLogDeliveryArgs',
    'ConnectorLogDeliveryWorkerLogDeliveryArgs',
    'ConnectorLogDeliveryWorkerLogDeliveryCloudwatchLogsArgs',
    'ConnectorLogDeliveryWorkerLogDeliveryFirehoseArgs',
    'ConnectorLogDeliveryWorkerLogDeliveryS3Args',
    'ConnectorPluginArgs',
    'ConnectorPluginCustomPluginArgs',
    'ConnectorWorkerConfigurationArgs',
    'CustomPluginLocationArgs',
    'CustomPluginLocationS3Args',
]

@pulumi.input_type
class ConnectorCapacityArgs:
    def __init__(__self__, *,
                 autoscaling: Optional[pulumi.Input['ConnectorCapacityAutoscalingArgs']] = None,
                 provisioned_capacity: Optional[pulumi.Input['ConnectorCapacityProvisionedCapacityArgs']] = None):
        """
        :param pulumi.Input['ConnectorCapacityAutoscalingArgs'] autoscaling: Information about the auto scaling parameters for the connector. See below.
        :param pulumi.Input['ConnectorCapacityProvisionedCapacityArgs'] provisioned_capacity: Details about a fixed capacity allocated to a connector. See below.
        """
        if autoscaling is not None:
            pulumi.set(__self__, "autoscaling", autoscaling)
        if provisioned_capacity is not None:
            pulumi.set(__self__, "provisioned_capacity", provisioned_capacity)

    @property
    @pulumi.getter
    def autoscaling(self) -> Optional[pulumi.Input['ConnectorCapacityAutoscalingArgs']]:
        """
        Information about the auto scaling parameters for the connector. See below.
        """
        return pulumi.get(self, "autoscaling")

    @autoscaling.setter
    def autoscaling(self, value: Optional[pulumi.Input['ConnectorCapacityAutoscalingArgs']]):
        pulumi.set(self, "autoscaling", value)

    @property
    @pulumi.getter(name="provisionedCapacity")
    def provisioned_capacity(self) -> Optional[pulumi.Input['ConnectorCapacityProvisionedCapacityArgs']]:
        """
        Details about a fixed capacity allocated to a connector. See below.
        """
        return pulumi.get(self, "provisioned_capacity")

    @provisioned_capacity.setter
    def provisioned_capacity(self, value: Optional[pulumi.Input['ConnectorCapacityProvisionedCapacityArgs']]):
        pulumi.set(self, "provisioned_capacity", value)


@pulumi.input_type
class ConnectorCapacityAutoscalingArgs:
    def __init__(__self__, *,
                 max_worker_count: pulumi.Input[int],
                 min_worker_count: pulumi.Input[int],
                 mcu_count: Optional[pulumi.Input[int]] = None,
                 scale_in_policy: Optional[pulumi.Input['ConnectorCapacityAutoscalingScaleInPolicyArgs']] = None,
                 scale_out_policy: Optional[pulumi.Input['ConnectorCapacityAutoscalingScaleOutPolicyArgs']] = None):
        """
        :param pulumi.Input[int] max_worker_count: The maximum number of workers allocated to the connector.
        :param pulumi.Input[int] min_worker_count: The minimum number of workers allocated to the connector.
        :param pulumi.Input[int] mcu_count: The number of microcontroller units (MCUs) allocated to each connector worker. Valid values: `1`, `2`, `4`, `8`. The default value is `1`.
        :param pulumi.Input['ConnectorCapacityAutoscalingScaleInPolicyArgs'] scale_in_policy: The scale-in policy for the connector. See below.
        :param pulumi.Input['ConnectorCapacityAutoscalingScaleOutPolicyArgs'] scale_out_policy: The scale-out policy for the connector. See below.
        """
        pulumi.set(__self__, "max_worker_count", max_worker_count)
        pulumi.set(__self__, "min_worker_count", min_worker_count)
        if mcu_count is not None:
            pulumi.set(__self__, "mcu_count", mcu_count)
        if scale_in_policy is not None:
            pulumi.set(__self__, "scale_in_policy", scale_in_policy)
        if scale_out_policy is not None:
            pulumi.set(__self__, "scale_out_policy", scale_out_policy)

    @property
    @pulumi.getter(name="maxWorkerCount")
    def max_worker_count(self) -> pulumi.Input[int]:
        """
        The maximum number of workers allocated to the connector.
        """
        return pulumi.get(self, "max_worker_count")

    @max_worker_count.setter
    def max_worker_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_worker_count", value)

    @property
    @pulumi.getter(name="minWorkerCount")
    def min_worker_count(self) -> pulumi.Input[int]:
        """
        The minimum number of workers allocated to the connector.
        """
        return pulumi.get(self, "min_worker_count")

    @min_worker_count.setter
    def min_worker_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "min_worker_count", value)

    @property
    @pulumi.getter(name="mcuCount")
    def mcu_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of microcontroller units (MCUs) allocated to each connector worker. Valid values: `1`, `2`, `4`, `8`. The default value is `1`.
        """
        return pulumi.get(self, "mcu_count")

    @mcu_count.setter
    def mcu_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "mcu_count", value)

    @property
    @pulumi.getter(name="scaleInPolicy")
    def scale_in_policy(self) -> Optional[pulumi.Input['ConnectorCapacityAutoscalingScaleInPolicyArgs']]:
        """
        The scale-in policy for the connector. See below.
        """
        return pulumi.get(self, "scale_in_policy")

    @scale_in_policy.setter
    def scale_in_policy(self, value: Optional[pulumi.Input['ConnectorCapacityAutoscalingScaleInPolicyArgs']]):
        pulumi.set(self, "scale_in_policy", value)

    @property
    @pulumi.getter(name="scaleOutPolicy")
    def scale_out_policy(self) -> Optional[pulumi.Input['ConnectorCapacityAutoscalingScaleOutPolicyArgs']]:
        """
        The scale-out policy for the connector. See below.
        """
        return pulumi.get(self, "scale_out_policy")

    @scale_out_policy.setter
    def scale_out_policy(self, value: Optional[pulumi.Input['ConnectorCapacityAutoscalingScaleOutPolicyArgs']]):
        pulumi.set(self, "scale_out_policy", value)


@pulumi.input_type
class ConnectorCapacityAutoscalingScaleInPolicyArgs:
    def __init__(__self__, *,
                 cpu_utilization_percentage: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] cpu_utilization_percentage: Specifies the CPU utilization percentage threshold at which you want connector scale in to be triggered.
        """
        if cpu_utilization_percentage is not None:
            pulumi.set(__self__, "cpu_utilization_percentage", cpu_utilization_percentage)

    @property
    @pulumi.getter(name="cpuUtilizationPercentage")
    def cpu_utilization_percentage(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the CPU utilization percentage threshold at which you want connector scale in to be triggered.
        """
        return pulumi.get(self, "cpu_utilization_percentage")

    @cpu_utilization_percentage.setter
    def cpu_utilization_percentage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu_utilization_percentage", value)


@pulumi.input_type
class ConnectorCapacityAutoscalingScaleOutPolicyArgs:
    def __init__(__self__, *,
                 cpu_utilization_percentage: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] cpu_utilization_percentage: The CPU utilization percentage threshold at which you want connector scale out to be triggered.
        """
        if cpu_utilization_percentage is not None:
            pulumi.set(__self__, "cpu_utilization_percentage", cpu_utilization_percentage)

    @property
    @pulumi.getter(name="cpuUtilizationPercentage")
    def cpu_utilization_percentage(self) -> Optional[pulumi.Input[int]]:
        """
        The CPU utilization percentage threshold at which you want connector scale out to be triggered.
        """
        return pulumi.get(self, "cpu_utilization_percentage")

    @cpu_utilization_percentage.setter
    def cpu_utilization_percentage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu_utilization_percentage", value)


@pulumi.input_type
class ConnectorCapacityProvisionedCapacityArgs:
    def __init__(__self__, *,
                 worker_count: pulumi.Input[int],
                 mcu_count: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] worker_count: The number of workers that are allocated to the connector.
        :param pulumi.Input[int] mcu_count: The number of microcontroller units (MCUs) allocated to each connector worker. Valid values: `1`, `2`, `4`, `8`. The default value is `1`.
        """
        pulumi.set(__self__, "worker_count", worker_count)
        if mcu_count is not None:
            pulumi.set(__self__, "mcu_count", mcu_count)

    @property
    @pulumi.getter(name="workerCount")
    def worker_count(self) -> pulumi.Input[int]:
        """
        The number of workers that are allocated to the connector.
        """
        return pulumi.get(self, "worker_count")

    @worker_count.setter
    def worker_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "worker_count", value)

    @property
    @pulumi.getter(name="mcuCount")
    def mcu_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of microcontroller units (MCUs) allocated to each connector worker. Valid values: `1`, `2`, `4`, `8`. The default value is `1`.
        """
        return pulumi.get(self, "mcu_count")

    @mcu_count.setter
    def mcu_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "mcu_count", value)


@pulumi.input_type
class ConnectorKafkaClusterArgs:
    def __init__(__self__, *,
                 apache_kafka_cluster: pulumi.Input['ConnectorKafkaClusterApacheKafkaClusterArgs']):
        """
        :param pulumi.Input['ConnectorKafkaClusterApacheKafkaClusterArgs'] apache_kafka_cluster: The Apache Kafka cluster to which the connector is connected.
        """
        pulumi.set(__self__, "apache_kafka_cluster", apache_kafka_cluster)

    @property
    @pulumi.getter(name="apacheKafkaCluster")
    def apache_kafka_cluster(self) -> pulumi.Input['ConnectorKafkaClusterApacheKafkaClusterArgs']:
        """
        The Apache Kafka cluster to which the connector is connected.
        """
        return pulumi.get(self, "apache_kafka_cluster")

    @apache_kafka_cluster.setter
    def apache_kafka_cluster(self, value: pulumi.Input['ConnectorKafkaClusterApacheKafkaClusterArgs']):
        pulumi.set(self, "apache_kafka_cluster", value)


@pulumi.input_type
class ConnectorKafkaClusterApacheKafkaClusterArgs:
    def __init__(__self__, *,
                 bootstrap_servers: pulumi.Input[str],
                 vpc: pulumi.Input['ConnectorKafkaClusterApacheKafkaClusterVpcArgs']):
        """
        :param pulumi.Input[str] bootstrap_servers: The bootstrap servers of the cluster.
        :param pulumi.Input['ConnectorKafkaClusterApacheKafkaClusterVpcArgs'] vpc: Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster.
        """
        pulumi.set(__self__, "bootstrap_servers", bootstrap_servers)
        pulumi.set(__self__, "vpc", vpc)

    @property
    @pulumi.getter(name="bootstrapServers")
    def bootstrap_servers(self) -> pulumi.Input[str]:
        """
        The bootstrap servers of the cluster.
        """
        return pulumi.get(self, "bootstrap_servers")

    @bootstrap_servers.setter
    def bootstrap_servers(self, value: pulumi.Input[str]):
        pulumi.set(self, "bootstrap_servers", value)

    @property
    @pulumi.getter
    def vpc(self) -> pulumi.Input['ConnectorKafkaClusterApacheKafkaClusterVpcArgs']:
        """
        Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster.
        """
        return pulumi.get(self, "vpc")

    @vpc.setter
    def vpc(self, value: pulumi.Input['ConnectorKafkaClusterApacheKafkaClusterVpcArgs']):
        pulumi.set(self, "vpc", value)


@pulumi.input_type
class ConnectorKafkaClusterApacheKafkaClusterVpcArgs:
    def __init__(__self__, *,
                 security_groups: pulumi.Input[Sequence[pulumi.Input[str]]],
                 subnets: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: The security groups for the connector.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnets: The subnets for the connector.
        """
        pulumi.set(__self__, "security_groups", security_groups)
        pulumi.set(__self__, "subnets", subnets)

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The security groups for the connector.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "security_groups", value)

    @property
    @pulumi.getter
    def subnets(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The subnets for the connector.
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "subnets", value)


@pulumi.input_type
class ConnectorKafkaClusterClientAuthenticationArgs:
    def __init__(__self__, *,
                 authentication_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] authentication_type: The type of client authentication used to connect to the Apache Kafka cluster. Valid values: `IAM`, `NONE`. A value of `NONE` means that no client authentication is used. The default value is `NONE`.
        """
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of client authentication used to connect to the Apache Kafka cluster. Valid values: `IAM`, `NONE`. A value of `NONE` means that no client authentication is used. The default value is `NONE`.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authentication_type", value)


@pulumi.input_type
class ConnectorKafkaClusterEncryptionInTransitArgs:
    def __init__(__self__, *,
                 encryption_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] encryption_type: The type of encryption in transit to the Apache Kafka cluster. Valid values: `PLAINTEXT`, `TLS`. The default values is `PLAINTEXT`.
        """
        if encryption_type is not None:
            pulumi.set(__self__, "encryption_type", encryption_type)

    @property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of encryption in transit to the Apache Kafka cluster. Valid values: `PLAINTEXT`, `TLS`. The default values is `PLAINTEXT`.
        """
        return pulumi.get(self, "encryption_type")

    @encryption_type.setter
    def encryption_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_type", value)


@pulumi.input_type
class ConnectorLogDeliveryArgs:
    def __init__(__self__, *,
                 worker_log_delivery: pulumi.Input['ConnectorLogDeliveryWorkerLogDeliveryArgs']):
        """
        :param pulumi.Input['ConnectorLogDeliveryWorkerLogDeliveryArgs'] worker_log_delivery: The workers can send worker logs to different destination types. This configuration specifies the details of these destinations. See below.
        """
        pulumi.set(__self__, "worker_log_delivery", worker_log_delivery)

    @property
    @pulumi.getter(name="workerLogDelivery")
    def worker_log_delivery(self) -> pulumi.Input['ConnectorLogDeliveryWorkerLogDeliveryArgs']:
        """
        The workers can send worker logs to different destination types. This configuration specifies the details of these destinations. See below.
        """
        return pulumi.get(self, "worker_log_delivery")

    @worker_log_delivery.setter
    def worker_log_delivery(self, value: pulumi.Input['ConnectorLogDeliveryWorkerLogDeliveryArgs']):
        pulumi.set(self, "worker_log_delivery", value)


@pulumi.input_type
class ConnectorLogDeliveryWorkerLogDeliveryArgs:
    def __init__(__self__, *,
                 cloudwatch_logs: Optional[pulumi.Input['ConnectorLogDeliveryWorkerLogDeliveryCloudwatchLogsArgs']] = None,
                 firehose: Optional[pulumi.Input['ConnectorLogDeliveryWorkerLogDeliveryFirehoseArgs']] = None,
                 s3: Optional[pulumi.Input['ConnectorLogDeliveryWorkerLogDeliveryS3Args']] = None):
        """
        :param pulumi.Input['ConnectorLogDeliveryWorkerLogDeliveryCloudwatchLogsArgs'] cloudwatch_logs: Details about delivering logs to Amazon CloudWatch Logs. See below.
        :param pulumi.Input['ConnectorLogDeliveryWorkerLogDeliveryFirehoseArgs'] firehose: Details about delivering logs to Amazon Kinesis Data Firehose. See below.
        :param pulumi.Input['ConnectorLogDeliveryWorkerLogDeliveryS3Args'] s3: Details about delivering logs to Amazon S3. See below.
        """
        if cloudwatch_logs is not None:
            pulumi.set(__self__, "cloudwatch_logs", cloudwatch_logs)
        if firehose is not None:
            pulumi.set(__self__, "firehose", firehose)
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)

    @property
    @pulumi.getter(name="cloudwatchLogs")
    def cloudwatch_logs(self) -> Optional[pulumi.Input['ConnectorLogDeliveryWorkerLogDeliveryCloudwatchLogsArgs']]:
        """
        Details about delivering logs to Amazon CloudWatch Logs. See below.
        """
        return pulumi.get(self, "cloudwatch_logs")

    @cloudwatch_logs.setter
    def cloudwatch_logs(self, value: Optional[pulumi.Input['ConnectorLogDeliveryWorkerLogDeliveryCloudwatchLogsArgs']]):
        pulumi.set(self, "cloudwatch_logs", value)

    @property
    @pulumi.getter
    def firehose(self) -> Optional[pulumi.Input['ConnectorLogDeliveryWorkerLogDeliveryFirehoseArgs']]:
        """
        Details about delivering logs to Amazon Kinesis Data Firehose. See below.
        """
        return pulumi.get(self, "firehose")

    @firehose.setter
    def firehose(self, value: Optional[pulumi.Input['ConnectorLogDeliveryWorkerLogDeliveryFirehoseArgs']]):
        pulumi.set(self, "firehose", value)

    @property
    @pulumi.getter
    def s3(self) -> Optional[pulumi.Input['ConnectorLogDeliveryWorkerLogDeliveryS3Args']]:
        """
        Details about delivering logs to Amazon S3. See below.
        """
        return pulumi.get(self, "s3")

    @s3.setter
    def s3(self, value: Optional[pulumi.Input['ConnectorLogDeliveryWorkerLogDeliveryS3Args']]):
        pulumi.set(self, "s3", value)


@pulumi.input_type
class ConnectorLogDeliveryWorkerLogDeliveryCloudwatchLogsArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 log_group: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] enabled: Whether log delivery to Amazon CloudWatch Logs is enabled.
        :param pulumi.Input[str] log_group: The name of the CloudWatch log group that is the destination for log delivery.
        """
        pulumi.set(__self__, "enabled", enabled)
        if log_group is not None:
            pulumi.set(__self__, "log_group", log_group)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Whether log delivery to Amazon CloudWatch Logs is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="logGroup")
    def log_group(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the CloudWatch log group that is the destination for log delivery.
        """
        return pulumi.get(self, "log_group")

    @log_group.setter
    def log_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_group", value)


@pulumi.input_type
class ConnectorLogDeliveryWorkerLogDeliveryFirehoseArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 delivery_stream: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] enabled: Specifies whether connector logs get delivered to Amazon Kinesis Data Firehose.
        :param pulumi.Input[str] delivery_stream: The name of the Kinesis Data Firehose delivery stream that is the destination for log delivery.
        """
        pulumi.set(__self__, "enabled", enabled)
        if delivery_stream is not None:
            pulumi.set(__self__, "delivery_stream", delivery_stream)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Specifies whether connector logs get delivered to Amazon Kinesis Data Firehose.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="deliveryStream")
    def delivery_stream(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Kinesis Data Firehose delivery stream that is the destination for log delivery.
        """
        return pulumi.get(self, "delivery_stream")

    @delivery_stream.setter
    def delivery_stream(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delivery_stream", value)


@pulumi.input_type
class ConnectorLogDeliveryWorkerLogDeliveryS3Args:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 bucket: Optional[pulumi.Input[str]] = None,
                 prefix: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] enabled: Whether log delivery to Amazon CloudWatch Logs is enabled.
        :param pulumi.Input[str] bucket: The name of the S3 bucket that is the destination for log delivery.
        :param pulumi.Input[str] prefix: The S3 prefix that is the destination for log delivery.
        """
        pulumi.set(__self__, "enabled", enabled)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Whether log delivery to Amazon CloudWatch Logs is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the S3 bucket that is the destination for log delivery.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The S3 prefix that is the destination for log delivery.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix", value)


@pulumi.input_type
class ConnectorPluginArgs:
    def __init__(__self__, *,
                 custom_plugin: pulumi.Input['ConnectorPluginCustomPluginArgs']):
        """
        :param pulumi.Input['ConnectorPluginCustomPluginArgs'] custom_plugin: Details about a custom plugin. See below.
        """
        pulumi.set(__self__, "custom_plugin", custom_plugin)

    @property
    @pulumi.getter(name="customPlugin")
    def custom_plugin(self) -> pulumi.Input['ConnectorPluginCustomPluginArgs']:
        """
        Details about a custom plugin. See below.
        """
        return pulumi.get(self, "custom_plugin")

    @custom_plugin.setter
    def custom_plugin(self, value: pulumi.Input['ConnectorPluginCustomPluginArgs']):
        pulumi.set(self, "custom_plugin", value)


@pulumi.input_type
class ConnectorPluginCustomPluginArgs:
    def __init__(__self__, *,
                 arn: pulumi.Input[str],
                 revision: pulumi.Input[int]):
        """
        :param pulumi.Input[str] arn: The Amazon Resource Name (ARN) of the custom plugin.
        :param pulumi.Input[int] revision: The revision of the custom plugin.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "revision", revision)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) of the custom plugin.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def revision(self) -> pulumi.Input[int]:
        """
        The revision of the custom plugin.
        """
        return pulumi.get(self, "revision")

    @revision.setter
    def revision(self, value: pulumi.Input[int]):
        pulumi.set(self, "revision", value)


@pulumi.input_type
class ConnectorWorkerConfigurationArgs:
    def __init__(__self__, *,
                 arn: pulumi.Input[str],
                 revision: pulumi.Input[int]):
        """
        :param pulumi.Input[str] arn: The Amazon Resource Name (ARN) of the worker configuration.
        :param pulumi.Input[int] revision: The revision of the worker configuration.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "revision", revision)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) of the worker configuration.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def revision(self) -> pulumi.Input[int]:
        """
        The revision of the worker configuration.
        """
        return pulumi.get(self, "revision")

    @revision.setter
    def revision(self, value: pulumi.Input[int]):
        pulumi.set(self, "revision", value)


@pulumi.input_type
class CustomPluginLocationArgs:
    def __init__(__self__, *,
                 s3: pulumi.Input['CustomPluginLocationS3Args']):
        """
        :param pulumi.Input['CustomPluginLocationS3Args'] s3: Information of the plugin file stored in Amazon S3. See below.
        """
        pulumi.set(__self__, "s3", s3)

    @property
    @pulumi.getter
    def s3(self) -> pulumi.Input['CustomPluginLocationS3Args']:
        """
        Information of the plugin file stored in Amazon S3. See below.
        """
        return pulumi.get(self, "s3")

    @s3.setter
    def s3(self, value: pulumi.Input['CustomPluginLocationS3Args']):
        pulumi.set(self, "s3", value)


@pulumi.input_type
class CustomPluginLocationS3Args:
    def __init__(__self__, *,
                 bucket_arn: pulumi.Input[str],
                 file_key: pulumi.Input[str],
                 object_version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket_arn: The Amazon Resource Name (ARN) of an S3 bucket.
        :param pulumi.Input[str] file_key: The file key for an object in an S3 bucket.
        :param pulumi.Input[str] object_version: The version of an object in an S3 bucket.
        """
        pulumi.set(__self__, "bucket_arn", bucket_arn)
        pulumi.set(__self__, "file_key", file_key)
        if object_version is not None:
            pulumi.set(__self__, "object_version", object_version)

    @property
    @pulumi.getter(name="bucketArn")
    def bucket_arn(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) of an S3 bucket.
        """
        return pulumi.get(self, "bucket_arn")

    @bucket_arn.setter
    def bucket_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket_arn", value)

    @property
    @pulumi.getter(name="fileKey")
    def file_key(self) -> pulumi.Input[str]:
        """
        The file key for an object in an S3 bucket.
        """
        return pulumi.get(self, "file_key")

    @file_key.setter
    def file_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "file_key", value)

    @property
    @pulumi.getter(name="objectVersion")
    def object_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of an object in an S3 bucket.
        """
        return pulumi.get(self, "object_version")

    @object_version.setter
    def object_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_version", value)


