# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LoggingConfigurationArgs', 'LoggingConfiguration']

@pulumi.input_type
class LoggingConfigurationArgs:
    def __init__(__self__, *,
                 firewall_arn: pulumi.Input[str],
                 logging_configuration: pulumi.Input['LoggingConfigurationLoggingConfigurationArgs']):
        """
        The set of arguments for constructing a LoggingConfiguration resource.
        :param pulumi.Input[str] firewall_arn: The Amazon Resource Name (ARN) of the Network Firewall firewall.
        :param pulumi.Input['LoggingConfigurationLoggingConfigurationArgs'] logging_configuration: A configuration block describing how AWS Network Firewall performs logging for a firewall. See Logging Configuration below for details.
        """
        pulumi.set(__self__, "firewall_arn", firewall_arn)
        pulumi.set(__self__, "logging_configuration", logging_configuration)

    @property
    @pulumi.getter(name="firewallArn")
    def firewall_arn(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) of the Network Firewall firewall.
        """
        return pulumi.get(self, "firewall_arn")

    @firewall_arn.setter
    def firewall_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "firewall_arn", value)

    @property
    @pulumi.getter(name="loggingConfiguration")
    def logging_configuration(self) -> pulumi.Input['LoggingConfigurationLoggingConfigurationArgs']:
        """
        A configuration block describing how AWS Network Firewall performs logging for a firewall. See Logging Configuration below for details.
        """
        return pulumi.get(self, "logging_configuration")

    @logging_configuration.setter
    def logging_configuration(self, value: pulumi.Input['LoggingConfigurationLoggingConfigurationArgs']):
        pulumi.set(self, "logging_configuration", value)


@pulumi.input_type
class _LoggingConfigurationState:
    def __init__(__self__, *,
                 firewall_arn: Optional[pulumi.Input[str]] = None,
                 logging_configuration: Optional[pulumi.Input['LoggingConfigurationLoggingConfigurationArgs']] = None):
        """
        Input properties used for looking up and filtering LoggingConfiguration resources.
        :param pulumi.Input[str] firewall_arn: The Amazon Resource Name (ARN) of the Network Firewall firewall.
        :param pulumi.Input['LoggingConfigurationLoggingConfigurationArgs'] logging_configuration: A configuration block describing how AWS Network Firewall performs logging for a firewall. See Logging Configuration below for details.
        """
        if firewall_arn is not None:
            pulumi.set(__self__, "firewall_arn", firewall_arn)
        if logging_configuration is not None:
            pulumi.set(__self__, "logging_configuration", logging_configuration)

    @property
    @pulumi.getter(name="firewallArn")
    def firewall_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the Network Firewall firewall.
        """
        return pulumi.get(self, "firewall_arn")

    @firewall_arn.setter
    def firewall_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "firewall_arn", value)

    @property
    @pulumi.getter(name="loggingConfiguration")
    def logging_configuration(self) -> Optional[pulumi.Input['LoggingConfigurationLoggingConfigurationArgs']]:
        """
        A configuration block describing how AWS Network Firewall performs logging for a firewall. See Logging Configuration below for details.
        """
        return pulumi.get(self, "logging_configuration")

    @logging_configuration.setter
    def logging_configuration(self, value: Optional[pulumi.Input['LoggingConfigurationLoggingConfigurationArgs']]):
        pulumi.set(self, "logging_configuration", value)


class LoggingConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 firewall_arn: Optional[pulumi.Input[str]] = None,
                 logging_configuration: Optional[pulumi.Input[pulumi.InputType['LoggingConfigurationLoggingConfigurationArgs']]] = None,
                 __props__=None):
        """
        Provides an AWS Network Firewall Logging Configuration Resource

        ## Example Usage
        ### Logging to S3

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkfirewall.LoggingConfiguration("example",
            firewall_arn=aws_networkfirewall_firewall["example"]["arn"],
            logging_configuration=aws.networkfirewall.LoggingConfigurationLoggingConfigurationArgs(
                log_destination_configs=[aws.networkfirewall.LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs(
                    log_destination={
                        "bucketName": aws_s3_bucket["example"]["bucket"],
                        "prefix": "/example",
                    },
                    log_destination_type="S3",
                    log_type="FLOW",
                )],
            ))
        ```
        ### Logging to CloudWatch

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkfirewall.LoggingConfiguration("example",
            firewall_arn=aws_networkfirewall_firewall["example"]["arn"],
            logging_configuration=aws.networkfirewall.LoggingConfigurationLoggingConfigurationArgs(
                log_destination_configs=[aws.networkfirewall.LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs(
                    log_destination={
                        "logGroup": aws_cloudwatch_log_group["example"]["name"],
                    },
                    log_destination_type="CloudWatchLogs",
                    log_type="ALERT",
                )],
            ))
        ```
        ### Logging to Kinesis Data Firehose

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkfirewall.LoggingConfiguration("example",
            firewall_arn=aws_networkfirewall_firewall["example"]["arn"],
            logging_configuration=aws.networkfirewall.LoggingConfigurationLoggingConfigurationArgs(
                log_destination_configs=[aws.networkfirewall.LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs(
                    log_destination={
                        "deliveryStream": aws_kinesis_firehose_delivery_stream["example"]["name"],
                    },
                    log_destination_type="KinesisDataFirehose",
                    log_type="ALERT",
                )],
            ))
        ```

        ## Import

        Using `pulumi import`, import Network Firewall Logging Configurations using the `firewall_arn`. For example:

        ```sh
         $ pulumi import aws:networkfirewall/loggingConfiguration:LoggingConfiguration example arn:aws:network-firewall:us-west-1:123456789012:firewall/example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] firewall_arn: The Amazon Resource Name (ARN) of the Network Firewall firewall.
        :param pulumi.Input[pulumi.InputType['LoggingConfigurationLoggingConfigurationArgs']] logging_configuration: A configuration block describing how AWS Network Firewall performs logging for a firewall. See Logging Configuration below for details.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoggingConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an AWS Network Firewall Logging Configuration Resource

        ## Example Usage
        ### Logging to S3

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkfirewall.LoggingConfiguration("example",
            firewall_arn=aws_networkfirewall_firewall["example"]["arn"],
            logging_configuration=aws.networkfirewall.LoggingConfigurationLoggingConfigurationArgs(
                log_destination_configs=[aws.networkfirewall.LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs(
                    log_destination={
                        "bucketName": aws_s3_bucket["example"]["bucket"],
                        "prefix": "/example",
                    },
                    log_destination_type="S3",
                    log_type="FLOW",
                )],
            ))
        ```
        ### Logging to CloudWatch

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkfirewall.LoggingConfiguration("example",
            firewall_arn=aws_networkfirewall_firewall["example"]["arn"],
            logging_configuration=aws.networkfirewall.LoggingConfigurationLoggingConfigurationArgs(
                log_destination_configs=[aws.networkfirewall.LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs(
                    log_destination={
                        "logGroup": aws_cloudwatch_log_group["example"]["name"],
                    },
                    log_destination_type="CloudWatchLogs",
                    log_type="ALERT",
                )],
            ))
        ```
        ### Logging to Kinesis Data Firehose

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkfirewall.LoggingConfiguration("example",
            firewall_arn=aws_networkfirewall_firewall["example"]["arn"],
            logging_configuration=aws.networkfirewall.LoggingConfigurationLoggingConfigurationArgs(
                log_destination_configs=[aws.networkfirewall.LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs(
                    log_destination={
                        "deliveryStream": aws_kinesis_firehose_delivery_stream["example"]["name"],
                    },
                    log_destination_type="KinesisDataFirehose",
                    log_type="ALERT",
                )],
            ))
        ```

        ## Import

        Using `pulumi import`, import Network Firewall Logging Configurations using the `firewall_arn`. For example:

        ```sh
         $ pulumi import aws:networkfirewall/loggingConfiguration:LoggingConfiguration example arn:aws:network-firewall:us-west-1:123456789012:firewall/example
        ```

        :param str resource_name: The name of the resource.
        :param LoggingConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoggingConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 firewall_arn: Optional[pulumi.Input[str]] = None,
                 logging_configuration: Optional[pulumi.Input[pulumi.InputType['LoggingConfigurationLoggingConfigurationArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoggingConfigurationArgs.__new__(LoggingConfigurationArgs)

            if firewall_arn is None and not opts.urn:
                raise TypeError("Missing required property 'firewall_arn'")
            __props__.__dict__["firewall_arn"] = firewall_arn
            if logging_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'logging_configuration'")
            __props__.__dict__["logging_configuration"] = logging_configuration
        super(LoggingConfiguration, __self__).__init__(
            'aws:networkfirewall/loggingConfiguration:LoggingConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            firewall_arn: Optional[pulumi.Input[str]] = None,
            logging_configuration: Optional[pulumi.Input[pulumi.InputType['LoggingConfigurationLoggingConfigurationArgs']]] = None) -> 'LoggingConfiguration':
        """
        Get an existing LoggingConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] firewall_arn: The Amazon Resource Name (ARN) of the Network Firewall firewall.
        :param pulumi.Input[pulumi.InputType['LoggingConfigurationLoggingConfigurationArgs']] logging_configuration: A configuration block describing how AWS Network Firewall performs logging for a firewall. See Logging Configuration below for details.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoggingConfigurationState.__new__(_LoggingConfigurationState)

        __props__.__dict__["firewall_arn"] = firewall_arn
        __props__.__dict__["logging_configuration"] = logging_configuration
        return LoggingConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="firewallArn")
    def firewall_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the Network Firewall firewall.
        """
        return pulumi.get(self, "firewall_arn")

    @property
    @pulumi.getter(name="loggingConfiguration")
    def logging_configuration(self) -> pulumi.Output['outputs.LoggingConfigurationLoggingConfiguration']:
        """
        A configuration block describing how AWS Network Firewall performs logging for a firewall. See Logging Configuration below for details.
        """
        return pulumi.get(self, "logging_configuration")

