# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CoreNetworkArgs', 'CoreNetwork']

@pulumi.input_type
class CoreNetworkArgs:
    def __init__(__self__, *,
                 global_network_id: pulumi.Input[str],
                 base_policy_region: Optional[pulumi.Input[str]] = None,
                 base_policy_regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 create_base_policy: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a CoreNetwork resource.
        :param pulumi.Input[str] global_network_id: The ID of the global network that a core network will be a part of.
        :param pulumi.Input[str] base_policy_region: The base policy created by setting the `create_base_policy` argument to `true` requires a region to be set in the `edge-locations`, `location` key. If `base_policy_region` is not specified, the region used in the base policy defaults to the region specified in the `provider` block.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] base_policy_regions: A list of regions to add to the base policy. The base policy created by setting the `create_base_policy` argument to `true` requires one or more regions to be set in the `edge-locations`, `location` key. If `base_policy_regions` is not specified, the region used in the base policy defaults to the region specified in the `provider` block.
        :param pulumi.Input[bool] create_base_policy: Specifies whether to create a base policy when a core network is created or updated. A base policy is created and set to `LIVE` to allow attachments to the core network (e.g. VPC Attachments) before applying a policy document provided using the `networkmanager.CoreNetworkPolicyAttachment` resource. This base policy is needed if your core network does not have any `LIVE` policies and your policy document has static routes pointing to VPC attachments and you want to attach your VPCs to the core network before applying the desired policy document. Valid values are `true` or `false`. An example of this Pulumi snippet can be found above for VPC Attachment in a single region and for VPC Attachment multi-region. An example base policy is shown below. This base policy is overridden with the policy that you specify in the `networkmanager.CoreNetworkPolicyAttachment` resource.
               
               ```python
               import pulumi
               ```
        :param pulumi.Input[str] description: Description of the Core Network.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value tags for the Core Network. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "global_network_id", global_network_id)
        if base_policy_region is not None:
            warnings.warn("""Use the base_policy_regions argument instead. This argument will be removed in the next major version of the provider.""", DeprecationWarning)
            pulumi.log.warn("""base_policy_region is deprecated: Use the base_policy_regions argument instead. This argument will be removed in the next major version of the provider.""")
        if base_policy_region is not None:
            pulumi.set(__self__, "base_policy_region", base_policy_region)
        if base_policy_regions is not None:
            pulumi.set(__self__, "base_policy_regions", base_policy_regions)
        if create_base_policy is not None:
            pulumi.set(__self__, "create_base_policy", create_base_policy)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="globalNetworkId")
    def global_network_id(self) -> pulumi.Input[str]:
        """
        The ID of the global network that a core network will be a part of.
        """
        return pulumi.get(self, "global_network_id")

    @global_network_id.setter
    def global_network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "global_network_id", value)

    @property
    @pulumi.getter(name="basePolicyRegion")
    def base_policy_region(self) -> Optional[pulumi.Input[str]]:
        """
        The base policy created by setting the `create_base_policy` argument to `true` requires a region to be set in the `edge-locations`, `location` key. If `base_policy_region` is not specified, the region used in the base policy defaults to the region specified in the `provider` block.
        """
        warnings.warn("""Use the base_policy_regions argument instead. This argument will be removed in the next major version of the provider.""", DeprecationWarning)
        pulumi.log.warn("""base_policy_region is deprecated: Use the base_policy_regions argument instead. This argument will be removed in the next major version of the provider.""")

        return pulumi.get(self, "base_policy_region")

    @base_policy_region.setter
    def base_policy_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_policy_region", value)

    @property
    @pulumi.getter(name="basePolicyRegions")
    def base_policy_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of regions to add to the base policy. The base policy created by setting the `create_base_policy` argument to `true` requires one or more regions to be set in the `edge-locations`, `location` key. If `base_policy_regions` is not specified, the region used in the base policy defaults to the region specified in the `provider` block.
        """
        return pulumi.get(self, "base_policy_regions")

    @base_policy_regions.setter
    def base_policy_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "base_policy_regions", value)

    @property
    @pulumi.getter(name="createBasePolicy")
    def create_base_policy(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to create a base policy when a core network is created or updated. A base policy is created and set to `LIVE` to allow attachments to the core network (e.g. VPC Attachments) before applying a policy document provided using the `networkmanager.CoreNetworkPolicyAttachment` resource. This base policy is needed if your core network does not have any `LIVE` policies and your policy document has static routes pointing to VPC attachments and you want to attach your VPCs to the core network before applying the desired policy document. Valid values are `true` or `false`. An example of this Pulumi snippet can be found above for VPC Attachment in a single region and for VPC Attachment multi-region. An example base policy is shown below. This base policy is overridden with the policy that you specify in the `networkmanager.CoreNetworkPolicyAttachment` resource.

        ```python
        import pulumi
        ```
        """
        return pulumi.get(self, "create_base_policy")

    @create_base_policy.setter
    def create_base_policy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "create_base_policy", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the Core Network.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value tags for the Core Network. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _CoreNetworkState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 base_policy_region: Optional[pulumi.Input[str]] = None,
                 base_policy_regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 create_base_policy: Optional[pulumi.Input[bool]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 edges: Optional[pulumi.Input[Sequence[pulumi.Input['CoreNetworkEdgeArgs']]]] = None,
                 global_network_id: Optional[pulumi.Input[str]] = None,
                 segments: Optional[pulumi.Input[Sequence[pulumi.Input['CoreNetworkSegmentArgs']]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering CoreNetwork resources.
        :param pulumi.Input[str] arn: Core Network Amazon Resource Name (ARN).
        :param pulumi.Input[str] base_policy_region: The base policy created by setting the `create_base_policy` argument to `true` requires a region to be set in the `edge-locations`, `location` key. If `base_policy_region` is not specified, the region used in the base policy defaults to the region specified in the `provider` block.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] base_policy_regions: A list of regions to add to the base policy. The base policy created by setting the `create_base_policy` argument to `true` requires one or more regions to be set in the `edge-locations`, `location` key. If `base_policy_regions` is not specified, the region used in the base policy defaults to the region specified in the `provider` block.
        :param pulumi.Input[bool] create_base_policy: Specifies whether to create a base policy when a core network is created or updated. A base policy is created and set to `LIVE` to allow attachments to the core network (e.g. VPC Attachments) before applying a policy document provided using the `networkmanager.CoreNetworkPolicyAttachment` resource. This base policy is needed if your core network does not have any `LIVE` policies and your policy document has static routes pointing to VPC attachments and you want to attach your VPCs to the core network before applying the desired policy document. Valid values are `true` or `false`. An example of this Pulumi snippet can be found above for VPC Attachment in a single region and for VPC Attachment multi-region. An example base policy is shown below. This base policy is overridden with the policy that you specify in the `networkmanager.CoreNetworkPolicyAttachment` resource.
               
               ```python
               import pulumi
               ```
        :param pulumi.Input[str] created_at: Timestamp when a core network was created.
        :param pulumi.Input[str] description: Description of the Core Network.
        :param pulumi.Input[Sequence[pulumi.Input['CoreNetworkEdgeArgs']]] edges: One or more blocks detailing the edges within a core network. Detailed below.
        :param pulumi.Input[str] global_network_id: The ID of the global network that a core network will be a part of.
        :param pulumi.Input[Sequence[pulumi.Input['CoreNetworkSegmentArgs']]] segments: One or more blocks detailing the segments within a core network. Detailed below.
        :param pulumi.Input[str] state: Current state of a core network.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value tags for the Core Network. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if base_policy_region is not None:
            warnings.warn("""Use the base_policy_regions argument instead. This argument will be removed in the next major version of the provider.""", DeprecationWarning)
            pulumi.log.warn("""base_policy_region is deprecated: Use the base_policy_regions argument instead. This argument will be removed in the next major version of the provider.""")
        if base_policy_region is not None:
            pulumi.set(__self__, "base_policy_region", base_policy_region)
        if base_policy_regions is not None:
            pulumi.set(__self__, "base_policy_regions", base_policy_regions)
        if create_base_policy is not None:
            pulumi.set(__self__, "create_base_policy", create_base_policy)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if edges is not None:
            pulumi.set(__self__, "edges", edges)
        if global_network_id is not None:
            pulumi.set(__self__, "global_network_id", global_network_id)
        if segments is not None:
            pulumi.set(__self__, "segments", segments)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        Core Network Amazon Resource Name (ARN).
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="basePolicyRegion")
    def base_policy_region(self) -> Optional[pulumi.Input[str]]:
        """
        The base policy created by setting the `create_base_policy` argument to `true` requires a region to be set in the `edge-locations`, `location` key. If `base_policy_region` is not specified, the region used in the base policy defaults to the region specified in the `provider` block.
        """
        warnings.warn("""Use the base_policy_regions argument instead. This argument will be removed in the next major version of the provider.""", DeprecationWarning)
        pulumi.log.warn("""base_policy_region is deprecated: Use the base_policy_regions argument instead. This argument will be removed in the next major version of the provider.""")

        return pulumi.get(self, "base_policy_region")

    @base_policy_region.setter
    def base_policy_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_policy_region", value)

    @property
    @pulumi.getter(name="basePolicyRegions")
    def base_policy_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of regions to add to the base policy. The base policy created by setting the `create_base_policy` argument to `true` requires one or more regions to be set in the `edge-locations`, `location` key. If `base_policy_regions` is not specified, the region used in the base policy defaults to the region specified in the `provider` block.
        """
        return pulumi.get(self, "base_policy_regions")

    @base_policy_regions.setter
    def base_policy_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "base_policy_regions", value)

    @property
    @pulumi.getter(name="createBasePolicy")
    def create_base_policy(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to create a base policy when a core network is created or updated. A base policy is created and set to `LIVE` to allow attachments to the core network (e.g. VPC Attachments) before applying a policy document provided using the `networkmanager.CoreNetworkPolicyAttachment` resource. This base policy is needed if your core network does not have any `LIVE` policies and your policy document has static routes pointing to VPC attachments and you want to attach your VPCs to the core network before applying the desired policy document. Valid values are `true` or `false`. An example of this Pulumi snippet can be found above for VPC Attachment in a single region and for VPC Attachment multi-region. An example base policy is shown below. This base policy is overridden with the policy that you specify in the `networkmanager.CoreNetworkPolicyAttachment` resource.

        ```python
        import pulumi
        ```
        """
        return pulumi.get(self, "create_base_policy")

    @create_base_policy.setter
    def create_base_policy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "create_base_policy", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp when a core network was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the Core Network.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def edges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CoreNetworkEdgeArgs']]]]:
        """
        One or more blocks detailing the edges within a core network. Detailed below.
        """
        return pulumi.get(self, "edges")

    @edges.setter
    def edges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CoreNetworkEdgeArgs']]]]):
        pulumi.set(self, "edges", value)

    @property
    @pulumi.getter(name="globalNetworkId")
    def global_network_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the global network that a core network will be a part of.
        """
        return pulumi.get(self, "global_network_id")

    @global_network_id.setter
    def global_network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "global_network_id", value)

    @property
    @pulumi.getter
    def segments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CoreNetworkSegmentArgs']]]]:
        """
        One or more blocks detailing the segments within a core network. Detailed below.
        """
        return pulumi.get(self, "segments")

    @segments.setter
    def segments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CoreNetworkSegmentArgs']]]]):
        pulumi.set(self, "segments", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        Current state of a core network.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value tags for the Core Network. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)


class CoreNetwork(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_policy_region: Optional[pulumi.Input[str]] = None,
                 base_policy_regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 create_base_policy: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 global_network_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Provides a core network resource.

        ## Example Usage
        ### Basic

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkmanager.CoreNetwork("example", global_network_id=aws_networkmanager_global_network["example"]["id"])
        ```
        ### With description

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkmanager.CoreNetwork("example",
            global_network_id=aws_networkmanager_global_network["example"]["id"],
            description="example")
        ```
        ### With tags

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkmanager.CoreNetwork("example",
            global_network_id=aws_networkmanager_global_network["example"]["id"],
            tags={
                "hello": "world",
            })
        ```
        ### With VPC Attachment (Single Region)

        The example below illustrates the scenario where your policy document has static routes pointing to VPC attachments and you want to attach your VPCs to the core network before applying the desired policy document. Set the `create_base_policy` argument to `true` if your core network does not currently have any `LIVE` policies (e.g. this is the first `pulumi up` with the core network resource), since a `LIVE` policy is required before VPCs can be attached to the core network. Otherwise, if your core network already has a `LIVE` policy, you may exclude the `create_base_policy` argument.

        ```python
        import pulumi
        import pulumi_aws as aws

        example_global_network = aws.networkmanager.GlobalNetwork("exampleGlobalNetwork")
        example_core_network = aws.networkmanager.CoreNetwork("exampleCoreNetwork",
            global_network_id=example_global_network.id,
            create_base_policy=True)
        example_vpc_attachment = aws.networkmanager.VpcAttachment("exampleVpcAttachment",
            core_network_id=example_core_network.id,
            subnet_arns=[__item["arn"] for __item in aws_subnet["example"]],
            vpc_arn=aws_vpc["example"]["arn"])
        example_core_network_policy_document = aws.networkmanager.get_core_network_policy_document_output(core_network_configurations=[aws.networkmanager.GetCoreNetworkPolicyDocumentCoreNetworkConfigurationArgs(
                asn_ranges=["65022-65534"],
                edge_locations=[aws.networkmanager.GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs(
                    location="us-west-2",
                )],
            )],
            segments=[aws.networkmanager.GetCoreNetworkPolicyDocumentSegmentArgs(
                name="segment",
            )],
            segment_actions=[aws.networkmanager.GetCoreNetworkPolicyDocumentSegmentActionArgs(
                action="create-route",
                segment="segment",
                destination_cidr_blocks=["0.0.0.0/0"],
                destinations=[example_vpc_attachment.id],
            )])
        example_core_network_policy_attachment = aws.networkmanager.CoreNetworkPolicyAttachment("exampleCoreNetworkPolicyAttachment",
            core_network_id=example_core_network.id,
            policy_document=example_core_network_policy_document.json)
        ```
        ### With VPC Attachment (Multi-Region)

        The example below illustrates the scenario where your policy document has static routes pointing to VPC attachments and you want to attach your VPCs to the core network before applying the desired policy document. Set the `create_base_policy` argument of the `networkmanager.CoreNetwork` resource to `true` if your core network does not currently have any `LIVE` policies (e.g. this is the first `pulumi up` with the core network resource), since a `LIVE` policy is required before VPCs can be attached to the core network. Otherwise, if your core network already has a `LIVE` policy, you may exclude the `create_base_policy` argument. For multi-region in a core network that does not yet have a `LIVE` policy, pass a list of regions to the `networkmanager.CoreNetwork` `base_policy_regions` argument. In the example below, `us-west-2` and `us-east-1` are specified in the base policy.

        ```python
        import pulumi
        import pulumi_aws as aws

        example_global_network = aws.networkmanager.GlobalNetwork("exampleGlobalNetwork")
        example_core_network = aws.networkmanager.CoreNetwork("exampleCoreNetwork",
            global_network_id=example_global_network.id,
            base_policy_regions=[
                "us-west-2",
                "us-east-1",
            ],
            create_base_policy=True)
        example_us_west2 = aws.networkmanager.VpcAttachment("exampleUsWest2",
            core_network_id=example_core_network.id,
            subnet_arns=[__item["arn"] for __item in aws_subnet["example_us_west_2"]],
            vpc_arn=aws_vpc["example_us_west_2"]["arn"])
        example_us_east1 = aws.networkmanager.VpcAttachment("exampleUsEast1",
            core_network_id=example_core_network.id,
            subnet_arns=[__item["arn"] for __item in aws_subnet["example_us_east_1"]],
            vpc_arn=aws_vpc["example_us_east_1"]["arn"],
            opts=pulumi.ResourceOptions(provider="alternate"))
        example_core_network_policy_document = aws.networkmanager.get_core_network_policy_document_output(core_network_configurations=[aws.networkmanager.GetCoreNetworkPolicyDocumentCoreNetworkConfigurationArgs(
                asn_ranges=["65022-65534"],
                edge_locations=[
                    aws.networkmanager.GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs(
                        location="us-west-2",
                    ),
                    aws.networkmanager.GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs(
                        location="us-east-1",
                    ),
                ],
            )],
            segments=[
                aws.networkmanager.GetCoreNetworkPolicyDocumentSegmentArgs(
                    name="segment",
                ),
                aws.networkmanager.GetCoreNetworkPolicyDocumentSegmentArgs(
                    name="segment2",
                ),
            ],
            segment_actions=[
                aws.networkmanager.GetCoreNetworkPolicyDocumentSegmentActionArgs(
                    action="create-route",
                    segment="segment",
                    destination_cidr_blocks=["10.0.0.0/16"],
                    destinations=[example_us_west2.id],
                ),
                aws.networkmanager.GetCoreNetworkPolicyDocumentSegmentActionArgs(
                    action="create-route",
                    segment="segment",
                    destination_cidr_blocks=["10.1.0.0/16"],
                    destinations=[example_us_east1.id],
                ),
            ])
        example_core_network_policy_attachment = aws.networkmanager.CoreNetworkPolicyAttachment("exampleCoreNetworkPolicyAttachment",
            core_network_id=example_core_network.id,
            policy_document=example_core_network_policy_document.json)
        ```

        ## Import

        Using `pulumi import`, import `aws_networkmanager_core_network` using the core network ID. For example:

        ```sh
         $ pulumi import aws:networkmanager/coreNetwork:CoreNetwork example core-network-0d47f6t230mz46dy4
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] base_policy_region: The base policy created by setting the `create_base_policy` argument to `true` requires a region to be set in the `edge-locations`, `location` key. If `base_policy_region` is not specified, the region used in the base policy defaults to the region specified in the `provider` block.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] base_policy_regions: A list of regions to add to the base policy. The base policy created by setting the `create_base_policy` argument to `true` requires one or more regions to be set in the `edge-locations`, `location` key. If `base_policy_regions` is not specified, the region used in the base policy defaults to the region specified in the `provider` block.
        :param pulumi.Input[bool] create_base_policy: Specifies whether to create a base policy when a core network is created or updated. A base policy is created and set to `LIVE` to allow attachments to the core network (e.g. VPC Attachments) before applying a policy document provided using the `networkmanager.CoreNetworkPolicyAttachment` resource. This base policy is needed if your core network does not have any `LIVE` policies and your policy document has static routes pointing to VPC attachments and you want to attach your VPCs to the core network before applying the desired policy document. Valid values are `true` or `false`. An example of this Pulumi snippet can be found above for VPC Attachment in a single region and for VPC Attachment multi-region. An example base policy is shown below. This base policy is overridden with the policy that you specify in the `networkmanager.CoreNetworkPolicyAttachment` resource.
               
               ```python
               import pulumi
               ```
        :param pulumi.Input[str] description: Description of the Core Network.
        :param pulumi.Input[str] global_network_id: The ID of the global network that a core network will be a part of.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value tags for the Core Network. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CoreNetworkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a core network resource.

        ## Example Usage
        ### Basic

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkmanager.CoreNetwork("example", global_network_id=aws_networkmanager_global_network["example"]["id"])
        ```
        ### With description

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkmanager.CoreNetwork("example",
            global_network_id=aws_networkmanager_global_network["example"]["id"],
            description="example")
        ```
        ### With tags

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkmanager.CoreNetwork("example",
            global_network_id=aws_networkmanager_global_network["example"]["id"],
            tags={
                "hello": "world",
            })
        ```
        ### With VPC Attachment (Single Region)

        The example below illustrates the scenario where your policy document has static routes pointing to VPC attachments and you want to attach your VPCs to the core network before applying the desired policy document. Set the `create_base_policy` argument to `true` if your core network does not currently have any `LIVE` policies (e.g. this is the first `pulumi up` with the core network resource), since a `LIVE` policy is required before VPCs can be attached to the core network. Otherwise, if your core network already has a `LIVE` policy, you may exclude the `create_base_policy` argument.

        ```python
        import pulumi
        import pulumi_aws as aws

        example_global_network = aws.networkmanager.GlobalNetwork("exampleGlobalNetwork")
        example_core_network = aws.networkmanager.CoreNetwork("exampleCoreNetwork",
            global_network_id=example_global_network.id,
            create_base_policy=True)
        example_vpc_attachment = aws.networkmanager.VpcAttachment("exampleVpcAttachment",
            core_network_id=example_core_network.id,
            subnet_arns=[__item["arn"] for __item in aws_subnet["example"]],
            vpc_arn=aws_vpc["example"]["arn"])
        example_core_network_policy_document = aws.networkmanager.get_core_network_policy_document_output(core_network_configurations=[aws.networkmanager.GetCoreNetworkPolicyDocumentCoreNetworkConfigurationArgs(
                asn_ranges=["65022-65534"],
                edge_locations=[aws.networkmanager.GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs(
                    location="us-west-2",
                )],
            )],
            segments=[aws.networkmanager.GetCoreNetworkPolicyDocumentSegmentArgs(
                name="segment",
            )],
            segment_actions=[aws.networkmanager.GetCoreNetworkPolicyDocumentSegmentActionArgs(
                action="create-route",
                segment="segment",
                destination_cidr_blocks=["0.0.0.0/0"],
                destinations=[example_vpc_attachment.id],
            )])
        example_core_network_policy_attachment = aws.networkmanager.CoreNetworkPolicyAttachment("exampleCoreNetworkPolicyAttachment",
            core_network_id=example_core_network.id,
            policy_document=example_core_network_policy_document.json)
        ```
        ### With VPC Attachment (Multi-Region)

        The example below illustrates the scenario where your policy document has static routes pointing to VPC attachments and you want to attach your VPCs to the core network before applying the desired policy document. Set the `create_base_policy` argument of the `networkmanager.CoreNetwork` resource to `true` if your core network does not currently have any `LIVE` policies (e.g. this is the first `pulumi up` with the core network resource), since a `LIVE` policy is required before VPCs can be attached to the core network. Otherwise, if your core network already has a `LIVE` policy, you may exclude the `create_base_policy` argument. For multi-region in a core network that does not yet have a `LIVE` policy, pass a list of regions to the `networkmanager.CoreNetwork` `base_policy_regions` argument. In the example below, `us-west-2` and `us-east-1` are specified in the base policy.

        ```python
        import pulumi
        import pulumi_aws as aws

        example_global_network = aws.networkmanager.GlobalNetwork("exampleGlobalNetwork")
        example_core_network = aws.networkmanager.CoreNetwork("exampleCoreNetwork",
            global_network_id=example_global_network.id,
            base_policy_regions=[
                "us-west-2",
                "us-east-1",
            ],
            create_base_policy=True)
        example_us_west2 = aws.networkmanager.VpcAttachment("exampleUsWest2",
            core_network_id=example_core_network.id,
            subnet_arns=[__item["arn"] for __item in aws_subnet["example_us_west_2"]],
            vpc_arn=aws_vpc["example_us_west_2"]["arn"])
        example_us_east1 = aws.networkmanager.VpcAttachment("exampleUsEast1",
            core_network_id=example_core_network.id,
            subnet_arns=[__item["arn"] for __item in aws_subnet["example_us_east_1"]],
            vpc_arn=aws_vpc["example_us_east_1"]["arn"],
            opts=pulumi.ResourceOptions(provider="alternate"))
        example_core_network_policy_document = aws.networkmanager.get_core_network_policy_document_output(core_network_configurations=[aws.networkmanager.GetCoreNetworkPolicyDocumentCoreNetworkConfigurationArgs(
                asn_ranges=["65022-65534"],
                edge_locations=[
                    aws.networkmanager.GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs(
                        location="us-west-2",
                    ),
                    aws.networkmanager.GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs(
                        location="us-east-1",
                    ),
                ],
            )],
            segments=[
                aws.networkmanager.GetCoreNetworkPolicyDocumentSegmentArgs(
                    name="segment",
                ),
                aws.networkmanager.GetCoreNetworkPolicyDocumentSegmentArgs(
                    name="segment2",
                ),
            ],
            segment_actions=[
                aws.networkmanager.GetCoreNetworkPolicyDocumentSegmentActionArgs(
                    action="create-route",
                    segment="segment",
                    destination_cidr_blocks=["10.0.0.0/16"],
                    destinations=[example_us_west2.id],
                ),
                aws.networkmanager.GetCoreNetworkPolicyDocumentSegmentActionArgs(
                    action="create-route",
                    segment="segment",
                    destination_cidr_blocks=["10.1.0.0/16"],
                    destinations=[example_us_east1.id],
                ),
            ])
        example_core_network_policy_attachment = aws.networkmanager.CoreNetworkPolicyAttachment("exampleCoreNetworkPolicyAttachment",
            core_network_id=example_core_network.id,
            policy_document=example_core_network_policy_document.json)
        ```

        ## Import

        Using `pulumi import`, import `aws_networkmanager_core_network` using the core network ID. For example:

        ```sh
         $ pulumi import aws:networkmanager/coreNetwork:CoreNetwork example core-network-0d47f6t230mz46dy4
        ```

        :param str resource_name: The name of the resource.
        :param CoreNetworkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CoreNetworkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_policy_region: Optional[pulumi.Input[str]] = None,
                 base_policy_regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 create_base_policy: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 global_network_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CoreNetworkArgs.__new__(CoreNetworkArgs)

            if base_policy_region is not None and not opts.urn:
                warnings.warn("""Use the base_policy_regions argument instead. This argument will be removed in the next major version of the provider.""", DeprecationWarning)
                pulumi.log.warn("""base_policy_region is deprecated: Use the base_policy_regions argument instead. This argument will be removed in the next major version of the provider.""")
            __props__.__dict__["base_policy_region"] = base_policy_region
            __props__.__dict__["base_policy_regions"] = base_policy_regions
            __props__.__dict__["create_base_policy"] = create_base_policy
            __props__.__dict__["description"] = description
            if global_network_id is None and not opts.urn:
                raise TypeError("Missing required property 'global_network_id'")
            __props__.__dict__["global_network_id"] = global_network_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["edges"] = None
            __props__.__dict__["segments"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["tags_all"] = None
        super(CoreNetwork, __self__).__init__(
            'aws:networkmanager/coreNetwork:CoreNetwork',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            base_policy_region: Optional[pulumi.Input[str]] = None,
            base_policy_regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            create_base_policy: Optional[pulumi.Input[bool]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            edges: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CoreNetworkEdgeArgs']]]]] = None,
            global_network_id: Optional[pulumi.Input[str]] = None,
            segments: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CoreNetworkSegmentArgs']]]]] = None,
            state: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None) -> 'CoreNetwork':
        """
        Get an existing CoreNetwork resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: Core Network Amazon Resource Name (ARN).
        :param pulumi.Input[str] base_policy_region: The base policy created by setting the `create_base_policy` argument to `true` requires a region to be set in the `edge-locations`, `location` key. If `base_policy_region` is not specified, the region used in the base policy defaults to the region specified in the `provider` block.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] base_policy_regions: A list of regions to add to the base policy. The base policy created by setting the `create_base_policy` argument to `true` requires one or more regions to be set in the `edge-locations`, `location` key. If `base_policy_regions` is not specified, the region used in the base policy defaults to the region specified in the `provider` block.
        :param pulumi.Input[bool] create_base_policy: Specifies whether to create a base policy when a core network is created or updated. A base policy is created and set to `LIVE` to allow attachments to the core network (e.g. VPC Attachments) before applying a policy document provided using the `networkmanager.CoreNetworkPolicyAttachment` resource. This base policy is needed if your core network does not have any `LIVE` policies and your policy document has static routes pointing to VPC attachments and you want to attach your VPCs to the core network before applying the desired policy document. Valid values are `true` or `false`. An example of this Pulumi snippet can be found above for VPC Attachment in a single region and for VPC Attachment multi-region. An example base policy is shown below. This base policy is overridden with the policy that you specify in the `networkmanager.CoreNetworkPolicyAttachment` resource.
               
               ```python
               import pulumi
               ```
        :param pulumi.Input[str] created_at: Timestamp when a core network was created.
        :param pulumi.Input[str] description: Description of the Core Network.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CoreNetworkEdgeArgs']]]] edges: One or more blocks detailing the edges within a core network. Detailed below.
        :param pulumi.Input[str] global_network_id: The ID of the global network that a core network will be a part of.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CoreNetworkSegmentArgs']]]] segments: One or more blocks detailing the segments within a core network. Detailed below.
        :param pulumi.Input[str] state: Current state of a core network.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value tags for the Core Network. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CoreNetworkState.__new__(_CoreNetworkState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["base_policy_region"] = base_policy_region
        __props__.__dict__["base_policy_regions"] = base_policy_regions
        __props__.__dict__["create_base_policy"] = create_base_policy
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["edges"] = edges
        __props__.__dict__["global_network_id"] = global_network_id
        __props__.__dict__["segments"] = segments
        __props__.__dict__["state"] = state
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return CoreNetwork(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        Core Network Amazon Resource Name (ARN).
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="basePolicyRegion")
    def base_policy_region(self) -> pulumi.Output[Optional[str]]:
        """
        The base policy created by setting the `create_base_policy` argument to `true` requires a region to be set in the `edge-locations`, `location` key. If `base_policy_region` is not specified, the region used in the base policy defaults to the region specified in the `provider` block.
        """
        warnings.warn("""Use the base_policy_regions argument instead. This argument will be removed in the next major version of the provider.""", DeprecationWarning)
        pulumi.log.warn("""base_policy_region is deprecated: Use the base_policy_regions argument instead. This argument will be removed in the next major version of the provider.""")

        return pulumi.get(self, "base_policy_region")

    @property
    @pulumi.getter(name="basePolicyRegions")
    def base_policy_regions(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of regions to add to the base policy. The base policy created by setting the `create_base_policy` argument to `true` requires one or more regions to be set in the `edge-locations`, `location` key. If `base_policy_regions` is not specified, the region used in the base policy defaults to the region specified in the `provider` block.
        """
        return pulumi.get(self, "base_policy_regions")

    @property
    @pulumi.getter(name="createBasePolicy")
    def create_base_policy(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to create a base policy when a core network is created or updated. A base policy is created and set to `LIVE` to allow attachments to the core network (e.g. VPC Attachments) before applying a policy document provided using the `networkmanager.CoreNetworkPolicyAttachment` resource. This base policy is needed if your core network does not have any `LIVE` policies and your policy document has static routes pointing to VPC attachments and you want to attach your VPCs to the core network before applying the desired policy document. Valid values are `true` or `false`. An example of this Pulumi snippet can be found above for VPC Attachment in a single region and for VPC Attachment multi-region. An example base policy is shown below. This base policy is overridden with the policy that you specify in the `networkmanager.CoreNetworkPolicyAttachment` resource.

        ```python
        import pulumi
        ```
        """
        return pulumi.get(self, "create_base_policy")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        Timestamp when a core network was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the Core Network.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def edges(self) -> pulumi.Output[Sequence['outputs.CoreNetworkEdge']]:
        """
        One or more blocks detailing the edges within a core network. Detailed below.
        """
        return pulumi.get(self, "edges")

    @property
    @pulumi.getter(name="globalNetworkId")
    def global_network_id(self) -> pulumi.Output[str]:
        """
        The ID of the global network that a core network will be a part of.
        """
        return pulumi.get(self, "global_network_id")

    @property
    @pulumi.getter
    def segments(self) -> pulumi.Output[Sequence['outputs.CoreNetworkSegment']]:
        """
        One or more blocks detailing the segments within a core network. Detailed below.
        """
        return pulumi.get(self, "segments")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        Current state of a core network.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Key-value tags for the Core Network. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

