# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ConnectAttachmentOptions',
    'ConnectPeerBgpOptions',
    'ConnectPeerConfiguration',
    'ConnectPeerConfigurationBgpConfiguration',
    'CoreNetworkEdge',
    'CoreNetworkSegment',
    'DeviceAwsLocation',
    'DeviceLocation',
    'LinkBandwidth',
    'SiteLocation',
    'VpcAttachmentOptions',
    'GetCoreNetworkPolicyDocumentAttachmentPolicyResult',
    'GetCoreNetworkPolicyDocumentAttachmentPolicyActionResult',
    'GetCoreNetworkPolicyDocumentAttachmentPolicyConditionResult',
    'GetCoreNetworkPolicyDocumentCoreNetworkConfigurationResult',
    'GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationResult',
    'GetCoreNetworkPolicyDocumentSegmentResult',
    'GetCoreNetworkPolicyDocumentSegmentActionResult',
    'GetDeviceAwsLocationResult',
    'GetDeviceLocationResult',
    'GetLinkBandwidthResult',
    'GetSiteLocationResult',
]

@pulumi.output_type
class ConnectAttachmentOptions(dict):
    def __init__(__self__, *,
                 protocol: Optional[str] = None):
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        return pulumi.get(self, "protocol")


@pulumi.output_type
class ConnectPeerBgpOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "peerAsn":
            suggest = "peer_asn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectPeerBgpOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectPeerBgpOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectPeerBgpOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 peer_asn: Optional[int] = None):
        if peer_asn is not None:
            pulumi.set(__self__, "peer_asn", peer_asn)

    @property
    @pulumi.getter(name="peerAsn")
    def peer_asn(self) -> Optional[int]:
        return pulumi.get(self, "peer_asn")


@pulumi.output_type
class ConnectPeerConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bgpConfigurations":
            suggest = "bgp_configurations"
        elif key == "coreNetworkAddress":
            suggest = "core_network_address"
        elif key == "insideCidrBlocks":
            suggest = "inside_cidr_blocks"
        elif key == "peerAddress":
            suggest = "peer_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectPeerConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectPeerConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectPeerConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bgp_configurations: Optional[Sequence['outputs.ConnectPeerConfigurationBgpConfiguration']] = None,
                 core_network_address: Optional[str] = None,
                 inside_cidr_blocks: Optional[Sequence[str]] = None,
                 peer_address: Optional[str] = None,
                 protocol: Optional[str] = None):
        """
        :param str core_network_address: A Connect peer core network address.
        :param Sequence[str] inside_cidr_blocks: The inside IP addresses used for BGP peering.
        :param str peer_address: The Connect peer address.
               
               The following arguments are optional:
        """
        if bgp_configurations is not None:
            pulumi.set(__self__, "bgp_configurations", bgp_configurations)
        if core_network_address is not None:
            pulumi.set(__self__, "core_network_address", core_network_address)
        if inside_cidr_blocks is not None:
            pulumi.set(__self__, "inside_cidr_blocks", inside_cidr_blocks)
        if peer_address is not None:
            pulumi.set(__self__, "peer_address", peer_address)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="bgpConfigurations")
    def bgp_configurations(self) -> Optional[Sequence['outputs.ConnectPeerConfigurationBgpConfiguration']]:
        return pulumi.get(self, "bgp_configurations")

    @property
    @pulumi.getter(name="coreNetworkAddress")
    def core_network_address(self) -> Optional[str]:
        """
        A Connect peer core network address.
        """
        return pulumi.get(self, "core_network_address")

    @property
    @pulumi.getter(name="insideCidrBlocks")
    def inside_cidr_blocks(self) -> Optional[Sequence[str]]:
        """
        The inside IP addresses used for BGP peering.
        """
        return pulumi.get(self, "inside_cidr_blocks")

    @property
    @pulumi.getter(name="peerAddress")
    def peer_address(self) -> Optional[str]:
        """
        The Connect peer address.

        The following arguments are optional:
        """
        return pulumi.get(self, "peer_address")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        return pulumi.get(self, "protocol")


@pulumi.output_type
class ConnectPeerConfigurationBgpConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "coreNetworkAddress":
            suggest = "core_network_address"
        elif key == "coreNetworkAsn":
            suggest = "core_network_asn"
        elif key == "peerAddress":
            suggest = "peer_address"
        elif key == "peerAsn":
            suggest = "peer_asn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectPeerConfigurationBgpConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectPeerConfigurationBgpConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectPeerConfigurationBgpConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 core_network_address: Optional[str] = None,
                 core_network_asn: Optional[int] = None,
                 peer_address: Optional[str] = None,
                 peer_asn: Optional[int] = None):
        """
        :param str core_network_address: A Connect peer core network address.
        :param str peer_address: The Connect peer address.
               
               The following arguments are optional:
        """
        if core_network_address is not None:
            pulumi.set(__self__, "core_network_address", core_network_address)
        if core_network_asn is not None:
            pulumi.set(__self__, "core_network_asn", core_network_asn)
        if peer_address is not None:
            pulumi.set(__self__, "peer_address", peer_address)
        if peer_asn is not None:
            pulumi.set(__self__, "peer_asn", peer_asn)

    @property
    @pulumi.getter(name="coreNetworkAddress")
    def core_network_address(self) -> Optional[str]:
        """
        A Connect peer core network address.
        """
        return pulumi.get(self, "core_network_address")

    @property
    @pulumi.getter(name="coreNetworkAsn")
    def core_network_asn(self) -> Optional[int]:
        return pulumi.get(self, "core_network_asn")

    @property
    @pulumi.getter(name="peerAddress")
    def peer_address(self) -> Optional[str]:
        """
        The Connect peer address.

        The following arguments are optional:
        """
        return pulumi.get(self, "peer_address")

    @property
    @pulumi.getter(name="peerAsn")
    def peer_asn(self) -> Optional[int]:
        return pulumi.get(self, "peer_asn")


@pulumi.output_type
class CoreNetworkEdge(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "edgeLocation":
            suggest = "edge_location"
        elif key == "insideCidrBlocks":
            suggest = "inside_cidr_blocks"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CoreNetworkEdge. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CoreNetworkEdge.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CoreNetworkEdge.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 asn: Optional[int] = None,
                 edge_location: Optional[str] = None,
                 inside_cidr_blocks: Optional[Sequence[str]] = None):
        """
        :param int asn: ASN of a core network edge.
        :param str edge_location: Region where a core network edge is located.
        :param Sequence[str] inside_cidr_blocks: Inside IP addresses used for core network edges.
        """
        if asn is not None:
            pulumi.set(__self__, "asn", asn)
        if edge_location is not None:
            pulumi.set(__self__, "edge_location", edge_location)
        if inside_cidr_blocks is not None:
            pulumi.set(__self__, "inside_cidr_blocks", inside_cidr_blocks)

    @property
    @pulumi.getter
    def asn(self) -> Optional[int]:
        """
        ASN of a core network edge.
        """
        return pulumi.get(self, "asn")

    @property
    @pulumi.getter(name="edgeLocation")
    def edge_location(self) -> Optional[str]:
        """
        Region where a core network edge is located.
        """
        return pulumi.get(self, "edge_location")

    @property
    @pulumi.getter(name="insideCidrBlocks")
    def inside_cidr_blocks(self) -> Optional[Sequence[str]]:
        """
        Inside IP addresses used for core network edges.
        """
        return pulumi.get(self, "inside_cidr_blocks")


@pulumi.output_type
class CoreNetworkSegment(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "edgeLocations":
            suggest = "edge_locations"
        elif key == "sharedSegments":
            suggest = "shared_segments"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CoreNetworkSegment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CoreNetworkSegment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CoreNetworkSegment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 edge_locations: Optional[Sequence[str]] = None,
                 name: Optional[str] = None,
                 shared_segments: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] edge_locations: Regions where the edges are located.
        :param str name: Name of a core network segment.
        :param Sequence[str] shared_segments: Shared segments of a core network.
        """
        if edge_locations is not None:
            pulumi.set(__self__, "edge_locations", edge_locations)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if shared_segments is not None:
            pulumi.set(__self__, "shared_segments", shared_segments)

    @property
    @pulumi.getter(name="edgeLocations")
    def edge_locations(self) -> Optional[Sequence[str]]:
        """
        Regions where the edges are located.
        """
        return pulumi.get(self, "edge_locations")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of a core network segment.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sharedSegments")
    def shared_segments(self) -> Optional[Sequence[str]]:
        """
        Shared segments of a core network.
        """
        return pulumi.get(self, "shared_segments")


@pulumi.output_type
class DeviceAwsLocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetArn":
            suggest = "subnet_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceAwsLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceAwsLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceAwsLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_arn: Optional[str] = None,
                 zone: Optional[str] = None):
        """
        :param str subnet_arn: The Amazon Resource Name (ARN) of the subnet that the device is located in.
        :param str zone: The Zone that the device is located in. Specify the ID of an Availability Zone, Local Zone, Wavelength Zone, or an Outpost.
        """
        if subnet_arn is not None:
            pulumi.set(__self__, "subnet_arn", subnet_arn)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="subnetArn")
    def subnet_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the subnet that the device is located in.
        """
        return pulumi.get(self, "subnet_arn")

    @property
    @pulumi.getter
    def zone(self) -> Optional[str]:
        """
        The Zone that the device is located in. Specify the ID of an Availability Zone, Local Zone, Wavelength Zone, or an Outpost.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class DeviceLocation(dict):
    def __init__(__self__, *,
                 address: Optional[str] = None,
                 latitude: Optional[str] = None,
                 longitude: Optional[str] = None):
        """
        :param str address: The physical address.
        :param str latitude: The latitude.
        :param str longitude: The longitude.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if latitude is not None:
            pulumi.set(__self__, "latitude", latitude)
        if longitude is not None:
            pulumi.set(__self__, "longitude", longitude)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        The physical address.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def latitude(self) -> Optional[str]:
        """
        The latitude.
        """
        return pulumi.get(self, "latitude")

    @property
    @pulumi.getter
    def longitude(self) -> Optional[str]:
        """
        The longitude.
        """
        return pulumi.get(self, "longitude")


@pulumi.output_type
class LinkBandwidth(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "downloadSpeed":
            suggest = "download_speed"
        elif key == "uploadSpeed":
            suggest = "upload_speed"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinkBandwidth. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinkBandwidth.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinkBandwidth.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 download_speed: Optional[int] = None,
                 upload_speed: Optional[int] = None):
        """
        :param int download_speed: Download speed in Mbps.
        :param int upload_speed: Upload speed in Mbps.
        """
        if download_speed is not None:
            pulumi.set(__self__, "download_speed", download_speed)
        if upload_speed is not None:
            pulumi.set(__self__, "upload_speed", upload_speed)

    @property
    @pulumi.getter(name="downloadSpeed")
    def download_speed(self) -> Optional[int]:
        """
        Download speed in Mbps.
        """
        return pulumi.get(self, "download_speed")

    @property
    @pulumi.getter(name="uploadSpeed")
    def upload_speed(self) -> Optional[int]:
        """
        Upload speed in Mbps.
        """
        return pulumi.get(self, "upload_speed")


@pulumi.output_type
class SiteLocation(dict):
    def __init__(__self__, *,
                 address: Optional[str] = None,
                 latitude: Optional[str] = None,
                 longitude: Optional[str] = None):
        """
        :param str address: Address of the location.
        :param str latitude: Latitude of the location.
        :param str longitude: Longitude of the location.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if latitude is not None:
            pulumi.set(__self__, "latitude", latitude)
        if longitude is not None:
            pulumi.set(__self__, "longitude", longitude)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        Address of the location.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def latitude(self) -> Optional[str]:
        """
        Latitude of the location.
        """
        return pulumi.get(self, "latitude")

    @property
    @pulumi.getter
    def longitude(self) -> Optional[str]:
        """
        Longitude of the location.
        """
        return pulumi.get(self, "longitude")


@pulumi.output_type
class VpcAttachmentOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applianceModeSupport":
            suggest = "appliance_mode_support"
        elif key == "ipv6Support":
            suggest = "ipv6_support"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VpcAttachmentOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VpcAttachmentOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VpcAttachmentOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 appliance_mode_support: Optional[bool] = None,
                 ipv6_support: Optional[bool] = None):
        """
        :param bool appliance_mode_support: Indicates whether appliance mode is supported. If enabled, traffic flow between a source and destination use the same Availability Zone for the VPC attachment for the lifetime of that flow.
        :param bool ipv6_support: Indicates whether IPv6 is supported.
        """
        if appliance_mode_support is not None:
            pulumi.set(__self__, "appliance_mode_support", appliance_mode_support)
        if ipv6_support is not None:
            pulumi.set(__self__, "ipv6_support", ipv6_support)

    @property
    @pulumi.getter(name="applianceModeSupport")
    def appliance_mode_support(self) -> Optional[bool]:
        """
        Indicates whether appliance mode is supported. If enabled, traffic flow between a source and destination use the same Availability Zone for the VPC attachment for the lifetime of that flow.
        """
        return pulumi.get(self, "appliance_mode_support")

    @property
    @pulumi.getter(name="ipv6Support")
    def ipv6_support(self) -> Optional[bool]:
        """
        Indicates whether IPv6 is supported.
        """
        return pulumi.get(self, "ipv6_support")


@pulumi.output_type
class GetCoreNetworkPolicyDocumentAttachmentPolicyResult(dict):
    def __init__(__self__, *,
                 action: 'outputs.GetCoreNetworkPolicyDocumentAttachmentPolicyActionResult',
                 conditions: Sequence['outputs.GetCoreNetworkPolicyDocumentAttachmentPolicyConditionResult'],
                 rule_number: int,
                 condition_logic: Optional[str] = None,
                 description: Optional[str] = None):
        """
        :param 'GetCoreNetworkPolicyDocumentAttachmentPolicyActionArgs' action: Action to take when a condition is true. Detailed Below.
        :param Sequence['GetCoreNetworkPolicyDocumentAttachmentPolicyConditionArgs'] conditions: A block argument. Detailed Below.
        :param int rule_number: An integer from `1` to `65535` indicating the rule's order number. Rules are processed in order from the lowest numbered rule to the highest. Rules stop processing when a rule is matched. It's important to make sure that you number your rules in the exact order that you want them processed.
        :param str condition_logic: Valid values include `and` or `or`. This is a mandatory parameter only if you have more than one condition. The `condition_logic` apply to all of the conditions for a rule, which also means nested conditions of `and` or `or` are not supported. Use `or` if you want to associate the attachment with the segment by either the segment name or attachment tag value, or by the chosen conditions. Use `and` if you want to associate the attachment with the segment by either the segment name or attachment tag value and by the chosen conditions. Detailed Below.
        :param str description: A user-defined description that further helps identify the rule.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "rule_number", rule_number)
        if condition_logic is not None:
            pulumi.set(__self__, "condition_logic", condition_logic)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def action(self) -> 'outputs.GetCoreNetworkPolicyDocumentAttachmentPolicyActionResult':
        """
        Action to take when a condition is true. Detailed Below.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.GetCoreNetworkPolicyDocumentAttachmentPolicyConditionResult']:
        """
        A block argument. Detailed Below.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="ruleNumber")
    def rule_number(self) -> int:
        """
        An integer from `1` to `65535` indicating the rule's order number. Rules are processed in order from the lowest numbered rule to the highest. Rules stop processing when a rule is matched. It's important to make sure that you number your rules in the exact order that you want them processed.
        """
        return pulumi.get(self, "rule_number")

    @property
    @pulumi.getter(name="conditionLogic")
    def condition_logic(self) -> Optional[str]:
        """
        Valid values include `and` or `or`. This is a mandatory parameter only if you have more than one condition. The `condition_logic` apply to all of the conditions for a rule, which also means nested conditions of `and` or `or` are not supported. Use `or` if you want to associate the attachment with the segment by either the segment name or attachment tag value, or by the chosen conditions. Use `and` if you want to associate the attachment with the segment by either the segment name or attachment tag value and by the chosen conditions. Detailed Below.
        """
        return pulumi.get(self, "condition_logic")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A user-defined description that further helps identify the rule.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class GetCoreNetworkPolicyDocumentAttachmentPolicyActionResult(dict):
    def __init__(__self__, *,
                 association_method: str,
                 require_acceptance: Optional[bool] = None,
                 segment: Optional[str] = None,
                 tag_value_of_key: Optional[str] = None):
        """
        :param str association_method: Defines how a segment is mapped. Values can be `constant` or `tag`. `constant` statically defines the segment to associate the attachment to. `tag` uses the value of a tag to dynamically try to map to a segment.reference_policies_elements_condition_operators.html) to evaluate.
        :param bool require_acceptance: Determines if this mapping should override the segment value for `require_attachment_acceptance`. You can only set this to `true`, indicating that this setting applies only to segments that have `require_attachment_acceptance` set to `false`. If the segment already has the default `require_attachment_acceptance`, you can set this to inherit segment’s acceptance value.
        :param str segment: Name of the `segment` to share as defined in the `segments` section. This is used only when the `association_method` is `constant`.
        :param str tag_value_of_key: Maps the attachment to the value of a known key. This is used with the `association_method` is `tag`. For example a `tag` of `stage = “test”`, will map to a segment named `test`. The value must exactly match the name of a segment. This allows you to have many segments, but use only a single rule without having to define multiple nearly identical conditions. This prevents creating many similar conditions that all use the same keys to map to segments.
        """
        pulumi.set(__self__, "association_method", association_method)
        if require_acceptance is not None:
            pulumi.set(__self__, "require_acceptance", require_acceptance)
        if segment is not None:
            pulumi.set(__self__, "segment", segment)
        if tag_value_of_key is not None:
            pulumi.set(__self__, "tag_value_of_key", tag_value_of_key)

    @property
    @pulumi.getter(name="associationMethod")
    def association_method(self) -> str:
        """
        Defines how a segment is mapped. Values can be `constant` or `tag`. `constant` statically defines the segment to associate the attachment to. `tag` uses the value of a tag to dynamically try to map to a segment.reference_policies_elements_condition_operators.html) to evaluate.
        """
        return pulumi.get(self, "association_method")

    @property
    @pulumi.getter(name="requireAcceptance")
    def require_acceptance(self) -> Optional[bool]:
        """
        Determines if this mapping should override the segment value for `require_attachment_acceptance`. You can only set this to `true`, indicating that this setting applies only to segments that have `require_attachment_acceptance` set to `false`. If the segment already has the default `require_attachment_acceptance`, you can set this to inherit segment’s acceptance value.
        """
        return pulumi.get(self, "require_acceptance")

    @property
    @pulumi.getter
    def segment(self) -> Optional[str]:
        """
        Name of the `segment` to share as defined in the `segments` section. This is used only when the `association_method` is `constant`.
        """
        return pulumi.get(self, "segment")

    @property
    @pulumi.getter(name="tagValueOfKey")
    def tag_value_of_key(self) -> Optional[str]:
        """
        Maps the attachment to the value of a known key. This is used with the `association_method` is `tag`. For example a `tag` of `stage = “test”`, will map to a segment named `test`. The value must exactly match the name of a segment. This allows you to have many segments, but use only a single rule without having to define multiple nearly identical conditions. This prevents creating many similar conditions that all use the same keys to map to segments.
        """
        return pulumi.get(self, "tag_value_of_key")


@pulumi.output_type
class GetCoreNetworkPolicyDocumentAttachmentPolicyConditionResult(dict):
    def __init__(__self__, *,
                 type: str,
                 key: Optional[str] = None,
                 operator: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str type: Valid values include: `account-id`, `any`, `tag-value`, `tag-exists`, `resource-id`, `region`, `attachment-type`.
        :param str key: string value
        :param str operator: Valid values include: `equals`, `not-equals`, `contains`, `begins-with`.
        :param str value: string value
        """
        pulumi.set(__self__, "type", type)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Valid values include: `account-id`, `any`, `tag-value`, `tag-exists`, `resource-id`, `region`, `attachment-type`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        string value
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def operator(self) -> Optional[str]:
        """
        Valid values include: `equals`, `not-equals`, `contains`, `begins-with`.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        string value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetCoreNetworkPolicyDocumentCoreNetworkConfigurationResult(dict):
    def __init__(__self__, *,
                 asn_ranges: Sequence[str],
                 edge_locations: Sequence['outputs.GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationResult'],
                 inside_cidr_blocks: Optional[Sequence[str]] = None,
                 vpn_ecmp_support: Optional[bool] = None):
        """
        :param Sequence[str] asn_ranges: List of strings containing Autonomous System Numbers (ASNs) to assign to Core Network Edges. By default, the core network automatically assigns an ASN for each Core Network Edge but you can optionally define the ASN in the edge-locations for each Region. The ASN uses an array of integer ranges only from `64512` to `65534` and `4200000000` to `4294967294` expressed as a string like `"64512-65534"`. No other ASN ranges can be used.
        :param Sequence['GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs'] edge_locations: A block value of AWS Region locations where you're creating Core Network Edges. Detailed below.
        :param Sequence[str] inside_cidr_blocks: The Classless Inter-Domain Routing (CIDR) block range used to create tunnels for AWS Transit Gateway Connect. The format is standard AWS CIDR range (for example, `10.0.1.0/24`). You can optionally define the inside CIDR in the Core Network Edges section per Region. The minimum is a `/24` for IPv4 or `/64` for IPv6. You can provide multiple `/24` subnets or a larger CIDR range. If you define a larger CIDR range, new Core Network Edges will be automatically assigned `/24` and `/64` subnets from the larger CIDR. an Inside CIDR block is required for attaching Connect attachments to a Core Network Edge.
        :param bool vpn_ecmp_support: Indicates whether the core network forwards traffic over multiple equal-cost routes using VPN. The value can be either `true` or `false`. The default is `true`.
        """
        pulumi.set(__self__, "asn_ranges", asn_ranges)
        pulumi.set(__self__, "edge_locations", edge_locations)
        if inside_cidr_blocks is not None:
            pulumi.set(__self__, "inside_cidr_blocks", inside_cidr_blocks)
        if vpn_ecmp_support is not None:
            pulumi.set(__self__, "vpn_ecmp_support", vpn_ecmp_support)

    @property
    @pulumi.getter(name="asnRanges")
    def asn_ranges(self) -> Sequence[str]:
        """
        List of strings containing Autonomous System Numbers (ASNs) to assign to Core Network Edges. By default, the core network automatically assigns an ASN for each Core Network Edge but you can optionally define the ASN in the edge-locations for each Region. The ASN uses an array of integer ranges only from `64512` to `65534` and `4200000000` to `4294967294` expressed as a string like `"64512-65534"`. No other ASN ranges can be used.
        """
        return pulumi.get(self, "asn_ranges")

    @property
    @pulumi.getter(name="edgeLocations")
    def edge_locations(self) -> Sequence['outputs.GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationResult']:
        """
        A block value of AWS Region locations where you're creating Core Network Edges. Detailed below.
        """
        return pulumi.get(self, "edge_locations")

    @property
    @pulumi.getter(name="insideCidrBlocks")
    def inside_cidr_blocks(self) -> Optional[Sequence[str]]:
        """
        The Classless Inter-Domain Routing (CIDR) block range used to create tunnels for AWS Transit Gateway Connect. The format is standard AWS CIDR range (for example, `10.0.1.0/24`). You can optionally define the inside CIDR in the Core Network Edges section per Region. The minimum is a `/24` for IPv4 or `/64` for IPv6. You can provide multiple `/24` subnets or a larger CIDR range. If you define a larger CIDR range, new Core Network Edges will be automatically assigned `/24` and `/64` subnets from the larger CIDR. an Inside CIDR block is required for attaching Connect attachments to a Core Network Edge.
        """
        return pulumi.get(self, "inside_cidr_blocks")

    @property
    @pulumi.getter(name="vpnEcmpSupport")
    def vpn_ecmp_support(self) -> Optional[bool]:
        """
        Indicates whether the core network forwards traffic over multiple equal-cost routes using VPN. The value can be either `true` or `false`. The default is `true`.
        """
        return pulumi.get(self, "vpn_ecmp_support")


@pulumi.output_type
class GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationResult(dict):
    def __init__(__self__, *,
                 location: str,
                 asn: Optional[str] = None,
                 inside_cidr_blocks: Optional[Sequence[str]] = None):
        """
        :param str asn: ASN of the Core Network Edge in an AWS Region. By default, the ASN will be a single integer automatically assigned from `asn_ranges`
        :param Sequence[str] inside_cidr_blocks: The local CIDR blocks for this Core Network Edge for AWS Transit Gateway Connect attachments. By default, this CIDR block will be one or more optional IPv4 and IPv6 CIDR prefixes auto-assigned from `inside_cidr_blocks`.
        """
        pulumi.set(__self__, "location", location)
        if asn is not None:
            pulumi.set(__self__, "asn", asn)
        if inside_cidr_blocks is not None:
            pulumi.set(__self__, "inside_cidr_blocks", inside_cidr_blocks)

    @property
    @pulumi.getter
    def location(self) -> str:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def asn(self) -> Optional[str]:
        """
        ASN of the Core Network Edge in an AWS Region. By default, the ASN will be a single integer automatically assigned from `asn_ranges`
        """
        return pulumi.get(self, "asn")

    @property
    @pulumi.getter(name="insideCidrBlocks")
    def inside_cidr_blocks(self) -> Optional[Sequence[str]]:
        """
        The local CIDR blocks for this Core Network Edge for AWS Transit Gateway Connect attachments. By default, this CIDR block will be one or more optional IPv4 and IPv6 CIDR prefixes auto-assigned from `inside_cidr_blocks`.
        """
        return pulumi.get(self, "inside_cidr_blocks")


@pulumi.output_type
class GetCoreNetworkPolicyDocumentSegmentResult(dict):
    def __init__(__self__, *,
                 name: str,
                 allow_filters: Optional[Sequence[str]] = None,
                 deny_filters: Optional[Sequence[str]] = None,
                 description: Optional[str] = None,
                 edge_locations: Optional[Sequence[str]] = None,
                 isolate_attachments: Optional[bool] = None,
                 require_attachment_acceptance: Optional[bool] = None):
        """
        :param str name: Unique name for a segment. The name is a string used in other parts of the policy document, as well as in the console for metrics and other reference points. Valid characters are a–z, and 0–9.
        :param Sequence[str] allow_filters: List of strings of segment names that explicitly allows only routes from the segments that are listed in the array. Use the `allow_filter` setting if a segment has a well-defined group of other segments that connectivity should be restricted to. It is applied after routes have been shared in `segment_actions`. If a segment is listed in `allow_filter`, attachments between the two segments will have routes if they are also shared in the segment-actions area. For example, you might have a segment named "video-producer" that should only ever share routes with a "video-distributor" segment, no matter how many other share statements are created.
        :param Sequence[str] deny_filters: An array of segments that disallows routes from the segments listed in the array. It is applied only after routes have been shared in `segment_actions`. If a segment is listed in the `deny_filter`, attachments between the two segments will never have routes shared across them. For example, you might have a "financial" payment segment that should never share routes with a "development" segment, regardless of how many other share statements are created. Adding the payments segment to the deny-filter parameter prevents any shared routes from being created with other segments.
        :param str description: A user-defined string describing the segment.
        :param Sequence[str] edge_locations: A list of strings of AWS Region names. Allows you to define a more restrictive set of Regions for a segment. The edge location must be a subset of the locations that are defined for `edge_locations` in the `core_network_configuration`.
        :param bool isolate_attachments: This Boolean setting determines whether attachments on the same segment can communicate with each other. If set to `true`, the only routes available will be either shared routes through the share actions, which are attachments in other segments, or static routes. The default value is `false`. For example, you might have a segment dedicated to "development" that should never allow VPCs to talk to each other, even if they’re on the same segment. In this example, you would keep the default parameter of `false`.
        :param bool require_attachment_acceptance: This Boolean setting determines whether attachment requests are automatically approved or require acceptance. The default is `true`, indicating that attachment requests require acceptance. For example, you might use this setting to allow a "sandbox" segment to allow any attachment request so that a core network or attachment administrator does not need to review and approve attachment requests. In this example, `require_attachment_acceptance` is set to `false`.
        """
        pulumi.set(__self__, "name", name)
        if allow_filters is not None:
            pulumi.set(__self__, "allow_filters", allow_filters)
        if deny_filters is not None:
            pulumi.set(__self__, "deny_filters", deny_filters)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if edge_locations is not None:
            pulumi.set(__self__, "edge_locations", edge_locations)
        if isolate_attachments is not None:
            pulumi.set(__self__, "isolate_attachments", isolate_attachments)
        if require_attachment_acceptance is not None:
            pulumi.set(__self__, "require_attachment_acceptance", require_attachment_acceptance)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Unique name for a segment. The name is a string used in other parts of the policy document, as well as in the console for metrics and other reference points. Valid characters are a–z, and 0–9.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="allowFilters")
    def allow_filters(self) -> Optional[Sequence[str]]:
        """
        List of strings of segment names that explicitly allows only routes from the segments that are listed in the array. Use the `allow_filter` setting if a segment has a well-defined group of other segments that connectivity should be restricted to. It is applied after routes have been shared in `segment_actions`. If a segment is listed in `allow_filter`, attachments between the two segments will have routes if they are also shared in the segment-actions area. For example, you might have a segment named "video-producer" that should only ever share routes with a "video-distributor" segment, no matter how many other share statements are created.
        """
        return pulumi.get(self, "allow_filters")

    @property
    @pulumi.getter(name="denyFilters")
    def deny_filters(self) -> Optional[Sequence[str]]:
        """
        An array of segments that disallows routes from the segments listed in the array. It is applied only after routes have been shared in `segment_actions`. If a segment is listed in the `deny_filter`, attachments between the two segments will never have routes shared across them. For example, you might have a "financial" payment segment that should never share routes with a "development" segment, regardless of how many other share statements are created. Adding the payments segment to the deny-filter parameter prevents any shared routes from being created with other segments.
        """
        return pulumi.get(self, "deny_filters")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A user-defined string describing the segment.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="edgeLocations")
    def edge_locations(self) -> Optional[Sequence[str]]:
        """
        A list of strings of AWS Region names. Allows you to define a more restrictive set of Regions for a segment. The edge location must be a subset of the locations that are defined for `edge_locations` in the `core_network_configuration`.
        """
        return pulumi.get(self, "edge_locations")

    @property
    @pulumi.getter(name="isolateAttachments")
    def isolate_attachments(self) -> Optional[bool]:
        """
        This Boolean setting determines whether attachments on the same segment can communicate with each other. If set to `true`, the only routes available will be either shared routes through the share actions, which are attachments in other segments, or static routes. The default value is `false`. For example, you might have a segment dedicated to "development" that should never allow VPCs to talk to each other, even if they’re on the same segment. In this example, you would keep the default parameter of `false`.
        """
        return pulumi.get(self, "isolate_attachments")

    @property
    @pulumi.getter(name="requireAttachmentAcceptance")
    def require_attachment_acceptance(self) -> Optional[bool]:
        """
        This Boolean setting determines whether attachment requests are automatically approved or require acceptance. The default is `true`, indicating that attachment requests require acceptance. For example, you might use this setting to allow a "sandbox" segment to allow any attachment request so that a core network or attachment administrator does not need to review and approve attachment requests. In this example, `require_attachment_acceptance` is set to `false`.
        """
        return pulumi.get(self, "require_attachment_acceptance")


@pulumi.output_type
class GetCoreNetworkPolicyDocumentSegmentActionResult(dict):
    def __init__(__self__, *,
                 action: str,
                 segment: str,
                 description: Optional[str] = None,
                 destination_cidr_blocks: Optional[Sequence[str]] = None,
                 destinations: Optional[Sequence[str]] = None,
                 mode: Optional[str] = None,
                 share_with_excepts: Optional[Sequence[str]] = None,
                 share_withs: Optional[Sequence[str]] = None):
        """
        :param str action: Action to take for the chosen segment. Valid values `create-route` or `share`.
        :param str segment: Name of the segment.
        :param str description: A user-defined string describing the segment action.
        :param Sequence[str] destination_cidr_blocks: List of strings containing CIDRs. You can define the IPv4 and IPv6 CIDR notation for each AWS Region. For example, `10.1.0.0/16` or `2001:db8::/56`. This is an array of CIDR notation strings.
        :param Sequence[str] destinations: A list of strings. Valid values include `["blackhole"]` or a list of attachment ids.
        :param str mode: String. This mode places the attachment and return routes in each of the `share_with` segments. Valid values include: `attachment-route`.
        :param Sequence[str] share_with_excepts: A set subtraction of segments to not share with.
        :param Sequence[str] share_withs: A list of strings to share with. Must be a substring is all segments. Valid values include: `["*"]` or `["<segment-names>"]`.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "segment", segment)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_cidr_blocks is not None:
            pulumi.set(__self__, "destination_cidr_blocks", destination_cidr_blocks)
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if share_with_excepts is not None:
            pulumi.set(__self__, "share_with_excepts", share_with_excepts)
        if share_withs is not None:
            pulumi.set(__self__, "share_withs", share_withs)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        Action to take for the chosen segment. Valid values `create-route` or `share`.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def segment(self) -> str:
        """
        Name of the segment.
        """
        return pulumi.get(self, "segment")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A user-defined string describing the segment action.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationCidrBlocks")
    def destination_cidr_blocks(self) -> Optional[Sequence[str]]:
        """
        List of strings containing CIDRs. You can define the IPv4 and IPv6 CIDR notation for each AWS Region. For example, `10.1.0.0/16` or `2001:db8::/56`. This is an array of CIDR notation strings.
        """
        return pulumi.get(self, "destination_cidr_blocks")

    @property
    @pulumi.getter
    def destinations(self) -> Optional[Sequence[str]]:
        """
        A list of strings. Valid values include `["blackhole"]` or a list of attachment ids.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        String. This mode places the attachment and return routes in each of the `share_with` segments. Valid values include: `attachment-route`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="shareWithExcepts")
    def share_with_excepts(self) -> Optional[Sequence[str]]:
        """
        A set subtraction of segments to not share with.
        """
        return pulumi.get(self, "share_with_excepts")

    @property
    @pulumi.getter(name="shareWiths")
    def share_withs(self) -> Optional[Sequence[str]]:
        """
        A list of strings to share with. Must be a substring is all segments. Valid values include: `["*"]` or `["<segment-names>"]`.
        """
        return pulumi.get(self, "share_withs")


@pulumi.output_type
class GetDeviceAwsLocationResult(dict):
    def __init__(__self__, *,
                 subnet_arn: str,
                 zone: str):
        """
        :param str subnet_arn: ARN of the subnet that the device is located in.
        :param str zone: Zone that the device is located in.
        """
        pulumi.set(__self__, "subnet_arn", subnet_arn)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="subnetArn")
    def subnet_arn(self) -> str:
        """
        ARN of the subnet that the device is located in.
        """
        return pulumi.get(self, "subnet_arn")

    @property
    @pulumi.getter
    def zone(self) -> str:
        """
        Zone that the device is located in.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetDeviceLocationResult(dict):
    def __init__(__self__, *,
                 address: str,
                 latitude: str,
                 longitude: str):
        """
        :param str address: Physical address.
        :param str latitude: Latitude.
        :param str longitude: Longitude.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "latitude", latitude)
        pulumi.set(__self__, "longitude", longitude)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        Physical address.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def latitude(self) -> str:
        """
        Latitude.
        """
        return pulumi.get(self, "latitude")

    @property
    @pulumi.getter
    def longitude(self) -> str:
        """
        Longitude.
        """
        return pulumi.get(self, "longitude")


@pulumi.output_type
class GetLinkBandwidthResult(dict):
    def __init__(__self__, *,
                 download_speed: int,
                 upload_speed: int):
        """
        :param int download_speed: Download speed in Mbps.
        :param int upload_speed: Upload speed in Mbps.
        """
        pulumi.set(__self__, "download_speed", download_speed)
        pulumi.set(__self__, "upload_speed", upload_speed)

    @property
    @pulumi.getter(name="downloadSpeed")
    def download_speed(self) -> int:
        """
        Download speed in Mbps.
        """
        return pulumi.get(self, "download_speed")

    @property
    @pulumi.getter(name="uploadSpeed")
    def upload_speed(self) -> int:
        """
        Upload speed in Mbps.
        """
        return pulumi.get(self, "upload_speed")


@pulumi.output_type
class GetSiteLocationResult(dict):
    def __init__(__self__, *,
                 address: str,
                 latitude: str,
                 longitude: str):
        """
        :param str address: Address of the location.
        :param str latitude: Latitude of the location.
        :param str longitude: Longitude of the location.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "latitude", latitude)
        pulumi.set(__self__, "longitude", longitude)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        Address of the location.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def latitude(self) -> str:
        """
        Latitude of the location.
        """
        return pulumi.get(self, "latitude")

    @property
    @pulumi.getter
    def longitude(self) -> str:
        """
        Longitude of the location.
        """
        return pulumi.get(self, "longitude")


