# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['LinkArgs', 'Link']

@pulumi.input_type
class LinkArgs:
    def __init__(__self__, *,
                 label_template: pulumi.Input[str],
                 resource_types: pulumi.Input[Sequence[pulumi.Input[str]]],
                 sink_identifier: pulumi.Input[str],
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Link resource.
        :param pulumi.Input[str] label_template: Human-readable name to use to identify this source account when you are viewing data from it in the monitoring account.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resource_types: Types of data that the source account shares with the monitoring account.
        :param pulumi.Input[str] sink_identifier: Identifier of the sink to use to create this link.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "label_template", label_template)
        pulumi.set(__self__, "resource_types", resource_types)
        pulumi.set(__self__, "sink_identifier", sink_identifier)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="labelTemplate")
    def label_template(self) -> pulumi.Input[str]:
        """
        Human-readable name to use to identify this source account when you are viewing data from it in the monitoring account.
        """
        return pulumi.get(self, "label_template")

    @label_template.setter
    def label_template(self, value: pulumi.Input[str]):
        pulumi.set(self, "label_template", value)

    @property
    @pulumi.getter(name="resourceTypes")
    def resource_types(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Types of data that the source account shares with the monitoring account.
        """
        return pulumi.get(self, "resource_types")

    @resource_types.setter
    def resource_types(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "resource_types", value)

    @property
    @pulumi.getter(name="sinkIdentifier")
    def sink_identifier(self) -> pulumi.Input[str]:
        """
        Identifier of the sink to use to create this link.

        The following arguments are optional:
        """
        return pulumi.get(self, "sink_identifier")

    @sink_identifier.setter
    def sink_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "sink_identifier", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _LinkState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 label_template: Optional[pulumi.Input[str]] = None,
                 link_id: Optional[pulumi.Input[str]] = None,
                 resource_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sink_arn: Optional[pulumi.Input[str]] = None,
                 sink_identifier: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering Link resources.
        :param pulumi.Input[str] arn: ARN of the link.
        :param pulumi.Input[str] label: Label that is assigned to this link.
        :param pulumi.Input[str] label_template: Human-readable name to use to identify this source account when you are viewing data from it in the monitoring account.
        :param pulumi.Input[str] link_id: ID string that AWS generated as part of the link ARN.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resource_types: Types of data that the source account shares with the monitoring account.
        :param pulumi.Input[str] sink_arn: ARN of the sink that is used for this link.
        :param pulumi.Input[str] sink_identifier: Identifier of the sink to use to create this link.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if label_template is not None:
            pulumi.set(__self__, "label_template", label_template)
        if link_id is not None:
            pulumi.set(__self__, "link_id", link_id)
        if resource_types is not None:
            pulumi.set(__self__, "resource_types", resource_types)
        if sink_arn is not None:
            pulumi.set(__self__, "sink_arn", sink_arn)
        if sink_identifier is not None:
            pulumi.set(__self__, "sink_identifier", sink_identifier)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the link.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        Label that is assigned to this link.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="labelTemplate")
    def label_template(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable name to use to identify this source account when you are viewing data from it in the monitoring account.
        """
        return pulumi.get(self, "label_template")

    @label_template.setter
    def label_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label_template", value)

    @property
    @pulumi.getter(name="linkId")
    def link_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID string that AWS generated as part of the link ARN.
        """
        return pulumi.get(self, "link_id")

    @link_id.setter
    def link_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "link_id", value)

    @property
    @pulumi.getter(name="resourceTypes")
    def resource_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Types of data that the source account shares with the monitoring account.
        """
        return pulumi.get(self, "resource_types")

    @resource_types.setter
    def resource_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "resource_types", value)

    @property
    @pulumi.getter(name="sinkArn")
    def sink_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the sink that is used for this link.
        """
        return pulumi.get(self, "sink_arn")

    @sink_arn.setter
    def sink_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sink_arn", value)

    @property
    @pulumi.getter(name="sinkIdentifier")
    def sink_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the sink to use to create this link.

        The following arguments are optional:
        """
        return pulumi.get(self, "sink_identifier")

    @sink_identifier.setter
    def sink_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sink_identifier", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)


class Link(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 label_template: Optional[pulumi.Input[str]] = None,
                 resource_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sink_identifier: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Resource for managing an AWS CloudWatch Observability Access Manager Link.

        ## Example Usage
        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.oam.Link("example",
            label_template="$AccountName",
            resource_types=["AWS::CloudWatch::Metric"],
            sink_identifier=aws_oam_sink["test"]["id"],
            tags={
                "Env": "prod",
            })
        ```

        ## Import

        Using `pulumi import`, import CloudWatch Observability Access Manager Link using the `arn`. For example:

        ```sh
         $ pulumi import aws:oam/link:Link example arn:aws:oam:us-west-2:123456789012:link/link-id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] label_template: Human-readable name to use to identify this source account when you are viewing data from it in the monitoring account.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resource_types: Types of data that the source account shares with the monitoring account.
        :param pulumi.Input[str] sink_identifier: Identifier of the sink to use to create this link.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LinkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS CloudWatch Observability Access Manager Link.

        ## Example Usage
        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.oam.Link("example",
            label_template="$AccountName",
            resource_types=["AWS::CloudWatch::Metric"],
            sink_identifier=aws_oam_sink["test"]["id"],
            tags={
                "Env": "prod",
            })
        ```

        ## Import

        Using `pulumi import`, import CloudWatch Observability Access Manager Link using the `arn`. For example:

        ```sh
         $ pulumi import aws:oam/link:Link example arn:aws:oam:us-west-2:123456789012:link/link-id
        ```

        :param str resource_name: The name of the resource.
        :param LinkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LinkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 label_template: Optional[pulumi.Input[str]] = None,
                 resource_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sink_identifier: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LinkArgs.__new__(LinkArgs)

            if label_template is None and not opts.urn:
                raise TypeError("Missing required property 'label_template'")
            __props__.__dict__["label_template"] = label_template
            if resource_types is None and not opts.urn:
                raise TypeError("Missing required property 'resource_types'")
            __props__.__dict__["resource_types"] = resource_types
            if sink_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'sink_identifier'")
            __props__.__dict__["sink_identifier"] = sink_identifier
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["label"] = None
            __props__.__dict__["link_id"] = None
            __props__.__dict__["sink_arn"] = None
            __props__.__dict__["tags_all"] = None
        super(Link, __self__).__init__(
            'aws:oam/link:Link',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            label: Optional[pulumi.Input[str]] = None,
            label_template: Optional[pulumi.Input[str]] = None,
            link_id: Optional[pulumi.Input[str]] = None,
            resource_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            sink_arn: Optional[pulumi.Input[str]] = None,
            sink_identifier: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None) -> 'Link':
        """
        Get an existing Link resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: ARN of the link.
        :param pulumi.Input[str] label: Label that is assigned to this link.
        :param pulumi.Input[str] label_template: Human-readable name to use to identify this source account when you are viewing data from it in the monitoring account.
        :param pulumi.Input[str] link_id: ID string that AWS generated as part of the link ARN.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resource_types: Types of data that the source account shares with the monitoring account.
        :param pulumi.Input[str] sink_arn: ARN of the sink that is used for this link.
        :param pulumi.Input[str] sink_identifier: Identifier of the sink to use to create this link.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LinkState.__new__(_LinkState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["label"] = label
        __props__.__dict__["label_template"] = label_template
        __props__.__dict__["link_id"] = link_id
        __props__.__dict__["resource_types"] = resource_types
        __props__.__dict__["sink_arn"] = sink_arn
        __props__.__dict__["sink_identifier"] = sink_identifier
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return Link(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        ARN of the link.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def label(self) -> pulumi.Output[str]:
        """
        Label that is assigned to this link.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="labelTemplate")
    def label_template(self) -> pulumi.Output[str]:
        """
        Human-readable name to use to identify this source account when you are viewing data from it in the monitoring account.
        """
        return pulumi.get(self, "label_template")

    @property
    @pulumi.getter(name="linkId")
    def link_id(self) -> pulumi.Output[str]:
        """
        ID string that AWS generated as part of the link ARN.
        """
        return pulumi.get(self, "link_id")

    @property
    @pulumi.getter(name="resourceTypes")
    def resource_types(self) -> pulumi.Output[Sequence[str]]:
        """
        Types of data that the source account shares with the monitoring account.
        """
        return pulumi.get(self, "resource_types")

    @property
    @pulumi.getter(name="sinkArn")
    def sink_arn(self) -> pulumi.Output[str]:
        """
        ARN of the sink that is used for this link.
        """
        return pulumi.get(self, "sink_arn")

    @property
    @pulumi.getter(name="sinkIdentifier")
    def sink_identifier(self) -> pulumi.Output[str]:
        """
        Identifier of the sink to use to create this link.

        The following arguments are optional:
        """
        return pulumi.get(self, "sink_identifier")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        return pulumi.get(self, "tags_all")

