# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DomainArgs', 'Domain']

@pulumi.input_type
class DomainArgs:
    def __init__(__self__, *,
                 access_policies: Optional[pulumi.Input[str]] = None,
                 advanced_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 advanced_security_options: Optional[pulumi.Input['DomainAdvancedSecurityOptionsArgs']] = None,
                 auto_tune_options: Optional[pulumi.Input['DomainAutoTuneOptionsArgs']] = None,
                 cluster_config: Optional[pulumi.Input['DomainClusterConfigArgs']] = None,
                 cognito_options: Optional[pulumi.Input['DomainCognitoOptionsArgs']] = None,
                 domain_endpoint_options: Optional[pulumi.Input['DomainDomainEndpointOptionsArgs']] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 ebs_options: Optional[pulumi.Input['DomainEbsOptionsArgs']] = None,
                 encrypt_at_rest: Optional[pulumi.Input['DomainEncryptAtRestArgs']] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 log_publishing_options: Optional[pulumi.Input[Sequence[pulumi.Input['DomainLogPublishingOptionArgs']]]] = None,
                 node_to_node_encryption: Optional[pulumi.Input['DomainNodeToNodeEncryptionArgs']] = None,
                 off_peak_window_options: Optional[pulumi.Input['DomainOffPeakWindowOptionsArgs']] = None,
                 snapshot_options: Optional[pulumi.Input['DomainSnapshotOptionsArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_options: Optional[pulumi.Input['DomainVpcOptionsArgs']] = None):
        """
        The set of arguments for constructing a Domain resource.
        :param pulumi.Input[str] access_policies: IAM policy document specifying the access policies for the domain.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] advanced_options: Key-value string pairs to specify advanced configuration options. Note that the values for these configuration options must be strings (wrapped in quotes) or they may be wrong and cause a perpetual diff, causing the provider to want to recreate your OpenSearch domain on every apply.
        :param pulumi.Input['DomainAdvancedSecurityOptionsArgs'] advanced_security_options: Configuration block for [fine-grained access control](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html). Detailed below.
        :param pulumi.Input['DomainAutoTuneOptionsArgs'] auto_tune_options: Configuration block for the Auto-Tune options of the domain. Detailed below.
        :param pulumi.Input['DomainClusterConfigArgs'] cluster_config: Configuration block for the cluster of the domain. Detailed below.
        :param pulumi.Input['DomainCognitoOptionsArgs'] cognito_options: Configuration block for authenticating dashboard with Cognito. Detailed below.
        :param pulumi.Input['DomainDomainEndpointOptionsArgs'] domain_endpoint_options: Configuration block for domain endpoint HTTP(S) related options. Detailed below.
        :param pulumi.Input[str] domain_name: Name of the domain.
               
               The following arguments are optional:
        :param pulumi.Input['DomainEbsOptionsArgs'] ebs_options: Configuration block for EBS related options, may be required based on chosen [instance size](https://aws.amazon.com/opensearch-service/pricing/). Detailed below.
        :param pulumi.Input['DomainEncryptAtRestArgs'] encrypt_at_rest: Configuration block for encrypt at rest options. Only available for [certain instance types](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/encryption-at-rest.html). Detailed below.
        :param pulumi.Input[str] engine_version: Either `Elasticsearch_X.Y` or `OpenSearch_X.Y` to specify the engine version for the Amazon OpenSearch Service domain. For example, `OpenSearch_1.0` or `Elasticsearch_7.9`.
               See [Creating and managing Amazon OpenSearch Service domains](http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomains).
               Defaults to the lastest version of OpenSearch.
        :param pulumi.Input[Sequence[pulumi.Input['DomainLogPublishingOptionArgs']]] log_publishing_options: Configuration block for publishing slow and application logs to CloudWatch Logs. This block can be declared multiple times, for each log_type, within the same resource. Detailed below.
        :param pulumi.Input['DomainNodeToNodeEncryptionArgs'] node_to_node_encryption: Configuration block for node-to-node encryption options. Detailed below.
        :param pulumi.Input['DomainOffPeakWindowOptionsArgs'] off_peak_window_options: Configuration to add Off Peak update options. ([documentation](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/off-peak.html)). Detailed below.
        :param pulumi.Input['DomainSnapshotOptionsArgs'] snapshot_options: Configuration block for snapshot related options. Detailed below. DEPRECATED. For domains running OpenSearch 5.3 and later, Amazon OpenSearch takes hourly automated snapshots, making this setting irrelevant. For domains running earlier versions, OpenSearch takes daily automated snapshots.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input['DomainVpcOptionsArgs'] vpc_options: Configuration block for VPC related options. Adding or removing this configuration forces a new resource ([documentation](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html)). Detailed below.
        """
        if access_policies is not None:
            pulumi.set(__self__, "access_policies", access_policies)
        if advanced_options is not None:
            pulumi.set(__self__, "advanced_options", advanced_options)
        if advanced_security_options is not None:
            pulumi.set(__self__, "advanced_security_options", advanced_security_options)
        if auto_tune_options is not None:
            pulumi.set(__self__, "auto_tune_options", auto_tune_options)
        if cluster_config is not None:
            pulumi.set(__self__, "cluster_config", cluster_config)
        if cognito_options is not None:
            pulumi.set(__self__, "cognito_options", cognito_options)
        if domain_endpoint_options is not None:
            pulumi.set(__self__, "domain_endpoint_options", domain_endpoint_options)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if ebs_options is not None:
            pulumi.set(__self__, "ebs_options", ebs_options)
        if encrypt_at_rest is not None:
            pulumi.set(__self__, "encrypt_at_rest", encrypt_at_rest)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if log_publishing_options is not None:
            pulumi.set(__self__, "log_publishing_options", log_publishing_options)
        if node_to_node_encryption is not None:
            pulumi.set(__self__, "node_to_node_encryption", node_to_node_encryption)
        if off_peak_window_options is not None:
            pulumi.set(__self__, "off_peak_window_options", off_peak_window_options)
        if snapshot_options is not None:
            pulumi.set(__self__, "snapshot_options", snapshot_options)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_options is not None:
            pulumi.set(__self__, "vpc_options", vpc_options)

    @property
    @pulumi.getter(name="accessPolicies")
    def access_policies(self) -> Optional[pulumi.Input[str]]:
        """
        IAM policy document specifying the access policies for the domain.
        """
        return pulumi.get(self, "access_policies")

    @access_policies.setter
    def access_policies(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_policies", value)

    @property
    @pulumi.getter(name="advancedOptions")
    def advanced_options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value string pairs to specify advanced configuration options. Note that the values for these configuration options must be strings (wrapped in quotes) or they may be wrong and cause a perpetual diff, causing the provider to want to recreate your OpenSearch domain on every apply.
        """
        return pulumi.get(self, "advanced_options")

    @advanced_options.setter
    def advanced_options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "advanced_options", value)

    @property
    @pulumi.getter(name="advancedSecurityOptions")
    def advanced_security_options(self) -> Optional[pulumi.Input['DomainAdvancedSecurityOptionsArgs']]:
        """
        Configuration block for [fine-grained access control](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html). Detailed below.
        """
        return pulumi.get(self, "advanced_security_options")

    @advanced_security_options.setter
    def advanced_security_options(self, value: Optional[pulumi.Input['DomainAdvancedSecurityOptionsArgs']]):
        pulumi.set(self, "advanced_security_options", value)

    @property
    @pulumi.getter(name="autoTuneOptions")
    def auto_tune_options(self) -> Optional[pulumi.Input['DomainAutoTuneOptionsArgs']]:
        """
        Configuration block for the Auto-Tune options of the domain. Detailed below.
        """
        return pulumi.get(self, "auto_tune_options")

    @auto_tune_options.setter
    def auto_tune_options(self, value: Optional[pulumi.Input['DomainAutoTuneOptionsArgs']]):
        pulumi.set(self, "auto_tune_options", value)

    @property
    @pulumi.getter(name="clusterConfig")
    def cluster_config(self) -> Optional[pulumi.Input['DomainClusterConfigArgs']]:
        """
        Configuration block for the cluster of the domain. Detailed below.
        """
        return pulumi.get(self, "cluster_config")

    @cluster_config.setter
    def cluster_config(self, value: Optional[pulumi.Input['DomainClusterConfigArgs']]):
        pulumi.set(self, "cluster_config", value)

    @property
    @pulumi.getter(name="cognitoOptions")
    def cognito_options(self) -> Optional[pulumi.Input['DomainCognitoOptionsArgs']]:
        """
        Configuration block for authenticating dashboard with Cognito. Detailed below.
        """
        return pulumi.get(self, "cognito_options")

    @cognito_options.setter
    def cognito_options(self, value: Optional[pulumi.Input['DomainCognitoOptionsArgs']]):
        pulumi.set(self, "cognito_options", value)

    @property
    @pulumi.getter(name="domainEndpointOptions")
    def domain_endpoint_options(self) -> Optional[pulumi.Input['DomainDomainEndpointOptionsArgs']]:
        """
        Configuration block for domain endpoint HTTP(S) related options. Detailed below.
        """
        return pulumi.get(self, "domain_endpoint_options")

    @domain_endpoint_options.setter
    def domain_endpoint_options(self, value: Optional[pulumi.Input['DomainDomainEndpointOptionsArgs']]):
        pulumi.set(self, "domain_endpoint_options", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the domain.

        The following arguments are optional:
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="ebsOptions")
    def ebs_options(self) -> Optional[pulumi.Input['DomainEbsOptionsArgs']]:
        """
        Configuration block for EBS related options, may be required based on chosen [instance size](https://aws.amazon.com/opensearch-service/pricing/). Detailed below.
        """
        return pulumi.get(self, "ebs_options")

    @ebs_options.setter
    def ebs_options(self, value: Optional[pulumi.Input['DomainEbsOptionsArgs']]):
        pulumi.set(self, "ebs_options", value)

    @property
    @pulumi.getter(name="encryptAtRest")
    def encrypt_at_rest(self) -> Optional[pulumi.Input['DomainEncryptAtRestArgs']]:
        """
        Configuration block for encrypt at rest options. Only available for [certain instance types](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/encryption-at-rest.html). Detailed below.
        """
        return pulumi.get(self, "encrypt_at_rest")

    @encrypt_at_rest.setter
    def encrypt_at_rest(self, value: Optional[pulumi.Input['DomainEncryptAtRestArgs']]):
        pulumi.set(self, "encrypt_at_rest", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[str]]:
        """
        Either `Elasticsearch_X.Y` or `OpenSearch_X.Y` to specify the engine version for the Amazon OpenSearch Service domain. For example, `OpenSearch_1.0` or `Elasticsearch_7.9`.
        See [Creating and managing Amazon OpenSearch Service domains](http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomains).
        Defaults to the lastest version of OpenSearch.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="logPublishingOptions")
    def log_publishing_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainLogPublishingOptionArgs']]]]:
        """
        Configuration block for publishing slow and application logs to CloudWatch Logs. This block can be declared multiple times, for each log_type, within the same resource. Detailed below.
        """
        return pulumi.get(self, "log_publishing_options")

    @log_publishing_options.setter
    def log_publishing_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainLogPublishingOptionArgs']]]]):
        pulumi.set(self, "log_publishing_options", value)

    @property
    @pulumi.getter(name="nodeToNodeEncryption")
    def node_to_node_encryption(self) -> Optional[pulumi.Input['DomainNodeToNodeEncryptionArgs']]:
        """
        Configuration block for node-to-node encryption options. Detailed below.
        """
        return pulumi.get(self, "node_to_node_encryption")

    @node_to_node_encryption.setter
    def node_to_node_encryption(self, value: Optional[pulumi.Input['DomainNodeToNodeEncryptionArgs']]):
        pulumi.set(self, "node_to_node_encryption", value)

    @property
    @pulumi.getter(name="offPeakWindowOptions")
    def off_peak_window_options(self) -> Optional[pulumi.Input['DomainOffPeakWindowOptionsArgs']]:
        """
        Configuration to add Off Peak update options. ([documentation](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/off-peak.html)). Detailed below.
        """
        return pulumi.get(self, "off_peak_window_options")

    @off_peak_window_options.setter
    def off_peak_window_options(self, value: Optional[pulumi.Input['DomainOffPeakWindowOptionsArgs']]):
        pulumi.set(self, "off_peak_window_options", value)

    @property
    @pulumi.getter(name="snapshotOptions")
    def snapshot_options(self) -> Optional[pulumi.Input['DomainSnapshotOptionsArgs']]:
        """
        Configuration block for snapshot related options. Detailed below. DEPRECATED. For domains running OpenSearch 5.3 and later, Amazon OpenSearch takes hourly automated snapshots, making this setting irrelevant. For domains running earlier versions, OpenSearch takes daily automated snapshots.
        """
        return pulumi.get(self, "snapshot_options")

    @snapshot_options.setter
    def snapshot_options(self, value: Optional[pulumi.Input['DomainSnapshotOptionsArgs']]):
        pulumi.set(self, "snapshot_options", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpcOptions")
    def vpc_options(self) -> Optional[pulumi.Input['DomainVpcOptionsArgs']]:
        """
        Configuration block for VPC related options. Adding or removing this configuration forces a new resource ([documentation](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html)). Detailed below.
        """
        return pulumi.get(self, "vpc_options")

    @vpc_options.setter
    def vpc_options(self, value: Optional[pulumi.Input['DomainVpcOptionsArgs']]):
        pulumi.set(self, "vpc_options", value)


@pulumi.input_type
class _DomainState:
    def __init__(__self__, *,
                 access_policies: Optional[pulumi.Input[str]] = None,
                 advanced_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 advanced_security_options: Optional[pulumi.Input['DomainAdvancedSecurityOptionsArgs']] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 auto_tune_options: Optional[pulumi.Input['DomainAutoTuneOptionsArgs']] = None,
                 cluster_config: Optional[pulumi.Input['DomainClusterConfigArgs']] = None,
                 cognito_options: Optional[pulumi.Input['DomainCognitoOptionsArgs']] = None,
                 dashboard_endpoint: Optional[pulumi.Input[str]] = None,
                 domain_endpoint_options: Optional[pulumi.Input['DomainDomainEndpointOptionsArgs']] = None,
                 domain_id: Optional[pulumi.Input[str]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 ebs_options: Optional[pulumi.Input['DomainEbsOptionsArgs']] = None,
                 encrypt_at_rest: Optional[pulumi.Input['DomainEncryptAtRestArgs']] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 kibana_endpoint: Optional[pulumi.Input[str]] = None,
                 log_publishing_options: Optional[pulumi.Input[Sequence[pulumi.Input['DomainLogPublishingOptionArgs']]]] = None,
                 node_to_node_encryption: Optional[pulumi.Input['DomainNodeToNodeEncryptionArgs']] = None,
                 off_peak_window_options: Optional[pulumi.Input['DomainOffPeakWindowOptionsArgs']] = None,
                 snapshot_options: Optional[pulumi.Input['DomainSnapshotOptionsArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_options: Optional[pulumi.Input['DomainVpcOptionsArgs']] = None):
        """
        Input properties used for looking up and filtering Domain resources.
        :param pulumi.Input[str] access_policies: IAM policy document specifying the access policies for the domain.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] advanced_options: Key-value string pairs to specify advanced configuration options. Note that the values for these configuration options must be strings (wrapped in quotes) or they may be wrong and cause a perpetual diff, causing the provider to want to recreate your OpenSearch domain on every apply.
        :param pulumi.Input['DomainAdvancedSecurityOptionsArgs'] advanced_security_options: Configuration block for [fine-grained access control](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html). Detailed below.
        :param pulumi.Input[str] arn: ARN of the domain.
        :param pulumi.Input['DomainAutoTuneOptionsArgs'] auto_tune_options: Configuration block for the Auto-Tune options of the domain. Detailed below.
        :param pulumi.Input['DomainClusterConfigArgs'] cluster_config: Configuration block for the cluster of the domain. Detailed below.
        :param pulumi.Input['DomainCognitoOptionsArgs'] cognito_options: Configuration block for authenticating dashboard with Cognito. Detailed below.
        :param pulumi.Input[str] dashboard_endpoint: Domain-specific endpoint for Dashboard without https scheme.
        :param pulumi.Input['DomainDomainEndpointOptionsArgs'] domain_endpoint_options: Configuration block for domain endpoint HTTP(S) related options. Detailed below.
        :param pulumi.Input[str] domain_id: Unique identifier for the domain.
        :param pulumi.Input[str] domain_name: Name of the domain.
               
               The following arguments are optional:
        :param pulumi.Input['DomainEbsOptionsArgs'] ebs_options: Configuration block for EBS related options, may be required based on chosen [instance size](https://aws.amazon.com/opensearch-service/pricing/). Detailed below.
        :param pulumi.Input['DomainEncryptAtRestArgs'] encrypt_at_rest: Configuration block for encrypt at rest options. Only available for [certain instance types](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/encryption-at-rest.html). Detailed below.
        :param pulumi.Input[str] endpoint: Domain-specific endpoint used to submit index, search, and data upload requests.
        :param pulumi.Input[str] engine_version: Either `Elasticsearch_X.Y` or `OpenSearch_X.Y` to specify the engine version for the Amazon OpenSearch Service domain. For example, `OpenSearch_1.0` or `Elasticsearch_7.9`.
               See [Creating and managing Amazon OpenSearch Service domains](http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomains).
               Defaults to the lastest version of OpenSearch.
        :param pulumi.Input[str] kibana_endpoint: (**Deprecated**) Domain-specific endpoint for kibana without https scheme. Use the `dashboard_endpoint` attribute instead.
        :param pulumi.Input[Sequence[pulumi.Input['DomainLogPublishingOptionArgs']]] log_publishing_options: Configuration block for publishing slow and application logs to CloudWatch Logs. This block can be declared multiple times, for each log_type, within the same resource. Detailed below.
        :param pulumi.Input['DomainNodeToNodeEncryptionArgs'] node_to_node_encryption: Configuration block for node-to-node encryption options. Detailed below.
        :param pulumi.Input['DomainOffPeakWindowOptionsArgs'] off_peak_window_options: Configuration to add Off Peak update options. ([documentation](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/off-peak.html)). Detailed below.
        :param pulumi.Input['DomainSnapshotOptionsArgs'] snapshot_options: Configuration block for snapshot related options. Detailed below. DEPRECATED. For domains running OpenSearch 5.3 and later, Amazon OpenSearch takes hourly automated snapshots, making this setting irrelevant. For domains running earlier versions, OpenSearch takes daily automated snapshots.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
               * `vpc_options.0.availability_zones` - If the domain was created inside a VPC, the names of the availability zones the configured `subnet_ids` were created inside.
               * `vpc_options.0.vpc_id` - If the domain was created inside a VPC, the ID of the VPC.
        :param pulumi.Input['DomainVpcOptionsArgs'] vpc_options: Configuration block for VPC related options. Adding or removing this configuration forces a new resource ([documentation](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html)). Detailed below.
        """
        if access_policies is not None:
            pulumi.set(__self__, "access_policies", access_policies)
        if advanced_options is not None:
            pulumi.set(__self__, "advanced_options", advanced_options)
        if advanced_security_options is not None:
            pulumi.set(__self__, "advanced_security_options", advanced_security_options)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if auto_tune_options is not None:
            pulumi.set(__self__, "auto_tune_options", auto_tune_options)
        if cluster_config is not None:
            pulumi.set(__self__, "cluster_config", cluster_config)
        if cognito_options is not None:
            pulumi.set(__self__, "cognito_options", cognito_options)
        if dashboard_endpoint is not None:
            pulumi.set(__self__, "dashboard_endpoint", dashboard_endpoint)
        if domain_endpoint_options is not None:
            pulumi.set(__self__, "domain_endpoint_options", domain_endpoint_options)
        if domain_id is not None:
            pulumi.set(__self__, "domain_id", domain_id)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if ebs_options is not None:
            pulumi.set(__self__, "ebs_options", ebs_options)
        if encrypt_at_rest is not None:
            pulumi.set(__self__, "encrypt_at_rest", encrypt_at_rest)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if kibana_endpoint is not None:
            warnings.warn("""use 'dashboard_endpoint' attribute instead""", DeprecationWarning)
            pulumi.log.warn("""kibana_endpoint is deprecated: use 'dashboard_endpoint' attribute instead""")
        if kibana_endpoint is not None:
            pulumi.set(__self__, "kibana_endpoint", kibana_endpoint)
        if log_publishing_options is not None:
            pulumi.set(__self__, "log_publishing_options", log_publishing_options)
        if node_to_node_encryption is not None:
            pulumi.set(__self__, "node_to_node_encryption", node_to_node_encryption)
        if off_peak_window_options is not None:
            pulumi.set(__self__, "off_peak_window_options", off_peak_window_options)
        if snapshot_options is not None:
            pulumi.set(__self__, "snapshot_options", snapshot_options)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if vpc_options is not None:
            pulumi.set(__self__, "vpc_options", vpc_options)

    @property
    @pulumi.getter(name="accessPolicies")
    def access_policies(self) -> Optional[pulumi.Input[str]]:
        """
        IAM policy document specifying the access policies for the domain.
        """
        return pulumi.get(self, "access_policies")

    @access_policies.setter
    def access_policies(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_policies", value)

    @property
    @pulumi.getter(name="advancedOptions")
    def advanced_options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value string pairs to specify advanced configuration options. Note that the values for these configuration options must be strings (wrapped in quotes) or they may be wrong and cause a perpetual diff, causing the provider to want to recreate your OpenSearch domain on every apply.
        """
        return pulumi.get(self, "advanced_options")

    @advanced_options.setter
    def advanced_options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "advanced_options", value)

    @property
    @pulumi.getter(name="advancedSecurityOptions")
    def advanced_security_options(self) -> Optional[pulumi.Input['DomainAdvancedSecurityOptionsArgs']]:
        """
        Configuration block for [fine-grained access control](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html). Detailed below.
        """
        return pulumi.get(self, "advanced_security_options")

    @advanced_security_options.setter
    def advanced_security_options(self, value: Optional[pulumi.Input['DomainAdvancedSecurityOptionsArgs']]):
        pulumi.set(self, "advanced_security_options", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the domain.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="autoTuneOptions")
    def auto_tune_options(self) -> Optional[pulumi.Input['DomainAutoTuneOptionsArgs']]:
        """
        Configuration block for the Auto-Tune options of the domain. Detailed below.
        """
        return pulumi.get(self, "auto_tune_options")

    @auto_tune_options.setter
    def auto_tune_options(self, value: Optional[pulumi.Input['DomainAutoTuneOptionsArgs']]):
        pulumi.set(self, "auto_tune_options", value)

    @property
    @pulumi.getter(name="clusterConfig")
    def cluster_config(self) -> Optional[pulumi.Input['DomainClusterConfigArgs']]:
        """
        Configuration block for the cluster of the domain. Detailed below.
        """
        return pulumi.get(self, "cluster_config")

    @cluster_config.setter
    def cluster_config(self, value: Optional[pulumi.Input['DomainClusterConfigArgs']]):
        pulumi.set(self, "cluster_config", value)

    @property
    @pulumi.getter(name="cognitoOptions")
    def cognito_options(self) -> Optional[pulumi.Input['DomainCognitoOptionsArgs']]:
        """
        Configuration block for authenticating dashboard with Cognito. Detailed below.
        """
        return pulumi.get(self, "cognito_options")

    @cognito_options.setter
    def cognito_options(self, value: Optional[pulumi.Input['DomainCognitoOptionsArgs']]):
        pulumi.set(self, "cognito_options", value)

    @property
    @pulumi.getter(name="dashboardEndpoint")
    def dashboard_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        Domain-specific endpoint for Dashboard without https scheme.
        """
        return pulumi.get(self, "dashboard_endpoint")

    @dashboard_endpoint.setter
    def dashboard_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dashboard_endpoint", value)

    @property
    @pulumi.getter(name="domainEndpointOptions")
    def domain_endpoint_options(self) -> Optional[pulumi.Input['DomainDomainEndpointOptionsArgs']]:
        """
        Configuration block for domain endpoint HTTP(S) related options. Detailed below.
        """
        return pulumi.get(self, "domain_endpoint_options")

    @domain_endpoint_options.setter
    def domain_endpoint_options(self, value: Optional[pulumi.Input['DomainDomainEndpointOptionsArgs']]):
        pulumi.set(self, "domain_endpoint_options", value)

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier for the domain.
        """
        return pulumi.get(self, "domain_id")

    @domain_id.setter
    def domain_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_id", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the domain.

        The following arguments are optional:
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="ebsOptions")
    def ebs_options(self) -> Optional[pulumi.Input['DomainEbsOptionsArgs']]:
        """
        Configuration block for EBS related options, may be required based on chosen [instance size](https://aws.amazon.com/opensearch-service/pricing/). Detailed below.
        """
        return pulumi.get(self, "ebs_options")

    @ebs_options.setter
    def ebs_options(self, value: Optional[pulumi.Input['DomainEbsOptionsArgs']]):
        pulumi.set(self, "ebs_options", value)

    @property
    @pulumi.getter(name="encryptAtRest")
    def encrypt_at_rest(self) -> Optional[pulumi.Input['DomainEncryptAtRestArgs']]:
        """
        Configuration block for encrypt at rest options. Only available for [certain instance types](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/encryption-at-rest.html). Detailed below.
        """
        return pulumi.get(self, "encrypt_at_rest")

    @encrypt_at_rest.setter
    def encrypt_at_rest(self, value: Optional[pulumi.Input['DomainEncryptAtRestArgs']]):
        pulumi.set(self, "encrypt_at_rest", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        Domain-specific endpoint used to submit index, search, and data upload requests.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[str]]:
        """
        Either `Elasticsearch_X.Y` or `OpenSearch_X.Y` to specify the engine version for the Amazon OpenSearch Service domain. For example, `OpenSearch_1.0` or `Elasticsearch_7.9`.
        See [Creating and managing Amazon OpenSearch Service domains](http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomains).
        Defaults to the lastest version of OpenSearch.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="kibanaEndpoint")
    def kibana_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        (**Deprecated**) Domain-specific endpoint for kibana without https scheme. Use the `dashboard_endpoint` attribute instead.
        """
        warnings.warn("""use 'dashboard_endpoint' attribute instead""", DeprecationWarning)
        pulumi.log.warn("""kibana_endpoint is deprecated: use 'dashboard_endpoint' attribute instead""")

        return pulumi.get(self, "kibana_endpoint")

    @kibana_endpoint.setter
    def kibana_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kibana_endpoint", value)

    @property
    @pulumi.getter(name="logPublishingOptions")
    def log_publishing_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainLogPublishingOptionArgs']]]]:
        """
        Configuration block for publishing slow and application logs to CloudWatch Logs. This block can be declared multiple times, for each log_type, within the same resource. Detailed below.
        """
        return pulumi.get(self, "log_publishing_options")

    @log_publishing_options.setter
    def log_publishing_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainLogPublishingOptionArgs']]]]):
        pulumi.set(self, "log_publishing_options", value)

    @property
    @pulumi.getter(name="nodeToNodeEncryption")
    def node_to_node_encryption(self) -> Optional[pulumi.Input['DomainNodeToNodeEncryptionArgs']]:
        """
        Configuration block for node-to-node encryption options. Detailed below.
        """
        return pulumi.get(self, "node_to_node_encryption")

    @node_to_node_encryption.setter
    def node_to_node_encryption(self, value: Optional[pulumi.Input['DomainNodeToNodeEncryptionArgs']]):
        pulumi.set(self, "node_to_node_encryption", value)

    @property
    @pulumi.getter(name="offPeakWindowOptions")
    def off_peak_window_options(self) -> Optional[pulumi.Input['DomainOffPeakWindowOptionsArgs']]:
        """
        Configuration to add Off Peak update options. ([documentation](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/off-peak.html)). Detailed below.
        """
        return pulumi.get(self, "off_peak_window_options")

    @off_peak_window_options.setter
    def off_peak_window_options(self, value: Optional[pulumi.Input['DomainOffPeakWindowOptionsArgs']]):
        pulumi.set(self, "off_peak_window_options", value)

    @property
    @pulumi.getter(name="snapshotOptions")
    def snapshot_options(self) -> Optional[pulumi.Input['DomainSnapshotOptionsArgs']]:
        """
        Configuration block for snapshot related options. Detailed below. DEPRECATED. For domains running OpenSearch 5.3 and later, Amazon OpenSearch takes hourly automated snapshots, making this setting irrelevant. For domains running earlier versions, OpenSearch takes daily automated snapshots.
        """
        return pulumi.get(self, "snapshot_options")

    @snapshot_options.setter
    def snapshot_options(self, value: Optional[pulumi.Input['DomainSnapshotOptionsArgs']]):
        pulumi.set(self, "snapshot_options", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        * `vpc_options.0.availability_zones` - If the domain was created inside a VPC, the names of the availability zones the configured `subnet_ids` were created inside.
        * `vpc_options.0.vpc_id` - If the domain was created inside a VPC, the ID of the VPC.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="vpcOptions")
    def vpc_options(self) -> Optional[pulumi.Input['DomainVpcOptionsArgs']]:
        """
        Configuration block for VPC related options. Adding or removing this configuration forces a new resource ([documentation](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html)). Detailed below.
        """
        return pulumi.get(self, "vpc_options")

    @vpc_options.setter
    def vpc_options(self, value: Optional[pulumi.Input['DomainVpcOptionsArgs']]):
        pulumi.set(self, "vpc_options", value)


class Domain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_policies: Optional[pulumi.Input[str]] = None,
                 advanced_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 advanced_security_options: Optional[pulumi.Input[pulumi.InputType['DomainAdvancedSecurityOptionsArgs']]] = None,
                 auto_tune_options: Optional[pulumi.Input[pulumi.InputType['DomainAutoTuneOptionsArgs']]] = None,
                 cluster_config: Optional[pulumi.Input[pulumi.InputType['DomainClusterConfigArgs']]] = None,
                 cognito_options: Optional[pulumi.Input[pulumi.InputType['DomainCognitoOptionsArgs']]] = None,
                 domain_endpoint_options: Optional[pulumi.Input[pulumi.InputType['DomainDomainEndpointOptionsArgs']]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 ebs_options: Optional[pulumi.Input[pulumi.InputType['DomainEbsOptionsArgs']]] = None,
                 encrypt_at_rest: Optional[pulumi.Input[pulumi.InputType['DomainEncryptAtRestArgs']]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 log_publishing_options: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainLogPublishingOptionArgs']]]]] = None,
                 node_to_node_encryption: Optional[pulumi.Input[pulumi.InputType['DomainNodeToNodeEncryptionArgs']]] = None,
                 off_peak_window_options: Optional[pulumi.Input[pulumi.InputType['DomainOffPeakWindowOptionsArgs']]] = None,
                 snapshot_options: Optional[pulumi.Input[pulumi.InputType['DomainSnapshotOptionsArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_options: Optional[pulumi.Input[pulumi.InputType['DomainVpcOptionsArgs']]] = None,
                 __props__=None):
        """
        Manages an Amazon OpenSearch Domain.

        ## Elasticsearch vs. OpenSearch

        Amazon OpenSearch Service is the successor to Amazon Elasticsearch Service and supports OpenSearch and legacy Elasticsearch OSS (up to 7.10, the final open source version of the software).

        OpenSearch Domain configurations are similar in many ways to Elasticsearch Domain configurations. However, there are important differences including these:

        * OpenSearch has `engine_version` while Elasticsearch has `elasticsearch_version`
        * Versions are specified differently - _e.g._, `Elasticsearch_7.10` with OpenSearch vs. `7.10` for Elasticsearch.
        * `instance_type` argument values end in `search` for OpenSearch vs. `elasticsearch` for Elasticsearch (_e.g._, `t2.micro.search` vs. `t2.micro.elasticsearch`).
        * The AWS-managed service-linked role for OpenSearch is called `AWSServiceRoleForAmazonOpenSearchService` instead of `AWSServiceRoleForAmazonElasticsearchService` for Elasticsearch.

        There are also some potentially unexpected similarities in configurations:

        * ARNs for both are prefaced with `arn:aws:es:`.
        * Both OpenSearch and Elasticsearch use assume role policies that refer to the `Principal` `Service` as `es.amazonaws.com`.
        * IAM policy actions, such as those you will find in `access_policies`, are prefaced with `es:` for both.

        ## Example Usage
        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.opensearch.Domain("example",
            cluster_config=aws.opensearch.DomainClusterConfigArgs(
                instance_type="r4.large.search",
            ),
            engine_version="Elasticsearch_7.10",
            tags={
                "Domain": "TestDomain",
            })
        ```
        ### Access Policy

        > See also: `opensearch.DomainPolicy` resource

        ```python
        import pulumi
        import pulumi_aws as aws

        config = pulumi.Config()
        domain = config.get("domain")
        if domain is None:
            domain = "tf-test"
        current_region = aws.get_region()
        current_caller_identity = aws.get_caller_identity()
        example_policy_document = aws.iam.get_policy_document(statements=[aws.iam.GetPolicyDocumentStatementArgs(
            effect="Allow",
            principals=[aws.iam.GetPolicyDocumentStatementPrincipalArgs(
                type="*",
                identifiers=["*"],
            )],
            actions=["es:*"],
            resources=[f"arn:aws:es:{current_region.name}:{current_caller_identity.account_id}:domain/{domain}/*"],
            conditions=[aws.iam.GetPolicyDocumentStatementConditionArgs(
                test="IpAddress",
                variable="aws:SourceIp",
                values=["66.193.100.22/32"],
            )],
        )])
        example_domain = aws.opensearch.Domain("exampleDomain", access_policies=example_policy_document.json)
        ```
        ### Log publishing to CloudWatch Logs

        ```python
        import pulumi
        import pulumi_aws as aws

        example_log_group = aws.cloudwatch.LogGroup("exampleLogGroup")
        example_policy_document = aws.iam.get_policy_document(statements=[aws.iam.GetPolicyDocumentStatementArgs(
            effect="Allow",
            principals=[aws.iam.GetPolicyDocumentStatementPrincipalArgs(
                type="Service",
                identifiers=["es.amazonaws.com"],
            )],
            actions=[
                "logs:PutLogEvents",
                "logs:PutLogEventsBatch",
                "logs:CreateLogStream",
            ],
            resources=["arn:aws:logs:*"],
        )])
        example_log_resource_policy = aws.cloudwatch.LogResourcePolicy("exampleLogResourcePolicy",
            policy_name="example",
            policy_document=example_policy_document.json)
        # .. other configuration ...
        example_domain = aws.opensearch.Domain("exampleDomain", log_publishing_options=[aws.opensearch.DomainLogPublishingOptionArgs(
            cloudwatch_log_group_arn=example_log_group.arn,
            log_type="INDEX_SLOW_LOGS",
        )])
        ```
        ### VPC based OpenSearch

        ```python
        import pulumi
        import pulumi_aws as aws

        config = pulumi.Config()
        vpc = config.require_object("vpc")
        domain = config.get("domain")
        if domain is None:
            domain = "tf-test"
        example_vpc = aws.ec2.get_vpc(tags={
            "Name": vpc,
        })
        example_subnets = aws.ec2.get_subnets(filters=[aws.ec2.GetSubnetsFilterArgs(
                name="vpc-id",
                values=[example_vpc.id],
            )],
            tags={
                "Tier": "private",
            })
        current_region = aws.get_region()
        current_caller_identity = aws.get_caller_identity()
        example_security_group = aws.ec2.SecurityGroup("exampleSecurityGroup",
            description="Managed by Pulumi",
            vpc_id=example_vpc.id,
            ingress=[aws.ec2.SecurityGroupIngressArgs(
                from_port=443,
                to_port=443,
                protocol="tcp",
                cidr_blocks=[example_vpc.cidr_block],
            )])
        example_service_linked_role = aws.iam.ServiceLinkedRole("exampleServiceLinkedRole", aws_service_name="opensearchservice.amazonaws.com")
        example_policy_document = aws.iam.get_policy_document(statements=[aws.iam.GetPolicyDocumentStatementArgs(
            effect="Allow",
            principals=[aws.iam.GetPolicyDocumentStatementPrincipalArgs(
                type="*",
                identifiers=["*"],
            )],
            actions=["es:*"],
            resources=[f"arn:aws:es:{current_region.name}:{current_caller_identity.account_id}:domain/{domain}/*"],
        )])
        example_domain = aws.opensearch.Domain("exampleDomain",
            engine_version="OpenSearch_1.0",
            cluster_config=aws.opensearch.DomainClusterConfigArgs(
                instance_type="m4.large.search",
                zone_awareness_enabled=True,
            ),
            vpc_options=aws.opensearch.DomainVpcOptionsArgs(
                subnet_ids=[
                    example_subnets.ids[0],
                    example_subnets.ids[1],
                ],
                security_group_ids=[example_security_group.id],
            ),
            advanced_options={
                "rest.action.multi.allow_explicit_index": "true",
            },
            access_policies=example_policy_document.json,
            tags={
                "Domain": "TestDomain",
            },
            opts=pulumi.ResourceOptions(depends_on=[example_service_linked_role]))
        ```
        ### Enabling fine-grained access control on an existing domain

        This example shows two configurations: one to create a domain without fine-grained access control and the second to modify the domain to enable fine-grained access control. For more information, see [Enabling fine-grained access control](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html).
        ### First apply

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.opensearch.Domain("example",
            advanced_security_options=aws.opensearch.DomainAdvancedSecurityOptionsArgs(
                anonymous_auth_enabled=True,
                enabled=False,
                internal_user_database_enabled=True,
                master_user_options=aws.opensearch.DomainAdvancedSecurityOptionsMasterUserOptionsArgs(
                    master_user_name="example",
                    master_user_password="Barbarbarbar1!",
                ),
            ),
            cluster_config=aws.opensearch.DomainClusterConfigArgs(
                instance_type="r5.large.search",
            ),
            domain_endpoint_options=aws.opensearch.DomainDomainEndpointOptionsArgs(
                enforce_https=True,
                tls_security_policy="Policy-Min-TLS-1-2-2019-07",
            ),
            ebs_options=aws.opensearch.DomainEbsOptionsArgs(
                ebs_enabled=True,
                volume_size=10,
            ),
            encrypt_at_rest=aws.opensearch.DomainEncryptAtRestArgs(
                enabled=True,
            ),
            engine_version="Elasticsearch_7.1",
            node_to_node_encryption=aws.opensearch.DomainNodeToNodeEncryptionArgs(
                enabled=True,
            ))
        ```
        ### Second apply

        Notice that the only change is `advanced_security_options.0.enabled` is now set to `true`.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.opensearch.Domain("example",
            advanced_security_options=aws.opensearch.DomainAdvancedSecurityOptionsArgs(
                anonymous_auth_enabled=True,
                enabled=True,
                internal_user_database_enabled=True,
                master_user_options=aws.opensearch.DomainAdvancedSecurityOptionsMasterUserOptionsArgs(
                    master_user_name="example",
                    master_user_password="Barbarbarbar1!",
                ),
            ),
            cluster_config=aws.opensearch.DomainClusterConfigArgs(
                instance_type="r5.large.search",
            ),
            domain_endpoint_options=aws.opensearch.DomainDomainEndpointOptionsArgs(
                enforce_https=True,
                tls_security_policy="Policy-Min-TLS-1-2-2019-07",
            ),
            ebs_options=aws.opensearch.DomainEbsOptionsArgs(
                ebs_enabled=True,
                volume_size=10,
            ),
            encrypt_at_rest=aws.opensearch.DomainEncryptAtRestArgs(
                enabled=True,
            ),
            engine_version="Elasticsearch_7.1",
            node_to_node_encryption=aws.opensearch.DomainNodeToNodeEncryptionArgs(
                enabled=True,
            ))
        ```

        ## Import

        Using `pulumi import`, import OpenSearch domains using the `domain_name`. For example:

        ```sh
         $ pulumi import aws:opensearch/domain:Domain example domain_name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_policies: IAM policy document specifying the access policies for the domain.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] advanced_options: Key-value string pairs to specify advanced configuration options. Note that the values for these configuration options must be strings (wrapped in quotes) or they may be wrong and cause a perpetual diff, causing the provider to want to recreate your OpenSearch domain on every apply.
        :param pulumi.Input[pulumi.InputType['DomainAdvancedSecurityOptionsArgs']] advanced_security_options: Configuration block for [fine-grained access control](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html). Detailed below.
        :param pulumi.Input[pulumi.InputType['DomainAutoTuneOptionsArgs']] auto_tune_options: Configuration block for the Auto-Tune options of the domain. Detailed below.
        :param pulumi.Input[pulumi.InputType['DomainClusterConfigArgs']] cluster_config: Configuration block for the cluster of the domain. Detailed below.
        :param pulumi.Input[pulumi.InputType['DomainCognitoOptionsArgs']] cognito_options: Configuration block for authenticating dashboard with Cognito. Detailed below.
        :param pulumi.Input[pulumi.InputType['DomainDomainEndpointOptionsArgs']] domain_endpoint_options: Configuration block for domain endpoint HTTP(S) related options. Detailed below.
        :param pulumi.Input[str] domain_name: Name of the domain.
               
               The following arguments are optional:
        :param pulumi.Input[pulumi.InputType['DomainEbsOptionsArgs']] ebs_options: Configuration block for EBS related options, may be required based on chosen [instance size](https://aws.amazon.com/opensearch-service/pricing/). Detailed below.
        :param pulumi.Input[pulumi.InputType['DomainEncryptAtRestArgs']] encrypt_at_rest: Configuration block for encrypt at rest options. Only available for [certain instance types](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/encryption-at-rest.html). Detailed below.
        :param pulumi.Input[str] engine_version: Either `Elasticsearch_X.Y` or `OpenSearch_X.Y` to specify the engine version for the Amazon OpenSearch Service domain. For example, `OpenSearch_1.0` or `Elasticsearch_7.9`.
               See [Creating and managing Amazon OpenSearch Service domains](http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomains).
               Defaults to the lastest version of OpenSearch.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainLogPublishingOptionArgs']]]] log_publishing_options: Configuration block for publishing slow and application logs to CloudWatch Logs. This block can be declared multiple times, for each log_type, within the same resource. Detailed below.
        :param pulumi.Input[pulumi.InputType['DomainNodeToNodeEncryptionArgs']] node_to_node_encryption: Configuration block for node-to-node encryption options. Detailed below.
        :param pulumi.Input[pulumi.InputType['DomainOffPeakWindowOptionsArgs']] off_peak_window_options: Configuration to add Off Peak update options. ([documentation](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/off-peak.html)). Detailed below.
        :param pulumi.Input[pulumi.InputType['DomainSnapshotOptionsArgs']] snapshot_options: Configuration block for snapshot related options. Detailed below. DEPRECATED. For domains running OpenSearch 5.3 and later, Amazon OpenSearch takes hourly automated snapshots, making this setting irrelevant. For domains running earlier versions, OpenSearch takes daily automated snapshots.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[pulumi.InputType['DomainVpcOptionsArgs']] vpc_options: Configuration block for VPC related options. Adding or removing this configuration forces a new resource ([documentation](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html)). Detailed below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[DomainArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Amazon OpenSearch Domain.

        ## Elasticsearch vs. OpenSearch

        Amazon OpenSearch Service is the successor to Amazon Elasticsearch Service and supports OpenSearch and legacy Elasticsearch OSS (up to 7.10, the final open source version of the software).

        OpenSearch Domain configurations are similar in many ways to Elasticsearch Domain configurations. However, there are important differences including these:

        * OpenSearch has `engine_version` while Elasticsearch has `elasticsearch_version`
        * Versions are specified differently - _e.g._, `Elasticsearch_7.10` with OpenSearch vs. `7.10` for Elasticsearch.
        * `instance_type` argument values end in `search` for OpenSearch vs. `elasticsearch` for Elasticsearch (_e.g._, `t2.micro.search` vs. `t2.micro.elasticsearch`).
        * The AWS-managed service-linked role for OpenSearch is called `AWSServiceRoleForAmazonOpenSearchService` instead of `AWSServiceRoleForAmazonElasticsearchService` for Elasticsearch.

        There are also some potentially unexpected similarities in configurations:

        * ARNs for both are prefaced with `arn:aws:es:`.
        * Both OpenSearch and Elasticsearch use assume role policies that refer to the `Principal` `Service` as `es.amazonaws.com`.
        * IAM policy actions, such as those you will find in `access_policies`, are prefaced with `es:` for both.

        ## Example Usage
        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.opensearch.Domain("example",
            cluster_config=aws.opensearch.DomainClusterConfigArgs(
                instance_type="r4.large.search",
            ),
            engine_version="Elasticsearch_7.10",
            tags={
                "Domain": "TestDomain",
            })
        ```
        ### Access Policy

        > See also: `opensearch.DomainPolicy` resource

        ```python
        import pulumi
        import pulumi_aws as aws

        config = pulumi.Config()
        domain = config.get("domain")
        if domain is None:
            domain = "tf-test"
        current_region = aws.get_region()
        current_caller_identity = aws.get_caller_identity()
        example_policy_document = aws.iam.get_policy_document(statements=[aws.iam.GetPolicyDocumentStatementArgs(
            effect="Allow",
            principals=[aws.iam.GetPolicyDocumentStatementPrincipalArgs(
                type="*",
                identifiers=["*"],
            )],
            actions=["es:*"],
            resources=[f"arn:aws:es:{current_region.name}:{current_caller_identity.account_id}:domain/{domain}/*"],
            conditions=[aws.iam.GetPolicyDocumentStatementConditionArgs(
                test="IpAddress",
                variable="aws:SourceIp",
                values=["66.193.100.22/32"],
            )],
        )])
        example_domain = aws.opensearch.Domain("exampleDomain", access_policies=example_policy_document.json)
        ```
        ### Log publishing to CloudWatch Logs

        ```python
        import pulumi
        import pulumi_aws as aws

        example_log_group = aws.cloudwatch.LogGroup("exampleLogGroup")
        example_policy_document = aws.iam.get_policy_document(statements=[aws.iam.GetPolicyDocumentStatementArgs(
            effect="Allow",
            principals=[aws.iam.GetPolicyDocumentStatementPrincipalArgs(
                type="Service",
                identifiers=["es.amazonaws.com"],
            )],
            actions=[
                "logs:PutLogEvents",
                "logs:PutLogEventsBatch",
                "logs:CreateLogStream",
            ],
            resources=["arn:aws:logs:*"],
        )])
        example_log_resource_policy = aws.cloudwatch.LogResourcePolicy("exampleLogResourcePolicy",
            policy_name="example",
            policy_document=example_policy_document.json)
        # .. other configuration ...
        example_domain = aws.opensearch.Domain("exampleDomain", log_publishing_options=[aws.opensearch.DomainLogPublishingOptionArgs(
            cloudwatch_log_group_arn=example_log_group.arn,
            log_type="INDEX_SLOW_LOGS",
        )])
        ```
        ### VPC based OpenSearch

        ```python
        import pulumi
        import pulumi_aws as aws

        config = pulumi.Config()
        vpc = config.require_object("vpc")
        domain = config.get("domain")
        if domain is None:
            domain = "tf-test"
        example_vpc = aws.ec2.get_vpc(tags={
            "Name": vpc,
        })
        example_subnets = aws.ec2.get_subnets(filters=[aws.ec2.GetSubnetsFilterArgs(
                name="vpc-id",
                values=[example_vpc.id],
            )],
            tags={
                "Tier": "private",
            })
        current_region = aws.get_region()
        current_caller_identity = aws.get_caller_identity()
        example_security_group = aws.ec2.SecurityGroup("exampleSecurityGroup",
            description="Managed by Pulumi",
            vpc_id=example_vpc.id,
            ingress=[aws.ec2.SecurityGroupIngressArgs(
                from_port=443,
                to_port=443,
                protocol="tcp",
                cidr_blocks=[example_vpc.cidr_block],
            )])
        example_service_linked_role = aws.iam.ServiceLinkedRole("exampleServiceLinkedRole", aws_service_name="opensearchservice.amazonaws.com")
        example_policy_document = aws.iam.get_policy_document(statements=[aws.iam.GetPolicyDocumentStatementArgs(
            effect="Allow",
            principals=[aws.iam.GetPolicyDocumentStatementPrincipalArgs(
                type="*",
                identifiers=["*"],
            )],
            actions=["es:*"],
            resources=[f"arn:aws:es:{current_region.name}:{current_caller_identity.account_id}:domain/{domain}/*"],
        )])
        example_domain = aws.opensearch.Domain("exampleDomain",
            engine_version="OpenSearch_1.0",
            cluster_config=aws.opensearch.DomainClusterConfigArgs(
                instance_type="m4.large.search",
                zone_awareness_enabled=True,
            ),
            vpc_options=aws.opensearch.DomainVpcOptionsArgs(
                subnet_ids=[
                    example_subnets.ids[0],
                    example_subnets.ids[1],
                ],
                security_group_ids=[example_security_group.id],
            ),
            advanced_options={
                "rest.action.multi.allow_explicit_index": "true",
            },
            access_policies=example_policy_document.json,
            tags={
                "Domain": "TestDomain",
            },
            opts=pulumi.ResourceOptions(depends_on=[example_service_linked_role]))
        ```
        ### Enabling fine-grained access control on an existing domain

        This example shows two configurations: one to create a domain without fine-grained access control and the second to modify the domain to enable fine-grained access control. For more information, see [Enabling fine-grained access control](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html).
        ### First apply

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.opensearch.Domain("example",
            advanced_security_options=aws.opensearch.DomainAdvancedSecurityOptionsArgs(
                anonymous_auth_enabled=True,
                enabled=False,
                internal_user_database_enabled=True,
                master_user_options=aws.opensearch.DomainAdvancedSecurityOptionsMasterUserOptionsArgs(
                    master_user_name="example",
                    master_user_password="Barbarbarbar1!",
                ),
            ),
            cluster_config=aws.opensearch.DomainClusterConfigArgs(
                instance_type="r5.large.search",
            ),
            domain_endpoint_options=aws.opensearch.DomainDomainEndpointOptionsArgs(
                enforce_https=True,
                tls_security_policy="Policy-Min-TLS-1-2-2019-07",
            ),
            ebs_options=aws.opensearch.DomainEbsOptionsArgs(
                ebs_enabled=True,
                volume_size=10,
            ),
            encrypt_at_rest=aws.opensearch.DomainEncryptAtRestArgs(
                enabled=True,
            ),
            engine_version="Elasticsearch_7.1",
            node_to_node_encryption=aws.opensearch.DomainNodeToNodeEncryptionArgs(
                enabled=True,
            ))
        ```
        ### Second apply

        Notice that the only change is `advanced_security_options.0.enabled` is now set to `true`.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.opensearch.Domain("example",
            advanced_security_options=aws.opensearch.DomainAdvancedSecurityOptionsArgs(
                anonymous_auth_enabled=True,
                enabled=True,
                internal_user_database_enabled=True,
                master_user_options=aws.opensearch.DomainAdvancedSecurityOptionsMasterUserOptionsArgs(
                    master_user_name="example",
                    master_user_password="Barbarbarbar1!",
                ),
            ),
            cluster_config=aws.opensearch.DomainClusterConfigArgs(
                instance_type="r5.large.search",
            ),
            domain_endpoint_options=aws.opensearch.DomainDomainEndpointOptionsArgs(
                enforce_https=True,
                tls_security_policy="Policy-Min-TLS-1-2-2019-07",
            ),
            ebs_options=aws.opensearch.DomainEbsOptionsArgs(
                ebs_enabled=True,
                volume_size=10,
            ),
            encrypt_at_rest=aws.opensearch.DomainEncryptAtRestArgs(
                enabled=True,
            ),
            engine_version="Elasticsearch_7.1",
            node_to_node_encryption=aws.opensearch.DomainNodeToNodeEncryptionArgs(
                enabled=True,
            ))
        ```

        ## Import

        Using `pulumi import`, import OpenSearch domains using the `domain_name`. For example:

        ```sh
         $ pulumi import aws:opensearch/domain:Domain example domain_name
        ```

        :param str resource_name: The name of the resource.
        :param DomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_policies: Optional[pulumi.Input[str]] = None,
                 advanced_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 advanced_security_options: Optional[pulumi.Input[pulumi.InputType['DomainAdvancedSecurityOptionsArgs']]] = None,
                 auto_tune_options: Optional[pulumi.Input[pulumi.InputType['DomainAutoTuneOptionsArgs']]] = None,
                 cluster_config: Optional[pulumi.Input[pulumi.InputType['DomainClusterConfigArgs']]] = None,
                 cognito_options: Optional[pulumi.Input[pulumi.InputType['DomainCognitoOptionsArgs']]] = None,
                 domain_endpoint_options: Optional[pulumi.Input[pulumi.InputType['DomainDomainEndpointOptionsArgs']]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 ebs_options: Optional[pulumi.Input[pulumi.InputType['DomainEbsOptionsArgs']]] = None,
                 encrypt_at_rest: Optional[pulumi.Input[pulumi.InputType['DomainEncryptAtRestArgs']]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 log_publishing_options: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainLogPublishingOptionArgs']]]]] = None,
                 node_to_node_encryption: Optional[pulumi.Input[pulumi.InputType['DomainNodeToNodeEncryptionArgs']]] = None,
                 off_peak_window_options: Optional[pulumi.Input[pulumi.InputType['DomainOffPeakWindowOptionsArgs']]] = None,
                 snapshot_options: Optional[pulumi.Input[pulumi.InputType['DomainSnapshotOptionsArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_options: Optional[pulumi.Input[pulumi.InputType['DomainVpcOptionsArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainArgs.__new__(DomainArgs)

            __props__.__dict__["access_policies"] = access_policies
            __props__.__dict__["advanced_options"] = advanced_options
            __props__.__dict__["advanced_security_options"] = advanced_security_options
            __props__.__dict__["auto_tune_options"] = auto_tune_options
            __props__.__dict__["cluster_config"] = cluster_config
            __props__.__dict__["cognito_options"] = cognito_options
            __props__.__dict__["domain_endpoint_options"] = domain_endpoint_options
            __props__.__dict__["domain_name"] = domain_name
            __props__.__dict__["ebs_options"] = ebs_options
            __props__.__dict__["encrypt_at_rest"] = encrypt_at_rest
            __props__.__dict__["engine_version"] = engine_version
            __props__.__dict__["log_publishing_options"] = log_publishing_options
            __props__.__dict__["node_to_node_encryption"] = node_to_node_encryption
            __props__.__dict__["off_peak_window_options"] = off_peak_window_options
            __props__.__dict__["snapshot_options"] = snapshot_options
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpc_options"] = vpc_options
            __props__.__dict__["arn"] = None
            __props__.__dict__["dashboard_endpoint"] = None
            __props__.__dict__["domain_id"] = None
            __props__.__dict__["endpoint"] = None
            __props__.__dict__["kibana_endpoint"] = None
            __props__.__dict__["tags_all"] = None
        super(Domain, __self__).__init__(
            'aws:opensearch/domain:Domain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_policies: Optional[pulumi.Input[str]] = None,
            advanced_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            advanced_security_options: Optional[pulumi.Input[pulumi.InputType['DomainAdvancedSecurityOptionsArgs']]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            auto_tune_options: Optional[pulumi.Input[pulumi.InputType['DomainAutoTuneOptionsArgs']]] = None,
            cluster_config: Optional[pulumi.Input[pulumi.InputType['DomainClusterConfigArgs']]] = None,
            cognito_options: Optional[pulumi.Input[pulumi.InputType['DomainCognitoOptionsArgs']]] = None,
            dashboard_endpoint: Optional[pulumi.Input[str]] = None,
            domain_endpoint_options: Optional[pulumi.Input[pulumi.InputType['DomainDomainEndpointOptionsArgs']]] = None,
            domain_id: Optional[pulumi.Input[str]] = None,
            domain_name: Optional[pulumi.Input[str]] = None,
            ebs_options: Optional[pulumi.Input[pulumi.InputType['DomainEbsOptionsArgs']]] = None,
            encrypt_at_rest: Optional[pulumi.Input[pulumi.InputType['DomainEncryptAtRestArgs']]] = None,
            endpoint: Optional[pulumi.Input[str]] = None,
            engine_version: Optional[pulumi.Input[str]] = None,
            kibana_endpoint: Optional[pulumi.Input[str]] = None,
            log_publishing_options: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainLogPublishingOptionArgs']]]]] = None,
            node_to_node_encryption: Optional[pulumi.Input[pulumi.InputType['DomainNodeToNodeEncryptionArgs']]] = None,
            off_peak_window_options: Optional[pulumi.Input[pulumi.InputType['DomainOffPeakWindowOptionsArgs']]] = None,
            snapshot_options: Optional[pulumi.Input[pulumi.InputType['DomainSnapshotOptionsArgs']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            vpc_options: Optional[pulumi.Input[pulumi.InputType['DomainVpcOptionsArgs']]] = None) -> 'Domain':
        """
        Get an existing Domain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_policies: IAM policy document specifying the access policies for the domain.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] advanced_options: Key-value string pairs to specify advanced configuration options. Note that the values for these configuration options must be strings (wrapped in quotes) or they may be wrong and cause a perpetual diff, causing the provider to want to recreate your OpenSearch domain on every apply.
        :param pulumi.Input[pulumi.InputType['DomainAdvancedSecurityOptionsArgs']] advanced_security_options: Configuration block for [fine-grained access control](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html). Detailed below.
        :param pulumi.Input[str] arn: ARN of the domain.
        :param pulumi.Input[pulumi.InputType['DomainAutoTuneOptionsArgs']] auto_tune_options: Configuration block for the Auto-Tune options of the domain. Detailed below.
        :param pulumi.Input[pulumi.InputType['DomainClusterConfigArgs']] cluster_config: Configuration block for the cluster of the domain. Detailed below.
        :param pulumi.Input[pulumi.InputType['DomainCognitoOptionsArgs']] cognito_options: Configuration block for authenticating dashboard with Cognito. Detailed below.
        :param pulumi.Input[str] dashboard_endpoint: Domain-specific endpoint for Dashboard without https scheme.
        :param pulumi.Input[pulumi.InputType['DomainDomainEndpointOptionsArgs']] domain_endpoint_options: Configuration block for domain endpoint HTTP(S) related options. Detailed below.
        :param pulumi.Input[str] domain_id: Unique identifier for the domain.
        :param pulumi.Input[str] domain_name: Name of the domain.
               
               The following arguments are optional:
        :param pulumi.Input[pulumi.InputType['DomainEbsOptionsArgs']] ebs_options: Configuration block for EBS related options, may be required based on chosen [instance size](https://aws.amazon.com/opensearch-service/pricing/). Detailed below.
        :param pulumi.Input[pulumi.InputType['DomainEncryptAtRestArgs']] encrypt_at_rest: Configuration block for encrypt at rest options. Only available for [certain instance types](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/encryption-at-rest.html). Detailed below.
        :param pulumi.Input[str] endpoint: Domain-specific endpoint used to submit index, search, and data upload requests.
        :param pulumi.Input[str] engine_version: Either `Elasticsearch_X.Y` or `OpenSearch_X.Y` to specify the engine version for the Amazon OpenSearch Service domain. For example, `OpenSearch_1.0` or `Elasticsearch_7.9`.
               See [Creating and managing Amazon OpenSearch Service domains](http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomains).
               Defaults to the lastest version of OpenSearch.
        :param pulumi.Input[str] kibana_endpoint: (**Deprecated**) Domain-specific endpoint for kibana without https scheme. Use the `dashboard_endpoint` attribute instead.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainLogPublishingOptionArgs']]]] log_publishing_options: Configuration block for publishing slow and application logs to CloudWatch Logs. This block can be declared multiple times, for each log_type, within the same resource. Detailed below.
        :param pulumi.Input[pulumi.InputType['DomainNodeToNodeEncryptionArgs']] node_to_node_encryption: Configuration block for node-to-node encryption options. Detailed below.
        :param pulumi.Input[pulumi.InputType['DomainOffPeakWindowOptionsArgs']] off_peak_window_options: Configuration to add Off Peak update options. ([documentation](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/off-peak.html)). Detailed below.
        :param pulumi.Input[pulumi.InputType['DomainSnapshotOptionsArgs']] snapshot_options: Configuration block for snapshot related options. Detailed below. DEPRECATED. For domains running OpenSearch 5.3 and later, Amazon OpenSearch takes hourly automated snapshots, making this setting irrelevant. For domains running earlier versions, OpenSearch takes daily automated snapshots.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
               * `vpc_options.0.availability_zones` - If the domain was created inside a VPC, the names of the availability zones the configured `subnet_ids` were created inside.
               * `vpc_options.0.vpc_id` - If the domain was created inside a VPC, the ID of the VPC.
        :param pulumi.Input[pulumi.InputType['DomainVpcOptionsArgs']] vpc_options: Configuration block for VPC related options. Adding or removing this configuration forces a new resource ([documentation](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html)). Detailed below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainState.__new__(_DomainState)

        __props__.__dict__["access_policies"] = access_policies
        __props__.__dict__["advanced_options"] = advanced_options
        __props__.__dict__["advanced_security_options"] = advanced_security_options
        __props__.__dict__["arn"] = arn
        __props__.__dict__["auto_tune_options"] = auto_tune_options
        __props__.__dict__["cluster_config"] = cluster_config
        __props__.__dict__["cognito_options"] = cognito_options
        __props__.__dict__["dashboard_endpoint"] = dashboard_endpoint
        __props__.__dict__["domain_endpoint_options"] = domain_endpoint_options
        __props__.__dict__["domain_id"] = domain_id
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["ebs_options"] = ebs_options
        __props__.__dict__["encrypt_at_rest"] = encrypt_at_rest
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["engine_version"] = engine_version
        __props__.__dict__["kibana_endpoint"] = kibana_endpoint
        __props__.__dict__["log_publishing_options"] = log_publishing_options
        __props__.__dict__["node_to_node_encryption"] = node_to_node_encryption
        __props__.__dict__["off_peak_window_options"] = off_peak_window_options
        __props__.__dict__["snapshot_options"] = snapshot_options
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["vpc_options"] = vpc_options
        return Domain(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessPolicies")
    def access_policies(self) -> pulumi.Output[str]:
        """
        IAM policy document specifying the access policies for the domain.
        """
        return pulumi.get(self, "access_policies")

    @property
    @pulumi.getter(name="advancedOptions")
    def advanced_options(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Key-value string pairs to specify advanced configuration options. Note that the values for these configuration options must be strings (wrapped in quotes) or they may be wrong and cause a perpetual diff, causing the provider to want to recreate your OpenSearch domain on every apply.
        """
        return pulumi.get(self, "advanced_options")

    @property
    @pulumi.getter(name="advancedSecurityOptions")
    def advanced_security_options(self) -> pulumi.Output['outputs.DomainAdvancedSecurityOptions']:
        """
        Configuration block for [fine-grained access control](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html). Detailed below.
        """
        return pulumi.get(self, "advanced_security_options")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        ARN of the domain.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="autoTuneOptions")
    def auto_tune_options(self) -> pulumi.Output['outputs.DomainAutoTuneOptions']:
        """
        Configuration block for the Auto-Tune options of the domain. Detailed below.
        """
        return pulumi.get(self, "auto_tune_options")

    @property
    @pulumi.getter(name="clusterConfig")
    def cluster_config(self) -> pulumi.Output['outputs.DomainClusterConfig']:
        """
        Configuration block for the cluster of the domain. Detailed below.
        """
        return pulumi.get(self, "cluster_config")

    @property
    @pulumi.getter(name="cognitoOptions")
    def cognito_options(self) -> pulumi.Output[Optional['outputs.DomainCognitoOptions']]:
        """
        Configuration block for authenticating dashboard with Cognito. Detailed below.
        """
        return pulumi.get(self, "cognito_options")

    @property
    @pulumi.getter(name="dashboardEndpoint")
    def dashboard_endpoint(self) -> pulumi.Output[str]:
        """
        Domain-specific endpoint for Dashboard without https scheme.
        """
        return pulumi.get(self, "dashboard_endpoint")

    @property
    @pulumi.getter(name="domainEndpointOptions")
    def domain_endpoint_options(self) -> pulumi.Output['outputs.DomainDomainEndpointOptions']:
        """
        Configuration block for domain endpoint HTTP(S) related options. Detailed below.
        """
        return pulumi.get(self, "domain_endpoint_options")

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> pulumi.Output[str]:
        """
        Unique identifier for the domain.
        """
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[str]:
        """
        Name of the domain.

        The following arguments are optional:
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="ebsOptions")
    def ebs_options(self) -> pulumi.Output['outputs.DomainEbsOptions']:
        """
        Configuration block for EBS related options, may be required based on chosen [instance size](https://aws.amazon.com/opensearch-service/pricing/). Detailed below.
        """
        return pulumi.get(self, "ebs_options")

    @property
    @pulumi.getter(name="encryptAtRest")
    def encrypt_at_rest(self) -> pulumi.Output['outputs.DomainEncryptAtRest']:
        """
        Configuration block for encrypt at rest options. Only available for [certain instance types](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/encryption-at-rest.html). Detailed below.
        """
        return pulumi.get(self, "encrypt_at_rest")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[str]:
        """
        Domain-specific endpoint used to submit index, search, and data upload requests.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[str]:
        """
        Either `Elasticsearch_X.Y` or `OpenSearch_X.Y` to specify the engine version for the Amazon OpenSearch Service domain. For example, `OpenSearch_1.0` or `Elasticsearch_7.9`.
        See [Creating and managing Amazon OpenSearch Service domains](http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomains).
        Defaults to the lastest version of OpenSearch.
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter(name="kibanaEndpoint")
    def kibana_endpoint(self) -> pulumi.Output[str]:
        """
        (**Deprecated**) Domain-specific endpoint for kibana without https scheme. Use the `dashboard_endpoint` attribute instead.
        """
        warnings.warn("""use 'dashboard_endpoint' attribute instead""", DeprecationWarning)
        pulumi.log.warn("""kibana_endpoint is deprecated: use 'dashboard_endpoint' attribute instead""")

        return pulumi.get(self, "kibana_endpoint")

    @property
    @pulumi.getter(name="logPublishingOptions")
    def log_publishing_options(self) -> pulumi.Output[Optional[Sequence['outputs.DomainLogPublishingOption']]]:
        """
        Configuration block for publishing slow and application logs to CloudWatch Logs. This block can be declared multiple times, for each log_type, within the same resource. Detailed below.
        """
        return pulumi.get(self, "log_publishing_options")

    @property
    @pulumi.getter(name="nodeToNodeEncryption")
    def node_to_node_encryption(self) -> pulumi.Output['outputs.DomainNodeToNodeEncryption']:
        """
        Configuration block for node-to-node encryption options. Detailed below.
        """
        return pulumi.get(self, "node_to_node_encryption")

    @property
    @pulumi.getter(name="offPeakWindowOptions")
    def off_peak_window_options(self) -> pulumi.Output['outputs.DomainOffPeakWindowOptions']:
        """
        Configuration to add Off Peak update options. ([documentation](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/off-peak.html)). Detailed below.
        """
        return pulumi.get(self, "off_peak_window_options")

    @property
    @pulumi.getter(name="snapshotOptions")
    def snapshot_options(self) -> pulumi.Output[Optional['outputs.DomainSnapshotOptions']]:
        """
        Configuration block for snapshot related options. Detailed below. DEPRECATED. For domains running OpenSearch 5.3 and later, Amazon OpenSearch takes hourly automated snapshots, making this setting irrelevant. For domains running earlier versions, OpenSearch takes daily automated snapshots.
        """
        return pulumi.get(self, "snapshot_options")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        * `vpc_options.0.availability_zones` - If the domain was created inside a VPC, the names of the availability zones the configured `subnet_ids` were created inside.
        * `vpc_options.0.vpc_id` - If the domain was created inside a VPC, the ID of the VPC.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="vpcOptions")
    def vpc_options(self) -> pulumi.Output[Optional['outputs.DomainVpcOptions']]:
        """
        Configuration block for VPC related options. Adding or removing this configuration forces a new resource ([documentation](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html)). Detailed below.
        """
        return pulumi.get(self, "vpc_options")

