# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetServerlessVpcEndpointResult',
    'AwaitableGetServerlessVpcEndpointResult',
    'get_serverless_vpc_endpoint',
    'get_serverless_vpc_endpoint_output',
]

@pulumi.output_type
class GetServerlessVpcEndpointResult:
    """
    A collection of values returned by getServerlessVpcEndpoint.
    """
    def __init__(__self__, created_date=None, id=None, name=None, security_group_ids=None, subnet_ids=None, vpc_endpoint_id=None, vpc_id=None):
        if created_date and not isinstance(created_date, str):
            raise TypeError("Expected argument 'created_date' to be a str")
        pulumi.set(__self__, "created_date", created_date)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if security_group_ids and not isinstance(security_group_ids, list):
            raise TypeError("Expected argument 'security_group_ids' to be a list")
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        if subnet_ids and not isinstance(subnet_ids, list):
            raise TypeError("Expected argument 'subnet_ids' to be a list")
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if vpc_endpoint_id and not isinstance(vpc_endpoint_id, str):
            raise TypeError("Expected argument 'vpc_endpoint_id' to be a str")
        pulumi.set(__self__, "vpc_endpoint_id", vpc_endpoint_id)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> str:
        """
        The date the endpoint was created.
        """
        return pulumi.get(self, "created_date")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[str]:
        """
        The IDs of the security groups that define the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[str]:
        """
        The IDs of the subnets from which you access OpenSearch Serverless.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter(name="vpcEndpointId")
    def vpc_endpoint_id(self) -> str:
        return pulumi.get(self, "vpc_endpoint_id")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The ID of the VPC from which you access OpenSearch Serverless.
        """
        return pulumi.get(self, "vpc_id")


class AwaitableGetServerlessVpcEndpointResult(GetServerlessVpcEndpointResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServerlessVpcEndpointResult(
            created_date=self.created_date,
            id=self.id,
            name=self.name,
            security_group_ids=self.security_group_ids,
            subnet_ids=self.subnet_ids,
            vpc_endpoint_id=self.vpc_endpoint_id,
            vpc_id=self.vpc_id)


def get_serverless_vpc_endpoint(vpc_endpoint_id: Optional[str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServerlessVpcEndpointResult:
    """
    Data source for managing an AWS OpenSearch Serverless VPC Endpoint.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.opensearch.get_serverless_vpc_endpoint(vpc_endpoint_id="vpce-829a4487959e2a839")
    ```


    :param str vpc_endpoint_id: The unique identifier of the endpoint.
    """
    __args__ = dict()
    __args__['vpcEndpointId'] = vpc_endpoint_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:opensearch/getServerlessVpcEndpoint:getServerlessVpcEndpoint', __args__, opts=opts, typ=GetServerlessVpcEndpointResult).value

    return AwaitableGetServerlessVpcEndpointResult(
        created_date=pulumi.get(__ret__, 'created_date'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        security_group_ids=pulumi.get(__ret__, 'security_group_ids'),
        subnet_ids=pulumi.get(__ret__, 'subnet_ids'),
        vpc_endpoint_id=pulumi.get(__ret__, 'vpc_endpoint_id'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))


@_utilities.lift_output_func(get_serverless_vpc_endpoint)
def get_serverless_vpc_endpoint_output(vpc_endpoint_id: Optional[pulumi.Input[str]] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetServerlessVpcEndpointResult]:
    """
    Data source for managing an AWS OpenSearch Serverless VPC Endpoint.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.opensearch.get_serverless_vpc_endpoint(vpc_endpoint_id="vpce-829a4487959e2a839")
    ```


    :param str vpc_endpoint_id: The unique identifier of the endpoint.
    """
    ...
