# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OutboundConnectionArgs', 'OutboundConnection']

@pulumi.input_type
class OutboundConnectionArgs:
    def __init__(__self__, *,
                 connection_alias: pulumi.Input[str],
                 local_domain_info: pulumi.Input['OutboundConnectionLocalDomainInfoArgs'],
                 remote_domain_info: pulumi.Input['OutboundConnectionRemoteDomainInfoArgs']):
        """
        The set of arguments for constructing a OutboundConnection resource.
        :param pulumi.Input[str] connection_alias: Specifies the connection alias that will be used by the customer for this connection.
        :param pulumi.Input['OutboundConnectionLocalDomainInfoArgs'] local_domain_info: Configuration block for the local Opensearch domain.
        :param pulumi.Input['OutboundConnectionRemoteDomainInfoArgs'] remote_domain_info: Configuration block for the remote Opensearch domain.
        """
        pulumi.set(__self__, "connection_alias", connection_alias)
        pulumi.set(__self__, "local_domain_info", local_domain_info)
        pulumi.set(__self__, "remote_domain_info", remote_domain_info)

    @property
    @pulumi.getter(name="connectionAlias")
    def connection_alias(self) -> pulumi.Input[str]:
        """
        Specifies the connection alias that will be used by the customer for this connection.
        """
        return pulumi.get(self, "connection_alias")

    @connection_alias.setter
    def connection_alias(self, value: pulumi.Input[str]):
        pulumi.set(self, "connection_alias", value)

    @property
    @pulumi.getter(name="localDomainInfo")
    def local_domain_info(self) -> pulumi.Input['OutboundConnectionLocalDomainInfoArgs']:
        """
        Configuration block for the local Opensearch domain.
        """
        return pulumi.get(self, "local_domain_info")

    @local_domain_info.setter
    def local_domain_info(self, value: pulumi.Input['OutboundConnectionLocalDomainInfoArgs']):
        pulumi.set(self, "local_domain_info", value)

    @property
    @pulumi.getter(name="remoteDomainInfo")
    def remote_domain_info(self) -> pulumi.Input['OutboundConnectionRemoteDomainInfoArgs']:
        """
        Configuration block for the remote Opensearch domain.
        """
        return pulumi.get(self, "remote_domain_info")

    @remote_domain_info.setter
    def remote_domain_info(self, value: pulumi.Input['OutboundConnectionRemoteDomainInfoArgs']):
        pulumi.set(self, "remote_domain_info", value)


@pulumi.input_type
class _OutboundConnectionState:
    def __init__(__self__, *,
                 connection_alias: Optional[pulumi.Input[str]] = None,
                 connection_status: Optional[pulumi.Input[str]] = None,
                 local_domain_info: Optional[pulumi.Input['OutboundConnectionLocalDomainInfoArgs']] = None,
                 remote_domain_info: Optional[pulumi.Input['OutboundConnectionRemoteDomainInfoArgs']] = None):
        """
        Input properties used for looking up and filtering OutboundConnection resources.
        :param pulumi.Input[str] connection_alias: Specifies the connection alias that will be used by the customer for this connection.
        :param pulumi.Input[str] connection_status: Status of the connection request.
        :param pulumi.Input['OutboundConnectionLocalDomainInfoArgs'] local_domain_info: Configuration block for the local Opensearch domain.
        :param pulumi.Input['OutboundConnectionRemoteDomainInfoArgs'] remote_domain_info: Configuration block for the remote Opensearch domain.
        """
        if connection_alias is not None:
            pulumi.set(__self__, "connection_alias", connection_alias)
        if connection_status is not None:
            pulumi.set(__self__, "connection_status", connection_status)
        if local_domain_info is not None:
            pulumi.set(__self__, "local_domain_info", local_domain_info)
        if remote_domain_info is not None:
            pulumi.set(__self__, "remote_domain_info", remote_domain_info)

    @property
    @pulumi.getter(name="connectionAlias")
    def connection_alias(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the connection alias that will be used by the customer for this connection.
        """
        return pulumi.get(self, "connection_alias")

    @connection_alias.setter
    def connection_alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_alias", value)

    @property
    @pulumi.getter(name="connectionStatus")
    def connection_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the connection request.
        """
        return pulumi.get(self, "connection_status")

    @connection_status.setter
    def connection_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_status", value)

    @property
    @pulumi.getter(name="localDomainInfo")
    def local_domain_info(self) -> Optional[pulumi.Input['OutboundConnectionLocalDomainInfoArgs']]:
        """
        Configuration block for the local Opensearch domain.
        """
        return pulumi.get(self, "local_domain_info")

    @local_domain_info.setter
    def local_domain_info(self, value: Optional[pulumi.Input['OutboundConnectionLocalDomainInfoArgs']]):
        pulumi.set(self, "local_domain_info", value)

    @property
    @pulumi.getter(name="remoteDomainInfo")
    def remote_domain_info(self) -> Optional[pulumi.Input['OutboundConnectionRemoteDomainInfoArgs']]:
        """
        Configuration block for the remote Opensearch domain.
        """
        return pulumi.get(self, "remote_domain_info")

    @remote_domain_info.setter
    def remote_domain_info(self, value: Optional[pulumi.Input['OutboundConnectionRemoteDomainInfoArgs']]):
        pulumi.set(self, "remote_domain_info", value)


class OutboundConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_alias: Optional[pulumi.Input[str]] = None,
                 local_domain_info: Optional[pulumi.Input[pulumi.InputType['OutboundConnectionLocalDomainInfoArgs']]] = None,
                 remote_domain_info: Optional[pulumi.Input[pulumi.InputType['OutboundConnectionRemoteDomainInfoArgs']]] = None,
                 __props__=None):
        """
        Manages an AWS Opensearch Outbound Connection.

        ## Example Usage
        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        current_caller_identity = aws.get_caller_identity()
        current_region = aws.get_region()
        foo = aws.opensearch.OutboundConnection("foo",
            connection_alias="outbound_connection",
            local_domain_info=aws.opensearch.OutboundConnectionLocalDomainInfoArgs(
                owner_id=current_caller_identity.account_id,
                region=current_region.name,
                domain_name=aws_opensearch_domain["local_domain"]["domain_name"],
            ),
            remote_domain_info=aws.opensearch.OutboundConnectionRemoteDomainInfoArgs(
                owner_id=current_caller_identity.account_id,
                region=current_region.name,
                domain_name=aws_opensearch_domain["remote_domain"]["domain_name"],
            ))
        ```

        ## Import

        Using `pulumi import`, import AWS Opensearch Outbound Connections using the Outbound Connection ID. For example:

        ```sh
         $ pulumi import aws:opensearch/outboundConnection:OutboundConnection foo connection-id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] connection_alias: Specifies the connection alias that will be used by the customer for this connection.
        :param pulumi.Input[pulumi.InputType['OutboundConnectionLocalDomainInfoArgs']] local_domain_info: Configuration block for the local Opensearch domain.
        :param pulumi.Input[pulumi.InputType['OutboundConnectionRemoteDomainInfoArgs']] remote_domain_info: Configuration block for the remote Opensearch domain.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OutboundConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AWS Opensearch Outbound Connection.

        ## Example Usage
        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        current_caller_identity = aws.get_caller_identity()
        current_region = aws.get_region()
        foo = aws.opensearch.OutboundConnection("foo",
            connection_alias="outbound_connection",
            local_domain_info=aws.opensearch.OutboundConnectionLocalDomainInfoArgs(
                owner_id=current_caller_identity.account_id,
                region=current_region.name,
                domain_name=aws_opensearch_domain["local_domain"]["domain_name"],
            ),
            remote_domain_info=aws.opensearch.OutboundConnectionRemoteDomainInfoArgs(
                owner_id=current_caller_identity.account_id,
                region=current_region.name,
                domain_name=aws_opensearch_domain["remote_domain"]["domain_name"],
            ))
        ```

        ## Import

        Using `pulumi import`, import AWS Opensearch Outbound Connections using the Outbound Connection ID. For example:

        ```sh
         $ pulumi import aws:opensearch/outboundConnection:OutboundConnection foo connection-id
        ```

        :param str resource_name: The name of the resource.
        :param OutboundConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OutboundConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_alias: Optional[pulumi.Input[str]] = None,
                 local_domain_info: Optional[pulumi.Input[pulumi.InputType['OutboundConnectionLocalDomainInfoArgs']]] = None,
                 remote_domain_info: Optional[pulumi.Input[pulumi.InputType['OutboundConnectionRemoteDomainInfoArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OutboundConnectionArgs.__new__(OutboundConnectionArgs)

            if connection_alias is None and not opts.urn:
                raise TypeError("Missing required property 'connection_alias'")
            __props__.__dict__["connection_alias"] = connection_alias
            if local_domain_info is None and not opts.urn:
                raise TypeError("Missing required property 'local_domain_info'")
            __props__.__dict__["local_domain_info"] = local_domain_info
            if remote_domain_info is None and not opts.urn:
                raise TypeError("Missing required property 'remote_domain_info'")
            __props__.__dict__["remote_domain_info"] = remote_domain_info
            __props__.__dict__["connection_status"] = None
        super(OutboundConnection, __self__).__init__(
            'aws:opensearch/outboundConnection:OutboundConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connection_alias: Optional[pulumi.Input[str]] = None,
            connection_status: Optional[pulumi.Input[str]] = None,
            local_domain_info: Optional[pulumi.Input[pulumi.InputType['OutboundConnectionLocalDomainInfoArgs']]] = None,
            remote_domain_info: Optional[pulumi.Input[pulumi.InputType['OutboundConnectionRemoteDomainInfoArgs']]] = None) -> 'OutboundConnection':
        """
        Get an existing OutboundConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] connection_alias: Specifies the connection alias that will be used by the customer for this connection.
        :param pulumi.Input[str] connection_status: Status of the connection request.
        :param pulumi.Input[pulumi.InputType['OutboundConnectionLocalDomainInfoArgs']] local_domain_info: Configuration block for the local Opensearch domain.
        :param pulumi.Input[pulumi.InputType['OutboundConnectionRemoteDomainInfoArgs']] remote_domain_info: Configuration block for the remote Opensearch domain.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OutboundConnectionState.__new__(_OutboundConnectionState)

        __props__.__dict__["connection_alias"] = connection_alias
        __props__.__dict__["connection_status"] = connection_status
        __props__.__dict__["local_domain_info"] = local_domain_info
        __props__.__dict__["remote_domain_info"] = remote_domain_info
        return OutboundConnection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="connectionAlias")
    def connection_alias(self) -> pulumi.Output[str]:
        """
        Specifies the connection alias that will be used by the customer for this connection.
        """
        return pulumi.get(self, "connection_alias")

    @property
    @pulumi.getter(name="connectionStatus")
    def connection_status(self) -> pulumi.Output[str]:
        """
        Status of the connection request.
        """
        return pulumi.get(self, "connection_status")

    @property
    @pulumi.getter(name="localDomainInfo")
    def local_domain_info(self) -> pulumi.Output['outputs.OutboundConnectionLocalDomainInfo']:
        """
        Configuration block for the local Opensearch domain.
        """
        return pulumi.get(self, "local_domain_info")

    @property
    @pulumi.getter(name="remoteDomainInfo")
    def remote_domain_info(self) -> pulumi.Output['outputs.OutboundConnectionRemoteDomainInfo']:
        """
        Configuration block for the remote Opensearch domain.
        """
        return pulumi.get(self, "remote_domain_info")

