# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetClustersResult',
    'AwaitableGetClustersResult',
    'get_clusters',
    'get_clusters_output',
]

@pulumi.output_type
class GetClustersResult:
    """
    A collection of values returned by getClusters.
    """
    def __init__(__self__, cluster_arns=None, cluster_identifiers=None, filters=None, id=None):
        if cluster_arns and not isinstance(cluster_arns, list):
            raise TypeError("Expected argument 'cluster_arns' to be a list")
        pulumi.set(__self__, "cluster_arns", cluster_arns)
        if cluster_identifiers and not isinstance(cluster_identifiers, list):
            raise TypeError("Expected argument 'cluster_identifiers' to be a list")
        pulumi.set(__self__, "cluster_identifiers", cluster_identifiers)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="clusterArns")
    def cluster_arns(self) -> Sequence[str]:
        """
        Set of cluster ARNs of the matched RDS clusters.
        """
        return pulumi.get(self, "cluster_arns")

    @property
    @pulumi.getter(name="clusterIdentifiers")
    def cluster_identifiers(self) -> Sequence[str]:
        """
        Set of ARNs of cluster identifiers of the matched RDS clusters.
        """
        return pulumi.get(self, "cluster_identifiers")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetClustersFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetClustersResult(GetClustersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClustersResult(
            cluster_arns=self.cluster_arns,
            cluster_identifiers=self.cluster_identifiers,
            filters=self.filters,
            id=self.id)


def get_clusters(filters: Optional[Sequence[pulumi.InputType['GetClustersFilterArgs']]] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClustersResult:
    """
    Data source for managing an AWS RDS (Relational Database) Clusters.

    ## Example Usage
    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.rds.get_clusters(filters=[aws.rds.GetClustersFilterArgs(
        name="engine",
        values=["aurora-postgresql"],
    )])
    ```


    :param Sequence[pulumi.InputType['GetClustersFilterArgs']] filters: Configuration block(s) for filtering. Detailed below.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:rds/getClusters:getClusters', __args__, opts=opts, typ=GetClustersResult).value

    return AwaitableGetClustersResult(
        cluster_arns=pulumi.get(__ret__, 'cluster_arns'),
        cluster_identifiers=pulumi.get(__ret__, 'cluster_identifiers'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))


@_utilities.lift_output_func(get_clusters)
def get_clusters_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetClustersFilterArgs']]]]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetClustersResult]:
    """
    Data source for managing an AWS RDS (Relational Database) Clusters.

    ## Example Usage
    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.rds.get_clusters(filters=[aws.rds.GetClustersFilterArgs(
        name="engine",
        values=["aurora-postgresql"],
    )])
    ```


    :param Sequence[pulumi.InputType['GetClustersFilterArgs']] filters: Configuration block(s) for filtering. Detailed below.
    """
    ...
