# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 cluster_identifier: pulumi.Input[str],
                 node_type: pulumi.Input[str],
                 allow_version_upgrade: Optional[pulumi.Input[bool]] = None,
                 apply_immediately: Optional[pulumi.Input[bool]] = None,
                 aqua_configuration_status: Optional[pulumi.Input[str]] = None,
                 automated_snapshot_retention_period: Optional[pulumi.Input[int]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 availability_zone_relocation_enabled: Optional[pulumi.Input[bool]] = None,
                 cluster_parameter_group_name: Optional[pulumi.Input[str]] = None,
                 cluster_public_key: Optional[pulumi.Input[str]] = None,
                 cluster_revision_number: Optional[pulumi.Input[str]] = None,
                 cluster_subnet_group_name: Optional[pulumi.Input[str]] = None,
                 cluster_type: Optional[pulumi.Input[str]] = None,
                 cluster_version: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 default_iam_role_arn: Optional[pulumi.Input[str]] = None,
                 elastic_ip: Optional[pulumi.Input[str]] = None,
                 encrypted: Optional[pulumi.Input[bool]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 enhanced_vpc_routing: Optional[pulumi.Input[bool]] = None,
                 final_snapshot_identifier: Optional[pulumi.Input[str]] = None,
                 iam_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 logging: Optional[pulumi.Input['ClusterLoggingArgs']] = None,
                 maintenance_track_name: Optional[pulumi.Input[str]] = None,
                 manual_snapshot_retention_period: Optional[pulumi.Input[int]] = None,
                 master_password: Optional[pulumi.Input[str]] = None,
                 master_username: Optional[pulumi.Input[str]] = None,
                 number_of_nodes: Optional[pulumi.Input[int]] = None,
                 owner_account: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[str]] = None,
                 publicly_accessible: Optional[pulumi.Input[bool]] = None,
                 skip_final_snapshot: Optional[pulumi.Input[bool]] = None,
                 snapshot_cluster_identifier: Optional[pulumi.Input[str]] = None,
                 snapshot_copy: Optional[pulumi.Input['ClusterSnapshotCopyArgs']] = None,
                 snapshot_identifier: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[str] cluster_identifier: The Cluster Identifier. Must be a lower case string.
        :param pulumi.Input[str] node_type: The node type to be provisioned for the cluster.
        :param pulumi.Input[bool] allow_version_upgrade: If true , major version upgrades can be applied during the maintenance window to the Amazon Redshift engine that is running on the cluster. Default is `true`.
        :param pulumi.Input[bool] apply_immediately: Specifies whether any cluster modifications are applied immediately, or during the next maintenance window. Default is `false`.
        :param pulumi.Input[str] aqua_configuration_status: The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) after the cluster is restored.
               No longer supported by the AWS API.
               Always returns `auto`.
        :param pulumi.Input[int] automated_snapshot_retention_period: The number of days that automated snapshots are retained. If the value is 0, automated snapshots are disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want with create-cluster-snapshot. Default is 1.
        :param pulumi.Input[str] availability_zone: The EC2 Availability Zone (AZ) in which you want Amazon Redshift to provision the cluster. For example, if you have several EC2 instances running in a specific Availability Zone, then you might want the cluster to be provisioned in the same zone in order to decrease network latency. Can only be changed if `availability_zone_relocation_enabled` is `true`.
        :param pulumi.Input[bool] availability_zone_relocation_enabled: If true, the cluster can be relocated to another availabity zone, either automatically by AWS or when requested. Default is `false`. Available for use on clusters from the RA3 instance family.
        :param pulumi.Input[str] cluster_parameter_group_name: The name of the parameter group to be associated with this cluster.
        :param pulumi.Input[str] cluster_public_key: The public key for the cluster
        :param pulumi.Input[str] cluster_revision_number: The specific revision number of the database in the cluster
        :param pulumi.Input[str] cluster_subnet_group_name: The name of a cluster subnet group to be associated with this cluster. If this parameter is not provided the resulting cluster will be deployed outside virtual private cloud (VPC).
        :param pulumi.Input[str] cluster_type: The cluster type to use. Either `single-node` or `multi-node`.
        :param pulumi.Input[str] cluster_version: The version of the Amazon Redshift engine software that you want to deploy on the cluster.
               The version selected runs on all the nodes in the cluster.
        :param pulumi.Input[str] database_name: The name of the first database to be created when the cluster is created.
               If you do not provide a name, Amazon Redshift will create a default database called `dev`.
        :param pulumi.Input[str] default_iam_role_arn: The Amazon Resource Name (ARN) for the IAM role that was set as default for the cluster when the cluster was created.
        :param pulumi.Input[str] elastic_ip: The Elastic IP (EIP) address for the cluster.
        :param pulumi.Input[bool] encrypted: If true , the data in the cluster is encrypted at rest.
        :param pulumi.Input[str] endpoint: The connection endpoint
        :param pulumi.Input[bool] enhanced_vpc_routing: If true , enhanced VPC routing is enabled.
        :param pulumi.Input[str] final_snapshot_identifier: The identifier of the final snapshot that is to be created immediately before deleting the cluster. If this parameter is provided, `skip_final_snapshot` must be false.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] iam_roles: A list of IAM Role ARNs to associate with the cluster. A Maximum of 10 can be associated to the cluster at any time.
        :param pulumi.Input[str] kms_key_id: The ARN for the KMS encryption key. When specifying `kms_key_id`, `encrypted` needs to be set to true.
        :param pulumi.Input['ClusterLoggingArgs'] logging: Logging, documented below.
        :param pulumi.Input[str] maintenance_track_name: The name of the maintenance track for the restored cluster. When you take a snapshot, the snapshot inherits the MaintenanceTrack value from the cluster. The snapshot might be on a different track than the cluster that was the source for the snapshot. For example, suppose that you take a snapshot of  a cluster that is on the current track and then change the cluster to be on the trailing track. In this case, the snapshot and the source cluster are on different tracks. Default value is `current`.
        :param pulumi.Input[int] manual_snapshot_retention_period: The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained indefinitely. This setting doesn't change the retention period of existing snapshots. Valid values are between `-1` and `3653`. Default value is `-1`.
        :param pulumi.Input[str] master_password: Password for the master DB user.
               Note that this may show up in logs, and it will be stored in the state file. Password must contain at least 8 chars and
               contain at least one uppercase letter, one lowercase letter, and one number.
        :param pulumi.Input[str] master_username: Username for the master DB user.
        :param pulumi.Input[int] number_of_nodes: The number of compute nodes in the cluster. This parameter is required when the ClusterType parameter is specified as multi-node. Default is 1.
        :param pulumi.Input[str] owner_account: The AWS customer account used to create or copy the snapshot. Required if you are restoring a snapshot you do not own, optional if you own the snapshot.
        :param pulumi.Input[int] port: The port number on which the cluster accepts incoming connections. Valid values are between `1115` and `65535`.
               The cluster is accessible only via the JDBC and ODBC connection strings.
               Part of the connection string requires the port on which the cluster will listen for incoming connections.
               Default port is `5439`.
        :param pulumi.Input[str] preferred_maintenance_window: The weekly time range (in UTC) during which automated cluster maintenance can occur.
               Format: ddd:hh24:mi-ddd:hh24:mi
        :param pulumi.Input[bool] publicly_accessible: If true, the cluster can be accessed from a public network. Default is `true`.
        :param pulumi.Input[bool] skip_final_snapshot: Determines whether a final snapshot of the cluster is created before Amazon Redshift deletes the cluster. If true , a final cluster snapshot is not created. If false , a final cluster snapshot is created before the cluster is deleted. Default is false.
        :param pulumi.Input[str] snapshot_cluster_identifier: The name of the cluster the source snapshot was created from.
        :param pulumi.Input['ClusterSnapshotCopyArgs'] snapshot_copy: Configuration of automatic copy of snapshots from one region to another. Documented below.
        :param pulumi.Input[str] snapshot_identifier: The name of the snapshot from which to create the new cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_security_group_ids: A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.
        """
        pulumi.set(__self__, "cluster_identifier", cluster_identifier)
        pulumi.set(__self__, "node_type", node_type)
        if allow_version_upgrade is not None:
            pulumi.set(__self__, "allow_version_upgrade", allow_version_upgrade)
        if apply_immediately is not None:
            pulumi.set(__self__, "apply_immediately", apply_immediately)
        if aqua_configuration_status is not None:
            warnings.warn("""This parameter is no longer supported by the AWS API. It will be removed in the next major version of the provider.""", DeprecationWarning)
            pulumi.log.warn("""aqua_configuration_status is deprecated: This parameter is no longer supported by the AWS API. It will be removed in the next major version of the provider.""")
        if aqua_configuration_status is not None:
            pulumi.set(__self__, "aqua_configuration_status", aqua_configuration_status)
        if automated_snapshot_retention_period is not None:
            pulumi.set(__self__, "automated_snapshot_retention_period", automated_snapshot_retention_period)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if availability_zone_relocation_enabled is not None:
            pulumi.set(__self__, "availability_zone_relocation_enabled", availability_zone_relocation_enabled)
        if cluster_parameter_group_name is not None:
            pulumi.set(__self__, "cluster_parameter_group_name", cluster_parameter_group_name)
        if cluster_public_key is not None:
            pulumi.set(__self__, "cluster_public_key", cluster_public_key)
        if cluster_revision_number is not None:
            pulumi.set(__self__, "cluster_revision_number", cluster_revision_number)
        if cluster_subnet_group_name is not None:
            pulumi.set(__self__, "cluster_subnet_group_name", cluster_subnet_group_name)
        if cluster_type is not None:
            pulumi.set(__self__, "cluster_type", cluster_type)
        if cluster_version is not None:
            pulumi.set(__self__, "cluster_version", cluster_version)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if default_iam_role_arn is not None:
            pulumi.set(__self__, "default_iam_role_arn", default_iam_role_arn)
        if elastic_ip is not None:
            pulumi.set(__self__, "elastic_ip", elastic_ip)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if enhanced_vpc_routing is not None:
            pulumi.set(__self__, "enhanced_vpc_routing", enhanced_vpc_routing)
        if final_snapshot_identifier is not None:
            pulumi.set(__self__, "final_snapshot_identifier", final_snapshot_identifier)
        if iam_roles is not None:
            pulumi.set(__self__, "iam_roles", iam_roles)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if maintenance_track_name is not None:
            pulumi.set(__self__, "maintenance_track_name", maintenance_track_name)
        if manual_snapshot_retention_period is not None:
            pulumi.set(__self__, "manual_snapshot_retention_period", manual_snapshot_retention_period)
        if master_password is not None:
            pulumi.set(__self__, "master_password", master_password)
        if master_username is not None:
            pulumi.set(__self__, "master_username", master_username)
        if number_of_nodes is not None:
            pulumi.set(__self__, "number_of_nodes", number_of_nodes)
        if owner_account is not None:
            pulumi.set(__self__, "owner_account", owner_account)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if preferred_maintenance_window is not None:
            pulumi.set(__self__, "preferred_maintenance_window", preferred_maintenance_window)
        if publicly_accessible is not None:
            pulumi.set(__self__, "publicly_accessible", publicly_accessible)
        if skip_final_snapshot is not None:
            pulumi.set(__self__, "skip_final_snapshot", skip_final_snapshot)
        if snapshot_cluster_identifier is not None:
            pulumi.set(__self__, "snapshot_cluster_identifier", snapshot_cluster_identifier)
        if snapshot_copy is not None:
            pulumi.set(__self__, "snapshot_copy", snapshot_copy)
        if snapshot_identifier is not None:
            pulumi.set(__self__, "snapshot_identifier", snapshot_identifier)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_security_group_ids is not None:
            pulumi.set(__self__, "vpc_security_group_ids", vpc_security_group_ids)

    @property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> pulumi.Input[str]:
        """
        The Cluster Identifier. Must be a lower case string.
        """
        return pulumi.get(self, "cluster_identifier")

    @cluster_identifier.setter
    def cluster_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_identifier", value)

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Input[str]:
        """
        The node type to be provisioned for the cluster.
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "node_type", value)

    @property
    @pulumi.getter(name="allowVersionUpgrade")
    def allow_version_upgrade(self) -> Optional[pulumi.Input[bool]]:
        """
        If true , major version upgrades can be applied during the maintenance window to the Amazon Redshift engine that is running on the cluster. Default is `true`.
        """
        return pulumi.get(self, "allow_version_upgrade")

    @allow_version_upgrade.setter
    def allow_version_upgrade(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_version_upgrade", value)

    @property
    @pulumi.getter(name="applyImmediately")
    def apply_immediately(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether any cluster modifications are applied immediately, or during the next maintenance window. Default is `false`.
        """
        return pulumi.get(self, "apply_immediately")

    @apply_immediately.setter
    def apply_immediately(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "apply_immediately", value)

    @property
    @pulumi.getter(name="aquaConfigurationStatus")
    def aqua_configuration_status(self) -> Optional[pulumi.Input[str]]:
        """
        The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) after the cluster is restored.
        No longer supported by the AWS API.
        Always returns `auto`.
        """
        warnings.warn("""This parameter is no longer supported by the AWS API. It will be removed in the next major version of the provider.""", DeprecationWarning)
        pulumi.log.warn("""aqua_configuration_status is deprecated: This parameter is no longer supported by the AWS API. It will be removed in the next major version of the provider.""")

        return pulumi.get(self, "aqua_configuration_status")

    @aqua_configuration_status.setter
    def aqua_configuration_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aqua_configuration_status", value)

    @property
    @pulumi.getter(name="automatedSnapshotRetentionPeriod")
    def automated_snapshot_retention_period(self) -> Optional[pulumi.Input[int]]:
        """
        The number of days that automated snapshots are retained. If the value is 0, automated snapshots are disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want with create-cluster-snapshot. Default is 1.
        """
        return pulumi.get(self, "automated_snapshot_retention_period")

    @automated_snapshot_retention_period.setter
    def automated_snapshot_retention_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "automated_snapshot_retention_period", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The EC2 Availability Zone (AZ) in which you want Amazon Redshift to provision the cluster. For example, if you have several EC2 instances running in a specific Availability Zone, then you might want the cluster to be provisioned in the same zone in order to decrease network latency. Can only be changed if `availability_zone_relocation_enabled` is `true`.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="availabilityZoneRelocationEnabled")
    def availability_zone_relocation_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the cluster can be relocated to another availabity zone, either automatically by AWS or when requested. Default is `false`. Available for use on clusters from the RA3 instance family.
        """
        return pulumi.get(self, "availability_zone_relocation_enabled")

    @availability_zone_relocation_enabled.setter
    def availability_zone_relocation_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "availability_zone_relocation_enabled", value)

    @property
    @pulumi.getter(name="clusterParameterGroupName")
    def cluster_parameter_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the parameter group to be associated with this cluster.
        """
        return pulumi.get(self, "cluster_parameter_group_name")

    @cluster_parameter_group_name.setter
    def cluster_parameter_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_parameter_group_name", value)

    @property
    @pulumi.getter(name="clusterPublicKey")
    def cluster_public_key(self) -> Optional[pulumi.Input[str]]:
        """
        The public key for the cluster
        """
        return pulumi.get(self, "cluster_public_key")

    @cluster_public_key.setter
    def cluster_public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_public_key", value)

    @property
    @pulumi.getter(name="clusterRevisionNumber")
    def cluster_revision_number(self) -> Optional[pulumi.Input[str]]:
        """
        The specific revision number of the database in the cluster
        """
        return pulumi.get(self, "cluster_revision_number")

    @cluster_revision_number.setter
    def cluster_revision_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_revision_number", value)

    @property
    @pulumi.getter(name="clusterSubnetGroupName")
    def cluster_subnet_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of a cluster subnet group to be associated with this cluster. If this parameter is not provided the resulting cluster will be deployed outside virtual private cloud (VPC).
        """
        return pulumi.get(self, "cluster_subnet_group_name")

    @cluster_subnet_group_name.setter
    def cluster_subnet_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_subnet_group_name", value)

    @property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> Optional[pulumi.Input[str]]:
        """
        The cluster type to use. Either `single-node` or `multi-node`.
        """
        return pulumi.get(self, "cluster_type")

    @cluster_type.setter
    def cluster_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_type", value)

    @property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the Amazon Redshift engine software that you want to deploy on the cluster.
        The version selected runs on all the nodes in the cluster.
        """
        return pulumi.get(self, "cluster_version")

    @cluster_version.setter
    def cluster_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_version", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the first database to be created when the cluster is created.
        If you do not provide a name, Amazon Redshift will create a default database called `dev`.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="defaultIamRoleArn")
    def default_iam_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) for the IAM role that was set as default for the cluster when the cluster was created.
        """
        return pulumi.get(self, "default_iam_role_arn")

    @default_iam_role_arn.setter
    def default_iam_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_iam_role_arn", value)

    @property
    @pulumi.getter(name="elasticIp")
    def elastic_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The Elastic IP (EIP) address for the cluster.
        """
        return pulumi.get(self, "elastic_ip")

    @elastic_ip.setter
    def elastic_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "elastic_ip", value)

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        If true , the data in the cluster is encrypted at rest.
        """
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypted", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The connection endpoint
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter(name="enhancedVpcRouting")
    def enhanced_vpc_routing(self) -> Optional[pulumi.Input[bool]]:
        """
        If true , enhanced VPC routing is enabled.
        """
        return pulumi.get(self, "enhanced_vpc_routing")

    @enhanced_vpc_routing.setter
    def enhanced_vpc_routing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enhanced_vpc_routing", value)

    @property
    @pulumi.getter(name="finalSnapshotIdentifier")
    def final_snapshot_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of the final snapshot that is to be created immediately before deleting the cluster. If this parameter is provided, `skip_final_snapshot` must be false.
        """
        return pulumi.get(self, "final_snapshot_identifier")

    @final_snapshot_identifier.setter
    def final_snapshot_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "final_snapshot_identifier", value)

    @property
    @pulumi.getter(name="iamRoles")
    def iam_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of IAM Role ARNs to associate with the cluster. A Maximum of 10 can be associated to the cluster at any time.
        """
        return pulumi.get(self, "iam_roles")

    @iam_roles.setter
    def iam_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "iam_roles", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN for the KMS encryption key. When specifying `kms_key_id`, `encrypted` needs to be set to true.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter
    def logging(self) -> Optional[pulumi.Input['ClusterLoggingArgs']]:
        """
        Logging, documented below.
        """
        return pulumi.get(self, "logging")

    @logging.setter
    def logging(self, value: Optional[pulumi.Input['ClusterLoggingArgs']]):
        pulumi.set(self, "logging", value)

    @property
    @pulumi.getter(name="maintenanceTrackName")
    def maintenance_track_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the maintenance track for the restored cluster. When you take a snapshot, the snapshot inherits the MaintenanceTrack value from the cluster. The snapshot might be on a different track than the cluster that was the source for the snapshot. For example, suppose that you take a snapshot of  a cluster that is on the current track and then change the cluster to be on the trailing track. In this case, the snapshot and the source cluster are on different tracks. Default value is `current`.
        """
        return pulumi.get(self, "maintenance_track_name")

    @maintenance_track_name.setter
    def maintenance_track_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintenance_track_name", value)

    @property
    @pulumi.getter(name="manualSnapshotRetentionPeriod")
    def manual_snapshot_retention_period(self) -> Optional[pulumi.Input[int]]:
        """
        The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained indefinitely. This setting doesn't change the retention period of existing snapshots. Valid values are between `-1` and `3653`. Default value is `-1`.
        """
        return pulumi.get(self, "manual_snapshot_retention_period")

    @manual_snapshot_retention_period.setter
    def manual_snapshot_retention_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "manual_snapshot_retention_period", value)

    @property
    @pulumi.getter(name="masterPassword")
    def master_password(self) -> Optional[pulumi.Input[str]]:
        """
        Password for the master DB user.
        Note that this may show up in logs, and it will be stored in the state file. Password must contain at least 8 chars and
        contain at least one uppercase letter, one lowercase letter, and one number.
        """
        return pulumi.get(self, "master_password")

    @master_password.setter
    def master_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_password", value)

    @property
    @pulumi.getter(name="masterUsername")
    def master_username(self) -> Optional[pulumi.Input[str]]:
        """
        Username for the master DB user.
        """
        return pulumi.get(self, "master_username")

    @master_username.setter
    def master_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_username", value)

    @property
    @pulumi.getter(name="numberOfNodes")
    def number_of_nodes(self) -> Optional[pulumi.Input[int]]:
        """
        The number of compute nodes in the cluster. This parameter is required when the ClusterType parameter is specified as multi-node. Default is 1.
        """
        return pulumi.get(self, "number_of_nodes")

    @number_of_nodes.setter
    def number_of_nodes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number_of_nodes", value)

    @property
    @pulumi.getter(name="ownerAccount")
    def owner_account(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS customer account used to create or copy the snapshot. Required if you are restoring a snapshot you do not own, optional if you own the snapshot.
        """
        return pulumi.get(self, "owner_account")

    @owner_account.setter
    def owner_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner_account", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port number on which the cluster accepts incoming connections. Valid values are between `1115` and `65535`.
        The cluster is accessible only via the JDBC and ODBC connection strings.
        Part of the connection string requires the port on which the cluster will listen for incoming connections.
        Default port is `5439`.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> Optional[pulumi.Input[str]]:
        """
        The weekly time range (in UTC) during which automated cluster maintenance can occur.
        Format: ddd:hh24:mi-ddd:hh24:mi
        """
        return pulumi.get(self, "preferred_maintenance_window")

    @preferred_maintenance_window.setter
    def preferred_maintenance_window(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_maintenance_window", value)

    @property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the cluster can be accessed from a public network. Default is `true`.
        """
        return pulumi.get(self, "publicly_accessible")

    @publicly_accessible.setter
    def publicly_accessible(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "publicly_accessible", value)

    @property
    @pulumi.getter(name="skipFinalSnapshot")
    def skip_final_snapshot(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines whether a final snapshot of the cluster is created before Amazon Redshift deletes the cluster. If true , a final cluster snapshot is not created. If false , a final cluster snapshot is created before the cluster is deleted. Default is false.
        """
        return pulumi.get(self, "skip_final_snapshot")

    @skip_final_snapshot.setter
    def skip_final_snapshot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_final_snapshot", value)

    @property
    @pulumi.getter(name="snapshotClusterIdentifier")
    def snapshot_cluster_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the cluster the source snapshot was created from.
        """
        return pulumi.get(self, "snapshot_cluster_identifier")

    @snapshot_cluster_identifier.setter
    def snapshot_cluster_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_cluster_identifier", value)

    @property
    @pulumi.getter(name="snapshotCopy")
    def snapshot_copy(self) -> Optional[pulumi.Input['ClusterSnapshotCopyArgs']]:
        """
        Configuration of automatic copy of snapshots from one region to another. Documented below.
        """
        return pulumi.get(self, "snapshot_copy")

    @snapshot_copy.setter
    def snapshot_copy(self, value: Optional[pulumi.Input['ClusterSnapshotCopyArgs']]):
        pulumi.set(self, "snapshot_copy", value)

    @property
    @pulumi.getter(name="snapshotIdentifier")
    def snapshot_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the snapshot from which to create the new cluster.
        """
        return pulumi.get(self, "snapshot_identifier")

    @snapshot_identifier.setter
    def snapshot_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_identifier", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpcSecurityGroupIds")
    def vpc_security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.
        """
        return pulumi.get(self, "vpc_security_group_ids")

    @vpc_security_group_ids.setter
    def vpc_security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vpc_security_group_ids", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 allow_version_upgrade: Optional[pulumi.Input[bool]] = None,
                 apply_immediately: Optional[pulumi.Input[bool]] = None,
                 aqua_configuration_status: Optional[pulumi.Input[str]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 automated_snapshot_retention_period: Optional[pulumi.Input[int]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 availability_zone_relocation_enabled: Optional[pulumi.Input[bool]] = None,
                 cluster_identifier: Optional[pulumi.Input[str]] = None,
                 cluster_namespace_arn: Optional[pulumi.Input[str]] = None,
                 cluster_nodes: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterClusterNodeArgs']]]] = None,
                 cluster_parameter_group_name: Optional[pulumi.Input[str]] = None,
                 cluster_public_key: Optional[pulumi.Input[str]] = None,
                 cluster_revision_number: Optional[pulumi.Input[str]] = None,
                 cluster_subnet_group_name: Optional[pulumi.Input[str]] = None,
                 cluster_type: Optional[pulumi.Input[str]] = None,
                 cluster_version: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 default_iam_role_arn: Optional[pulumi.Input[str]] = None,
                 dns_name: Optional[pulumi.Input[str]] = None,
                 elastic_ip: Optional[pulumi.Input[str]] = None,
                 encrypted: Optional[pulumi.Input[bool]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 enhanced_vpc_routing: Optional[pulumi.Input[bool]] = None,
                 final_snapshot_identifier: Optional[pulumi.Input[str]] = None,
                 iam_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 logging: Optional[pulumi.Input['ClusterLoggingArgs']] = None,
                 maintenance_track_name: Optional[pulumi.Input[str]] = None,
                 manual_snapshot_retention_period: Optional[pulumi.Input[int]] = None,
                 master_password: Optional[pulumi.Input[str]] = None,
                 master_username: Optional[pulumi.Input[str]] = None,
                 node_type: Optional[pulumi.Input[str]] = None,
                 number_of_nodes: Optional[pulumi.Input[int]] = None,
                 owner_account: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[str]] = None,
                 publicly_accessible: Optional[pulumi.Input[bool]] = None,
                 skip_final_snapshot: Optional[pulumi.Input[bool]] = None,
                 snapshot_cluster_identifier: Optional[pulumi.Input[str]] = None,
                 snapshot_copy: Optional[pulumi.Input['ClusterSnapshotCopyArgs']] = None,
                 snapshot_identifier: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[bool] allow_version_upgrade: If true , major version upgrades can be applied during the maintenance window to the Amazon Redshift engine that is running on the cluster. Default is `true`.
        :param pulumi.Input[bool] apply_immediately: Specifies whether any cluster modifications are applied immediately, or during the next maintenance window. Default is `false`.
        :param pulumi.Input[str] aqua_configuration_status: The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) after the cluster is restored.
               No longer supported by the AWS API.
               Always returns `auto`.
        :param pulumi.Input[str] arn: Amazon Resource Name (ARN) of cluster
        :param pulumi.Input[int] automated_snapshot_retention_period: The number of days that automated snapshots are retained. If the value is 0, automated snapshots are disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want with create-cluster-snapshot. Default is 1.
        :param pulumi.Input[str] availability_zone: The EC2 Availability Zone (AZ) in which you want Amazon Redshift to provision the cluster. For example, if you have several EC2 instances running in a specific Availability Zone, then you might want the cluster to be provisioned in the same zone in order to decrease network latency. Can only be changed if `availability_zone_relocation_enabled` is `true`.
        :param pulumi.Input[bool] availability_zone_relocation_enabled: If true, the cluster can be relocated to another availabity zone, either automatically by AWS or when requested. Default is `false`. Available for use on clusters from the RA3 instance family.
        :param pulumi.Input[str] cluster_identifier: The Cluster Identifier. Must be a lower case string.
        :param pulumi.Input[str] cluster_namespace_arn: The namespace Amazon Resource Name (ARN) of the cluster
        :param pulumi.Input[Sequence[pulumi.Input['ClusterClusterNodeArgs']]] cluster_nodes: The nodes in the cluster. Cluster node blocks are documented below
        :param pulumi.Input[str] cluster_parameter_group_name: The name of the parameter group to be associated with this cluster.
        :param pulumi.Input[str] cluster_public_key: The public key for the cluster
        :param pulumi.Input[str] cluster_revision_number: The specific revision number of the database in the cluster
        :param pulumi.Input[str] cluster_subnet_group_name: The name of a cluster subnet group to be associated with this cluster. If this parameter is not provided the resulting cluster will be deployed outside virtual private cloud (VPC).
        :param pulumi.Input[str] cluster_type: The cluster type to use. Either `single-node` or `multi-node`.
        :param pulumi.Input[str] cluster_version: The version of the Amazon Redshift engine software that you want to deploy on the cluster.
               The version selected runs on all the nodes in the cluster.
        :param pulumi.Input[str] database_name: The name of the first database to be created when the cluster is created.
               If you do not provide a name, Amazon Redshift will create a default database called `dev`.
        :param pulumi.Input[str] default_iam_role_arn: The Amazon Resource Name (ARN) for the IAM role that was set as default for the cluster when the cluster was created.
        :param pulumi.Input[str] dns_name: The DNS name of the cluster
        :param pulumi.Input[str] elastic_ip: The Elastic IP (EIP) address for the cluster.
        :param pulumi.Input[bool] encrypted: If true , the data in the cluster is encrypted at rest.
        :param pulumi.Input[str] endpoint: The connection endpoint
        :param pulumi.Input[bool] enhanced_vpc_routing: If true , enhanced VPC routing is enabled.
        :param pulumi.Input[str] final_snapshot_identifier: The identifier of the final snapshot that is to be created immediately before deleting the cluster. If this parameter is provided, `skip_final_snapshot` must be false.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] iam_roles: A list of IAM Role ARNs to associate with the cluster. A Maximum of 10 can be associated to the cluster at any time.
        :param pulumi.Input[str] kms_key_id: The ARN for the KMS encryption key. When specifying `kms_key_id`, `encrypted` needs to be set to true.
        :param pulumi.Input['ClusterLoggingArgs'] logging: Logging, documented below.
        :param pulumi.Input[str] maintenance_track_name: The name of the maintenance track for the restored cluster. When you take a snapshot, the snapshot inherits the MaintenanceTrack value from the cluster. The snapshot might be on a different track than the cluster that was the source for the snapshot. For example, suppose that you take a snapshot of  a cluster that is on the current track and then change the cluster to be on the trailing track. In this case, the snapshot and the source cluster are on different tracks. Default value is `current`.
        :param pulumi.Input[int] manual_snapshot_retention_period: The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained indefinitely. This setting doesn't change the retention period of existing snapshots. Valid values are between `-1` and `3653`. Default value is `-1`.
        :param pulumi.Input[str] master_password: Password for the master DB user.
               Note that this may show up in logs, and it will be stored in the state file. Password must contain at least 8 chars and
               contain at least one uppercase letter, one lowercase letter, and one number.
        :param pulumi.Input[str] master_username: Username for the master DB user.
        :param pulumi.Input[str] node_type: The node type to be provisioned for the cluster.
        :param pulumi.Input[int] number_of_nodes: The number of compute nodes in the cluster. This parameter is required when the ClusterType parameter is specified as multi-node. Default is 1.
        :param pulumi.Input[str] owner_account: The AWS customer account used to create or copy the snapshot. Required if you are restoring a snapshot you do not own, optional if you own the snapshot.
        :param pulumi.Input[int] port: The port number on which the cluster accepts incoming connections. Valid values are between `1115` and `65535`.
               The cluster is accessible only via the JDBC and ODBC connection strings.
               Part of the connection string requires the port on which the cluster will listen for incoming connections.
               Default port is `5439`.
        :param pulumi.Input[str] preferred_maintenance_window: The weekly time range (in UTC) during which automated cluster maintenance can occur.
               Format: ddd:hh24:mi-ddd:hh24:mi
        :param pulumi.Input[bool] publicly_accessible: If true, the cluster can be accessed from a public network. Default is `true`.
        :param pulumi.Input[bool] skip_final_snapshot: Determines whether a final snapshot of the cluster is created before Amazon Redshift deletes the cluster. If true , a final cluster snapshot is not created. If false , a final cluster snapshot is created before the cluster is deleted. Default is false.
        :param pulumi.Input[str] snapshot_cluster_identifier: The name of the cluster the source snapshot was created from.
        :param pulumi.Input['ClusterSnapshotCopyArgs'] snapshot_copy: Configuration of automatic copy of snapshots from one region to another. Documented below.
        :param pulumi.Input[str] snapshot_identifier: The name of the snapshot from which to create the new cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_security_group_ids: A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.
        """
        if allow_version_upgrade is not None:
            pulumi.set(__self__, "allow_version_upgrade", allow_version_upgrade)
        if apply_immediately is not None:
            pulumi.set(__self__, "apply_immediately", apply_immediately)
        if aqua_configuration_status is not None:
            warnings.warn("""This parameter is no longer supported by the AWS API. It will be removed in the next major version of the provider.""", DeprecationWarning)
            pulumi.log.warn("""aqua_configuration_status is deprecated: This parameter is no longer supported by the AWS API. It will be removed in the next major version of the provider.""")
        if aqua_configuration_status is not None:
            pulumi.set(__self__, "aqua_configuration_status", aqua_configuration_status)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if automated_snapshot_retention_period is not None:
            pulumi.set(__self__, "automated_snapshot_retention_period", automated_snapshot_retention_period)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if availability_zone_relocation_enabled is not None:
            pulumi.set(__self__, "availability_zone_relocation_enabled", availability_zone_relocation_enabled)
        if cluster_identifier is not None:
            pulumi.set(__self__, "cluster_identifier", cluster_identifier)
        if cluster_namespace_arn is not None:
            pulumi.set(__self__, "cluster_namespace_arn", cluster_namespace_arn)
        if cluster_nodes is not None:
            pulumi.set(__self__, "cluster_nodes", cluster_nodes)
        if cluster_parameter_group_name is not None:
            pulumi.set(__self__, "cluster_parameter_group_name", cluster_parameter_group_name)
        if cluster_public_key is not None:
            pulumi.set(__self__, "cluster_public_key", cluster_public_key)
        if cluster_revision_number is not None:
            pulumi.set(__self__, "cluster_revision_number", cluster_revision_number)
        if cluster_subnet_group_name is not None:
            pulumi.set(__self__, "cluster_subnet_group_name", cluster_subnet_group_name)
        if cluster_type is not None:
            pulumi.set(__self__, "cluster_type", cluster_type)
        if cluster_version is not None:
            pulumi.set(__self__, "cluster_version", cluster_version)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if default_iam_role_arn is not None:
            pulumi.set(__self__, "default_iam_role_arn", default_iam_role_arn)
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if elastic_ip is not None:
            pulumi.set(__self__, "elastic_ip", elastic_ip)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if enhanced_vpc_routing is not None:
            pulumi.set(__self__, "enhanced_vpc_routing", enhanced_vpc_routing)
        if final_snapshot_identifier is not None:
            pulumi.set(__self__, "final_snapshot_identifier", final_snapshot_identifier)
        if iam_roles is not None:
            pulumi.set(__self__, "iam_roles", iam_roles)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if maintenance_track_name is not None:
            pulumi.set(__self__, "maintenance_track_name", maintenance_track_name)
        if manual_snapshot_retention_period is not None:
            pulumi.set(__self__, "manual_snapshot_retention_period", manual_snapshot_retention_period)
        if master_password is not None:
            pulumi.set(__self__, "master_password", master_password)
        if master_username is not None:
            pulumi.set(__self__, "master_username", master_username)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if number_of_nodes is not None:
            pulumi.set(__self__, "number_of_nodes", number_of_nodes)
        if owner_account is not None:
            pulumi.set(__self__, "owner_account", owner_account)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if preferred_maintenance_window is not None:
            pulumi.set(__self__, "preferred_maintenance_window", preferred_maintenance_window)
        if publicly_accessible is not None:
            pulumi.set(__self__, "publicly_accessible", publicly_accessible)
        if skip_final_snapshot is not None:
            pulumi.set(__self__, "skip_final_snapshot", skip_final_snapshot)
        if snapshot_cluster_identifier is not None:
            pulumi.set(__self__, "snapshot_cluster_identifier", snapshot_cluster_identifier)
        if snapshot_copy is not None:
            pulumi.set(__self__, "snapshot_copy", snapshot_copy)
        if snapshot_identifier is not None:
            pulumi.set(__self__, "snapshot_identifier", snapshot_identifier)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if vpc_security_group_ids is not None:
            pulumi.set(__self__, "vpc_security_group_ids", vpc_security_group_ids)

    @property
    @pulumi.getter(name="allowVersionUpgrade")
    def allow_version_upgrade(self) -> Optional[pulumi.Input[bool]]:
        """
        If true , major version upgrades can be applied during the maintenance window to the Amazon Redshift engine that is running on the cluster. Default is `true`.
        """
        return pulumi.get(self, "allow_version_upgrade")

    @allow_version_upgrade.setter
    def allow_version_upgrade(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_version_upgrade", value)

    @property
    @pulumi.getter(name="applyImmediately")
    def apply_immediately(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether any cluster modifications are applied immediately, or during the next maintenance window. Default is `false`.
        """
        return pulumi.get(self, "apply_immediately")

    @apply_immediately.setter
    def apply_immediately(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "apply_immediately", value)

    @property
    @pulumi.getter(name="aquaConfigurationStatus")
    def aqua_configuration_status(self) -> Optional[pulumi.Input[str]]:
        """
        The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) after the cluster is restored.
        No longer supported by the AWS API.
        Always returns `auto`.
        """
        warnings.warn("""This parameter is no longer supported by the AWS API. It will be removed in the next major version of the provider.""", DeprecationWarning)
        pulumi.log.warn("""aqua_configuration_status is deprecated: This parameter is no longer supported by the AWS API. It will be removed in the next major version of the provider.""")

        return pulumi.get(self, "aqua_configuration_status")

    @aqua_configuration_status.setter
    def aqua_configuration_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aqua_configuration_status", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) of cluster
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="automatedSnapshotRetentionPeriod")
    def automated_snapshot_retention_period(self) -> Optional[pulumi.Input[int]]:
        """
        The number of days that automated snapshots are retained. If the value is 0, automated snapshots are disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want with create-cluster-snapshot. Default is 1.
        """
        return pulumi.get(self, "automated_snapshot_retention_period")

    @automated_snapshot_retention_period.setter
    def automated_snapshot_retention_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "automated_snapshot_retention_period", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The EC2 Availability Zone (AZ) in which you want Amazon Redshift to provision the cluster. For example, if you have several EC2 instances running in a specific Availability Zone, then you might want the cluster to be provisioned in the same zone in order to decrease network latency. Can only be changed if `availability_zone_relocation_enabled` is `true`.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="availabilityZoneRelocationEnabled")
    def availability_zone_relocation_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the cluster can be relocated to another availabity zone, either automatically by AWS or when requested. Default is `false`. Available for use on clusters from the RA3 instance family.
        """
        return pulumi.get(self, "availability_zone_relocation_enabled")

    @availability_zone_relocation_enabled.setter
    def availability_zone_relocation_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "availability_zone_relocation_enabled", value)

    @property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The Cluster Identifier. Must be a lower case string.
        """
        return pulumi.get(self, "cluster_identifier")

    @cluster_identifier.setter
    def cluster_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_identifier", value)

    @property
    @pulumi.getter(name="clusterNamespaceArn")
    def cluster_namespace_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace Amazon Resource Name (ARN) of the cluster
        """
        return pulumi.get(self, "cluster_namespace_arn")

    @cluster_namespace_arn.setter
    def cluster_namespace_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_namespace_arn", value)

    @property
    @pulumi.getter(name="clusterNodes")
    def cluster_nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterClusterNodeArgs']]]]:
        """
        The nodes in the cluster. Cluster node blocks are documented below
        """
        return pulumi.get(self, "cluster_nodes")

    @cluster_nodes.setter
    def cluster_nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterClusterNodeArgs']]]]):
        pulumi.set(self, "cluster_nodes", value)

    @property
    @pulumi.getter(name="clusterParameterGroupName")
    def cluster_parameter_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the parameter group to be associated with this cluster.
        """
        return pulumi.get(self, "cluster_parameter_group_name")

    @cluster_parameter_group_name.setter
    def cluster_parameter_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_parameter_group_name", value)

    @property
    @pulumi.getter(name="clusterPublicKey")
    def cluster_public_key(self) -> Optional[pulumi.Input[str]]:
        """
        The public key for the cluster
        """
        return pulumi.get(self, "cluster_public_key")

    @cluster_public_key.setter
    def cluster_public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_public_key", value)

    @property
    @pulumi.getter(name="clusterRevisionNumber")
    def cluster_revision_number(self) -> Optional[pulumi.Input[str]]:
        """
        The specific revision number of the database in the cluster
        """
        return pulumi.get(self, "cluster_revision_number")

    @cluster_revision_number.setter
    def cluster_revision_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_revision_number", value)

    @property
    @pulumi.getter(name="clusterSubnetGroupName")
    def cluster_subnet_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of a cluster subnet group to be associated with this cluster. If this parameter is not provided the resulting cluster will be deployed outside virtual private cloud (VPC).
        """
        return pulumi.get(self, "cluster_subnet_group_name")

    @cluster_subnet_group_name.setter
    def cluster_subnet_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_subnet_group_name", value)

    @property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> Optional[pulumi.Input[str]]:
        """
        The cluster type to use. Either `single-node` or `multi-node`.
        """
        return pulumi.get(self, "cluster_type")

    @cluster_type.setter
    def cluster_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_type", value)

    @property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the Amazon Redshift engine software that you want to deploy on the cluster.
        The version selected runs on all the nodes in the cluster.
        """
        return pulumi.get(self, "cluster_version")

    @cluster_version.setter
    def cluster_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_version", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the first database to be created when the cluster is created.
        If you do not provide a name, Amazon Redshift will create a default database called `dev`.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="defaultIamRoleArn")
    def default_iam_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) for the IAM role that was set as default for the cluster when the cluster was created.
        """
        return pulumi.get(self, "default_iam_role_arn")

    @default_iam_role_arn.setter
    def default_iam_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_iam_role_arn", value)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[str]]:
        """
        The DNS name of the cluster
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_name", value)

    @property
    @pulumi.getter(name="elasticIp")
    def elastic_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The Elastic IP (EIP) address for the cluster.
        """
        return pulumi.get(self, "elastic_ip")

    @elastic_ip.setter
    def elastic_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "elastic_ip", value)

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        If true , the data in the cluster is encrypted at rest.
        """
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypted", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The connection endpoint
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter(name="enhancedVpcRouting")
    def enhanced_vpc_routing(self) -> Optional[pulumi.Input[bool]]:
        """
        If true , enhanced VPC routing is enabled.
        """
        return pulumi.get(self, "enhanced_vpc_routing")

    @enhanced_vpc_routing.setter
    def enhanced_vpc_routing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enhanced_vpc_routing", value)

    @property
    @pulumi.getter(name="finalSnapshotIdentifier")
    def final_snapshot_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of the final snapshot that is to be created immediately before deleting the cluster. If this parameter is provided, `skip_final_snapshot` must be false.
        """
        return pulumi.get(self, "final_snapshot_identifier")

    @final_snapshot_identifier.setter
    def final_snapshot_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "final_snapshot_identifier", value)

    @property
    @pulumi.getter(name="iamRoles")
    def iam_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of IAM Role ARNs to associate with the cluster. A Maximum of 10 can be associated to the cluster at any time.
        """
        return pulumi.get(self, "iam_roles")

    @iam_roles.setter
    def iam_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "iam_roles", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN for the KMS encryption key. When specifying `kms_key_id`, `encrypted` needs to be set to true.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter
    def logging(self) -> Optional[pulumi.Input['ClusterLoggingArgs']]:
        """
        Logging, documented below.
        """
        return pulumi.get(self, "logging")

    @logging.setter
    def logging(self, value: Optional[pulumi.Input['ClusterLoggingArgs']]):
        pulumi.set(self, "logging", value)

    @property
    @pulumi.getter(name="maintenanceTrackName")
    def maintenance_track_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the maintenance track for the restored cluster. When you take a snapshot, the snapshot inherits the MaintenanceTrack value from the cluster. The snapshot might be on a different track than the cluster that was the source for the snapshot. For example, suppose that you take a snapshot of  a cluster that is on the current track and then change the cluster to be on the trailing track. In this case, the snapshot and the source cluster are on different tracks. Default value is `current`.
        """
        return pulumi.get(self, "maintenance_track_name")

    @maintenance_track_name.setter
    def maintenance_track_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintenance_track_name", value)

    @property
    @pulumi.getter(name="manualSnapshotRetentionPeriod")
    def manual_snapshot_retention_period(self) -> Optional[pulumi.Input[int]]:
        """
        The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained indefinitely. This setting doesn't change the retention period of existing snapshots. Valid values are between `-1` and `3653`. Default value is `-1`.
        """
        return pulumi.get(self, "manual_snapshot_retention_period")

    @manual_snapshot_retention_period.setter
    def manual_snapshot_retention_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "manual_snapshot_retention_period", value)

    @property
    @pulumi.getter(name="masterPassword")
    def master_password(self) -> Optional[pulumi.Input[str]]:
        """
        Password for the master DB user.
        Note that this may show up in logs, and it will be stored in the state file. Password must contain at least 8 chars and
        contain at least one uppercase letter, one lowercase letter, and one number.
        """
        return pulumi.get(self, "master_password")

    @master_password.setter
    def master_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_password", value)

    @property
    @pulumi.getter(name="masterUsername")
    def master_username(self) -> Optional[pulumi.Input[str]]:
        """
        Username for the master DB user.
        """
        return pulumi.get(self, "master_username")

    @master_username.setter
    def master_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_username", value)

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[pulumi.Input[str]]:
        """
        The node type to be provisioned for the cluster.
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type", value)

    @property
    @pulumi.getter(name="numberOfNodes")
    def number_of_nodes(self) -> Optional[pulumi.Input[int]]:
        """
        The number of compute nodes in the cluster. This parameter is required when the ClusterType parameter is specified as multi-node. Default is 1.
        """
        return pulumi.get(self, "number_of_nodes")

    @number_of_nodes.setter
    def number_of_nodes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number_of_nodes", value)

    @property
    @pulumi.getter(name="ownerAccount")
    def owner_account(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS customer account used to create or copy the snapshot. Required if you are restoring a snapshot you do not own, optional if you own the snapshot.
        """
        return pulumi.get(self, "owner_account")

    @owner_account.setter
    def owner_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner_account", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port number on which the cluster accepts incoming connections. Valid values are between `1115` and `65535`.
        The cluster is accessible only via the JDBC and ODBC connection strings.
        Part of the connection string requires the port on which the cluster will listen for incoming connections.
        Default port is `5439`.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> Optional[pulumi.Input[str]]:
        """
        The weekly time range (in UTC) during which automated cluster maintenance can occur.
        Format: ddd:hh24:mi-ddd:hh24:mi
        """
        return pulumi.get(self, "preferred_maintenance_window")

    @preferred_maintenance_window.setter
    def preferred_maintenance_window(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_maintenance_window", value)

    @property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the cluster can be accessed from a public network. Default is `true`.
        """
        return pulumi.get(self, "publicly_accessible")

    @publicly_accessible.setter
    def publicly_accessible(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "publicly_accessible", value)

    @property
    @pulumi.getter(name="skipFinalSnapshot")
    def skip_final_snapshot(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines whether a final snapshot of the cluster is created before Amazon Redshift deletes the cluster. If true , a final cluster snapshot is not created. If false , a final cluster snapshot is created before the cluster is deleted. Default is false.
        """
        return pulumi.get(self, "skip_final_snapshot")

    @skip_final_snapshot.setter
    def skip_final_snapshot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_final_snapshot", value)

    @property
    @pulumi.getter(name="snapshotClusterIdentifier")
    def snapshot_cluster_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the cluster the source snapshot was created from.
        """
        return pulumi.get(self, "snapshot_cluster_identifier")

    @snapshot_cluster_identifier.setter
    def snapshot_cluster_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_cluster_identifier", value)

    @property
    @pulumi.getter(name="snapshotCopy")
    def snapshot_copy(self) -> Optional[pulumi.Input['ClusterSnapshotCopyArgs']]:
        """
        Configuration of automatic copy of snapshots from one region to another. Documented below.
        """
        return pulumi.get(self, "snapshot_copy")

    @snapshot_copy.setter
    def snapshot_copy(self, value: Optional[pulumi.Input['ClusterSnapshotCopyArgs']]):
        pulumi.set(self, "snapshot_copy", value)

    @property
    @pulumi.getter(name="snapshotIdentifier")
    def snapshot_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the snapshot from which to create the new cluster.
        """
        return pulumi.get(self, "snapshot_identifier")

    @snapshot_identifier.setter
    def snapshot_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_identifier", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="vpcSecurityGroupIds")
    def vpc_security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.
        """
        return pulumi.get(self, "vpc_security_group_ids")

    @vpc_security_group_ids.setter
    def vpc_security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vpc_security_group_ids", value)


class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_version_upgrade: Optional[pulumi.Input[bool]] = None,
                 apply_immediately: Optional[pulumi.Input[bool]] = None,
                 aqua_configuration_status: Optional[pulumi.Input[str]] = None,
                 automated_snapshot_retention_period: Optional[pulumi.Input[int]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 availability_zone_relocation_enabled: Optional[pulumi.Input[bool]] = None,
                 cluster_identifier: Optional[pulumi.Input[str]] = None,
                 cluster_parameter_group_name: Optional[pulumi.Input[str]] = None,
                 cluster_public_key: Optional[pulumi.Input[str]] = None,
                 cluster_revision_number: Optional[pulumi.Input[str]] = None,
                 cluster_subnet_group_name: Optional[pulumi.Input[str]] = None,
                 cluster_type: Optional[pulumi.Input[str]] = None,
                 cluster_version: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 default_iam_role_arn: Optional[pulumi.Input[str]] = None,
                 elastic_ip: Optional[pulumi.Input[str]] = None,
                 encrypted: Optional[pulumi.Input[bool]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 enhanced_vpc_routing: Optional[pulumi.Input[bool]] = None,
                 final_snapshot_identifier: Optional[pulumi.Input[str]] = None,
                 iam_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 logging: Optional[pulumi.Input[pulumi.InputType['ClusterLoggingArgs']]] = None,
                 maintenance_track_name: Optional[pulumi.Input[str]] = None,
                 manual_snapshot_retention_period: Optional[pulumi.Input[int]] = None,
                 master_password: Optional[pulumi.Input[str]] = None,
                 master_username: Optional[pulumi.Input[str]] = None,
                 node_type: Optional[pulumi.Input[str]] = None,
                 number_of_nodes: Optional[pulumi.Input[int]] = None,
                 owner_account: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[str]] = None,
                 publicly_accessible: Optional[pulumi.Input[bool]] = None,
                 skip_final_snapshot: Optional[pulumi.Input[bool]] = None,
                 snapshot_cluster_identifier: Optional[pulumi.Input[str]] = None,
                 snapshot_copy: Optional[pulumi.Input[pulumi.InputType['ClusterSnapshotCopyArgs']]] = None,
                 snapshot_identifier: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Provides a Redshift Cluster Resource.

        > **NOTE:** A Redshift cluster's default IAM role can be managed both by this resource's `default_iam_role_arn` argument and the `redshift.ClusterIamRoles` resource's `default_iam_role_arn` argument. Do not configure different values for both arguments. Doing so will cause a conflict of default IAM roles.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.redshift.Cluster("example",
            cluster_identifier="tf-redshift-cluster",
            cluster_type="single-node",
            database_name="mydb",
            master_password="Mustbe8characters",
            master_username="exampleuser",
            node_type="dc1.large")
        ```

        ## Import

        Using `pulumi import`, import Redshift Clusters using the `cluster_identifier`. For example:

        ```sh
         $ pulumi import aws:redshift/cluster:Cluster myprodcluster tf-redshift-cluster-12345
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_version_upgrade: If true , major version upgrades can be applied during the maintenance window to the Amazon Redshift engine that is running on the cluster. Default is `true`.
        :param pulumi.Input[bool] apply_immediately: Specifies whether any cluster modifications are applied immediately, or during the next maintenance window. Default is `false`.
        :param pulumi.Input[str] aqua_configuration_status: The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) after the cluster is restored.
               No longer supported by the AWS API.
               Always returns `auto`.
        :param pulumi.Input[int] automated_snapshot_retention_period: The number of days that automated snapshots are retained. If the value is 0, automated snapshots are disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want with create-cluster-snapshot. Default is 1.
        :param pulumi.Input[str] availability_zone: The EC2 Availability Zone (AZ) in which you want Amazon Redshift to provision the cluster. For example, if you have several EC2 instances running in a specific Availability Zone, then you might want the cluster to be provisioned in the same zone in order to decrease network latency. Can only be changed if `availability_zone_relocation_enabled` is `true`.
        :param pulumi.Input[bool] availability_zone_relocation_enabled: If true, the cluster can be relocated to another availabity zone, either automatically by AWS or when requested. Default is `false`. Available for use on clusters from the RA3 instance family.
        :param pulumi.Input[str] cluster_identifier: The Cluster Identifier. Must be a lower case string.
        :param pulumi.Input[str] cluster_parameter_group_name: The name of the parameter group to be associated with this cluster.
        :param pulumi.Input[str] cluster_public_key: The public key for the cluster
        :param pulumi.Input[str] cluster_revision_number: The specific revision number of the database in the cluster
        :param pulumi.Input[str] cluster_subnet_group_name: The name of a cluster subnet group to be associated with this cluster. If this parameter is not provided the resulting cluster will be deployed outside virtual private cloud (VPC).
        :param pulumi.Input[str] cluster_type: The cluster type to use. Either `single-node` or `multi-node`.
        :param pulumi.Input[str] cluster_version: The version of the Amazon Redshift engine software that you want to deploy on the cluster.
               The version selected runs on all the nodes in the cluster.
        :param pulumi.Input[str] database_name: The name of the first database to be created when the cluster is created.
               If you do not provide a name, Amazon Redshift will create a default database called `dev`.
        :param pulumi.Input[str] default_iam_role_arn: The Amazon Resource Name (ARN) for the IAM role that was set as default for the cluster when the cluster was created.
        :param pulumi.Input[str] elastic_ip: The Elastic IP (EIP) address for the cluster.
        :param pulumi.Input[bool] encrypted: If true , the data in the cluster is encrypted at rest.
        :param pulumi.Input[str] endpoint: The connection endpoint
        :param pulumi.Input[bool] enhanced_vpc_routing: If true , enhanced VPC routing is enabled.
        :param pulumi.Input[str] final_snapshot_identifier: The identifier of the final snapshot that is to be created immediately before deleting the cluster. If this parameter is provided, `skip_final_snapshot` must be false.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] iam_roles: A list of IAM Role ARNs to associate with the cluster. A Maximum of 10 can be associated to the cluster at any time.
        :param pulumi.Input[str] kms_key_id: The ARN for the KMS encryption key. When specifying `kms_key_id`, `encrypted` needs to be set to true.
        :param pulumi.Input[pulumi.InputType['ClusterLoggingArgs']] logging: Logging, documented below.
        :param pulumi.Input[str] maintenance_track_name: The name of the maintenance track for the restored cluster. When you take a snapshot, the snapshot inherits the MaintenanceTrack value from the cluster. The snapshot might be on a different track than the cluster that was the source for the snapshot. For example, suppose that you take a snapshot of  a cluster that is on the current track and then change the cluster to be on the trailing track. In this case, the snapshot and the source cluster are on different tracks. Default value is `current`.
        :param pulumi.Input[int] manual_snapshot_retention_period: The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained indefinitely. This setting doesn't change the retention period of existing snapshots. Valid values are between `-1` and `3653`. Default value is `-1`.
        :param pulumi.Input[str] master_password: Password for the master DB user.
               Note that this may show up in logs, and it will be stored in the state file. Password must contain at least 8 chars and
               contain at least one uppercase letter, one lowercase letter, and one number.
        :param pulumi.Input[str] master_username: Username for the master DB user.
        :param pulumi.Input[str] node_type: The node type to be provisioned for the cluster.
        :param pulumi.Input[int] number_of_nodes: The number of compute nodes in the cluster. This parameter is required when the ClusterType parameter is specified as multi-node. Default is 1.
        :param pulumi.Input[str] owner_account: The AWS customer account used to create or copy the snapshot. Required if you are restoring a snapshot you do not own, optional if you own the snapshot.
        :param pulumi.Input[int] port: The port number on which the cluster accepts incoming connections. Valid values are between `1115` and `65535`.
               The cluster is accessible only via the JDBC and ODBC connection strings.
               Part of the connection string requires the port on which the cluster will listen for incoming connections.
               Default port is `5439`.
        :param pulumi.Input[str] preferred_maintenance_window: The weekly time range (in UTC) during which automated cluster maintenance can occur.
               Format: ddd:hh24:mi-ddd:hh24:mi
        :param pulumi.Input[bool] publicly_accessible: If true, the cluster can be accessed from a public network. Default is `true`.
        :param pulumi.Input[bool] skip_final_snapshot: Determines whether a final snapshot of the cluster is created before Amazon Redshift deletes the cluster. If true , a final cluster snapshot is not created. If false , a final cluster snapshot is created before the cluster is deleted. Default is false.
        :param pulumi.Input[str] snapshot_cluster_identifier: The name of the cluster the source snapshot was created from.
        :param pulumi.Input[pulumi.InputType['ClusterSnapshotCopyArgs']] snapshot_copy: Configuration of automatic copy of snapshots from one region to another. Documented below.
        :param pulumi.Input[str] snapshot_identifier: The name of the snapshot from which to create the new cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_security_group_ids: A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Redshift Cluster Resource.

        > **NOTE:** A Redshift cluster's default IAM role can be managed both by this resource's `default_iam_role_arn` argument and the `redshift.ClusterIamRoles` resource's `default_iam_role_arn` argument. Do not configure different values for both arguments. Doing so will cause a conflict of default IAM roles.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.redshift.Cluster("example",
            cluster_identifier="tf-redshift-cluster",
            cluster_type="single-node",
            database_name="mydb",
            master_password="Mustbe8characters",
            master_username="exampleuser",
            node_type="dc1.large")
        ```

        ## Import

        Using `pulumi import`, import Redshift Clusters using the `cluster_identifier`. For example:

        ```sh
         $ pulumi import aws:redshift/cluster:Cluster myprodcluster tf-redshift-cluster-12345
        ```

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_version_upgrade: Optional[pulumi.Input[bool]] = None,
                 apply_immediately: Optional[pulumi.Input[bool]] = None,
                 aqua_configuration_status: Optional[pulumi.Input[str]] = None,
                 automated_snapshot_retention_period: Optional[pulumi.Input[int]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 availability_zone_relocation_enabled: Optional[pulumi.Input[bool]] = None,
                 cluster_identifier: Optional[pulumi.Input[str]] = None,
                 cluster_parameter_group_name: Optional[pulumi.Input[str]] = None,
                 cluster_public_key: Optional[pulumi.Input[str]] = None,
                 cluster_revision_number: Optional[pulumi.Input[str]] = None,
                 cluster_subnet_group_name: Optional[pulumi.Input[str]] = None,
                 cluster_type: Optional[pulumi.Input[str]] = None,
                 cluster_version: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 default_iam_role_arn: Optional[pulumi.Input[str]] = None,
                 elastic_ip: Optional[pulumi.Input[str]] = None,
                 encrypted: Optional[pulumi.Input[bool]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 enhanced_vpc_routing: Optional[pulumi.Input[bool]] = None,
                 final_snapshot_identifier: Optional[pulumi.Input[str]] = None,
                 iam_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 logging: Optional[pulumi.Input[pulumi.InputType['ClusterLoggingArgs']]] = None,
                 maintenance_track_name: Optional[pulumi.Input[str]] = None,
                 manual_snapshot_retention_period: Optional[pulumi.Input[int]] = None,
                 master_password: Optional[pulumi.Input[str]] = None,
                 master_username: Optional[pulumi.Input[str]] = None,
                 node_type: Optional[pulumi.Input[str]] = None,
                 number_of_nodes: Optional[pulumi.Input[int]] = None,
                 owner_account: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[str]] = None,
                 publicly_accessible: Optional[pulumi.Input[bool]] = None,
                 skip_final_snapshot: Optional[pulumi.Input[bool]] = None,
                 snapshot_cluster_identifier: Optional[pulumi.Input[str]] = None,
                 snapshot_copy: Optional[pulumi.Input[pulumi.InputType['ClusterSnapshotCopyArgs']]] = None,
                 snapshot_identifier: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["allow_version_upgrade"] = allow_version_upgrade
            __props__.__dict__["apply_immediately"] = apply_immediately
            if aqua_configuration_status is not None and not opts.urn:
                warnings.warn("""This parameter is no longer supported by the AWS API. It will be removed in the next major version of the provider.""", DeprecationWarning)
                pulumi.log.warn("""aqua_configuration_status is deprecated: This parameter is no longer supported by the AWS API. It will be removed in the next major version of the provider.""")
            __props__.__dict__["aqua_configuration_status"] = aqua_configuration_status
            __props__.__dict__["automated_snapshot_retention_period"] = automated_snapshot_retention_period
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["availability_zone_relocation_enabled"] = availability_zone_relocation_enabled
            if cluster_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_identifier'")
            __props__.__dict__["cluster_identifier"] = cluster_identifier
            __props__.__dict__["cluster_parameter_group_name"] = cluster_parameter_group_name
            __props__.__dict__["cluster_public_key"] = cluster_public_key
            __props__.__dict__["cluster_revision_number"] = cluster_revision_number
            __props__.__dict__["cluster_subnet_group_name"] = cluster_subnet_group_name
            __props__.__dict__["cluster_type"] = cluster_type
            __props__.__dict__["cluster_version"] = cluster_version
            __props__.__dict__["database_name"] = database_name
            __props__.__dict__["default_iam_role_arn"] = default_iam_role_arn
            __props__.__dict__["elastic_ip"] = elastic_ip
            __props__.__dict__["encrypted"] = encrypted
            __props__.__dict__["endpoint"] = endpoint
            __props__.__dict__["enhanced_vpc_routing"] = enhanced_vpc_routing
            __props__.__dict__["final_snapshot_identifier"] = final_snapshot_identifier
            __props__.__dict__["iam_roles"] = iam_roles
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["logging"] = logging
            __props__.__dict__["maintenance_track_name"] = maintenance_track_name
            __props__.__dict__["manual_snapshot_retention_period"] = manual_snapshot_retention_period
            __props__.__dict__["master_password"] = None if master_password is None else pulumi.Output.secret(master_password)
            __props__.__dict__["master_username"] = master_username
            if node_type is None and not opts.urn:
                raise TypeError("Missing required property 'node_type'")
            __props__.__dict__["node_type"] = node_type
            __props__.__dict__["number_of_nodes"] = number_of_nodes
            __props__.__dict__["owner_account"] = owner_account
            __props__.__dict__["port"] = port
            __props__.__dict__["preferred_maintenance_window"] = preferred_maintenance_window
            __props__.__dict__["publicly_accessible"] = publicly_accessible
            __props__.__dict__["skip_final_snapshot"] = skip_final_snapshot
            __props__.__dict__["snapshot_cluster_identifier"] = snapshot_cluster_identifier
            __props__.__dict__["snapshot_copy"] = snapshot_copy
            __props__.__dict__["snapshot_identifier"] = snapshot_identifier
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpc_security_group_ids"] = vpc_security_group_ids
            __props__.__dict__["arn"] = None
            __props__.__dict__["cluster_namespace_arn"] = None
            __props__.__dict__["cluster_nodes"] = None
            __props__.__dict__["dns_name"] = None
            __props__.__dict__["tags_all"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["masterPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Cluster, __self__).__init__(
            'aws:redshift/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_version_upgrade: Optional[pulumi.Input[bool]] = None,
            apply_immediately: Optional[pulumi.Input[bool]] = None,
            aqua_configuration_status: Optional[pulumi.Input[str]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            automated_snapshot_retention_period: Optional[pulumi.Input[int]] = None,
            availability_zone: Optional[pulumi.Input[str]] = None,
            availability_zone_relocation_enabled: Optional[pulumi.Input[bool]] = None,
            cluster_identifier: Optional[pulumi.Input[str]] = None,
            cluster_namespace_arn: Optional[pulumi.Input[str]] = None,
            cluster_nodes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterClusterNodeArgs']]]]] = None,
            cluster_parameter_group_name: Optional[pulumi.Input[str]] = None,
            cluster_public_key: Optional[pulumi.Input[str]] = None,
            cluster_revision_number: Optional[pulumi.Input[str]] = None,
            cluster_subnet_group_name: Optional[pulumi.Input[str]] = None,
            cluster_type: Optional[pulumi.Input[str]] = None,
            cluster_version: Optional[pulumi.Input[str]] = None,
            database_name: Optional[pulumi.Input[str]] = None,
            default_iam_role_arn: Optional[pulumi.Input[str]] = None,
            dns_name: Optional[pulumi.Input[str]] = None,
            elastic_ip: Optional[pulumi.Input[str]] = None,
            encrypted: Optional[pulumi.Input[bool]] = None,
            endpoint: Optional[pulumi.Input[str]] = None,
            enhanced_vpc_routing: Optional[pulumi.Input[bool]] = None,
            final_snapshot_identifier: Optional[pulumi.Input[str]] = None,
            iam_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            kms_key_id: Optional[pulumi.Input[str]] = None,
            logging: Optional[pulumi.Input[pulumi.InputType['ClusterLoggingArgs']]] = None,
            maintenance_track_name: Optional[pulumi.Input[str]] = None,
            manual_snapshot_retention_period: Optional[pulumi.Input[int]] = None,
            master_password: Optional[pulumi.Input[str]] = None,
            master_username: Optional[pulumi.Input[str]] = None,
            node_type: Optional[pulumi.Input[str]] = None,
            number_of_nodes: Optional[pulumi.Input[int]] = None,
            owner_account: Optional[pulumi.Input[str]] = None,
            port: Optional[pulumi.Input[int]] = None,
            preferred_maintenance_window: Optional[pulumi.Input[str]] = None,
            publicly_accessible: Optional[pulumi.Input[bool]] = None,
            skip_final_snapshot: Optional[pulumi.Input[bool]] = None,
            snapshot_cluster_identifier: Optional[pulumi.Input[str]] = None,
            snapshot_copy: Optional[pulumi.Input[pulumi.InputType['ClusterSnapshotCopyArgs']]] = None,
            snapshot_identifier: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_version_upgrade: If true , major version upgrades can be applied during the maintenance window to the Amazon Redshift engine that is running on the cluster. Default is `true`.
        :param pulumi.Input[bool] apply_immediately: Specifies whether any cluster modifications are applied immediately, or during the next maintenance window. Default is `false`.
        :param pulumi.Input[str] aqua_configuration_status: The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) after the cluster is restored.
               No longer supported by the AWS API.
               Always returns `auto`.
        :param pulumi.Input[str] arn: Amazon Resource Name (ARN) of cluster
        :param pulumi.Input[int] automated_snapshot_retention_period: The number of days that automated snapshots are retained. If the value is 0, automated snapshots are disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want with create-cluster-snapshot. Default is 1.
        :param pulumi.Input[str] availability_zone: The EC2 Availability Zone (AZ) in which you want Amazon Redshift to provision the cluster. For example, if you have several EC2 instances running in a specific Availability Zone, then you might want the cluster to be provisioned in the same zone in order to decrease network latency. Can only be changed if `availability_zone_relocation_enabled` is `true`.
        :param pulumi.Input[bool] availability_zone_relocation_enabled: If true, the cluster can be relocated to another availabity zone, either automatically by AWS or when requested. Default is `false`. Available for use on clusters from the RA3 instance family.
        :param pulumi.Input[str] cluster_identifier: The Cluster Identifier. Must be a lower case string.
        :param pulumi.Input[str] cluster_namespace_arn: The namespace Amazon Resource Name (ARN) of the cluster
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterClusterNodeArgs']]]] cluster_nodes: The nodes in the cluster. Cluster node blocks are documented below
        :param pulumi.Input[str] cluster_parameter_group_name: The name of the parameter group to be associated with this cluster.
        :param pulumi.Input[str] cluster_public_key: The public key for the cluster
        :param pulumi.Input[str] cluster_revision_number: The specific revision number of the database in the cluster
        :param pulumi.Input[str] cluster_subnet_group_name: The name of a cluster subnet group to be associated with this cluster. If this parameter is not provided the resulting cluster will be deployed outside virtual private cloud (VPC).
        :param pulumi.Input[str] cluster_type: The cluster type to use. Either `single-node` or `multi-node`.
        :param pulumi.Input[str] cluster_version: The version of the Amazon Redshift engine software that you want to deploy on the cluster.
               The version selected runs on all the nodes in the cluster.
        :param pulumi.Input[str] database_name: The name of the first database to be created when the cluster is created.
               If you do not provide a name, Amazon Redshift will create a default database called `dev`.
        :param pulumi.Input[str] default_iam_role_arn: The Amazon Resource Name (ARN) for the IAM role that was set as default for the cluster when the cluster was created.
        :param pulumi.Input[str] dns_name: The DNS name of the cluster
        :param pulumi.Input[str] elastic_ip: The Elastic IP (EIP) address for the cluster.
        :param pulumi.Input[bool] encrypted: If true , the data in the cluster is encrypted at rest.
        :param pulumi.Input[str] endpoint: The connection endpoint
        :param pulumi.Input[bool] enhanced_vpc_routing: If true , enhanced VPC routing is enabled.
        :param pulumi.Input[str] final_snapshot_identifier: The identifier of the final snapshot that is to be created immediately before deleting the cluster. If this parameter is provided, `skip_final_snapshot` must be false.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] iam_roles: A list of IAM Role ARNs to associate with the cluster. A Maximum of 10 can be associated to the cluster at any time.
        :param pulumi.Input[str] kms_key_id: The ARN for the KMS encryption key. When specifying `kms_key_id`, `encrypted` needs to be set to true.
        :param pulumi.Input[pulumi.InputType['ClusterLoggingArgs']] logging: Logging, documented below.
        :param pulumi.Input[str] maintenance_track_name: The name of the maintenance track for the restored cluster. When you take a snapshot, the snapshot inherits the MaintenanceTrack value from the cluster. The snapshot might be on a different track than the cluster that was the source for the snapshot. For example, suppose that you take a snapshot of  a cluster that is on the current track and then change the cluster to be on the trailing track. In this case, the snapshot and the source cluster are on different tracks. Default value is `current`.
        :param pulumi.Input[int] manual_snapshot_retention_period: The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained indefinitely. This setting doesn't change the retention period of existing snapshots. Valid values are between `-1` and `3653`. Default value is `-1`.
        :param pulumi.Input[str] master_password: Password for the master DB user.
               Note that this may show up in logs, and it will be stored in the state file. Password must contain at least 8 chars and
               contain at least one uppercase letter, one lowercase letter, and one number.
        :param pulumi.Input[str] master_username: Username for the master DB user.
        :param pulumi.Input[str] node_type: The node type to be provisioned for the cluster.
        :param pulumi.Input[int] number_of_nodes: The number of compute nodes in the cluster. This parameter is required when the ClusterType parameter is specified as multi-node. Default is 1.
        :param pulumi.Input[str] owner_account: The AWS customer account used to create or copy the snapshot. Required if you are restoring a snapshot you do not own, optional if you own the snapshot.
        :param pulumi.Input[int] port: The port number on which the cluster accepts incoming connections. Valid values are between `1115` and `65535`.
               The cluster is accessible only via the JDBC and ODBC connection strings.
               Part of the connection string requires the port on which the cluster will listen for incoming connections.
               Default port is `5439`.
        :param pulumi.Input[str] preferred_maintenance_window: The weekly time range (in UTC) during which automated cluster maintenance can occur.
               Format: ddd:hh24:mi-ddd:hh24:mi
        :param pulumi.Input[bool] publicly_accessible: If true, the cluster can be accessed from a public network. Default is `true`.
        :param pulumi.Input[bool] skip_final_snapshot: Determines whether a final snapshot of the cluster is created before Amazon Redshift deletes the cluster. If true , a final cluster snapshot is not created. If false , a final cluster snapshot is created before the cluster is deleted. Default is false.
        :param pulumi.Input[str] snapshot_cluster_identifier: The name of the cluster the source snapshot was created from.
        :param pulumi.Input[pulumi.InputType['ClusterSnapshotCopyArgs']] snapshot_copy: Configuration of automatic copy of snapshots from one region to another. Documented below.
        :param pulumi.Input[str] snapshot_identifier: The name of the snapshot from which to create the new cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_security_group_ids: A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["allow_version_upgrade"] = allow_version_upgrade
        __props__.__dict__["apply_immediately"] = apply_immediately
        __props__.__dict__["aqua_configuration_status"] = aqua_configuration_status
        __props__.__dict__["arn"] = arn
        __props__.__dict__["automated_snapshot_retention_period"] = automated_snapshot_retention_period
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["availability_zone_relocation_enabled"] = availability_zone_relocation_enabled
        __props__.__dict__["cluster_identifier"] = cluster_identifier
        __props__.__dict__["cluster_namespace_arn"] = cluster_namespace_arn
        __props__.__dict__["cluster_nodes"] = cluster_nodes
        __props__.__dict__["cluster_parameter_group_name"] = cluster_parameter_group_name
        __props__.__dict__["cluster_public_key"] = cluster_public_key
        __props__.__dict__["cluster_revision_number"] = cluster_revision_number
        __props__.__dict__["cluster_subnet_group_name"] = cluster_subnet_group_name
        __props__.__dict__["cluster_type"] = cluster_type
        __props__.__dict__["cluster_version"] = cluster_version
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["default_iam_role_arn"] = default_iam_role_arn
        __props__.__dict__["dns_name"] = dns_name
        __props__.__dict__["elastic_ip"] = elastic_ip
        __props__.__dict__["encrypted"] = encrypted
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["enhanced_vpc_routing"] = enhanced_vpc_routing
        __props__.__dict__["final_snapshot_identifier"] = final_snapshot_identifier
        __props__.__dict__["iam_roles"] = iam_roles
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["logging"] = logging
        __props__.__dict__["maintenance_track_name"] = maintenance_track_name
        __props__.__dict__["manual_snapshot_retention_period"] = manual_snapshot_retention_period
        __props__.__dict__["master_password"] = master_password
        __props__.__dict__["master_username"] = master_username
        __props__.__dict__["node_type"] = node_type
        __props__.__dict__["number_of_nodes"] = number_of_nodes
        __props__.__dict__["owner_account"] = owner_account
        __props__.__dict__["port"] = port
        __props__.__dict__["preferred_maintenance_window"] = preferred_maintenance_window
        __props__.__dict__["publicly_accessible"] = publicly_accessible
        __props__.__dict__["skip_final_snapshot"] = skip_final_snapshot
        __props__.__dict__["snapshot_cluster_identifier"] = snapshot_cluster_identifier
        __props__.__dict__["snapshot_copy"] = snapshot_copy
        __props__.__dict__["snapshot_identifier"] = snapshot_identifier
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["vpc_security_group_ids"] = vpc_security_group_ids
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowVersionUpgrade")
    def allow_version_upgrade(self) -> pulumi.Output[Optional[bool]]:
        """
        If true , major version upgrades can be applied during the maintenance window to the Amazon Redshift engine that is running on the cluster. Default is `true`.
        """
        return pulumi.get(self, "allow_version_upgrade")

    @property
    @pulumi.getter(name="applyImmediately")
    def apply_immediately(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether any cluster modifications are applied immediately, or during the next maintenance window. Default is `false`.
        """
        return pulumi.get(self, "apply_immediately")

    @property
    @pulumi.getter(name="aquaConfigurationStatus")
    def aqua_configuration_status(self) -> pulumi.Output[str]:
        """
        The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) after the cluster is restored.
        No longer supported by the AWS API.
        Always returns `auto`.
        """
        warnings.warn("""This parameter is no longer supported by the AWS API. It will be removed in the next major version of the provider.""", DeprecationWarning)
        pulumi.log.warn("""aqua_configuration_status is deprecated: This parameter is no longer supported by the AWS API. It will be removed in the next major version of the provider.""")

        return pulumi.get(self, "aqua_configuration_status")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        Amazon Resource Name (ARN) of cluster
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="automatedSnapshotRetentionPeriod")
    def automated_snapshot_retention_period(self) -> pulumi.Output[Optional[int]]:
        """
        The number of days that automated snapshots are retained. If the value is 0, automated snapshots are disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want with create-cluster-snapshot. Default is 1.
        """
        return pulumi.get(self, "automated_snapshot_retention_period")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[str]:
        """
        The EC2 Availability Zone (AZ) in which you want Amazon Redshift to provision the cluster. For example, if you have several EC2 instances running in a specific Availability Zone, then you might want the cluster to be provisioned in the same zone in order to decrease network latency. Can only be changed if `availability_zone_relocation_enabled` is `true`.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="availabilityZoneRelocationEnabled")
    def availability_zone_relocation_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, the cluster can be relocated to another availabity zone, either automatically by AWS or when requested. Default is `false`. Available for use on clusters from the RA3 instance family.
        """
        return pulumi.get(self, "availability_zone_relocation_enabled")

    @property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> pulumi.Output[str]:
        """
        The Cluster Identifier. Must be a lower case string.
        """
        return pulumi.get(self, "cluster_identifier")

    @property
    @pulumi.getter(name="clusterNamespaceArn")
    def cluster_namespace_arn(self) -> pulumi.Output[str]:
        """
        The namespace Amazon Resource Name (ARN) of the cluster
        """
        return pulumi.get(self, "cluster_namespace_arn")

    @property
    @pulumi.getter(name="clusterNodes")
    def cluster_nodes(self) -> pulumi.Output[Sequence['outputs.ClusterClusterNode']]:
        """
        The nodes in the cluster. Cluster node blocks are documented below
        """
        return pulumi.get(self, "cluster_nodes")

    @property
    @pulumi.getter(name="clusterParameterGroupName")
    def cluster_parameter_group_name(self) -> pulumi.Output[str]:
        """
        The name of the parameter group to be associated with this cluster.
        """
        return pulumi.get(self, "cluster_parameter_group_name")

    @property
    @pulumi.getter(name="clusterPublicKey")
    def cluster_public_key(self) -> pulumi.Output[str]:
        """
        The public key for the cluster
        """
        return pulumi.get(self, "cluster_public_key")

    @property
    @pulumi.getter(name="clusterRevisionNumber")
    def cluster_revision_number(self) -> pulumi.Output[str]:
        """
        The specific revision number of the database in the cluster
        """
        return pulumi.get(self, "cluster_revision_number")

    @property
    @pulumi.getter(name="clusterSubnetGroupName")
    def cluster_subnet_group_name(self) -> pulumi.Output[str]:
        """
        The name of a cluster subnet group to be associated with this cluster. If this parameter is not provided the resulting cluster will be deployed outside virtual private cloud (VPC).
        """
        return pulumi.get(self, "cluster_subnet_group_name")

    @property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> pulumi.Output[str]:
        """
        The cluster type to use. Either `single-node` or `multi-node`.
        """
        return pulumi.get(self, "cluster_type")

    @property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> pulumi.Output[Optional[str]]:
        """
        The version of the Amazon Redshift engine software that you want to deploy on the cluster.
        The version selected runs on all the nodes in the cluster.
        """
        return pulumi.get(self, "cluster_version")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[str]:
        """
        The name of the first database to be created when the cluster is created.
        If you do not provide a name, Amazon Redshift will create a default database called `dev`.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="defaultIamRoleArn")
    def default_iam_role_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) for the IAM role that was set as default for the cluster when the cluster was created.
        """
        return pulumi.get(self, "default_iam_role_arn")

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> pulumi.Output[str]:
        """
        The DNS name of the cluster
        """
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="elasticIp")
    def elastic_ip(self) -> pulumi.Output[Optional[str]]:
        """
        The Elastic IP (EIP) address for the cluster.
        """
        return pulumi.get(self, "elastic_ip")

    @property
    @pulumi.getter
    def encrypted(self) -> pulumi.Output[Optional[bool]]:
        """
        If true , the data in the cluster is encrypted at rest.
        """
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[str]:
        """
        The connection endpoint
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="enhancedVpcRouting")
    def enhanced_vpc_routing(self) -> pulumi.Output[bool]:
        """
        If true , enhanced VPC routing is enabled.
        """
        return pulumi.get(self, "enhanced_vpc_routing")

    @property
    @pulumi.getter(name="finalSnapshotIdentifier")
    def final_snapshot_identifier(self) -> pulumi.Output[Optional[str]]:
        """
        The identifier of the final snapshot that is to be created immediately before deleting the cluster. If this parameter is provided, `skip_final_snapshot` must be false.
        """
        return pulumi.get(self, "final_snapshot_identifier")

    @property
    @pulumi.getter(name="iamRoles")
    def iam_roles(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of IAM Role ARNs to associate with the cluster. A Maximum of 10 can be associated to the cluster at any time.
        """
        return pulumi.get(self, "iam_roles")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[str]:
        """
        The ARN for the KMS encryption key. When specifying `kms_key_id`, `encrypted` needs to be set to true.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter
    def logging(self) -> pulumi.Output[Optional['outputs.ClusterLogging']]:
        """
        Logging, documented below.
        """
        return pulumi.get(self, "logging")

    @property
    @pulumi.getter(name="maintenanceTrackName")
    def maintenance_track_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the maintenance track for the restored cluster. When you take a snapshot, the snapshot inherits the MaintenanceTrack value from the cluster. The snapshot might be on a different track than the cluster that was the source for the snapshot. For example, suppose that you take a snapshot of  a cluster that is on the current track and then change the cluster to be on the trailing track. In this case, the snapshot and the source cluster are on different tracks. Default value is `current`.
        """
        return pulumi.get(self, "maintenance_track_name")

    @property
    @pulumi.getter(name="manualSnapshotRetentionPeriod")
    def manual_snapshot_retention_period(self) -> pulumi.Output[Optional[int]]:
        """
        The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained indefinitely. This setting doesn't change the retention period of existing snapshots. Valid values are between `-1` and `3653`. Default value is `-1`.
        """
        return pulumi.get(self, "manual_snapshot_retention_period")

    @property
    @pulumi.getter(name="masterPassword")
    def master_password(self) -> pulumi.Output[Optional[str]]:
        """
        Password for the master DB user.
        Note that this may show up in logs, and it will be stored in the state file. Password must contain at least 8 chars and
        contain at least one uppercase letter, one lowercase letter, and one number.
        """
        return pulumi.get(self, "master_password")

    @property
    @pulumi.getter(name="masterUsername")
    def master_username(self) -> pulumi.Output[Optional[str]]:
        """
        Username for the master DB user.
        """
        return pulumi.get(self, "master_username")

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Output[str]:
        """
        The node type to be provisioned for the cluster.
        """
        return pulumi.get(self, "node_type")

    @property
    @pulumi.getter(name="numberOfNodes")
    def number_of_nodes(self) -> pulumi.Output[Optional[int]]:
        """
        The number of compute nodes in the cluster. This parameter is required when the ClusterType parameter is specified as multi-node. Default is 1.
        """
        return pulumi.get(self, "number_of_nodes")

    @property
    @pulumi.getter(name="ownerAccount")
    def owner_account(self) -> pulumi.Output[Optional[str]]:
        """
        The AWS customer account used to create or copy the snapshot. Required if you are restoring a snapshot you do not own, optional if you own the snapshot.
        """
        return pulumi.get(self, "owner_account")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[int]]:
        """
        The port number on which the cluster accepts incoming connections. Valid values are between `1115` and `65535`.
        The cluster is accessible only via the JDBC and ODBC connection strings.
        Part of the connection string requires the port on which the cluster will listen for incoming connections.
        Default port is `5439`.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> pulumi.Output[str]:
        """
        The weekly time range (in UTC) during which automated cluster maintenance can occur.
        Format: ddd:hh24:mi-ddd:hh24:mi
        """
        return pulumi.get(self, "preferred_maintenance_window")

    @property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, the cluster can be accessed from a public network. Default is `true`.
        """
        return pulumi.get(self, "publicly_accessible")

    @property
    @pulumi.getter(name="skipFinalSnapshot")
    def skip_final_snapshot(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines whether a final snapshot of the cluster is created before Amazon Redshift deletes the cluster. If true , a final cluster snapshot is not created. If false , a final cluster snapshot is created before the cluster is deleted. Default is false.
        """
        return pulumi.get(self, "skip_final_snapshot")

    @property
    @pulumi.getter(name="snapshotClusterIdentifier")
    def snapshot_cluster_identifier(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the cluster the source snapshot was created from.
        """
        return pulumi.get(self, "snapshot_cluster_identifier")

    @property
    @pulumi.getter(name="snapshotCopy")
    def snapshot_copy(self) -> pulumi.Output[Optional['outputs.ClusterSnapshotCopy']]:
        """
        Configuration of automatic copy of snapshots from one region to another. Documented below.
        """
        return pulumi.get(self, "snapshot_copy")

    @property
    @pulumi.getter(name="snapshotIdentifier")
    def snapshot_identifier(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the snapshot from which to create the new cluster.
        """
        return pulumi.get(self, "snapshot_identifier")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="vpcSecurityGroupIds")
    def vpc_security_group_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.
        """
        return pulumi.get(self, "vpc_security_group_ids")

