# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['StatementArgs', 'Statement']

@pulumi.input_type
class StatementArgs:
    def __init__(__self__, *,
                 database: pulumi.Input[str],
                 sql: pulumi.Input[str],
                 cluster_identifier: Optional[pulumi.Input[str]] = None,
                 db_user: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['StatementParameterArgs']]]] = None,
                 secret_arn: Optional[pulumi.Input[str]] = None,
                 statement_name: Optional[pulumi.Input[str]] = None,
                 with_event: Optional[pulumi.Input[bool]] = None,
                 workgroup_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Statement resource.
        :param pulumi.Input[str] database: The name of the database.
        :param pulumi.Input[str] sql: The SQL statement text to run.
               
               The following arguments are optional:
        :param pulumi.Input[str] cluster_identifier: The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials.
        :param pulumi.Input[str] db_user: The database user name.
        :param pulumi.Input[str] secret_arn: The name or ARN of the secret that enables access to the database.
        :param pulumi.Input[str] statement_name: The name of the SQL statement. You can name the SQL statement when you create it to identify the query.
        :param pulumi.Input[bool] with_event: A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statement runs.
        :param pulumi.Input[str] workgroup_name: The serverless workgroup name. This parameter is required when connecting to a serverless workgroup and authenticating using either Secrets Manager or temporary credentials.
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "sql", sql)
        if cluster_identifier is not None:
            pulumi.set(__self__, "cluster_identifier", cluster_identifier)
        if db_user is not None:
            pulumi.set(__self__, "db_user", db_user)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)
        if statement_name is not None:
            pulumi.set(__self__, "statement_name", statement_name)
        if with_event is not None:
            pulumi.set(__self__, "with_event", with_event)
        if workgroup_name is not None:
            pulumi.set(__self__, "workgroup_name", workgroup_name)

    @property
    @pulumi.getter
    def database(self) -> pulumi.Input[str]:
        """
        The name of the database.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[str]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter
    def sql(self) -> pulumi.Input[str]:
        """
        The SQL statement text to run.

        The following arguments are optional:
        """
        return pulumi.get(self, "sql")

    @sql.setter
    def sql(self, value: pulumi.Input[str]):
        pulumi.set(self, "sql", value)

    @property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials.
        """
        return pulumi.get(self, "cluster_identifier")

    @cluster_identifier.setter
    def cluster_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_identifier", value)

    @property
    @pulumi.getter(name="dbUser")
    def db_user(self) -> Optional[pulumi.Input[str]]:
        """
        The database user name.
        """
        return pulumi.get(self, "db_user")

    @db_user.setter
    def db_user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_user", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StatementParameterArgs']]]]:
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StatementParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The name or ARN of the secret that enables access to the database.
        """
        return pulumi.get(self, "secret_arn")

    @secret_arn.setter
    def secret_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_arn", value)

    @property
    @pulumi.getter(name="statementName")
    def statement_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the SQL statement. You can name the SQL statement when you create it to identify the query.
        """
        return pulumi.get(self, "statement_name")

    @statement_name.setter
    def statement_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "statement_name", value)

    @property
    @pulumi.getter(name="withEvent")
    def with_event(self) -> Optional[pulumi.Input[bool]]:
        """
        A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statement runs.
        """
        return pulumi.get(self, "with_event")

    @with_event.setter
    def with_event(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "with_event", value)

    @property
    @pulumi.getter(name="workgroupName")
    def workgroup_name(self) -> Optional[pulumi.Input[str]]:
        """
        The serverless workgroup name. This parameter is required when connecting to a serverless workgroup and authenticating using either Secrets Manager or temporary credentials.
        """
        return pulumi.get(self, "workgroup_name")

    @workgroup_name.setter
    def workgroup_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workgroup_name", value)


@pulumi.input_type
class _StatementState:
    def __init__(__self__, *,
                 cluster_identifier: Optional[pulumi.Input[str]] = None,
                 database: Optional[pulumi.Input[str]] = None,
                 db_user: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['StatementParameterArgs']]]] = None,
                 secret_arn: Optional[pulumi.Input[str]] = None,
                 sql: Optional[pulumi.Input[str]] = None,
                 statement_name: Optional[pulumi.Input[str]] = None,
                 with_event: Optional[pulumi.Input[bool]] = None,
                 workgroup_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Statement resources.
        :param pulumi.Input[str] cluster_identifier: The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials.
        :param pulumi.Input[str] database: The name of the database.
        :param pulumi.Input[str] db_user: The database user name.
        :param pulumi.Input[str] secret_arn: The name or ARN of the secret that enables access to the database.
        :param pulumi.Input[str] sql: The SQL statement text to run.
               
               The following arguments are optional:
        :param pulumi.Input[str] statement_name: The name of the SQL statement. You can name the SQL statement when you create it to identify the query.
        :param pulumi.Input[bool] with_event: A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statement runs.
        :param pulumi.Input[str] workgroup_name: The serverless workgroup name. This parameter is required when connecting to a serverless workgroup and authenticating using either Secrets Manager or temporary credentials.
        """
        if cluster_identifier is not None:
            pulumi.set(__self__, "cluster_identifier", cluster_identifier)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if db_user is not None:
            pulumi.set(__self__, "db_user", db_user)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)
        if sql is not None:
            pulumi.set(__self__, "sql", sql)
        if statement_name is not None:
            pulumi.set(__self__, "statement_name", statement_name)
        if with_event is not None:
            pulumi.set(__self__, "with_event", with_event)
        if workgroup_name is not None:
            pulumi.set(__self__, "workgroup_name", workgroup_name)

    @property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials.
        """
        return pulumi.get(self, "cluster_identifier")

    @cluster_identifier.setter
    def cluster_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_identifier", value)

    @property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the database.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter(name="dbUser")
    def db_user(self) -> Optional[pulumi.Input[str]]:
        """
        The database user name.
        """
        return pulumi.get(self, "db_user")

    @db_user.setter
    def db_user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_user", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StatementParameterArgs']]]]:
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StatementParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The name or ARN of the secret that enables access to the database.
        """
        return pulumi.get(self, "secret_arn")

    @secret_arn.setter
    def secret_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_arn", value)

    @property
    @pulumi.getter
    def sql(self) -> Optional[pulumi.Input[str]]:
        """
        The SQL statement text to run.

        The following arguments are optional:
        """
        return pulumi.get(self, "sql")

    @sql.setter
    def sql(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sql", value)

    @property
    @pulumi.getter(name="statementName")
    def statement_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the SQL statement. You can name the SQL statement when you create it to identify the query.
        """
        return pulumi.get(self, "statement_name")

    @statement_name.setter
    def statement_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "statement_name", value)

    @property
    @pulumi.getter(name="withEvent")
    def with_event(self) -> Optional[pulumi.Input[bool]]:
        """
        A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statement runs.
        """
        return pulumi.get(self, "with_event")

    @with_event.setter
    def with_event(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "with_event", value)

    @property
    @pulumi.getter(name="workgroupName")
    def workgroup_name(self) -> Optional[pulumi.Input[str]]:
        """
        The serverless workgroup name. This parameter is required when connecting to a serverless workgroup and authenticating using either Secrets Manager or temporary credentials.
        """
        return pulumi.get(self, "workgroup_name")

    @workgroup_name.setter
    def workgroup_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workgroup_name", value)


class Statement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_identifier: Optional[pulumi.Input[str]] = None,
                 database: Optional[pulumi.Input[str]] = None,
                 db_user: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['StatementParameterArgs']]]]] = None,
                 secret_arn: Optional[pulumi.Input[str]] = None,
                 sql: Optional[pulumi.Input[str]] = None,
                 statement_name: Optional[pulumi.Input[str]] = None,
                 with_event: Optional[pulumi.Input[bool]] = None,
                 workgroup_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Executes a Redshift Data Statement.

        ## Example Usage
        ### cluster_identifier

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.redshiftdata.Statement("example",
            cluster_identifier=aws_redshift_cluster["example"]["cluster_identifier"],
            database=aws_redshift_cluster["example"]["database_name"],
            db_user=aws_redshift_cluster["example"]["master_username"],
            sql="CREATE GROUP group_name;")
        ```
        ### workgroup_name

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.redshiftdata.Statement("example",
            workgroup_name=aws_redshiftserverless_workgroup["example"]["workgroup_name"],
            database="dev",
            sql="CREATE GROUP group_name;")
        ```

        ## Import

        Using `pulumi import`, import Redshift Data Statements using the `id`. For example:

        ```sh
         $ pulumi import aws:redshiftdata/statement:Statement example example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_identifier: The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials.
        :param pulumi.Input[str] database: The name of the database.
        :param pulumi.Input[str] db_user: The database user name.
        :param pulumi.Input[str] secret_arn: The name or ARN of the secret that enables access to the database.
        :param pulumi.Input[str] sql: The SQL statement text to run.
               
               The following arguments are optional:
        :param pulumi.Input[str] statement_name: The name of the SQL statement. You can name the SQL statement when you create it to identify the query.
        :param pulumi.Input[bool] with_event: A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statement runs.
        :param pulumi.Input[str] workgroup_name: The serverless workgroup name. This parameter is required when connecting to a serverless workgroup and authenticating using either Secrets Manager or temporary credentials.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StatementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Executes a Redshift Data Statement.

        ## Example Usage
        ### cluster_identifier

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.redshiftdata.Statement("example",
            cluster_identifier=aws_redshift_cluster["example"]["cluster_identifier"],
            database=aws_redshift_cluster["example"]["database_name"],
            db_user=aws_redshift_cluster["example"]["master_username"],
            sql="CREATE GROUP group_name;")
        ```
        ### workgroup_name

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.redshiftdata.Statement("example",
            workgroup_name=aws_redshiftserverless_workgroup["example"]["workgroup_name"],
            database="dev",
            sql="CREATE GROUP group_name;")
        ```

        ## Import

        Using `pulumi import`, import Redshift Data Statements using the `id`. For example:

        ```sh
         $ pulumi import aws:redshiftdata/statement:Statement example example
        ```

        :param str resource_name: The name of the resource.
        :param StatementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StatementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_identifier: Optional[pulumi.Input[str]] = None,
                 database: Optional[pulumi.Input[str]] = None,
                 db_user: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['StatementParameterArgs']]]]] = None,
                 secret_arn: Optional[pulumi.Input[str]] = None,
                 sql: Optional[pulumi.Input[str]] = None,
                 statement_name: Optional[pulumi.Input[str]] = None,
                 with_event: Optional[pulumi.Input[bool]] = None,
                 workgroup_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StatementArgs.__new__(StatementArgs)

            __props__.__dict__["cluster_identifier"] = cluster_identifier
            if database is None and not opts.urn:
                raise TypeError("Missing required property 'database'")
            __props__.__dict__["database"] = database
            __props__.__dict__["db_user"] = db_user
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["secret_arn"] = secret_arn
            if sql is None and not opts.urn:
                raise TypeError("Missing required property 'sql'")
            __props__.__dict__["sql"] = sql
            __props__.__dict__["statement_name"] = statement_name
            __props__.__dict__["with_event"] = with_event
            __props__.__dict__["workgroup_name"] = workgroup_name
        super(Statement, __self__).__init__(
            'aws:redshiftdata/statement:Statement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_identifier: Optional[pulumi.Input[str]] = None,
            database: Optional[pulumi.Input[str]] = None,
            db_user: Optional[pulumi.Input[str]] = None,
            parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['StatementParameterArgs']]]]] = None,
            secret_arn: Optional[pulumi.Input[str]] = None,
            sql: Optional[pulumi.Input[str]] = None,
            statement_name: Optional[pulumi.Input[str]] = None,
            with_event: Optional[pulumi.Input[bool]] = None,
            workgroup_name: Optional[pulumi.Input[str]] = None) -> 'Statement':
        """
        Get an existing Statement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_identifier: The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials.
        :param pulumi.Input[str] database: The name of the database.
        :param pulumi.Input[str] db_user: The database user name.
        :param pulumi.Input[str] secret_arn: The name or ARN of the secret that enables access to the database.
        :param pulumi.Input[str] sql: The SQL statement text to run.
               
               The following arguments are optional:
        :param pulumi.Input[str] statement_name: The name of the SQL statement. You can name the SQL statement when you create it to identify the query.
        :param pulumi.Input[bool] with_event: A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statement runs.
        :param pulumi.Input[str] workgroup_name: The serverless workgroup name. This parameter is required when connecting to a serverless workgroup and authenticating using either Secrets Manager or temporary credentials.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StatementState.__new__(_StatementState)

        __props__.__dict__["cluster_identifier"] = cluster_identifier
        __props__.__dict__["database"] = database
        __props__.__dict__["db_user"] = db_user
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["secret_arn"] = secret_arn
        __props__.__dict__["sql"] = sql
        __props__.__dict__["statement_name"] = statement_name
        __props__.__dict__["with_event"] = with_event
        __props__.__dict__["workgroup_name"] = workgroup_name
        return Statement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> pulumi.Output[Optional[str]]:
        """
        The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials.
        """
        return pulumi.get(self, "cluster_identifier")

    @property
    @pulumi.getter
    def database(self) -> pulumi.Output[str]:
        """
        The name of the database.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter(name="dbUser")
    def db_user(self) -> pulumi.Output[Optional[str]]:
        """
        The database user name.
        """
        return pulumi.get(self, "db_user")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Sequence['outputs.StatementParameter']]]:
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The name or ARN of the secret that enables access to the database.
        """
        return pulumi.get(self, "secret_arn")

    @property
    @pulumi.getter
    def sql(self) -> pulumi.Output[str]:
        """
        The SQL statement text to run.

        The following arguments are optional:
        """
        return pulumi.get(self, "sql")

    @property
    @pulumi.getter(name="statementName")
    def statement_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the SQL statement. You can name the SQL statement when you create it to identify the query.
        """
        return pulumi.get(self, "statement_name")

    @property
    @pulumi.getter(name="withEvent")
    def with_event(self) -> pulumi.Output[Optional[bool]]:
        """
        A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statement runs.
        """
        return pulumi.get(self, "with_event")

    @property
    @pulumi.getter(name="workgroupName")
    def workgroup_name(self) -> pulumi.Output[Optional[str]]:
        """
        The serverless workgroup name. This parameter is required when connecting to a serverless workgroup and authenticating using either Secrets Manager or temporary credentials.
        """
        return pulumi.get(self, "workgroup_name")

