# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['RecordArgs', 'Record']

@pulumi.input_type
class RecordArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 type: pulumi.Input[Union[str, 'RecordType']],
                 zone_id: pulumi.Input[str],
                 aliases: Optional[pulumi.Input[Sequence[pulumi.Input['RecordAliasArgs']]]] = None,
                 allow_overwrite: Optional[pulumi.Input[bool]] = None,
                 cidr_routing_policy: Optional[pulumi.Input['RecordCidrRoutingPolicyArgs']] = None,
                 failover_routing_policies: Optional[pulumi.Input[Sequence[pulumi.Input['RecordFailoverRoutingPolicyArgs']]]] = None,
                 geolocation_routing_policies: Optional[pulumi.Input[Sequence[pulumi.Input['RecordGeolocationRoutingPolicyArgs']]]] = None,
                 health_check_id: Optional[pulumi.Input[str]] = None,
                 latency_routing_policies: Optional[pulumi.Input[Sequence[pulumi.Input['RecordLatencyRoutingPolicyArgs']]]] = None,
                 multivalue_answer_routing_policy: Optional[pulumi.Input[bool]] = None,
                 records: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 set_identifier: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[int]] = None,
                 weighted_routing_policies: Optional[pulumi.Input[Sequence[pulumi.Input['RecordWeightedRoutingPolicyArgs']]]] = None):
        """
        The set of arguments for constructing a Record resource.
        :param pulumi.Input[str] name: The name of the record.
        :param pulumi.Input[Union[str, 'RecordType']] type: The record type. Valid values are `A`, `AAAA`, `CAA`, `CNAME`, `DS`, `MX`, `NAPTR`, `NS`, `PTR`, `SOA`, `SPF`, `SRV` and `TXT`.
        :param pulumi.Input[str] zone_id: The ID of the hosted zone to contain this record.
        :param pulumi.Input[Sequence[pulumi.Input['RecordAliasArgs']]] aliases: An alias block. Conflicts with `ttl` & `records`.
               Documented below.
        :param pulumi.Input[bool] allow_overwrite: Allow creation of this record to overwrite an existing record, if any. This does not affect the ability to update the record using this provider and does not prevent other resources within this provider or manual Route 53 changes outside this provider from overwriting this record. `false` by default. This configuration is not recommended for most environments.
               
               Exactly one of `records` or `alias` must be specified: this determines whether it's an alias record.
        :param pulumi.Input['RecordCidrRoutingPolicyArgs'] cidr_routing_policy: A block indicating a routing policy based on the IP network ranges of requestors. Conflicts with any other routing policy. Documented below.
        :param pulumi.Input[Sequence[pulumi.Input['RecordFailoverRoutingPolicyArgs']]] failover_routing_policies: A block indicating the routing behavior when associated health check fails. Conflicts with any other routing policy. Documented below.
        :param pulumi.Input[Sequence[pulumi.Input['RecordGeolocationRoutingPolicyArgs']]] geolocation_routing_policies: A block indicating a routing policy based on the geolocation of the requestor. Conflicts with any other routing policy. Documented below.
        :param pulumi.Input[str] health_check_id: The health check the record should be associated with.
        :param pulumi.Input[Sequence[pulumi.Input['RecordLatencyRoutingPolicyArgs']]] latency_routing_policies: A block indicating a routing policy based on the latency between the requestor and an AWS region. Conflicts with any other routing policy. Documented below.
        :param pulumi.Input[bool] multivalue_answer_routing_policy: Set to `true` to indicate a multivalue answer routing policy. Conflicts with any other routing policy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] records: A string list of records. To specify a single record value longer than 255 characters such as a TXT record for DKIM, add `\\"\\"` inside the provider configuration string (e.g., `"first255characters\\"\\"morecharacters"`).
        :param pulumi.Input[str] set_identifier: Unique identifier to differentiate records with routing policies from one another. Required if using `cidr_routing_policy`, `failover_routing_policy`, `geolocation_routing_policy`, `latency_routing_policy`, `multivalue_answer_routing_policy`, or `weighted_routing_policy`.
        :param pulumi.Input[int] ttl: The TTL of the record.
        :param pulumi.Input[Sequence[pulumi.Input['RecordWeightedRoutingPolicyArgs']]] weighted_routing_policies: A block indicating a weighted routing policy. Conflicts with any other routing policy. Documented below.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "zone_id", zone_id)
        if aliases is not None:
            pulumi.set(__self__, "aliases", aliases)
        if allow_overwrite is not None:
            pulumi.set(__self__, "allow_overwrite", allow_overwrite)
        if cidr_routing_policy is not None:
            pulumi.set(__self__, "cidr_routing_policy", cidr_routing_policy)
        if failover_routing_policies is not None:
            pulumi.set(__self__, "failover_routing_policies", failover_routing_policies)
        if geolocation_routing_policies is not None:
            pulumi.set(__self__, "geolocation_routing_policies", geolocation_routing_policies)
        if health_check_id is not None:
            pulumi.set(__self__, "health_check_id", health_check_id)
        if latency_routing_policies is not None:
            pulumi.set(__self__, "latency_routing_policies", latency_routing_policies)
        if multivalue_answer_routing_policy is not None:
            pulumi.set(__self__, "multivalue_answer_routing_policy", multivalue_answer_routing_policy)
        if records is not None:
            pulumi.set(__self__, "records", records)
        if set_identifier is not None:
            pulumi.set(__self__, "set_identifier", set_identifier)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if weighted_routing_policies is not None:
            pulumi.set(__self__, "weighted_routing_policies", weighted_routing_policies)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the record.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[Union[str, 'RecordType']]:
        """
        The record type. Valid values are `A`, `AAAA`, `CAA`, `CNAME`, `DS`, `MX`, `NAPTR`, `NS`, `PTR`, `SOA`, `SPF`, `SRV` and `TXT`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[Union[str, 'RecordType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[str]:
        """
        The ID of the hosted zone to contain this record.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "zone_id", value)

    @property
    @pulumi.getter
    def aliases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RecordAliasArgs']]]]:
        """
        An alias block. Conflicts with `ttl` & `records`.
        Documented below.
        """
        return pulumi.get(self, "aliases")

    @aliases.setter
    def aliases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RecordAliasArgs']]]]):
        pulumi.set(self, "aliases", value)

    @property
    @pulumi.getter(name="allowOverwrite")
    def allow_overwrite(self) -> Optional[pulumi.Input[bool]]:
        """
        Allow creation of this record to overwrite an existing record, if any. This does not affect the ability to update the record using this provider and does not prevent other resources within this provider or manual Route 53 changes outside this provider from overwriting this record. `false` by default. This configuration is not recommended for most environments.

        Exactly one of `records` or `alias` must be specified: this determines whether it's an alias record.
        """
        return pulumi.get(self, "allow_overwrite")

    @allow_overwrite.setter
    def allow_overwrite(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_overwrite", value)

    @property
    @pulumi.getter(name="cidrRoutingPolicy")
    def cidr_routing_policy(self) -> Optional[pulumi.Input['RecordCidrRoutingPolicyArgs']]:
        """
        A block indicating a routing policy based on the IP network ranges of requestors. Conflicts with any other routing policy. Documented below.
        """
        return pulumi.get(self, "cidr_routing_policy")

    @cidr_routing_policy.setter
    def cidr_routing_policy(self, value: Optional[pulumi.Input['RecordCidrRoutingPolicyArgs']]):
        pulumi.set(self, "cidr_routing_policy", value)

    @property
    @pulumi.getter(name="failoverRoutingPolicies")
    def failover_routing_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RecordFailoverRoutingPolicyArgs']]]]:
        """
        A block indicating the routing behavior when associated health check fails. Conflicts with any other routing policy. Documented below.
        """
        return pulumi.get(self, "failover_routing_policies")

    @failover_routing_policies.setter
    def failover_routing_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RecordFailoverRoutingPolicyArgs']]]]):
        pulumi.set(self, "failover_routing_policies", value)

    @property
    @pulumi.getter(name="geolocationRoutingPolicies")
    def geolocation_routing_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RecordGeolocationRoutingPolicyArgs']]]]:
        """
        A block indicating a routing policy based on the geolocation of the requestor. Conflicts with any other routing policy. Documented below.
        """
        return pulumi.get(self, "geolocation_routing_policies")

    @geolocation_routing_policies.setter
    def geolocation_routing_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RecordGeolocationRoutingPolicyArgs']]]]):
        pulumi.set(self, "geolocation_routing_policies", value)

    @property
    @pulumi.getter(name="healthCheckId")
    def health_check_id(self) -> Optional[pulumi.Input[str]]:
        """
        The health check the record should be associated with.
        """
        return pulumi.get(self, "health_check_id")

    @health_check_id.setter
    def health_check_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_id", value)

    @property
    @pulumi.getter(name="latencyRoutingPolicies")
    def latency_routing_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RecordLatencyRoutingPolicyArgs']]]]:
        """
        A block indicating a routing policy based on the latency between the requestor and an AWS region. Conflicts with any other routing policy. Documented below.
        """
        return pulumi.get(self, "latency_routing_policies")

    @latency_routing_policies.setter
    def latency_routing_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RecordLatencyRoutingPolicyArgs']]]]):
        pulumi.set(self, "latency_routing_policies", value)

    @property
    @pulumi.getter(name="multivalueAnswerRoutingPolicy")
    def multivalue_answer_routing_policy(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to indicate a multivalue answer routing policy. Conflicts with any other routing policy.
        """
        return pulumi.get(self, "multivalue_answer_routing_policy")

    @multivalue_answer_routing_policy.setter
    def multivalue_answer_routing_policy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multivalue_answer_routing_policy", value)

    @property
    @pulumi.getter
    def records(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A string list of records. To specify a single record value longer than 255 characters such as a TXT record for DKIM, add `\\"\\"` inside the provider configuration string (e.g., `"first255characters\\"\\"morecharacters"`).
        """
        return pulumi.get(self, "records")

    @records.setter
    def records(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "records", value)

    @property
    @pulumi.getter(name="setIdentifier")
    def set_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier to differentiate records with routing policies from one another. Required if using `cidr_routing_policy`, `failover_routing_policy`, `geolocation_routing_policy`, `latency_routing_policy`, `multivalue_answer_routing_policy`, or `weighted_routing_policy`.
        """
        return pulumi.get(self, "set_identifier")

    @set_identifier.setter
    def set_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "set_identifier", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The TTL of the record.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ttl", value)

    @property
    @pulumi.getter(name="weightedRoutingPolicies")
    def weighted_routing_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RecordWeightedRoutingPolicyArgs']]]]:
        """
        A block indicating a weighted routing policy. Conflicts with any other routing policy. Documented below.
        """
        return pulumi.get(self, "weighted_routing_policies")

    @weighted_routing_policies.setter
    def weighted_routing_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RecordWeightedRoutingPolicyArgs']]]]):
        pulumi.set(self, "weighted_routing_policies", value)


@pulumi.input_type
class _RecordState:
    def __init__(__self__, *,
                 aliases: Optional[pulumi.Input[Sequence[pulumi.Input['RecordAliasArgs']]]] = None,
                 allow_overwrite: Optional[pulumi.Input[bool]] = None,
                 cidr_routing_policy: Optional[pulumi.Input['RecordCidrRoutingPolicyArgs']] = None,
                 failover_routing_policies: Optional[pulumi.Input[Sequence[pulumi.Input['RecordFailoverRoutingPolicyArgs']]]] = None,
                 fqdn: Optional[pulumi.Input[str]] = None,
                 geolocation_routing_policies: Optional[pulumi.Input[Sequence[pulumi.Input['RecordGeolocationRoutingPolicyArgs']]]] = None,
                 health_check_id: Optional[pulumi.Input[str]] = None,
                 latency_routing_policies: Optional[pulumi.Input[Sequence[pulumi.Input['RecordLatencyRoutingPolicyArgs']]]] = None,
                 multivalue_answer_routing_policy: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 records: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 set_identifier: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[Union[str, 'RecordType']]] = None,
                 weighted_routing_policies: Optional[pulumi.Input[Sequence[pulumi.Input['RecordWeightedRoutingPolicyArgs']]]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Record resources.
        :param pulumi.Input[Sequence[pulumi.Input['RecordAliasArgs']]] aliases: An alias block. Conflicts with `ttl` & `records`.
               Documented below.
        :param pulumi.Input[bool] allow_overwrite: Allow creation of this record to overwrite an existing record, if any. This does not affect the ability to update the record using this provider and does not prevent other resources within this provider or manual Route 53 changes outside this provider from overwriting this record. `false` by default. This configuration is not recommended for most environments.
               
               Exactly one of `records` or `alias` must be specified: this determines whether it's an alias record.
        :param pulumi.Input['RecordCidrRoutingPolicyArgs'] cidr_routing_policy: A block indicating a routing policy based on the IP network ranges of requestors. Conflicts with any other routing policy. Documented below.
        :param pulumi.Input[Sequence[pulumi.Input['RecordFailoverRoutingPolicyArgs']]] failover_routing_policies: A block indicating the routing behavior when associated health check fails. Conflicts with any other routing policy. Documented below.
        :param pulumi.Input[str] fqdn: [FQDN](https://en.wikipedia.org/wiki/Fully_qualified_domain_name) built using the zone domain and `name`.
        :param pulumi.Input[Sequence[pulumi.Input['RecordGeolocationRoutingPolicyArgs']]] geolocation_routing_policies: A block indicating a routing policy based on the geolocation of the requestor. Conflicts with any other routing policy. Documented below.
        :param pulumi.Input[str] health_check_id: The health check the record should be associated with.
        :param pulumi.Input[Sequence[pulumi.Input['RecordLatencyRoutingPolicyArgs']]] latency_routing_policies: A block indicating a routing policy based on the latency between the requestor and an AWS region. Conflicts with any other routing policy. Documented below.
        :param pulumi.Input[bool] multivalue_answer_routing_policy: Set to `true` to indicate a multivalue answer routing policy. Conflicts with any other routing policy.
        :param pulumi.Input[str] name: The name of the record.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] records: A string list of records. To specify a single record value longer than 255 characters such as a TXT record for DKIM, add `\\"\\"` inside the provider configuration string (e.g., `"first255characters\\"\\"morecharacters"`).
        :param pulumi.Input[str] set_identifier: Unique identifier to differentiate records with routing policies from one another. Required if using `cidr_routing_policy`, `failover_routing_policy`, `geolocation_routing_policy`, `latency_routing_policy`, `multivalue_answer_routing_policy`, or `weighted_routing_policy`.
        :param pulumi.Input[int] ttl: The TTL of the record.
        :param pulumi.Input[Union[str, 'RecordType']] type: The record type. Valid values are `A`, `AAAA`, `CAA`, `CNAME`, `DS`, `MX`, `NAPTR`, `NS`, `PTR`, `SOA`, `SPF`, `SRV` and `TXT`.
        :param pulumi.Input[Sequence[pulumi.Input['RecordWeightedRoutingPolicyArgs']]] weighted_routing_policies: A block indicating a weighted routing policy. Conflicts with any other routing policy. Documented below.
        :param pulumi.Input[str] zone_id: The ID of the hosted zone to contain this record.
        """
        if aliases is not None:
            pulumi.set(__self__, "aliases", aliases)
        if allow_overwrite is not None:
            pulumi.set(__self__, "allow_overwrite", allow_overwrite)
        if cidr_routing_policy is not None:
            pulumi.set(__self__, "cidr_routing_policy", cidr_routing_policy)
        if failover_routing_policies is not None:
            pulumi.set(__self__, "failover_routing_policies", failover_routing_policies)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if geolocation_routing_policies is not None:
            pulumi.set(__self__, "geolocation_routing_policies", geolocation_routing_policies)
        if health_check_id is not None:
            pulumi.set(__self__, "health_check_id", health_check_id)
        if latency_routing_policies is not None:
            pulumi.set(__self__, "latency_routing_policies", latency_routing_policies)
        if multivalue_answer_routing_policy is not None:
            pulumi.set(__self__, "multivalue_answer_routing_policy", multivalue_answer_routing_policy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if records is not None:
            pulumi.set(__self__, "records", records)
        if set_identifier is not None:
            pulumi.set(__self__, "set_identifier", set_identifier)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if weighted_routing_policies is not None:
            pulumi.set(__self__, "weighted_routing_policies", weighted_routing_policies)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def aliases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RecordAliasArgs']]]]:
        """
        An alias block. Conflicts with `ttl` & `records`.
        Documented below.
        """
        return pulumi.get(self, "aliases")

    @aliases.setter
    def aliases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RecordAliasArgs']]]]):
        pulumi.set(self, "aliases", value)

    @property
    @pulumi.getter(name="allowOverwrite")
    def allow_overwrite(self) -> Optional[pulumi.Input[bool]]:
        """
        Allow creation of this record to overwrite an existing record, if any. This does not affect the ability to update the record using this provider and does not prevent other resources within this provider or manual Route 53 changes outside this provider from overwriting this record. `false` by default. This configuration is not recommended for most environments.

        Exactly one of `records` or `alias` must be specified: this determines whether it's an alias record.
        """
        return pulumi.get(self, "allow_overwrite")

    @allow_overwrite.setter
    def allow_overwrite(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_overwrite", value)

    @property
    @pulumi.getter(name="cidrRoutingPolicy")
    def cidr_routing_policy(self) -> Optional[pulumi.Input['RecordCidrRoutingPolicyArgs']]:
        """
        A block indicating a routing policy based on the IP network ranges of requestors. Conflicts with any other routing policy. Documented below.
        """
        return pulumi.get(self, "cidr_routing_policy")

    @cidr_routing_policy.setter
    def cidr_routing_policy(self, value: Optional[pulumi.Input['RecordCidrRoutingPolicyArgs']]):
        pulumi.set(self, "cidr_routing_policy", value)

    @property
    @pulumi.getter(name="failoverRoutingPolicies")
    def failover_routing_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RecordFailoverRoutingPolicyArgs']]]]:
        """
        A block indicating the routing behavior when associated health check fails. Conflicts with any other routing policy. Documented below.
        """
        return pulumi.get(self, "failover_routing_policies")

    @failover_routing_policies.setter
    def failover_routing_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RecordFailoverRoutingPolicyArgs']]]]):
        pulumi.set(self, "failover_routing_policies", value)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        [FQDN](https://en.wikipedia.org/wiki/Fully_qualified_domain_name) built using the zone domain and `name`.
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fqdn", value)

    @property
    @pulumi.getter(name="geolocationRoutingPolicies")
    def geolocation_routing_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RecordGeolocationRoutingPolicyArgs']]]]:
        """
        A block indicating a routing policy based on the geolocation of the requestor. Conflicts with any other routing policy. Documented below.
        """
        return pulumi.get(self, "geolocation_routing_policies")

    @geolocation_routing_policies.setter
    def geolocation_routing_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RecordGeolocationRoutingPolicyArgs']]]]):
        pulumi.set(self, "geolocation_routing_policies", value)

    @property
    @pulumi.getter(name="healthCheckId")
    def health_check_id(self) -> Optional[pulumi.Input[str]]:
        """
        The health check the record should be associated with.
        """
        return pulumi.get(self, "health_check_id")

    @health_check_id.setter
    def health_check_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_id", value)

    @property
    @pulumi.getter(name="latencyRoutingPolicies")
    def latency_routing_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RecordLatencyRoutingPolicyArgs']]]]:
        """
        A block indicating a routing policy based on the latency between the requestor and an AWS region. Conflicts with any other routing policy. Documented below.
        """
        return pulumi.get(self, "latency_routing_policies")

    @latency_routing_policies.setter
    def latency_routing_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RecordLatencyRoutingPolicyArgs']]]]):
        pulumi.set(self, "latency_routing_policies", value)

    @property
    @pulumi.getter(name="multivalueAnswerRoutingPolicy")
    def multivalue_answer_routing_policy(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to indicate a multivalue answer routing policy. Conflicts with any other routing policy.
        """
        return pulumi.get(self, "multivalue_answer_routing_policy")

    @multivalue_answer_routing_policy.setter
    def multivalue_answer_routing_policy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multivalue_answer_routing_policy", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the record.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def records(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A string list of records. To specify a single record value longer than 255 characters such as a TXT record for DKIM, add `\\"\\"` inside the provider configuration string (e.g., `"first255characters\\"\\"morecharacters"`).
        """
        return pulumi.get(self, "records")

    @records.setter
    def records(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "records", value)

    @property
    @pulumi.getter(name="setIdentifier")
    def set_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier to differentiate records with routing policies from one another. Required if using `cidr_routing_policy`, `failover_routing_policy`, `geolocation_routing_policy`, `latency_routing_policy`, `multivalue_answer_routing_policy`, or `weighted_routing_policy`.
        """
        return pulumi.get(self, "set_identifier")

    @set_identifier.setter
    def set_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "set_identifier", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The TTL of the record.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ttl", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'RecordType']]]:
        """
        The record type. Valid values are `A`, `AAAA`, `CAA`, `CNAME`, `DS`, `MX`, `NAPTR`, `NS`, `PTR`, `SOA`, `SPF`, `SRV` and `TXT`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'RecordType']]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="weightedRoutingPolicies")
    def weighted_routing_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RecordWeightedRoutingPolicyArgs']]]]:
        """
        A block indicating a weighted routing policy. Conflicts with any other routing policy. Documented below.
        """
        return pulumi.get(self, "weighted_routing_policies")

    @weighted_routing_policies.setter
    def weighted_routing_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RecordWeightedRoutingPolicyArgs']]]]):
        pulumi.set(self, "weighted_routing_policies", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the hosted zone to contain this record.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


class Record(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aliases: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RecordAliasArgs']]]]] = None,
                 allow_overwrite: Optional[pulumi.Input[bool]] = None,
                 cidr_routing_policy: Optional[pulumi.Input[pulumi.InputType['RecordCidrRoutingPolicyArgs']]] = None,
                 failover_routing_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RecordFailoverRoutingPolicyArgs']]]]] = None,
                 geolocation_routing_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RecordGeolocationRoutingPolicyArgs']]]]] = None,
                 health_check_id: Optional[pulumi.Input[str]] = None,
                 latency_routing_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RecordLatencyRoutingPolicyArgs']]]]] = None,
                 multivalue_answer_routing_policy: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 records: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 set_identifier: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[Union[str, 'RecordType']]] = None,
                 weighted_routing_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RecordWeightedRoutingPolicyArgs']]]]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Route53 record resource.

        ## Example Usage
        ### Simple routing policy

        ```python
        import pulumi
        import pulumi_aws as aws

        www = aws.route53.Record("www",
            zone_id=aws_route53_zone["primary"]["zone_id"],
            name="www.example.com",
            type="A",
            ttl=300,
            records=[aws_eip["lb"]["public_ip"]])
        ```
        ### Weighted routing policy

        Other routing policies are configured similarly. See [Amazon Route 53 Developer Guide](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html) for details.

        ```python
        import pulumi
        import pulumi_aws as aws

        www_dev = aws.route53.Record("www-dev",
            zone_id=aws_route53_zone["primary"]["zone_id"],
            name="www",
            type="CNAME",
            ttl=5,
            weighted_routing_policies=[aws.route53.RecordWeightedRoutingPolicyArgs(
                weight=10,
            )],
            set_identifier="dev",
            records=["dev.example.com"])
        www_live = aws.route53.Record("www-live",
            zone_id=aws_route53_zone["primary"]["zone_id"],
            name="www",
            type="CNAME",
            ttl=5,
            weighted_routing_policies=[aws.route53.RecordWeightedRoutingPolicyArgs(
                weight=90,
            )],
            set_identifier="live",
            records=["live.example.com"])
        ```
        ### Alias record

        See [related part of Amazon Route 53 Developer Guide](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/resource-record-sets-choosing-alias-non-alias.html)
        to understand differences between alias and non-alias records.

        TTL for all alias records is [60 seconds](https://aws.amazon.com/route53/faqs/#dns_failover_do_i_need_to_adjust),
        you cannot change this, therefore `ttl` has to be omitted in alias records.

        ```python
        import pulumi
        import pulumi_aws as aws

        main = aws.elb.LoadBalancer("main",
            availability_zones=["us-east-1c"],
            listeners=[aws.elb.LoadBalancerListenerArgs(
                instance_port=80,
                instance_protocol="http",
                lb_port=80,
                lb_protocol="http",
            )])
        www = aws.route53.Record("www",
            zone_id=aws_route53_zone["primary"]["zone_id"],
            name="example.com",
            type="A",
            aliases=[aws.route53.RecordAliasArgs(
                name=main.dns_name,
                zone_id=main.zone_id,
                evaluate_target_health=True,
            )])
        ```
        ### NS and SOA Record Management

        When creating Route 53 zones, the `NS` and `SOA` records for the zone are automatically created. Enabling the `allow_overwrite` argument will allow managing these records in a single deployment without the requirement for `import`.

        ```python
        import pulumi
        import pulumi_aws as aws

        example_zone = aws.route53.Zone("exampleZone")
        example_record = aws.route53.Record("exampleRecord",
            allow_overwrite=True,
            name="test.example.com",
            ttl=172800,
            type="NS",
            zone_id=example_zone.zone_id,
            records=[
                example_zone.name_servers[0],
                example_zone.name_servers[1],
                example_zone.name_servers[2],
                example_zone.name_servers[3],
            ])
        ```

        ## Import

        Using the ID of the record, which is the zone identifier, record name, and record type, separated by underscores (`_`):

        If the record also contains a set identifier, append it:

        __Using `pulumi import` to import__ Route53 Records using the ID of the record, record name, record type, and set identifier. For example:

        Using the ID of the record, which is the zone identifier, record name, and record type, separated by underscores (`_`):

        ```sh
         $ pulumi import aws:route53/record:Record myrecord Z4KAPRWWNC7JR_dev.example.com_NS
        ```
         If the record also contains a set identifier, append it:

        ```sh
         $ pulumi import aws:route53/record:Record myrecord Z4KAPRWWNC7JR_dev.example.com_NS_dev
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RecordAliasArgs']]]] aliases: An alias block. Conflicts with `ttl` & `records`.
               Documented below.
        :param pulumi.Input[bool] allow_overwrite: Allow creation of this record to overwrite an existing record, if any. This does not affect the ability to update the record using this provider and does not prevent other resources within this provider or manual Route 53 changes outside this provider from overwriting this record. `false` by default. This configuration is not recommended for most environments.
               
               Exactly one of `records` or `alias` must be specified: this determines whether it's an alias record.
        :param pulumi.Input[pulumi.InputType['RecordCidrRoutingPolicyArgs']] cidr_routing_policy: A block indicating a routing policy based on the IP network ranges of requestors. Conflicts with any other routing policy. Documented below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RecordFailoverRoutingPolicyArgs']]]] failover_routing_policies: A block indicating the routing behavior when associated health check fails. Conflicts with any other routing policy. Documented below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RecordGeolocationRoutingPolicyArgs']]]] geolocation_routing_policies: A block indicating a routing policy based on the geolocation of the requestor. Conflicts with any other routing policy. Documented below.
        :param pulumi.Input[str] health_check_id: The health check the record should be associated with.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RecordLatencyRoutingPolicyArgs']]]] latency_routing_policies: A block indicating a routing policy based on the latency between the requestor and an AWS region. Conflicts with any other routing policy. Documented below.
        :param pulumi.Input[bool] multivalue_answer_routing_policy: Set to `true` to indicate a multivalue answer routing policy. Conflicts with any other routing policy.
        :param pulumi.Input[str] name: The name of the record.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] records: A string list of records. To specify a single record value longer than 255 characters such as a TXT record for DKIM, add `\\"\\"` inside the provider configuration string (e.g., `"first255characters\\"\\"morecharacters"`).
        :param pulumi.Input[str] set_identifier: Unique identifier to differentiate records with routing policies from one another. Required if using `cidr_routing_policy`, `failover_routing_policy`, `geolocation_routing_policy`, `latency_routing_policy`, `multivalue_answer_routing_policy`, or `weighted_routing_policy`.
        :param pulumi.Input[int] ttl: The TTL of the record.
        :param pulumi.Input[Union[str, 'RecordType']] type: The record type. Valid values are `A`, `AAAA`, `CAA`, `CNAME`, `DS`, `MX`, `NAPTR`, `NS`, `PTR`, `SOA`, `SPF`, `SRV` and `TXT`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RecordWeightedRoutingPolicyArgs']]]] weighted_routing_policies: A block indicating a weighted routing policy. Conflicts with any other routing policy. Documented below.
        :param pulumi.Input[str] zone_id: The ID of the hosted zone to contain this record.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RecordArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Route53 record resource.

        ## Example Usage
        ### Simple routing policy

        ```python
        import pulumi
        import pulumi_aws as aws

        www = aws.route53.Record("www",
            zone_id=aws_route53_zone["primary"]["zone_id"],
            name="www.example.com",
            type="A",
            ttl=300,
            records=[aws_eip["lb"]["public_ip"]])
        ```
        ### Weighted routing policy

        Other routing policies are configured similarly. See [Amazon Route 53 Developer Guide](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html) for details.

        ```python
        import pulumi
        import pulumi_aws as aws

        www_dev = aws.route53.Record("www-dev",
            zone_id=aws_route53_zone["primary"]["zone_id"],
            name="www",
            type="CNAME",
            ttl=5,
            weighted_routing_policies=[aws.route53.RecordWeightedRoutingPolicyArgs(
                weight=10,
            )],
            set_identifier="dev",
            records=["dev.example.com"])
        www_live = aws.route53.Record("www-live",
            zone_id=aws_route53_zone["primary"]["zone_id"],
            name="www",
            type="CNAME",
            ttl=5,
            weighted_routing_policies=[aws.route53.RecordWeightedRoutingPolicyArgs(
                weight=90,
            )],
            set_identifier="live",
            records=["live.example.com"])
        ```
        ### Alias record

        See [related part of Amazon Route 53 Developer Guide](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/resource-record-sets-choosing-alias-non-alias.html)
        to understand differences between alias and non-alias records.

        TTL for all alias records is [60 seconds](https://aws.amazon.com/route53/faqs/#dns_failover_do_i_need_to_adjust),
        you cannot change this, therefore `ttl` has to be omitted in alias records.

        ```python
        import pulumi
        import pulumi_aws as aws

        main = aws.elb.LoadBalancer("main",
            availability_zones=["us-east-1c"],
            listeners=[aws.elb.LoadBalancerListenerArgs(
                instance_port=80,
                instance_protocol="http",
                lb_port=80,
                lb_protocol="http",
            )])
        www = aws.route53.Record("www",
            zone_id=aws_route53_zone["primary"]["zone_id"],
            name="example.com",
            type="A",
            aliases=[aws.route53.RecordAliasArgs(
                name=main.dns_name,
                zone_id=main.zone_id,
                evaluate_target_health=True,
            )])
        ```
        ### NS and SOA Record Management

        When creating Route 53 zones, the `NS` and `SOA` records for the zone are automatically created. Enabling the `allow_overwrite` argument will allow managing these records in a single deployment without the requirement for `import`.

        ```python
        import pulumi
        import pulumi_aws as aws

        example_zone = aws.route53.Zone("exampleZone")
        example_record = aws.route53.Record("exampleRecord",
            allow_overwrite=True,
            name="test.example.com",
            ttl=172800,
            type="NS",
            zone_id=example_zone.zone_id,
            records=[
                example_zone.name_servers[0],
                example_zone.name_servers[1],
                example_zone.name_servers[2],
                example_zone.name_servers[3],
            ])
        ```

        ## Import

        Using the ID of the record, which is the zone identifier, record name, and record type, separated by underscores (`_`):

        If the record also contains a set identifier, append it:

        __Using `pulumi import` to import__ Route53 Records using the ID of the record, record name, record type, and set identifier. For example:

        Using the ID of the record, which is the zone identifier, record name, and record type, separated by underscores (`_`):

        ```sh
         $ pulumi import aws:route53/record:Record myrecord Z4KAPRWWNC7JR_dev.example.com_NS
        ```
         If the record also contains a set identifier, append it:

        ```sh
         $ pulumi import aws:route53/record:Record myrecord Z4KAPRWWNC7JR_dev.example.com_NS_dev
        ```

        :param str resource_name: The name of the resource.
        :param RecordArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RecordArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aliases: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RecordAliasArgs']]]]] = None,
                 allow_overwrite: Optional[pulumi.Input[bool]] = None,
                 cidr_routing_policy: Optional[pulumi.Input[pulumi.InputType['RecordCidrRoutingPolicyArgs']]] = None,
                 failover_routing_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RecordFailoverRoutingPolicyArgs']]]]] = None,
                 geolocation_routing_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RecordGeolocationRoutingPolicyArgs']]]]] = None,
                 health_check_id: Optional[pulumi.Input[str]] = None,
                 latency_routing_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RecordLatencyRoutingPolicyArgs']]]]] = None,
                 multivalue_answer_routing_policy: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 records: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 set_identifier: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[Union[str, 'RecordType']]] = None,
                 weighted_routing_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RecordWeightedRoutingPolicyArgs']]]]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RecordArgs.__new__(RecordArgs)

            __props__.__dict__["aliases"] = aliases
            __props__.__dict__["allow_overwrite"] = allow_overwrite
            __props__.__dict__["cidr_routing_policy"] = cidr_routing_policy
            __props__.__dict__["failover_routing_policies"] = failover_routing_policies
            __props__.__dict__["geolocation_routing_policies"] = geolocation_routing_policies
            __props__.__dict__["health_check_id"] = health_check_id
            __props__.__dict__["latency_routing_policies"] = latency_routing_policies
            __props__.__dict__["multivalue_answer_routing_policy"] = multivalue_answer_routing_policy
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["records"] = records
            __props__.__dict__["set_identifier"] = set_identifier
            __props__.__dict__["ttl"] = ttl
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["weighted_routing_policies"] = weighted_routing_policies
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["fqdn"] = None
        super(Record, __self__).__init__(
            'aws:route53/record:Record',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aliases: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RecordAliasArgs']]]]] = None,
            allow_overwrite: Optional[pulumi.Input[bool]] = None,
            cidr_routing_policy: Optional[pulumi.Input[pulumi.InputType['RecordCidrRoutingPolicyArgs']]] = None,
            failover_routing_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RecordFailoverRoutingPolicyArgs']]]]] = None,
            fqdn: Optional[pulumi.Input[str]] = None,
            geolocation_routing_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RecordGeolocationRoutingPolicyArgs']]]]] = None,
            health_check_id: Optional[pulumi.Input[str]] = None,
            latency_routing_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RecordLatencyRoutingPolicyArgs']]]]] = None,
            multivalue_answer_routing_policy: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            records: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            set_identifier: Optional[pulumi.Input[str]] = None,
            ttl: Optional[pulumi.Input[int]] = None,
            type: Optional[pulumi.Input[Union[str, 'RecordType']]] = None,
            weighted_routing_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RecordWeightedRoutingPolicyArgs']]]]] = None,
            zone_id: Optional[pulumi.Input[str]] = None) -> 'Record':
        """
        Get an existing Record resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RecordAliasArgs']]]] aliases: An alias block. Conflicts with `ttl` & `records`.
               Documented below.
        :param pulumi.Input[bool] allow_overwrite: Allow creation of this record to overwrite an existing record, if any. This does not affect the ability to update the record using this provider and does not prevent other resources within this provider or manual Route 53 changes outside this provider from overwriting this record. `false` by default. This configuration is not recommended for most environments.
               
               Exactly one of `records` or `alias` must be specified: this determines whether it's an alias record.
        :param pulumi.Input[pulumi.InputType['RecordCidrRoutingPolicyArgs']] cidr_routing_policy: A block indicating a routing policy based on the IP network ranges of requestors. Conflicts with any other routing policy. Documented below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RecordFailoverRoutingPolicyArgs']]]] failover_routing_policies: A block indicating the routing behavior when associated health check fails. Conflicts with any other routing policy. Documented below.
        :param pulumi.Input[str] fqdn: [FQDN](https://en.wikipedia.org/wiki/Fully_qualified_domain_name) built using the zone domain and `name`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RecordGeolocationRoutingPolicyArgs']]]] geolocation_routing_policies: A block indicating a routing policy based on the geolocation of the requestor. Conflicts with any other routing policy. Documented below.
        :param pulumi.Input[str] health_check_id: The health check the record should be associated with.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RecordLatencyRoutingPolicyArgs']]]] latency_routing_policies: A block indicating a routing policy based on the latency between the requestor and an AWS region. Conflicts with any other routing policy. Documented below.
        :param pulumi.Input[bool] multivalue_answer_routing_policy: Set to `true` to indicate a multivalue answer routing policy. Conflicts with any other routing policy.
        :param pulumi.Input[str] name: The name of the record.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] records: A string list of records. To specify a single record value longer than 255 characters such as a TXT record for DKIM, add `\\"\\"` inside the provider configuration string (e.g., `"first255characters\\"\\"morecharacters"`).
        :param pulumi.Input[str] set_identifier: Unique identifier to differentiate records with routing policies from one another. Required if using `cidr_routing_policy`, `failover_routing_policy`, `geolocation_routing_policy`, `latency_routing_policy`, `multivalue_answer_routing_policy`, or `weighted_routing_policy`.
        :param pulumi.Input[int] ttl: The TTL of the record.
        :param pulumi.Input[Union[str, 'RecordType']] type: The record type. Valid values are `A`, `AAAA`, `CAA`, `CNAME`, `DS`, `MX`, `NAPTR`, `NS`, `PTR`, `SOA`, `SPF`, `SRV` and `TXT`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RecordWeightedRoutingPolicyArgs']]]] weighted_routing_policies: A block indicating a weighted routing policy. Conflicts with any other routing policy. Documented below.
        :param pulumi.Input[str] zone_id: The ID of the hosted zone to contain this record.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RecordState.__new__(_RecordState)

        __props__.__dict__["aliases"] = aliases
        __props__.__dict__["allow_overwrite"] = allow_overwrite
        __props__.__dict__["cidr_routing_policy"] = cidr_routing_policy
        __props__.__dict__["failover_routing_policies"] = failover_routing_policies
        __props__.__dict__["fqdn"] = fqdn
        __props__.__dict__["geolocation_routing_policies"] = geolocation_routing_policies
        __props__.__dict__["health_check_id"] = health_check_id
        __props__.__dict__["latency_routing_policies"] = latency_routing_policies
        __props__.__dict__["multivalue_answer_routing_policy"] = multivalue_answer_routing_policy
        __props__.__dict__["name"] = name
        __props__.__dict__["records"] = records
        __props__.__dict__["set_identifier"] = set_identifier
        __props__.__dict__["ttl"] = ttl
        __props__.__dict__["type"] = type
        __props__.__dict__["weighted_routing_policies"] = weighted_routing_policies
        __props__.__dict__["zone_id"] = zone_id
        return Record(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def aliases(self) -> pulumi.Output[Optional[Sequence['outputs.RecordAlias']]]:
        """
        An alias block. Conflicts with `ttl` & `records`.
        Documented below.
        """
        return pulumi.get(self, "aliases")

    @property
    @pulumi.getter(name="allowOverwrite")
    def allow_overwrite(self) -> pulumi.Output[bool]:
        """
        Allow creation of this record to overwrite an existing record, if any. This does not affect the ability to update the record using this provider and does not prevent other resources within this provider or manual Route 53 changes outside this provider from overwriting this record. `false` by default. This configuration is not recommended for most environments.

        Exactly one of `records` or `alias` must be specified: this determines whether it's an alias record.
        """
        return pulumi.get(self, "allow_overwrite")

    @property
    @pulumi.getter(name="cidrRoutingPolicy")
    def cidr_routing_policy(self) -> pulumi.Output[Optional['outputs.RecordCidrRoutingPolicy']]:
        """
        A block indicating a routing policy based on the IP network ranges of requestors. Conflicts with any other routing policy. Documented below.
        """
        return pulumi.get(self, "cidr_routing_policy")

    @property
    @pulumi.getter(name="failoverRoutingPolicies")
    def failover_routing_policies(self) -> pulumi.Output[Optional[Sequence['outputs.RecordFailoverRoutingPolicy']]]:
        """
        A block indicating the routing behavior when associated health check fails. Conflicts with any other routing policy. Documented below.
        """
        return pulumi.get(self, "failover_routing_policies")

    @property
    @pulumi.getter
    def fqdn(self) -> pulumi.Output[str]:
        """
        [FQDN](https://en.wikipedia.org/wiki/Fully_qualified_domain_name) built using the zone domain and `name`.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="geolocationRoutingPolicies")
    def geolocation_routing_policies(self) -> pulumi.Output[Optional[Sequence['outputs.RecordGeolocationRoutingPolicy']]]:
        """
        A block indicating a routing policy based on the geolocation of the requestor. Conflicts with any other routing policy. Documented below.
        """
        return pulumi.get(self, "geolocation_routing_policies")

    @property
    @pulumi.getter(name="healthCheckId")
    def health_check_id(self) -> pulumi.Output[Optional[str]]:
        """
        The health check the record should be associated with.
        """
        return pulumi.get(self, "health_check_id")

    @property
    @pulumi.getter(name="latencyRoutingPolicies")
    def latency_routing_policies(self) -> pulumi.Output[Optional[Sequence['outputs.RecordLatencyRoutingPolicy']]]:
        """
        A block indicating a routing policy based on the latency between the requestor and an AWS region. Conflicts with any other routing policy. Documented below.
        """
        return pulumi.get(self, "latency_routing_policies")

    @property
    @pulumi.getter(name="multivalueAnswerRoutingPolicy")
    def multivalue_answer_routing_policy(self) -> pulumi.Output[Optional[bool]]:
        """
        Set to `true` to indicate a multivalue answer routing policy. Conflicts with any other routing policy.
        """
        return pulumi.get(self, "multivalue_answer_routing_policy")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the record.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def records(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A string list of records. To specify a single record value longer than 255 characters such as a TXT record for DKIM, add `\\"\\"` inside the provider configuration string (e.g., `"first255characters\\"\\"morecharacters"`).
        """
        return pulumi.get(self, "records")

    @property
    @pulumi.getter(name="setIdentifier")
    def set_identifier(self) -> pulumi.Output[Optional[str]]:
        """
        Unique identifier to differentiate records with routing policies from one another. Required if using `cidr_routing_policy`, `failover_routing_policy`, `geolocation_routing_policy`, `latency_routing_policy`, `multivalue_answer_routing_policy`, or `weighted_routing_policy`.
        """
        return pulumi.get(self, "set_identifier")

    @property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[Optional[int]]:
        """
        The TTL of the record.
        """
        return pulumi.get(self, "ttl")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The record type. Valid values are `A`, `AAAA`, `CAA`, `CNAME`, `DS`, `MX`, `NAPTR`, `NS`, `PTR`, `SOA`, `SPF`, `SRV` and `TXT`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="weightedRoutingPolicies")
    def weighted_routing_policies(self) -> pulumi.Output[Optional[Sequence['outputs.RecordWeightedRoutingPolicy']]]:
        """
        A block indicating a weighted routing policy. Conflicts with any other routing policy. Documented below.
        """
        return pulumi.get(self, "weighted_routing_policies")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[str]:
        """
        The ID of the hosted zone to contain this record.
        """
        return pulumi.get(self, "zone_id")

