# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ResolverFirewallConfigArgs', 'ResolverFirewallConfig']

@pulumi.input_type
class ResolverFirewallConfigArgs:
    def __init__(__self__, *,
                 resource_id: pulumi.Input[str],
                 firewall_fail_open: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ResolverFirewallConfig resource.
        :param pulumi.Input[str] resource_id: The ID of the VPC that the configuration is for.
        :param pulumi.Input[str] firewall_fail_open: Determines how Route 53 Resolver handles queries during failures, for example when all traffic that is sent to DNS Firewall fails to receive a reply. By default, fail open is disabled, which means the failure mode is closed. This approach favors security over availability. DNS Firewall blocks queries that it is unable to evaluate properly. If you enable this option, the failure mode is open. This approach favors availability over security. DNS Firewall allows queries to proceed if it is unable to properly evaluate them. Valid values: `ENABLED`, `DISABLED`.
        """
        pulumi.set(__self__, "resource_id", resource_id)
        if firewall_fail_open is not None:
            pulumi.set(__self__, "firewall_fail_open", firewall_fail_open)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[str]:
        """
        The ID of the VPC that the configuration is for.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="firewallFailOpen")
    def firewall_fail_open(self) -> Optional[pulumi.Input[str]]:
        """
        Determines how Route 53 Resolver handles queries during failures, for example when all traffic that is sent to DNS Firewall fails to receive a reply. By default, fail open is disabled, which means the failure mode is closed. This approach favors security over availability. DNS Firewall blocks queries that it is unable to evaluate properly. If you enable this option, the failure mode is open. This approach favors availability over security. DNS Firewall allows queries to proceed if it is unable to properly evaluate them. Valid values: `ENABLED`, `DISABLED`.
        """
        return pulumi.get(self, "firewall_fail_open")

    @firewall_fail_open.setter
    def firewall_fail_open(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "firewall_fail_open", value)


@pulumi.input_type
class _ResolverFirewallConfigState:
    def __init__(__self__, *,
                 firewall_fail_open: Optional[pulumi.Input[str]] = None,
                 owner_id: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ResolverFirewallConfig resources.
        :param pulumi.Input[str] firewall_fail_open: Determines how Route 53 Resolver handles queries during failures, for example when all traffic that is sent to DNS Firewall fails to receive a reply. By default, fail open is disabled, which means the failure mode is closed. This approach favors security over availability. DNS Firewall blocks queries that it is unable to evaluate properly. If you enable this option, the failure mode is open. This approach favors availability over security. DNS Firewall allows queries to proceed if it is unable to properly evaluate them. Valid values: `ENABLED`, `DISABLED`.
        :param pulumi.Input[str] owner_id: The AWS account ID of the owner of the VPC that this firewall configuration applies to.
        :param pulumi.Input[str] resource_id: The ID of the VPC that the configuration is for.
        """
        if firewall_fail_open is not None:
            pulumi.set(__self__, "firewall_fail_open", firewall_fail_open)
        if owner_id is not None:
            pulumi.set(__self__, "owner_id", owner_id)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="firewallFailOpen")
    def firewall_fail_open(self) -> Optional[pulumi.Input[str]]:
        """
        Determines how Route 53 Resolver handles queries during failures, for example when all traffic that is sent to DNS Firewall fails to receive a reply. By default, fail open is disabled, which means the failure mode is closed. This approach favors security over availability. DNS Firewall blocks queries that it is unable to evaluate properly. If you enable this option, the failure mode is open. This approach favors availability over security. DNS Firewall allows queries to proceed if it is unable to properly evaluate them. Valid values: `ENABLED`, `DISABLED`.
        """
        return pulumi.get(self, "firewall_fail_open")

    @firewall_fail_open.setter
    def firewall_fail_open(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "firewall_fail_open", value)

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS account ID of the owner of the VPC that this firewall configuration applies to.
        """
        return pulumi.get(self, "owner_id")

    @owner_id.setter
    def owner_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner_id", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the VPC that the configuration is for.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


class ResolverFirewallConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 firewall_fail_open: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Route 53 Resolver DNS Firewall config resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example_vpc = aws.ec2.Vpc("exampleVpc",
            cidr_block="10.0.0.0/16",
            enable_dns_support=True,
            enable_dns_hostnames=True)
        example_resolver_firewall_config = aws.route53.ResolverFirewallConfig("exampleResolverFirewallConfig",
            resource_id=example_vpc.id,
            firewall_fail_open="ENABLED")
        ```

        ## Import

        Using `pulumi import`, import Route 53 Resolver DNS Firewall configs using the Route 53 Resolver DNS Firewall config ID. For example:

        ```sh
         $ pulumi import aws:route53/resolverFirewallConfig:ResolverFirewallConfig example rdsc-be1866ecc1683e95
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] firewall_fail_open: Determines how Route 53 Resolver handles queries during failures, for example when all traffic that is sent to DNS Firewall fails to receive a reply. By default, fail open is disabled, which means the failure mode is closed. This approach favors security over availability. DNS Firewall blocks queries that it is unable to evaluate properly. If you enable this option, the failure mode is open. This approach favors availability over security. DNS Firewall allows queries to proceed if it is unable to properly evaluate them. Valid values: `ENABLED`, `DISABLED`.
        :param pulumi.Input[str] resource_id: The ID of the VPC that the configuration is for.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ResolverFirewallConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Route 53 Resolver DNS Firewall config resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example_vpc = aws.ec2.Vpc("exampleVpc",
            cidr_block="10.0.0.0/16",
            enable_dns_support=True,
            enable_dns_hostnames=True)
        example_resolver_firewall_config = aws.route53.ResolverFirewallConfig("exampleResolverFirewallConfig",
            resource_id=example_vpc.id,
            firewall_fail_open="ENABLED")
        ```

        ## Import

        Using `pulumi import`, import Route 53 Resolver DNS Firewall configs using the Route 53 Resolver DNS Firewall config ID. For example:

        ```sh
         $ pulumi import aws:route53/resolverFirewallConfig:ResolverFirewallConfig example rdsc-be1866ecc1683e95
        ```

        :param str resource_name: The name of the resource.
        :param ResolverFirewallConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ResolverFirewallConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 firewall_fail_open: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ResolverFirewallConfigArgs.__new__(ResolverFirewallConfigArgs)

            __props__.__dict__["firewall_fail_open"] = firewall_fail_open
            if resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'resource_id'")
            __props__.__dict__["resource_id"] = resource_id
            __props__.__dict__["owner_id"] = None
        super(ResolverFirewallConfig, __self__).__init__(
            'aws:route53/resolverFirewallConfig:ResolverFirewallConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            firewall_fail_open: Optional[pulumi.Input[str]] = None,
            owner_id: Optional[pulumi.Input[str]] = None,
            resource_id: Optional[pulumi.Input[str]] = None) -> 'ResolverFirewallConfig':
        """
        Get an existing ResolverFirewallConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] firewall_fail_open: Determines how Route 53 Resolver handles queries during failures, for example when all traffic that is sent to DNS Firewall fails to receive a reply. By default, fail open is disabled, which means the failure mode is closed. This approach favors security over availability. DNS Firewall blocks queries that it is unable to evaluate properly. If you enable this option, the failure mode is open. This approach favors availability over security. DNS Firewall allows queries to proceed if it is unable to properly evaluate them. Valid values: `ENABLED`, `DISABLED`.
        :param pulumi.Input[str] owner_id: The AWS account ID of the owner of the VPC that this firewall configuration applies to.
        :param pulumi.Input[str] resource_id: The ID of the VPC that the configuration is for.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ResolverFirewallConfigState.__new__(_ResolverFirewallConfigState)

        __props__.__dict__["firewall_fail_open"] = firewall_fail_open
        __props__.__dict__["owner_id"] = owner_id
        __props__.__dict__["resource_id"] = resource_id
        return ResolverFirewallConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="firewallFailOpen")
    def firewall_fail_open(self) -> pulumi.Output[str]:
        """
        Determines how Route 53 Resolver handles queries during failures, for example when all traffic that is sent to DNS Firewall fails to receive a reply. By default, fail open is disabled, which means the failure mode is closed. This approach favors security over availability. DNS Firewall blocks queries that it is unable to evaluate properly. If you enable this option, the failure mode is open. This approach favors availability over security. DNS Firewall allows queries to proceed if it is unable to properly evaluate them. Valid values: `ENABLED`, `DISABLED`.
        """
        return pulumi.get(self, "firewall_fail_open")

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> pulumi.Output[str]:
        """
        The AWS account ID of the owner of the VPC that this firewall configuration applies to.
        """
        return pulumi.get(self, "owner_id")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Output[str]:
        """
        The ID of the VPC that the configuration is for.
        """
        return pulumi.get(self, "resource_id")

