# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['MetricsDestinationArgs', 'MetricsDestination']

@pulumi.input_type
class MetricsDestinationArgs:
    def __init__(__self__, *,
                 app_monitor_name: pulumi.Input[str],
                 destination: pulumi.Input[str],
                 destination_arn: Optional[pulumi.Input[str]] = None,
                 iam_role_arn: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a MetricsDestination resource.
        :param pulumi.Input[str] app_monitor_name: The name of the CloudWatch RUM app monitor that will send the metrics.
        :param pulumi.Input[str] destination: Defines the destination to send the metrics to. Valid values are `CloudWatch` and `Evidently`. If you specify `Evidently`, you must also specify the ARN of the CloudWatchEvidently experiment that is to be the destination and an IAM role that has permission to write to the experiment.
        :param pulumi.Input[str] destination_arn: Use this parameter only if Destination is Evidently. This parameter specifies the ARN of the Evidently experiment that will receive the extended metrics.
        :param pulumi.Input[str] iam_role_arn: This parameter is required if Destination is Evidently. If Destination is CloudWatch, do not use this parameter.
        """
        pulumi.set(__self__, "app_monitor_name", app_monitor_name)
        pulumi.set(__self__, "destination", destination)
        if destination_arn is not None:
            pulumi.set(__self__, "destination_arn", destination_arn)
        if iam_role_arn is not None:
            pulumi.set(__self__, "iam_role_arn", iam_role_arn)

    @property
    @pulumi.getter(name="appMonitorName")
    def app_monitor_name(self) -> pulumi.Input[str]:
        """
        The name of the CloudWatch RUM app monitor that will send the metrics.
        """
        return pulumi.get(self, "app_monitor_name")

    @app_monitor_name.setter
    def app_monitor_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "app_monitor_name", value)

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Input[str]:
        """
        Defines the destination to send the metrics to. Valid values are `CloudWatch` and `Evidently`. If you specify `Evidently`, you must also specify the ARN of the CloudWatchEvidently experiment that is to be the destination and an IAM role that has permission to write to the experiment.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter(name="destinationArn")
    def destination_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Use this parameter only if Destination is Evidently. This parameter specifies the ARN of the Evidently experiment that will receive the extended metrics.
        """
        return pulumi.get(self, "destination_arn")

    @destination_arn.setter
    def destination_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_arn", value)

    @property
    @pulumi.getter(name="iamRoleArn")
    def iam_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        This parameter is required if Destination is Evidently. If Destination is CloudWatch, do not use this parameter.
        """
        return pulumi.get(self, "iam_role_arn")

    @iam_role_arn.setter
    def iam_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iam_role_arn", value)


@pulumi.input_type
class _MetricsDestinationState:
    def __init__(__self__, *,
                 app_monitor_name: Optional[pulumi.Input[str]] = None,
                 destination: Optional[pulumi.Input[str]] = None,
                 destination_arn: Optional[pulumi.Input[str]] = None,
                 iam_role_arn: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MetricsDestination resources.
        :param pulumi.Input[str] app_monitor_name: The name of the CloudWatch RUM app monitor that will send the metrics.
        :param pulumi.Input[str] destination: Defines the destination to send the metrics to. Valid values are `CloudWatch` and `Evidently`. If you specify `Evidently`, you must also specify the ARN of the CloudWatchEvidently experiment that is to be the destination and an IAM role that has permission to write to the experiment.
        :param pulumi.Input[str] destination_arn: Use this parameter only if Destination is Evidently. This parameter specifies the ARN of the Evidently experiment that will receive the extended metrics.
        :param pulumi.Input[str] iam_role_arn: This parameter is required if Destination is Evidently. If Destination is CloudWatch, do not use this parameter.
        """
        if app_monitor_name is not None:
            pulumi.set(__self__, "app_monitor_name", app_monitor_name)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if destination_arn is not None:
            pulumi.set(__self__, "destination_arn", destination_arn)
        if iam_role_arn is not None:
            pulumi.set(__self__, "iam_role_arn", iam_role_arn)

    @property
    @pulumi.getter(name="appMonitorName")
    def app_monitor_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the CloudWatch RUM app monitor that will send the metrics.
        """
        return pulumi.get(self, "app_monitor_name")

    @app_monitor_name.setter
    def app_monitor_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_monitor_name", value)

    @property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input[str]]:
        """
        Defines the destination to send the metrics to. Valid values are `CloudWatch` and `Evidently`. If you specify `Evidently`, you must also specify the ARN of the CloudWatchEvidently experiment that is to be the destination and an IAM role that has permission to write to the experiment.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter(name="destinationArn")
    def destination_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Use this parameter only if Destination is Evidently. This parameter specifies the ARN of the Evidently experiment that will receive the extended metrics.
        """
        return pulumi.get(self, "destination_arn")

    @destination_arn.setter
    def destination_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_arn", value)

    @property
    @pulumi.getter(name="iamRoleArn")
    def iam_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        This parameter is required if Destination is Evidently. If Destination is CloudWatch, do not use this parameter.
        """
        return pulumi.get(self, "iam_role_arn")

    @iam_role_arn.setter
    def iam_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iam_role_arn", value)


class MetricsDestination(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_monitor_name: Optional[pulumi.Input[str]] = None,
                 destination: Optional[pulumi.Input[str]] = None,
                 destination_arn: Optional[pulumi.Input[str]] = None,
                 iam_role_arn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a CloudWatch RUM Metrics Destination resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.rum.MetricsDestination("example",
            app_monitor_name=aws_rum_app_monitor["example"]["name"],
            destination="CloudWatch")
        ```

        ## Import

        Using `pulumi import`, import Cloudwatch RUM Metrics Destination using the `id`. For example:

        ```sh
         $ pulumi import aws:rum/metricsDestination:MetricsDestination example example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_monitor_name: The name of the CloudWatch RUM app monitor that will send the metrics.
        :param pulumi.Input[str] destination: Defines the destination to send the metrics to. Valid values are `CloudWatch` and `Evidently`. If you specify `Evidently`, you must also specify the ARN of the CloudWatchEvidently experiment that is to be the destination and an IAM role that has permission to write to the experiment.
        :param pulumi.Input[str] destination_arn: Use this parameter only if Destination is Evidently. This parameter specifies the ARN of the Evidently experiment that will receive the extended metrics.
        :param pulumi.Input[str] iam_role_arn: This parameter is required if Destination is Evidently. If Destination is CloudWatch, do not use this parameter.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MetricsDestinationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a CloudWatch RUM Metrics Destination resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.rum.MetricsDestination("example",
            app_monitor_name=aws_rum_app_monitor["example"]["name"],
            destination="CloudWatch")
        ```

        ## Import

        Using `pulumi import`, import Cloudwatch RUM Metrics Destination using the `id`. For example:

        ```sh
         $ pulumi import aws:rum/metricsDestination:MetricsDestination example example
        ```

        :param str resource_name: The name of the resource.
        :param MetricsDestinationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MetricsDestinationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_monitor_name: Optional[pulumi.Input[str]] = None,
                 destination: Optional[pulumi.Input[str]] = None,
                 destination_arn: Optional[pulumi.Input[str]] = None,
                 iam_role_arn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MetricsDestinationArgs.__new__(MetricsDestinationArgs)

            if app_monitor_name is None and not opts.urn:
                raise TypeError("Missing required property 'app_monitor_name'")
            __props__.__dict__["app_monitor_name"] = app_monitor_name
            if destination is None and not opts.urn:
                raise TypeError("Missing required property 'destination'")
            __props__.__dict__["destination"] = destination
            __props__.__dict__["destination_arn"] = destination_arn
            __props__.__dict__["iam_role_arn"] = iam_role_arn
        super(MetricsDestination, __self__).__init__(
            'aws:rum/metricsDestination:MetricsDestination',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_monitor_name: Optional[pulumi.Input[str]] = None,
            destination: Optional[pulumi.Input[str]] = None,
            destination_arn: Optional[pulumi.Input[str]] = None,
            iam_role_arn: Optional[pulumi.Input[str]] = None) -> 'MetricsDestination':
        """
        Get an existing MetricsDestination resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_monitor_name: The name of the CloudWatch RUM app monitor that will send the metrics.
        :param pulumi.Input[str] destination: Defines the destination to send the metrics to. Valid values are `CloudWatch` and `Evidently`. If you specify `Evidently`, you must also specify the ARN of the CloudWatchEvidently experiment that is to be the destination and an IAM role that has permission to write to the experiment.
        :param pulumi.Input[str] destination_arn: Use this parameter only if Destination is Evidently. This parameter specifies the ARN of the Evidently experiment that will receive the extended metrics.
        :param pulumi.Input[str] iam_role_arn: This parameter is required if Destination is Evidently. If Destination is CloudWatch, do not use this parameter.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MetricsDestinationState.__new__(_MetricsDestinationState)

        __props__.__dict__["app_monitor_name"] = app_monitor_name
        __props__.__dict__["destination"] = destination
        __props__.__dict__["destination_arn"] = destination_arn
        __props__.__dict__["iam_role_arn"] = iam_role_arn
        return MetricsDestination(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appMonitorName")
    def app_monitor_name(self) -> pulumi.Output[str]:
        """
        The name of the CloudWatch RUM app monitor that will send the metrics.
        """
        return pulumi.get(self, "app_monitor_name")

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Output[str]:
        """
        Defines the destination to send the metrics to. Valid values are `CloudWatch` and `Evidently`. If you specify `Evidently`, you must also specify the ARN of the CloudWatchEvidently experiment that is to be the destination and an IAM role that has permission to write to the experiment.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="destinationArn")
    def destination_arn(self) -> pulumi.Output[Optional[str]]:
        """
        Use this parameter only if Destination is Evidently. This parameter specifies the ARN of the Evidently experiment that will receive the extended metrics.
        """
        return pulumi.get(self, "destination_arn")

    @property
    @pulumi.getter(name="iamRoleArn")
    def iam_role_arn(self) -> pulumi.Output[Optional[str]]:
        """
        This parameter is required if Destination is Evidently. If Destination is CloudWatch, do not use this parameter.
        """
        return pulumi.get(self, "iam_role_arn")

