# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'BucketLifecycleConfigurationRule',
    'BucketLifecycleConfigurationRuleAbortIncompleteMultipartUpload',
    'BucketLifecycleConfigurationRuleExpiration',
    'BucketLifecycleConfigurationRuleFilter',
    'MultiRegionAccessPointDetails',
    'MultiRegionAccessPointDetailsPublicAccessBlock',
    'MultiRegionAccessPointDetailsRegion',
    'MultiRegionAccessPointPolicyDetails',
    'ObjectLambdaAccessPointConfiguration',
    'ObjectLambdaAccessPointConfigurationTransformationConfiguration',
    'ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformation',
    'ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationAwsLambda',
    'StorageLensConfigurationStorageLensConfiguration',
    'StorageLensConfigurationStorageLensConfigurationAccountLevel',
    'StorageLensConfigurationStorageLensConfigurationAccountLevelActivityMetrics',
    'StorageLensConfigurationStorageLensConfigurationAccountLevelAdvancedCostOptimizationMetrics',
    'StorageLensConfigurationStorageLensConfigurationAccountLevelAdvancedDataProtectionMetrics',
    'StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevel',
    'StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelActivityMetrics',
    'StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelAdvancedCostOptimizationMetrics',
    'StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelAdvancedDataProtectionMetrics',
    'StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelDetailedStatusCodeMetrics',
    'StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevel',
    'StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetrics',
    'StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetricsSelectionCriteria',
    'StorageLensConfigurationStorageLensConfigurationAccountLevelDetailedStatusCodeMetrics',
    'StorageLensConfigurationStorageLensConfigurationAwsOrg',
    'StorageLensConfigurationStorageLensConfigurationDataExport',
    'StorageLensConfigurationStorageLensConfigurationDataExportCloudWatchMetrics',
    'StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestination',
    'StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryption',
    'StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionSseKms',
    'StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionSseS3',
    'StorageLensConfigurationStorageLensConfigurationExclude',
    'StorageLensConfigurationStorageLensConfigurationInclude',
    'GetMultiRegionAccessPointPublicAccessBlockResult',
    'GetMultiRegionAccessPointRegionResult',
]

@pulumi.output_type
class BucketLifecycleConfigurationRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "abortIncompleteMultipartUpload":
            suggest = "abort_incomplete_multipart_upload"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleConfigurationRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleConfigurationRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleConfigurationRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 abort_incomplete_multipart_upload: Optional['outputs.BucketLifecycleConfigurationRuleAbortIncompleteMultipartUpload'] = None,
                 expiration: Optional['outputs.BucketLifecycleConfigurationRuleExpiration'] = None,
                 filter: Optional['outputs.BucketLifecycleConfigurationRuleFilter'] = None,
                 status: Optional[str] = None):
        """
        :param str id: Unique identifier for the rule.
        :param 'BucketLifecycleConfigurationRuleAbortIncompleteMultipartUploadArgs' abort_incomplete_multipart_upload: Configuration block containing settings for abort incomplete multipart upload.
        :param 'BucketLifecycleConfigurationRuleExpirationArgs' expiration: Configuration block containing settings for expiration of objects.
        :param 'BucketLifecycleConfigurationRuleFilterArgs' filter: Configuration block containing settings for filtering.
        :param str status: Status of the rule. Valid values: `Enabled` and `Disabled`. Defaults to `Enabled`.
        """
        pulumi.set(__self__, "id", id)
        if abort_incomplete_multipart_upload is not None:
            pulumi.set(__self__, "abort_incomplete_multipart_upload", abort_incomplete_multipart_upload)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique identifier for the rule.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="abortIncompleteMultipartUpload")
    def abort_incomplete_multipart_upload(self) -> Optional['outputs.BucketLifecycleConfigurationRuleAbortIncompleteMultipartUpload']:
        """
        Configuration block containing settings for abort incomplete multipart upload.
        """
        return pulumi.get(self, "abort_incomplete_multipart_upload")

    @property
    @pulumi.getter
    def expiration(self) -> Optional['outputs.BucketLifecycleConfigurationRuleExpiration']:
        """
        Configuration block containing settings for expiration of objects.
        """
        return pulumi.get(self, "expiration")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.BucketLifecycleConfigurationRuleFilter']:
        """
        Configuration block containing settings for filtering.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Status of the rule. Valid values: `Enabled` and `Disabled`. Defaults to `Enabled`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class BucketLifecycleConfigurationRuleAbortIncompleteMultipartUpload(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "daysAfterInitiation":
            suggest = "days_after_initiation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleConfigurationRuleAbortIncompleteMultipartUpload. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleConfigurationRuleAbortIncompleteMultipartUpload.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleConfigurationRuleAbortIncompleteMultipartUpload.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 days_after_initiation: int):
        """
        :param int days_after_initiation: Number of days after which Amazon S3 aborts an incomplete multipart upload.
        """
        pulumi.set(__self__, "days_after_initiation", days_after_initiation)

    @property
    @pulumi.getter(name="daysAfterInitiation")
    def days_after_initiation(self) -> int:
        """
        Number of days after which Amazon S3 aborts an incomplete multipart upload.
        """
        return pulumi.get(self, "days_after_initiation")


@pulumi.output_type
class BucketLifecycleConfigurationRuleExpiration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expiredObjectDeleteMarker":
            suggest = "expired_object_delete_marker"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleConfigurationRuleExpiration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleConfigurationRuleExpiration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleConfigurationRuleExpiration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 date: Optional[str] = None,
                 days: Optional[int] = None,
                 expired_object_delete_marker: Optional[bool] = None):
        """
        :param str date: Date the object is to be deleted. Should be in `YYYY-MM-DD` date format, e.g., `2020-09-30`.
        :param int days: Number of days before the object is to be deleted.
        :param bool expired_object_delete_marker: Enable to remove a delete marker with no noncurrent versions. Cannot be specified with `date` or `days`.
        """
        if date is not None:
            pulumi.set(__self__, "date", date)
        if days is not None:
            pulumi.set(__self__, "days", days)
        if expired_object_delete_marker is not None:
            pulumi.set(__self__, "expired_object_delete_marker", expired_object_delete_marker)

    @property
    @pulumi.getter
    def date(self) -> Optional[str]:
        """
        Date the object is to be deleted. Should be in `YYYY-MM-DD` date format, e.g., `2020-09-30`.
        """
        return pulumi.get(self, "date")

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        """
        Number of days before the object is to be deleted.
        """
        return pulumi.get(self, "days")

    @property
    @pulumi.getter(name="expiredObjectDeleteMarker")
    def expired_object_delete_marker(self) -> Optional[bool]:
        """
        Enable to remove a delete marker with no noncurrent versions. Cannot be specified with `date` or `days`.
        """
        return pulumi.get(self, "expired_object_delete_marker")


@pulumi.output_type
class BucketLifecycleConfigurationRuleFilter(dict):
    def __init__(__self__, *,
                 prefix: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        :param str prefix: Object prefix for rule filtering.
        :param Mapping[str, str] tags: Key-value map of object tags for rule filtering.
        """
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        Object prefix for rule filtering.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Key-value map of object tags for rule filtering.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class MultiRegionAccessPointDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicAccessBlock":
            suggest = "public_access_block"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MultiRegionAccessPointDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MultiRegionAccessPointDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MultiRegionAccessPointDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 regions: Sequence['outputs.MultiRegionAccessPointDetailsRegion'],
                 public_access_block: Optional['outputs.MultiRegionAccessPointDetailsPublicAccessBlock'] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "regions", regions)
        if public_access_block is not None:
            pulumi.set(__self__, "public_access_block", public_access_block)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def regions(self) -> Sequence['outputs.MultiRegionAccessPointDetailsRegion']:
        return pulumi.get(self, "regions")

    @property
    @pulumi.getter(name="publicAccessBlock")
    def public_access_block(self) -> Optional['outputs.MultiRegionAccessPointDetailsPublicAccessBlock']:
        return pulumi.get(self, "public_access_block")


@pulumi.output_type
class MultiRegionAccessPointDetailsPublicAccessBlock(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blockPublicAcls":
            suggest = "block_public_acls"
        elif key == "blockPublicPolicy":
            suggest = "block_public_policy"
        elif key == "ignorePublicAcls":
            suggest = "ignore_public_acls"
        elif key == "restrictPublicBuckets":
            suggest = "restrict_public_buckets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MultiRegionAccessPointDetailsPublicAccessBlock. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MultiRegionAccessPointDetailsPublicAccessBlock.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MultiRegionAccessPointDetailsPublicAccessBlock.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 block_public_acls: Optional[bool] = None,
                 block_public_policy: Optional[bool] = None,
                 ignore_public_acls: Optional[bool] = None,
                 restrict_public_buckets: Optional[bool] = None):
        if block_public_acls is not None:
            pulumi.set(__self__, "block_public_acls", block_public_acls)
        if block_public_policy is not None:
            pulumi.set(__self__, "block_public_policy", block_public_policy)
        if ignore_public_acls is not None:
            pulumi.set(__self__, "ignore_public_acls", ignore_public_acls)
        if restrict_public_buckets is not None:
            pulumi.set(__self__, "restrict_public_buckets", restrict_public_buckets)

    @property
    @pulumi.getter(name="blockPublicAcls")
    def block_public_acls(self) -> Optional[bool]:
        return pulumi.get(self, "block_public_acls")

    @property
    @pulumi.getter(name="blockPublicPolicy")
    def block_public_policy(self) -> Optional[bool]:
        return pulumi.get(self, "block_public_policy")

    @property
    @pulumi.getter(name="ignorePublicAcls")
    def ignore_public_acls(self) -> Optional[bool]:
        return pulumi.get(self, "ignore_public_acls")

    @property
    @pulumi.getter(name="restrictPublicBuckets")
    def restrict_public_buckets(self) -> Optional[bool]:
        return pulumi.get(self, "restrict_public_buckets")


@pulumi.output_type
class MultiRegionAccessPointDetailsRegion(dict):
    def __init__(__self__, *,
                 bucket: str):
        pulumi.set(__self__, "bucket", bucket)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        return pulumi.get(self, "bucket")


@pulumi.output_type
class MultiRegionAccessPointPolicyDetails(dict):
    def __init__(__self__, *,
                 name: str,
                 policy: str):
        """
        :param str name: The name of the Multi-Region Access Point.
        :param str policy: A valid JSON document that specifies the policy that you want to associate with this Multi-Region Access Point. Once applied, the policy can be edited, but not deleted. For more information, see the documentation on [Multi-Region Access Point Permissions](https://docs.aws.amazon.com/AmazonS3/latest/userguide/MultiRegionAccessPointPermissions.html).
               
               > **NOTE:** When you update the `policy`, the update is first listed as the proposed policy. After the update is finished and all Regions have been updated, the proposed policy is listed as the established policy. If both policies have the same version number, the proposed policy is the established policy.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "policy", policy)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Multi-Region Access Point.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def policy(self) -> str:
        """
        A valid JSON document that specifies the policy that you want to associate with this Multi-Region Access Point. Once applied, the policy can be edited, but not deleted. For more information, see the documentation on [Multi-Region Access Point Permissions](https://docs.aws.amazon.com/AmazonS3/latest/userguide/MultiRegionAccessPointPermissions.html).

        > **NOTE:** When you update the `policy`, the update is first listed as the proposed policy. After the update is finished and all Regions have been updated, the proposed policy is listed as the established policy. If both policies have the same version number, the proposed policy is the established policy.
        """
        return pulumi.get(self, "policy")


@pulumi.output_type
class ObjectLambdaAccessPointConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "supportingAccessPoint":
            suggest = "supporting_access_point"
        elif key == "transformationConfigurations":
            suggest = "transformation_configurations"
        elif key == "allowedFeatures":
            suggest = "allowed_features"
        elif key == "cloudWatchMetricsEnabled":
            suggest = "cloud_watch_metrics_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectLambdaAccessPointConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectLambdaAccessPointConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectLambdaAccessPointConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 supporting_access_point: str,
                 transformation_configurations: Sequence['outputs.ObjectLambdaAccessPointConfigurationTransformationConfiguration'],
                 allowed_features: Optional[Sequence[str]] = None,
                 cloud_watch_metrics_enabled: Optional[bool] = None):
        """
        :param str supporting_access_point: Standard access point associated with the Object Lambda Access Point.
        :param Sequence['ObjectLambdaAccessPointConfigurationTransformationConfigurationArgs'] transformation_configurations: List of transformation configurations for the Object Lambda Access Point. See Transformation Configuration below for more details.
        :param Sequence[str] allowed_features: Allowed features. Valid values: `GetObject-Range`, `GetObject-PartNumber`.
        :param bool cloud_watch_metrics_enabled: Whether or not the CloudWatch metrics configuration is enabled.
        """
        pulumi.set(__self__, "supporting_access_point", supporting_access_point)
        pulumi.set(__self__, "transformation_configurations", transformation_configurations)
        if allowed_features is not None:
            pulumi.set(__self__, "allowed_features", allowed_features)
        if cloud_watch_metrics_enabled is not None:
            pulumi.set(__self__, "cloud_watch_metrics_enabled", cloud_watch_metrics_enabled)

    @property
    @pulumi.getter(name="supportingAccessPoint")
    def supporting_access_point(self) -> str:
        """
        Standard access point associated with the Object Lambda Access Point.
        """
        return pulumi.get(self, "supporting_access_point")

    @property
    @pulumi.getter(name="transformationConfigurations")
    def transformation_configurations(self) -> Sequence['outputs.ObjectLambdaAccessPointConfigurationTransformationConfiguration']:
        """
        List of transformation configurations for the Object Lambda Access Point. See Transformation Configuration below for more details.
        """
        return pulumi.get(self, "transformation_configurations")

    @property
    @pulumi.getter(name="allowedFeatures")
    def allowed_features(self) -> Optional[Sequence[str]]:
        """
        Allowed features. Valid values: `GetObject-Range`, `GetObject-PartNumber`.
        """
        return pulumi.get(self, "allowed_features")

    @property
    @pulumi.getter(name="cloudWatchMetricsEnabled")
    def cloud_watch_metrics_enabled(self) -> Optional[bool]:
        """
        Whether or not the CloudWatch metrics configuration is enabled.
        """
        return pulumi.get(self, "cloud_watch_metrics_enabled")


@pulumi.output_type
class ObjectLambdaAccessPointConfigurationTransformationConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentTransformation":
            suggest = "content_transformation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectLambdaAccessPointConfigurationTransformationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectLambdaAccessPointConfigurationTransformationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectLambdaAccessPointConfigurationTransformationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions: Sequence[str],
                 content_transformation: 'outputs.ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformation'):
        """
        :param Sequence[str] actions: The actions of an Object Lambda Access Point configuration. Valid values: `GetObject`.
        :param 'ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationArgs' content_transformation: The content transformation of an Object Lambda Access Point configuration. See Content Transformation below for more details.
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "content_transformation", content_transformation)

    @property
    @pulumi.getter
    def actions(self) -> Sequence[str]:
        """
        The actions of an Object Lambda Access Point configuration. Valid values: `GetObject`.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="contentTransformation")
    def content_transformation(self) -> 'outputs.ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformation':
        """
        The content transformation of an Object Lambda Access Point configuration. See Content Transformation below for more details.
        """
        return pulumi.get(self, "content_transformation")


@pulumi.output_type
class ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsLambda":
            suggest = "aws_lambda"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_lambda: 'outputs.ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationAwsLambda'):
        """
        :param 'ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationAwsLambdaArgs' aws_lambda: Configuration for an AWS Lambda function. See AWS Lambda below for more details.
        """
        pulumi.set(__self__, "aws_lambda", aws_lambda)

    @property
    @pulumi.getter(name="awsLambda")
    def aws_lambda(self) -> 'outputs.ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationAwsLambda':
        """
        Configuration for an AWS Lambda function. See AWS Lambda below for more details.
        """
        return pulumi.get(self, "aws_lambda")


@pulumi.output_type
class ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationAwsLambda(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "functionArn":
            suggest = "function_arn"
        elif key == "functionPayload":
            suggest = "function_payload"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationAwsLambda. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationAwsLambda.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationAwsLambda.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 function_arn: str,
                 function_payload: Optional[str] = None):
        """
        :param str function_arn: The Amazon Resource Name (ARN) of the AWS Lambda function.
        :param str function_payload: Additional JSON that provides supplemental data to the Lambda function used to transform objects.
        """
        pulumi.set(__self__, "function_arn", function_arn)
        if function_payload is not None:
            pulumi.set(__self__, "function_payload", function_payload)

    @property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of the AWS Lambda function.
        """
        return pulumi.get(self, "function_arn")

    @property
    @pulumi.getter(name="functionPayload")
    def function_payload(self) -> Optional[str]:
        """
        Additional JSON that provides supplemental data to the Lambda function used to transform objects.
        """
        return pulumi.get(self, "function_payload")


@pulumi.output_type
class StorageLensConfigurationStorageLensConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountLevel":
            suggest = "account_level"
        elif key == "awsOrg":
            suggest = "aws_org"
        elif key == "dataExport":
            suggest = "data_export"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageLensConfigurationStorageLensConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageLensConfigurationStorageLensConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageLensConfigurationStorageLensConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_level: 'outputs.StorageLensConfigurationStorageLensConfigurationAccountLevel',
                 enabled: bool,
                 aws_org: Optional['outputs.StorageLensConfigurationStorageLensConfigurationAwsOrg'] = None,
                 data_export: Optional['outputs.StorageLensConfigurationStorageLensConfigurationDataExport'] = None,
                 exclude: Optional['outputs.StorageLensConfigurationStorageLensConfigurationExclude'] = None,
                 include: Optional['outputs.StorageLensConfigurationStorageLensConfigurationInclude'] = None):
        """
        :param 'StorageLensConfigurationStorageLensConfigurationAccountLevelArgs' account_level: The account-level configurations of the S3 Storage Lens configuration. See Account Level below for more details.
        :param bool enabled: Whether the S3 Storage Lens configuration is enabled.
        :param 'StorageLensConfigurationStorageLensConfigurationAwsOrgArgs' aws_org: The Amazon Web Services organization for the S3 Storage Lens configuration. See AWS Org below for more details.
        :param 'StorageLensConfigurationStorageLensConfigurationDataExportArgs' data_export: Properties of S3 Storage Lens metrics export including the destination, schema and format. See Data Export below for more details.
        :param 'StorageLensConfigurationStorageLensConfigurationExcludeArgs' exclude: What is excluded in this configuration. Conflicts with `include`. See Exclude below for more details.
        :param 'StorageLensConfigurationStorageLensConfigurationIncludeArgs' include: What is included in this configuration. Conflicts with `exclude`. See Include below for more details.
        """
        pulumi.set(__self__, "account_level", account_level)
        pulumi.set(__self__, "enabled", enabled)
        if aws_org is not None:
            pulumi.set(__self__, "aws_org", aws_org)
        if data_export is not None:
            pulumi.set(__self__, "data_export", data_export)
        if exclude is not None:
            pulumi.set(__self__, "exclude", exclude)
        if include is not None:
            pulumi.set(__self__, "include", include)

    @property
    @pulumi.getter(name="accountLevel")
    def account_level(self) -> 'outputs.StorageLensConfigurationStorageLensConfigurationAccountLevel':
        """
        The account-level configurations of the S3 Storage Lens configuration. See Account Level below for more details.
        """
        return pulumi.get(self, "account_level")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether the S3 Storage Lens configuration is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="awsOrg")
    def aws_org(self) -> Optional['outputs.StorageLensConfigurationStorageLensConfigurationAwsOrg']:
        """
        The Amazon Web Services organization for the S3 Storage Lens configuration. See AWS Org below for more details.
        """
        return pulumi.get(self, "aws_org")

    @property
    @pulumi.getter(name="dataExport")
    def data_export(self) -> Optional['outputs.StorageLensConfigurationStorageLensConfigurationDataExport']:
        """
        Properties of S3 Storage Lens metrics export including the destination, schema and format. See Data Export below for more details.
        """
        return pulumi.get(self, "data_export")

    @property
    @pulumi.getter
    def exclude(self) -> Optional['outputs.StorageLensConfigurationStorageLensConfigurationExclude']:
        """
        What is excluded in this configuration. Conflicts with `include`. See Exclude below for more details.
        """
        return pulumi.get(self, "exclude")

    @property
    @pulumi.getter
    def include(self) -> Optional['outputs.StorageLensConfigurationStorageLensConfigurationInclude']:
        """
        What is included in this configuration. Conflicts with `exclude`. See Include below for more details.
        """
        return pulumi.get(self, "include")


@pulumi.output_type
class StorageLensConfigurationStorageLensConfigurationAccountLevel(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketLevel":
            suggest = "bucket_level"
        elif key == "activityMetrics":
            suggest = "activity_metrics"
        elif key == "advancedCostOptimizationMetrics":
            suggest = "advanced_cost_optimization_metrics"
        elif key == "advancedDataProtectionMetrics":
            suggest = "advanced_data_protection_metrics"
        elif key == "detailedStatusCodeMetrics":
            suggest = "detailed_status_code_metrics"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageLensConfigurationStorageLensConfigurationAccountLevel. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageLensConfigurationStorageLensConfigurationAccountLevel.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageLensConfigurationStorageLensConfigurationAccountLevel.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_level: 'outputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevel',
                 activity_metrics: Optional['outputs.StorageLensConfigurationStorageLensConfigurationAccountLevelActivityMetrics'] = None,
                 advanced_cost_optimization_metrics: Optional['outputs.StorageLensConfigurationStorageLensConfigurationAccountLevelAdvancedCostOptimizationMetrics'] = None,
                 advanced_data_protection_metrics: Optional['outputs.StorageLensConfigurationStorageLensConfigurationAccountLevelAdvancedDataProtectionMetrics'] = None,
                 detailed_status_code_metrics: Optional['outputs.StorageLensConfigurationStorageLensConfigurationAccountLevelDetailedStatusCodeMetrics'] = None):
        """
        :param 'StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelArgs' bucket_level: S3 Storage Lens bucket-level configuration. See Bucket Level below for more details.
        :param 'StorageLensConfigurationStorageLensConfigurationAccountLevelActivityMetricsArgs' activity_metrics: S3 Storage Lens activity metrics. See Activity Metrics below for more details.
        :param 'StorageLensConfigurationStorageLensConfigurationAccountLevelAdvancedCostOptimizationMetricsArgs' advanced_cost_optimization_metrics: Advanced cost-optimization metrics for S3 Storage Lens. See Advanced Cost-Optimization Metrics below for more details.
        :param 'StorageLensConfigurationStorageLensConfigurationAccountLevelAdvancedDataProtectionMetricsArgs' advanced_data_protection_metrics: Advanced data-protection metrics for S3 Storage Lens. See Advanced Data-Protection Metrics below for more details.
        :param 'StorageLensConfigurationStorageLensConfigurationAccountLevelDetailedStatusCodeMetricsArgs' detailed_status_code_metrics: Detailed status code metrics for S3 Storage Lens. See Detailed Status Code Metrics below for more details.
        """
        pulumi.set(__self__, "bucket_level", bucket_level)
        if activity_metrics is not None:
            pulumi.set(__self__, "activity_metrics", activity_metrics)
        if advanced_cost_optimization_metrics is not None:
            pulumi.set(__self__, "advanced_cost_optimization_metrics", advanced_cost_optimization_metrics)
        if advanced_data_protection_metrics is not None:
            pulumi.set(__self__, "advanced_data_protection_metrics", advanced_data_protection_metrics)
        if detailed_status_code_metrics is not None:
            pulumi.set(__self__, "detailed_status_code_metrics", detailed_status_code_metrics)

    @property
    @pulumi.getter(name="bucketLevel")
    def bucket_level(self) -> 'outputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevel':
        """
        S3 Storage Lens bucket-level configuration. See Bucket Level below for more details.
        """
        return pulumi.get(self, "bucket_level")

    @property
    @pulumi.getter(name="activityMetrics")
    def activity_metrics(self) -> Optional['outputs.StorageLensConfigurationStorageLensConfigurationAccountLevelActivityMetrics']:
        """
        S3 Storage Lens activity metrics. See Activity Metrics below for more details.
        """
        return pulumi.get(self, "activity_metrics")

    @property
    @pulumi.getter(name="advancedCostOptimizationMetrics")
    def advanced_cost_optimization_metrics(self) -> Optional['outputs.StorageLensConfigurationStorageLensConfigurationAccountLevelAdvancedCostOptimizationMetrics']:
        """
        Advanced cost-optimization metrics for S3 Storage Lens. See Advanced Cost-Optimization Metrics below for more details.
        """
        return pulumi.get(self, "advanced_cost_optimization_metrics")

    @property
    @pulumi.getter(name="advancedDataProtectionMetrics")
    def advanced_data_protection_metrics(self) -> Optional['outputs.StorageLensConfigurationStorageLensConfigurationAccountLevelAdvancedDataProtectionMetrics']:
        """
        Advanced data-protection metrics for S3 Storage Lens. See Advanced Data-Protection Metrics below for more details.
        """
        return pulumi.get(self, "advanced_data_protection_metrics")

    @property
    @pulumi.getter(name="detailedStatusCodeMetrics")
    def detailed_status_code_metrics(self) -> Optional['outputs.StorageLensConfigurationStorageLensConfigurationAccountLevelDetailedStatusCodeMetrics']:
        """
        Detailed status code metrics for S3 Storage Lens. See Detailed Status Code Metrics below for more details.
        """
        return pulumi.get(self, "detailed_status_code_metrics")


@pulumi.output_type
class StorageLensConfigurationStorageLensConfigurationAccountLevelActivityMetrics(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        """
        :param bool enabled: Whether the activity metrics are enabled.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether the activity metrics are enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class StorageLensConfigurationStorageLensConfigurationAccountLevelAdvancedCostOptimizationMetrics(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        """
        :param bool enabled: Whether advanced cost-optimization metrics are enabled.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether advanced cost-optimization metrics are enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class StorageLensConfigurationStorageLensConfigurationAccountLevelAdvancedDataProtectionMetrics(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        """
        :param bool enabled: Whether advanced data-protection metrics are enabled.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether advanced data-protection metrics are enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevel(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activityMetrics":
            suggest = "activity_metrics"
        elif key == "advancedCostOptimizationMetrics":
            suggest = "advanced_cost_optimization_metrics"
        elif key == "advancedDataProtectionMetrics":
            suggest = "advanced_data_protection_metrics"
        elif key == "detailedStatusCodeMetrics":
            suggest = "detailed_status_code_metrics"
        elif key == "prefixLevel":
            suggest = "prefix_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevel. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevel.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevel.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 activity_metrics: Optional['outputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelActivityMetrics'] = None,
                 advanced_cost_optimization_metrics: Optional['outputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelAdvancedCostOptimizationMetrics'] = None,
                 advanced_data_protection_metrics: Optional['outputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelAdvancedDataProtectionMetrics'] = None,
                 detailed_status_code_metrics: Optional['outputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelDetailedStatusCodeMetrics'] = None,
                 prefix_level: Optional['outputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevel'] = None):
        """
        :param 'StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelActivityMetricsArgs' activity_metrics: S3 Storage Lens activity metrics. See Activity Metrics above for more details.
        :param 'StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelAdvancedCostOptimizationMetricsArgs' advanced_cost_optimization_metrics: Advanced cost-optimization metrics for S3 Storage Lens. See Advanced Cost-Optimization Metrics above for more details.
        :param 'StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelAdvancedDataProtectionMetricsArgs' advanced_data_protection_metrics: Advanced data-protection metrics for S3 Storage Lens. See Advanced Data-Protection Metrics above for more details.
        :param 'StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelDetailedStatusCodeMetricsArgs' detailed_status_code_metrics: Detailed status code metrics for S3 Storage Lens. See Detailed Status Code Metrics above for more details.
        :param 'StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelArgs' prefix_level: Prefix-level metrics for S3 Storage Lens. See Prefix Level below for more details.
        """
        if activity_metrics is not None:
            pulumi.set(__self__, "activity_metrics", activity_metrics)
        if advanced_cost_optimization_metrics is not None:
            pulumi.set(__self__, "advanced_cost_optimization_metrics", advanced_cost_optimization_metrics)
        if advanced_data_protection_metrics is not None:
            pulumi.set(__self__, "advanced_data_protection_metrics", advanced_data_protection_metrics)
        if detailed_status_code_metrics is not None:
            pulumi.set(__self__, "detailed_status_code_metrics", detailed_status_code_metrics)
        if prefix_level is not None:
            pulumi.set(__self__, "prefix_level", prefix_level)

    @property
    @pulumi.getter(name="activityMetrics")
    def activity_metrics(self) -> Optional['outputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelActivityMetrics']:
        """
        S3 Storage Lens activity metrics. See Activity Metrics above for more details.
        """
        return pulumi.get(self, "activity_metrics")

    @property
    @pulumi.getter(name="advancedCostOptimizationMetrics")
    def advanced_cost_optimization_metrics(self) -> Optional['outputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelAdvancedCostOptimizationMetrics']:
        """
        Advanced cost-optimization metrics for S3 Storage Lens. See Advanced Cost-Optimization Metrics above for more details.
        """
        return pulumi.get(self, "advanced_cost_optimization_metrics")

    @property
    @pulumi.getter(name="advancedDataProtectionMetrics")
    def advanced_data_protection_metrics(self) -> Optional['outputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelAdvancedDataProtectionMetrics']:
        """
        Advanced data-protection metrics for S3 Storage Lens. See Advanced Data-Protection Metrics above for more details.
        """
        return pulumi.get(self, "advanced_data_protection_metrics")

    @property
    @pulumi.getter(name="detailedStatusCodeMetrics")
    def detailed_status_code_metrics(self) -> Optional['outputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelDetailedStatusCodeMetrics']:
        """
        Detailed status code metrics for S3 Storage Lens. See Detailed Status Code Metrics above for more details.
        """
        return pulumi.get(self, "detailed_status_code_metrics")

    @property
    @pulumi.getter(name="prefixLevel")
    def prefix_level(self) -> Optional['outputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevel']:
        """
        Prefix-level metrics for S3 Storage Lens. See Prefix Level below for more details.
        """
        return pulumi.get(self, "prefix_level")


@pulumi.output_type
class StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelActivityMetrics(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        """
        :param bool enabled: Whether the activity metrics are enabled.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether the activity metrics are enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelAdvancedCostOptimizationMetrics(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        """
        :param bool enabled: Whether advanced cost-optimization metrics are enabled.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether advanced cost-optimization metrics are enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelAdvancedDataProtectionMetrics(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        """
        :param bool enabled: Whether advanced data-protection metrics are enabled.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether advanced data-protection metrics are enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelDetailedStatusCodeMetrics(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        """
        :param bool enabled: Whether detailed status code metrics are enabled.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether detailed status code metrics are enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevel(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageMetrics":
            suggest = "storage_metrics"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevel. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevel.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevel.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_metrics: 'outputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetrics'):
        """
        :param 'StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetricsArgs' storage_metrics: Prefix-level storage metrics for S3 Storage Lens. See Prefix Level Storage Metrics below for more details.
        """
        pulumi.set(__self__, "storage_metrics", storage_metrics)

    @property
    @pulumi.getter(name="storageMetrics")
    def storage_metrics(self) -> 'outputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetrics':
        """
        Prefix-level storage metrics for S3 Storage Lens. See Prefix Level Storage Metrics below for more details.
        """
        return pulumi.get(self, "storage_metrics")


@pulumi.output_type
class StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetrics(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "selectionCriteria":
            suggest = "selection_criteria"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetrics. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetrics.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetrics.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 selection_criteria: Optional['outputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetricsSelectionCriteria'] = None):
        """
        :param bool enabled: Whether prefix-level storage metrics are enabled.
        :param 'StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetricsSelectionCriteriaArgs' selection_criteria: Selection criteria. See Selection Criteria below for more details.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if selection_criteria is not None:
            pulumi.set(__self__, "selection_criteria", selection_criteria)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether prefix-level storage metrics are enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="selectionCriteria")
    def selection_criteria(self) -> Optional['outputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetricsSelectionCriteria']:
        """
        Selection criteria. See Selection Criteria below for more details.
        """
        return pulumi.get(self, "selection_criteria")


@pulumi.output_type
class StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetricsSelectionCriteria(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxDepth":
            suggest = "max_depth"
        elif key == "minStorageBytesPercentage":
            suggest = "min_storage_bytes_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetricsSelectionCriteria. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetricsSelectionCriteria.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelPrefixLevelStorageMetricsSelectionCriteria.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delimiter: Optional[str] = None,
                 max_depth: Optional[int] = None,
                 min_storage_bytes_percentage: Optional[float] = None):
        """
        :param str delimiter: The delimiter of the selection criteria being used.
        :param int max_depth: The max depth of the selection criteria.
        :param float min_storage_bytes_percentage: The minimum number of storage bytes percentage whose metrics will be selected.
        """
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)
        if max_depth is not None:
            pulumi.set(__self__, "max_depth", max_depth)
        if min_storage_bytes_percentage is not None:
            pulumi.set(__self__, "min_storage_bytes_percentage", min_storage_bytes_percentage)

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[str]:
        """
        The delimiter of the selection criteria being used.
        """
        return pulumi.get(self, "delimiter")

    @property
    @pulumi.getter(name="maxDepth")
    def max_depth(self) -> Optional[int]:
        """
        The max depth of the selection criteria.
        """
        return pulumi.get(self, "max_depth")

    @property
    @pulumi.getter(name="minStorageBytesPercentage")
    def min_storage_bytes_percentage(self) -> Optional[float]:
        """
        The minimum number of storage bytes percentage whose metrics will be selected.
        """
        return pulumi.get(self, "min_storage_bytes_percentage")


@pulumi.output_type
class StorageLensConfigurationStorageLensConfigurationAccountLevelDetailedStatusCodeMetrics(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        """
        :param bool enabled: Whether detailed status code metrics are enabled.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether detailed status code metrics are enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class StorageLensConfigurationStorageLensConfigurationAwsOrg(dict):
    def __init__(__self__, *,
                 arn: str):
        """
        :param str arn: The Amazon Resource Name (ARN) of the Amazon Web Services organization.
        """
        pulumi.set(__self__, "arn", arn)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of the Amazon Web Services organization.
        """
        return pulumi.get(self, "arn")


@pulumi.output_type
class StorageLensConfigurationStorageLensConfigurationDataExport(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudWatchMetrics":
            suggest = "cloud_watch_metrics"
        elif key == "s3BucketDestination":
            suggest = "s3_bucket_destination"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageLensConfigurationStorageLensConfigurationDataExport. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageLensConfigurationStorageLensConfigurationDataExport.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageLensConfigurationStorageLensConfigurationDataExport.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_watch_metrics: Optional['outputs.StorageLensConfigurationStorageLensConfigurationDataExportCloudWatchMetrics'] = None,
                 s3_bucket_destination: Optional['outputs.StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestination'] = None):
        """
        :param 'StorageLensConfigurationStorageLensConfigurationDataExportCloudWatchMetricsArgs' cloud_watch_metrics: Amazon CloudWatch publishing for S3 Storage Lens metrics. See Cloud Watch Metrics below for more details.
        :param 'StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationArgs' s3_bucket_destination: The bucket where the S3 Storage Lens metrics export will be located. See S3 Bucket Destination below for more details.
        """
        if cloud_watch_metrics is not None:
            pulumi.set(__self__, "cloud_watch_metrics", cloud_watch_metrics)
        if s3_bucket_destination is not None:
            pulumi.set(__self__, "s3_bucket_destination", s3_bucket_destination)

    @property
    @pulumi.getter(name="cloudWatchMetrics")
    def cloud_watch_metrics(self) -> Optional['outputs.StorageLensConfigurationStorageLensConfigurationDataExportCloudWatchMetrics']:
        """
        Amazon CloudWatch publishing for S3 Storage Lens metrics. See Cloud Watch Metrics below for more details.
        """
        return pulumi.get(self, "cloud_watch_metrics")

    @property
    @pulumi.getter(name="s3BucketDestination")
    def s3_bucket_destination(self) -> Optional['outputs.StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestination']:
        """
        The bucket where the S3 Storage Lens metrics export will be located. See S3 Bucket Destination below for more details.
        """
        return pulumi.get(self, "s3_bucket_destination")


@pulumi.output_type
class StorageLensConfigurationStorageLensConfigurationDataExportCloudWatchMetrics(dict):
    def __init__(__self__, *,
                 enabled: bool):
        """
        :param bool enabled: Whether CloudWatch publishing for S3 Storage Lens metrics is enabled.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether CloudWatch publishing for S3 Storage Lens metrics is enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountId":
            suggest = "account_id"
        elif key == "outputSchemaVersion":
            suggest = "output_schema_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_id: str,
                 arn: str,
                 format: str,
                 output_schema_version: str,
                 encryption: Optional['outputs.StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryption'] = None,
                 prefix: Optional[str] = None):
        """
        :param str account_id: The AWS account ID for the S3 Storage Lens configuration. Defaults to automatically determined account ID of the AWS provider.
        :param str arn: The Amazon Resource Name (ARN) of the Amazon Web Services organization.
        :param str format: The export format. Valid values: `CSV`, `Parquet`.
        :param str output_schema_version: The schema version of the export file. Valid values: `V_1`.
        :param 'StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionArgs' encryption: Encryption of the metrics exports in this bucket. See Encryption below for more details.
        :param str prefix: The prefix of the destination bucket where the metrics export will be delivered.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "format", format)
        pulumi.set(__self__, "output_schema_version", output_schema_version)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> str:
        """
        The AWS account ID for the S3 Storage Lens configuration. Defaults to automatically determined account ID of the AWS provider.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of the Amazon Web Services organization.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def format(self) -> str:
        """
        The export format. Valid values: `CSV`, `Parquet`.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="outputSchemaVersion")
    def output_schema_version(self) -> str:
        """
        The schema version of the export file. Valid values: `V_1`.
        """
        return pulumi.get(self, "output_schema_version")

    @property
    @pulumi.getter
    def encryption(self) -> Optional['outputs.StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryption']:
        """
        Encryption of the metrics exports in this bucket. See Encryption below for more details.
        """
        return pulumi.get(self, "encryption")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        The prefix of the destination bucket where the metrics export will be delivered.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sseKms":
            suggest = "sse_kms"
        elif key == "sseS3s":
            suggest = "sse_s3s"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sse_kms: Optional['outputs.StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionSseKms'] = None,
                 sse_s3s: Optional[Sequence['outputs.StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionSseS3']] = None):
        """
        :param 'StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionSseKmsArgs' sse_kms: SSE-KMS encryption. See SSE KMS below for more details.
        :param Sequence['StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionSseS3Args'] sse_s3s: SSE-S3 encryption. An empty configuration block `{}` should be used.
        """
        if sse_kms is not None:
            pulumi.set(__self__, "sse_kms", sse_kms)
        if sse_s3s is not None:
            pulumi.set(__self__, "sse_s3s", sse_s3s)

    @property
    @pulumi.getter(name="sseKms")
    def sse_kms(self) -> Optional['outputs.StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionSseKms']:
        """
        SSE-KMS encryption. See SSE KMS below for more details.
        """
        return pulumi.get(self, "sse_kms")

    @property
    @pulumi.getter(name="sseS3s")
    def sse_s3s(self) -> Optional[Sequence['outputs.StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionSseS3']]:
        """
        SSE-S3 encryption. An empty configuration block `{}` should be used.
        """
        return pulumi.get(self, "sse_s3s")


@pulumi.output_type
class StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionSseKms(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyId":
            suggest = "key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionSseKms. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionSseKms.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionSseKms.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_id: str):
        """
        :param str key_id: KMS key ARN.
        """
        pulumi.set(__self__, "key_id", key_id)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> str:
        """
        KMS key ARN.
        """
        return pulumi.get(self, "key_id")


@pulumi.output_type
class StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionSseS3(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class StorageLensConfigurationStorageLensConfigurationExclude(dict):
    def __init__(__self__, *,
                 buckets: Optional[Sequence[str]] = None,
                 regions: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] buckets: List of S3 bucket ARNs.
        :param Sequence[str] regions: List of AWS Regions.
        """
        if buckets is not None:
            pulumi.set(__self__, "buckets", buckets)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)

    @property
    @pulumi.getter
    def buckets(self) -> Optional[Sequence[str]]:
        """
        List of S3 bucket ARNs.
        """
        return pulumi.get(self, "buckets")

    @property
    @pulumi.getter
    def regions(self) -> Optional[Sequence[str]]:
        """
        List of AWS Regions.
        """
        return pulumi.get(self, "regions")


@pulumi.output_type
class StorageLensConfigurationStorageLensConfigurationInclude(dict):
    def __init__(__self__, *,
                 buckets: Optional[Sequence[str]] = None,
                 regions: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] buckets: List of S3 bucket ARNs.
        :param Sequence[str] regions: List of AWS Regions.
        """
        if buckets is not None:
            pulumi.set(__self__, "buckets", buckets)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)

    @property
    @pulumi.getter
    def buckets(self) -> Optional[Sequence[str]]:
        """
        List of S3 bucket ARNs.
        """
        return pulumi.get(self, "buckets")

    @property
    @pulumi.getter
    def regions(self) -> Optional[Sequence[str]]:
        """
        List of AWS Regions.
        """
        return pulumi.get(self, "regions")


@pulumi.output_type
class GetMultiRegionAccessPointPublicAccessBlockResult(dict):
    def __init__(__self__, *,
                 block_public_acls: bool,
                 block_public_policy: bool,
                 ignore_public_acls: bool,
                 restrict_public_buckets: bool):
        """
        :param bool block_public_acls: Specifies whether Amazon S3 should block public access control lists (ACLs). When set to `true` causes the following behavior:
               * PUT Bucket acl and PUT Object acl calls fail if the specified ACL is public.
               * PUT Object calls fail if the request includes a public ACL.
               * PUT Bucket calls fail if the request includes a public ACL.
        :param bool block_public_policy: Specifies whether Amazon S3 should block public bucket policies for buckets in this account. When set to `true` causes Amazon S3 to:
               * Reject calls to PUT Bucket policy if the specified bucket policy allows public access.
        :param bool ignore_public_acls: Specifies whether Amazon S3 should ignore public ACLs for buckets in this account. When set to `true` causes Amazon S3 to:
               * Ignore all public ACLs on buckets in this account and any objects that they contain.
        :param bool restrict_public_buckets: Specifies whether Amazon S3 should restrict public bucket policies for buckets in this account. When set to `true`:
               * Only the bucket owner and AWS Services can access buckets with public policies.
        """
        pulumi.set(__self__, "block_public_acls", block_public_acls)
        pulumi.set(__self__, "block_public_policy", block_public_policy)
        pulumi.set(__self__, "ignore_public_acls", ignore_public_acls)
        pulumi.set(__self__, "restrict_public_buckets", restrict_public_buckets)

    @property
    @pulumi.getter(name="blockPublicAcls")
    def block_public_acls(self) -> bool:
        """
        Specifies whether Amazon S3 should block public access control lists (ACLs). When set to `true` causes the following behavior:
        * PUT Bucket acl and PUT Object acl calls fail if the specified ACL is public.
        * PUT Object calls fail if the request includes a public ACL.
        * PUT Bucket calls fail if the request includes a public ACL.
        """
        return pulumi.get(self, "block_public_acls")

    @property
    @pulumi.getter(name="blockPublicPolicy")
    def block_public_policy(self) -> bool:
        """
        Specifies whether Amazon S3 should block public bucket policies for buckets in this account. When set to `true` causes Amazon S3 to:
        * Reject calls to PUT Bucket policy if the specified bucket policy allows public access.
        """
        return pulumi.get(self, "block_public_policy")

    @property
    @pulumi.getter(name="ignorePublicAcls")
    def ignore_public_acls(self) -> bool:
        """
        Specifies whether Amazon S3 should ignore public ACLs for buckets in this account. When set to `true` causes Amazon S3 to:
        * Ignore all public ACLs on buckets in this account and any objects that they contain.
        """
        return pulumi.get(self, "ignore_public_acls")

    @property
    @pulumi.getter(name="restrictPublicBuckets")
    def restrict_public_buckets(self) -> bool:
        """
        Specifies whether Amazon S3 should restrict public bucket policies for buckets in this account. When set to `true`:
        * Only the bucket owner and AWS Services can access buckets with public policies.
        """
        return pulumi.get(self, "restrict_public_buckets")


@pulumi.output_type
class GetMultiRegionAccessPointRegionResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 region: str):
        """
        :param str bucket: The name of the bucket.
        :param str region: The name of the region.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The name of the region.
        """
        return pulumi.get(self, "region")


