# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetRandomPasswordResult',
    'AwaitableGetRandomPasswordResult',
    'get_random_password',
    'get_random_password_output',
]

@pulumi.output_type
class GetRandomPasswordResult:
    """
    A collection of values returned by getRandomPassword.
    """
    def __init__(__self__, exclude_characters=None, exclude_lowercase=None, exclude_numbers=None, exclude_punctuation=None, exclude_uppercase=None, id=None, include_space=None, password_length=None, random_password=None, require_each_included_type=None):
        if exclude_characters and not isinstance(exclude_characters, str):
            raise TypeError("Expected argument 'exclude_characters' to be a str")
        pulumi.set(__self__, "exclude_characters", exclude_characters)
        if exclude_lowercase and not isinstance(exclude_lowercase, bool):
            raise TypeError("Expected argument 'exclude_lowercase' to be a bool")
        pulumi.set(__self__, "exclude_lowercase", exclude_lowercase)
        if exclude_numbers and not isinstance(exclude_numbers, bool):
            raise TypeError("Expected argument 'exclude_numbers' to be a bool")
        pulumi.set(__self__, "exclude_numbers", exclude_numbers)
        if exclude_punctuation and not isinstance(exclude_punctuation, bool):
            raise TypeError("Expected argument 'exclude_punctuation' to be a bool")
        pulumi.set(__self__, "exclude_punctuation", exclude_punctuation)
        if exclude_uppercase and not isinstance(exclude_uppercase, bool):
            raise TypeError("Expected argument 'exclude_uppercase' to be a bool")
        pulumi.set(__self__, "exclude_uppercase", exclude_uppercase)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if include_space and not isinstance(include_space, bool):
            raise TypeError("Expected argument 'include_space' to be a bool")
        pulumi.set(__self__, "include_space", include_space)
        if password_length and not isinstance(password_length, int):
            raise TypeError("Expected argument 'password_length' to be a int")
        pulumi.set(__self__, "password_length", password_length)
        if random_password and not isinstance(random_password, str):
            raise TypeError("Expected argument 'random_password' to be a str")
        pulumi.set(__self__, "random_password", random_password)
        if require_each_included_type and not isinstance(require_each_included_type, bool):
            raise TypeError("Expected argument 'require_each_included_type' to be a bool")
        pulumi.set(__self__, "require_each_included_type", require_each_included_type)

    @property
    @pulumi.getter(name="excludeCharacters")
    def exclude_characters(self) -> Optional[str]:
        return pulumi.get(self, "exclude_characters")

    @property
    @pulumi.getter(name="excludeLowercase")
    def exclude_lowercase(self) -> Optional[bool]:
        return pulumi.get(self, "exclude_lowercase")

    @property
    @pulumi.getter(name="excludeNumbers")
    def exclude_numbers(self) -> Optional[bool]:
        return pulumi.get(self, "exclude_numbers")

    @property
    @pulumi.getter(name="excludePunctuation")
    def exclude_punctuation(self) -> Optional[bool]:
        return pulumi.get(self, "exclude_punctuation")

    @property
    @pulumi.getter(name="excludeUppercase")
    def exclude_uppercase(self) -> Optional[bool]:
        return pulumi.get(self, "exclude_uppercase")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="includeSpace")
    def include_space(self) -> Optional[bool]:
        return pulumi.get(self, "include_space")

    @property
    @pulumi.getter(name="passwordLength")
    def password_length(self) -> Optional[int]:
        return pulumi.get(self, "password_length")

    @property
    @pulumi.getter(name="randomPassword")
    def random_password(self) -> str:
        """
        Random password.
        """
        return pulumi.get(self, "random_password")

    @property
    @pulumi.getter(name="requireEachIncludedType")
    def require_each_included_type(self) -> Optional[bool]:
        return pulumi.get(self, "require_each_included_type")


class AwaitableGetRandomPasswordResult(GetRandomPasswordResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRandomPasswordResult(
            exclude_characters=self.exclude_characters,
            exclude_lowercase=self.exclude_lowercase,
            exclude_numbers=self.exclude_numbers,
            exclude_punctuation=self.exclude_punctuation,
            exclude_uppercase=self.exclude_uppercase,
            id=self.id,
            include_space=self.include_space,
            password_length=self.password_length,
            random_password=self.random_password,
            require_each_included_type=self.require_each_included_type)


def get_random_password(exclude_characters: Optional[str] = None,
                        exclude_lowercase: Optional[bool] = None,
                        exclude_numbers: Optional[bool] = None,
                        exclude_punctuation: Optional[bool] = None,
                        exclude_uppercase: Optional[bool] = None,
                        include_space: Optional[bool] = None,
                        password_length: Optional[int] = None,
                        random_password: Optional[str] = None,
                        require_each_included_type: Optional[bool] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRandomPasswordResult:
    """
    Generate a random password.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.secretsmanager.get_random_password(exclude_numbers=True,
        password_length=50)
    ```


    :param str exclude_characters: String of the characters that you don't want in the password.
    :param bool exclude_lowercase: Specifies whether to exclude lowercase letters from the password.
    :param bool exclude_numbers: Specifies whether to exclude numbers from the password.
    :param bool exclude_punctuation: Specifies whether to exclude the following punctuation characters from the password: ``! " # $ % & ' ( ) * + , - . / : ; < = > ? @ [ \\ ] ^ _ ` { | } ~ .``
    :param bool exclude_uppercase: Specifies whether to exclude uppercase letters from the password.
    :param bool include_space: Specifies whether to include the space character.
    :param int password_length: Length of the password.
    :param str random_password: Random password.
    :param bool require_each_included_type: Specifies whether to include at least one upper and lowercase letter, one number, and one punctuation.
    """
    __args__ = dict()
    __args__['excludeCharacters'] = exclude_characters
    __args__['excludeLowercase'] = exclude_lowercase
    __args__['excludeNumbers'] = exclude_numbers
    __args__['excludePunctuation'] = exclude_punctuation
    __args__['excludeUppercase'] = exclude_uppercase
    __args__['includeSpace'] = include_space
    __args__['passwordLength'] = password_length
    __args__['randomPassword'] = random_password
    __args__['requireEachIncludedType'] = require_each_included_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:secretsmanager/getRandomPassword:getRandomPassword', __args__, opts=opts, typ=GetRandomPasswordResult).value

    return AwaitableGetRandomPasswordResult(
        exclude_characters=pulumi.get(__ret__, 'exclude_characters'),
        exclude_lowercase=pulumi.get(__ret__, 'exclude_lowercase'),
        exclude_numbers=pulumi.get(__ret__, 'exclude_numbers'),
        exclude_punctuation=pulumi.get(__ret__, 'exclude_punctuation'),
        exclude_uppercase=pulumi.get(__ret__, 'exclude_uppercase'),
        id=pulumi.get(__ret__, 'id'),
        include_space=pulumi.get(__ret__, 'include_space'),
        password_length=pulumi.get(__ret__, 'password_length'),
        random_password=pulumi.get(__ret__, 'random_password'),
        require_each_included_type=pulumi.get(__ret__, 'require_each_included_type'))


@_utilities.lift_output_func(get_random_password)
def get_random_password_output(exclude_characters: Optional[pulumi.Input[Optional[str]]] = None,
                               exclude_lowercase: Optional[pulumi.Input[Optional[bool]]] = None,
                               exclude_numbers: Optional[pulumi.Input[Optional[bool]]] = None,
                               exclude_punctuation: Optional[pulumi.Input[Optional[bool]]] = None,
                               exclude_uppercase: Optional[pulumi.Input[Optional[bool]]] = None,
                               include_space: Optional[pulumi.Input[Optional[bool]]] = None,
                               password_length: Optional[pulumi.Input[Optional[int]]] = None,
                               random_password: Optional[pulumi.Input[Optional[str]]] = None,
                               require_each_included_type: Optional[pulumi.Input[Optional[bool]]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRandomPasswordResult]:
    """
    Generate a random password.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.secretsmanager.get_random_password(exclude_numbers=True,
        password_length=50)
    ```


    :param str exclude_characters: String of the characters that you don't want in the password.
    :param bool exclude_lowercase: Specifies whether to exclude lowercase letters from the password.
    :param bool exclude_numbers: Specifies whether to exclude numbers from the password.
    :param bool exclude_punctuation: Specifies whether to exclude the following punctuation characters from the password: ``! " # $ % & ' ( ) * + , - . / : ; < = > ? @ [ \\ ] ^ _ ` { | } ~ .``
    :param bool exclude_uppercase: Specifies whether to exclude uppercase letters from the password.
    :param bool include_space: Specifies whether to include the space character.
    :param int password_length: Length of the password.
    :param str random_password: Random password.
    :param bool require_each_included_type: Specifies whether to include at least one upper and lowercase letter, one number, and one punctuation.
    """
    ...
