# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['FindingAggregatorArgs', 'FindingAggregator']

@pulumi.input_type
class FindingAggregatorArgs:
    def __init__(__self__, *,
                 linking_mode: pulumi.Input[str],
                 specified_regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a FindingAggregator resource.
        :param pulumi.Input[str] linking_mode: Indicates whether to aggregate findings from all of the available Regions or from a specified list. The options are `ALL_REGIONS`, `ALL_REGIONS_EXCEPT_SPECIFIED` or `SPECIFIED_REGIONS`. When `ALL_REGIONS` or `ALL_REGIONS_EXCEPT_SPECIFIED` are used, Security Hub will automatically aggregate findings from new Regions as Security Hub supports them and you opt into them.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] specified_regions: List of regions to include or exclude (required if `linking_mode` is set to `ALL_REGIONS_EXCEPT_SPECIFIED` or `SPECIFIED_REGIONS`)
        """
        pulumi.set(__self__, "linking_mode", linking_mode)
        if specified_regions is not None:
            pulumi.set(__self__, "specified_regions", specified_regions)

    @property
    @pulumi.getter(name="linkingMode")
    def linking_mode(self) -> pulumi.Input[str]:
        """
        Indicates whether to aggregate findings from all of the available Regions or from a specified list. The options are `ALL_REGIONS`, `ALL_REGIONS_EXCEPT_SPECIFIED` or `SPECIFIED_REGIONS`. When `ALL_REGIONS` or `ALL_REGIONS_EXCEPT_SPECIFIED` are used, Security Hub will automatically aggregate findings from new Regions as Security Hub supports them and you opt into them.
        """
        return pulumi.get(self, "linking_mode")

    @linking_mode.setter
    def linking_mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "linking_mode", value)

    @property
    @pulumi.getter(name="specifiedRegions")
    def specified_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of regions to include or exclude (required if `linking_mode` is set to `ALL_REGIONS_EXCEPT_SPECIFIED` or `SPECIFIED_REGIONS`)
        """
        return pulumi.get(self, "specified_regions")

    @specified_regions.setter
    def specified_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "specified_regions", value)


@pulumi.input_type
class _FindingAggregatorState:
    def __init__(__self__, *,
                 linking_mode: Optional[pulumi.Input[str]] = None,
                 specified_regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering FindingAggregator resources.
        :param pulumi.Input[str] linking_mode: Indicates whether to aggregate findings from all of the available Regions or from a specified list. The options are `ALL_REGIONS`, `ALL_REGIONS_EXCEPT_SPECIFIED` or `SPECIFIED_REGIONS`. When `ALL_REGIONS` or `ALL_REGIONS_EXCEPT_SPECIFIED` are used, Security Hub will automatically aggregate findings from new Regions as Security Hub supports them and you opt into them.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] specified_regions: List of regions to include or exclude (required if `linking_mode` is set to `ALL_REGIONS_EXCEPT_SPECIFIED` or `SPECIFIED_REGIONS`)
        """
        if linking_mode is not None:
            pulumi.set(__self__, "linking_mode", linking_mode)
        if specified_regions is not None:
            pulumi.set(__self__, "specified_regions", specified_regions)

    @property
    @pulumi.getter(name="linkingMode")
    def linking_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates whether to aggregate findings from all of the available Regions or from a specified list. The options are `ALL_REGIONS`, `ALL_REGIONS_EXCEPT_SPECIFIED` or `SPECIFIED_REGIONS`. When `ALL_REGIONS` or `ALL_REGIONS_EXCEPT_SPECIFIED` are used, Security Hub will automatically aggregate findings from new Regions as Security Hub supports them and you opt into them.
        """
        return pulumi.get(self, "linking_mode")

    @linking_mode.setter
    def linking_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "linking_mode", value)

    @property
    @pulumi.getter(name="specifiedRegions")
    def specified_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of regions to include or exclude (required if `linking_mode` is set to `ALL_REGIONS_EXCEPT_SPECIFIED` or `SPECIFIED_REGIONS`)
        """
        return pulumi.get(self, "specified_regions")

    @specified_regions.setter
    def specified_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "specified_regions", value)


class FindingAggregator(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 linking_mode: Optional[pulumi.Input[str]] = None,
                 specified_regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Manages a Security Hub finding aggregator. Security Hub needs to be enabled in a region in order for the aggregator to pull through findings.

        ## Example Usage
        ### All Regions Usage

        The following example will enable the aggregator for every region.

        ```python
        import pulumi
        import pulumi_aws as aws

        example_account = aws.securityhub.Account("exampleAccount")
        example_finding_aggregator = aws.securityhub.FindingAggregator("exampleFindingAggregator", linking_mode="ALL_REGIONS",
        opts=pulumi.ResourceOptions(depends_on=[example_account]))
        ```
        ### All Regions Except Specified Regions Usage

        The following example will enable the aggregator for every region except those specified in `specified_regions`.

        ```python
        import pulumi
        import pulumi_aws as aws

        example_account = aws.securityhub.Account("exampleAccount")
        example_finding_aggregator = aws.securityhub.FindingAggregator("exampleFindingAggregator",
            linking_mode="ALL_REGIONS_EXCEPT_SPECIFIED",
            specified_regions=[
                "eu-west-1",
                "eu-west-2",
            ],
            opts=pulumi.ResourceOptions(depends_on=[example_account]))
        ```
        ### Specified Regions Usage

        The following example will enable the aggregator for every region specified in `specified_regions`.

        ```python
        import pulumi
        import pulumi_aws as aws

        example_account = aws.securityhub.Account("exampleAccount")
        example_finding_aggregator = aws.securityhub.FindingAggregator("exampleFindingAggregator",
            linking_mode="SPECIFIED_REGIONS",
            specified_regions=[
                "eu-west-1",
                "eu-west-2",
            ],
            opts=pulumi.ResourceOptions(depends_on=[example_account]))
        ```

        ## Import

        Using `pulumi import`, import an existing Security Hub finding aggregator using the `arn`. For example:

        ```sh
         $ pulumi import aws:securityhub/findingAggregator:FindingAggregator example arn:aws:securityhub:eu-west-1:123456789098:finding-aggregator/abcd1234-abcd-1234-1234-abcdef123456
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] linking_mode: Indicates whether to aggregate findings from all of the available Regions or from a specified list. The options are `ALL_REGIONS`, `ALL_REGIONS_EXCEPT_SPECIFIED` or `SPECIFIED_REGIONS`. When `ALL_REGIONS` or `ALL_REGIONS_EXCEPT_SPECIFIED` are used, Security Hub will automatically aggregate findings from new Regions as Security Hub supports them and you opt into them.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] specified_regions: List of regions to include or exclude (required if `linking_mode` is set to `ALL_REGIONS_EXCEPT_SPECIFIED` or `SPECIFIED_REGIONS`)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FindingAggregatorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Security Hub finding aggregator. Security Hub needs to be enabled in a region in order for the aggregator to pull through findings.

        ## Example Usage
        ### All Regions Usage

        The following example will enable the aggregator for every region.

        ```python
        import pulumi
        import pulumi_aws as aws

        example_account = aws.securityhub.Account("exampleAccount")
        example_finding_aggregator = aws.securityhub.FindingAggregator("exampleFindingAggregator", linking_mode="ALL_REGIONS",
        opts=pulumi.ResourceOptions(depends_on=[example_account]))
        ```
        ### All Regions Except Specified Regions Usage

        The following example will enable the aggregator for every region except those specified in `specified_regions`.

        ```python
        import pulumi
        import pulumi_aws as aws

        example_account = aws.securityhub.Account("exampleAccount")
        example_finding_aggregator = aws.securityhub.FindingAggregator("exampleFindingAggregator",
            linking_mode="ALL_REGIONS_EXCEPT_SPECIFIED",
            specified_regions=[
                "eu-west-1",
                "eu-west-2",
            ],
            opts=pulumi.ResourceOptions(depends_on=[example_account]))
        ```
        ### Specified Regions Usage

        The following example will enable the aggregator for every region specified in `specified_regions`.

        ```python
        import pulumi
        import pulumi_aws as aws

        example_account = aws.securityhub.Account("exampleAccount")
        example_finding_aggregator = aws.securityhub.FindingAggregator("exampleFindingAggregator",
            linking_mode="SPECIFIED_REGIONS",
            specified_regions=[
                "eu-west-1",
                "eu-west-2",
            ],
            opts=pulumi.ResourceOptions(depends_on=[example_account]))
        ```

        ## Import

        Using `pulumi import`, import an existing Security Hub finding aggregator using the `arn`. For example:

        ```sh
         $ pulumi import aws:securityhub/findingAggregator:FindingAggregator example arn:aws:securityhub:eu-west-1:123456789098:finding-aggregator/abcd1234-abcd-1234-1234-abcdef123456
        ```

        :param str resource_name: The name of the resource.
        :param FindingAggregatorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FindingAggregatorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 linking_mode: Optional[pulumi.Input[str]] = None,
                 specified_regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FindingAggregatorArgs.__new__(FindingAggregatorArgs)

            if linking_mode is None and not opts.urn:
                raise TypeError("Missing required property 'linking_mode'")
            __props__.__dict__["linking_mode"] = linking_mode
            __props__.__dict__["specified_regions"] = specified_regions
        super(FindingAggregator, __self__).__init__(
            'aws:securityhub/findingAggregator:FindingAggregator',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            linking_mode: Optional[pulumi.Input[str]] = None,
            specified_regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'FindingAggregator':
        """
        Get an existing FindingAggregator resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] linking_mode: Indicates whether to aggregate findings from all of the available Regions or from a specified list. The options are `ALL_REGIONS`, `ALL_REGIONS_EXCEPT_SPECIFIED` or `SPECIFIED_REGIONS`. When `ALL_REGIONS` or `ALL_REGIONS_EXCEPT_SPECIFIED` are used, Security Hub will automatically aggregate findings from new Regions as Security Hub supports them and you opt into them.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] specified_regions: List of regions to include or exclude (required if `linking_mode` is set to `ALL_REGIONS_EXCEPT_SPECIFIED` or `SPECIFIED_REGIONS`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FindingAggregatorState.__new__(_FindingAggregatorState)

        __props__.__dict__["linking_mode"] = linking_mode
        __props__.__dict__["specified_regions"] = specified_regions
        return FindingAggregator(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="linkingMode")
    def linking_mode(self) -> pulumi.Output[str]:
        """
        Indicates whether to aggregate findings from all of the available Regions or from a specified list. The options are `ALL_REGIONS`, `ALL_REGIONS_EXCEPT_SPECIFIED` or `SPECIFIED_REGIONS`. When `ALL_REGIONS` or `ALL_REGIONS_EXCEPT_SPECIFIED` are used, Security Hub will automatically aggregate findings from new Regions as Security Hub supports them and you opt into them.
        """
        return pulumi.get(self, "linking_mode")

    @property
    @pulumi.getter(name="specifiedRegions")
    def specified_regions(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of regions to include or exclude (required if `linking_mode` is set to `ALL_REGIONS_EXCEPT_SPECIFIED` or `SPECIFIED_REGIONS`)
        """
        return pulumi.get(self, "specified_regions")

