# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['MemberArgs', 'Member']

@pulumi.input_type
class MemberArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[str],
                 email: Optional[pulumi.Input[str]] = None,
                 invite: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a Member resource.
        :param pulumi.Input[str] account_id: The ID of the member AWS account.
        :param pulumi.Input[str] email: The email of the member AWS account.
        :param pulumi.Input[bool] invite: Boolean whether to invite the account to Security Hub as a member. Defaults to `false`.
        """
        pulumi.set(__self__, "account_id", account_id)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if invite is not None:
            pulumi.set(__self__, "invite", invite)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[str]:
        """
        The ID of the member AWS account.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        The email of the member AWS account.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def invite(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean whether to invite the account to Security Hub as a member. Defaults to `false`.
        """
        return pulumi.get(self, "invite")

    @invite.setter
    def invite(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "invite", value)


@pulumi.input_type
class _MemberState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 invite: Optional[pulumi.Input[bool]] = None,
                 master_id: Optional[pulumi.Input[str]] = None,
                 member_status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Member resources.
        :param pulumi.Input[str] account_id: The ID of the member AWS account.
        :param pulumi.Input[str] email: The email of the member AWS account.
        :param pulumi.Input[bool] invite: Boolean whether to invite the account to Security Hub as a member. Defaults to `false`.
        :param pulumi.Input[str] master_id: The ID of the master Security Hub AWS account.
        :param pulumi.Input[str] member_status: The status of the member account relationship.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if invite is not None:
            pulumi.set(__self__, "invite", invite)
        if master_id is not None:
            pulumi.set(__self__, "master_id", master_id)
        if member_status is not None:
            pulumi.set(__self__, "member_status", member_status)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the member AWS account.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        The email of the member AWS account.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def invite(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean whether to invite the account to Security Hub as a member. Defaults to `false`.
        """
        return pulumi.get(self, "invite")

    @invite.setter
    def invite(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "invite", value)

    @property
    @pulumi.getter(name="masterId")
    def master_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the master Security Hub AWS account.
        """
        return pulumi.get(self, "master_id")

    @master_id.setter
    def master_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_id", value)

    @property
    @pulumi.getter(name="memberStatus")
    def member_status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the member account relationship.
        """
        return pulumi.get(self, "member_status")

    @member_status.setter
    def member_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "member_status", value)


class Member(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 invite: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Provides a Security Hub member resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example_account = aws.securityhub.Account("exampleAccount")
        example_member = aws.securityhub.Member("exampleMember",
            account_id="123456789012",
            email="example@example.com",
            invite=True,
            opts=pulumi.ResourceOptions(depends_on=[example_account]))
        ```

        ## Import

        Using `pulumi import`, import Security Hub members using their account ID. For example:

        ```sh
         $ pulumi import aws:securityhub/member:Member example 123456789012
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The ID of the member AWS account.
        :param pulumi.Input[str] email: The email of the member AWS account.
        :param pulumi.Input[bool] invite: Boolean whether to invite the account to Security Hub as a member. Defaults to `false`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MemberArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Security Hub member resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example_account = aws.securityhub.Account("exampleAccount")
        example_member = aws.securityhub.Member("exampleMember",
            account_id="123456789012",
            email="example@example.com",
            invite=True,
            opts=pulumi.ResourceOptions(depends_on=[example_account]))
        ```

        ## Import

        Using `pulumi import`, import Security Hub members using their account ID. For example:

        ```sh
         $ pulumi import aws:securityhub/member:Member example 123456789012
        ```

        :param str resource_name: The name of the resource.
        :param MemberArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MemberArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 invite: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MemberArgs.__new__(MemberArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["email"] = email
            __props__.__dict__["invite"] = invite
            __props__.__dict__["master_id"] = None
            __props__.__dict__["member_status"] = None
        super(Member, __self__).__init__(
            'aws:securityhub/member:Member',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            email: Optional[pulumi.Input[str]] = None,
            invite: Optional[pulumi.Input[bool]] = None,
            master_id: Optional[pulumi.Input[str]] = None,
            member_status: Optional[pulumi.Input[str]] = None) -> 'Member':
        """
        Get an existing Member resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The ID of the member AWS account.
        :param pulumi.Input[str] email: The email of the member AWS account.
        :param pulumi.Input[bool] invite: Boolean whether to invite the account to Security Hub as a member. Defaults to `false`.
        :param pulumi.Input[str] master_id: The ID of the master Security Hub AWS account.
        :param pulumi.Input[str] member_status: The status of the member account relationship.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MemberState.__new__(_MemberState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["email"] = email
        __props__.__dict__["invite"] = invite
        __props__.__dict__["master_id"] = master_id
        __props__.__dict__["member_status"] = member_status
        return Member(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        """
        The ID of the member AWS account.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[Optional[str]]:
        """
        The email of the member AWS account.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def invite(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean whether to invite the account to Security Hub as a member. Defaults to `false`.
        """
        return pulumi.get(self, "invite")

    @property
    @pulumi.getter(name="masterId")
    def master_id(self) -> pulumi.Output[str]:
        """
        The ID of the master Security Hub AWS account.
        """
        return pulumi.get(self, "master_id")

    @property
    @pulumi.getter(name="memberStatus")
    def member_status(self) -> pulumi.Output[str]:
        """
        The status of the member account relationship.
        """
        return pulumi.get(self, "member_status")

