# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['DomainIdentityArgs', 'DomainIdentity']

@pulumi.input_type
class DomainIdentityArgs:
    def __init__(__self__, *,
                 domain: pulumi.Input[str]):
        """
        The set of arguments for constructing a DomainIdentity resource.
        :param pulumi.Input[str] domain: The domain name to assign to SES
        """
        pulumi.set(__self__, "domain", domain)

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Input[str]:
        """
        The domain name to assign to SES
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain", value)


@pulumi.input_type
class _DomainIdentityState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 verification_token: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DomainIdentity resources.
        :param pulumi.Input[str] arn: The ARN of the domain identity.
        :param pulumi.Input[str] domain: The domain name to assign to SES
        :param pulumi.Input[str] verification_token: A code which when added to the domain as a TXT record
               will signal to SES that the owner of the domain has authorised SES to act on
               their behalf. The domain identity will be in state "verification pending"
               until this is done. See the With Route53 Record example
               for how this might be achieved when the domain is hosted in Route 53 and
               managed by this provider.  Find out more about verifying domains in Amazon
               SES in the [AWS SES
               docs](http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-domains.html).
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if verification_token is not None:
            pulumi.set(__self__, "verification_token", verification_token)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the domain identity.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        The domain name to assign to SES
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="verificationToken")
    def verification_token(self) -> Optional[pulumi.Input[str]]:
        """
        A code which when added to the domain as a TXT record
        will signal to SES that the owner of the domain has authorised SES to act on
        their behalf. The domain identity will be in state "verification pending"
        until this is done. See the With Route53 Record example
        for how this might be achieved when the domain is hosted in Route 53 and
        managed by this provider.  Find out more about verifying domains in Amazon
        SES in the [AWS SES
        docs](http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-domains.html).
        """
        return pulumi.get(self, "verification_token")

    @verification_token.setter
    def verification_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "verification_token", value)


class DomainIdentity(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides an SES domain identity resource

        ## Example Usage
        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ses.DomainIdentity("example", domain="example.com")
        ```
        ### With Route53 Record

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ses.DomainIdentity("example", domain="example.com")
        example_amazonses_verification_record = aws.route53.Record("exampleAmazonsesVerificationRecord",
            zone_id="ABCDEFGHIJ123",
            name="_amazonses.example.com",
            type="TXT",
            ttl=600,
            records=[example.verification_token])
        ```

        ## Import

        Using `pulumi import`, import SES domain identities using the domain name. For example:

        ```sh
         $ pulumi import aws:ses/domainIdentity:DomainIdentity example example.com
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] domain: The domain name to assign to SES
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainIdentityArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an SES domain identity resource

        ## Example Usage
        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ses.DomainIdentity("example", domain="example.com")
        ```
        ### With Route53 Record

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ses.DomainIdentity("example", domain="example.com")
        example_amazonses_verification_record = aws.route53.Record("exampleAmazonsesVerificationRecord",
            zone_id="ABCDEFGHIJ123",
            name="_amazonses.example.com",
            type="TXT",
            ttl=600,
            records=[example.verification_token])
        ```

        ## Import

        Using `pulumi import`, import SES domain identities using the domain name. For example:

        ```sh
         $ pulumi import aws:ses/domainIdentity:DomainIdentity example example.com
        ```

        :param str resource_name: The name of the resource.
        :param DomainIdentityArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainIdentityArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainIdentityArgs.__new__(DomainIdentityArgs)

            if domain is None and not opts.urn:
                raise TypeError("Missing required property 'domain'")
            __props__.__dict__["domain"] = domain
            __props__.__dict__["arn"] = None
            __props__.__dict__["verification_token"] = None
        super(DomainIdentity, __self__).__init__(
            'aws:ses/domainIdentity:DomainIdentity',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            domain: Optional[pulumi.Input[str]] = None,
            verification_token: Optional[pulumi.Input[str]] = None) -> 'DomainIdentity':
        """
        Get an existing DomainIdentity resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The ARN of the domain identity.
        :param pulumi.Input[str] domain: The domain name to assign to SES
        :param pulumi.Input[str] verification_token: A code which when added to the domain as a TXT record
               will signal to SES that the owner of the domain has authorised SES to act on
               their behalf. The domain identity will be in state "verification pending"
               until this is done. See the With Route53 Record example
               for how this might be achieved when the domain is hosted in Route 53 and
               managed by this provider.  Find out more about verifying domains in Amazon
               SES in the [AWS SES
               docs](http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-domains.html).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainIdentityState.__new__(_DomainIdentityState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["domain"] = domain
        __props__.__dict__["verification_token"] = verification_token
        return DomainIdentity(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the domain identity.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output[str]:
        """
        The domain name to assign to SES
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="verificationToken")
    def verification_token(self) -> pulumi.Output[str]:
        """
        A code which when added to the domain as a TXT record
        will signal to SES that the owner of the domain has authorised SES to act on
        their behalf. The domain identity will be in state "verification pending"
        until this is done. See the With Route53 Record example
        for how this might be achieved when the domain is hosted in Route 53 and
        managed by this provider.  Find out more about verifying domains in Amazon
        SES in the [AWS SES
        docs](http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-domains.html).
        """
        return pulumi.get(self, "verification_token")

