# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AssociationOutputLocation',
    'AssociationTarget',
    'DocumentAttachmentsSource',
    'DocumentParameter',
    'MaintenanceWindowTargetTarget',
    'MaintenanceWindowTaskTarget',
    'MaintenanceWindowTaskTaskInvocationParameters',
    'MaintenanceWindowTaskTaskInvocationParametersAutomationParameters',
    'MaintenanceWindowTaskTaskInvocationParametersAutomationParametersParameter',
    'MaintenanceWindowTaskTaskInvocationParametersLambdaParameters',
    'MaintenanceWindowTaskTaskInvocationParametersRunCommandParameters',
    'MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersCloudwatchConfig',
    'MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfig',
    'MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameter',
    'MaintenanceWindowTaskTaskInvocationParametersStepFunctionsParameters',
    'PatchBaselineApprovalRule',
    'PatchBaselineApprovalRulePatchFilter',
    'PatchBaselineGlobalFilter',
    'PatchBaselineSource',
    'ResourceDataSyncS3Destination',
    'GetInstancesFilterResult',
    'GetMaintenanceWindowsFilterResult',
    'GetPatchBaselineApprovalRuleResult',
    'GetPatchBaselineApprovalRulePatchFilterResult',
    'GetPatchBaselineGlobalFilterResult',
    'GetPatchBaselineSourceResult',
]

@pulumi.output_type
class AssociationOutputLocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3BucketName":
            suggest = "s3_bucket_name"
        elif key == "s3KeyPrefix":
            suggest = "s3_key_prefix"
        elif key == "s3Region":
            suggest = "s3_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssociationOutputLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssociationOutputLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssociationOutputLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_bucket_name: str,
                 s3_key_prefix: Optional[str] = None,
                 s3_region: Optional[str] = None):
        """
        :param str s3_bucket_name: The S3 bucket name.
        :param str s3_key_prefix: The S3 bucket prefix. Results stored in the root if not configured.
        :param str s3_region: The S3 bucket region.
               
               Targets specify what instance IDs or tags to apply the document to and has these keys:
        """
        pulumi.set(__self__, "s3_bucket_name", s3_bucket_name)
        if s3_key_prefix is not None:
            pulumi.set(__self__, "s3_key_prefix", s3_key_prefix)
        if s3_region is not None:
            pulumi.set(__self__, "s3_region", s3_region)

    @property
    @pulumi.getter(name="s3BucketName")
    def s3_bucket_name(self) -> str:
        """
        The S3 bucket name.
        """
        return pulumi.get(self, "s3_bucket_name")

    @property
    @pulumi.getter(name="s3KeyPrefix")
    def s3_key_prefix(self) -> Optional[str]:
        """
        The S3 bucket prefix. Results stored in the root if not configured.
        """
        return pulumi.get(self, "s3_key_prefix")

    @property
    @pulumi.getter(name="s3Region")
    def s3_region(self) -> Optional[str]:
        """
        The S3 bucket region.

        Targets specify what instance IDs or tags to apply the document to and has these keys:
        """
        return pulumi.get(self, "s3_region")


@pulumi.output_type
class AssociationTarget(dict):
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str]):
        """
        :param str key: Either `InstanceIds` or `tag:Tag Name` to specify an EC2 tag.
        :param Sequence[str] values: A list of instance IDs or tag values. AWS currently limits this list size to one value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Either `InstanceIds` or `tag:Tag Name` to specify an EC2 tag.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        A list of instance IDs or tag values. AWS currently limits this list size to one value.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class DocumentAttachmentsSource(dict):
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str],
                 name: Optional[str] = None):
        """
        :param str key: The key describing the location of an attachment to a document. Valid key types include: `SourceUrl` and `S3FileUrl`
        :param Sequence[str] values: The value describing the location of an attachment to a document
        :param str name: The name of the document attachment file
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key describing the location of an attachment to a document. Valid key types include: `SourceUrl` and `S3FileUrl`
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The value describing the location of an attachment to a document
        """
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the document attachment file
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class DocumentParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultValue":
            suggest = "default_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DocumentParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DocumentParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DocumentParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_value: Optional[str] = None,
                 description: Optional[str] = None,
                 name: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str description: The description of the document.
        :param str name: The name of the document.
        """
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[str]:
        return pulumi.get(self, "default_value")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the document.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the document.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        return pulumi.get(self, "type")


@pulumi.output_type
class MaintenanceWindowTargetTarget(dict):
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str]):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")


@pulumi.output_type
class MaintenanceWindowTaskTarget(dict):
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str]):
        """
        :param Sequence[str] values: The array of strings.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The array of strings.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class MaintenanceWindowTaskTaskInvocationParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "automationParameters":
            suggest = "automation_parameters"
        elif key == "lambdaParameters":
            suggest = "lambda_parameters"
        elif key == "runCommandParameters":
            suggest = "run_command_parameters"
        elif key == "stepFunctionsParameters":
            suggest = "step_functions_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MaintenanceWindowTaskTaskInvocationParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MaintenanceWindowTaskTaskInvocationParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MaintenanceWindowTaskTaskInvocationParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 automation_parameters: Optional['outputs.MaintenanceWindowTaskTaskInvocationParametersAutomationParameters'] = None,
                 lambda_parameters: Optional['outputs.MaintenanceWindowTaskTaskInvocationParametersLambdaParameters'] = None,
                 run_command_parameters: Optional['outputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParameters'] = None,
                 step_functions_parameters: Optional['outputs.MaintenanceWindowTaskTaskInvocationParametersStepFunctionsParameters'] = None):
        """
        :param 'MaintenanceWindowTaskTaskInvocationParametersAutomationParametersArgs' automation_parameters: The parameters for an AUTOMATION task type. Documented below.
        :param 'MaintenanceWindowTaskTaskInvocationParametersLambdaParametersArgs' lambda_parameters: The parameters for a LAMBDA task type. Documented below.
        :param 'MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersArgs' run_command_parameters: The parameters for a RUN_COMMAND task type. Documented below.
        :param 'MaintenanceWindowTaskTaskInvocationParametersStepFunctionsParametersArgs' step_functions_parameters: The parameters for a STEP_FUNCTIONS task type. Documented below.
        """
        if automation_parameters is not None:
            pulumi.set(__self__, "automation_parameters", automation_parameters)
        if lambda_parameters is not None:
            pulumi.set(__self__, "lambda_parameters", lambda_parameters)
        if run_command_parameters is not None:
            pulumi.set(__self__, "run_command_parameters", run_command_parameters)
        if step_functions_parameters is not None:
            pulumi.set(__self__, "step_functions_parameters", step_functions_parameters)

    @property
    @pulumi.getter(name="automationParameters")
    def automation_parameters(self) -> Optional['outputs.MaintenanceWindowTaskTaskInvocationParametersAutomationParameters']:
        """
        The parameters for an AUTOMATION task type. Documented below.
        """
        return pulumi.get(self, "automation_parameters")

    @property
    @pulumi.getter(name="lambdaParameters")
    def lambda_parameters(self) -> Optional['outputs.MaintenanceWindowTaskTaskInvocationParametersLambdaParameters']:
        """
        The parameters for a LAMBDA task type. Documented below.
        """
        return pulumi.get(self, "lambda_parameters")

    @property
    @pulumi.getter(name="runCommandParameters")
    def run_command_parameters(self) -> Optional['outputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParameters']:
        """
        The parameters for a RUN_COMMAND task type. Documented below.
        """
        return pulumi.get(self, "run_command_parameters")

    @property
    @pulumi.getter(name="stepFunctionsParameters")
    def step_functions_parameters(self) -> Optional['outputs.MaintenanceWindowTaskTaskInvocationParametersStepFunctionsParameters']:
        """
        The parameters for a STEP_FUNCTIONS task type. Documented below.
        """
        return pulumi.get(self, "step_functions_parameters")


@pulumi.output_type
class MaintenanceWindowTaskTaskInvocationParametersAutomationParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "documentVersion":
            suggest = "document_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MaintenanceWindowTaskTaskInvocationParametersAutomationParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MaintenanceWindowTaskTaskInvocationParametersAutomationParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MaintenanceWindowTaskTaskInvocationParametersAutomationParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 document_version: Optional[str] = None,
                 parameters: Optional[Sequence['outputs.MaintenanceWindowTaskTaskInvocationParametersAutomationParametersParameter']] = None):
        """
        :param str document_version: The version of an Automation document to use during task execution.
        :param Sequence['MaintenanceWindowTaskTaskInvocationParametersAutomationParametersParameterArgs'] parameters: The parameters for the RUN_COMMAND task execution. Documented below.
        """
        if document_version is not None:
            pulumi.set(__self__, "document_version", document_version)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="documentVersion")
    def document_version(self) -> Optional[str]:
        """
        The version of an Automation document to use during task execution.
        """
        return pulumi.get(self, "document_version")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Sequence['outputs.MaintenanceWindowTaskTaskInvocationParametersAutomationParametersParameter']]:
        """
        The parameters for the RUN_COMMAND task execution. Documented below.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class MaintenanceWindowTaskTaskInvocationParametersAutomationParametersParameter(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The parameter name.
        :param Sequence[str] values: The array of strings.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The parameter name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The array of strings.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class MaintenanceWindowTaskTaskInvocationParametersLambdaParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientContext":
            suggest = "client_context"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MaintenanceWindowTaskTaskInvocationParametersLambdaParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MaintenanceWindowTaskTaskInvocationParametersLambdaParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MaintenanceWindowTaskTaskInvocationParametersLambdaParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_context: Optional[str] = None,
                 payload: Optional[str] = None,
                 qualifier: Optional[str] = None):
        """
        :param str client_context: Pass client-specific information to the Lambda function that you are invoking.
        :param str payload: JSON to provide to your Lambda function as input.
        :param str qualifier: Specify a Lambda function version or alias name.
        """
        if client_context is not None:
            pulumi.set(__self__, "client_context", client_context)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)
        if qualifier is not None:
            pulumi.set(__self__, "qualifier", qualifier)

    @property
    @pulumi.getter(name="clientContext")
    def client_context(self) -> Optional[str]:
        """
        Pass client-specific information to the Lambda function that you are invoking.
        """
        return pulumi.get(self, "client_context")

    @property
    @pulumi.getter
    def payload(self) -> Optional[str]:
        """
        JSON to provide to your Lambda function as input.
        """
        return pulumi.get(self, "payload")

    @property
    @pulumi.getter
    def qualifier(self) -> Optional[str]:
        """
        Specify a Lambda function version or alias name.
        """
        return pulumi.get(self, "qualifier")


@pulumi.output_type
class MaintenanceWindowTaskTaskInvocationParametersRunCommandParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudwatchConfig":
            suggest = "cloudwatch_config"
        elif key == "documentHash":
            suggest = "document_hash"
        elif key == "documentHashType":
            suggest = "document_hash_type"
        elif key == "documentVersion":
            suggest = "document_version"
        elif key == "notificationConfig":
            suggest = "notification_config"
        elif key == "outputS3Bucket":
            suggest = "output_s3_bucket"
        elif key == "outputS3KeyPrefix":
            suggest = "output_s3_key_prefix"
        elif key == "serviceRoleArn":
            suggest = "service_role_arn"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MaintenanceWindowTaskTaskInvocationParametersRunCommandParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MaintenanceWindowTaskTaskInvocationParametersRunCommandParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MaintenanceWindowTaskTaskInvocationParametersRunCommandParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloudwatch_config: Optional['outputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersCloudwatchConfig'] = None,
                 comment: Optional[str] = None,
                 document_hash: Optional[str] = None,
                 document_hash_type: Optional[str] = None,
                 document_version: Optional[str] = None,
                 notification_config: Optional['outputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfig'] = None,
                 output_s3_bucket: Optional[str] = None,
                 output_s3_key_prefix: Optional[str] = None,
                 parameters: Optional[Sequence['outputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameter']] = None,
                 service_role_arn: Optional[str] = None,
                 timeout_seconds: Optional[int] = None):
        """
        :param 'MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersCloudwatchConfigArgs' cloudwatch_config: Configuration options for sending command output to CloudWatch Logs. Documented below.
        :param str comment: Information about the command(s) to execute.
        :param str document_hash: The SHA-256 or SHA-1 hash created by the system when the document was created. SHA-1 hashes have been deprecated.
        :param str document_hash_type: SHA-256 or SHA-1. SHA-1 hashes have been deprecated. Valid values: `Sha256` and `Sha1`
        :param str document_version: The version of an Automation document to use during task execution.
        :param 'MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfigArgs' notification_config: Configurations for sending notifications about command status changes on a per-instance basis. Documented below.
        :param str output_s3_bucket: The name of the Amazon S3 bucket.
        :param str output_s3_key_prefix: The Amazon S3 bucket subfolder.
        :param Sequence['MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameterArgs'] parameters: The parameters for the RUN_COMMAND task execution. Documented below.
        :param str service_role_arn: The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) service role to use to publish Amazon Simple Notification Service (Amazon SNS) notifications for maintenance window Run Command tasks.
        :param int timeout_seconds: If this time is reached and the command has not already started executing, it doesn't run.
        """
        if cloudwatch_config is not None:
            pulumi.set(__self__, "cloudwatch_config", cloudwatch_config)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if document_hash is not None:
            pulumi.set(__self__, "document_hash", document_hash)
        if document_hash_type is not None:
            pulumi.set(__self__, "document_hash_type", document_hash_type)
        if document_version is not None:
            pulumi.set(__self__, "document_version", document_version)
        if notification_config is not None:
            pulumi.set(__self__, "notification_config", notification_config)
        if output_s3_bucket is not None:
            pulumi.set(__self__, "output_s3_bucket", output_s3_bucket)
        if output_s3_key_prefix is not None:
            pulumi.set(__self__, "output_s3_key_prefix", output_s3_key_prefix)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if service_role_arn is not None:
            pulumi.set(__self__, "service_role_arn", service_role_arn)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter(name="cloudwatchConfig")
    def cloudwatch_config(self) -> Optional['outputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersCloudwatchConfig']:
        """
        Configuration options for sending command output to CloudWatch Logs. Documented below.
        """
        return pulumi.get(self, "cloudwatch_config")

    @property
    @pulumi.getter
    def comment(self) -> Optional[str]:
        """
        Information about the command(s) to execute.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="documentHash")
    def document_hash(self) -> Optional[str]:
        """
        The SHA-256 or SHA-1 hash created by the system when the document was created. SHA-1 hashes have been deprecated.
        """
        return pulumi.get(self, "document_hash")

    @property
    @pulumi.getter(name="documentHashType")
    def document_hash_type(self) -> Optional[str]:
        """
        SHA-256 or SHA-1. SHA-1 hashes have been deprecated. Valid values: `Sha256` and `Sha1`
        """
        return pulumi.get(self, "document_hash_type")

    @property
    @pulumi.getter(name="documentVersion")
    def document_version(self) -> Optional[str]:
        """
        The version of an Automation document to use during task execution.
        """
        return pulumi.get(self, "document_version")

    @property
    @pulumi.getter(name="notificationConfig")
    def notification_config(self) -> Optional['outputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfig']:
        """
        Configurations for sending notifications about command status changes on a per-instance basis. Documented below.
        """
        return pulumi.get(self, "notification_config")

    @property
    @pulumi.getter(name="outputS3Bucket")
    def output_s3_bucket(self) -> Optional[str]:
        """
        The name of the Amazon S3 bucket.
        """
        return pulumi.get(self, "output_s3_bucket")

    @property
    @pulumi.getter(name="outputS3KeyPrefix")
    def output_s3_key_prefix(self) -> Optional[str]:
        """
        The Amazon S3 bucket subfolder.
        """
        return pulumi.get(self, "output_s3_key_prefix")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Sequence['outputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameter']]:
        """
        The parameters for the RUN_COMMAND task execution. Documented below.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="serviceRoleArn")
    def service_role_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) service role to use to publish Amazon Simple Notification Service (Amazon SNS) notifications for maintenance window Run Command tasks.
        """
        return pulumi.get(self, "service_role_arn")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[int]:
        """
        If this time is reached and the command has not already started executing, it doesn't run.
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersCloudwatchConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudwatchLogGroupName":
            suggest = "cloudwatch_log_group_name"
        elif key == "cloudwatchOutputEnabled":
            suggest = "cloudwatch_output_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersCloudwatchConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersCloudwatchConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersCloudwatchConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloudwatch_log_group_name: Optional[str] = None,
                 cloudwatch_output_enabled: Optional[bool] = None):
        """
        :param str cloudwatch_log_group_name: The name of the CloudWatch log group where you want to send command output. If you don't specify a group name, Systems Manager automatically creates a log group for you. The log group uses the following naming format: aws/ssm/SystemsManagerDocumentName.
        :param bool cloudwatch_output_enabled: Enables Systems Manager to send command output to CloudWatch Logs.
        """
        if cloudwatch_log_group_name is not None:
            pulumi.set(__self__, "cloudwatch_log_group_name", cloudwatch_log_group_name)
        if cloudwatch_output_enabled is not None:
            pulumi.set(__self__, "cloudwatch_output_enabled", cloudwatch_output_enabled)

    @property
    @pulumi.getter(name="cloudwatchLogGroupName")
    def cloudwatch_log_group_name(self) -> Optional[str]:
        """
        The name of the CloudWatch log group where you want to send command output. If you don't specify a group name, Systems Manager automatically creates a log group for you. The log group uses the following naming format: aws/ssm/SystemsManagerDocumentName.
        """
        return pulumi.get(self, "cloudwatch_log_group_name")

    @property
    @pulumi.getter(name="cloudwatchOutputEnabled")
    def cloudwatch_output_enabled(self) -> Optional[bool]:
        """
        Enables Systems Manager to send command output to CloudWatch Logs.
        """
        return pulumi.get(self, "cloudwatch_output_enabled")


@pulumi.output_type
class MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "notificationArn":
            suggest = "notification_arn"
        elif key == "notificationEvents":
            suggest = "notification_events"
        elif key == "notificationType":
            suggest = "notification_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 notification_arn: Optional[str] = None,
                 notification_events: Optional[Sequence[str]] = None,
                 notification_type: Optional[str] = None):
        """
        :param str notification_arn: An Amazon Resource Name (ARN) for a Simple Notification Service (SNS) topic. Run Command pushes notifications about command status changes to this topic.
        :param Sequence[str] notification_events: The different events for which you can receive notifications. Valid values: `All`, `InProgress`, `Success`, `TimedOut`, `Cancelled`, and `Failed`
        :param str notification_type: When specified with `Command`, receive notification when the status of a command changes. When specified with `Invocation`, for commands sent to multiple instances, receive notification on a per-instance basis when the status of a command changes. Valid values: `Command` and `Invocation`
        """
        if notification_arn is not None:
            pulumi.set(__self__, "notification_arn", notification_arn)
        if notification_events is not None:
            pulumi.set(__self__, "notification_events", notification_events)
        if notification_type is not None:
            pulumi.set(__self__, "notification_type", notification_type)

    @property
    @pulumi.getter(name="notificationArn")
    def notification_arn(self) -> Optional[str]:
        """
        An Amazon Resource Name (ARN) for a Simple Notification Service (SNS) topic. Run Command pushes notifications about command status changes to this topic.
        """
        return pulumi.get(self, "notification_arn")

    @property
    @pulumi.getter(name="notificationEvents")
    def notification_events(self) -> Optional[Sequence[str]]:
        """
        The different events for which you can receive notifications. Valid values: `All`, `InProgress`, `Success`, `TimedOut`, `Cancelled`, and `Failed`
        """
        return pulumi.get(self, "notification_events")

    @property
    @pulumi.getter(name="notificationType")
    def notification_type(self) -> Optional[str]:
        """
        When specified with `Command`, receive notification when the status of a command changes. When specified with `Invocation`, for commands sent to multiple instances, receive notification on a per-instance basis when the status of a command changes. Valid values: `Command` and `Invocation`
        """
        return pulumi.get(self, "notification_type")


@pulumi.output_type
class MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameter(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The parameter name.
        :param Sequence[str] values: The array of strings.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The parameter name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The array of strings.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class MaintenanceWindowTaskTaskInvocationParametersStepFunctionsParameters(dict):
    def __init__(__self__, *,
                 input: Optional[str] = None,
                 name: Optional[str] = None):
        """
        :param str input: The inputs for the STEP_FUNCTION task.
        :param str name: The name of the STEP_FUNCTION task.
        """
        if input is not None:
            pulumi.set(__self__, "input", input)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def input(self) -> Optional[str]:
        """
        The inputs for the STEP_FUNCTION task.
        """
        return pulumi.get(self, "input")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the STEP_FUNCTION task.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class PatchBaselineApprovalRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "patchFilters":
            suggest = "patch_filters"
        elif key == "approveAfterDays":
            suggest = "approve_after_days"
        elif key == "approveUntilDate":
            suggest = "approve_until_date"
        elif key == "complianceLevel":
            suggest = "compliance_level"
        elif key == "enableNonSecurity":
            suggest = "enable_non_security"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PatchBaselineApprovalRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PatchBaselineApprovalRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PatchBaselineApprovalRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 patch_filters: Sequence['outputs.PatchBaselineApprovalRulePatchFilter'],
                 approve_after_days: Optional[int] = None,
                 approve_until_date: Optional[str] = None,
                 compliance_level: Optional[str] = None,
                 enable_non_security: Optional[bool] = None):
        """
        :param Sequence['PatchBaselineApprovalRulePatchFilterArgs'] patch_filters: The patch filter group that defines the criteria for the rule.
               Up to 5 patch filters can be specified per approval rule using Key/Value pairs.
               Valid combinations of these Keys and the `operating_system` value can be found in the [SSM DescribePatchProperties API Reference](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_DescribePatchProperties.html).
               Valid Values are exact values for the patch property given as the key, or a wildcard `*`, which matches all values.
        :param int approve_after_days: The number of days after the release date of each patch matched by the rule the patch is marked as approved in the patch baseline.
               Valid Range: 0 to 100.
               Conflicts with `approve_until_date`.
        :param str approve_until_date: The cutoff date for auto approval of released patches.
               Any patches released on or before this date are installed automatically.
               Date is formatted as `YYYY-MM-DD`.
               Conflicts with `approve_after_days`
        :param str compliance_level: The compliance level for patches approved by this rule.
               Valid values are `CRITICAL`, `HIGH`, `MEDIUM`, `LOW`, `INFORMATIONAL`, and `UNSPECIFIED`.
               The default value is `UNSPECIFIED`.
        :param bool enable_non_security: Boolean enabling the application of non-security updates.
               The default value is `false`.
               Valid for Linux instances only.
        """
        pulumi.set(__self__, "patch_filters", patch_filters)
        if approve_after_days is not None:
            pulumi.set(__self__, "approve_after_days", approve_after_days)
        if approve_until_date is not None:
            pulumi.set(__self__, "approve_until_date", approve_until_date)
        if compliance_level is not None:
            pulumi.set(__self__, "compliance_level", compliance_level)
        if enable_non_security is not None:
            pulumi.set(__self__, "enable_non_security", enable_non_security)

    @property
    @pulumi.getter(name="patchFilters")
    def patch_filters(self) -> Sequence['outputs.PatchBaselineApprovalRulePatchFilter']:
        """
        The patch filter group that defines the criteria for the rule.
        Up to 5 patch filters can be specified per approval rule using Key/Value pairs.
        Valid combinations of these Keys and the `operating_system` value can be found in the [SSM DescribePatchProperties API Reference](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_DescribePatchProperties.html).
        Valid Values are exact values for the patch property given as the key, or a wildcard `*`, which matches all values.
        """
        return pulumi.get(self, "patch_filters")

    @property
    @pulumi.getter(name="approveAfterDays")
    def approve_after_days(self) -> Optional[int]:
        """
        The number of days after the release date of each patch matched by the rule the patch is marked as approved in the patch baseline.
        Valid Range: 0 to 100.
        Conflicts with `approve_until_date`.
        """
        return pulumi.get(self, "approve_after_days")

    @property
    @pulumi.getter(name="approveUntilDate")
    def approve_until_date(self) -> Optional[str]:
        """
        The cutoff date for auto approval of released patches.
        Any patches released on or before this date are installed automatically.
        Date is formatted as `YYYY-MM-DD`.
        Conflicts with `approve_after_days`
        """
        return pulumi.get(self, "approve_until_date")

    @property
    @pulumi.getter(name="complianceLevel")
    def compliance_level(self) -> Optional[str]:
        """
        The compliance level for patches approved by this rule.
        Valid values are `CRITICAL`, `HIGH`, `MEDIUM`, `LOW`, `INFORMATIONAL`, and `UNSPECIFIED`.
        The default value is `UNSPECIFIED`.
        """
        return pulumi.get(self, "compliance_level")

    @property
    @pulumi.getter(name="enableNonSecurity")
    def enable_non_security(self) -> Optional[bool]:
        """
        Boolean enabling the application of non-security updates.
        The default value is `false`.
        Valid for Linux instances only.
        """
        return pulumi.get(self, "enable_non_security")


@pulumi.output_type
class PatchBaselineApprovalRulePatchFilter(dict):
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str]):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")


@pulumi.output_type
class PatchBaselineGlobalFilter(dict):
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str]):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")


@pulumi.output_type
class PatchBaselineSource(dict):
    def __init__(__self__, *,
                 configuration: str,
                 name: str,
                 products: Sequence[str]):
        """
        :param str configuration: The value of the yum repo configuration.
               For information about other options available for your yum repository configuration, see the [`dnf.conf` documentation](https://man7.org/linux/man-pages/man5/dnf.conf.5.html)
        :param str name: The name specified to identify the patch source.
        :param Sequence[str] products: The specific operating system versions a patch repository applies to, such as `"Ubuntu16.04"`, `"AmazonLinux2016.09"`, `"RedhatEnterpriseLinux7.2"` or `"Suse12.7"`.
               For lists of supported product values, see [PatchFilter](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html).
        """
        pulumi.set(__self__, "configuration", configuration)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "products", products)

    @property
    @pulumi.getter
    def configuration(self) -> str:
        """
        The value of the yum repo configuration.
        For information about other options available for your yum repository configuration, see the [`dnf.conf` documentation](https://man7.org/linux/man-pages/man5/dnf.conf.5.html)
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name specified to identify the patch source.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def products(self) -> Sequence[str]:
        """
        The specific operating system versions a patch repository applies to, such as `"Ubuntu16.04"`, `"AmazonLinux2016.09"`, `"RedhatEnterpriseLinux7.2"` or `"Suse12.7"`.
        For lists of supported product values, see [PatchFilter](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html).
        """
        return pulumi.get(self, "products")


@pulumi.output_type
class ResourceDataSyncS3Destination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "kmsKeyArn":
            suggest = "kms_key_arn"
        elif key == "syncFormat":
            suggest = "sync_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceDataSyncS3Destination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceDataSyncS3Destination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceDataSyncS3Destination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: str,
                 region: str,
                 kms_key_arn: Optional[str] = None,
                 prefix: Optional[str] = None,
                 sync_format: Optional[str] = None):
        """
        :param str bucket_name: Name of S3 bucket where the aggregated data is stored.
        :param str region: Region with the bucket targeted by the Resource Data Sync.
        :param str kms_key_arn: ARN of an encryption key for a destination in Amazon S3.
        :param str prefix: Prefix for the bucket.
        :param str sync_format: A supported sync format. Only JsonSerDe is currently supported. Defaults to JsonSerDe.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "region", region)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if sync_format is not None:
            pulumi.set(__self__, "sync_format", sync_format)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        Name of S3 bucket where the aggregated data is stored.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        Region with the bucket targeted by the Resource Data Sync.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[str]:
        """
        ARN of an encryption key for a destination in Amazon S3.
        """
        return pulumi.get(self, "kms_key_arn")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        Prefix for the bucket.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter(name="syncFormat")
    def sync_format(self) -> Optional[str]:
        """
        A supported sync format. Only JsonSerDe is currently supported. Defaults to JsonSerDe.
        """
        return pulumi.get(self, "sync_format")


@pulumi.output_type
class GetInstancesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Name of the filter field. Valid values can be found in the [SSM InstanceInformationStringFilter API Reference](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_InstanceInformationStringFilter.html).
        :param Sequence[str] values: Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the filter field. Valid values can be found in the [SSM InstanceInformationStringFilter API Reference](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_InstanceInformationStringFilter.html).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetMaintenanceWindowsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Name of the filter field. Valid values can be found in the [SSM DescribeMaintenanceWindows API Reference](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_DescribeMaintenanceWindows.html#API_DescribeMaintenanceWindows_RequestSyntax).
        :param Sequence[str] values: Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the filter field. Valid values can be found in the [SSM DescribeMaintenanceWindows API Reference](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_DescribeMaintenanceWindows.html#API_DescribeMaintenanceWindows_RequestSyntax).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetPatchBaselineApprovalRuleResult(dict):
    def __init__(__self__, *,
                 approve_after_days: int,
                 approve_until_date: str,
                 compliance_level: str,
                 enable_non_security: bool,
                 patch_filters: Sequence['outputs.GetPatchBaselineApprovalRulePatchFilterResult']):
        """
        :param int approve_after_days: The number of days after the release date of each patch matched by the rule the patch is marked as approved in the patch baseline.
        :param str approve_until_date: The cutoff date for auto approval of released patches. Any patches released on or before this date are installed automatically. Date is formatted as `YYYY-MM-DD`. Conflicts with `approve_after_days`
        :param str compliance_level: The compliance level for patches approved by this rule.
        :param bool enable_non_security: Boolean enabling the application of non-security updates.
        :param Sequence['GetPatchBaselineApprovalRulePatchFilterArgs'] patch_filters: The patch filter group that defines the criteria for the rule.
        """
        pulumi.set(__self__, "approve_after_days", approve_after_days)
        pulumi.set(__self__, "approve_until_date", approve_until_date)
        pulumi.set(__self__, "compliance_level", compliance_level)
        pulumi.set(__self__, "enable_non_security", enable_non_security)
        pulumi.set(__self__, "patch_filters", patch_filters)

    @property
    @pulumi.getter(name="approveAfterDays")
    def approve_after_days(self) -> int:
        """
        The number of days after the release date of each patch matched by the rule the patch is marked as approved in the patch baseline.
        """
        return pulumi.get(self, "approve_after_days")

    @property
    @pulumi.getter(name="approveUntilDate")
    def approve_until_date(self) -> str:
        """
        The cutoff date for auto approval of released patches. Any patches released on or before this date are installed automatically. Date is formatted as `YYYY-MM-DD`. Conflicts with `approve_after_days`
        """
        return pulumi.get(self, "approve_until_date")

    @property
    @pulumi.getter(name="complianceLevel")
    def compliance_level(self) -> str:
        """
        The compliance level for patches approved by this rule.
        """
        return pulumi.get(self, "compliance_level")

    @property
    @pulumi.getter(name="enableNonSecurity")
    def enable_non_security(self) -> bool:
        """
        Boolean enabling the application of non-security updates.
        """
        return pulumi.get(self, "enable_non_security")

    @property
    @pulumi.getter(name="patchFilters")
    def patch_filters(self) -> Sequence['outputs.GetPatchBaselineApprovalRulePatchFilterResult']:
        """
        The patch filter group that defines the criteria for the rule.
        """
        return pulumi.get(self, "patch_filters")


@pulumi.output_type
class GetPatchBaselineApprovalRulePatchFilterResult(dict):
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str]):
        """
        :param str key: The key for the filter.
        :param Sequence[str] values: The value for the filter.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key for the filter.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The value for the filter.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetPatchBaselineGlobalFilterResult(dict):
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str]):
        """
        :param str key: The key for the filter.
        :param Sequence[str] values: The value for the filter.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key for the filter.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The value for the filter.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetPatchBaselineSourceResult(dict):
    def __init__(__self__, *,
                 configuration: str,
                 name: str,
                 products: Sequence[str]):
        """
        :param str configuration: The value of the yum repo configuration.
        :param str name: The name specified to identify the patch source.
        :param Sequence[str] products: The specific operating system versions a patch repository applies to.
        """
        pulumi.set(__self__, "configuration", configuration)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "products", products)

    @property
    @pulumi.getter
    def configuration(self) -> str:
        """
        The value of the yum repo configuration.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name specified to identify the patch source.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def products(self) -> Sequence[str]:
        """
        The specific operating system versions a patch repository applies to.
        """
        return pulumi.get(self, "products")


