# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'CustomerManagedPolicyAttachmentCustomerManagedPolicyReference',
    'InstanceAccessControlAttributesAttribute',
    'InstanceAccessControlAttributesAttributeValue',
    'PermissionsBoundaryAttachmentPermissionsBoundary',
    'PermissionsBoundaryAttachmentPermissionsBoundaryCustomerManagedPolicyReference',
]

@pulumi.output_type
class CustomerManagedPolicyAttachmentCustomerManagedPolicyReference(dict):
    def __init__(__self__, *,
                 name: str,
                 path: Optional[str] = None):
        """
        :param str name: Name of the customer managed IAM Policy to be attached.
        :param str path: The path to the IAM policy to be attached. The default is `/`. See [IAM Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names) for more information.
        """
        pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the customer managed IAM Policy to be attached.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path to the IAM policy to be attached. The default is `/`. See [IAM Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names) for more information.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class InstanceAccessControlAttributesAttribute(dict):
    def __init__(__self__, *,
                 key: str,
                 values: Sequence['outputs.InstanceAccessControlAttributesAttributeValue']):
        """
        :param str key: The name of the attribute associated with your identities in your identity source. This is used to map a specified attribute in your identity source with an attribute in AWS SSO.
        :param Sequence['InstanceAccessControlAttributesAttributeValueArgs'] values: The value used for mapping a specified attribute to an identity source. See AccessControlAttributeValue
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The name of the attribute associated with your identities in your identity source. This is used to map a specified attribute in your identity source with an attribute in AWS SSO.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence['outputs.InstanceAccessControlAttributesAttributeValue']:
        """
        The value used for mapping a specified attribute to an identity source. See AccessControlAttributeValue
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class InstanceAccessControlAttributesAttributeValue(dict):
    def __init__(__self__, *,
                 sources: Sequence[str]):
        """
        :param Sequence[str] sources: The identity source to use when mapping a specified attribute to AWS SSO.
        """
        pulumi.set(__self__, "sources", sources)

    @property
    @pulumi.getter
    def sources(self) -> Sequence[str]:
        """
        The identity source to use when mapping a specified attribute to AWS SSO.
        """
        return pulumi.get(self, "sources")


@pulumi.output_type
class PermissionsBoundaryAttachmentPermissionsBoundary(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customerManagedPolicyReference":
            suggest = "customer_managed_policy_reference"
        elif key == "managedPolicyArn":
            suggest = "managed_policy_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PermissionsBoundaryAttachmentPermissionsBoundary. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PermissionsBoundaryAttachmentPermissionsBoundary.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PermissionsBoundaryAttachmentPermissionsBoundary.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 customer_managed_policy_reference: Optional['outputs.PermissionsBoundaryAttachmentPermissionsBoundaryCustomerManagedPolicyReference'] = None,
                 managed_policy_arn: Optional[str] = None):
        """
        :param 'PermissionsBoundaryAttachmentPermissionsBoundaryCustomerManagedPolicyReferenceArgs' customer_managed_policy_reference: Specifies the name and path of a customer managed policy. See below.
        :param str managed_policy_arn: AWS-managed IAM policy ARN to use as the permissions boundary.
        """
        if customer_managed_policy_reference is not None:
            pulumi.set(__self__, "customer_managed_policy_reference", customer_managed_policy_reference)
        if managed_policy_arn is not None:
            pulumi.set(__self__, "managed_policy_arn", managed_policy_arn)

    @property
    @pulumi.getter(name="customerManagedPolicyReference")
    def customer_managed_policy_reference(self) -> Optional['outputs.PermissionsBoundaryAttachmentPermissionsBoundaryCustomerManagedPolicyReference']:
        """
        Specifies the name and path of a customer managed policy. See below.
        """
        return pulumi.get(self, "customer_managed_policy_reference")

    @property
    @pulumi.getter(name="managedPolicyArn")
    def managed_policy_arn(self) -> Optional[str]:
        """
        AWS-managed IAM policy ARN to use as the permissions boundary.
        """
        return pulumi.get(self, "managed_policy_arn")


@pulumi.output_type
class PermissionsBoundaryAttachmentPermissionsBoundaryCustomerManagedPolicyReference(dict):
    def __init__(__self__, *,
                 name: str,
                 path: Optional[str] = None):
        """
        :param str name: Name of the customer managed IAM Policy to be attached.
        :param str path: The path to the IAM policy to be attached. The default is `/`. See [IAM Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names) for more information.
        """
        pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the customer managed IAM Policy to be attached.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path to the IAM policy to be attached. The default is `/`. See [IAM Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names) for more information.
        """
        return pulumi.get(self, "path")


