# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'AccessHomeDirectoryMappingArgs',
    'AccessPosixProfileArgs',
    'ConnectorAs2ConfigArgs',
    'ServerEndpointDetailsArgs',
    'ServerProtocolDetailsArgs',
    'ServerWorkflowDetailsArgs',
    'ServerWorkflowDetailsOnPartialUploadArgs',
    'ServerWorkflowDetailsOnUploadArgs',
    'UserHomeDirectoryMappingArgs',
    'UserPosixProfileArgs',
    'WorkflowOnExceptionStepArgs',
    'WorkflowOnExceptionStepCopyStepDetailsArgs',
    'WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationArgs',
    'WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationEfsFileLocationArgs',
    'WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationS3FileLocationArgs',
    'WorkflowOnExceptionStepCustomStepDetailsArgs',
    'WorkflowOnExceptionStepDecryptStepDetailsArgs',
    'WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationArgs',
    'WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationEfsFileLocationArgs',
    'WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationS3FileLocationArgs',
    'WorkflowOnExceptionStepDeleteStepDetailsArgs',
    'WorkflowOnExceptionStepTagStepDetailsArgs',
    'WorkflowOnExceptionStepTagStepDetailsTagArgs',
    'WorkflowStepArgs',
    'WorkflowStepCopyStepDetailsArgs',
    'WorkflowStepCopyStepDetailsDestinationFileLocationArgs',
    'WorkflowStepCopyStepDetailsDestinationFileLocationEfsFileLocationArgs',
    'WorkflowStepCopyStepDetailsDestinationFileLocationS3FileLocationArgs',
    'WorkflowStepCustomStepDetailsArgs',
    'WorkflowStepDecryptStepDetailsArgs',
    'WorkflowStepDecryptStepDetailsDestinationFileLocationArgs',
    'WorkflowStepDecryptStepDetailsDestinationFileLocationEfsFileLocationArgs',
    'WorkflowStepDecryptStepDetailsDestinationFileLocationS3FileLocationArgs',
    'WorkflowStepDeleteStepDetailsArgs',
    'WorkflowStepTagStepDetailsArgs',
    'WorkflowStepTagStepDetailsTagArgs',
]

@pulumi.input_type
class AccessHomeDirectoryMappingArgs:
    def __init__(__self__, *,
                 entry: pulumi.Input[str],
                 target: pulumi.Input[str]):
        """
        :param pulumi.Input[str] entry: Represents an entry and a target.
        :param pulumi.Input[str] target: Represents the map target.
        """
        pulumi.set(__self__, "entry", entry)
        pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def entry(self) -> pulumi.Input[str]:
        """
        Represents an entry and a target.
        """
        return pulumi.get(self, "entry")

    @entry.setter
    def entry(self, value: pulumi.Input[str]):
        pulumi.set(self, "entry", value)

    @property
    @pulumi.getter
    def target(self) -> pulumi.Input[str]:
        """
        Represents the map target.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: pulumi.Input[str]):
        pulumi.set(self, "target", value)


@pulumi.input_type
class AccessPosixProfileArgs:
    def __init__(__self__, *,
                 gid: pulumi.Input[int],
                 uid: pulumi.Input[int],
                 secondary_gids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None):
        """
        :param pulumi.Input[int] gid: The POSIX group ID used for all EFS operations by this user.
        :param pulumi.Input[int] uid: The POSIX user ID used for all EFS operations by this user.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] secondary_gids: The secondary POSIX group IDs used for all EFS operations by this user.
        """
        pulumi.set(__self__, "gid", gid)
        pulumi.set(__self__, "uid", uid)
        if secondary_gids is not None:
            pulumi.set(__self__, "secondary_gids", secondary_gids)

    @property
    @pulumi.getter
    def gid(self) -> pulumi.Input[int]:
        """
        The POSIX group ID used for all EFS operations by this user.
        """
        return pulumi.get(self, "gid")

    @gid.setter
    def gid(self, value: pulumi.Input[int]):
        pulumi.set(self, "gid", value)

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Input[int]:
        """
        The POSIX user ID used for all EFS operations by this user.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: pulumi.Input[int]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="secondaryGids")
    def secondary_gids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        The secondary POSIX group IDs used for all EFS operations by this user.
        """
        return pulumi.get(self, "secondary_gids")

    @secondary_gids.setter
    def secondary_gids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "secondary_gids", value)


@pulumi.input_type
class ConnectorAs2ConfigArgs:
    def __init__(__self__, *,
                 compression: pulumi.Input[str],
                 encryption_algorithm: pulumi.Input[str],
                 local_profile_id: pulumi.Input[str],
                 mdn_response: pulumi.Input[str],
                 partner_profile_id: pulumi.Input[str],
                 signing_algorithm: pulumi.Input[str],
                 mdn_signing_algorithm: Optional[pulumi.Input[str]] = None,
                 message_subject: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] compression: Specifies weather AS2 file is compressed. The valud values are ZLIB and  DISABLED.
        :param pulumi.Input[str] encryption_algorithm: The algorithm that is used to encrypt the file. The valid values are AES128_CBC | AES192_CBC | AES256_CBC | NONE.
        :param pulumi.Input[str] local_profile_id: The unique identifier for the AS2 local profile.
        :param pulumi.Input[str] mdn_response: Used for outbound requests to determine if a partner response for transfers is synchronous or asynchronous. The valid values are SYNC and NONE.
        :param pulumi.Input[str] partner_profile_id: The unique identifier for the AS2 partner profile.
        :param pulumi.Input[str] signing_algorithm: The algorithm that is used to sign AS2 messages sent with the connector. The valid values are SHA256 | SHA384 | SHA512 | SHA1 | NONE .
        :param pulumi.Input[str] mdn_signing_algorithm: The signing algorithm for the Mdn response. The valid values are SHA256 | SHA384 | SHA512 | SHA1 | NONE | DEFAULT.
        :param pulumi.Input[str] message_subject: Used as the subject HTTP header attribute in AS2 messages that are being sent with the connector.
        """
        pulumi.set(__self__, "compression", compression)
        pulumi.set(__self__, "encryption_algorithm", encryption_algorithm)
        pulumi.set(__self__, "local_profile_id", local_profile_id)
        pulumi.set(__self__, "mdn_response", mdn_response)
        pulumi.set(__self__, "partner_profile_id", partner_profile_id)
        pulumi.set(__self__, "signing_algorithm", signing_algorithm)
        if mdn_signing_algorithm is not None:
            pulumi.set(__self__, "mdn_signing_algorithm", mdn_signing_algorithm)
        if message_subject is not None:
            pulumi.set(__self__, "message_subject", message_subject)

    @property
    @pulumi.getter
    def compression(self) -> pulumi.Input[str]:
        """
        Specifies weather AS2 file is compressed. The valud values are ZLIB and  DISABLED.
        """
        return pulumi.get(self, "compression")

    @compression.setter
    def compression(self, value: pulumi.Input[str]):
        pulumi.set(self, "compression", value)

    @property
    @pulumi.getter(name="encryptionAlgorithm")
    def encryption_algorithm(self) -> pulumi.Input[str]:
        """
        The algorithm that is used to encrypt the file. The valid values are AES128_CBC | AES192_CBC | AES256_CBC | NONE.
        """
        return pulumi.get(self, "encryption_algorithm")

    @encryption_algorithm.setter
    def encryption_algorithm(self, value: pulumi.Input[str]):
        pulumi.set(self, "encryption_algorithm", value)

    @property
    @pulumi.getter(name="localProfileId")
    def local_profile_id(self) -> pulumi.Input[str]:
        """
        The unique identifier for the AS2 local profile.
        """
        return pulumi.get(self, "local_profile_id")

    @local_profile_id.setter
    def local_profile_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "local_profile_id", value)

    @property
    @pulumi.getter(name="mdnResponse")
    def mdn_response(self) -> pulumi.Input[str]:
        """
        Used for outbound requests to determine if a partner response for transfers is synchronous or asynchronous. The valid values are SYNC and NONE.
        """
        return pulumi.get(self, "mdn_response")

    @mdn_response.setter
    def mdn_response(self, value: pulumi.Input[str]):
        pulumi.set(self, "mdn_response", value)

    @property
    @pulumi.getter(name="partnerProfileId")
    def partner_profile_id(self) -> pulumi.Input[str]:
        """
        The unique identifier for the AS2 partner profile.
        """
        return pulumi.get(self, "partner_profile_id")

    @partner_profile_id.setter
    def partner_profile_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "partner_profile_id", value)

    @property
    @pulumi.getter(name="signingAlgorithm")
    def signing_algorithm(self) -> pulumi.Input[str]:
        """
        The algorithm that is used to sign AS2 messages sent with the connector. The valid values are SHA256 | SHA384 | SHA512 | SHA1 | NONE .
        """
        return pulumi.get(self, "signing_algorithm")

    @signing_algorithm.setter
    def signing_algorithm(self, value: pulumi.Input[str]):
        pulumi.set(self, "signing_algorithm", value)

    @property
    @pulumi.getter(name="mdnSigningAlgorithm")
    def mdn_signing_algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        The signing algorithm for the Mdn response. The valid values are SHA256 | SHA384 | SHA512 | SHA1 | NONE | DEFAULT.
        """
        return pulumi.get(self, "mdn_signing_algorithm")

    @mdn_signing_algorithm.setter
    def mdn_signing_algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mdn_signing_algorithm", value)

    @property
    @pulumi.getter(name="messageSubject")
    def message_subject(self) -> Optional[pulumi.Input[str]]:
        """
        Used as the subject HTTP header attribute in AS2 messages that are being sent with the connector.
        """
        return pulumi.get(self, "message_subject")

    @message_subject.setter
    def message_subject(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_subject", value)


@pulumi.input_type
class ServerEndpointDetailsArgs:
    def __init__(__self__, *,
                 address_allocation_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vpc_endpoint_id: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] address_allocation_ids: A list of address allocation IDs that are required to attach an Elastic IP address to your SFTP server's endpoint. This property can only be used when `endpoint_type` is set to `VPC`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A list of security groups IDs that are available to attach to your server's endpoint. If no security groups are specified, the VPC's default security groups are automatically assigned to your endpoint. This property can only be used when `endpoint_type` is set to `VPC`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: A list of subnet IDs that are required to host your SFTP server endpoint in your VPC. This property can only be used when `endpoint_type` is set to `VPC`.
        :param pulumi.Input[str] vpc_endpoint_id: The ID of the VPC endpoint. This property can only be used when `endpoint_type` is set to `VPC_ENDPOINT`
        :param pulumi.Input[str] vpc_id: The VPC ID of the virtual private cloud in which the SFTP server's endpoint will be hosted. This property can only be used when `endpoint_type` is set to `VPC`.
        """
        if address_allocation_ids is not None:
            pulumi.set(__self__, "address_allocation_ids", address_allocation_ids)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if vpc_endpoint_id is not None:
            pulumi.set(__self__, "vpc_endpoint_id", vpc_endpoint_id)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="addressAllocationIds")
    def address_allocation_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of address allocation IDs that are required to attach an Elastic IP address to your SFTP server's endpoint. This property can only be used when `endpoint_type` is set to `VPC`.
        """
        return pulumi.get(self, "address_allocation_ids")

    @address_allocation_ids.setter
    def address_allocation_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "address_allocation_ids", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of security groups IDs that are available to attach to your server's endpoint. If no security groups are specified, the VPC's default security groups are automatically assigned to your endpoint. This property can only be used when `endpoint_type` is set to `VPC`.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of subnet IDs that are required to host your SFTP server endpoint in your VPC. This property can only be used when `endpoint_type` is set to `VPC`.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter(name="vpcEndpointId")
    def vpc_endpoint_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the VPC endpoint. This property can only be used when `endpoint_type` is set to `VPC_ENDPOINT`
        """
        return pulumi.get(self, "vpc_endpoint_id")

    @vpc_endpoint_id.setter
    def vpc_endpoint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_endpoint_id", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The VPC ID of the virtual private cloud in which the SFTP server's endpoint will be hosted. This property can only be used when `endpoint_type` is set to `VPC`.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.input_type
class ServerProtocolDetailsArgs:
    def __init__(__self__, *,
                 as2_transports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 passive_ip: Optional[pulumi.Input[str]] = None,
                 set_stat_option: Optional[pulumi.Input[str]] = None,
                 tls_session_resumption_mode: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] as2_transports: Indicates the transport method for the AS2 messages. Currently, only `HTTP` is supported.
        :param pulumi.Input[str] passive_ip: Indicates passive mode, for FTP and FTPS protocols. Enter a single IPv4 address, such as the public IP address of a firewall, router, or load balancer.
        :param pulumi.Input[str] set_stat_option: Use to ignore the error that is generated when the client attempts to use `SETSTAT` on a file you are uploading to an S3 bucket. Valid values: `DEFAULT`, `ENABLE_NO_OP`.
        :param pulumi.Input[str] tls_session_resumption_mode: A property used with Transfer Family servers that use the FTPS protocol. Provides a mechanism to resume or share a negotiated secret key between the control and data connection for an FTPS session. Valid values: `DISABLED`, `ENABLED`, `ENFORCED`.
        """
        if as2_transports is not None:
            pulumi.set(__self__, "as2_transports", as2_transports)
        if passive_ip is not None:
            pulumi.set(__self__, "passive_ip", passive_ip)
        if set_stat_option is not None:
            pulumi.set(__self__, "set_stat_option", set_stat_option)
        if tls_session_resumption_mode is not None:
            pulumi.set(__self__, "tls_session_resumption_mode", tls_session_resumption_mode)

    @property
    @pulumi.getter(name="as2Transports")
    def as2_transports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Indicates the transport method for the AS2 messages. Currently, only `HTTP` is supported.
        """
        return pulumi.get(self, "as2_transports")

    @as2_transports.setter
    def as2_transports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "as2_transports", value)

    @property
    @pulumi.getter(name="passiveIp")
    def passive_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates passive mode, for FTP and FTPS protocols. Enter a single IPv4 address, such as the public IP address of a firewall, router, or load balancer.
        """
        return pulumi.get(self, "passive_ip")

    @passive_ip.setter
    def passive_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "passive_ip", value)

    @property
    @pulumi.getter(name="setStatOption")
    def set_stat_option(self) -> Optional[pulumi.Input[str]]:
        """
        Use to ignore the error that is generated when the client attempts to use `SETSTAT` on a file you are uploading to an S3 bucket. Valid values: `DEFAULT`, `ENABLE_NO_OP`.
        """
        return pulumi.get(self, "set_stat_option")

    @set_stat_option.setter
    def set_stat_option(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "set_stat_option", value)

    @property
    @pulumi.getter(name="tlsSessionResumptionMode")
    def tls_session_resumption_mode(self) -> Optional[pulumi.Input[str]]:
        """
        A property used with Transfer Family servers that use the FTPS protocol. Provides a mechanism to resume or share a negotiated secret key between the control and data connection for an FTPS session. Valid values: `DISABLED`, `ENABLED`, `ENFORCED`.
        """
        return pulumi.get(self, "tls_session_resumption_mode")

    @tls_session_resumption_mode.setter
    def tls_session_resumption_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_session_resumption_mode", value)


@pulumi.input_type
class ServerWorkflowDetailsArgs:
    def __init__(__self__, *,
                 on_partial_upload: Optional[pulumi.Input['ServerWorkflowDetailsOnPartialUploadArgs']] = None,
                 on_upload: Optional[pulumi.Input['ServerWorkflowDetailsOnUploadArgs']] = None):
        """
        :param pulumi.Input['ServerWorkflowDetailsOnPartialUploadArgs'] on_partial_upload: A trigger that starts a workflow if a file is only partially uploaded. See Workflow Detail below.
        :param pulumi.Input['ServerWorkflowDetailsOnUploadArgs'] on_upload: A trigger that starts a workflow: the workflow begins to execute after a file is uploaded. See Workflow Detail below.
        """
        if on_partial_upload is not None:
            pulumi.set(__self__, "on_partial_upload", on_partial_upload)
        if on_upload is not None:
            pulumi.set(__self__, "on_upload", on_upload)

    @property
    @pulumi.getter(name="onPartialUpload")
    def on_partial_upload(self) -> Optional[pulumi.Input['ServerWorkflowDetailsOnPartialUploadArgs']]:
        """
        A trigger that starts a workflow if a file is only partially uploaded. See Workflow Detail below.
        """
        return pulumi.get(self, "on_partial_upload")

    @on_partial_upload.setter
    def on_partial_upload(self, value: Optional[pulumi.Input['ServerWorkflowDetailsOnPartialUploadArgs']]):
        pulumi.set(self, "on_partial_upload", value)

    @property
    @pulumi.getter(name="onUpload")
    def on_upload(self) -> Optional[pulumi.Input['ServerWorkflowDetailsOnUploadArgs']]:
        """
        A trigger that starts a workflow: the workflow begins to execute after a file is uploaded. See Workflow Detail below.
        """
        return pulumi.get(self, "on_upload")

    @on_upload.setter
    def on_upload(self, value: Optional[pulumi.Input['ServerWorkflowDetailsOnUploadArgs']]):
        pulumi.set(self, "on_upload", value)


@pulumi.input_type
class ServerWorkflowDetailsOnPartialUploadArgs:
    def __init__(__self__, *,
                 execution_role: pulumi.Input[str],
                 workflow_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] execution_role: Includes the necessary permissions for S3, EFS, and Lambda operations that Transfer can assume, so that all workflow steps can operate on the required resources.
        :param pulumi.Input[str] workflow_id: A unique identifier for the workflow.
        """
        pulumi.set(__self__, "execution_role", execution_role)
        pulumi.set(__self__, "workflow_id", workflow_id)

    @property
    @pulumi.getter(name="executionRole")
    def execution_role(self) -> pulumi.Input[str]:
        """
        Includes the necessary permissions for S3, EFS, and Lambda operations that Transfer can assume, so that all workflow steps can operate on the required resources.
        """
        return pulumi.get(self, "execution_role")

    @execution_role.setter
    def execution_role(self, value: pulumi.Input[str]):
        pulumi.set(self, "execution_role", value)

    @property
    @pulumi.getter(name="workflowId")
    def workflow_id(self) -> pulumi.Input[str]:
        """
        A unique identifier for the workflow.
        """
        return pulumi.get(self, "workflow_id")

    @workflow_id.setter
    def workflow_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "workflow_id", value)


@pulumi.input_type
class ServerWorkflowDetailsOnUploadArgs:
    def __init__(__self__, *,
                 execution_role: pulumi.Input[str],
                 workflow_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] execution_role: Includes the necessary permissions for S3, EFS, and Lambda operations that Transfer can assume, so that all workflow steps can operate on the required resources.
        :param pulumi.Input[str] workflow_id: A unique identifier for the workflow.
        """
        pulumi.set(__self__, "execution_role", execution_role)
        pulumi.set(__self__, "workflow_id", workflow_id)

    @property
    @pulumi.getter(name="executionRole")
    def execution_role(self) -> pulumi.Input[str]:
        """
        Includes the necessary permissions for S3, EFS, and Lambda operations that Transfer can assume, so that all workflow steps can operate on the required resources.
        """
        return pulumi.get(self, "execution_role")

    @execution_role.setter
    def execution_role(self, value: pulumi.Input[str]):
        pulumi.set(self, "execution_role", value)

    @property
    @pulumi.getter(name="workflowId")
    def workflow_id(self) -> pulumi.Input[str]:
        """
        A unique identifier for the workflow.
        """
        return pulumi.get(self, "workflow_id")

    @workflow_id.setter
    def workflow_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "workflow_id", value)


@pulumi.input_type
class UserHomeDirectoryMappingArgs:
    def __init__(__self__, *,
                 entry: pulumi.Input[str],
                 target: pulumi.Input[str]):
        """
        :param pulumi.Input[str] entry: Represents an entry and a target.
        :param pulumi.Input[str] target: Represents the map target.
               
               The `Restricted` option is achieved using the following mapping:
               
               ```python
               import pulumi
               ```
        """
        pulumi.set(__self__, "entry", entry)
        pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def entry(self) -> pulumi.Input[str]:
        """
        Represents an entry and a target.
        """
        return pulumi.get(self, "entry")

    @entry.setter
    def entry(self, value: pulumi.Input[str]):
        pulumi.set(self, "entry", value)

    @property
    @pulumi.getter
    def target(self) -> pulumi.Input[str]:
        """
        Represents the map target.

        The `Restricted` option is achieved using the following mapping:

        ```python
        import pulumi
        ```
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: pulumi.Input[str]):
        pulumi.set(self, "target", value)


@pulumi.input_type
class UserPosixProfileArgs:
    def __init__(__self__, *,
                 gid: pulumi.Input[int],
                 uid: pulumi.Input[int],
                 secondary_gids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None):
        """
        :param pulumi.Input[int] gid: The POSIX group ID used for all EFS operations by this user.
        :param pulumi.Input[int] uid: The POSIX user ID used for all EFS operations by this user.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] secondary_gids: The secondary POSIX group IDs used for all EFS operations by this user.
        """
        pulumi.set(__self__, "gid", gid)
        pulumi.set(__self__, "uid", uid)
        if secondary_gids is not None:
            pulumi.set(__self__, "secondary_gids", secondary_gids)

    @property
    @pulumi.getter
    def gid(self) -> pulumi.Input[int]:
        """
        The POSIX group ID used for all EFS operations by this user.
        """
        return pulumi.get(self, "gid")

    @gid.setter
    def gid(self, value: pulumi.Input[int]):
        pulumi.set(self, "gid", value)

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Input[int]:
        """
        The POSIX user ID used for all EFS operations by this user.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: pulumi.Input[int]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="secondaryGids")
    def secondary_gids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        The secondary POSIX group IDs used for all EFS operations by this user.
        """
        return pulumi.get(self, "secondary_gids")

    @secondary_gids.setter
    def secondary_gids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "secondary_gids", value)


@pulumi.input_type
class WorkflowOnExceptionStepArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 copy_step_details: Optional[pulumi.Input['WorkflowOnExceptionStepCopyStepDetailsArgs']] = None,
                 custom_step_details: Optional[pulumi.Input['WorkflowOnExceptionStepCustomStepDetailsArgs']] = None,
                 decrypt_step_details: Optional[pulumi.Input['WorkflowOnExceptionStepDecryptStepDetailsArgs']] = None,
                 delete_step_details: Optional[pulumi.Input['WorkflowOnExceptionStepDeleteStepDetailsArgs']] = None,
                 tag_step_details: Optional[pulumi.Input['WorkflowOnExceptionStepTagStepDetailsArgs']] = None):
        """
        :param pulumi.Input[str] type: One of the following step types are supported. `COPY`, `CUSTOM`, `DECRYPT`, `DELETE`, and `TAG`.
        :param pulumi.Input['WorkflowOnExceptionStepCopyStepDetailsArgs'] copy_step_details: Details for a step that performs a file copy. See Copy Step Details below.
        :param pulumi.Input['WorkflowOnExceptionStepCustomStepDetailsArgs'] custom_step_details: Details for a step that invokes a lambda function.
        :param pulumi.Input['WorkflowOnExceptionStepDecryptStepDetailsArgs'] decrypt_step_details: Details for a step that decrypts the file.
        :param pulumi.Input['WorkflowOnExceptionStepDeleteStepDetailsArgs'] delete_step_details: Details for a step that deletes the file.
        :param pulumi.Input['WorkflowOnExceptionStepTagStepDetailsArgs'] tag_step_details: Details for a step that creates one or more tags.
        """
        pulumi.set(__self__, "type", type)
        if copy_step_details is not None:
            pulumi.set(__self__, "copy_step_details", copy_step_details)
        if custom_step_details is not None:
            pulumi.set(__self__, "custom_step_details", custom_step_details)
        if decrypt_step_details is not None:
            pulumi.set(__self__, "decrypt_step_details", decrypt_step_details)
        if delete_step_details is not None:
            pulumi.set(__self__, "delete_step_details", delete_step_details)
        if tag_step_details is not None:
            pulumi.set(__self__, "tag_step_details", tag_step_details)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        One of the following step types are supported. `COPY`, `CUSTOM`, `DECRYPT`, `DELETE`, and `TAG`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="copyStepDetails")
    def copy_step_details(self) -> Optional[pulumi.Input['WorkflowOnExceptionStepCopyStepDetailsArgs']]:
        """
        Details for a step that performs a file copy. See Copy Step Details below.
        """
        return pulumi.get(self, "copy_step_details")

    @copy_step_details.setter
    def copy_step_details(self, value: Optional[pulumi.Input['WorkflowOnExceptionStepCopyStepDetailsArgs']]):
        pulumi.set(self, "copy_step_details", value)

    @property
    @pulumi.getter(name="customStepDetails")
    def custom_step_details(self) -> Optional[pulumi.Input['WorkflowOnExceptionStepCustomStepDetailsArgs']]:
        """
        Details for a step that invokes a lambda function.
        """
        return pulumi.get(self, "custom_step_details")

    @custom_step_details.setter
    def custom_step_details(self, value: Optional[pulumi.Input['WorkflowOnExceptionStepCustomStepDetailsArgs']]):
        pulumi.set(self, "custom_step_details", value)

    @property
    @pulumi.getter(name="decryptStepDetails")
    def decrypt_step_details(self) -> Optional[pulumi.Input['WorkflowOnExceptionStepDecryptStepDetailsArgs']]:
        """
        Details for a step that decrypts the file.
        """
        return pulumi.get(self, "decrypt_step_details")

    @decrypt_step_details.setter
    def decrypt_step_details(self, value: Optional[pulumi.Input['WorkflowOnExceptionStepDecryptStepDetailsArgs']]):
        pulumi.set(self, "decrypt_step_details", value)

    @property
    @pulumi.getter(name="deleteStepDetails")
    def delete_step_details(self) -> Optional[pulumi.Input['WorkflowOnExceptionStepDeleteStepDetailsArgs']]:
        """
        Details for a step that deletes the file.
        """
        return pulumi.get(self, "delete_step_details")

    @delete_step_details.setter
    def delete_step_details(self, value: Optional[pulumi.Input['WorkflowOnExceptionStepDeleteStepDetailsArgs']]):
        pulumi.set(self, "delete_step_details", value)

    @property
    @pulumi.getter(name="tagStepDetails")
    def tag_step_details(self) -> Optional[pulumi.Input['WorkflowOnExceptionStepTagStepDetailsArgs']]:
        """
        Details for a step that creates one or more tags.
        """
        return pulumi.get(self, "tag_step_details")

    @tag_step_details.setter
    def tag_step_details(self, value: Optional[pulumi.Input['WorkflowOnExceptionStepTagStepDetailsArgs']]):
        pulumi.set(self, "tag_step_details", value)


@pulumi.input_type
class WorkflowOnExceptionStepCopyStepDetailsArgs:
    def __init__(__self__, *,
                 destination_file_location: Optional[pulumi.Input['WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 overwrite_existing: Optional[pulumi.Input[str]] = None,
                 source_file_location: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationArgs'] destination_file_location: Specifies the location for the file being copied. Use ${Transfer:username} in this field to parametrize the destination prefix by username.
        :param pulumi.Input[str] name: The name of the step, used as an identifier.
        :param pulumi.Input[str] overwrite_existing: A flag that indicates whether or not to overwrite an existing file of the same name. The default is `FALSE`. Valid values are `TRUE` and `FALSE`.
        :param pulumi.Input[str] source_file_location: Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
        """
        if destination_file_location is not None:
            pulumi.set(__self__, "destination_file_location", destination_file_location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if overwrite_existing is not None:
            pulumi.set(__self__, "overwrite_existing", overwrite_existing)
        if source_file_location is not None:
            pulumi.set(__self__, "source_file_location", source_file_location)

    @property
    @pulumi.getter(name="destinationFileLocation")
    def destination_file_location(self) -> Optional[pulumi.Input['WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationArgs']]:
        """
        Specifies the location for the file being copied. Use ${Transfer:username} in this field to parametrize the destination prefix by username.
        """
        return pulumi.get(self, "destination_file_location")

    @destination_file_location.setter
    def destination_file_location(self, value: Optional[pulumi.Input['WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationArgs']]):
        pulumi.set(self, "destination_file_location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the step, used as an identifier.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="overwriteExisting")
    def overwrite_existing(self) -> Optional[pulumi.Input[str]]:
        """
        A flag that indicates whether or not to overwrite an existing file of the same name. The default is `FALSE`. Valid values are `TRUE` and `FALSE`.
        """
        return pulumi.get(self, "overwrite_existing")

    @overwrite_existing.setter
    def overwrite_existing(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "overwrite_existing", value)

    @property
    @pulumi.getter(name="sourceFileLocation")
    def source_file_location(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
        """
        return pulumi.get(self, "source_file_location")

    @source_file_location.setter
    def source_file_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_file_location", value)


@pulumi.input_type
class WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationArgs:
    def __init__(__self__, *,
                 efs_file_location: Optional[pulumi.Input['WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationEfsFileLocationArgs']] = None,
                 s3_file_location: Optional[pulumi.Input['WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationS3FileLocationArgs']] = None):
        """
        :param pulumi.Input['WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationEfsFileLocationArgs'] efs_file_location: Specifies the details for the EFS file being copied.
        :param pulumi.Input['WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationS3FileLocationArgs'] s3_file_location: Specifies the details for the S3 file being copied.
        """
        if efs_file_location is not None:
            pulumi.set(__self__, "efs_file_location", efs_file_location)
        if s3_file_location is not None:
            pulumi.set(__self__, "s3_file_location", s3_file_location)

    @property
    @pulumi.getter(name="efsFileLocation")
    def efs_file_location(self) -> Optional[pulumi.Input['WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationEfsFileLocationArgs']]:
        """
        Specifies the details for the EFS file being copied.
        """
        return pulumi.get(self, "efs_file_location")

    @efs_file_location.setter
    def efs_file_location(self, value: Optional[pulumi.Input['WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationEfsFileLocationArgs']]):
        pulumi.set(self, "efs_file_location", value)

    @property
    @pulumi.getter(name="s3FileLocation")
    def s3_file_location(self) -> Optional[pulumi.Input['WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationS3FileLocationArgs']]:
        """
        Specifies the details for the S3 file being copied.
        """
        return pulumi.get(self, "s3_file_location")

    @s3_file_location.setter
    def s3_file_location(self, value: Optional[pulumi.Input['WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationS3FileLocationArgs']]):
        pulumi.set(self, "s3_file_location", value)


@pulumi.input_type
class WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationEfsFileLocationArgs:
    def __init__(__self__, *,
                 file_system_id: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] file_system_id: The ID of the file system, assigned by Amazon EFS.
        :param pulumi.Input[str] path: The pathname for the folder being used by a workflow.
        """
        if file_system_id is not None:
            pulumi.set(__self__, "file_system_id", file_system_id)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the file system, assigned by Amazon EFS.
        """
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_system_id", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The pathname for the folder being used by a workflow.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationS3FileLocationArgs:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket: Specifies the S3 bucket for the customer input file.
        :param pulumi.Input[str] key: The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the S3 bucket for the customer input file.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)


@pulumi.input_type
class WorkflowOnExceptionStepCustomStepDetailsArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 source_file_location: Optional[pulumi.Input[str]] = None,
                 target: Optional[pulumi.Input[str]] = None,
                 timeout_seconds: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] name: The name of the step, used as an identifier.
        :param pulumi.Input[str] source_file_location: Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
        :param pulumi.Input[str] target: The ARN for the lambda function that is being called.
        :param pulumi.Input[int] timeout_seconds: Timeout, in seconds, for the step.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_file_location is not None:
            pulumi.set(__self__, "source_file_location", source_file_location)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the step, used as an identifier.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sourceFileLocation")
    def source_file_location(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
        """
        return pulumi.get(self, "source_file_location")

    @source_file_location.setter
    def source_file_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_file_location", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN for the lambda function that is being called.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Timeout, in seconds, for the step.
        """
        return pulumi.get(self, "timeout_seconds")

    @timeout_seconds.setter
    def timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_seconds", value)


@pulumi.input_type
class WorkflowOnExceptionStepDecryptStepDetailsArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 destination_file_location: Optional[pulumi.Input['WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 overwrite_existing: Optional[pulumi.Input[str]] = None,
                 source_file_location: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: The type of encryption used. Currently, this value must be `"PGP"`.
        :param pulumi.Input['WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationArgs'] destination_file_location: Specifies the location for the file being copied. Use ${Transfer:username} in this field to parametrize the destination prefix by username.
        :param pulumi.Input[str] name: The name of the step, used as an identifier.
        :param pulumi.Input[str] overwrite_existing: A flag that indicates whether or not to overwrite an existing file of the same name. The default is `FALSE`. Valid values are `TRUE` and `FALSE`.
        :param pulumi.Input[str] source_file_location: Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
        """
        pulumi.set(__self__, "type", type)
        if destination_file_location is not None:
            pulumi.set(__self__, "destination_file_location", destination_file_location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if overwrite_existing is not None:
            pulumi.set(__self__, "overwrite_existing", overwrite_existing)
        if source_file_location is not None:
            pulumi.set(__self__, "source_file_location", source_file_location)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of encryption used. Currently, this value must be `"PGP"`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="destinationFileLocation")
    def destination_file_location(self) -> Optional[pulumi.Input['WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationArgs']]:
        """
        Specifies the location for the file being copied. Use ${Transfer:username} in this field to parametrize the destination prefix by username.
        """
        return pulumi.get(self, "destination_file_location")

    @destination_file_location.setter
    def destination_file_location(self, value: Optional[pulumi.Input['WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationArgs']]):
        pulumi.set(self, "destination_file_location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the step, used as an identifier.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="overwriteExisting")
    def overwrite_existing(self) -> Optional[pulumi.Input[str]]:
        """
        A flag that indicates whether or not to overwrite an existing file of the same name. The default is `FALSE`. Valid values are `TRUE` and `FALSE`.
        """
        return pulumi.get(self, "overwrite_existing")

    @overwrite_existing.setter
    def overwrite_existing(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "overwrite_existing", value)

    @property
    @pulumi.getter(name="sourceFileLocation")
    def source_file_location(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
        """
        return pulumi.get(self, "source_file_location")

    @source_file_location.setter
    def source_file_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_file_location", value)


@pulumi.input_type
class WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationArgs:
    def __init__(__self__, *,
                 efs_file_location: Optional[pulumi.Input['WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationEfsFileLocationArgs']] = None,
                 s3_file_location: Optional[pulumi.Input['WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationS3FileLocationArgs']] = None):
        """
        :param pulumi.Input['WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationEfsFileLocationArgs'] efs_file_location: Specifies the details for the EFS file being copied.
        :param pulumi.Input['WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationS3FileLocationArgs'] s3_file_location: Specifies the details for the S3 file being copied.
        """
        if efs_file_location is not None:
            pulumi.set(__self__, "efs_file_location", efs_file_location)
        if s3_file_location is not None:
            pulumi.set(__self__, "s3_file_location", s3_file_location)

    @property
    @pulumi.getter(name="efsFileLocation")
    def efs_file_location(self) -> Optional[pulumi.Input['WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationEfsFileLocationArgs']]:
        """
        Specifies the details for the EFS file being copied.
        """
        return pulumi.get(self, "efs_file_location")

    @efs_file_location.setter
    def efs_file_location(self, value: Optional[pulumi.Input['WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationEfsFileLocationArgs']]):
        pulumi.set(self, "efs_file_location", value)

    @property
    @pulumi.getter(name="s3FileLocation")
    def s3_file_location(self) -> Optional[pulumi.Input['WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationS3FileLocationArgs']]:
        """
        Specifies the details for the S3 file being copied.
        """
        return pulumi.get(self, "s3_file_location")

    @s3_file_location.setter
    def s3_file_location(self, value: Optional[pulumi.Input['WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationS3FileLocationArgs']]):
        pulumi.set(self, "s3_file_location", value)


@pulumi.input_type
class WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationEfsFileLocationArgs:
    def __init__(__self__, *,
                 file_system_id: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] file_system_id: The ID of the file system, assigned by Amazon EFS.
        :param pulumi.Input[str] path: The pathname for the folder being used by a workflow.
        """
        if file_system_id is not None:
            pulumi.set(__self__, "file_system_id", file_system_id)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the file system, assigned by Amazon EFS.
        """
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_system_id", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The pathname for the folder being used by a workflow.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationS3FileLocationArgs:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket: Specifies the S3 bucket for the customer input file.
        :param pulumi.Input[str] key: The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the S3 bucket for the customer input file.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)


@pulumi.input_type
class WorkflowOnExceptionStepDeleteStepDetailsArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 source_file_location: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The name of the step, used as an identifier.
        :param pulumi.Input[str] source_file_location: Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_file_location is not None:
            pulumi.set(__self__, "source_file_location", source_file_location)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the step, used as an identifier.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sourceFileLocation")
    def source_file_location(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
        """
        return pulumi.get(self, "source_file_location")

    @source_file_location.setter
    def source_file_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_file_location", value)


@pulumi.input_type
class WorkflowOnExceptionStepTagStepDetailsArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 source_file_location: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowOnExceptionStepTagStepDetailsTagArgs']]]] = None):
        """
        :param pulumi.Input[str] name: The name of the step, used as an identifier.
        :param pulumi.Input[str] source_file_location: Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
        :param pulumi.Input[Sequence[pulumi.Input['WorkflowOnExceptionStepTagStepDetailsTagArgs']]] tags: Array that contains from 1 to 10 key/value pairs. See S3 Tags below.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_file_location is not None:
            pulumi.set(__self__, "source_file_location", source_file_location)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the step, used as an identifier.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sourceFileLocation")
    def source_file_location(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
        """
        return pulumi.get(self, "source_file_location")

    @source_file_location.setter
    def source_file_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_file_location", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowOnExceptionStepTagStepDetailsTagArgs']]]]:
        """
        Array that contains from 1 to 10 key/value pairs. See S3 Tags below.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowOnExceptionStepTagStepDetailsTagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class WorkflowOnExceptionStepTagStepDetailsTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] key: The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
        :param pulumi.Input[str] value: The value that corresponds to the key.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value that corresponds to the key.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class WorkflowStepArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 copy_step_details: Optional[pulumi.Input['WorkflowStepCopyStepDetailsArgs']] = None,
                 custom_step_details: Optional[pulumi.Input['WorkflowStepCustomStepDetailsArgs']] = None,
                 decrypt_step_details: Optional[pulumi.Input['WorkflowStepDecryptStepDetailsArgs']] = None,
                 delete_step_details: Optional[pulumi.Input['WorkflowStepDeleteStepDetailsArgs']] = None,
                 tag_step_details: Optional[pulumi.Input['WorkflowStepTagStepDetailsArgs']] = None):
        """
        :param pulumi.Input[str] type: One of the following step types are supported. `COPY`, `CUSTOM`, `DECRYPT`, `DELETE`, and `TAG`.
        :param pulumi.Input['WorkflowStepCopyStepDetailsArgs'] copy_step_details: Details for a step that performs a file copy. See Copy Step Details below.
        :param pulumi.Input['WorkflowStepCustomStepDetailsArgs'] custom_step_details: Details for a step that invokes a lambda function.
        :param pulumi.Input['WorkflowStepDecryptStepDetailsArgs'] decrypt_step_details: Details for a step that decrypts the file.
        :param pulumi.Input['WorkflowStepDeleteStepDetailsArgs'] delete_step_details: Details for a step that deletes the file.
        :param pulumi.Input['WorkflowStepTagStepDetailsArgs'] tag_step_details: Details for a step that creates one or more tags.
        """
        pulumi.set(__self__, "type", type)
        if copy_step_details is not None:
            pulumi.set(__self__, "copy_step_details", copy_step_details)
        if custom_step_details is not None:
            pulumi.set(__self__, "custom_step_details", custom_step_details)
        if decrypt_step_details is not None:
            pulumi.set(__self__, "decrypt_step_details", decrypt_step_details)
        if delete_step_details is not None:
            pulumi.set(__self__, "delete_step_details", delete_step_details)
        if tag_step_details is not None:
            pulumi.set(__self__, "tag_step_details", tag_step_details)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        One of the following step types are supported. `COPY`, `CUSTOM`, `DECRYPT`, `DELETE`, and `TAG`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="copyStepDetails")
    def copy_step_details(self) -> Optional[pulumi.Input['WorkflowStepCopyStepDetailsArgs']]:
        """
        Details for a step that performs a file copy. See Copy Step Details below.
        """
        return pulumi.get(self, "copy_step_details")

    @copy_step_details.setter
    def copy_step_details(self, value: Optional[pulumi.Input['WorkflowStepCopyStepDetailsArgs']]):
        pulumi.set(self, "copy_step_details", value)

    @property
    @pulumi.getter(name="customStepDetails")
    def custom_step_details(self) -> Optional[pulumi.Input['WorkflowStepCustomStepDetailsArgs']]:
        """
        Details for a step that invokes a lambda function.
        """
        return pulumi.get(self, "custom_step_details")

    @custom_step_details.setter
    def custom_step_details(self, value: Optional[pulumi.Input['WorkflowStepCustomStepDetailsArgs']]):
        pulumi.set(self, "custom_step_details", value)

    @property
    @pulumi.getter(name="decryptStepDetails")
    def decrypt_step_details(self) -> Optional[pulumi.Input['WorkflowStepDecryptStepDetailsArgs']]:
        """
        Details for a step that decrypts the file.
        """
        return pulumi.get(self, "decrypt_step_details")

    @decrypt_step_details.setter
    def decrypt_step_details(self, value: Optional[pulumi.Input['WorkflowStepDecryptStepDetailsArgs']]):
        pulumi.set(self, "decrypt_step_details", value)

    @property
    @pulumi.getter(name="deleteStepDetails")
    def delete_step_details(self) -> Optional[pulumi.Input['WorkflowStepDeleteStepDetailsArgs']]:
        """
        Details for a step that deletes the file.
        """
        return pulumi.get(self, "delete_step_details")

    @delete_step_details.setter
    def delete_step_details(self, value: Optional[pulumi.Input['WorkflowStepDeleteStepDetailsArgs']]):
        pulumi.set(self, "delete_step_details", value)

    @property
    @pulumi.getter(name="tagStepDetails")
    def tag_step_details(self) -> Optional[pulumi.Input['WorkflowStepTagStepDetailsArgs']]:
        """
        Details for a step that creates one or more tags.
        """
        return pulumi.get(self, "tag_step_details")

    @tag_step_details.setter
    def tag_step_details(self, value: Optional[pulumi.Input['WorkflowStepTagStepDetailsArgs']]):
        pulumi.set(self, "tag_step_details", value)


@pulumi.input_type
class WorkflowStepCopyStepDetailsArgs:
    def __init__(__self__, *,
                 destination_file_location: Optional[pulumi.Input['WorkflowStepCopyStepDetailsDestinationFileLocationArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 overwrite_existing: Optional[pulumi.Input[str]] = None,
                 source_file_location: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['WorkflowStepCopyStepDetailsDestinationFileLocationArgs'] destination_file_location: Specifies the location for the file being copied. Use ${Transfer:username} in this field to parametrize the destination prefix by username.
        :param pulumi.Input[str] name: The name of the step, used as an identifier.
        :param pulumi.Input[str] overwrite_existing: A flag that indicates whether or not to overwrite an existing file of the same name. The default is `FALSE`. Valid values are `TRUE` and `FALSE`.
        :param pulumi.Input[str] source_file_location: Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
        """
        if destination_file_location is not None:
            pulumi.set(__self__, "destination_file_location", destination_file_location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if overwrite_existing is not None:
            pulumi.set(__self__, "overwrite_existing", overwrite_existing)
        if source_file_location is not None:
            pulumi.set(__self__, "source_file_location", source_file_location)

    @property
    @pulumi.getter(name="destinationFileLocation")
    def destination_file_location(self) -> Optional[pulumi.Input['WorkflowStepCopyStepDetailsDestinationFileLocationArgs']]:
        """
        Specifies the location for the file being copied. Use ${Transfer:username} in this field to parametrize the destination prefix by username.
        """
        return pulumi.get(self, "destination_file_location")

    @destination_file_location.setter
    def destination_file_location(self, value: Optional[pulumi.Input['WorkflowStepCopyStepDetailsDestinationFileLocationArgs']]):
        pulumi.set(self, "destination_file_location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the step, used as an identifier.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="overwriteExisting")
    def overwrite_existing(self) -> Optional[pulumi.Input[str]]:
        """
        A flag that indicates whether or not to overwrite an existing file of the same name. The default is `FALSE`. Valid values are `TRUE` and `FALSE`.
        """
        return pulumi.get(self, "overwrite_existing")

    @overwrite_existing.setter
    def overwrite_existing(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "overwrite_existing", value)

    @property
    @pulumi.getter(name="sourceFileLocation")
    def source_file_location(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
        """
        return pulumi.get(self, "source_file_location")

    @source_file_location.setter
    def source_file_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_file_location", value)


@pulumi.input_type
class WorkflowStepCopyStepDetailsDestinationFileLocationArgs:
    def __init__(__self__, *,
                 efs_file_location: Optional[pulumi.Input['WorkflowStepCopyStepDetailsDestinationFileLocationEfsFileLocationArgs']] = None,
                 s3_file_location: Optional[pulumi.Input['WorkflowStepCopyStepDetailsDestinationFileLocationS3FileLocationArgs']] = None):
        """
        :param pulumi.Input['WorkflowStepCopyStepDetailsDestinationFileLocationEfsFileLocationArgs'] efs_file_location: Specifies the details for the EFS file being copied.
        :param pulumi.Input['WorkflowStepCopyStepDetailsDestinationFileLocationS3FileLocationArgs'] s3_file_location: Specifies the details for the S3 file being copied.
        """
        if efs_file_location is not None:
            pulumi.set(__self__, "efs_file_location", efs_file_location)
        if s3_file_location is not None:
            pulumi.set(__self__, "s3_file_location", s3_file_location)

    @property
    @pulumi.getter(name="efsFileLocation")
    def efs_file_location(self) -> Optional[pulumi.Input['WorkflowStepCopyStepDetailsDestinationFileLocationEfsFileLocationArgs']]:
        """
        Specifies the details for the EFS file being copied.
        """
        return pulumi.get(self, "efs_file_location")

    @efs_file_location.setter
    def efs_file_location(self, value: Optional[pulumi.Input['WorkflowStepCopyStepDetailsDestinationFileLocationEfsFileLocationArgs']]):
        pulumi.set(self, "efs_file_location", value)

    @property
    @pulumi.getter(name="s3FileLocation")
    def s3_file_location(self) -> Optional[pulumi.Input['WorkflowStepCopyStepDetailsDestinationFileLocationS3FileLocationArgs']]:
        """
        Specifies the details for the S3 file being copied.
        """
        return pulumi.get(self, "s3_file_location")

    @s3_file_location.setter
    def s3_file_location(self, value: Optional[pulumi.Input['WorkflowStepCopyStepDetailsDestinationFileLocationS3FileLocationArgs']]):
        pulumi.set(self, "s3_file_location", value)


@pulumi.input_type
class WorkflowStepCopyStepDetailsDestinationFileLocationEfsFileLocationArgs:
    def __init__(__self__, *,
                 file_system_id: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] file_system_id: The ID of the file system, assigned by Amazon EFS.
        :param pulumi.Input[str] path: The pathname for the folder being used by a workflow.
        """
        if file_system_id is not None:
            pulumi.set(__self__, "file_system_id", file_system_id)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the file system, assigned by Amazon EFS.
        """
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_system_id", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The pathname for the folder being used by a workflow.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class WorkflowStepCopyStepDetailsDestinationFileLocationS3FileLocationArgs:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket: Specifies the S3 bucket for the customer input file.
        :param pulumi.Input[str] key: The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the S3 bucket for the customer input file.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)


@pulumi.input_type
class WorkflowStepCustomStepDetailsArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 source_file_location: Optional[pulumi.Input[str]] = None,
                 target: Optional[pulumi.Input[str]] = None,
                 timeout_seconds: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] name: The name of the step, used as an identifier.
        :param pulumi.Input[str] source_file_location: Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
        :param pulumi.Input[str] target: The ARN for the lambda function that is being called.
        :param pulumi.Input[int] timeout_seconds: Timeout, in seconds, for the step.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_file_location is not None:
            pulumi.set(__self__, "source_file_location", source_file_location)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the step, used as an identifier.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sourceFileLocation")
    def source_file_location(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
        """
        return pulumi.get(self, "source_file_location")

    @source_file_location.setter
    def source_file_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_file_location", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN for the lambda function that is being called.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Timeout, in seconds, for the step.
        """
        return pulumi.get(self, "timeout_seconds")

    @timeout_seconds.setter
    def timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_seconds", value)


@pulumi.input_type
class WorkflowStepDecryptStepDetailsArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 destination_file_location: Optional[pulumi.Input['WorkflowStepDecryptStepDetailsDestinationFileLocationArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 overwrite_existing: Optional[pulumi.Input[str]] = None,
                 source_file_location: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: The type of encryption used. Currently, this value must be `"PGP"`.
        :param pulumi.Input['WorkflowStepDecryptStepDetailsDestinationFileLocationArgs'] destination_file_location: Specifies the location for the file being copied. Use ${Transfer:username} in this field to parametrize the destination prefix by username.
        :param pulumi.Input[str] name: The name of the step, used as an identifier.
        :param pulumi.Input[str] overwrite_existing: A flag that indicates whether or not to overwrite an existing file of the same name. The default is `FALSE`. Valid values are `TRUE` and `FALSE`.
        :param pulumi.Input[str] source_file_location: Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
        """
        pulumi.set(__self__, "type", type)
        if destination_file_location is not None:
            pulumi.set(__self__, "destination_file_location", destination_file_location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if overwrite_existing is not None:
            pulumi.set(__self__, "overwrite_existing", overwrite_existing)
        if source_file_location is not None:
            pulumi.set(__self__, "source_file_location", source_file_location)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of encryption used. Currently, this value must be `"PGP"`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="destinationFileLocation")
    def destination_file_location(self) -> Optional[pulumi.Input['WorkflowStepDecryptStepDetailsDestinationFileLocationArgs']]:
        """
        Specifies the location for the file being copied. Use ${Transfer:username} in this field to parametrize the destination prefix by username.
        """
        return pulumi.get(self, "destination_file_location")

    @destination_file_location.setter
    def destination_file_location(self, value: Optional[pulumi.Input['WorkflowStepDecryptStepDetailsDestinationFileLocationArgs']]):
        pulumi.set(self, "destination_file_location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the step, used as an identifier.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="overwriteExisting")
    def overwrite_existing(self) -> Optional[pulumi.Input[str]]:
        """
        A flag that indicates whether or not to overwrite an existing file of the same name. The default is `FALSE`. Valid values are `TRUE` and `FALSE`.
        """
        return pulumi.get(self, "overwrite_existing")

    @overwrite_existing.setter
    def overwrite_existing(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "overwrite_existing", value)

    @property
    @pulumi.getter(name="sourceFileLocation")
    def source_file_location(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
        """
        return pulumi.get(self, "source_file_location")

    @source_file_location.setter
    def source_file_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_file_location", value)


@pulumi.input_type
class WorkflowStepDecryptStepDetailsDestinationFileLocationArgs:
    def __init__(__self__, *,
                 efs_file_location: Optional[pulumi.Input['WorkflowStepDecryptStepDetailsDestinationFileLocationEfsFileLocationArgs']] = None,
                 s3_file_location: Optional[pulumi.Input['WorkflowStepDecryptStepDetailsDestinationFileLocationS3FileLocationArgs']] = None):
        """
        :param pulumi.Input['WorkflowStepDecryptStepDetailsDestinationFileLocationEfsFileLocationArgs'] efs_file_location: Specifies the details for the EFS file being copied.
        :param pulumi.Input['WorkflowStepDecryptStepDetailsDestinationFileLocationS3FileLocationArgs'] s3_file_location: Specifies the details for the S3 file being copied.
        """
        if efs_file_location is not None:
            pulumi.set(__self__, "efs_file_location", efs_file_location)
        if s3_file_location is not None:
            pulumi.set(__self__, "s3_file_location", s3_file_location)

    @property
    @pulumi.getter(name="efsFileLocation")
    def efs_file_location(self) -> Optional[pulumi.Input['WorkflowStepDecryptStepDetailsDestinationFileLocationEfsFileLocationArgs']]:
        """
        Specifies the details for the EFS file being copied.
        """
        return pulumi.get(self, "efs_file_location")

    @efs_file_location.setter
    def efs_file_location(self, value: Optional[pulumi.Input['WorkflowStepDecryptStepDetailsDestinationFileLocationEfsFileLocationArgs']]):
        pulumi.set(self, "efs_file_location", value)

    @property
    @pulumi.getter(name="s3FileLocation")
    def s3_file_location(self) -> Optional[pulumi.Input['WorkflowStepDecryptStepDetailsDestinationFileLocationS3FileLocationArgs']]:
        """
        Specifies the details for the S3 file being copied.
        """
        return pulumi.get(self, "s3_file_location")

    @s3_file_location.setter
    def s3_file_location(self, value: Optional[pulumi.Input['WorkflowStepDecryptStepDetailsDestinationFileLocationS3FileLocationArgs']]):
        pulumi.set(self, "s3_file_location", value)


@pulumi.input_type
class WorkflowStepDecryptStepDetailsDestinationFileLocationEfsFileLocationArgs:
    def __init__(__self__, *,
                 file_system_id: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] file_system_id: The ID of the file system, assigned by Amazon EFS.
        :param pulumi.Input[str] path: The pathname for the folder being used by a workflow.
        """
        if file_system_id is not None:
            pulumi.set(__self__, "file_system_id", file_system_id)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the file system, assigned by Amazon EFS.
        """
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_system_id", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The pathname for the folder being used by a workflow.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class WorkflowStepDecryptStepDetailsDestinationFileLocationS3FileLocationArgs:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket: Specifies the S3 bucket for the customer input file.
        :param pulumi.Input[str] key: The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the S3 bucket for the customer input file.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)


@pulumi.input_type
class WorkflowStepDeleteStepDetailsArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 source_file_location: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The name of the step, used as an identifier.
        :param pulumi.Input[str] source_file_location: Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_file_location is not None:
            pulumi.set(__self__, "source_file_location", source_file_location)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the step, used as an identifier.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sourceFileLocation")
    def source_file_location(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
        """
        return pulumi.get(self, "source_file_location")

    @source_file_location.setter
    def source_file_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_file_location", value)


@pulumi.input_type
class WorkflowStepTagStepDetailsArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 source_file_location: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowStepTagStepDetailsTagArgs']]]] = None):
        """
        :param pulumi.Input[str] name: The name of the step, used as an identifier.
        :param pulumi.Input[str] source_file_location: Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
        :param pulumi.Input[Sequence[pulumi.Input['WorkflowStepTagStepDetailsTagArgs']]] tags: Array that contains from 1 to 10 key/value pairs. See S3 Tags below.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_file_location is not None:
            pulumi.set(__self__, "source_file_location", source_file_location)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the step, used as an identifier.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sourceFileLocation")
    def source_file_location(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
        """
        return pulumi.get(self, "source_file_location")

    @source_file_location.setter
    def source_file_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_file_location", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowStepTagStepDetailsTagArgs']]]]:
        """
        Array that contains from 1 to 10 key/value pairs. See S3 Tags below.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowStepTagStepDetailsTagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class WorkflowStepTagStepDetailsTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] key: The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
        :param pulumi.Input[str] value: The value that corresponds to the key.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value that corresponds to the key.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


