# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetServiceNetworkResult',
    'AwaitableGetServiceNetworkResult',
    'get_service_network',
    'get_service_network_output',
]

@pulumi.output_type
class GetServiceNetworkResult:
    """
    A collection of values returned by getServiceNetwork.
    """
    def __init__(__self__, arn=None, auth_type=None, created_at=None, id=None, last_updated_at=None, name=None, number_of_associated_services=None, number_of_associated_vpcs=None, service_network_identifier=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if auth_type and not isinstance(auth_type, str):
            raise TypeError("Expected argument 'auth_type' to be a str")
        pulumi.set(__self__, "auth_type", auth_type)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_updated_at and not isinstance(last_updated_at, str):
            raise TypeError("Expected argument 'last_updated_at' to be a str")
        pulumi.set(__self__, "last_updated_at", last_updated_at)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if number_of_associated_services and not isinstance(number_of_associated_services, int):
            raise TypeError("Expected argument 'number_of_associated_services' to be a int")
        pulumi.set(__self__, "number_of_associated_services", number_of_associated_services)
        if number_of_associated_vpcs and not isinstance(number_of_associated_vpcs, int):
            raise TypeError("Expected argument 'number_of_associated_vpcs' to be a int")
        pulumi.set(__self__, "number_of_associated_vpcs", number_of_associated_vpcs)
        if service_network_identifier and not isinstance(service_network_identifier, str):
            raise TypeError("Expected argument 'service_network_identifier' to be a str")
        pulumi.set(__self__, "service_network_identifier", service_network_identifier)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        ARN of the Service Network.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> str:
        """
        Authentication type for the service network. Either `NONE` or `AWS_IAM`.
        """
        return pulumi.get(self, "auth_type")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        Date and time the service network was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastUpdatedAt")
    def last_updated_at(self) -> str:
        """
        Date and time the service network was last updated.
        """
        return pulumi.get(self, "last_updated_at")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the service network.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="numberOfAssociatedServices")
    def number_of_associated_services(self) -> int:
        """
        Number of services associated with this service network.
        """
        return pulumi.get(self, "number_of_associated_services")

    @property
    @pulumi.getter(name="numberOfAssociatedVpcs")
    def number_of_associated_vpcs(self) -> int:
        """
        Number of VPCs associated with this service network.
        """
        return pulumi.get(self, "number_of_associated_vpcs")

    @property
    @pulumi.getter(name="serviceNetworkIdentifier")
    def service_network_identifier(self) -> str:
        return pulumi.get(self, "service_network_identifier")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        return pulumi.get(self, "tags")


class AwaitableGetServiceNetworkResult(GetServiceNetworkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceNetworkResult(
            arn=self.arn,
            auth_type=self.auth_type,
            created_at=self.created_at,
            id=self.id,
            last_updated_at=self.last_updated_at,
            name=self.name,
            number_of_associated_services=self.number_of_associated_services,
            number_of_associated_vpcs=self.number_of_associated_vpcs,
            service_network_identifier=self.service_network_identifier,
            tags=self.tags)


def get_service_network(service_network_identifier: Optional[str] = None,
                        tags: Optional[Mapping[str, str]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceNetworkResult:
    """
    Data source for managing an AWS VPC Lattice Service Network.

    ## Example Usage
    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.vpclattice.get_service_network(service_network_identifier="")
    ```


    :param str service_network_identifier: Identifier of the network service.
    """
    __args__ = dict()
    __args__['serviceNetworkIdentifier'] = service_network_identifier
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:vpclattice/getServiceNetwork:getServiceNetwork', __args__, opts=opts, typ=GetServiceNetworkResult).value

    return AwaitableGetServiceNetworkResult(
        arn=pulumi.get(__ret__, 'arn'),
        auth_type=pulumi.get(__ret__, 'auth_type'),
        created_at=pulumi.get(__ret__, 'created_at'),
        id=pulumi.get(__ret__, 'id'),
        last_updated_at=pulumi.get(__ret__, 'last_updated_at'),
        name=pulumi.get(__ret__, 'name'),
        number_of_associated_services=pulumi.get(__ret__, 'number_of_associated_services'),
        number_of_associated_vpcs=pulumi.get(__ret__, 'number_of_associated_vpcs'),
        service_network_identifier=pulumi.get(__ret__, 'service_network_identifier'),
        tags=pulumi.get(__ret__, 'tags'))


@_utilities.lift_output_func(get_service_network)
def get_service_network_output(service_network_identifier: Optional[pulumi.Input[str]] = None,
                               tags: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetServiceNetworkResult]:
    """
    Data source for managing an AWS VPC Lattice Service Network.

    ## Example Usage
    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.vpclattice.get_service_network(service_network_identifier="")
    ```


    :param str service_network_identifier: Identifier of the network service.
    """
    ...
