# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ByteMatchSetByteMatchTupleArgs',
    'ByteMatchSetByteMatchTupleFieldToMatchArgs',
    'GeoMatchSetGeoMatchConstraintArgs',
    'IpSetIpSetDescriptorArgs',
    'RateBasedRulePredicateArgs',
    'RegexMatchSetRegexMatchTupleArgs',
    'RegexMatchSetRegexMatchTupleFieldToMatchArgs',
    'RuleGroupActivatedRuleArgs',
    'RuleGroupActivatedRuleActionArgs',
    'RulePredicateArgs',
    'SizeConstraintSetSizeConstraintArgs',
    'SizeConstraintSetSizeConstraintFieldToMatchArgs',
    'SqlInjectionMatchSetSqlInjectionMatchTupleArgs',
    'SqlInjectionMatchSetSqlInjectionMatchTupleFieldToMatchArgs',
    'WebAclDefaultActionArgs',
    'WebAclLoggingConfigurationArgs',
    'WebAclLoggingConfigurationRedactedFieldsArgs',
    'WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgs',
    'WebAclRuleArgs',
    'WebAclRuleActionArgs',
    'WebAclRuleOverrideActionArgs',
    'XssMatchSetXssMatchTupleArgs',
    'XssMatchSetXssMatchTupleFieldToMatchArgs',
]

@pulumi.input_type
class ByteMatchSetByteMatchTupleArgs:
    def __init__(__self__, *,
                 field_to_match: pulumi.Input['ByteMatchSetByteMatchTupleFieldToMatchArgs'],
                 positional_constraint: pulumi.Input[str],
                 text_transformation: pulumi.Input[str],
                 target_string: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['ByteMatchSetByteMatchTupleFieldToMatchArgs'] field_to_match: The part of a web request that you want to search, such as a specified header or a query string.
        :param pulumi.Input[str] positional_constraint: Within the portion of a web request that you want to search
               (for example, in the query string, if any), specify where you want to search.
               e.g., `CONTAINS`, `CONTAINS_WORD` or `EXACTLY`.
               See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_ByteMatchTuple.html#WAF-Type-ByteMatchTuple-PositionalConstraint)
               for all supported values.
        :param pulumi.Input[str] text_transformation: Text transformations used to eliminate unusual formatting that attackers use in web requests in an effort to bypass AWS WAF.
               If you specify a transformation, AWS WAF performs the transformation on `target_string` before inspecting a request for a match.
               e.g., `CMD_LINE`, `HTML_ENTITY_DECODE` or `NONE`.
               See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_ByteMatchTuple.html#WAF-Type-ByteMatchTuple-TextTransformation)
               for all supported values.
        :param pulumi.Input[str] target_string: The value that you want to search for within the field specified by `field_to_match`, e.g., `badrefer1`.
               See [docs](https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_ByteMatchTuple.html)
               for all supported values.
        """
        pulumi.set(__self__, "field_to_match", field_to_match)
        pulumi.set(__self__, "positional_constraint", positional_constraint)
        pulumi.set(__self__, "text_transformation", text_transformation)
        if target_string is not None:
            pulumi.set(__self__, "target_string", target_string)

    @property
    @pulumi.getter(name="fieldToMatch")
    def field_to_match(self) -> pulumi.Input['ByteMatchSetByteMatchTupleFieldToMatchArgs']:
        """
        The part of a web request that you want to search, such as a specified header or a query string.
        """
        return pulumi.get(self, "field_to_match")

    @field_to_match.setter
    def field_to_match(self, value: pulumi.Input['ByteMatchSetByteMatchTupleFieldToMatchArgs']):
        pulumi.set(self, "field_to_match", value)

    @property
    @pulumi.getter(name="positionalConstraint")
    def positional_constraint(self) -> pulumi.Input[str]:
        """
        Within the portion of a web request that you want to search
        (for example, in the query string, if any), specify where you want to search.
        e.g., `CONTAINS`, `CONTAINS_WORD` or `EXACTLY`.
        See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_ByteMatchTuple.html#WAF-Type-ByteMatchTuple-PositionalConstraint)
        for all supported values.
        """
        return pulumi.get(self, "positional_constraint")

    @positional_constraint.setter
    def positional_constraint(self, value: pulumi.Input[str]):
        pulumi.set(self, "positional_constraint", value)

    @property
    @pulumi.getter(name="textTransformation")
    def text_transformation(self) -> pulumi.Input[str]:
        """
        Text transformations used to eliminate unusual formatting that attackers use in web requests in an effort to bypass AWS WAF.
        If you specify a transformation, AWS WAF performs the transformation on `target_string` before inspecting a request for a match.
        e.g., `CMD_LINE`, `HTML_ENTITY_DECODE` or `NONE`.
        See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_ByteMatchTuple.html#WAF-Type-ByteMatchTuple-TextTransformation)
        for all supported values.
        """
        return pulumi.get(self, "text_transformation")

    @text_transformation.setter
    def text_transformation(self, value: pulumi.Input[str]):
        pulumi.set(self, "text_transformation", value)

    @property
    @pulumi.getter(name="targetString")
    def target_string(self) -> Optional[pulumi.Input[str]]:
        """
        The value that you want to search for within the field specified by `field_to_match`, e.g., `badrefer1`.
        See [docs](https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_ByteMatchTuple.html)
        for all supported values.
        """
        return pulumi.get(self, "target_string")

    @target_string.setter
    def target_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_string", value)


@pulumi.input_type
class ByteMatchSetByteMatchTupleFieldToMatchArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 data: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: The part of the web request that you want AWS WAF to search for a specified string.
               e.g., `HEADER`, `METHOD` or `BODY`.
               See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_FieldToMatch.html)
               for all supported values.
        :param pulumi.Input[str] data: When `type` is `HEADER`, enter the name of the header that you want to search, e.g., `User-Agent` or `Referer`.
               If `type` is any other value, omit this field.
        """
        pulumi.set(__self__, "type", type)
        if data is not None:
            pulumi.set(__self__, "data", data)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The part of the web request that you want AWS WAF to search for a specified string.
        e.g., `HEADER`, `METHOD` or `BODY`.
        See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_FieldToMatch.html)
        for all supported values.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[str]]:
        """
        When `type` is `HEADER`, enter the name of the header that you want to search, e.g., `User-Agent` or `Referer`.
        If `type` is any other value, omit this field.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data", value)


@pulumi.input_type
class GeoMatchSetGeoMatchConstraintArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] type: The type of geographical area you want AWS WAF to search for. Currently Country is the only valid value.
        :param pulumi.Input[str] value: The country that you want AWS WAF to search for.
               This is the two-letter country code, e.g., `US`, `CA`, `RU`, `CN`, etc.
               See [docs](https://docs.aws.amazon.com/waf/latest/APIReference/API_GeoMatchConstraint.html) for all supported values.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of geographical area you want AWS WAF to search for. Currently Country is the only valid value.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The country that you want AWS WAF to search for.
        This is the two-letter country code, e.g., `US`, `CA`, `RU`, `CN`, etc.
        See [docs](https://docs.aws.amazon.com/waf/latest/APIReference/API_GeoMatchConstraint.html) for all supported values.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class IpSetIpSetDescriptorArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] type: Type of the IP address - `IPV4` or `IPV6`.
        :param pulumi.Input[str] value: An IPv4 or IPv6 address specified via CIDR notationE.g., `192.0.2.44/32` or `1111:0000:0000:0000:0000:0000:0000:0000/64`
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of the IP address - `IPV4` or `IPV6`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        An IPv4 or IPv6 address specified via CIDR notationE.g., `192.0.2.44/32` or `1111:0000:0000:0000:0000:0000:0000:0000/64`
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class RateBasedRulePredicateArgs:
    def __init__(__self__, *,
                 data_id: pulumi.Input[str],
                 negated: pulumi.Input[bool],
                 type: pulumi.Input[str]):
        """
        :param pulumi.Input[str] data_id: A unique identifier for a predicate in the rule, such as Byte Match Set ID or IPSet ID.
        :param pulumi.Input[bool] negated: Set this to `false` if you want to allow, block, or count requests
               based on the settings in the specified `ByteMatchSet`, `IPSet`, `SqlInjectionMatchSet`, `XssMatchSet`, or `SizeConstraintSet`.
               For example, if an IPSet includes the IP address `192.0.2.44`, AWS WAF will allow or block requests based on that IP address.
               If set to `true`, AWS WAF will allow, block, or count requests based on all IP addresses _except_ `192.0.2.44`.
        :param pulumi.Input[str] type: The type of predicate in a rule. Valid values: `ByteMatch`, `GeoMatch`, `IPMatch`, `RegexMatch`, `SizeConstraint`, `SqlInjectionMatch`, or `XssMatch`.
        """
        pulumi.set(__self__, "data_id", data_id)
        pulumi.set(__self__, "negated", negated)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="dataId")
    def data_id(self) -> pulumi.Input[str]:
        """
        A unique identifier for a predicate in the rule, such as Byte Match Set ID or IPSet ID.
        """
        return pulumi.get(self, "data_id")

    @data_id.setter
    def data_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_id", value)

    @property
    @pulumi.getter
    def negated(self) -> pulumi.Input[bool]:
        """
        Set this to `false` if you want to allow, block, or count requests
        based on the settings in the specified `ByteMatchSet`, `IPSet`, `SqlInjectionMatchSet`, `XssMatchSet`, or `SizeConstraintSet`.
        For example, if an IPSet includes the IP address `192.0.2.44`, AWS WAF will allow or block requests based on that IP address.
        If set to `true`, AWS WAF will allow, block, or count requests based on all IP addresses _except_ `192.0.2.44`.
        """
        return pulumi.get(self, "negated")

    @negated.setter
    def negated(self, value: pulumi.Input[bool]):
        pulumi.set(self, "negated", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of predicate in a rule. Valid values: `ByteMatch`, `GeoMatch`, `IPMatch`, `RegexMatch`, `SizeConstraint`, `SqlInjectionMatch`, or `XssMatch`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class RegexMatchSetRegexMatchTupleArgs:
    def __init__(__self__, *,
                 field_to_match: pulumi.Input['RegexMatchSetRegexMatchTupleFieldToMatchArgs'],
                 regex_pattern_set_id: pulumi.Input[str],
                 text_transformation: pulumi.Input[str]):
        """
        :param pulumi.Input['RegexMatchSetRegexMatchTupleFieldToMatchArgs'] field_to_match: The part of a web request that you want to search, such as a specified header or a query string.
        :param pulumi.Input[str] regex_pattern_set_id: The ID of a Regex Pattern Set.
        :param pulumi.Input[str] text_transformation: Text transformations used to eliminate unusual formatting that attackers use in web requests in an effort to bypass AWS WAF.
               e.g., `CMD_LINE`, `HTML_ENTITY_DECODE` or `NONE`.
               See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_ByteMatchTuple.html#WAF-Type-ByteMatchTuple-TextTransformation)
               for all supported values.
        """
        pulumi.set(__self__, "field_to_match", field_to_match)
        pulumi.set(__self__, "regex_pattern_set_id", regex_pattern_set_id)
        pulumi.set(__self__, "text_transformation", text_transformation)

    @property
    @pulumi.getter(name="fieldToMatch")
    def field_to_match(self) -> pulumi.Input['RegexMatchSetRegexMatchTupleFieldToMatchArgs']:
        """
        The part of a web request that you want to search, such as a specified header or a query string.
        """
        return pulumi.get(self, "field_to_match")

    @field_to_match.setter
    def field_to_match(self, value: pulumi.Input['RegexMatchSetRegexMatchTupleFieldToMatchArgs']):
        pulumi.set(self, "field_to_match", value)

    @property
    @pulumi.getter(name="regexPatternSetId")
    def regex_pattern_set_id(self) -> pulumi.Input[str]:
        """
        The ID of a Regex Pattern Set.
        """
        return pulumi.get(self, "regex_pattern_set_id")

    @regex_pattern_set_id.setter
    def regex_pattern_set_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "regex_pattern_set_id", value)

    @property
    @pulumi.getter(name="textTransformation")
    def text_transformation(self) -> pulumi.Input[str]:
        """
        Text transformations used to eliminate unusual formatting that attackers use in web requests in an effort to bypass AWS WAF.
        e.g., `CMD_LINE`, `HTML_ENTITY_DECODE` or `NONE`.
        See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_ByteMatchTuple.html#WAF-Type-ByteMatchTuple-TextTransformation)
        for all supported values.
        """
        return pulumi.get(self, "text_transformation")

    @text_transformation.setter
    def text_transformation(self, value: pulumi.Input[str]):
        pulumi.set(self, "text_transformation", value)


@pulumi.input_type
class RegexMatchSetRegexMatchTupleFieldToMatchArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 data: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: The part of the web request that you want AWS WAF to search for a specified string.
               e.g., `HEADER`, `METHOD` or `BODY`.
               See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_FieldToMatch.html)
               for all supported values.
        :param pulumi.Input[str] data: When `type` is `HEADER`, enter the name of the header that you want to search, e.g., `User-Agent` or `Referer`.
               If `type` is any other value, omit this field.
        """
        pulumi.set(__self__, "type", type)
        if data is not None:
            pulumi.set(__self__, "data", data)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The part of the web request that you want AWS WAF to search for a specified string.
        e.g., `HEADER`, `METHOD` or `BODY`.
        See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_FieldToMatch.html)
        for all supported values.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[str]]:
        """
        When `type` is `HEADER`, enter the name of the header that you want to search, e.g., `User-Agent` or `Referer`.
        If `type` is any other value, omit this field.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data", value)


@pulumi.input_type
class RuleGroupActivatedRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input['RuleGroupActivatedRuleActionArgs'],
                 priority: pulumi.Input[int],
                 rule_id: pulumi.Input[str],
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['RuleGroupActivatedRuleActionArgs'] action: Specifies the action that CloudFront or AWS WAF takes when a web request matches the conditions in the rule.
        :param pulumi.Input[int] priority: Specifies the order in which the rules are evaluated. Rules with a lower value are evaluated before rules with a higher value.
        :param pulumi.Input[str] rule_id: The ID of a rule
        :param pulumi.Input[str] type: e.g., `BLOCK`, `ALLOW`, or `COUNT`
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "rule_id", rule_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input['RuleGroupActivatedRuleActionArgs']:
        """
        Specifies the action that CloudFront or AWS WAF takes when a web request matches the conditions in the rule.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input['RuleGroupActivatedRuleActionArgs']):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Input[int]:
        """
        Specifies the order in which the rules are evaluated. Rules with a lower value are evaluated before rules with a higher value.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[int]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> pulumi.Input[str]:
        """
        The ID of a rule
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        e.g., `BLOCK`, `ALLOW`, or `COUNT`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class RuleGroupActivatedRuleActionArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str]):
        """
        :param pulumi.Input[str] type: e.g., `BLOCK`, `ALLOW`, or `COUNT`
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        e.g., `BLOCK`, `ALLOW`, or `COUNT`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class RulePredicateArgs:
    def __init__(__self__, *,
                 data_id: pulumi.Input[str],
                 negated: pulumi.Input[bool],
                 type: pulumi.Input[str]):
        """
        :param pulumi.Input[str] data_id: A unique identifier for a predicate in the rule, such as Byte Match Set ID or IPSet ID.
        :param pulumi.Input[bool] negated: Set this to `false` if you want to allow, block, or count requests
               based on the settings in the specified waf_byte_match_set, waf_ipset, aws_waf_size_constraint_set, waf.SqlInjectionMatchSet or aws_waf_xss_match_set.
               For example, if an IPSet includes the IP address `192.0.2.44`, AWS WAF will allow or block requests based on that IP address.
               If set to `true`, AWS WAF will allow, block, or count requests based on all IP addresses except `192.0.2.44`.
        :param pulumi.Input[str] type: The type of predicate in a rule. Valid values: `ByteMatch`, `GeoMatch`, `IPMatch`, `RegexMatch`, `SizeConstraint`, `SqlInjectionMatch`, or `XssMatch`.
        """
        pulumi.set(__self__, "data_id", data_id)
        pulumi.set(__self__, "negated", negated)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="dataId")
    def data_id(self) -> pulumi.Input[str]:
        """
        A unique identifier for a predicate in the rule, such as Byte Match Set ID or IPSet ID.
        """
        return pulumi.get(self, "data_id")

    @data_id.setter
    def data_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_id", value)

    @property
    @pulumi.getter
    def negated(self) -> pulumi.Input[bool]:
        """
        Set this to `false` if you want to allow, block, or count requests
        based on the settings in the specified waf_byte_match_set, waf_ipset, aws_waf_size_constraint_set, waf.SqlInjectionMatchSet or aws_waf_xss_match_set.
        For example, if an IPSet includes the IP address `192.0.2.44`, AWS WAF will allow or block requests based on that IP address.
        If set to `true`, AWS WAF will allow, block, or count requests based on all IP addresses except `192.0.2.44`.
        """
        return pulumi.get(self, "negated")

    @negated.setter
    def negated(self, value: pulumi.Input[bool]):
        pulumi.set(self, "negated", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of predicate in a rule. Valid values: `ByteMatch`, `GeoMatch`, `IPMatch`, `RegexMatch`, `SizeConstraint`, `SqlInjectionMatch`, or `XssMatch`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class SizeConstraintSetSizeConstraintArgs:
    def __init__(__self__, *,
                 comparison_operator: pulumi.Input[str],
                 field_to_match: pulumi.Input['SizeConstraintSetSizeConstraintFieldToMatchArgs'],
                 size: pulumi.Input[int],
                 text_transformation: pulumi.Input[str]):
        """
        :param pulumi.Input[str] comparison_operator: The type of comparison you want to perform.
               e.g., `EQ`, `NE`, `LT`, `GT`.
               See [docs](https://docs.aws.amazon.com/waf/latest/APIReference/API_wafRegional_SizeConstraint.html) for all supported values.
        :param pulumi.Input['SizeConstraintSetSizeConstraintFieldToMatchArgs'] field_to_match: Specifies where in a web request to look for the size constraint.
        :param pulumi.Input[int] size: The size in bytes that you want to compare against the size of the specified `field_to_match`.
               Valid values are between 0 - 21474836480 bytes (0 - 20 GB).
        :param pulumi.Input[str] text_transformation: Text transformations used to eliminate unusual formatting that attackers use in web requests in an effort to bypass AWS WAF.
               If you specify a transformation, AWS WAF performs the transformation on `field_to_match` before inspecting a request for a match.
               e.g., `CMD_LINE`, `HTML_ENTITY_DECODE` or `NONE`.
               See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_SizeConstraint.html#WAF-Type-SizeConstraint-TextTransformation)
               for all supported values.
               **Note:** if you choose `BODY` as `type`, you must choose `NONE` because CloudFront forwards only the first 8192 bytes for inspection.
        """
        pulumi.set(__self__, "comparison_operator", comparison_operator)
        pulumi.set(__self__, "field_to_match", field_to_match)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "text_transformation", text_transformation)

    @property
    @pulumi.getter(name="comparisonOperator")
    def comparison_operator(self) -> pulumi.Input[str]:
        """
        The type of comparison you want to perform.
        e.g., `EQ`, `NE`, `LT`, `GT`.
        See [docs](https://docs.aws.amazon.com/waf/latest/APIReference/API_wafRegional_SizeConstraint.html) for all supported values.
        """
        return pulumi.get(self, "comparison_operator")

    @comparison_operator.setter
    def comparison_operator(self, value: pulumi.Input[str]):
        pulumi.set(self, "comparison_operator", value)

    @property
    @pulumi.getter(name="fieldToMatch")
    def field_to_match(self) -> pulumi.Input['SizeConstraintSetSizeConstraintFieldToMatchArgs']:
        """
        Specifies where in a web request to look for the size constraint.
        """
        return pulumi.get(self, "field_to_match")

    @field_to_match.setter
    def field_to_match(self, value: pulumi.Input['SizeConstraintSetSizeConstraintFieldToMatchArgs']):
        pulumi.set(self, "field_to_match", value)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[int]:
        """
        The size in bytes that you want to compare against the size of the specified `field_to_match`.
        Valid values are between 0 - 21474836480 bytes (0 - 20 GB).
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="textTransformation")
    def text_transformation(self) -> pulumi.Input[str]:
        """
        Text transformations used to eliminate unusual formatting that attackers use in web requests in an effort to bypass AWS WAF.
        If you specify a transformation, AWS WAF performs the transformation on `field_to_match` before inspecting a request for a match.
        e.g., `CMD_LINE`, `HTML_ENTITY_DECODE` or `NONE`.
        See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_SizeConstraint.html#WAF-Type-SizeConstraint-TextTransformation)
        for all supported values.
        **Note:** if you choose `BODY` as `type`, you must choose `NONE` because CloudFront forwards only the first 8192 bytes for inspection.
        """
        return pulumi.get(self, "text_transformation")

    @text_transformation.setter
    def text_transformation(self, value: pulumi.Input[str]):
        pulumi.set(self, "text_transformation", value)


@pulumi.input_type
class SizeConstraintSetSizeConstraintFieldToMatchArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 data: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: The part of the web request that you want AWS WAF to search for a specified string.
               e.g., `HEADER`, `METHOD` or `BODY`.
               See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_FieldToMatch.html)
               for all supported values.
        :param pulumi.Input[str] data: When `type` is `HEADER`, enter the name of the header that you want to search, e.g., `User-Agent` or `Referer`.
               If `type` is any other value, omit this field.
        """
        pulumi.set(__self__, "type", type)
        if data is not None:
            pulumi.set(__self__, "data", data)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The part of the web request that you want AWS WAF to search for a specified string.
        e.g., `HEADER`, `METHOD` or `BODY`.
        See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_FieldToMatch.html)
        for all supported values.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[str]]:
        """
        When `type` is `HEADER`, enter the name of the header that you want to search, e.g., `User-Agent` or `Referer`.
        If `type` is any other value, omit this field.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data", value)


@pulumi.input_type
class SqlInjectionMatchSetSqlInjectionMatchTupleArgs:
    def __init__(__self__, *,
                 field_to_match: pulumi.Input['SqlInjectionMatchSetSqlInjectionMatchTupleFieldToMatchArgs'],
                 text_transformation: pulumi.Input[str]):
        """
        :param pulumi.Input['SqlInjectionMatchSetSqlInjectionMatchTupleFieldToMatchArgs'] field_to_match: Specifies where in a web request to look for snippets of malicious SQL code.
        :param pulumi.Input[str] text_transformation: Text transformations used to eliminate unusual formatting that attackers use in web requests in an effort to bypass AWS WAF.
               If you specify a transformation, AWS WAF performs the transformation on `field_to_match` before inspecting a request for a match.
               e.g., `CMD_LINE`, `HTML_ENTITY_DECODE` or `NONE`.
               See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_SqlInjectionMatchTuple.html#WAF-Type-SqlInjectionMatchTuple-TextTransformation)
               for all supported values.
        """
        pulumi.set(__self__, "field_to_match", field_to_match)
        pulumi.set(__self__, "text_transformation", text_transformation)

    @property
    @pulumi.getter(name="fieldToMatch")
    def field_to_match(self) -> pulumi.Input['SqlInjectionMatchSetSqlInjectionMatchTupleFieldToMatchArgs']:
        """
        Specifies where in a web request to look for snippets of malicious SQL code.
        """
        return pulumi.get(self, "field_to_match")

    @field_to_match.setter
    def field_to_match(self, value: pulumi.Input['SqlInjectionMatchSetSqlInjectionMatchTupleFieldToMatchArgs']):
        pulumi.set(self, "field_to_match", value)

    @property
    @pulumi.getter(name="textTransformation")
    def text_transformation(self) -> pulumi.Input[str]:
        """
        Text transformations used to eliminate unusual formatting that attackers use in web requests in an effort to bypass AWS WAF.
        If you specify a transformation, AWS WAF performs the transformation on `field_to_match` before inspecting a request for a match.
        e.g., `CMD_LINE`, `HTML_ENTITY_DECODE` or `NONE`.
        See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_SqlInjectionMatchTuple.html#WAF-Type-SqlInjectionMatchTuple-TextTransformation)
        for all supported values.
        """
        return pulumi.get(self, "text_transformation")

    @text_transformation.setter
    def text_transformation(self, value: pulumi.Input[str]):
        pulumi.set(self, "text_transformation", value)


@pulumi.input_type
class SqlInjectionMatchSetSqlInjectionMatchTupleFieldToMatchArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 data: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: The part of the web request that you want AWS WAF to search for a specified string.
               e.g., `HEADER`, `METHOD` or `BODY`.
               See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_FieldToMatch.html)
               for all supported values.
        :param pulumi.Input[str] data: When `type` is `HEADER`, enter the name of the header that you want to search, e.g., `User-Agent` or `Referer`.
               If `type` is any other value, omit this field.
        """
        pulumi.set(__self__, "type", type)
        if data is not None:
            pulumi.set(__self__, "data", data)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The part of the web request that you want AWS WAF to search for a specified string.
        e.g., `HEADER`, `METHOD` or `BODY`.
        See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_FieldToMatch.html)
        for all supported values.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[str]]:
        """
        When `type` is `HEADER`, enter the name of the header that you want to search, e.g., `User-Agent` or `Referer`.
        If `type` is any other value, omit this field.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data", value)


@pulumi.input_type
class WebAclDefaultActionArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str]):
        """
        :param pulumi.Input[str] type: Specifies how you want AWS WAF to respond to requests that don't match the criteria in any of the `rules`.
               e.g., `ALLOW` or `BLOCK`
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies how you want AWS WAF to respond to requests that don't match the criteria in any of the `rules`.
        e.g., `ALLOW` or `BLOCK`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class WebAclLoggingConfigurationArgs:
    def __init__(__self__, *,
                 log_destination: pulumi.Input[str],
                 redacted_fields: Optional[pulumi.Input['WebAclLoggingConfigurationRedactedFieldsArgs']] = None):
        """
        :param pulumi.Input[str] log_destination: Amazon Resource Name (ARN) of Kinesis Firehose Delivery Stream
        :param pulumi.Input['WebAclLoggingConfigurationRedactedFieldsArgs'] redacted_fields: Configuration block containing parts of the request that you want redacted from the logs. Detailed below.
        """
        pulumi.set(__self__, "log_destination", log_destination)
        if redacted_fields is not None:
            pulumi.set(__self__, "redacted_fields", redacted_fields)

    @property
    @pulumi.getter(name="logDestination")
    def log_destination(self) -> pulumi.Input[str]:
        """
        Amazon Resource Name (ARN) of Kinesis Firehose Delivery Stream
        """
        return pulumi.get(self, "log_destination")

    @log_destination.setter
    def log_destination(self, value: pulumi.Input[str]):
        pulumi.set(self, "log_destination", value)

    @property
    @pulumi.getter(name="redactedFields")
    def redacted_fields(self) -> Optional[pulumi.Input['WebAclLoggingConfigurationRedactedFieldsArgs']]:
        """
        Configuration block containing parts of the request that you want redacted from the logs. Detailed below.
        """
        return pulumi.get(self, "redacted_fields")

    @redacted_fields.setter
    def redacted_fields(self, value: Optional[pulumi.Input['WebAclLoggingConfigurationRedactedFieldsArgs']]):
        pulumi.set(self, "redacted_fields", value)


@pulumi.input_type
class WebAclLoggingConfigurationRedactedFieldsArgs:
    def __init__(__self__, *,
                 field_to_matches: pulumi.Input[Sequence[pulumi.Input['WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgs']]] field_to_matches: Set of configuration blocks for fields to redact. Detailed below.
        """
        pulumi.set(__self__, "field_to_matches", field_to_matches)

    @property
    @pulumi.getter(name="fieldToMatches")
    def field_to_matches(self) -> pulumi.Input[Sequence[pulumi.Input['WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgs']]]:
        """
        Set of configuration blocks for fields to redact. Detailed below.
        """
        return pulumi.get(self, "field_to_matches")

    @field_to_matches.setter
    def field_to_matches(self, value: pulumi.Input[Sequence[pulumi.Input['WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgs']]]):
        pulumi.set(self, "field_to_matches", value)


@pulumi.input_type
class WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 data: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: The part of the web request that you want AWS WAF to search for a specified stringE.g., `HEADER` or `METHOD`
        :param pulumi.Input[str] data: When the value of `type` is `HEADER`, enter the name of the header that you want the WAF to search, for example, `User-Agent` or `Referer`. If the value of `type` is any other value, omit `data`.
        """
        pulumi.set(__self__, "type", type)
        if data is not None:
            pulumi.set(__self__, "data", data)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The part of the web request that you want AWS WAF to search for a specified stringE.g., `HEADER` or `METHOD`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[str]]:
        """
        When the value of `type` is `HEADER`, enter the name of the header that you want the WAF to search, for example, `User-Agent` or `Referer`. If the value of `type` is any other value, omit `data`.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data", value)


@pulumi.input_type
class WebAclRuleArgs:
    def __init__(__self__, *,
                 priority: pulumi.Input[int],
                 rule_id: pulumi.Input[str],
                 action: Optional[pulumi.Input['WebAclRuleActionArgs']] = None,
                 override_action: Optional[pulumi.Input['WebAclRuleOverrideActionArgs']] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] priority: Specifies the order in which the rules in a WebACL are evaluated.
               Rules with a lower value are evaluated before rules with a higher value.
        :param pulumi.Input[str] rule_id: ID of the associated WAF (Global) rule (e.g., `waf.Rule`). WAF (Regional) rules cannot be used.
        :param pulumi.Input['WebAclRuleActionArgs'] action: The action that CloudFront or AWS WAF takes when a web request matches the conditions in the rule. Not used if `type` is `GROUP`.
        :param pulumi.Input['WebAclRuleOverrideActionArgs'] override_action: Override the action that a group requests CloudFront or AWS WAF takes when a web request matches the conditions in the rule. Only used if `type` is `GROUP`.
        :param pulumi.Input[str] type: The rule type, either `REGULAR`, as defined by [Rule](http://docs.aws.amazon.com/waf/latest/APIReference/API_Rule.html), `RATE_BASED`, as defined by [RateBasedRule](http://docs.aws.amazon.com/waf/latest/APIReference/API_RateBasedRule.html), or `GROUP`, as defined by [RuleGroup](https://docs.aws.amazon.com/waf/latest/APIReference/API_RuleGroup.html). The default is REGULAR. If you add a RATE_BASED rule, you need to set `type` as `RATE_BASED`. If you add a GROUP rule, you need to set `type` as `GROUP`.
        """
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "rule_id", rule_id)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if override_action is not None:
            pulumi.set(__self__, "override_action", override_action)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Input[int]:
        """
        Specifies the order in which the rules in a WebACL are evaluated.
        Rules with a lower value are evaluated before rules with a higher value.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[int]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> pulumi.Input[str]:
        """
        ID of the associated WAF (Global) rule (e.g., `waf.Rule`). WAF (Regional) rules cannot be used.
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_id", value)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input['WebAclRuleActionArgs']]:
        """
        The action that CloudFront or AWS WAF takes when a web request matches the conditions in the rule. Not used if `type` is `GROUP`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input['WebAclRuleActionArgs']]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="overrideAction")
    def override_action(self) -> Optional[pulumi.Input['WebAclRuleOverrideActionArgs']]:
        """
        Override the action that a group requests CloudFront or AWS WAF takes when a web request matches the conditions in the rule. Only used if `type` is `GROUP`.
        """
        return pulumi.get(self, "override_action")

    @override_action.setter
    def override_action(self, value: Optional[pulumi.Input['WebAclRuleOverrideActionArgs']]):
        pulumi.set(self, "override_action", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The rule type, either `REGULAR`, as defined by [Rule](http://docs.aws.amazon.com/waf/latest/APIReference/API_Rule.html), `RATE_BASED`, as defined by [RateBasedRule](http://docs.aws.amazon.com/waf/latest/APIReference/API_RateBasedRule.html), or `GROUP`, as defined by [RuleGroup](https://docs.aws.amazon.com/waf/latest/APIReference/API_RuleGroup.html). The default is REGULAR. If you add a RATE_BASED rule, you need to set `type` as `RATE_BASED`. If you add a GROUP rule, you need to set `type` as `GROUP`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class WebAclRuleActionArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str]):
        """
        :param pulumi.Input[str] type: Specifies how you want AWS WAF to respond to requests that don't match the criteria in any of the `rules`.
               e.g., `ALLOW` or `BLOCK`
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies how you want AWS WAF to respond to requests that don't match the criteria in any of the `rules`.
        e.g., `ALLOW` or `BLOCK`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class WebAclRuleOverrideActionArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str]):
        """
        :param pulumi.Input[str] type: Specifies how you want AWS WAF to respond to requests that don't match the criteria in any of the `rules`.
               e.g., `ALLOW` or `BLOCK`
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies how you want AWS WAF to respond to requests that don't match the criteria in any of the `rules`.
        e.g., `ALLOW` or `BLOCK`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class XssMatchSetXssMatchTupleArgs:
    def __init__(__self__, *,
                 field_to_match: pulumi.Input['XssMatchSetXssMatchTupleFieldToMatchArgs'],
                 text_transformation: pulumi.Input[str]):
        """
        :param pulumi.Input['XssMatchSetXssMatchTupleFieldToMatchArgs'] field_to_match: Specifies where in a web request to look for cross-site scripting attacks.
        :param pulumi.Input[str] text_transformation: Text transformations used to eliminate unusual formatting that attackers use in web requests in an effort to bypass AWS WAF.
               If you specify a transformation, AWS WAF performs the transformation on `target_string` before inspecting a request for a match.
               e.g., `CMD_LINE`, `HTML_ENTITY_DECODE` or `NONE`.
               See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_XssMatchTuple.html#WAF-Type-XssMatchTuple-TextTransformation)
               for all supported values.
        """
        pulumi.set(__self__, "field_to_match", field_to_match)
        pulumi.set(__self__, "text_transformation", text_transformation)

    @property
    @pulumi.getter(name="fieldToMatch")
    def field_to_match(self) -> pulumi.Input['XssMatchSetXssMatchTupleFieldToMatchArgs']:
        """
        Specifies where in a web request to look for cross-site scripting attacks.
        """
        return pulumi.get(self, "field_to_match")

    @field_to_match.setter
    def field_to_match(self, value: pulumi.Input['XssMatchSetXssMatchTupleFieldToMatchArgs']):
        pulumi.set(self, "field_to_match", value)

    @property
    @pulumi.getter(name="textTransformation")
    def text_transformation(self) -> pulumi.Input[str]:
        """
        Text transformations used to eliminate unusual formatting that attackers use in web requests in an effort to bypass AWS WAF.
        If you specify a transformation, AWS WAF performs the transformation on `target_string` before inspecting a request for a match.
        e.g., `CMD_LINE`, `HTML_ENTITY_DECODE` or `NONE`.
        See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_XssMatchTuple.html#WAF-Type-XssMatchTuple-TextTransformation)
        for all supported values.
        """
        return pulumi.get(self, "text_transformation")

    @text_transformation.setter
    def text_transformation(self, value: pulumi.Input[str]):
        pulumi.set(self, "text_transformation", value)


@pulumi.input_type
class XssMatchSetXssMatchTupleFieldToMatchArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 data: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: The part of the web request that you want AWS WAF to search for a specified string.
               e.g., `HEADER`, `METHOD` or `BODY`.
               See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_FieldToMatch.html)
               for all supported values.
        :param pulumi.Input[str] data: When `type` is `HEADER`, enter the name of the header that you want to search, e.g., `User-Agent` or `Referer`.
               If `type` is any other value, omit this field.
        """
        pulumi.set(__self__, "type", type)
        if data is not None:
            pulumi.set(__self__, "data", data)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The part of the web request that you want AWS WAF to search for a specified string.
        e.g., `HEADER`, `METHOD` or `BODY`.
        See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_FieldToMatch.html)
        for all supported values.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[str]]:
        """
        When `type` is `HEADER`, enter the name of the header that you want to search, e.g., `User-Agent` or `Referer`.
        If `type` is any other value, omit this field.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data", value)


