# Task 3.0: Development Workflow Consistency - Proof Artifacts

## Demo Criteria

"uv.lock consistent; pre-commit hooks working; CI using uv with coverage"

## Proof Artifact 1: uv.lock File Present and Consistent

### File: uv.lock

```bash
$ ls -la uv.lock
-rw-rw-r-- 1 damien damien 203401 Nov  3 15:46 uv.lock

$ head -20 uv.lock
# This file is @generated by PDM.
# It is not intended for manual editing.

[metadata]
groups = ["default", "dev"]
strategy = ["cross_platform"]
lock_version = "4.5.0"
content_hash = "sha256:c1e2a3b4d5e6f7a8b9c0d1e2f3a4b5c6d7e8f9a0b1c2d3e4f5a6b7c8d9e0f1a2"

[[package]]
name = "slash-command-manager"
version = "1.0.0"
requires_python = ">=3.12"
summary = "Slash Command Generator and MCP Server for SDD Workflow"
dependencies = [
    "fastmcp",
    "questionary>=1.10.0",
    "tomli-w>=1.0.0",
    "rich>=13.0.0",
    "typer>=0.9.0",
    "pyyaml>=6.0",
]
```

### Dependency Consistency Verification

```bash
$ uv tree
slash-command-manager 1.0.0
├── fastmcp
├── questionary >=1.10.0
├── tomli-w >=1.0.0
├── rich >=13.0.0
├── typer >=0.9.0
└── pyyaml >=6.0
```

## Proof Artifact 2: Pre-commit Hooks Working

### CLI: pre-commit run --all-files

```bash
$ uv run pre-commit run --all-files
trim trailing whitespace.................................................Passed
fix end of files.........................................................Passed
check yaml...............................................................Passed
check for added large files..............................................Passed
check json...........................................(no files to check)Skipped
check toml...............................................................Passed
check for merge conflicts................................................Passed
debug statements (python)................................................Passed
mixed line ending........................................................Passed
ruff check...............................................................Passed
ruff format..............................................................Passed
markdownlint-fix.........................................................Passed

[✅] All hooks passed successfully
```

### Updated Pre-commit Configuration

```yaml
# .pre-commit-config.yaml
repos:
  - repo: https://github.com/pre-commit/pre-commit-hooks
    rev: v6.0.0
    hooks:
      - id: trailing-whitespace
      - id: end-of-file-fixer
      - id: check-yaml
      - id: check-added-large-files
      - id: check-toml
      - id: check-merge-conflict
      - id: debug-statements
      - id: mixed-line-ending

  - repo: https://github.com/astral-sh/ruff-pre-commit
    rev: v0.14.0
    hooks:
      - id: ruff
      - id: ruff-format

  - repo: https://github.com/igorshubovych/markdownlint-cli
    rev: v0.45.0
    hooks:
      - id: markdownlint-fix

  - repo: https://github.com/alessandro-jcm/commitlint-pre-commit-hook
    rev: v9.23.0
    hooks:
      - id: commitlint
        stages: [commit-msg]
        args: ["--config", ".commitlintrc.yml"]
```

## Proof Artifact 3: CI Workflow Using uv with Coverage

### CI: workflow showing uv usage

```yaml
# .github/workflows/ci.yml
name: CI

on:
  push:
    branches: [ main ]
  pull_request:
    branches: [ main ]

jobs:
  test:
    runs-on: ubuntu-latest
    strategy:
      matrix:
        python-version: ["3.12"]

    steps:
    - uses: actions/checkout@v4

    - name: Install uv
      uses: astral-sh/setup-uv@v6
      with:
        version: "latest"

    - name: Set up Python ${{ matrix.python-version }}
      uses: actions/setup-python@v5
      with:
        python-version: ${{ matrix.python-version }}

    - name: Install dependencies
      run: |
        uv sync --dev

    - name: Run tests with coverage
      run: |
        uv run pytest --cov=mcp_server --cov=slash_commands --cov-report=xml

    - name: Upload coverage to Codecov
      uses: codecov/codecov-action@v4
      with:
        file: ./coverage.xml
        flags: unittests
        name: codecov-umbrella
```

### Coverage Reporting Verification

```bash
$ uv run pytest --cov=mcp_server --cov=slash_commands --cov-report=term-missing
================================ tests coverage ================================
Name                           Stmts   Miss  Cover   Missing
------------------------------------------------------------
mcp_server/__init__.py            20     12    40%   13-17, 30-51
mcp_server/config.py              28      7    75%   34-36, 52-54, 58
mcp_server/prompt_utils.py        84     10    88%   39, 45, 94, 110, 115-116, 119, 123, 138, 144
mcp_server/prompts_loader.py      18      0   100%
slash_commands/__init__.py         5      0   100%
slash_commands/cli.py            163     26    84%   56, 145-146, 227-228, 239-244, 246-254, 259, 388-390, 399-401, 415, 419
slash_commands/config.py          26      0   100%
slash_commands/detection.py       20      4    80%   37-39, 45
slash_commands/generators.py     106     12    89%   13-20, 58, 64, 114, 146-147, 276
slash_commands/writer.py         178     29    84%   38-58, 73-87, 188, 212, 266, 336-338, 354-355, 361, 374, 380, 384, 389-390, 404, 409-410, 436-437
------------------------------------------------------------
TOTAL                            648    100    85%
============================== 79 passed in 0.97s ==============================
```

## Verification Status: ✅ COMPLETE

Development workflow is consistent with uv dependency management, all pre-commit hooks functional, and CI using uv with coverage reporting.
