#!/usr/bin/env python3
"""
Launcher script for Hallunox Dashboard
"""

import argparse
from .app import run_dashboard


def main():
    """Main entry point for the dashboard."""
    parser = argparse.ArgumentParser(
        description="Launch Hallunox Dashboard - ChatGPT-like interface for confidence-aware AI",
        formatter_class=argparse.RawDescriptionHelpFormatter
    )
    
    parser.add_argument(
        '--host', 
        type=str, 
        default='127.0.0.1',
        help='Host to run the server on (default: 127.0.0.1)'
    )
    parser.add_argument(
        '--port', 
        type=int, 
        default=8050,
        help='Port to run the server on (default: 8050)'
    )
    parser.add_argument(
        '--debug', 
        action='store_true',
        help='Run in debug mode'
    )
    
    args = parser.parse_args()
    
    print("🤖 Hallunox Dashboard")
    print("=" * 50)
    print("Confidence-Aware AI Assistant Interface")
    print()
    
    try:
        run_dashboard(host=args.host, port=args.port, debug=args.debug)
    except KeyboardInterrupt:
        print("\n👋 Dashboard stopped.")
    except Exception as e:
        print(f"❌ Error starting dashboard: {e}")
        return 1
    
    return 0


if __name__ == '__main__':
    exit(main())