# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['CertificateArgs', 'Certificate']

@pulumi.input_type
class CertificateArgs:
    def __init__(__self__, *,
                 api_management_name: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 data: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_identity_client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Certificate resource.
        :param pulumi.Input[_builtins.str] api_management_name: The Name of the API Management Service where this Service should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The Name of the Resource Group where the API Management Service exists. Changing this forces a new resource to be created.
               
               > **Note:** Either `data` or `key_vault_secret_id` must be specified - but not both.
        :param pulumi.Input[_builtins.str] data: The base-64 encoded certificate data, which must be a PFX file.
        :param pulumi.Input[_builtins.str] key_vault_identity_client_id: The Client ID of the User Assigned Managed Identity to use for retrieving certificate.
               
               > **Note:** If not specified, will use System Assigned identity of the API Management Service.
        :param pulumi.Input[_builtins.str] key_vault_secret_id: The ID of the Key Vault Secret containing the SSL Certificate, which must be of the type `application/x-pkcs12`.
               
               > **Note:** Setting this field requires the `identity` block to be specified in API Management Service, since this identity is used to retrieve the Key Vault Certificate. Possible values are versioned or versionless secret ID. Auto-updating the Certificate from the Key Vault requires that Secret version isn't specified.
        :param pulumi.Input[_builtins.str] name: The name of the API Management Certificate. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] password: The password used for this certificate.
        """
        pulumi.set(__self__, "api_management_name", api_management_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if key_vault_identity_client_id is not None:
            pulumi.set(__self__, "key_vault_identity_client_id", key_vault_identity_client_id)
        if key_vault_secret_id is not None:
            pulumi.set(__self__, "key_vault_secret_id", key_vault_secret_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)

    @_builtins.property
    @pulumi.getter(name="apiManagementName")
    def api_management_name(self) -> pulumi.Input[_builtins.str]:
        """
        The Name of the API Management Service where this Service should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_name")

    @api_management_name.setter
    def api_management_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "api_management_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The Name of the Resource Group where the API Management Service exists. Changing this forces a new resource to be created.

        > **Note:** Either `data` or `key_vault_secret_id` must be specified - but not both.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The base-64 encoded certificate data, which must be a PFX file.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultIdentityClientId")
    def key_vault_identity_client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Client ID of the User Assigned Managed Identity to use for retrieving certificate.

        > **Note:** If not specified, will use System Assigned identity of the API Management Service.
        """
        return pulumi.get(self, "key_vault_identity_client_id")

    @key_vault_identity_client_id.setter
    def key_vault_identity_client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_vault_identity_client_id", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultSecretId")
    def key_vault_secret_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Key Vault Secret containing the SSL Certificate, which must be of the type `application/x-pkcs12`.

        > **Note:** Setting this field requires the `identity` block to be specified in API Management Service, since this identity is used to retrieve the Key Vault Certificate. Possible values are versioned or versionless secret ID. Auto-updating the Certificate from the Key Vault requires that Secret version isn't specified.
        """
        return pulumi.get(self, "key_vault_secret_id")

    @key_vault_secret_id.setter
    def key_vault_secret_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_vault_secret_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the API Management Certificate. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password used for this certificate.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)


@pulumi.input_type
class _CertificateState:
    def __init__(__self__, *,
                 api_management_name: Optional[pulumi.Input[_builtins.str]] = None,
                 data: Optional[pulumi.Input[_builtins.str]] = None,
                 expiration: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_identity_client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 subject: Optional[pulumi.Input[_builtins.str]] = None,
                 thumbprint: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Certificate resources.
        :param pulumi.Input[_builtins.str] api_management_name: The Name of the API Management Service where this Service should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] data: The base-64 encoded certificate data, which must be a PFX file.
        :param pulumi.Input[_builtins.str] expiration: The Expiration Date of this Certificate, formatted as an RFC3339 string.
        :param pulumi.Input[_builtins.str] key_vault_identity_client_id: The Client ID of the User Assigned Managed Identity to use for retrieving certificate.
               
               > **Note:** If not specified, will use System Assigned identity of the API Management Service.
        :param pulumi.Input[_builtins.str] key_vault_secret_id: The ID of the Key Vault Secret containing the SSL Certificate, which must be of the type `application/x-pkcs12`.
               
               > **Note:** Setting this field requires the `identity` block to be specified in API Management Service, since this identity is used to retrieve the Key Vault Certificate. Possible values are versioned or versionless secret ID. Auto-updating the Certificate from the Key Vault requires that Secret version isn't specified.
        :param pulumi.Input[_builtins.str] name: The name of the API Management Certificate. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] password: The password used for this certificate.
        :param pulumi.Input[_builtins.str] resource_group_name: The Name of the Resource Group where the API Management Service exists. Changing this forces a new resource to be created.
               
               > **Note:** Either `data` or `key_vault_secret_id` must be specified - but not both.
        :param pulumi.Input[_builtins.str] subject: The Subject of this Certificate.
        :param pulumi.Input[_builtins.str] thumbprint: The Thumbprint of this Certificate.
        """
        if api_management_name is not None:
            pulumi.set(__self__, "api_management_name", api_management_name)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if key_vault_identity_client_id is not None:
            pulumi.set(__self__, "key_vault_identity_client_id", key_vault_identity_client_id)
        if key_vault_secret_id is not None:
            pulumi.set(__self__, "key_vault_secret_id", key_vault_secret_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @_builtins.property
    @pulumi.getter(name="apiManagementName")
    def api_management_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Name of the API Management Service where this Service should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_name")

    @api_management_name.setter
    def api_management_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_management_name", value)

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The base-64 encoded certificate data, which must be a PFX file.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data", value)

    @_builtins.property
    @pulumi.getter
    def expiration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Expiration Date of this Certificate, formatted as an RFC3339 string.
        """
        return pulumi.get(self, "expiration")

    @expiration.setter
    def expiration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expiration", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultIdentityClientId")
    def key_vault_identity_client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Client ID of the User Assigned Managed Identity to use for retrieving certificate.

        > **Note:** If not specified, will use System Assigned identity of the API Management Service.
        """
        return pulumi.get(self, "key_vault_identity_client_id")

    @key_vault_identity_client_id.setter
    def key_vault_identity_client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_vault_identity_client_id", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultSecretId")
    def key_vault_secret_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Key Vault Secret containing the SSL Certificate, which must be of the type `application/x-pkcs12`.

        > **Note:** Setting this field requires the `identity` block to be specified in API Management Service, since this identity is used to retrieve the Key Vault Certificate. Possible values are versioned or versionless secret ID. Auto-updating the Certificate from the Key Vault requires that Secret version isn't specified.
        """
        return pulumi.get(self, "key_vault_secret_id")

    @key_vault_secret_id.setter
    def key_vault_secret_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_vault_secret_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the API Management Certificate. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password used for this certificate.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Name of the Resource Group where the API Management Service exists. Changing this forces a new resource to be created.

        > **Note:** Either `data` or `key_vault_secret_id` must be specified - but not both.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def subject(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Subject of this Certificate.
        """
        return pulumi.get(self, "subject")

    @subject.setter
    def subject(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subject", value)

    @_builtins.property
    @pulumi.getter
    def thumbprint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Thumbprint of this Certificate.
        """
        return pulumi.get(self, "thumbprint")

    @thumbprint.setter
    def thumbprint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "thumbprint", value)


@pulumi.type_token("azure:apimanagement/certificate:Certificate")
class Certificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_management_name: Optional[pulumi.Input[_builtins.str]] = None,
                 data: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_identity_client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Certificate within an API Management Service.

        ## Example Usage

        ### With Base64 Certificate)

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.apimanagement.Service("example",
            name="example-apim",
            location=example.location,
            resource_group_name=example.name,
            publisher_name="My Company",
            publisher_email="company@exmaple.com",
            sku_name="Developer_1")
        example_certificate = azure.apimanagement.Certificate("example",
            name="example-cert",
            api_management_name=example_service.name,
            resource_group_name=example.name,
            data=std.filebase64(input="example.pfx").result)
        ```

        ### With Key Vault Certificate)

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.apimanagement.Service("example",
            name="example-apim",
            location=example.location,
            resource_group_name=example.name,
            publisher_name="My Company",
            publisher_email="company@terraform.io",
            sku_name="Developer_1",
            identity={
                "type": "SystemAssigned",
            })
        example_key_vault = azure.keyvault.KeyVault("example",
            name="examplekeyvault",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="standard")
        example_access_policy = azure.keyvault.AccessPolicy("example",
            key_vault_id=example_key_vault.id,
            tenant_id=example_service.identity.tenant_id,
            object_id=example_service.identity.principal_id,
            secret_permissions=["Get"],
            certificate_permissions=["Get"])
        example_certificate = azure.keyvault.Certificate("example",
            name="example-cert",
            key_vault_id=example_key_vault.id,
            certificate={
                "contents": std.filebase64(input="example_cert.pfx").result,
                "password": "terraform",
            },
            certificate_policy={
                "issuer_parameters": {
                    "name": "Self",
                },
                "key_properties": {
                    "exportable": True,
                    "key_size": 2048,
                    "key_type": "RSA",
                    "reuse_key": False,
                },
                "secret_properties": {
                    "content_type": "application/x-pkcs12",
                },
            })
        example_certificate2 = azure.apimanagement.Certificate("example",
            name="example-cert",
            api_management_name=example_service.name,
            resource_group_name=example.name,
            key_vault_secret_id=example_certificate.secret_id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement`: 2022-08-01

        ## Import

        API Management Certificates can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/certificate:Certificate example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.ApiManagement/service/instance1/certificates/certificate1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_management_name: The Name of the API Management Service where this Service should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] data: The base-64 encoded certificate data, which must be a PFX file.
        :param pulumi.Input[_builtins.str] key_vault_identity_client_id: The Client ID of the User Assigned Managed Identity to use for retrieving certificate.
               
               > **Note:** If not specified, will use System Assigned identity of the API Management Service.
        :param pulumi.Input[_builtins.str] key_vault_secret_id: The ID of the Key Vault Secret containing the SSL Certificate, which must be of the type `application/x-pkcs12`.
               
               > **Note:** Setting this field requires the `identity` block to be specified in API Management Service, since this identity is used to retrieve the Key Vault Certificate. Possible values are versioned or versionless secret ID. Auto-updating the Certificate from the Key Vault requires that Secret version isn't specified.
        :param pulumi.Input[_builtins.str] name: The name of the API Management Certificate. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] password: The password used for this certificate.
        :param pulumi.Input[_builtins.str] resource_group_name: The Name of the Resource Group where the API Management Service exists. Changing this forces a new resource to be created.
               
               > **Note:** Either `data` or `key_vault_secret_id` must be specified - but not both.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Certificate within an API Management Service.

        ## Example Usage

        ### With Base64 Certificate)

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.apimanagement.Service("example",
            name="example-apim",
            location=example.location,
            resource_group_name=example.name,
            publisher_name="My Company",
            publisher_email="company@exmaple.com",
            sku_name="Developer_1")
        example_certificate = azure.apimanagement.Certificate("example",
            name="example-cert",
            api_management_name=example_service.name,
            resource_group_name=example.name,
            data=std.filebase64(input="example.pfx").result)
        ```

        ### With Key Vault Certificate)

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.apimanagement.Service("example",
            name="example-apim",
            location=example.location,
            resource_group_name=example.name,
            publisher_name="My Company",
            publisher_email="company@terraform.io",
            sku_name="Developer_1",
            identity={
                "type": "SystemAssigned",
            })
        example_key_vault = azure.keyvault.KeyVault("example",
            name="examplekeyvault",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="standard")
        example_access_policy = azure.keyvault.AccessPolicy("example",
            key_vault_id=example_key_vault.id,
            tenant_id=example_service.identity.tenant_id,
            object_id=example_service.identity.principal_id,
            secret_permissions=["Get"],
            certificate_permissions=["Get"])
        example_certificate = azure.keyvault.Certificate("example",
            name="example-cert",
            key_vault_id=example_key_vault.id,
            certificate={
                "contents": std.filebase64(input="example_cert.pfx").result,
                "password": "terraform",
            },
            certificate_policy={
                "issuer_parameters": {
                    "name": "Self",
                },
                "key_properties": {
                    "exportable": True,
                    "key_size": 2048,
                    "key_type": "RSA",
                    "reuse_key": False,
                },
                "secret_properties": {
                    "content_type": "application/x-pkcs12",
                },
            })
        example_certificate2 = azure.apimanagement.Certificate("example",
            name="example-cert",
            api_management_name=example_service.name,
            resource_group_name=example.name,
            key_vault_secret_id=example_certificate.secret_id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement`: 2022-08-01

        ## Import

        API Management Certificates can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/certificate:Certificate example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.ApiManagement/service/instance1/certificates/certificate1
        ```

        :param str resource_name: The name of the resource.
        :param CertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_management_name: Optional[pulumi.Input[_builtins.str]] = None,
                 data: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_identity_client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CertificateArgs.__new__(CertificateArgs)

            if api_management_name is None and not opts.urn:
                raise TypeError("Missing required property 'api_management_name'")
            __props__.__dict__["api_management_name"] = api_management_name
            __props__.__dict__["data"] = None if data is None else pulumi.Output.secret(data)
            __props__.__dict__["key_vault_identity_client_id"] = key_vault_identity_client_id
            __props__.__dict__["key_vault_secret_id"] = key_vault_secret_id
            __props__.__dict__["name"] = name
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["expiration"] = None
            __props__.__dict__["subject"] = None
            __props__.__dict__["thumbprint"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["data", "password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Certificate, __self__).__init__(
            'azure:apimanagement/certificate:Certificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_management_name: Optional[pulumi.Input[_builtins.str]] = None,
            data: Optional[pulumi.Input[_builtins.str]] = None,
            expiration: Optional[pulumi.Input[_builtins.str]] = None,
            key_vault_identity_client_id: Optional[pulumi.Input[_builtins.str]] = None,
            key_vault_secret_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            subject: Optional[pulumi.Input[_builtins.str]] = None,
            thumbprint: Optional[pulumi.Input[_builtins.str]] = None) -> 'Certificate':
        """
        Get an existing Certificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_management_name: The Name of the API Management Service where this Service should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] data: The base-64 encoded certificate data, which must be a PFX file.
        :param pulumi.Input[_builtins.str] expiration: The Expiration Date of this Certificate, formatted as an RFC3339 string.
        :param pulumi.Input[_builtins.str] key_vault_identity_client_id: The Client ID of the User Assigned Managed Identity to use for retrieving certificate.
               
               > **Note:** If not specified, will use System Assigned identity of the API Management Service.
        :param pulumi.Input[_builtins.str] key_vault_secret_id: The ID of the Key Vault Secret containing the SSL Certificate, which must be of the type `application/x-pkcs12`.
               
               > **Note:** Setting this field requires the `identity` block to be specified in API Management Service, since this identity is used to retrieve the Key Vault Certificate. Possible values are versioned or versionless secret ID. Auto-updating the Certificate from the Key Vault requires that Secret version isn't specified.
        :param pulumi.Input[_builtins.str] name: The name of the API Management Certificate. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] password: The password used for this certificate.
        :param pulumi.Input[_builtins.str] resource_group_name: The Name of the Resource Group where the API Management Service exists. Changing this forces a new resource to be created.
               
               > **Note:** Either `data` or `key_vault_secret_id` must be specified - but not both.
        :param pulumi.Input[_builtins.str] subject: The Subject of this Certificate.
        :param pulumi.Input[_builtins.str] thumbprint: The Thumbprint of this Certificate.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CertificateState.__new__(_CertificateState)

        __props__.__dict__["api_management_name"] = api_management_name
        __props__.__dict__["data"] = data
        __props__.__dict__["expiration"] = expiration
        __props__.__dict__["key_vault_identity_client_id"] = key_vault_identity_client_id
        __props__.__dict__["key_vault_secret_id"] = key_vault_secret_id
        __props__.__dict__["name"] = name
        __props__.__dict__["password"] = password
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["subject"] = subject
        __props__.__dict__["thumbprint"] = thumbprint
        return Certificate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiManagementName")
    def api_management_name(self) -> pulumi.Output[_builtins.str]:
        """
        The Name of the API Management Service where this Service should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_name")

    @_builtins.property
    @pulumi.getter
    def data(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The base-64 encoded certificate data, which must be a PFX file.
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter
    def expiration(self) -> pulumi.Output[_builtins.str]:
        """
        The Expiration Date of this Certificate, formatted as an RFC3339 string.
        """
        return pulumi.get(self, "expiration")

    @_builtins.property
    @pulumi.getter(name="keyVaultIdentityClientId")
    def key_vault_identity_client_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Client ID of the User Assigned Managed Identity to use for retrieving certificate.

        > **Note:** If not specified, will use System Assigned identity of the API Management Service.
        """
        return pulumi.get(self, "key_vault_identity_client_id")

    @_builtins.property
    @pulumi.getter(name="keyVaultSecretId")
    def key_vault_secret_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Key Vault Secret containing the SSL Certificate, which must be of the type `application/x-pkcs12`.

        > **Note:** Setting this field requires the `identity` block to be specified in API Management Service, since this identity is used to retrieve the Key Vault Certificate. Possible values are versioned or versionless secret ID. Auto-updating the Certificate from the Key Vault requires that Secret version isn't specified.
        """
        return pulumi.get(self, "key_vault_secret_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the API Management Certificate. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The password used for this certificate.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The Name of the Resource Group where the API Management Service exists. Changing this forces a new resource to be created.

        > **Note:** Either `data` or `key_vault_secret_id` must be specified - but not both.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def subject(self) -> pulumi.Output[_builtins.str]:
        """
        The Subject of this Certificate.
        """
        return pulumi.get(self, "subject")

    @_builtins.property
    @pulumi.getter
    def thumbprint(self) -> pulumi.Output[_builtins.str]:
        """
        The Thumbprint of this Certificate.
        """
        return pulumi.get(self, "thumbprint")

