# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SpringCloudAppDynamicsApplicationPerformanceMonitoringArgs', 'SpringCloudAppDynamicsApplicationPerformanceMonitoring']

@pulumi.input_type
class SpringCloudAppDynamicsApplicationPerformanceMonitoringArgs:
    def __init__(__self__, *,
                 agent_account_access_key: pulumi.Input[_builtins.str],
                 agent_account_name: pulumi.Input[_builtins.str],
                 controller_host_name: pulumi.Input[_builtins.str],
                 spring_cloud_service_id: pulumi.Input[_builtins.str],
                 agent_application_name: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_node_name: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_tier_name: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_unique_host_id: Optional[pulumi.Input[_builtins.str]] = None,
                 controller_port: Optional[pulumi.Input[_builtins.int]] = None,
                 controller_ssl_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 globally_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SpringCloudAppDynamicsApplicationPerformanceMonitoring resource.
        :param pulumi.Input[_builtins.str] agent_account_access_key: Specifies the account access key used to authenticate with the Controller.
        :param pulumi.Input[_builtins.str] agent_account_name: Specifies the account name of the App Dynamics account.
        :param pulumi.Input[_builtins.str] controller_host_name: Specifies the hostname or the IP address of the AppDynamics Controller.
        :param pulumi.Input[_builtins.str] spring_cloud_service_id: The ID of the Spring Cloud Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] agent_application_name: Specifies the name of the logical business application that this JVM node belongs to.
        :param pulumi.Input[_builtins.str] agent_node_name: Specifies the name of the node. Where JVMs are dynamically created.
        :param pulumi.Input[_builtins.str] agent_tier_name: Specifies the name of the tier that this JVM node belongs to.
        :param pulumi.Input[_builtins.str] agent_unique_host_id: Specifies the unique host ID which is used to Logically partition a single physical host or virtual machine such that it appears to the Controller that the application is running on different machines.
        :param pulumi.Input[_builtins.int] controller_port: Specifies the HTTP(S) port of the AppDynamics Controller. This is the port used to access the AppDynamics browser-based user interface.
        :param pulumi.Input[_builtins.bool] controller_ssl_enabled: Specifies whether enable use SSL (HTTPS) to connect to the AppDynamics Controller.
        :param pulumi.Input[_builtins.bool] globally_enabled: Specifies whether the Spring Cloud Application Performance Monitoring resource for Application Insights is enabled globally. Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Spring Cloud Application Performance Monitoring resource for App Dynamics. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "agent_account_access_key", agent_account_access_key)
        pulumi.set(__self__, "agent_account_name", agent_account_name)
        pulumi.set(__self__, "controller_host_name", controller_host_name)
        pulumi.set(__self__, "spring_cloud_service_id", spring_cloud_service_id)
        if agent_application_name is not None:
            pulumi.set(__self__, "agent_application_name", agent_application_name)
        if agent_node_name is not None:
            pulumi.set(__self__, "agent_node_name", agent_node_name)
        if agent_tier_name is not None:
            pulumi.set(__self__, "agent_tier_name", agent_tier_name)
        if agent_unique_host_id is not None:
            pulumi.set(__self__, "agent_unique_host_id", agent_unique_host_id)
        if controller_port is not None:
            pulumi.set(__self__, "controller_port", controller_port)
        if controller_ssl_enabled is not None:
            pulumi.set(__self__, "controller_ssl_enabled", controller_ssl_enabled)
        if globally_enabled is not None:
            pulumi.set(__self__, "globally_enabled", globally_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="agentAccountAccessKey")
    def agent_account_access_key(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the account access key used to authenticate with the Controller.
        """
        return pulumi.get(self, "agent_account_access_key")

    @agent_account_access_key.setter
    def agent_account_access_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "agent_account_access_key", value)

    @_builtins.property
    @pulumi.getter(name="agentAccountName")
    def agent_account_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the account name of the App Dynamics account.
        """
        return pulumi.get(self, "agent_account_name")

    @agent_account_name.setter
    def agent_account_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "agent_account_name", value)

    @_builtins.property
    @pulumi.getter(name="controllerHostName")
    def controller_host_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the hostname or the IP address of the AppDynamics Controller.
        """
        return pulumi.get(self, "controller_host_name")

    @controller_host_name.setter
    def controller_host_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "controller_host_name", value)

    @_builtins.property
    @pulumi.getter(name="springCloudServiceId")
    def spring_cloud_service_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Spring Cloud Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "spring_cloud_service_id")

    @spring_cloud_service_id.setter
    def spring_cloud_service_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "spring_cloud_service_id", value)

    @_builtins.property
    @pulumi.getter(name="agentApplicationName")
    def agent_application_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the logical business application that this JVM node belongs to.
        """
        return pulumi.get(self, "agent_application_name")

    @agent_application_name.setter
    def agent_application_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_application_name", value)

    @_builtins.property
    @pulumi.getter(name="agentNodeName")
    def agent_node_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the node. Where JVMs are dynamically created.
        """
        return pulumi.get(self, "agent_node_name")

    @agent_node_name.setter
    def agent_node_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_node_name", value)

    @_builtins.property
    @pulumi.getter(name="agentTierName")
    def agent_tier_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the tier that this JVM node belongs to.
        """
        return pulumi.get(self, "agent_tier_name")

    @agent_tier_name.setter
    def agent_tier_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_tier_name", value)

    @_builtins.property
    @pulumi.getter(name="agentUniqueHostId")
    def agent_unique_host_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the unique host ID which is used to Logically partition a single physical host or virtual machine such that it appears to the Controller that the application is running on different machines.
        """
        return pulumi.get(self, "agent_unique_host_id")

    @agent_unique_host_id.setter
    def agent_unique_host_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_unique_host_id", value)

    @_builtins.property
    @pulumi.getter(name="controllerPort")
    def controller_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the HTTP(S) port of the AppDynamics Controller. This is the port used to access the AppDynamics browser-based user interface.
        """
        return pulumi.get(self, "controller_port")

    @controller_port.setter
    def controller_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "controller_port", value)

    @_builtins.property
    @pulumi.getter(name="controllerSslEnabled")
    def controller_ssl_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether enable use SSL (HTTPS) to connect to the AppDynamics Controller.
        """
        return pulumi.get(self, "controller_ssl_enabled")

    @controller_ssl_enabled.setter
    def controller_ssl_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "controller_ssl_enabled", value)

    @_builtins.property
    @pulumi.getter(name="globallyEnabled")
    def globally_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the Spring Cloud Application Performance Monitoring resource for Application Insights is enabled globally. Defaults to `false`.
        """
        return pulumi.get(self, "globally_enabled")

    @globally_enabled.setter
    def globally_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "globally_enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Spring Cloud Application Performance Monitoring resource for App Dynamics. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _SpringCloudAppDynamicsApplicationPerformanceMonitoringState:
    def __init__(__self__, *,
                 agent_account_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_application_name: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_node_name: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_tier_name: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_unique_host_id: Optional[pulumi.Input[_builtins.str]] = None,
                 controller_host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 controller_port: Optional[pulumi.Input[_builtins.int]] = None,
                 controller_ssl_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 globally_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 spring_cloud_service_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SpringCloudAppDynamicsApplicationPerformanceMonitoring resources.
        :param pulumi.Input[_builtins.str] agent_account_access_key: Specifies the account access key used to authenticate with the Controller.
        :param pulumi.Input[_builtins.str] agent_account_name: Specifies the account name of the App Dynamics account.
        :param pulumi.Input[_builtins.str] agent_application_name: Specifies the name of the logical business application that this JVM node belongs to.
        :param pulumi.Input[_builtins.str] agent_node_name: Specifies the name of the node. Where JVMs are dynamically created.
        :param pulumi.Input[_builtins.str] agent_tier_name: Specifies the name of the tier that this JVM node belongs to.
        :param pulumi.Input[_builtins.str] agent_unique_host_id: Specifies the unique host ID which is used to Logically partition a single physical host or virtual machine such that it appears to the Controller that the application is running on different machines.
        :param pulumi.Input[_builtins.str] controller_host_name: Specifies the hostname or the IP address of the AppDynamics Controller.
        :param pulumi.Input[_builtins.int] controller_port: Specifies the HTTP(S) port of the AppDynamics Controller. This is the port used to access the AppDynamics browser-based user interface.
        :param pulumi.Input[_builtins.bool] controller_ssl_enabled: Specifies whether enable use SSL (HTTPS) to connect to the AppDynamics Controller.
        :param pulumi.Input[_builtins.bool] globally_enabled: Specifies whether the Spring Cloud Application Performance Monitoring resource for Application Insights is enabled globally. Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Spring Cloud Application Performance Monitoring resource for App Dynamics. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] spring_cloud_service_id: The ID of the Spring Cloud Service. Changing this forces a new resource to be created.
        """
        if agent_account_access_key is not None:
            pulumi.set(__self__, "agent_account_access_key", agent_account_access_key)
        if agent_account_name is not None:
            pulumi.set(__self__, "agent_account_name", agent_account_name)
        if agent_application_name is not None:
            pulumi.set(__self__, "agent_application_name", agent_application_name)
        if agent_node_name is not None:
            pulumi.set(__self__, "agent_node_name", agent_node_name)
        if agent_tier_name is not None:
            pulumi.set(__self__, "agent_tier_name", agent_tier_name)
        if agent_unique_host_id is not None:
            pulumi.set(__self__, "agent_unique_host_id", agent_unique_host_id)
        if controller_host_name is not None:
            pulumi.set(__self__, "controller_host_name", controller_host_name)
        if controller_port is not None:
            pulumi.set(__self__, "controller_port", controller_port)
        if controller_ssl_enabled is not None:
            pulumi.set(__self__, "controller_ssl_enabled", controller_ssl_enabled)
        if globally_enabled is not None:
            pulumi.set(__self__, "globally_enabled", globally_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if spring_cloud_service_id is not None:
            pulumi.set(__self__, "spring_cloud_service_id", spring_cloud_service_id)

    @_builtins.property
    @pulumi.getter(name="agentAccountAccessKey")
    def agent_account_access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the account access key used to authenticate with the Controller.
        """
        return pulumi.get(self, "agent_account_access_key")

    @agent_account_access_key.setter
    def agent_account_access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_account_access_key", value)

    @_builtins.property
    @pulumi.getter(name="agentAccountName")
    def agent_account_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the account name of the App Dynamics account.
        """
        return pulumi.get(self, "agent_account_name")

    @agent_account_name.setter
    def agent_account_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_account_name", value)

    @_builtins.property
    @pulumi.getter(name="agentApplicationName")
    def agent_application_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the logical business application that this JVM node belongs to.
        """
        return pulumi.get(self, "agent_application_name")

    @agent_application_name.setter
    def agent_application_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_application_name", value)

    @_builtins.property
    @pulumi.getter(name="agentNodeName")
    def agent_node_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the node. Where JVMs are dynamically created.
        """
        return pulumi.get(self, "agent_node_name")

    @agent_node_name.setter
    def agent_node_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_node_name", value)

    @_builtins.property
    @pulumi.getter(name="agentTierName")
    def agent_tier_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the tier that this JVM node belongs to.
        """
        return pulumi.get(self, "agent_tier_name")

    @agent_tier_name.setter
    def agent_tier_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_tier_name", value)

    @_builtins.property
    @pulumi.getter(name="agentUniqueHostId")
    def agent_unique_host_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the unique host ID which is used to Logically partition a single physical host or virtual machine such that it appears to the Controller that the application is running on different machines.
        """
        return pulumi.get(self, "agent_unique_host_id")

    @agent_unique_host_id.setter
    def agent_unique_host_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_unique_host_id", value)

    @_builtins.property
    @pulumi.getter(name="controllerHostName")
    def controller_host_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the hostname or the IP address of the AppDynamics Controller.
        """
        return pulumi.get(self, "controller_host_name")

    @controller_host_name.setter
    def controller_host_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "controller_host_name", value)

    @_builtins.property
    @pulumi.getter(name="controllerPort")
    def controller_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the HTTP(S) port of the AppDynamics Controller. This is the port used to access the AppDynamics browser-based user interface.
        """
        return pulumi.get(self, "controller_port")

    @controller_port.setter
    def controller_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "controller_port", value)

    @_builtins.property
    @pulumi.getter(name="controllerSslEnabled")
    def controller_ssl_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether enable use SSL (HTTPS) to connect to the AppDynamics Controller.
        """
        return pulumi.get(self, "controller_ssl_enabled")

    @controller_ssl_enabled.setter
    def controller_ssl_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "controller_ssl_enabled", value)

    @_builtins.property
    @pulumi.getter(name="globallyEnabled")
    def globally_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the Spring Cloud Application Performance Monitoring resource for Application Insights is enabled globally. Defaults to `false`.
        """
        return pulumi.get(self, "globally_enabled")

    @globally_enabled.setter
    def globally_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "globally_enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Spring Cloud Application Performance Monitoring resource for App Dynamics. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="springCloudServiceId")
    def spring_cloud_service_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Spring Cloud Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "spring_cloud_service_id")

    @spring_cloud_service_id.setter
    def spring_cloud_service_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spring_cloud_service_id", value)


@pulumi.type_token("azure:appplatform/springCloudAppDynamicsApplicationPerformanceMonitoring:SpringCloudAppDynamicsApplicationPerformanceMonitoring")
class SpringCloudAppDynamicsApplicationPerformanceMonitoring(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_account_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_application_name: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_node_name: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_tier_name: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_unique_host_id: Optional[pulumi.Input[_builtins.str]] = None,
                 controller_host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 controller_port: Optional[pulumi.Input[_builtins.int]] = None,
                 controller_ssl_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 globally_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 spring_cloud_service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        > **Note:** This resource is only applicable for Spring Cloud Service enterprise tier

        Manages a Spring Cloud Application Performance Monitoring resource for App Dynamics.

        !> **Note:** Azure Spring Apps is now deprecated and will be retired on 2028-05-31 - as such the `appplatform.SpringCloudAppDynamicsApplicationPerformanceMonitoring` resource is deprecated and will be removed in a future major version of the AzureRM Provider. See https://aka.ms/asaretirement for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        example_spring_cloud_service = azure.appplatform.SpringCloudService("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            sku_name="E0")
        example_spring_cloud_app_dynamics_application_performance_monitoring = azure.appplatform.SpringCloudAppDynamicsApplicationPerformanceMonitoring("example",
            name="example",
            spring_cloud_service_id=example_spring_cloud_service.id,
            agent_account_name="example-agent-account-name",
            agent_account_access_key="example-agent-account-access-key",
            controller_host_name="example-controller-host-name",
            agent_application_name="example-agent-application-name",
            agent_tier_name="example-agent-tier-name",
            agent_node_name="example-agent-node-name",
            agent_unique_host_id="example-agent-unique-host-id",
            controller_ssl_enabled=True,
            controller_port=8080,
            globally_enabled=True)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AppPlatform`: 2024-01-01-preview

        ## Import

        Spring Cloud Application Performance Monitoring resource for App Dynamics can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appplatform/springCloudAppDynamicsApplicationPerformanceMonitoring:SpringCloudAppDynamicsApplicationPerformanceMonitoring example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.AppPlatform/spring/service1/apms/apm1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] agent_account_access_key: Specifies the account access key used to authenticate with the Controller.
        :param pulumi.Input[_builtins.str] agent_account_name: Specifies the account name of the App Dynamics account.
        :param pulumi.Input[_builtins.str] agent_application_name: Specifies the name of the logical business application that this JVM node belongs to.
        :param pulumi.Input[_builtins.str] agent_node_name: Specifies the name of the node. Where JVMs are dynamically created.
        :param pulumi.Input[_builtins.str] agent_tier_name: Specifies the name of the tier that this JVM node belongs to.
        :param pulumi.Input[_builtins.str] agent_unique_host_id: Specifies the unique host ID which is used to Logically partition a single physical host or virtual machine such that it appears to the Controller that the application is running on different machines.
        :param pulumi.Input[_builtins.str] controller_host_name: Specifies the hostname or the IP address of the AppDynamics Controller.
        :param pulumi.Input[_builtins.int] controller_port: Specifies the HTTP(S) port of the AppDynamics Controller. This is the port used to access the AppDynamics browser-based user interface.
        :param pulumi.Input[_builtins.bool] controller_ssl_enabled: Specifies whether enable use SSL (HTTPS) to connect to the AppDynamics Controller.
        :param pulumi.Input[_builtins.bool] globally_enabled: Specifies whether the Spring Cloud Application Performance Monitoring resource for Application Insights is enabled globally. Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Spring Cloud Application Performance Monitoring resource for App Dynamics. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] spring_cloud_service_id: The ID of the Spring Cloud Service. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SpringCloudAppDynamicsApplicationPerformanceMonitoringArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > **Note:** This resource is only applicable for Spring Cloud Service enterprise tier

        Manages a Spring Cloud Application Performance Monitoring resource for App Dynamics.

        !> **Note:** Azure Spring Apps is now deprecated and will be retired on 2028-05-31 - as such the `appplatform.SpringCloudAppDynamicsApplicationPerformanceMonitoring` resource is deprecated and will be removed in a future major version of the AzureRM Provider. See https://aka.ms/asaretirement for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        example_spring_cloud_service = azure.appplatform.SpringCloudService("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            sku_name="E0")
        example_spring_cloud_app_dynamics_application_performance_monitoring = azure.appplatform.SpringCloudAppDynamicsApplicationPerformanceMonitoring("example",
            name="example",
            spring_cloud_service_id=example_spring_cloud_service.id,
            agent_account_name="example-agent-account-name",
            agent_account_access_key="example-agent-account-access-key",
            controller_host_name="example-controller-host-name",
            agent_application_name="example-agent-application-name",
            agent_tier_name="example-agent-tier-name",
            agent_node_name="example-agent-node-name",
            agent_unique_host_id="example-agent-unique-host-id",
            controller_ssl_enabled=True,
            controller_port=8080,
            globally_enabled=True)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AppPlatform`: 2024-01-01-preview

        ## Import

        Spring Cloud Application Performance Monitoring resource for App Dynamics can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appplatform/springCloudAppDynamicsApplicationPerformanceMonitoring:SpringCloudAppDynamicsApplicationPerformanceMonitoring example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.AppPlatform/spring/service1/apms/apm1
        ```

        :param str resource_name: The name of the resource.
        :param SpringCloudAppDynamicsApplicationPerformanceMonitoringArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SpringCloudAppDynamicsApplicationPerformanceMonitoringArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_account_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_application_name: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_node_name: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_tier_name: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_unique_host_id: Optional[pulumi.Input[_builtins.str]] = None,
                 controller_host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 controller_port: Optional[pulumi.Input[_builtins.int]] = None,
                 controller_ssl_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 globally_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 spring_cloud_service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SpringCloudAppDynamicsApplicationPerformanceMonitoringArgs.__new__(SpringCloudAppDynamicsApplicationPerformanceMonitoringArgs)

            if agent_account_access_key is None and not opts.urn:
                raise TypeError("Missing required property 'agent_account_access_key'")
            __props__.__dict__["agent_account_access_key"] = None if agent_account_access_key is None else pulumi.Output.secret(agent_account_access_key)
            if agent_account_name is None and not opts.urn:
                raise TypeError("Missing required property 'agent_account_name'")
            __props__.__dict__["agent_account_name"] = None if agent_account_name is None else pulumi.Output.secret(agent_account_name)
            __props__.__dict__["agent_application_name"] = agent_application_name
            __props__.__dict__["agent_node_name"] = agent_node_name
            __props__.__dict__["agent_tier_name"] = agent_tier_name
            __props__.__dict__["agent_unique_host_id"] = agent_unique_host_id
            if controller_host_name is None and not opts.urn:
                raise TypeError("Missing required property 'controller_host_name'")
            __props__.__dict__["controller_host_name"] = controller_host_name
            __props__.__dict__["controller_port"] = controller_port
            __props__.__dict__["controller_ssl_enabled"] = controller_ssl_enabled
            __props__.__dict__["globally_enabled"] = globally_enabled
            __props__.__dict__["name"] = name
            if spring_cloud_service_id is None and not opts.urn:
                raise TypeError("Missing required property 'spring_cloud_service_id'")
            __props__.__dict__["spring_cloud_service_id"] = spring_cloud_service_id
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["agentAccountAccessKey", "agentAccountName"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(SpringCloudAppDynamicsApplicationPerformanceMonitoring, __self__).__init__(
            'azure:appplatform/springCloudAppDynamicsApplicationPerformanceMonitoring:SpringCloudAppDynamicsApplicationPerformanceMonitoring',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agent_account_access_key: Optional[pulumi.Input[_builtins.str]] = None,
            agent_account_name: Optional[pulumi.Input[_builtins.str]] = None,
            agent_application_name: Optional[pulumi.Input[_builtins.str]] = None,
            agent_node_name: Optional[pulumi.Input[_builtins.str]] = None,
            agent_tier_name: Optional[pulumi.Input[_builtins.str]] = None,
            agent_unique_host_id: Optional[pulumi.Input[_builtins.str]] = None,
            controller_host_name: Optional[pulumi.Input[_builtins.str]] = None,
            controller_port: Optional[pulumi.Input[_builtins.int]] = None,
            controller_ssl_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            globally_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            spring_cloud_service_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'SpringCloudAppDynamicsApplicationPerformanceMonitoring':
        """
        Get an existing SpringCloudAppDynamicsApplicationPerformanceMonitoring resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] agent_account_access_key: Specifies the account access key used to authenticate with the Controller.
        :param pulumi.Input[_builtins.str] agent_account_name: Specifies the account name of the App Dynamics account.
        :param pulumi.Input[_builtins.str] agent_application_name: Specifies the name of the logical business application that this JVM node belongs to.
        :param pulumi.Input[_builtins.str] agent_node_name: Specifies the name of the node. Where JVMs are dynamically created.
        :param pulumi.Input[_builtins.str] agent_tier_name: Specifies the name of the tier that this JVM node belongs to.
        :param pulumi.Input[_builtins.str] agent_unique_host_id: Specifies the unique host ID which is used to Logically partition a single physical host or virtual machine such that it appears to the Controller that the application is running on different machines.
        :param pulumi.Input[_builtins.str] controller_host_name: Specifies the hostname or the IP address of the AppDynamics Controller.
        :param pulumi.Input[_builtins.int] controller_port: Specifies the HTTP(S) port of the AppDynamics Controller. This is the port used to access the AppDynamics browser-based user interface.
        :param pulumi.Input[_builtins.bool] controller_ssl_enabled: Specifies whether enable use SSL (HTTPS) to connect to the AppDynamics Controller.
        :param pulumi.Input[_builtins.bool] globally_enabled: Specifies whether the Spring Cloud Application Performance Monitoring resource for Application Insights is enabled globally. Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Spring Cloud Application Performance Monitoring resource for App Dynamics. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] spring_cloud_service_id: The ID of the Spring Cloud Service. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SpringCloudAppDynamicsApplicationPerformanceMonitoringState.__new__(_SpringCloudAppDynamicsApplicationPerformanceMonitoringState)

        __props__.__dict__["agent_account_access_key"] = agent_account_access_key
        __props__.__dict__["agent_account_name"] = agent_account_name
        __props__.__dict__["agent_application_name"] = agent_application_name
        __props__.__dict__["agent_node_name"] = agent_node_name
        __props__.__dict__["agent_tier_name"] = agent_tier_name
        __props__.__dict__["agent_unique_host_id"] = agent_unique_host_id
        __props__.__dict__["controller_host_name"] = controller_host_name
        __props__.__dict__["controller_port"] = controller_port
        __props__.__dict__["controller_ssl_enabled"] = controller_ssl_enabled
        __props__.__dict__["globally_enabled"] = globally_enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["spring_cloud_service_id"] = spring_cloud_service_id
        return SpringCloudAppDynamicsApplicationPerformanceMonitoring(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="agentAccountAccessKey")
    def agent_account_access_key(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the account access key used to authenticate with the Controller.
        """
        return pulumi.get(self, "agent_account_access_key")

    @_builtins.property
    @pulumi.getter(name="agentAccountName")
    def agent_account_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the account name of the App Dynamics account.
        """
        return pulumi.get(self, "agent_account_name")

    @_builtins.property
    @pulumi.getter(name="agentApplicationName")
    def agent_application_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the name of the logical business application that this JVM node belongs to.
        """
        return pulumi.get(self, "agent_application_name")

    @_builtins.property
    @pulumi.getter(name="agentNodeName")
    def agent_node_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the name of the node. Where JVMs are dynamically created.
        """
        return pulumi.get(self, "agent_node_name")

    @_builtins.property
    @pulumi.getter(name="agentTierName")
    def agent_tier_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the name of the tier that this JVM node belongs to.
        """
        return pulumi.get(self, "agent_tier_name")

    @_builtins.property
    @pulumi.getter(name="agentUniqueHostId")
    def agent_unique_host_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the unique host ID which is used to Logically partition a single physical host or virtual machine such that it appears to the Controller that the application is running on different machines.
        """
        return pulumi.get(self, "agent_unique_host_id")

    @_builtins.property
    @pulumi.getter(name="controllerHostName")
    def controller_host_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the hostname or the IP address of the AppDynamics Controller.
        """
        return pulumi.get(self, "controller_host_name")

    @_builtins.property
    @pulumi.getter(name="controllerPort")
    def controller_port(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the HTTP(S) port of the AppDynamics Controller. This is the port used to access the AppDynamics browser-based user interface.
        """
        return pulumi.get(self, "controller_port")

    @_builtins.property
    @pulumi.getter(name="controllerSslEnabled")
    def controller_ssl_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether enable use SSL (HTTPS) to connect to the AppDynamics Controller.
        """
        return pulumi.get(self, "controller_ssl_enabled")

    @_builtins.property
    @pulumi.getter(name="globallyEnabled")
    def globally_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether the Spring Cloud Application Performance Monitoring resource for Application Insights is enabled globally. Defaults to `false`.
        """
        return pulumi.get(self, "globally_enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Spring Cloud Application Performance Monitoring resource for App Dynamics. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="springCloudServiceId")
    def spring_cloud_service_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Spring Cloud Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "spring_cloud_service_id")

