# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SpringCloudNewRelicApplicationPerformanceMonitoringArgs', 'SpringCloudNewRelicApplicationPerformanceMonitoring']

@pulumi.input_type
class SpringCloudNewRelicApplicationPerformanceMonitoringArgs:
    def __init__(__self__, *,
                 app_name: pulumi.Input[_builtins.str],
                 license_key: pulumi.Input[_builtins.str],
                 spring_cloud_service_id: pulumi.Input[_builtins.str],
                 agent_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 app_server_port: Optional[pulumi.Input[_builtins.int]] = None,
                 audit_mode_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_app_naming_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_transaction_naming_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 custom_tracing_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 globally_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SpringCloudNewRelicApplicationPerformanceMonitoring resource.
        :param pulumi.Input[_builtins.str] app_name: Specifies the application name used to report data to New Relic.
        :param pulumi.Input[_builtins.str] license_key: Specifies the license key associated with the New Relic account. This key binds your agent's data to your account in New Relic service.
        :param pulumi.Input[_builtins.str] spring_cloud_service_id: The ID of the Spring Cloud Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] agent_enabled: Specifies whether enable the agent. Defaults to `true`.
        :param pulumi.Input[_builtins.int] app_server_port: Specifies the port number to differentiate JVMs for the same app on the same machine.
        :param pulumi.Input[_builtins.bool] audit_mode_enabled: Specifies whether enable plain text logging of all data sent to New Relic to the agent logfile. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] auto_app_naming_enabled: Specifies whether enable the reporting of data separately for each web app. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] auto_transaction_naming_enabled: Specifies whether enable the component-based transaction naming. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] custom_tracing_enabled: Specifies whether enable all instrumentation using an `@Trace` annotation. Disabling this causes `@Trace` annotations to be ignored. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] globally_enabled: Specifies whether the Spring Cloud Application Performance Monitoring resource for Application Insights is enabled globally. Defaults to `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Specifies a mapping of labels to be added to the New Relic application.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Spring Cloud Application Performance Monitoring resource for New Relic. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "app_name", app_name)
        pulumi.set(__self__, "license_key", license_key)
        pulumi.set(__self__, "spring_cloud_service_id", spring_cloud_service_id)
        if agent_enabled is not None:
            pulumi.set(__self__, "agent_enabled", agent_enabled)
        if app_server_port is not None:
            pulumi.set(__self__, "app_server_port", app_server_port)
        if audit_mode_enabled is not None:
            pulumi.set(__self__, "audit_mode_enabled", audit_mode_enabled)
        if auto_app_naming_enabled is not None:
            pulumi.set(__self__, "auto_app_naming_enabled", auto_app_naming_enabled)
        if auto_transaction_naming_enabled is not None:
            pulumi.set(__self__, "auto_transaction_naming_enabled", auto_transaction_naming_enabled)
        if custom_tracing_enabled is not None:
            pulumi.set(__self__, "custom_tracing_enabled", custom_tracing_enabled)
        if globally_enabled is not None:
            pulumi.set(__self__, "globally_enabled", globally_enabled)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="appName")
    def app_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the application name used to report data to New Relic.
        """
        return pulumi.get(self, "app_name")

    @app_name.setter
    def app_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "app_name", value)

    @_builtins.property
    @pulumi.getter(name="licenseKey")
    def license_key(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the license key associated with the New Relic account. This key binds your agent's data to your account in New Relic service.
        """
        return pulumi.get(self, "license_key")

    @license_key.setter
    def license_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "license_key", value)

    @_builtins.property
    @pulumi.getter(name="springCloudServiceId")
    def spring_cloud_service_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Spring Cloud Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "spring_cloud_service_id")

    @spring_cloud_service_id.setter
    def spring_cloud_service_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "spring_cloud_service_id", value)

    @_builtins.property
    @pulumi.getter(name="agentEnabled")
    def agent_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether enable the agent. Defaults to `true`.
        """
        return pulumi.get(self, "agent_enabled")

    @agent_enabled.setter
    def agent_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "agent_enabled", value)

    @_builtins.property
    @pulumi.getter(name="appServerPort")
    def app_server_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the port number to differentiate JVMs for the same app on the same machine.
        """
        return pulumi.get(self, "app_server_port")

    @app_server_port.setter
    def app_server_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "app_server_port", value)

    @_builtins.property
    @pulumi.getter(name="auditModeEnabled")
    def audit_mode_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether enable plain text logging of all data sent to New Relic to the agent logfile. Defaults to `false`.
        """
        return pulumi.get(self, "audit_mode_enabled")

    @audit_mode_enabled.setter
    def audit_mode_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "audit_mode_enabled", value)

    @_builtins.property
    @pulumi.getter(name="autoAppNamingEnabled")
    def auto_app_naming_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether enable the reporting of data separately for each web app. Defaults to `false`.
        """
        return pulumi.get(self, "auto_app_naming_enabled")

    @auto_app_naming_enabled.setter
    def auto_app_naming_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_app_naming_enabled", value)

    @_builtins.property
    @pulumi.getter(name="autoTransactionNamingEnabled")
    def auto_transaction_naming_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether enable the component-based transaction naming. Defaults to `true`.
        """
        return pulumi.get(self, "auto_transaction_naming_enabled")

    @auto_transaction_naming_enabled.setter
    def auto_transaction_naming_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_transaction_naming_enabled", value)

    @_builtins.property
    @pulumi.getter(name="customTracingEnabled")
    def custom_tracing_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether enable all instrumentation using an `@Trace` annotation. Disabling this causes `@Trace` annotations to be ignored. Defaults to `true`.
        """
        return pulumi.get(self, "custom_tracing_enabled")

    @custom_tracing_enabled.setter
    def custom_tracing_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "custom_tracing_enabled", value)

    @_builtins.property
    @pulumi.getter(name="globallyEnabled")
    def globally_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the Spring Cloud Application Performance Monitoring resource for Application Insights is enabled globally. Defaults to `false`.
        """
        return pulumi.get(self, "globally_enabled")

    @globally_enabled.setter
    def globally_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "globally_enabled", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies a mapping of labels to be added to the New Relic application.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Spring Cloud Application Performance Monitoring resource for New Relic. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _SpringCloudNewRelicApplicationPerformanceMonitoringState:
    def __init__(__self__, *,
                 agent_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 app_name: Optional[pulumi.Input[_builtins.str]] = None,
                 app_server_port: Optional[pulumi.Input[_builtins.int]] = None,
                 audit_mode_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_app_naming_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_transaction_naming_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 custom_tracing_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 globally_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 license_key: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 spring_cloud_service_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SpringCloudNewRelicApplicationPerformanceMonitoring resources.
        :param pulumi.Input[_builtins.bool] agent_enabled: Specifies whether enable the agent. Defaults to `true`.
        :param pulumi.Input[_builtins.str] app_name: Specifies the application name used to report data to New Relic.
        :param pulumi.Input[_builtins.int] app_server_port: Specifies the port number to differentiate JVMs for the same app on the same machine.
        :param pulumi.Input[_builtins.bool] audit_mode_enabled: Specifies whether enable plain text logging of all data sent to New Relic to the agent logfile. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] auto_app_naming_enabled: Specifies whether enable the reporting of data separately for each web app. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] auto_transaction_naming_enabled: Specifies whether enable the component-based transaction naming. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] custom_tracing_enabled: Specifies whether enable all instrumentation using an `@Trace` annotation. Disabling this causes `@Trace` annotations to be ignored. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] globally_enabled: Specifies whether the Spring Cloud Application Performance Monitoring resource for Application Insights is enabled globally. Defaults to `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Specifies a mapping of labels to be added to the New Relic application.
        :param pulumi.Input[_builtins.str] license_key: Specifies the license key associated with the New Relic account. This key binds your agent's data to your account in New Relic service.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Spring Cloud Application Performance Monitoring resource for New Relic. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] spring_cloud_service_id: The ID of the Spring Cloud Service. Changing this forces a new resource to be created.
        """
        if agent_enabled is not None:
            pulumi.set(__self__, "agent_enabled", agent_enabled)
        if app_name is not None:
            pulumi.set(__self__, "app_name", app_name)
        if app_server_port is not None:
            pulumi.set(__self__, "app_server_port", app_server_port)
        if audit_mode_enabled is not None:
            pulumi.set(__self__, "audit_mode_enabled", audit_mode_enabled)
        if auto_app_naming_enabled is not None:
            pulumi.set(__self__, "auto_app_naming_enabled", auto_app_naming_enabled)
        if auto_transaction_naming_enabled is not None:
            pulumi.set(__self__, "auto_transaction_naming_enabled", auto_transaction_naming_enabled)
        if custom_tracing_enabled is not None:
            pulumi.set(__self__, "custom_tracing_enabled", custom_tracing_enabled)
        if globally_enabled is not None:
            pulumi.set(__self__, "globally_enabled", globally_enabled)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if license_key is not None:
            pulumi.set(__self__, "license_key", license_key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if spring_cloud_service_id is not None:
            pulumi.set(__self__, "spring_cloud_service_id", spring_cloud_service_id)

    @_builtins.property
    @pulumi.getter(name="agentEnabled")
    def agent_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether enable the agent. Defaults to `true`.
        """
        return pulumi.get(self, "agent_enabled")

    @agent_enabled.setter
    def agent_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "agent_enabled", value)

    @_builtins.property
    @pulumi.getter(name="appName")
    def app_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the application name used to report data to New Relic.
        """
        return pulumi.get(self, "app_name")

    @app_name.setter
    def app_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_name", value)

    @_builtins.property
    @pulumi.getter(name="appServerPort")
    def app_server_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the port number to differentiate JVMs for the same app on the same machine.
        """
        return pulumi.get(self, "app_server_port")

    @app_server_port.setter
    def app_server_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "app_server_port", value)

    @_builtins.property
    @pulumi.getter(name="auditModeEnabled")
    def audit_mode_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether enable plain text logging of all data sent to New Relic to the agent logfile. Defaults to `false`.
        """
        return pulumi.get(self, "audit_mode_enabled")

    @audit_mode_enabled.setter
    def audit_mode_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "audit_mode_enabled", value)

    @_builtins.property
    @pulumi.getter(name="autoAppNamingEnabled")
    def auto_app_naming_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether enable the reporting of data separately for each web app. Defaults to `false`.
        """
        return pulumi.get(self, "auto_app_naming_enabled")

    @auto_app_naming_enabled.setter
    def auto_app_naming_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_app_naming_enabled", value)

    @_builtins.property
    @pulumi.getter(name="autoTransactionNamingEnabled")
    def auto_transaction_naming_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether enable the component-based transaction naming. Defaults to `true`.
        """
        return pulumi.get(self, "auto_transaction_naming_enabled")

    @auto_transaction_naming_enabled.setter
    def auto_transaction_naming_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_transaction_naming_enabled", value)

    @_builtins.property
    @pulumi.getter(name="customTracingEnabled")
    def custom_tracing_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether enable all instrumentation using an `@Trace` annotation. Disabling this causes `@Trace` annotations to be ignored. Defaults to `true`.
        """
        return pulumi.get(self, "custom_tracing_enabled")

    @custom_tracing_enabled.setter
    def custom_tracing_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "custom_tracing_enabled", value)

    @_builtins.property
    @pulumi.getter(name="globallyEnabled")
    def globally_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the Spring Cloud Application Performance Monitoring resource for Application Insights is enabled globally. Defaults to `false`.
        """
        return pulumi.get(self, "globally_enabled")

    @globally_enabled.setter
    def globally_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "globally_enabled", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies a mapping of labels to be added to the New Relic application.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="licenseKey")
    def license_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the license key associated with the New Relic account. This key binds your agent's data to your account in New Relic service.
        """
        return pulumi.get(self, "license_key")

    @license_key.setter
    def license_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license_key", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Spring Cloud Application Performance Monitoring resource for New Relic. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="springCloudServiceId")
    def spring_cloud_service_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Spring Cloud Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "spring_cloud_service_id")

    @spring_cloud_service_id.setter
    def spring_cloud_service_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spring_cloud_service_id", value)


@pulumi.type_token("azure:appplatform/springCloudNewRelicApplicationPerformanceMonitoring:SpringCloudNewRelicApplicationPerformanceMonitoring")
class SpringCloudNewRelicApplicationPerformanceMonitoring(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 app_name: Optional[pulumi.Input[_builtins.str]] = None,
                 app_server_port: Optional[pulumi.Input[_builtins.int]] = None,
                 audit_mode_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_app_naming_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_transaction_naming_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 custom_tracing_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 globally_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 license_key: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 spring_cloud_service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        > **Note:** This resource is only applicable for Spring Cloud Service enterprise tier

        Manages a Spring Cloud Application Performance Monitoring resource for New Relic.

        !> **Note:** Azure Spring Apps is now deprecated and will be retired on 2028-05-31 - as such the `appplatform.SpringCloudNewRelicApplicationPerformanceMonitoring` resource is deprecated and will be removed in a future major version of the AzureRM Provider. See https://aka.ms/asaretirement for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        example_spring_cloud_service = azure.appplatform.SpringCloudService("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            sku_name="E0")
        example_spring_cloud_new_relic_application_performance_monitoring = azure.appplatform.SpringCloudNewRelicApplicationPerformanceMonitoring("example",
            name="example",
            spring_cloud_service_id=example_spring_cloud_service.id,
            app_name="example-app-name",
            license_key="example-license-key",
            app_server_port=8080,
            labels={
                "tagName1": "tagValue1",
                "tagName2": "tagValue2",
            },
            globally_enabled=True)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AppPlatform`: 2024-01-01-preview

        ## Import

        Spring Cloud Application Performance Monitoring resource for New Relic can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appplatform/springCloudNewRelicApplicationPerformanceMonitoring:SpringCloudNewRelicApplicationPerformanceMonitoring example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.AppPlatform/spring/service1/apms/apm1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] agent_enabled: Specifies whether enable the agent. Defaults to `true`.
        :param pulumi.Input[_builtins.str] app_name: Specifies the application name used to report data to New Relic.
        :param pulumi.Input[_builtins.int] app_server_port: Specifies the port number to differentiate JVMs for the same app on the same machine.
        :param pulumi.Input[_builtins.bool] audit_mode_enabled: Specifies whether enable plain text logging of all data sent to New Relic to the agent logfile. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] auto_app_naming_enabled: Specifies whether enable the reporting of data separately for each web app. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] auto_transaction_naming_enabled: Specifies whether enable the component-based transaction naming. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] custom_tracing_enabled: Specifies whether enable all instrumentation using an `@Trace` annotation. Disabling this causes `@Trace` annotations to be ignored. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] globally_enabled: Specifies whether the Spring Cloud Application Performance Monitoring resource for Application Insights is enabled globally. Defaults to `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Specifies a mapping of labels to be added to the New Relic application.
        :param pulumi.Input[_builtins.str] license_key: Specifies the license key associated with the New Relic account. This key binds your agent's data to your account in New Relic service.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Spring Cloud Application Performance Monitoring resource for New Relic. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] spring_cloud_service_id: The ID of the Spring Cloud Service. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SpringCloudNewRelicApplicationPerformanceMonitoringArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > **Note:** This resource is only applicable for Spring Cloud Service enterprise tier

        Manages a Spring Cloud Application Performance Monitoring resource for New Relic.

        !> **Note:** Azure Spring Apps is now deprecated and will be retired on 2028-05-31 - as such the `appplatform.SpringCloudNewRelicApplicationPerformanceMonitoring` resource is deprecated and will be removed in a future major version of the AzureRM Provider. See https://aka.ms/asaretirement for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        example_spring_cloud_service = azure.appplatform.SpringCloudService("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            sku_name="E0")
        example_spring_cloud_new_relic_application_performance_monitoring = azure.appplatform.SpringCloudNewRelicApplicationPerformanceMonitoring("example",
            name="example",
            spring_cloud_service_id=example_spring_cloud_service.id,
            app_name="example-app-name",
            license_key="example-license-key",
            app_server_port=8080,
            labels={
                "tagName1": "tagValue1",
                "tagName2": "tagValue2",
            },
            globally_enabled=True)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AppPlatform`: 2024-01-01-preview

        ## Import

        Spring Cloud Application Performance Monitoring resource for New Relic can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appplatform/springCloudNewRelicApplicationPerformanceMonitoring:SpringCloudNewRelicApplicationPerformanceMonitoring example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.AppPlatform/spring/service1/apms/apm1
        ```

        :param str resource_name: The name of the resource.
        :param SpringCloudNewRelicApplicationPerformanceMonitoringArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SpringCloudNewRelicApplicationPerformanceMonitoringArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 app_name: Optional[pulumi.Input[_builtins.str]] = None,
                 app_server_port: Optional[pulumi.Input[_builtins.int]] = None,
                 audit_mode_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_app_naming_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_transaction_naming_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 custom_tracing_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 globally_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 license_key: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 spring_cloud_service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SpringCloudNewRelicApplicationPerformanceMonitoringArgs.__new__(SpringCloudNewRelicApplicationPerformanceMonitoringArgs)

            __props__.__dict__["agent_enabled"] = agent_enabled
            if app_name is None and not opts.urn:
                raise TypeError("Missing required property 'app_name'")
            __props__.__dict__["app_name"] = app_name
            __props__.__dict__["app_server_port"] = app_server_port
            __props__.__dict__["audit_mode_enabled"] = audit_mode_enabled
            __props__.__dict__["auto_app_naming_enabled"] = auto_app_naming_enabled
            __props__.__dict__["auto_transaction_naming_enabled"] = auto_transaction_naming_enabled
            __props__.__dict__["custom_tracing_enabled"] = custom_tracing_enabled
            __props__.__dict__["globally_enabled"] = globally_enabled
            __props__.__dict__["labels"] = labels
            if license_key is None and not opts.urn:
                raise TypeError("Missing required property 'license_key'")
            __props__.__dict__["license_key"] = None if license_key is None else pulumi.Output.secret(license_key)
            __props__.__dict__["name"] = name
            if spring_cloud_service_id is None and not opts.urn:
                raise TypeError("Missing required property 'spring_cloud_service_id'")
            __props__.__dict__["spring_cloud_service_id"] = spring_cloud_service_id
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["licenseKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(SpringCloudNewRelicApplicationPerformanceMonitoring, __self__).__init__(
            'azure:appplatform/springCloudNewRelicApplicationPerformanceMonitoring:SpringCloudNewRelicApplicationPerformanceMonitoring',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agent_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            app_name: Optional[pulumi.Input[_builtins.str]] = None,
            app_server_port: Optional[pulumi.Input[_builtins.int]] = None,
            audit_mode_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            auto_app_naming_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            auto_transaction_naming_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            custom_tracing_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            globally_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            license_key: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            spring_cloud_service_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'SpringCloudNewRelicApplicationPerformanceMonitoring':
        """
        Get an existing SpringCloudNewRelicApplicationPerformanceMonitoring resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] agent_enabled: Specifies whether enable the agent. Defaults to `true`.
        :param pulumi.Input[_builtins.str] app_name: Specifies the application name used to report data to New Relic.
        :param pulumi.Input[_builtins.int] app_server_port: Specifies the port number to differentiate JVMs for the same app on the same machine.
        :param pulumi.Input[_builtins.bool] audit_mode_enabled: Specifies whether enable plain text logging of all data sent to New Relic to the agent logfile. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] auto_app_naming_enabled: Specifies whether enable the reporting of data separately for each web app. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] auto_transaction_naming_enabled: Specifies whether enable the component-based transaction naming. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] custom_tracing_enabled: Specifies whether enable all instrumentation using an `@Trace` annotation. Disabling this causes `@Trace` annotations to be ignored. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] globally_enabled: Specifies whether the Spring Cloud Application Performance Monitoring resource for Application Insights is enabled globally. Defaults to `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Specifies a mapping of labels to be added to the New Relic application.
        :param pulumi.Input[_builtins.str] license_key: Specifies the license key associated with the New Relic account. This key binds your agent's data to your account in New Relic service.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Spring Cloud Application Performance Monitoring resource for New Relic. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] spring_cloud_service_id: The ID of the Spring Cloud Service. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SpringCloudNewRelicApplicationPerformanceMonitoringState.__new__(_SpringCloudNewRelicApplicationPerformanceMonitoringState)

        __props__.__dict__["agent_enabled"] = agent_enabled
        __props__.__dict__["app_name"] = app_name
        __props__.__dict__["app_server_port"] = app_server_port
        __props__.__dict__["audit_mode_enabled"] = audit_mode_enabled
        __props__.__dict__["auto_app_naming_enabled"] = auto_app_naming_enabled
        __props__.__dict__["auto_transaction_naming_enabled"] = auto_transaction_naming_enabled
        __props__.__dict__["custom_tracing_enabled"] = custom_tracing_enabled
        __props__.__dict__["globally_enabled"] = globally_enabled
        __props__.__dict__["labels"] = labels
        __props__.__dict__["license_key"] = license_key
        __props__.__dict__["name"] = name
        __props__.__dict__["spring_cloud_service_id"] = spring_cloud_service_id
        return SpringCloudNewRelicApplicationPerformanceMonitoring(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="agentEnabled")
    def agent_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether enable the agent. Defaults to `true`.
        """
        return pulumi.get(self, "agent_enabled")

    @_builtins.property
    @pulumi.getter(name="appName")
    def app_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the application name used to report data to New Relic.
        """
        return pulumi.get(self, "app_name")

    @_builtins.property
    @pulumi.getter(name="appServerPort")
    def app_server_port(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the port number to differentiate JVMs for the same app on the same machine.
        """
        return pulumi.get(self, "app_server_port")

    @_builtins.property
    @pulumi.getter(name="auditModeEnabled")
    def audit_mode_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether enable plain text logging of all data sent to New Relic to the agent logfile. Defaults to `false`.
        """
        return pulumi.get(self, "audit_mode_enabled")

    @_builtins.property
    @pulumi.getter(name="autoAppNamingEnabled")
    def auto_app_naming_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether enable the reporting of data separately for each web app. Defaults to `false`.
        """
        return pulumi.get(self, "auto_app_naming_enabled")

    @_builtins.property
    @pulumi.getter(name="autoTransactionNamingEnabled")
    def auto_transaction_naming_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether enable the component-based transaction naming. Defaults to `true`.
        """
        return pulumi.get(self, "auto_transaction_naming_enabled")

    @_builtins.property
    @pulumi.getter(name="customTracingEnabled")
    def custom_tracing_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether enable all instrumentation using an `@Trace` annotation. Disabling this causes `@Trace` annotations to be ignored. Defaults to `true`.
        """
        return pulumi.get(self, "custom_tracing_enabled")

    @_builtins.property
    @pulumi.getter(name="globallyEnabled")
    def globally_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether the Spring Cloud Application Performance Monitoring resource for Application Insights is enabled globally. Defaults to `false`.
        """
        return pulumi.get(self, "globally_enabled")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies a mapping of labels to be added to the New Relic application.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="licenseKey")
    def license_key(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the license key associated with the New Relic account. This key binds your agent's data to your account in New Relic service.
        """
        return pulumi.get(self, "license_key")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Spring Cloud Application Performance Monitoring resource for New Relic. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="springCloudServiceId")
    def spring_cloud_service_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Spring Cloud Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "spring_cloud_service_id")

