# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LinuxFunctionAppSlotArgs', 'LinuxFunctionAppSlot']

@pulumi.input_type
class LinuxFunctionAppSlotArgs:
    def __init__(__self__, *,
                 function_app_id: pulumi.Input[_builtins.str],
                 site_config: pulumi.Input['LinuxFunctionAppSlotSiteConfigArgs'],
                 app_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 auth_settings: Optional[pulumi.Input['LinuxFunctionAppSlotAuthSettingsArgs']] = None,
                 auth_settings_v2: Optional[pulumi.Input['LinuxFunctionAppSlotAuthSettingsV2Args']] = None,
                 backup: Optional[pulumi.Input['LinuxFunctionAppSlotBackupArgs']] = None,
                 builtin_logging_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_certificate_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_certificate_exclusion_paths: Optional[pulumi.Input[_builtins.str]] = None,
                 client_certificate_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxFunctionAppSlotConnectionStringArgs']]]] = None,
                 content_share_force_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 daily_memory_time_quota: Optional[pulumi.Input[_builtins.int]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ftp_publish_basic_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 functions_extension_version: Optional[pulumi.Input[_builtins.str]] = None,
                 https_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input['LinuxFunctionAppSlotIdentityArgs']] = None,
                 key_vault_reference_identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 service_plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxFunctionAppSlotStorageAccountArgs']]]] = None,
                 storage_key_vault_secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_uses_managed_identity: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 virtual_network_backup_restore_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 virtual_network_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vnet_image_pull_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 webdeploy_publish_basic_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a LinuxFunctionAppSlot resource.
        :param pulumi.Input[_builtins.str] function_app_id: The ID of the Linux Function App this Slot is a member of. Changing this forces a new resource to be created.
        :param pulumi.Input['LinuxFunctionAppSlotSiteConfigArgs'] site_config: a `site_config` block as detailed below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] app_settings: A map of key-value pairs for [App Settings](https://docs.microsoft.com/azure/azure-functions/functions-app-settings) and custom values.
        :param pulumi.Input['LinuxFunctionAppSlotAuthSettingsArgs'] auth_settings: an `auth_settings` block as detailed below.
        :param pulumi.Input['LinuxFunctionAppSlotAuthSettingsV2Args'] auth_settings_v2: an `auth_settings_v2` block as detailed below.
        :param pulumi.Input['LinuxFunctionAppSlotBackupArgs'] backup: a `backup` block as detailed below.
        :param pulumi.Input[_builtins.bool] builtin_logging_enabled: Should built in logging be enabled. Configures `AzureWebJobsDashboard` app setting based on the configured storage setting. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] client_certificate_enabled: Should the Function App Slot use Client Certificates.
        :param pulumi.Input[_builtins.str] client_certificate_exclusion_paths: Paths to exclude when using client certificates, separated by ;
        :param pulumi.Input[_builtins.str] client_certificate_mode: The mode of the Function App Slot's client certificates requirement for incoming requests. Possible values are `Required`, `Optional`, and `OptionalInteractiveUser`. Defaults to `Optional`.
        :param pulumi.Input[Sequence[pulumi.Input['LinuxFunctionAppSlotConnectionStringArgs']]] connection_strings: a `connection_string` block as detailed below.
        :param pulumi.Input[_builtins.bool] content_share_force_disabled: Force disable the content share settings.
        :param pulumi.Input[_builtins.int] daily_memory_time_quota: The amount of memory in gigabyte-seconds that your application is allowed to consume per day. Setting this value only affects function apps in Consumption Plans. Defaults to `0`.
        :param pulumi.Input[_builtins.bool] enabled: Is the Linux Function App Slot enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] ftp_publish_basic_authentication_enabled: Are the default FTP Basic Authentication publishing credentials enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.str] functions_extension_version: The runtime version associated with the Function App Slot. Defaults to `~4`.
        :param pulumi.Input[_builtins.bool] https_only: Can the Function App Slot only be accessed via HTTPS?. Defaults to `false`.
        :param pulumi.Input['LinuxFunctionAppSlotIdentityArgs'] identity: An `identity` block as detailed below.
        :param pulumi.Input[_builtins.str] key_vault_reference_identity_id: The User Assigned Identity ID used for accessing KeyVault secrets. The identity must be assigned to the application in the `identity` block. [For more information see - Access vaults with a user-assigned identity](https://docs.microsoft.com/azure/app-service/app-service-key-vault-references#access-vaults-with-a-user-assigned-identity)
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Function App Slot. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Should public network access be enabled for the Function App. Defaults to `true`.
        :param pulumi.Input[_builtins.str] service_plan_id: The ID of the Service Plan in which to run this slot. If not specified the same Service Plan as the Linux Function App will be used.
        :param pulumi.Input[_builtins.str] storage_account_access_key: The access key which will be used to access the storage account for the Function App Slot.
        :param pulumi.Input[_builtins.str] storage_account_name: The backend storage account name which will be used by this Function App Slot.
        :param pulumi.Input[Sequence[pulumi.Input['LinuxFunctionAppSlotStorageAccountArgs']]] storage_accounts: One or more `storage_account` blocks as defined below.
        :param pulumi.Input[_builtins.str] storage_key_vault_secret_id: The Key Vault Secret ID, optionally including version, that contains the Connection String to connect to the storage account for this Function App.
               
               > **Note:** `storage_key_vault_secret_id` cannot be used with `storage_account_name`.
               
               > **Note:** `storage_key_vault_secret_id` used without a version will use the latest version of the secret, however, the service can take up to 24h to pick up a rotation of the latest version. See the [official docs](https://docs.microsoft.com/azure/app-service/app-service-key-vault-references#rotation) for more information.
        :param pulumi.Input[_builtins.bool] storage_uses_managed_identity: Should the Function App Slot use its Managed Identity to access storage.
               
               > **Note:** One of `storage_account_access_key` or `storage_uses_managed_identity` must be specified when using `storage_account_name`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Linux Function App.
        :param pulumi.Input[_builtins.bool] virtual_network_backup_restore_enabled: Whether backup and restore operations over the linked virtual network are enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] vnet_image_pull_enabled: Specifies whether traffic for the image pull should be routed over virtual network. Defaults to `false`.
               
               > **Note:** The feature can also be enabled via the app setting `WEBSITE_PULL_IMAGE_OVER_VNET`. The Setting is enabled by default for an app running in the App Service Environment.
        :param pulumi.Input[_builtins.bool] webdeploy_publish_basic_authentication_enabled: Should the default WebDeploy Basic Authentication publishing credentials enabled. Defaults to `true`.
        """
        pulumi.set(__self__, "function_app_id", function_app_id)
        pulumi.set(__self__, "site_config", site_config)
        if app_settings is not None:
            pulumi.set(__self__, "app_settings", app_settings)
        if auth_settings is not None:
            pulumi.set(__self__, "auth_settings", auth_settings)
        if auth_settings_v2 is not None:
            pulumi.set(__self__, "auth_settings_v2", auth_settings_v2)
        if backup is not None:
            pulumi.set(__self__, "backup", backup)
        if builtin_logging_enabled is not None:
            pulumi.set(__self__, "builtin_logging_enabled", builtin_logging_enabled)
        if client_certificate_enabled is not None:
            pulumi.set(__self__, "client_certificate_enabled", client_certificate_enabled)
        if client_certificate_exclusion_paths is not None:
            pulumi.set(__self__, "client_certificate_exclusion_paths", client_certificate_exclusion_paths)
        if client_certificate_mode is not None:
            pulumi.set(__self__, "client_certificate_mode", client_certificate_mode)
        if connection_strings is not None:
            pulumi.set(__self__, "connection_strings", connection_strings)
        if content_share_force_disabled is not None:
            pulumi.set(__self__, "content_share_force_disabled", content_share_force_disabled)
        if daily_memory_time_quota is not None:
            pulumi.set(__self__, "daily_memory_time_quota", daily_memory_time_quota)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if ftp_publish_basic_authentication_enabled is not None:
            pulumi.set(__self__, "ftp_publish_basic_authentication_enabled", ftp_publish_basic_authentication_enabled)
        if functions_extension_version is not None:
            pulumi.set(__self__, "functions_extension_version", functions_extension_version)
        if https_only is not None:
            pulumi.set(__self__, "https_only", https_only)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if key_vault_reference_identity_id is not None:
            pulumi.set(__self__, "key_vault_reference_identity_id", key_vault_reference_identity_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if service_plan_id is not None:
            pulumi.set(__self__, "service_plan_id", service_plan_id)
        if storage_account_access_key is not None:
            pulumi.set(__self__, "storage_account_access_key", storage_account_access_key)
        if storage_account_name is not None:
            pulumi.set(__self__, "storage_account_name", storage_account_name)
        if storage_accounts is not None:
            pulumi.set(__self__, "storage_accounts", storage_accounts)
        if storage_key_vault_secret_id is not None:
            pulumi.set(__self__, "storage_key_vault_secret_id", storage_key_vault_secret_id)
        if storage_uses_managed_identity is not None:
            pulumi.set(__self__, "storage_uses_managed_identity", storage_uses_managed_identity)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if virtual_network_backup_restore_enabled is not None:
            pulumi.set(__self__, "virtual_network_backup_restore_enabled", virtual_network_backup_restore_enabled)
        if virtual_network_subnet_id is not None:
            pulumi.set(__self__, "virtual_network_subnet_id", virtual_network_subnet_id)
        if vnet_image_pull_enabled is not None:
            pulumi.set(__self__, "vnet_image_pull_enabled", vnet_image_pull_enabled)
        if webdeploy_publish_basic_authentication_enabled is not None:
            pulumi.set(__self__, "webdeploy_publish_basic_authentication_enabled", webdeploy_publish_basic_authentication_enabled)

    @_builtins.property
    @pulumi.getter(name="functionAppId")
    def function_app_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Linux Function App this Slot is a member of. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "function_app_id")

    @function_app_id.setter
    def function_app_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "function_app_id", value)

    @_builtins.property
    @pulumi.getter(name="siteConfig")
    def site_config(self) -> pulumi.Input['LinuxFunctionAppSlotSiteConfigArgs']:
        """
        a `site_config` block as detailed below.
        """
        return pulumi.get(self, "site_config")

    @site_config.setter
    def site_config(self, value: pulumi.Input['LinuxFunctionAppSlotSiteConfigArgs']):
        pulumi.set(self, "site_config", value)

    @_builtins.property
    @pulumi.getter(name="appSettings")
    def app_settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of key-value pairs for [App Settings](https://docs.microsoft.com/azure/azure-functions/functions-app-settings) and custom values.
        """
        return pulumi.get(self, "app_settings")

    @app_settings.setter
    def app_settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "app_settings", value)

    @_builtins.property
    @pulumi.getter(name="authSettings")
    def auth_settings(self) -> Optional[pulumi.Input['LinuxFunctionAppSlotAuthSettingsArgs']]:
        """
        an `auth_settings` block as detailed below.
        """
        return pulumi.get(self, "auth_settings")

    @auth_settings.setter
    def auth_settings(self, value: Optional[pulumi.Input['LinuxFunctionAppSlotAuthSettingsArgs']]):
        pulumi.set(self, "auth_settings", value)

    @_builtins.property
    @pulumi.getter(name="authSettingsV2")
    def auth_settings_v2(self) -> Optional[pulumi.Input['LinuxFunctionAppSlotAuthSettingsV2Args']]:
        """
        an `auth_settings_v2` block as detailed below.
        """
        return pulumi.get(self, "auth_settings_v2")

    @auth_settings_v2.setter
    def auth_settings_v2(self, value: Optional[pulumi.Input['LinuxFunctionAppSlotAuthSettingsV2Args']]):
        pulumi.set(self, "auth_settings_v2", value)

    @_builtins.property
    @pulumi.getter
    def backup(self) -> Optional[pulumi.Input['LinuxFunctionAppSlotBackupArgs']]:
        """
        a `backup` block as detailed below.
        """
        return pulumi.get(self, "backup")

    @backup.setter
    def backup(self, value: Optional[pulumi.Input['LinuxFunctionAppSlotBackupArgs']]):
        pulumi.set(self, "backup", value)

    @_builtins.property
    @pulumi.getter(name="builtinLoggingEnabled")
    def builtin_logging_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should built in logging be enabled. Configures `AzureWebJobsDashboard` app setting based on the configured storage setting. Defaults to `true`.
        """
        return pulumi.get(self, "builtin_logging_enabled")

    @builtin_logging_enabled.setter
    def builtin_logging_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "builtin_logging_enabled", value)

    @_builtins.property
    @pulumi.getter(name="clientCertificateEnabled")
    def client_certificate_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Function App Slot use Client Certificates.
        """
        return pulumi.get(self, "client_certificate_enabled")

    @client_certificate_enabled.setter
    def client_certificate_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "client_certificate_enabled", value)

    @_builtins.property
    @pulumi.getter(name="clientCertificateExclusionPaths")
    def client_certificate_exclusion_paths(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Paths to exclude when using client certificates, separated by ;
        """
        return pulumi.get(self, "client_certificate_exclusion_paths")

    @client_certificate_exclusion_paths.setter
    def client_certificate_exclusion_paths(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_certificate_exclusion_paths", value)

    @_builtins.property
    @pulumi.getter(name="clientCertificateMode")
    def client_certificate_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mode of the Function App Slot's client certificates requirement for incoming requests. Possible values are `Required`, `Optional`, and `OptionalInteractiveUser`. Defaults to `Optional`.
        """
        return pulumi.get(self, "client_certificate_mode")

    @client_certificate_mode.setter
    def client_certificate_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_certificate_mode", value)

    @_builtins.property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LinuxFunctionAppSlotConnectionStringArgs']]]]:
        """
        a `connection_string` block as detailed below.
        """
        return pulumi.get(self, "connection_strings")

    @connection_strings.setter
    def connection_strings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxFunctionAppSlotConnectionStringArgs']]]]):
        pulumi.set(self, "connection_strings", value)

    @_builtins.property
    @pulumi.getter(name="contentShareForceDisabled")
    def content_share_force_disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Force disable the content share settings.
        """
        return pulumi.get(self, "content_share_force_disabled")

    @content_share_force_disabled.setter
    def content_share_force_disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "content_share_force_disabled", value)

    @_builtins.property
    @pulumi.getter(name="dailyMemoryTimeQuota")
    def daily_memory_time_quota(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of memory in gigabyte-seconds that your application is allowed to consume per day. Setting this value only affects function apps in Consumption Plans. Defaults to `0`.
        """
        return pulumi.get(self, "daily_memory_time_quota")

    @daily_memory_time_quota.setter
    def daily_memory_time_quota(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "daily_memory_time_quota", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the Linux Function App Slot enabled. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="ftpPublishBasicAuthenticationEnabled")
    def ftp_publish_basic_authentication_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Are the default FTP Basic Authentication publishing credentials enabled. Defaults to `true`.
        """
        return pulumi.get(self, "ftp_publish_basic_authentication_enabled")

    @ftp_publish_basic_authentication_enabled.setter
    def ftp_publish_basic_authentication_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ftp_publish_basic_authentication_enabled", value)

    @_builtins.property
    @pulumi.getter(name="functionsExtensionVersion")
    def functions_extension_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The runtime version associated with the Function App Slot. Defaults to `~4`.
        """
        return pulumi.get(self, "functions_extension_version")

    @functions_extension_version.setter
    def functions_extension_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "functions_extension_version", value)

    @_builtins.property
    @pulumi.getter(name="httpsOnly")
    def https_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Can the Function App Slot only be accessed via HTTPS?. Defaults to `false`.
        """
        return pulumi.get(self, "https_only")

    @https_only.setter
    def https_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "https_only", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['LinuxFunctionAppSlotIdentityArgs']]:
        """
        An `identity` block as detailed below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['LinuxFunctionAppSlotIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultReferenceIdentityId")
    def key_vault_reference_identity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The User Assigned Identity ID used for accessing KeyVault secrets. The identity must be assigned to the application in the `identity` block. [For more information see - Access vaults with a user-assigned identity](https://docs.microsoft.com/azure/app-service/app-service-key-vault-references#access-vaults-with-a-user-assigned-identity)
        """
        return pulumi.get(self, "key_vault_reference_identity_id")

    @key_vault_reference_identity_id.setter
    def key_vault_reference_identity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_vault_reference_identity_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Function App Slot. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should public network access be enabled for the Function App. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="servicePlanId")
    def service_plan_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Service Plan in which to run this slot. If not specified the same Service Plan as the Linux Function App will be used.
        """
        return pulumi.get(self, "service_plan_id")

    @service_plan_id.setter
    def service_plan_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_plan_id", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountAccessKey")
    def storage_account_access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The access key which will be used to access the storage account for the Function App Slot.
        """
        return pulumi.get(self, "storage_account_access_key")

    @storage_account_access_key.setter
    def storage_account_access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_access_key", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountName")
    def storage_account_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The backend storage account name which will be used by this Function App Slot.
        """
        return pulumi.get(self, "storage_account_name")

    @storage_account_name.setter
    def storage_account_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_name", value)

    @_builtins.property
    @pulumi.getter(name="storageAccounts")
    def storage_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LinuxFunctionAppSlotStorageAccountArgs']]]]:
        """
        One or more `storage_account` blocks as defined below.
        """
        return pulumi.get(self, "storage_accounts")

    @storage_accounts.setter
    def storage_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxFunctionAppSlotStorageAccountArgs']]]]):
        pulumi.set(self, "storage_accounts", value)

    @_builtins.property
    @pulumi.getter(name="storageKeyVaultSecretId")
    def storage_key_vault_secret_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Key Vault Secret ID, optionally including version, that contains the Connection String to connect to the storage account for this Function App.

        > **Note:** `storage_key_vault_secret_id` cannot be used with `storage_account_name`.

        > **Note:** `storage_key_vault_secret_id` used without a version will use the latest version of the secret, however, the service can take up to 24h to pick up a rotation of the latest version. See the [official docs](https://docs.microsoft.com/azure/app-service/app-service-key-vault-references#rotation) for more information.
        """
        return pulumi.get(self, "storage_key_vault_secret_id")

    @storage_key_vault_secret_id.setter
    def storage_key_vault_secret_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_key_vault_secret_id", value)

    @_builtins.property
    @pulumi.getter(name="storageUsesManagedIdentity")
    def storage_uses_managed_identity(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Function App Slot use its Managed Identity to access storage.

        > **Note:** One of `storage_account_access_key` or `storage_uses_managed_identity` must be specified when using `storage_account_name`.
        """
        return pulumi.get(self, "storage_uses_managed_identity")

    @storage_uses_managed_identity.setter
    def storage_uses_managed_identity(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "storage_uses_managed_identity", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Linux Function App.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="virtualNetworkBackupRestoreEnabled")
    def virtual_network_backup_restore_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether backup and restore operations over the linked virtual network are enabled. Defaults to `false`.
        """
        return pulumi.get(self, "virtual_network_backup_restore_enabled")

    @virtual_network_backup_restore_enabled.setter
    def virtual_network_backup_restore_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "virtual_network_backup_restore_enabled", value)

    @_builtins.property
    @pulumi.getter(name="virtualNetworkSubnetId")
    def virtual_network_subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "virtual_network_subnet_id")

    @virtual_network_subnet_id.setter
    def virtual_network_subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_network_subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="vnetImagePullEnabled")
    def vnet_image_pull_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether traffic for the image pull should be routed over virtual network. Defaults to `false`.

        > **Note:** The feature can also be enabled via the app setting `WEBSITE_PULL_IMAGE_OVER_VNET`. The Setting is enabled by default for an app running in the App Service Environment.
        """
        return pulumi.get(self, "vnet_image_pull_enabled")

    @vnet_image_pull_enabled.setter
    def vnet_image_pull_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "vnet_image_pull_enabled", value)

    @_builtins.property
    @pulumi.getter(name="webdeployPublishBasicAuthenticationEnabled")
    def webdeploy_publish_basic_authentication_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the default WebDeploy Basic Authentication publishing credentials enabled. Defaults to `true`.
        """
        return pulumi.get(self, "webdeploy_publish_basic_authentication_enabled")

    @webdeploy_publish_basic_authentication_enabled.setter
    def webdeploy_publish_basic_authentication_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "webdeploy_publish_basic_authentication_enabled", value)


@pulumi.input_type
class _LinuxFunctionAppSlotState:
    def __init__(__self__, *,
                 app_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 auth_settings: Optional[pulumi.Input['LinuxFunctionAppSlotAuthSettingsArgs']] = None,
                 auth_settings_v2: Optional[pulumi.Input['LinuxFunctionAppSlotAuthSettingsV2Args']] = None,
                 backup: Optional[pulumi.Input['LinuxFunctionAppSlotBackupArgs']] = None,
                 builtin_logging_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_certificate_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_certificate_exclusion_paths: Optional[pulumi.Input[_builtins.str]] = None,
                 client_certificate_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxFunctionAppSlotConnectionStringArgs']]]] = None,
                 content_share_force_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 custom_domain_verification_id: Optional[pulumi.Input[_builtins.str]] = None,
                 daily_memory_time_quota: Optional[pulumi.Input[_builtins.int]] = None,
                 default_hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ftp_publish_basic_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 function_app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 functions_extension_version: Optional[pulumi.Input[_builtins.str]] = None,
                 hosting_environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 https_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input['LinuxFunctionAppSlotIdentityArgs']] = None,
                 key_vault_reference_identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 outbound_ip_address_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 outbound_ip_addresses: Optional[pulumi.Input[_builtins.str]] = None,
                 possible_outbound_ip_address_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 possible_outbound_ip_addresses: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 service_plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 site_config: Optional[pulumi.Input['LinuxFunctionAppSlotSiteConfigArgs']] = None,
                 site_credentials: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxFunctionAppSlotSiteCredentialArgs']]]] = None,
                 storage_account_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxFunctionAppSlotStorageAccountArgs']]]] = None,
                 storage_key_vault_secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_uses_managed_identity: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 virtual_network_backup_restore_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 virtual_network_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vnet_image_pull_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 webdeploy_publish_basic_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering LinuxFunctionAppSlot resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] app_settings: A map of key-value pairs for [App Settings](https://docs.microsoft.com/azure/azure-functions/functions-app-settings) and custom values.
        :param pulumi.Input['LinuxFunctionAppSlotAuthSettingsArgs'] auth_settings: an `auth_settings` block as detailed below.
        :param pulumi.Input['LinuxFunctionAppSlotAuthSettingsV2Args'] auth_settings_v2: an `auth_settings_v2` block as detailed below.
        :param pulumi.Input['LinuxFunctionAppSlotBackupArgs'] backup: a `backup` block as detailed below.
        :param pulumi.Input[_builtins.bool] builtin_logging_enabled: Should built in logging be enabled. Configures `AzureWebJobsDashboard` app setting based on the configured storage setting. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] client_certificate_enabled: Should the Function App Slot use Client Certificates.
        :param pulumi.Input[_builtins.str] client_certificate_exclusion_paths: Paths to exclude when using client certificates, separated by ;
        :param pulumi.Input[_builtins.str] client_certificate_mode: The mode of the Function App Slot's client certificates requirement for incoming requests. Possible values are `Required`, `Optional`, and `OptionalInteractiveUser`. Defaults to `Optional`.
        :param pulumi.Input[Sequence[pulumi.Input['LinuxFunctionAppSlotConnectionStringArgs']]] connection_strings: a `connection_string` block as detailed below.
        :param pulumi.Input[_builtins.bool] content_share_force_disabled: Force disable the content share settings.
        :param pulumi.Input[_builtins.str] custom_domain_verification_id: The identifier used by App Service to perform domain ownership verification via DNS TXT record.
        :param pulumi.Input[_builtins.int] daily_memory_time_quota: The amount of memory in gigabyte-seconds that your application is allowed to consume per day. Setting this value only affects function apps in Consumption Plans. Defaults to `0`.
        :param pulumi.Input[_builtins.str] default_hostname: The default hostname of the Linux Function App Slot.
        :param pulumi.Input[_builtins.bool] enabled: Is the Linux Function App Slot enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] ftp_publish_basic_authentication_enabled: Are the default FTP Basic Authentication publishing credentials enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.str] function_app_id: The ID of the Linux Function App this Slot is a member of. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] functions_extension_version: The runtime version associated with the Function App Slot. Defaults to `~4`.
        :param pulumi.Input[_builtins.str] hosting_environment_id: The ID of the App Service Environment used by Function App Slot.
        :param pulumi.Input[_builtins.bool] https_only: Can the Function App Slot only be accessed via HTTPS?. Defaults to `false`.
        :param pulumi.Input['LinuxFunctionAppSlotIdentityArgs'] identity: An `identity` block as detailed below.
        :param pulumi.Input[_builtins.str] key_vault_reference_identity_id: The User Assigned Identity ID used for accessing KeyVault secrets. The identity must be assigned to the application in the `identity` block. [For more information see - Access vaults with a user-assigned identity](https://docs.microsoft.com/azure/app-service/app-service-key-vault-references#access-vaults-with-a-user-assigned-identity)
        :param pulumi.Input[_builtins.str] kind: The Kind value for this Linux Function App Slot.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Function App Slot. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] outbound_ip_address_lists: A list of outbound IP addresses. For example `["52.23.25.3", "52.143.43.12"]`
        :param pulumi.Input[_builtins.str] outbound_ip_addresses: A comma separated list of outbound IP addresses as a string. For example `52.23.25.3,52.143.43.12`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] possible_outbound_ip_address_lists: A list of possible outbound IP addresses, not all of which are necessarily in use. This is a superset of `outbound_ip_address_list`. For example `["52.23.25.3", "52.143.43.12"]`.
        :param pulumi.Input[_builtins.str] possible_outbound_ip_addresses: A comma separated list of possible outbound IP addresses as a string. For example `52.23.25.3,52.143.43.12,52.143.43.17`. This is a superset of `outbound_ip_addresses`. For example `["52.23.25.3", "52.143.43.12","52.143.43.17"]`.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Should public network access be enabled for the Function App. Defaults to `true`.
        :param pulumi.Input[_builtins.str] service_plan_id: The ID of the Service Plan in which to run this slot. If not specified the same Service Plan as the Linux Function App will be used.
        :param pulumi.Input['LinuxFunctionAppSlotSiteConfigArgs'] site_config: a `site_config` block as detailed below.
        :param pulumi.Input[Sequence[pulumi.Input['LinuxFunctionAppSlotSiteCredentialArgs']]] site_credentials: A `site_credential` block as defined below.
        :param pulumi.Input[_builtins.str] storage_account_access_key: The access key which will be used to access the storage account for the Function App Slot.
        :param pulumi.Input[_builtins.str] storage_account_name: The backend storage account name which will be used by this Function App Slot.
        :param pulumi.Input[Sequence[pulumi.Input['LinuxFunctionAppSlotStorageAccountArgs']]] storage_accounts: One or more `storage_account` blocks as defined below.
        :param pulumi.Input[_builtins.str] storage_key_vault_secret_id: The Key Vault Secret ID, optionally including version, that contains the Connection String to connect to the storage account for this Function App.
               
               > **Note:** `storage_key_vault_secret_id` cannot be used with `storage_account_name`.
               
               > **Note:** `storage_key_vault_secret_id` used without a version will use the latest version of the secret, however, the service can take up to 24h to pick up a rotation of the latest version. See the [official docs](https://docs.microsoft.com/azure/app-service/app-service-key-vault-references#rotation) for more information.
        :param pulumi.Input[_builtins.bool] storage_uses_managed_identity: Should the Function App Slot use its Managed Identity to access storage.
               
               > **Note:** One of `storage_account_access_key` or `storage_uses_managed_identity` must be specified when using `storage_account_name`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Linux Function App.
        :param pulumi.Input[_builtins.bool] virtual_network_backup_restore_enabled: Whether backup and restore operations over the linked virtual network are enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] vnet_image_pull_enabled: Specifies whether traffic for the image pull should be routed over virtual network. Defaults to `false`.
               
               > **Note:** The feature can also be enabled via the app setting `WEBSITE_PULL_IMAGE_OVER_VNET`. The Setting is enabled by default for an app running in the App Service Environment.
        :param pulumi.Input[_builtins.bool] webdeploy_publish_basic_authentication_enabled: Should the default WebDeploy Basic Authentication publishing credentials enabled. Defaults to `true`.
        """
        if app_settings is not None:
            pulumi.set(__self__, "app_settings", app_settings)
        if auth_settings is not None:
            pulumi.set(__self__, "auth_settings", auth_settings)
        if auth_settings_v2 is not None:
            pulumi.set(__self__, "auth_settings_v2", auth_settings_v2)
        if backup is not None:
            pulumi.set(__self__, "backup", backup)
        if builtin_logging_enabled is not None:
            pulumi.set(__self__, "builtin_logging_enabled", builtin_logging_enabled)
        if client_certificate_enabled is not None:
            pulumi.set(__self__, "client_certificate_enabled", client_certificate_enabled)
        if client_certificate_exclusion_paths is not None:
            pulumi.set(__self__, "client_certificate_exclusion_paths", client_certificate_exclusion_paths)
        if client_certificate_mode is not None:
            pulumi.set(__self__, "client_certificate_mode", client_certificate_mode)
        if connection_strings is not None:
            pulumi.set(__self__, "connection_strings", connection_strings)
        if content_share_force_disabled is not None:
            pulumi.set(__self__, "content_share_force_disabled", content_share_force_disabled)
        if custom_domain_verification_id is not None:
            pulumi.set(__self__, "custom_domain_verification_id", custom_domain_verification_id)
        if daily_memory_time_quota is not None:
            pulumi.set(__self__, "daily_memory_time_quota", daily_memory_time_quota)
        if default_hostname is not None:
            pulumi.set(__self__, "default_hostname", default_hostname)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if ftp_publish_basic_authentication_enabled is not None:
            pulumi.set(__self__, "ftp_publish_basic_authentication_enabled", ftp_publish_basic_authentication_enabled)
        if function_app_id is not None:
            pulumi.set(__self__, "function_app_id", function_app_id)
        if functions_extension_version is not None:
            pulumi.set(__self__, "functions_extension_version", functions_extension_version)
        if hosting_environment_id is not None:
            pulumi.set(__self__, "hosting_environment_id", hosting_environment_id)
        if https_only is not None:
            pulumi.set(__self__, "https_only", https_only)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if key_vault_reference_identity_id is not None:
            pulumi.set(__self__, "key_vault_reference_identity_id", key_vault_reference_identity_id)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if outbound_ip_address_lists is not None:
            pulumi.set(__self__, "outbound_ip_address_lists", outbound_ip_address_lists)
        if outbound_ip_addresses is not None:
            pulumi.set(__self__, "outbound_ip_addresses", outbound_ip_addresses)
        if possible_outbound_ip_address_lists is not None:
            pulumi.set(__self__, "possible_outbound_ip_address_lists", possible_outbound_ip_address_lists)
        if possible_outbound_ip_addresses is not None:
            pulumi.set(__self__, "possible_outbound_ip_addresses", possible_outbound_ip_addresses)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if service_plan_id is not None:
            pulumi.set(__self__, "service_plan_id", service_plan_id)
        if site_config is not None:
            pulumi.set(__self__, "site_config", site_config)
        if site_credentials is not None:
            pulumi.set(__self__, "site_credentials", site_credentials)
        if storage_account_access_key is not None:
            pulumi.set(__self__, "storage_account_access_key", storage_account_access_key)
        if storage_account_name is not None:
            pulumi.set(__self__, "storage_account_name", storage_account_name)
        if storage_accounts is not None:
            pulumi.set(__self__, "storage_accounts", storage_accounts)
        if storage_key_vault_secret_id is not None:
            pulumi.set(__self__, "storage_key_vault_secret_id", storage_key_vault_secret_id)
        if storage_uses_managed_identity is not None:
            pulumi.set(__self__, "storage_uses_managed_identity", storage_uses_managed_identity)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if virtual_network_backup_restore_enabled is not None:
            pulumi.set(__self__, "virtual_network_backup_restore_enabled", virtual_network_backup_restore_enabled)
        if virtual_network_subnet_id is not None:
            pulumi.set(__self__, "virtual_network_subnet_id", virtual_network_subnet_id)
        if vnet_image_pull_enabled is not None:
            pulumi.set(__self__, "vnet_image_pull_enabled", vnet_image_pull_enabled)
        if webdeploy_publish_basic_authentication_enabled is not None:
            pulumi.set(__self__, "webdeploy_publish_basic_authentication_enabled", webdeploy_publish_basic_authentication_enabled)

    @_builtins.property
    @pulumi.getter(name="appSettings")
    def app_settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of key-value pairs for [App Settings](https://docs.microsoft.com/azure/azure-functions/functions-app-settings) and custom values.
        """
        return pulumi.get(self, "app_settings")

    @app_settings.setter
    def app_settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "app_settings", value)

    @_builtins.property
    @pulumi.getter(name="authSettings")
    def auth_settings(self) -> Optional[pulumi.Input['LinuxFunctionAppSlotAuthSettingsArgs']]:
        """
        an `auth_settings` block as detailed below.
        """
        return pulumi.get(self, "auth_settings")

    @auth_settings.setter
    def auth_settings(self, value: Optional[pulumi.Input['LinuxFunctionAppSlotAuthSettingsArgs']]):
        pulumi.set(self, "auth_settings", value)

    @_builtins.property
    @pulumi.getter(name="authSettingsV2")
    def auth_settings_v2(self) -> Optional[pulumi.Input['LinuxFunctionAppSlotAuthSettingsV2Args']]:
        """
        an `auth_settings_v2` block as detailed below.
        """
        return pulumi.get(self, "auth_settings_v2")

    @auth_settings_v2.setter
    def auth_settings_v2(self, value: Optional[pulumi.Input['LinuxFunctionAppSlotAuthSettingsV2Args']]):
        pulumi.set(self, "auth_settings_v2", value)

    @_builtins.property
    @pulumi.getter
    def backup(self) -> Optional[pulumi.Input['LinuxFunctionAppSlotBackupArgs']]:
        """
        a `backup` block as detailed below.
        """
        return pulumi.get(self, "backup")

    @backup.setter
    def backup(self, value: Optional[pulumi.Input['LinuxFunctionAppSlotBackupArgs']]):
        pulumi.set(self, "backup", value)

    @_builtins.property
    @pulumi.getter(name="builtinLoggingEnabled")
    def builtin_logging_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should built in logging be enabled. Configures `AzureWebJobsDashboard` app setting based on the configured storage setting. Defaults to `true`.
        """
        return pulumi.get(self, "builtin_logging_enabled")

    @builtin_logging_enabled.setter
    def builtin_logging_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "builtin_logging_enabled", value)

    @_builtins.property
    @pulumi.getter(name="clientCertificateEnabled")
    def client_certificate_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Function App Slot use Client Certificates.
        """
        return pulumi.get(self, "client_certificate_enabled")

    @client_certificate_enabled.setter
    def client_certificate_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "client_certificate_enabled", value)

    @_builtins.property
    @pulumi.getter(name="clientCertificateExclusionPaths")
    def client_certificate_exclusion_paths(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Paths to exclude when using client certificates, separated by ;
        """
        return pulumi.get(self, "client_certificate_exclusion_paths")

    @client_certificate_exclusion_paths.setter
    def client_certificate_exclusion_paths(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_certificate_exclusion_paths", value)

    @_builtins.property
    @pulumi.getter(name="clientCertificateMode")
    def client_certificate_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mode of the Function App Slot's client certificates requirement for incoming requests. Possible values are `Required`, `Optional`, and `OptionalInteractiveUser`. Defaults to `Optional`.
        """
        return pulumi.get(self, "client_certificate_mode")

    @client_certificate_mode.setter
    def client_certificate_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_certificate_mode", value)

    @_builtins.property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LinuxFunctionAppSlotConnectionStringArgs']]]]:
        """
        a `connection_string` block as detailed below.
        """
        return pulumi.get(self, "connection_strings")

    @connection_strings.setter
    def connection_strings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxFunctionAppSlotConnectionStringArgs']]]]):
        pulumi.set(self, "connection_strings", value)

    @_builtins.property
    @pulumi.getter(name="contentShareForceDisabled")
    def content_share_force_disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Force disable the content share settings.
        """
        return pulumi.get(self, "content_share_force_disabled")

    @content_share_force_disabled.setter
    def content_share_force_disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "content_share_force_disabled", value)

    @_builtins.property
    @pulumi.getter(name="customDomainVerificationId")
    def custom_domain_verification_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier used by App Service to perform domain ownership verification via DNS TXT record.
        """
        return pulumi.get(self, "custom_domain_verification_id")

    @custom_domain_verification_id.setter
    def custom_domain_verification_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_domain_verification_id", value)

    @_builtins.property
    @pulumi.getter(name="dailyMemoryTimeQuota")
    def daily_memory_time_quota(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of memory in gigabyte-seconds that your application is allowed to consume per day. Setting this value only affects function apps in Consumption Plans. Defaults to `0`.
        """
        return pulumi.get(self, "daily_memory_time_quota")

    @daily_memory_time_quota.setter
    def daily_memory_time_quota(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "daily_memory_time_quota", value)

    @_builtins.property
    @pulumi.getter(name="defaultHostname")
    def default_hostname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default hostname of the Linux Function App Slot.
        """
        return pulumi.get(self, "default_hostname")

    @default_hostname.setter
    def default_hostname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_hostname", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the Linux Function App Slot enabled. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="ftpPublishBasicAuthenticationEnabled")
    def ftp_publish_basic_authentication_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Are the default FTP Basic Authentication publishing credentials enabled. Defaults to `true`.
        """
        return pulumi.get(self, "ftp_publish_basic_authentication_enabled")

    @ftp_publish_basic_authentication_enabled.setter
    def ftp_publish_basic_authentication_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ftp_publish_basic_authentication_enabled", value)

    @_builtins.property
    @pulumi.getter(name="functionAppId")
    def function_app_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Linux Function App this Slot is a member of. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "function_app_id")

    @function_app_id.setter
    def function_app_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "function_app_id", value)

    @_builtins.property
    @pulumi.getter(name="functionsExtensionVersion")
    def functions_extension_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The runtime version associated with the Function App Slot. Defaults to `~4`.
        """
        return pulumi.get(self, "functions_extension_version")

    @functions_extension_version.setter
    def functions_extension_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "functions_extension_version", value)

    @_builtins.property
    @pulumi.getter(name="hostingEnvironmentId")
    def hosting_environment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the App Service Environment used by Function App Slot.
        """
        return pulumi.get(self, "hosting_environment_id")

    @hosting_environment_id.setter
    def hosting_environment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hosting_environment_id", value)

    @_builtins.property
    @pulumi.getter(name="httpsOnly")
    def https_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Can the Function App Slot only be accessed via HTTPS?. Defaults to `false`.
        """
        return pulumi.get(self, "https_only")

    @https_only.setter
    def https_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "https_only", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['LinuxFunctionAppSlotIdentityArgs']]:
        """
        An `identity` block as detailed below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['LinuxFunctionAppSlotIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultReferenceIdentityId")
    def key_vault_reference_identity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The User Assigned Identity ID used for accessing KeyVault secrets. The identity must be assigned to the application in the `identity` block. [For more information see - Access vaults with a user-assigned identity](https://docs.microsoft.com/azure/app-service/app-service-key-vault-references#access-vaults-with-a-user-assigned-identity)
        """
        return pulumi.get(self, "key_vault_reference_identity_id")

    @key_vault_reference_identity_id.setter
    def key_vault_reference_identity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_vault_reference_identity_id", value)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Kind value for this Linux Function App Slot.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kind", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Function App Slot. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="outboundIpAddressLists")
    def outbound_ip_address_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of outbound IP addresses. For example `["52.23.25.3", "52.143.43.12"]`
        """
        return pulumi.get(self, "outbound_ip_address_lists")

    @outbound_ip_address_lists.setter
    def outbound_ip_address_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "outbound_ip_address_lists", value)

    @_builtins.property
    @pulumi.getter(name="outboundIpAddresses")
    def outbound_ip_addresses(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A comma separated list of outbound IP addresses as a string. For example `52.23.25.3,52.143.43.12`.
        """
        return pulumi.get(self, "outbound_ip_addresses")

    @outbound_ip_addresses.setter
    def outbound_ip_addresses(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "outbound_ip_addresses", value)

    @_builtins.property
    @pulumi.getter(name="possibleOutboundIpAddressLists")
    def possible_outbound_ip_address_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of possible outbound IP addresses, not all of which are necessarily in use. This is a superset of `outbound_ip_address_list`. For example `["52.23.25.3", "52.143.43.12"]`.
        """
        return pulumi.get(self, "possible_outbound_ip_address_lists")

    @possible_outbound_ip_address_lists.setter
    def possible_outbound_ip_address_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "possible_outbound_ip_address_lists", value)

    @_builtins.property
    @pulumi.getter(name="possibleOutboundIpAddresses")
    def possible_outbound_ip_addresses(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A comma separated list of possible outbound IP addresses as a string. For example `52.23.25.3,52.143.43.12,52.143.43.17`. This is a superset of `outbound_ip_addresses`. For example `["52.23.25.3", "52.143.43.12","52.143.43.17"]`.
        """
        return pulumi.get(self, "possible_outbound_ip_addresses")

    @possible_outbound_ip_addresses.setter
    def possible_outbound_ip_addresses(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "possible_outbound_ip_addresses", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should public network access be enabled for the Function App. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="servicePlanId")
    def service_plan_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Service Plan in which to run this slot. If not specified the same Service Plan as the Linux Function App will be used.
        """
        return pulumi.get(self, "service_plan_id")

    @service_plan_id.setter
    def service_plan_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_plan_id", value)

    @_builtins.property
    @pulumi.getter(name="siteConfig")
    def site_config(self) -> Optional[pulumi.Input['LinuxFunctionAppSlotSiteConfigArgs']]:
        """
        a `site_config` block as detailed below.
        """
        return pulumi.get(self, "site_config")

    @site_config.setter
    def site_config(self, value: Optional[pulumi.Input['LinuxFunctionAppSlotSiteConfigArgs']]):
        pulumi.set(self, "site_config", value)

    @_builtins.property
    @pulumi.getter(name="siteCredentials")
    def site_credentials(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LinuxFunctionAppSlotSiteCredentialArgs']]]]:
        """
        A `site_credential` block as defined below.
        """
        return pulumi.get(self, "site_credentials")

    @site_credentials.setter
    def site_credentials(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxFunctionAppSlotSiteCredentialArgs']]]]):
        pulumi.set(self, "site_credentials", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountAccessKey")
    def storage_account_access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The access key which will be used to access the storage account for the Function App Slot.
        """
        return pulumi.get(self, "storage_account_access_key")

    @storage_account_access_key.setter
    def storage_account_access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_access_key", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountName")
    def storage_account_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The backend storage account name which will be used by this Function App Slot.
        """
        return pulumi.get(self, "storage_account_name")

    @storage_account_name.setter
    def storage_account_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_name", value)

    @_builtins.property
    @pulumi.getter(name="storageAccounts")
    def storage_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LinuxFunctionAppSlotStorageAccountArgs']]]]:
        """
        One or more `storage_account` blocks as defined below.
        """
        return pulumi.get(self, "storage_accounts")

    @storage_accounts.setter
    def storage_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxFunctionAppSlotStorageAccountArgs']]]]):
        pulumi.set(self, "storage_accounts", value)

    @_builtins.property
    @pulumi.getter(name="storageKeyVaultSecretId")
    def storage_key_vault_secret_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Key Vault Secret ID, optionally including version, that contains the Connection String to connect to the storage account for this Function App.

        > **Note:** `storage_key_vault_secret_id` cannot be used with `storage_account_name`.

        > **Note:** `storage_key_vault_secret_id` used without a version will use the latest version of the secret, however, the service can take up to 24h to pick up a rotation of the latest version. See the [official docs](https://docs.microsoft.com/azure/app-service/app-service-key-vault-references#rotation) for more information.
        """
        return pulumi.get(self, "storage_key_vault_secret_id")

    @storage_key_vault_secret_id.setter
    def storage_key_vault_secret_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_key_vault_secret_id", value)

    @_builtins.property
    @pulumi.getter(name="storageUsesManagedIdentity")
    def storage_uses_managed_identity(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Function App Slot use its Managed Identity to access storage.

        > **Note:** One of `storage_account_access_key` or `storage_uses_managed_identity` must be specified when using `storage_account_name`.
        """
        return pulumi.get(self, "storage_uses_managed_identity")

    @storage_uses_managed_identity.setter
    def storage_uses_managed_identity(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "storage_uses_managed_identity", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Linux Function App.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="virtualNetworkBackupRestoreEnabled")
    def virtual_network_backup_restore_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether backup and restore operations over the linked virtual network are enabled. Defaults to `false`.
        """
        return pulumi.get(self, "virtual_network_backup_restore_enabled")

    @virtual_network_backup_restore_enabled.setter
    def virtual_network_backup_restore_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "virtual_network_backup_restore_enabled", value)

    @_builtins.property
    @pulumi.getter(name="virtualNetworkSubnetId")
    def virtual_network_subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "virtual_network_subnet_id")

    @virtual_network_subnet_id.setter
    def virtual_network_subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_network_subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="vnetImagePullEnabled")
    def vnet_image_pull_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether traffic for the image pull should be routed over virtual network. Defaults to `false`.

        > **Note:** The feature can also be enabled via the app setting `WEBSITE_PULL_IMAGE_OVER_VNET`. The Setting is enabled by default for an app running in the App Service Environment.
        """
        return pulumi.get(self, "vnet_image_pull_enabled")

    @vnet_image_pull_enabled.setter
    def vnet_image_pull_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "vnet_image_pull_enabled", value)

    @_builtins.property
    @pulumi.getter(name="webdeployPublishBasicAuthenticationEnabled")
    def webdeploy_publish_basic_authentication_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the default WebDeploy Basic Authentication publishing credentials enabled. Defaults to `true`.
        """
        return pulumi.get(self, "webdeploy_publish_basic_authentication_enabled")

    @webdeploy_publish_basic_authentication_enabled.setter
    def webdeploy_publish_basic_authentication_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "webdeploy_publish_basic_authentication_enabled", value)


@pulumi.type_token("azure:appservice/linuxFunctionAppSlot:LinuxFunctionAppSlot")
class LinuxFunctionAppSlot(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 auth_settings: Optional[pulumi.Input[Union['LinuxFunctionAppSlotAuthSettingsArgs', 'LinuxFunctionAppSlotAuthSettingsArgsDict']]] = None,
                 auth_settings_v2: Optional[pulumi.Input[Union['LinuxFunctionAppSlotAuthSettingsV2Args', 'LinuxFunctionAppSlotAuthSettingsV2ArgsDict']]] = None,
                 backup: Optional[pulumi.Input[Union['LinuxFunctionAppSlotBackupArgs', 'LinuxFunctionAppSlotBackupArgsDict']]] = None,
                 builtin_logging_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_certificate_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_certificate_exclusion_paths: Optional[pulumi.Input[_builtins.str]] = None,
                 client_certificate_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LinuxFunctionAppSlotConnectionStringArgs', 'LinuxFunctionAppSlotConnectionStringArgsDict']]]]] = None,
                 content_share_force_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 daily_memory_time_quota: Optional[pulumi.Input[_builtins.int]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ftp_publish_basic_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 function_app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 functions_extension_version: Optional[pulumi.Input[_builtins.str]] = None,
                 https_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input[Union['LinuxFunctionAppSlotIdentityArgs', 'LinuxFunctionAppSlotIdentityArgsDict']]] = None,
                 key_vault_reference_identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 service_plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 site_config: Optional[pulumi.Input[Union['LinuxFunctionAppSlotSiteConfigArgs', 'LinuxFunctionAppSlotSiteConfigArgsDict']]] = None,
                 storage_account_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LinuxFunctionAppSlotStorageAccountArgs', 'LinuxFunctionAppSlotStorageAccountArgsDict']]]]] = None,
                 storage_key_vault_secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_uses_managed_identity: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 virtual_network_backup_restore_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 virtual_network_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vnet_image_pull_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 webdeploy_publish_basic_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Manages a Linux Function App Slot.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="linuxfunctionappsa",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_service_plan = azure.appservice.ServicePlan("example",
            name="example-app-service-plan",
            resource_group_name=example.name,
            location=example.location,
            os_type="Linux",
            sku_name="Y1")
        example_linux_function_app = azure.appservice.LinuxFunctionApp("example",
            name="example-linux-function-app",
            resource_group_name=example.name,
            location=example.location,
            service_plan_id=example_service_plan.id,
            storage_account_name=example_account.name,
            site_config={})
        example_linux_function_app_slot = azure.appservice.LinuxFunctionAppSlot("example",
            name="example-linux-function-app-slot",
            function_app_id=example_linux_function_app.id,
            storage_account_name=example_account.name,
            site_config={})
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Web`: 2023-12-01, 2023-01-01

        ## Import

        A Linux Function App Slot can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appservice/linuxFunctionAppSlot:LinuxFunctionAppSlot example "/subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.Web/sites/site1/slots/slot1"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] app_settings: A map of key-value pairs for [App Settings](https://docs.microsoft.com/azure/azure-functions/functions-app-settings) and custom values.
        :param pulumi.Input[Union['LinuxFunctionAppSlotAuthSettingsArgs', 'LinuxFunctionAppSlotAuthSettingsArgsDict']] auth_settings: an `auth_settings` block as detailed below.
        :param pulumi.Input[Union['LinuxFunctionAppSlotAuthSettingsV2Args', 'LinuxFunctionAppSlotAuthSettingsV2ArgsDict']] auth_settings_v2: an `auth_settings_v2` block as detailed below.
        :param pulumi.Input[Union['LinuxFunctionAppSlotBackupArgs', 'LinuxFunctionAppSlotBackupArgsDict']] backup: a `backup` block as detailed below.
        :param pulumi.Input[_builtins.bool] builtin_logging_enabled: Should built in logging be enabled. Configures `AzureWebJobsDashboard` app setting based on the configured storage setting. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] client_certificate_enabled: Should the Function App Slot use Client Certificates.
        :param pulumi.Input[_builtins.str] client_certificate_exclusion_paths: Paths to exclude when using client certificates, separated by ;
        :param pulumi.Input[_builtins.str] client_certificate_mode: The mode of the Function App Slot's client certificates requirement for incoming requests. Possible values are `Required`, `Optional`, and `OptionalInteractiveUser`. Defaults to `Optional`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LinuxFunctionAppSlotConnectionStringArgs', 'LinuxFunctionAppSlotConnectionStringArgsDict']]]] connection_strings: a `connection_string` block as detailed below.
        :param pulumi.Input[_builtins.bool] content_share_force_disabled: Force disable the content share settings.
        :param pulumi.Input[_builtins.int] daily_memory_time_quota: The amount of memory in gigabyte-seconds that your application is allowed to consume per day. Setting this value only affects function apps in Consumption Plans. Defaults to `0`.
        :param pulumi.Input[_builtins.bool] enabled: Is the Linux Function App Slot enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] ftp_publish_basic_authentication_enabled: Are the default FTP Basic Authentication publishing credentials enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.str] function_app_id: The ID of the Linux Function App this Slot is a member of. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] functions_extension_version: The runtime version associated with the Function App Slot. Defaults to `~4`.
        :param pulumi.Input[_builtins.bool] https_only: Can the Function App Slot only be accessed via HTTPS?. Defaults to `false`.
        :param pulumi.Input[Union['LinuxFunctionAppSlotIdentityArgs', 'LinuxFunctionAppSlotIdentityArgsDict']] identity: An `identity` block as detailed below.
        :param pulumi.Input[_builtins.str] key_vault_reference_identity_id: The User Assigned Identity ID used for accessing KeyVault secrets. The identity must be assigned to the application in the `identity` block. [For more information see - Access vaults with a user-assigned identity](https://docs.microsoft.com/azure/app-service/app-service-key-vault-references#access-vaults-with-a-user-assigned-identity)
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Function App Slot. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Should public network access be enabled for the Function App. Defaults to `true`.
        :param pulumi.Input[_builtins.str] service_plan_id: The ID of the Service Plan in which to run this slot. If not specified the same Service Plan as the Linux Function App will be used.
        :param pulumi.Input[Union['LinuxFunctionAppSlotSiteConfigArgs', 'LinuxFunctionAppSlotSiteConfigArgsDict']] site_config: a `site_config` block as detailed below.
        :param pulumi.Input[_builtins.str] storage_account_access_key: The access key which will be used to access the storage account for the Function App Slot.
        :param pulumi.Input[_builtins.str] storage_account_name: The backend storage account name which will be used by this Function App Slot.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LinuxFunctionAppSlotStorageAccountArgs', 'LinuxFunctionAppSlotStorageAccountArgsDict']]]] storage_accounts: One or more `storage_account` blocks as defined below.
        :param pulumi.Input[_builtins.str] storage_key_vault_secret_id: The Key Vault Secret ID, optionally including version, that contains the Connection String to connect to the storage account for this Function App.
               
               > **Note:** `storage_key_vault_secret_id` cannot be used with `storage_account_name`.
               
               > **Note:** `storage_key_vault_secret_id` used without a version will use the latest version of the secret, however, the service can take up to 24h to pick up a rotation of the latest version. See the [official docs](https://docs.microsoft.com/azure/app-service/app-service-key-vault-references#rotation) for more information.
        :param pulumi.Input[_builtins.bool] storage_uses_managed_identity: Should the Function App Slot use its Managed Identity to access storage.
               
               > **Note:** One of `storage_account_access_key` or `storage_uses_managed_identity` must be specified when using `storage_account_name`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Linux Function App.
        :param pulumi.Input[_builtins.bool] virtual_network_backup_restore_enabled: Whether backup and restore operations over the linked virtual network are enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] vnet_image_pull_enabled: Specifies whether traffic for the image pull should be routed over virtual network. Defaults to `false`.
               
               > **Note:** The feature can also be enabled via the app setting `WEBSITE_PULL_IMAGE_OVER_VNET`. The Setting is enabled by default for an app running in the App Service Environment.
        :param pulumi.Input[_builtins.bool] webdeploy_publish_basic_authentication_enabled: Should the default WebDeploy Basic Authentication publishing credentials enabled. Defaults to `true`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LinuxFunctionAppSlotArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Linux Function App Slot.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="linuxfunctionappsa",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_service_plan = azure.appservice.ServicePlan("example",
            name="example-app-service-plan",
            resource_group_name=example.name,
            location=example.location,
            os_type="Linux",
            sku_name="Y1")
        example_linux_function_app = azure.appservice.LinuxFunctionApp("example",
            name="example-linux-function-app",
            resource_group_name=example.name,
            location=example.location,
            service_plan_id=example_service_plan.id,
            storage_account_name=example_account.name,
            site_config={})
        example_linux_function_app_slot = azure.appservice.LinuxFunctionAppSlot("example",
            name="example-linux-function-app-slot",
            function_app_id=example_linux_function_app.id,
            storage_account_name=example_account.name,
            site_config={})
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Web`: 2023-12-01, 2023-01-01

        ## Import

        A Linux Function App Slot can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appservice/linuxFunctionAppSlot:LinuxFunctionAppSlot example "/subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.Web/sites/site1/slots/slot1"
        ```

        :param str resource_name: The name of the resource.
        :param LinuxFunctionAppSlotArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LinuxFunctionAppSlotArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 auth_settings: Optional[pulumi.Input[Union['LinuxFunctionAppSlotAuthSettingsArgs', 'LinuxFunctionAppSlotAuthSettingsArgsDict']]] = None,
                 auth_settings_v2: Optional[pulumi.Input[Union['LinuxFunctionAppSlotAuthSettingsV2Args', 'LinuxFunctionAppSlotAuthSettingsV2ArgsDict']]] = None,
                 backup: Optional[pulumi.Input[Union['LinuxFunctionAppSlotBackupArgs', 'LinuxFunctionAppSlotBackupArgsDict']]] = None,
                 builtin_logging_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_certificate_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_certificate_exclusion_paths: Optional[pulumi.Input[_builtins.str]] = None,
                 client_certificate_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LinuxFunctionAppSlotConnectionStringArgs', 'LinuxFunctionAppSlotConnectionStringArgsDict']]]]] = None,
                 content_share_force_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 daily_memory_time_quota: Optional[pulumi.Input[_builtins.int]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ftp_publish_basic_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 function_app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 functions_extension_version: Optional[pulumi.Input[_builtins.str]] = None,
                 https_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input[Union['LinuxFunctionAppSlotIdentityArgs', 'LinuxFunctionAppSlotIdentityArgsDict']]] = None,
                 key_vault_reference_identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 service_plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 site_config: Optional[pulumi.Input[Union['LinuxFunctionAppSlotSiteConfigArgs', 'LinuxFunctionAppSlotSiteConfigArgsDict']]] = None,
                 storage_account_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LinuxFunctionAppSlotStorageAccountArgs', 'LinuxFunctionAppSlotStorageAccountArgsDict']]]]] = None,
                 storage_key_vault_secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_uses_managed_identity: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 virtual_network_backup_restore_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 virtual_network_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vnet_image_pull_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 webdeploy_publish_basic_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LinuxFunctionAppSlotArgs.__new__(LinuxFunctionAppSlotArgs)

            __props__.__dict__["app_settings"] = app_settings
            __props__.__dict__["auth_settings"] = auth_settings
            __props__.__dict__["auth_settings_v2"] = auth_settings_v2
            __props__.__dict__["backup"] = backup
            __props__.__dict__["builtin_logging_enabled"] = builtin_logging_enabled
            __props__.__dict__["client_certificate_enabled"] = client_certificate_enabled
            __props__.__dict__["client_certificate_exclusion_paths"] = client_certificate_exclusion_paths
            __props__.__dict__["client_certificate_mode"] = client_certificate_mode
            __props__.__dict__["connection_strings"] = connection_strings
            __props__.__dict__["content_share_force_disabled"] = content_share_force_disabled
            __props__.__dict__["daily_memory_time_quota"] = daily_memory_time_quota
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["ftp_publish_basic_authentication_enabled"] = ftp_publish_basic_authentication_enabled
            if function_app_id is None and not opts.urn:
                raise TypeError("Missing required property 'function_app_id'")
            __props__.__dict__["function_app_id"] = function_app_id
            __props__.__dict__["functions_extension_version"] = functions_extension_version
            __props__.__dict__["https_only"] = https_only
            __props__.__dict__["identity"] = identity
            __props__.__dict__["key_vault_reference_identity_id"] = key_vault_reference_identity_id
            __props__.__dict__["name"] = name
            __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
            __props__.__dict__["service_plan_id"] = service_plan_id
            if site_config is None and not opts.urn:
                raise TypeError("Missing required property 'site_config'")
            __props__.__dict__["site_config"] = site_config
            __props__.__dict__["storage_account_access_key"] = None if storage_account_access_key is None else pulumi.Output.secret(storage_account_access_key)
            __props__.__dict__["storage_account_name"] = storage_account_name
            __props__.__dict__["storage_accounts"] = storage_accounts
            __props__.__dict__["storage_key_vault_secret_id"] = storage_key_vault_secret_id
            __props__.__dict__["storage_uses_managed_identity"] = storage_uses_managed_identity
            __props__.__dict__["tags"] = tags
            __props__.__dict__["virtual_network_backup_restore_enabled"] = virtual_network_backup_restore_enabled
            __props__.__dict__["virtual_network_subnet_id"] = virtual_network_subnet_id
            __props__.__dict__["vnet_image_pull_enabled"] = vnet_image_pull_enabled
            __props__.__dict__["webdeploy_publish_basic_authentication_enabled"] = webdeploy_publish_basic_authentication_enabled
            __props__.__dict__["custom_domain_verification_id"] = None
            __props__.__dict__["default_hostname"] = None
            __props__.__dict__["hosting_environment_id"] = None
            __props__.__dict__["kind"] = None
            __props__.__dict__["outbound_ip_address_lists"] = None
            __props__.__dict__["outbound_ip_addresses"] = None
            __props__.__dict__["possible_outbound_ip_address_lists"] = None
            __props__.__dict__["possible_outbound_ip_addresses"] = None
            __props__.__dict__["site_credentials"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["customDomainVerificationId", "siteCredentials", "storageAccountAccessKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(LinuxFunctionAppSlot, __self__).__init__(
            'azure:appservice/linuxFunctionAppSlot:LinuxFunctionAppSlot',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            auth_settings: Optional[pulumi.Input[Union['LinuxFunctionAppSlotAuthSettingsArgs', 'LinuxFunctionAppSlotAuthSettingsArgsDict']]] = None,
            auth_settings_v2: Optional[pulumi.Input[Union['LinuxFunctionAppSlotAuthSettingsV2Args', 'LinuxFunctionAppSlotAuthSettingsV2ArgsDict']]] = None,
            backup: Optional[pulumi.Input[Union['LinuxFunctionAppSlotBackupArgs', 'LinuxFunctionAppSlotBackupArgsDict']]] = None,
            builtin_logging_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            client_certificate_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            client_certificate_exclusion_paths: Optional[pulumi.Input[_builtins.str]] = None,
            client_certificate_mode: Optional[pulumi.Input[_builtins.str]] = None,
            connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LinuxFunctionAppSlotConnectionStringArgs', 'LinuxFunctionAppSlotConnectionStringArgsDict']]]]] = None,
            content_share_force_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
            custom_domain_verification_id: Optional[pulumi.Input[_builtins.str]] = None,
            daily_memory_time_quota: Optional[pulumi.Input[_builtins.int]] = None,
            default_hostname: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            ftp_publish_basic_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            function_app_id: Optional[pulumi.Input[_builtins.str]] = None,
            functions_extension_version: Optional[pulumi.Input[_builtins.str]] = None,
            hosting_environment_id: Optional[pulumi.Input[_builtins.str]] = None,
            https_only: Optional[pulumi.Input[_builtins.bool]] = None,
            identity: Optional[pulumi.Input[Union['LinuxFunctionAppSlotIdentityArgs', 'LinuxFunctionAppSlotIdentityArgsDict']]] = None,
            key_vault_reference_identity_id: Optional[pulumi.Input[_builtins.str]] = None,
            kind: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            outbound_ip_address_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            outbound_ip_addresses: Optional[pulumi.Input[_builtins.str]] = None,
            possible_outbound_ip_address_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            possible_outbound_ip_addresses: Optional[pulumi.Input[_builtins.str]] = None,
            public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            service_plan_id: Optional[pulumi.Input[_builtins.str]] = None,
            site_config: Optional[pulumi.Input[Union['LinuxFunctionAppSlotSiteConfigArgs', 'LinuxFunctionAppSlotSiteConfigArgsDict']]] = None,
            site_credentials: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LinuxFunctionAppSlotSiteCredentialArgs', 'LinuxFunctionAppSlotSiteCredentialArgsDict']]]]] = None,
            storage_account_access_key: Optional[pulumi.Input[_builtins.str]] = None,
            storage_account_name: Optional[pulumi.Input[_builtins.str]] = None,
            storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LinuxFunctionAppSlotStorageAccountArgs', 'LinuxFunctionAppSlotStorageAccountArgsDict']]]]] = None,
            storage_key_vault_secret_id: Optional[pulumi.Input[_builtins.str]] = None,
            storage_uses_managed_identity: Optional[pulumi.Input[_builtins.bool]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            virtual_network_backup_restore_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            virtual_network_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            vnet_image_pull_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            webdeploy_publish_basic_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None) -> 'LinuxFunctionAppSlot':
        """
        Get an existing LinuxFunctionAppSlot resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] app_settings: A map of key-value pairs for [App Settings](https://docs.microsoft.com/azure/azure-functions/functions-app-settings) and custom values.
        :param pulumi.Input[Union['LinuxFunctionAppSlotAuthSettingsArgs', 'LinuxFunctionAppSlotAuthSettingsArgsDict']] auth_settings: an `auth_settings` block as detailed below.
        :param pulumi.Input[Union['LinuxFunctionAppSlotAuthSettingsV2Args', 'LinuxFunctionAppSlotAuthSettingsV2ArgsDict']] auth_settings_v2: an `auth_settings_v2` block as detailed below.
        :param pulumi.Input[Union['LinuxFunctionAppSlotBackupArgs', 'LinuxFunctionAppSlotBackupArgsDict']] backup: a `backup` block as detailed below.
        :param pulumi.Input[_builtins.bool] builtin_logging_enabled: Should built in logging be enabled. Configures `AzureWebJobsDashboard` app setting based on the configured storage setting. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] client_certificate_enabled: Should the Function App Slot use Client Certificates.
        :param pulumi.Input[_builtins.str] client_certificate_exclusion_paths: Paths to exclude when using client certificates, separated by ;
        :param pulumi.Input[_builtins.str] client_certificate_mode: The mode of the Function App Slot's client certificates requirement for incoming requests. Possible values are `Required`, `Optional`, and `OptionalInteractiveUser`. Defaults to `Optional`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LinuxFunctionAppSlotConnectionStringArgs', 'LinuxFunctionAppSlotConnectionStringArgsDict']]]] connection_strings: a `connection_string` block as detailed below.
        :param pulumi.Input[_builtins.bool] content_share_force_disabled: Force disable the content share settings.
        :param pulumi.Input[_builtins.str] custom_domain_verification_id: The identifier used by App Service to perform domain ownership verification via DNS TXT record.
        :param pulumi.Input[_builtins.int] daily_memory_time_quota: The amount of memory in gigabyte-seconds that your application is allowed to consume per day. Setting this value only affects function apps in Consumption Plans. Defaults to `0`.
        :param pulumi.Input[_builtins.str] default_hostname: The default hostname of the Linux Function App Slot.
        :param pulumi.Input[_builtins.bool] enabled: Is the Linux Function App Slot enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] ftp_publish_basic_authentication_enabled: Are the default FTP Basic Authentication publishing credentials enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.str] function_app_id: The ID of the Linux Function App this Slot is a member of. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] functions_extension_version: The runtime version associated with the Function App Slot. Defaults to `~4`.
        :param pulumi.Input[_builtins.str] hosting_environment_id: The ID of the App Service Environment used by Function App Slot.
        :param pulumi.Input[_builtins.bool] https_only: Can the Function App Slot only be accessed via HTTPS?. Defaults to `false`.
        :param pulumi.Input[Union['LinuxFunctionAppSlotIdentityArgs', 'LinuxFunctionAppSlotIdentityArgsDict']] identity: An `identity` block as detailed below.
        :param pulumi.Input[_builtins.str] key_vault_reference_identity_id: The User Assigned Identity ID used for accessing KeyVault secrets. The identity must be assigned to the application in the `identity` block. [For more information see - Access vaults with a user-assigned identity](https://docs.microsoft.com/azure/app-service/app-service-key-vault-references#access-vaults-with-a-user-assigned-identity)
        :param pulumi.Input[_builtins.str] kind: The Kind value for this Linux Function App Slot.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Function App Slot. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] outbound_ip_address_lists: A list of outbound IP addresses. For example `["52.23.25.3", "52.143.43.12"]`
        :param pulumi.Input[_builtins.str] outbound_ip_addresses: A comma separated list of outbound IP addresses as a string. For example `52.23.25.3,52.143.43.12`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] possible_outbound_ip_address_lists: A list of possible outbound IP addresses, not all of which are necessarily in use. This is a superset of `outbound_ip_address_list`. For example `["52.23.25.3", "52.143.43.12"]`.
        :param pulumi.Input[_builtins.str] possible_outbound_ip_addresses: A comma separated list of possible outbound IP addresses as a string. For example `52.23.25.3,52.143.43.12,52.143.43.17`. This is a superset of `outbound_ip_addresses`. For example `["52.23.25.3", "52.143.43.12","52.143.43.17"]`.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Should public network access be enabled for the Function App. Defaults to `true`.
        :param pulumi.Input[_builtins.str] service_plan_id: The ID of the Service Plan in which to run this slot. If not specified the same Service Plan as the Linux Function App will be used.
        :param pulumi.Input[Union['LinuxFunctionAppSlotSiteConfigArgs', 'LinuxFunctionAppSlotSiteConfigArgsDict']] site_config: a `site_config` block as detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LinuxFunctionAppSlotSiteCredentialArgs', 'LinuxFunctionAppSlotSiteCredentialArgsDict']]]] site_credentials: A `site_credential` block as defined below.
        :param pulumi.Input[_builtins.str] storage_account_access_key: The access key which will be used to access the storage account for the Function App Slot.
        :param pulumi.Input[_builtins.str] storage_account_name: The backend storage account name which will be used by this Function App Slot.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LinuxFunctionAppSlotStorageAccountArgs', 'LinuxFunctionAppSlotStorageAccountArgsDict']]]] storage_accounts: One or more `storage_account` blocks as defined below.
        :param pulumi.Input[_builtins.str] storage_key_vault_secret_id: The Key Vault Secret ID, optionally including version, that contains the Connection String to connect to the storage account for this Function App.
               
               > **Note:** `storage_key_vault_secret_id` cannot be used with `storage_account_name`.
               
               > **Note:** `storage_key_vault_secret_id` used without a version will use the latest version of the secret, however, the service can take up to 24h to pick up a rotation of the latest version. See the [official docs](https://docs.microsoft.com/azure/app-service/app-service-key-vault-references#rotation) for more information.
        :param pulumi.Input[_builtins.bool] storage_uses_managed_identity: Should the Function App Slot use its Managed Identity to access storage.
               
               > **Note:** One of `storage_account_access_key` or `storage_uses_managed_identity` must be specified when using `storage_account_name`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Linux Function App.
        :param pulumi.Input[_builtins.bool] virtual_network_backup_restore_enabled: Whether backup and restore operations over the linked virtual network are enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] vnet_image_pull_enabled: Specifies whether traffic for the image pull should be routed over virtual network. Defaults to `false`.
               
               > **Note:** The feature can also be enabled via the app setting `WEBSITE_PULL_IMAGE_OVER_VNET`. The Setting is enabled by default for an app running in the App Service Environment.
        :param pulumi.Input[_builtins.bool] webdeploy_publish_basic_authentication_enabled: Should the default WebDeploy Basic Authentication publishing credentials enabled. Defaults to `true`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LinuxFunctionAppSlotState.__new__(_LinuxFunctionAppSlotState)

        __props__.__dict__["app_settings"] = app_settings
        __props__.__dict__["auth_settings"] = auth_settings
        __props__.__dict__["auth_settings_v2"] = auth_settings_v2
        __props__.__dict__["backup"] = backup
        __props__.__dict__["builtin_logging_enabled"] = builtin_logging_enabled
        __props__.__dict__["client_certificate_enabled"] = client_certificate_enabled
        __props__.__dict__["client_certificate_exclusion_paths"] = client_certificate_exclusion_paths
        __props__.__dict__["client_certificate_mode"] = client_certificate_mode
        __props__.__dict__["connection_strings"] = connection_strings
        __props__.__dict__["content_share_force_disabled"] = content_share_force_disabled
        __props__.__dict__["custom_domain_verification_id"] = custom_domain_verification_id
        __props__.__dict__["daily_memory_time_quota"] = daily_memory_time_quota
        __props__.__dict__["default_hostname"] = default_hostname
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["ftp_publish_basic_authentication_enabled"] = ftp_publish_basic_authentication_enabled
        __props__.__dict__["function_app_id"] = function_app_id
        __props__.__dict__["functions_extension_version"] = functions_extension_version
        __props__.__dict__["hosting_environment_id"] = hosting_environment_id
        __props__.__dict__["https_only"] = https_only
        __props__.__dict__["identity"] = identity
        __props__.__dict__["key_vault_reference_identity_id"] = key_vault_reference_identity_id
        __props__.__dict__["kind"] = kind
        __props__.__dict__["name"] = name
        __props__.__dict__["outbound_ip_address_lists"] = outbound_ip_address_lists
        __props__.__dict__["outbound_ip_addresses"] = outbound_ip_addresses
        __props__.__dict__["possible_outbound_ip_address_lists"] = possible_outbound_ip_address_lists
        __props__.__dict__["possible_outbound_ip_addresses"] = possible_outbound_ip_addresses
        __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
        __props__.__dict__["service_plan_id"] = service_plan_id
        __props__.__dict__["site_config"] = site_config
        __props__.__dict__["site_credentials"] = site_credentials
        __props__.__dict__["storage_account_access_key"] = storage_account_access_key
        __props__.__dict__["storage_account_name"] = storage_account_name
        __props__.__dict__["storage_accounts"] = storage_accounts
        __props__.__dict__["storage_key_vault_secret_id"] = storage_key_vault_secret_id
        __props__.__dict__["storage_uses_managed_identity"] = storage_uses_managed_identity
        __props__.__dict__["tags"] = tags
        __props__.__dict__["virtual_network_backup_restore_enabled"] = virtual_network_backup_restore_enabled
        __props__.__dict__["virtual_network_subnet_id"] = virtual_network_subnet_id
        __props__.__dict__["vnet_image_pull_enabled"] = vnet_image_pull_enabled
        __props__.__dict__["webdeploy_publish_basic_authentication_enabled"] = webdeploy_publish_basic_authentication_enabled
        return LinuxFunctionAppSlot(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="appSettings")
    def app_settings(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of key-value pairs for [App Settings](https://docs.microsoft.com/azure/azure-functions/functions-app-settings) and custom values.
        """
        return pulumi.get(self, "app_settings")

    @_builtins.property
    @pulumi.getter(name="authSettings")
    def auth_settings(self) -> pulumi.Output[Optional['outputs.LinuxFunctionAppSlotAuthSettings']]:
        """
        an `auth_settings` block as detailed below.
        """
        return pulumi.get(self, "auth_settings")

    @_builtins.property
    @pulumi.getter(name="authSettingsV2")
    def auth_settings_v2(self) -> pulumi.Output[Optional['outputs.LinuxFunctionAppSlotAuthSettingsV2']]:
        """
        an `auth_settings_v2` block as detailed below.
        """
        return pulumi.get(self, "auth_settings_v2")

    @_builtins.property
    @pulumi.getter
    def backup(self) -> pulumi.Output[Optional['outputs.LinuxFunctionAppSlotBackup']]:
        """
        a `backup` block as detailed below.
        """
        return pulumi.get(self, "backup")

    @_builtins.property
    @pulumi.getter(name="builtinLoggingEnabled")
    def builtin_logging_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should built in logging be enabled. Configures `AzureWebJobsDashboard` app setting based on the configured storage setting. Defaults to `true`.
        """
        return pulumi.get(self, "builtin_logging_enabled")

    @_builtins.property
    @pulumi.getter(name="clientCertificateEnabled")
    def client_certificate_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the Function App Slot use Client Certificates.
        """
        return pulumi.get(self, "client_certificate_enabled")

    @_builtins.property
    @pulumi.getter(name="clientCertificateExclusionPaths")
    def client_certificate_exclusion_paths(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Paths to exclude when using client certificates, separated by ;
        """
        return pulumi.get(self, "client_certificate_exclusion_paths")

    @_builtins.property
    @pulumi.getter(name="clientCertificateMode")
    def client_certificate_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The mode of the Function App Slot's client certificates requirement for incoming requests. Possible values are `Required`, `Optional`, and `OptionalInteractiveUser`. Defaults to `Optional`.
        """
        return pulumi.get(self, "client_certificate_mode")

    @_builtins.property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> pulumi.Output[Optional[Sequence['outputs.LinuxFunctionAppSlotConnectionString']]]:
        """
        a `connection_string` block as detailed below.
        """
        return pulumi.get(self, "connection_strings")

    @_builtins.property
    @pulumi.getter(name="contentShareForceDisabled")
    def content_share_force_disabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Force disable the content share settings.
        """
        return pulumi.get(self, "content_share_force_disabled")

    @_builtins.property
    @pulumi.getter(name="customDomainVerificationId")
    def custom_domain_verification_id(self) -> pulumi.Output[_builtins.str]:
        """
        The identifier used by App Service to perform domain ownership verification via DNS TXT record.
        """
        return pulumi.get(self, "custom_domain_verification_id")

    @_builtins.property
    @pulumi.getter(name="dailyMemoryTimeQuota")
    def daily_memory_time_quota(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The amount of memory in gigabyte-seconds that your application is allowed to consume per day. Setting this value only affects function apps in Consumption Plans. Defaults to `0`.
        """
        return pulumi.get(self, "daily_memory_time_quota")

    @_builtins.property
    @pulumi.getter(name="defaultHostname")
    def default_hostname(self) -> pulumi.Output[_builtins.str]:
        """
        The default hostname of the Linux Function App Slot.
        """
        return pulumi.get(self, "default_hostname")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is the Linux Function App Slot enabled. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="ftpPublishBasicAuthenticationEnabled")
    def ftp_publish_basic_authentication_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Are the default FTP Basic Authentication publishing credentials enabled. Defaults to `true`.
        """
        return pulumi.get(self, "ftp_publish_basic_authentication_enabled")

    @_builtins.property
    @pulumi.getter(name="functionAppId")
    def function_app_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Linux Function App this Slot is a member of. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "function_app_id")

    @_builtins.property
    @pulumi.getter(name="functionsExtensionVersion")
    def functions_extension_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The runtime version associated with the Function App Slot. Defaults to `~4`.
        """
        return pulumi.get(self, "functions_extension_version")

    @_builtins.property
    @pulumi.getter(name="hostingEnvironmentId")
    def hosting_environment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the App Service Environment used by Function App Slot.
        """
        return pulumi.get(self, "hosting_environment_id")

    @_builtins.property
    @pulumi.getter(name="httpsOnly")
    def https_only(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Can the Function App Slot only be accessed via HTTPS?. Defaults to `false`.
        """
        return pulumi.get(self, "https_only")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.LinuxFunctionAppSlotIdentity']]:
        """
        An `identity` block as detailed below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="keyVaultReferenceIdentityId")
    def key_vault_reference_identity_id(self) -> pulumi.Output[_builtins.str]:
        """
        The User Assigned Identity ID used for accessing KeyVault secrets. The identity must be assigned to the application in the `identity` block. [For more information see - Access vaults with a user-assigned identity](https://docs.microsoft.com/azure/app-service/app-service-key-vault-references#access-vaults-with-a-user-assigned-identity)
        """
        return pulumi.get(self, "key_vault_reference_identity_id")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> pulumi.Output[_builtins.str]:
        """
        The Kind value for this Linux Function App Slot.
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Function App Slot. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="outboundIpAddressLists")
    def outbound_ip_address_lists(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of outbound IP addresses. For example `["52.23.25.3", "52.143.43.12"]`
        """
        return pulumi.get(self, "outbound_ip_address_lists")

    @_builtins.property
    @pulumi.getter(name="outboundIpAddresses")
    def outbound_ip_addresses(self) -> pulumi.Output[_builtins.str]:
        """
        A comma separated list of outbound IP addresses as a string. For example `52.23.25.3,52.143.43.12`.
        """
        return pulumi.get(self, "outbound_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="possibleOutboundIpAddressLists")
    def possible_outbound_ip_address_lists(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of possible outbound IP addresses, not all of which are necessarily in use. This is a superset of `outbound_ip_address_list`. For example `["52.23.25.3", "52.143.43.12"]`.
        """
        return pulumi.get(self, "possible_outbound_ip_address_lists")

    @_builtins.property
    @pulumi.getter(name="possibleOutboundIpAddresses")
    def possible_outbound_ip_addresses(self) -> pulumi.Output[_builtins.str]:
        """
        A comma separated list of possible outbound IP addresses as a string. For example `52.23.25.3,52.143.43.12,52.143.43.17`. This is a superset of `outbound_ip_addresses`. For example `["52.23.25.3", "52.143.43.12","52.143.43.17"]`.
        """
        return pulumi.get(self, "possible_outbound_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should public network access be enabled for the Function App. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @_builtins.property
    @pulumi.getter(name="servicePlanId")
    def service_plan_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Service Plan in which to run this slot. If not specified the same Service Plan as the Linux Function App will be used.
        """
        return pulumi.get(self, "service_plan_id")

    @_builtins.property
    @pulumi.getter(name="siteConfig")
    def site_config(self) -> pulumi.Output['outputs.LinuxFunctionAppSlotSiteConfig']:
        """
        a `site_config` block as detailed below.
        """
        return pulumi.get(self, "site_config")

    @_builtins.property
    @pulumi.getter(name="siteCredentials")
    def site_credentials(self) -> pulumi.Output[Sequence['outputs.LinuxFunctionAppSlotSiteCredential']]:
        """
        A `site_credential` block as defined below.
        """
        return pulumi.get(self, "site_credentials")

    @_builtins.property
    @pulumi.getter(name="storageAccountAccessKey")
    def storage_account_access_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The access key which will be used to access the storage account for the Function App Slot.
        """
        return pulumi.get(self, "storage_account_access_key")

    @_builtins.property
    @pulumi.getter(name="storageAccountName")
    def storage_account_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The backend storage account name which will be used by this Function App Slot.
        """
        return pulumi.get(self, "storage_account_name")

    @_builtins.property
    @pulumi.getter(name="storageAccounts")
    def storage_accounts(self) -> pulumi.Output[Optional[Sequence['outputs.LinuxFunctionAppSlotStorageAccount']]]:
        """
        One or more `storage_account` blocks as defined below.
        """
        return pulumi.get(self, "storage_accounts")

    @_builtins.property
    @pulumi.getter(name="storageKeyVaultSecretId")
    def storage_key_vault_secret_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Key Vault Secret ID, optionally including version, that contains the Connection String to connect to the storage account for this Function App.

        > **Note:** `storage_key_vault_secret_id` cannot be used with `storage_account_name`.

        > **Note:** `storage_key_vault_secret_id` used without a version will use the latest version of the secret, however, the service can take up to 24h to pick up a rotation of the latest version. See the [official docs](https://docs.microsoft.com/azure/app-service/app-service-key-vault-references#rotation) for more information.
        """
        return pulumi.get(self, "storage_key_vault_secret_id")

    @_builtins.property
    @pulumi.getter(name="storageUsesManagedIdentity")
    def storage_uses_managed_identity(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the Function App Slot use its Managed Identity to access storage.

        > **Note:** One of `storage_account_access_key` or `storage_uses_managed_identity` must be specified when using `storage_account_name`.
        """
        return pulumi.get(self, "storage_uses_managed_identity")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Linux Function App.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="virtualNetworkBackupRestoreEnabled")
    def virtual_network_backup_restore_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether backup and restore operations over the linked virtual network are enabled. Defaults to `false`.
        """
        return pulumi.get(self, "virtual_network_backup_restore_enabled")

    @_builtins.property
    @pulumi.getter(name="virtualNetworkSubnetId")
    def virtual_network_subnet_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "virtual_network_subnet_id")

    @_builtins.property
    @pulumi.getter(name="vnetImagePullEnabled")
    def vnet_image_pull_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether traffic for the image pull should be routed over virtual network. Defaults to `false`.

        > **Note:** The feature can also be enabled via the app setting `WEBSITE_PULL_IMAGE_OVER_VNET`. The Setting is enabled by default for an app running in the App Service Environment.
        """
        return pulumi.get(self, "vnet_image_pull_enabled")

    @_builtins.property
    @pulumi.getter(name="webdeployPublishBasicAuthenticationEnabled")
    def webdeploy_publish_basic_authentication_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the default WebDeploy Basic Authentication publishing credentials enabled. Defaults to `true`.
        """
        return pulumi.get(self, "webdeploy_publish_basic_authentication_enabled")

