# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['StaticWebAppFunctionAppRegistrationArgs', 'StaticWebAppFunctionAppRegistration']

@pulumi.input_type
class StaticWebAppFunctionAppRegistrationArgs:
    def __init__(__self__, *,
                 function_app_id: pulumi.Input[_builtins.str],
                 static_web_app_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a StaticWebAppFunctionAppRegistration resource.
        :param pulumi.Input[_builtins.str] function_app_id: The ID of a Linux or Windows Function App to connect to the Static Web App as a Backend. Changing this forces a new resource to be created. 
               
               > **Note:** Only one Function App can be connected to a Static Web App. Multiple Function Apps are not currently supported.
               
               > **Note:** Connecting a Function App resource to a Static Web App resource updates the Function App to use AuthV2 and configures the `azure_static_web_app_v2` which may need to be accounted for by the use of `ignore_changes` depending on the existing `auth_settings_v2` configuration of the target Function App.
        :param pulumi.Input[_builtins.str] static_web_app_id: The ID of the Static Web App to register the Function App to as a backend. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "function_app_id", function_app_id)
        pulumi.set(__self__, "static_web_app_id", static_web_app_id)

    @_builtins.property
    @pulumi.getter(name="functionAppId")
    def function_app_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of a Linux or Windows Function App to connect to the Static Web App as a Backend. Changing this forces a new resource to be created. 

        > **Note:** Only one Function App can be connected to a Static Web App. Multiple Function Apps are not currently supported.

        > **Note:** Connecting a Function App resource to a Static Web App resource updates the Function App to use AuthV2 and configures the `azure_static_web_app_v2` which may need to be accounted for by the use of `ignore_changes` depending on the existing `auth_settings_v2` configuration of the target Function App.
        """
        return pulumi.get(self, "function_app_id")

    @function_app_id.setter
    def function_app_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "function_app_id", value)

    @_builtins.property
    @pulumi.getter(name="staticWebAppId")
    def static_web_app_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Static Web App to register the Function App to as a backend. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "static_web_app_id")

    @static_web_app_id.setter
    def static_web_app_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "static_web_app_id", value)


@pulumi.input_type
class _StaticWebAppFunctionAppRegistrationState:
    def __init__(__self__, *,
                 function_app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 static_web_app_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering StaticWebAppFunctionAppRegistration resources.
        :param pulumi.Input[_builtins.str] function_app_id: The ID of a Linux or Windows Function App to connect to the Static Web App as a Backend. Changing this forces a new resource to be created. 
               
               > **Note:** Only one Function App can be connected to a Static Web App. Multiple Function Apps are not currently supported.
               
               > **Note:** Connecting a Function App resource to a Static Web App resource updates the Function App to use AuthV2 and configures the `azure_static_web_app_v2` which may need to be accounted for by the use of `ignore_changes` depending on the existing `auth_settings_v2` configuration of the target Function App.
        :param pulumi.Input[_builtins.str] static_web_app_id: The ID of the Static Web App to register the Function App to as a backend. Changing this forces a new resource to be created.
        """
        if function_app_id is not None:
            pulumi.set(__self__, "function_app_id", function_app_id)
        if static_web_app_id is not None:
            pulumi.set(__self__, "static_web_app_id", static_web_app_id)

    @_builtins.property
    @pulumi.getter(name="functionAppId")
    def function_app_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of a Linux or Windows Function App to connect to the Static Web App as a Backend. Changing this forces a new resource to be created. 

        > **Note:** Only one Function App can be connected to a Static Web App. Multiple Function Apps are not currently supported.

        > **Note:** Connecting a Function App resource to a Static Web App resource updates the Function App to use AuthV2 and configures the `azure_static_web_app_v2` which may need to be accounted for by the use of `ignore_changes` depending on the existing `auth_settings_v2` configuration of the target Function App.
        """
        return pulumi.get(self, "function_app_id")

    @function_app_id.setter
    def function_app_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "function_app_id", value)

    @_builtins.property
    @pulumi.getter(name="staticWebAppId")
    def static_web_app_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Static Web App to register the Function App to as a backend. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "static_web_app_id")

    @static_web_app_id.setter
    def static_web_app_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "static_web_app_id", value)


@pulumi.type_token("azure:appservice/staticWebAppFunctionAppRegistration:StaticWebAppFunctionAppRegistration")
class StaticWebAppFunctionAppRegistration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 function_app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 static_web_app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an App Service Static Web App Function App Registration.

        > **Note:** This resource registers the specified Function App to the `Production` build of the Static Web App.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_static_web_app = azure.appservice.StaticWebApp("example",
            name="example",
            resource_group_name=example.name,
            location=example.location)
        example_account = azure.storage.Account("example",
            name="examplesstorageacc",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_service_plan = azure.appservice.ServicePlan("example",
            name="example-service-plan",
            location=example.location,
            resource_group_name=example.name,
            os_type="Linux",
            sku_name="S1")
        example_linux_function_app = azure.appservice.LinuxFunctionApp("example",
            name="example-function-app",
            location=example.location,
            resource_group_name=example.name,
            service_plan_id=example_service_plan.id,
            storage_account_name=example_account.name,
            storage_account_access_key=example_account.primary_access_key,
            site_config={})
        example_static_web_app_function_app_registration = azure.appservice.StaticWebAppFunctionAppRegistration("example",
            static_web_app_id=example_static_web_app.id,
            function_app_id=example_linux_function_app.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Web`: 2023-12-01, 2023-01-01

        ## Import

        Static Web App Function App Registration can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appservice/staticWebAppFunctionAppRegistration:StaticWebAppFunctionAppRegistration example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/group1/providers/Microsoft.Web/staticSites/my-static-site1/userProvidedFunctionApps/myFunctionApp
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] function_app_id: The ID of a Linux or Windows Function App to connect to the Static Web App as a Backend. Changing this forces a new resource to be created. 
               
               > **Note:** Only one Function App can be connected to a Static Web App. Multiple Function Apps are not currently supported.
               
               > **Note:** Connecting a Function App resource to a Static Web App resource updates the Function App to use AuthV2 and configures the `azure_static_web_app_v2` which may need to be accounted for by the use of `ignore_changes` depending on the existing `auth_settings_v2` configuration of the target Function App.
        :param pulumi.Input[_builtins.str] static_web_app_id: The ID of the Static Web App to register the Function App to as a backend. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StaticWebAppFunctionAppRegistrationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an App Service Static Web App Function App Registration.

        > **Note:** This resource registers the specified Function App to the `Production` build of the Static Web App.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_static_web_app = azure.appservice.StaticWebApp("example",
            name="example",
            resource_group_name=example.name,
            location=example.location)
        example_account = azure.storage.Account("example",
            name="examplesstorageacc",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_service_plan = azure.appservice.ServicePlan("example",
            name="example-service-plan",
            location=example.location,
            resource_group_name=example.name,
            os_type="Linux",
            sku_name="S1")
        example_linux_function_app = azure.appservice.LinuxFunctionApp("example",
            name="example-function-app",
            location=example.location,
            resource_group_name=example.name,
            service_plan_id=example_service_plan.id,
            storage_account_name=example_account.name,
            storage_account_access_key=example_account.primary_access_key,
            site_config={})
        example_static_web_app_function_app_registration = azure.appservice.StaticWebAppFunctionAppRegistration("example",
            static_web_app_id=example_static_web_app.id,
            function_app_id=example_linux_function_app.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Web`: 2023-12-01, 2023-01-01

        ## Import

        Static Web App Function App Registration can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appservice/staticWebAppFunctionAppRegistration:StaticWebAppFunctionAppRegistration example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/group1/providers/Microsoft.Web/staticSites/my-static-site1/userProvidedFunctionApps/myFunctionApp
        ```

        :param str resource_name: The name of the resource.
        :param StaticWebAppFunctionAppRegistrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StaticWebAppFunctionAppRegistrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 function_app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 static_web_app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StaticWebAppFunctionAppRegistrationArgs.__new__(StaticWebAppFunctionAppRegistrationArgs)

            if function_app_id is None and not opts.urn:
                raise TypeError("Missing required property 'function_app_id'")
            __props__.__dict__["function_app_id"] = function_app_id
            if static_web_app_id is None and not opts.urn:
                raise TypeError("Missing required property 'static_web_app_id'")
            __props__.__dict__["static_web_app_id"] = static_web_app_id
        super(StaticWebAppFunctionAppRegistration, __self__).__init__(
            'azure:appservice/staticWebAppFunctionAppRegistration:StaticWebAppFunctionAppRegistration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            function_app_id: Optional[pulumi.Input[_builtins.str]] = None,
            static_web_app_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'StaticWebAppFunctionAppRegistration':
        """
        Get an existing StaticWebAppFunctionAppRegistration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] function_app_id: The ID of a Linux or Windows Function App to connect to the Static Web App as a Backend. Changing this forces a new resource to be created. 
               
               > **Note:** Only one Function App can be connected to a Static Web App. Multiple Function Apps are not currently supported.
               
               > **Note:** Connecting a Function App resource to a Static Web App resource updates the Function App to use AuthV2 and configures the `azure_static_web_app_v2` which may need to be accounted for by the use of `ignore_changes` depending on the existing `auth_settings_v2` configuration of the target Function App.
        :param pulumi.Input[_builtins.str] static_web_app_id: The ID of the Static Web App to register the Function App to as a backend. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StaticWebAppFunctionAppRegistrationState.__new__(_StaticWebAppFunctionAppRegistrationState)

        __props__.__dict__["function_app_id"] = function_app_id
        __props__.__dict__["static_web_app_id"] = static_web_app_id
        return StaticWebAppFunctionAppRegistration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="functionAppId")
    def function_app_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of a Linux or Windows Function App to connect to the Static Web App as a Backend. Changing this forces a new resource to be created. 

        > **Note:** Only one Function App can be connected to a Static Web App. Multiple Function Apps are not currently supported.

        > **Note:** Connecting a Function App resource to a Static Web App resource updates the Function App to use AuthV2 and configures the `azure_static_web_app_v2` which may need to be accounted for by the use of `ignore_changes` depending on the existing `auth_settings_v2` configuration of the target Function App.
        """
        return pulumi.get(self, "function_app_id")

    @_builtins.property
    @pulumi.getter(name="staticWebAppId")
    def static_web_app_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Static Web App to register the Function App to as a backend. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "static_web_app_id")

