# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ProtectedVMArgs', 'ProtectedVM']

@pulumi.input_type
class ProtectedVMArgs:
    def __init__(__self__, *,
                 recovery_vault_name: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 backup_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_disk_luns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 include_disk_luns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 protection_state: Optional[pulumi.Input[_builtins.str]] = None,
                 source_vm_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ProtectedVM resource.
        :param pulumi.Input[_builtins.str] recovery_vault_name: Specifies the name of the Recovery Services Vault to use. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group **associated with** the Recovery Services Vault to use. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] exclude_disk_luns: A list of Disks' Logical Unit Numbers (LUN) to be excluded for VM Protection.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] include_disk_luns: A list of Disks' Logical Unit Numbers (LUN) to be included for VM Protection.
        :param pulumi.Input[_builtins.str] protection_state: Specifies Protection state of the backup. Possible values are `Protected`, `BackupsSuspended`, and `ProtectionStopped`.
               
               > **Note:** `protection_state` cannot be set to `BackupsSuspended` unless the `recoveryservices.Vault` has `immutability` set to `Unlocked` or `Locked`.
        :param pulumi.Input[_builtins.str] source_vm_id: Specifies the ID of the virtual machine to back up. Changing this forces a new resource to be created.
               
               > **Note:** After creation, the `source_vm_id` property can be removed without forcing a new resource to be created; however, setting it to a different ID will create a new resource. This allows the source virtual machine to be deleted without having to remove the backup.
        """
        pulumi.set(__self__, "recovery_vault_name", recovery_vault_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if backup_policy_id is not None:
            pulumi.set(__self__, "backup_policy_id", backup_policy_id)
        if exclude_disk_luns is not None:
            pulumi.set(__self__, "exclude_disk_luns", exclude_disk_luns)
        if include_disk_luns is not None:
            pulumi.set(__self__, "include_disk_luns", include_disk_luns)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if source_vm_id is not None:
            pulumi.set(__self__, "source_vm_id", source_vm_id)

    @_builtins.property
    @pulumi.getter(name="recoveryVaultName")
    def recovery_vault_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the Recovery Services Vault to use. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "recovery_vault_name")

    @recovery_vault_name.setter
    def recovery_vault_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "recovery_vault_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the Resource Group **associated with** the Recovery Services Vault to use. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="backupPolicyId")
    def backup_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "backup_policy_id")

    @backup_policy_id.setter
    def backup_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="excludeDiskLuns")
    def exclude_disk_luns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        A list of Disks' Logical Unit Numbers (LUN) to be excluded for VM Protection.
        """
        return pulumi.get(self, "exclude_disk_luns")

    @exclude_disk_luns.setter
    def exclude_disk_luns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "exclude_disk_luns", value)

    @_builtins.property
    @pulumi.getter(name="includeDiskLuns")
    def include_disk_luns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        A list of Disks' Logical Unit Numbers (LUN) to be included for VM Protection.
        """
        return pulumi.get(self, "include_disk_luns")

    @include_disk_luns.setter
    def include_disk_luns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "include_disk_luns", value)

    @_builtins.property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies Protection state of the backup. Possible values are `Protected`, `BackupsSuspended`, and `ProtectionStopped`.

        > **Note:** `protection_state` cannot be set to `BackupsSuspended` unless the `recoveryservices.Vault` has `immutability` set to `Unlocked` or `Locked`.
        """
        return pulumi.get(self, "protection_state")

    @protection_state.setter
    def protection_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protection_state", value)

    @_builtins.property
    @pulumi.getter(name="sourceVmId")
    def source_vm_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the virtual machine to back up. Changing this forces a new resource to be created.

        > **Note:** After creation, the `source_vm_id` property can be removed without forcing a new resource to be created; however, setting it to a different ID will create a new resource. This allows the source virtual machine to be deleted without having to remove the backup.
        """
        return pulumi.get(self, "source_vm_id")

    @source_vm_id.setter
    def source_vm_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_vm_id", value)


@pulumi.input_type
class _ProtectedVMState:
    def __init__(__self__, *,
                 backup_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_disk_luns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 include_disk_luns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 protection_state: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_vault_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_vm_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ProtectedVM resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] exclude_disk_luns: A list of Disks' Logical Unit Numbers (LUN) to be excluded for VM Protection.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] include_disk_luns: A list of Disks' Logical Unit Numbers (LUN) to be included for VM Protection.
        :param pulumi.Input[_builtins.str] protection_state: Specifies Protection state of the backup. Possible values are `Protected`, `BackupsSuspended`, and `ProtectionStopped`.
               
               > **Note:** `protection_state` cannot be set to `BackupsSuspended` unless the `recoveryservices.Vault` has `immutability` set to `Unlocked` or `Locked`.
        :param pulumi.Input[_builtins.str] recovery_vault_name: Specifies the name of the Recovery Services Vault to use. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group **associated with** the Recovery Services Vault to use. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] source_vm_id: Specifies the ID of the virtual machine to back up. Changing this forces a new resource to be created.
               
               > **Note:** After creation, the `source_vm_id` property can be removed without forcing a new resource to be created; however, setting it to a different ID will create a new resource. This allows the source virtual machine to be deleted without having to remove the backup.
        """
        if backup_policy_id is not None:
            pulumi.set(__self__, "backup_policy_id", backup_policy_id)
        if exclude_disk_luns is not None:
            pulumi.set(__self__, "exclude_disk_luns", exclude_disk_luns)
        if include_disk_luns is not None:
            pulumi.set(__self__, "include_disk_luns", include_disk_luns)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if recovery_vault_name is not None:
            pulumi.set(__self__, "recovery_vault_name", recovery_vault_name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if source_vm_id is not None:
            pulumi.set(__self__, "source_vm_id", source_vm_id)

    @_builtins.property
    @pulumi.getter(name="backupPolicyId")
    def backup_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "backup_policy_id")

    @backup_policy_id.setter
    def backup_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="excludeDiskLuns")
    def exclude_disk_luns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        A list of Disks' Logical Unit Numbers (LUN) to be excluded for VM Protection.
        """
        return pulumi.get(self, "exclude_disk_luns")

    @exclude_disk_luns.setter
    def exclude_disk_luns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "exclude_disk_luns", value)

    @_builtins.property
    @pulumi.getter(name="includeDiskLuns")
    def include_disk_luns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        A list of Disks' Logical Unit Numbers (LUN) to be included for VM Protection.
        """
        return pulumi.get(self, "include_disk_luns")

    @include_disk_luns.setter
    def include_disk_luns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "include_disk_luns", value)

    @_builtins.property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies Protection state of the backup. Possible values are `Protected`, `BackupsSuspended`, and `ProtectionStopped`.

        > **Note:** `protection_state` cannot be set to `BackupsSuspended` unless the `recoveryservices.Vault` has `immutability` set to `Unlocked` or `Locked`.
        """
        return pulumi.get(self, "protection_state")

    @protection_state.setter
    def protection_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protection_state", value)

    @_builtins.property
    @pulumi.getter(name="recoveryVaultName")
    def recovery_vault_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Recovery Services Vault to use. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "recovery_vault_name")

    @recovery_vault_name.setter
    def recovery_vault_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "recovery_vault_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Resource Group **associated with** the Recovery Services Vault to use. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="sourceVmId")
    def source_vm_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the virtual machine to back up. Changing this forces a new resource to be created.

        > **Note:** After creation, the `source_vm_id` property can be removed without forcing a new resource to be created; however, setting it to a different ID will create a new resource. This allows the source virtual machine to be deleted without having to remove the backup.
        """
        return pulumi.get(self, "source_vm_id")

    @source_vm_id.setter
    def source_vm_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_vm_id", value)


@pulumi.type_token("azure:backup/protectedVM:ProtectedVM")
class ProtectedVM(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_disk_luns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 include_disk_luns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 protection_state: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_vault_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_vm_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Azure Backup Protected Virtual Machine.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example_resource_group = azure.core.ResourceGroup("example",
            name="tfex-recovery_vault",
            location="West Europe")
        example_vault = azure.recoveryservices.Vault("example",
            name="tfex-recovery-vault",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            sku="Standard")
        example_policy_vm = azure.backup.PolicyVM("example",
            name="tfex-recovery-vault-policy",
            resource_group_name=example_resource_group.name,
            recovery_vault_name=example_vault.name,
            backup={
                "frequency": "Daily",
                "time": "23:00",
            },
            retention_daily={
                "count": 10,
            })
        example = azure.compute.get_virtual_machine_output(name="example-vm",
            resource_group_name=example_resource_group.name)
        vm1 = azure.backup.ProtectedVM("vm1",
            resource_group_name=example_resource_group.name,
            recovery_vault_name=example_vault.name,
            source_vm_id=example.id,
            backup_policy_id=example_policy_vm.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.RecoveryServices`: 2024-01-01

        ## Import

        Backup Protected Virtual Machines can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:backup/protectedVM:ProtectedVM item1 "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.RecoveryServices/vaults/example-recovery-vault/backupFabrics/Azure/protectionContainers/iaasvmcontainer;iaasvmcontainerv2;group1;vm1/protectedItems/vm;iaasvmcontainerv2;group1;vm1"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] exclude_disk_luns: A list of Disks' Logical Unit Numbers (LUN) to be excluded for VM Protection.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] include_disk_luns: A list of Disks' Logical Unit Numbers (LUN) to be included for VM Protection.
        :param pulumi.Input[_builtins.str] protection_state: Specifies Protection state of the backup. Possible values are `Protected`, `BackupsSuspended`, and `ProtectionStopped`.
               
               > **Note:** `protection_state` cannot be set to `BackupsSuspended` unless the `recoveryservices.Vault` has `immutability` set to `Unlocked` or `Locked`.
        :param pulumi.Input[_builtins.str] recovery_vault_name: Specifies the name of the Recovery Services Vault to use. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group **associated with** the Recovery Services Vault to use. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] source_vm_id: Specifies the ID of the virtual machine to back up. Changing this forces a new resource to be created.
               
               > **Note:** After creation, the `source_vm_id` property can be removed without forcing a new resource to be created; however, setting it to a different ID will create a new resource. This allows the source virtual machine to be deleted without having to remove the backup.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProtectedVMArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure Backup Protected Virtual Machine.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example_resource_group = azure.core.ResourceGroup("example",
            name="tfex-recovery_vault",
            location="West Europe")
        example_vault = azure.recoveryservices.Vault("example",
            name="tfex-recovery-vault",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            sku="Standard")
        example_policy_vm = azure.backup.PolicyVM("example",
            name="tfex-recovery-vault-policy",
            resource_group_name=example_resource_group.name,
            recovery_vault_name=example_vault.name,
            backup={
                "frequency": "Daily",
                "time": "23:00",
            },
            retention_daily={
                "count": 10,
            })
        example = azure.compute.get_virtual_machine_output(name="example-vm",
            resource_group_name=example_resource_group.name)
        vm1 = azure.backup.ProtectedVM("vm1",
            resource_group_name=example_resource_group.name,
            recovery_vault_name=example_vault.name,
            source_vm_id=example.id,
            backup_policy_id=example_policy_vm.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.RecoveryServices`: 2024-01-01

        ## Import

        Backup Protected Virtual Machines can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:backup/protectedVM:ProtectedVM item1 "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.RecoveryServices/vaults/example-recovery-vault/backupFabrics/Azure/protectionContainers/iaasvmcontainer;iaasvmcontainerv2;group1;vm1/protectedItems/vm;iaasvmcontainerv2;group1;vm1"
        ```

        :param str resource_name: The name of the resource.
        :param ProtectedVMArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProtectedVMArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_disk_luns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 include_disk_luns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 protection_state: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_vault_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_vm_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProtectedVMArgs.__new__(ProtectedVMArgs)

            __props__.__dict__["backup_policy_id"] = backup_policy_id
            __props__.__dict__["exclude_disk_luns"] = exclude_disk_luns
            __props__.__dict__["include_disk_luns"] = include_disk_luns
            __props__.__dict__["protection_state"] = protection_state
            if recovery_vault_name is None and not opts.urn:
                raise TypeError("Missing required property 'recovery_vault_name'")
            __props__.__dict__["recovery_vault_name"] = recovery_vault_name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["source_vm_id"] = source_vm_id
        super(ProtectedVM, __self__).__init__(
            'azure:backup/protectedVM:ProtectedVM',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            exclude_disk_luns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
            include_disk_luns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
            protection_state: Optional[pulumi.Input[_builtins.str]] = None,
            recovery_vault_name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            source_vm_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ProtectedVM':
        """
        Get an existing ProtectedVM resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] exclude_disk_luns: A list of Disks' Logical Unit Numbers (LUN) to be excluded for VM Protection.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] include_disk_luns: A list of Disks' Logical Unit Numbers (LUN) to be included for VM Protection.
        :param pulumi.Input[_builtins.str] protection_state: Specifies Protection state of the backup. Possible values are `Protected`, `BackupsSuspended`, and `ProtectionStopped`.
               
               > **Note:** `protection_state` cannot be set to `BackupsSuspended` unless the `recoveryservices.Vault` has `immutability` set to `Unlocked` or `Locked`.
        :param pulumi.Input[_builtins.str] recovery_vault_name: Specifies the name of the Recovery Services Vault to use. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group **associated with** the Recovery Services Vault to use. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] source_vm_id: Specifies the ID of the virtual machine to back up. Changing this forces a new resource to be created.
               
               > **Note:** After creation, the `source_vm_id` property can be removed without forcing a new resource to be created; however, setting it to a different ID will create a new resource. This allows the source virtual machine to be deleted without having to remove the backup.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProtectedVMState.__new__(_ProtectedVMState)

        __props__.__dict__["backup_policy_id"] = backup_policy_id
        __props__.__dict__["exclude_disk_luns"] = exclude_disk_luns
        __props__.__dict__["include_disk_luns"] = include_disk_luns
        __props__.__dict__["protection_state"] = protection_state
        __props__.__dict__["recovery_vault_name"] = recovery_vault_name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["source_vm_id"] = source_vm_id
        return ProtectedVM(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="backupPolicyId")
    def backup_policy_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "backup_policy_id")

    @_builtins.property
    @pulumi.getter(name="excludeDiskLuns")
    def exclude_disk_luns(self) -> pulumi.Output[Optional[Sequence[_builtins.int]]]:
        """
        A list of Disks' Logical Unit Numbers (LUN) to be excluded for VM Protection.
        """
        return pulumi.get(self, "exclude_disk_luns")

    @_builtins.property
    @pulumi.getter(name="includeDiskLuns")
    def include_disk_luns(self) -> pulumi.Output[Optional[Sequence[_builtins.int]]]:
        """
        A list of Disks' Logical Unit Numbers (LUN) to be included for VM Protection.
        """
        return pulumi.get(self, "include_disk_luns")

    @_builtins.property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies Protection state of the backup. Possible values are `Protected`, `BackupsSuspended`, and `ProtectionStopped`.

        > **Note:** `protection_state` cannot be set to `BackupsSuspended` unless the `recoveryservices.Vault` has `immutability` set to `Unlocked` or `Locked`.
        """
        return pulumi.get(self, "protection_state")

    @_builtins.property
    @pulumi.getter(name="recoveryVaultName")
    def recovery_vault_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Recovery Services Vault to use. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "recovery_vault_name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Resource Group **associated with** the Recovery Services Vault to use. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="sourceVmId")
    def source_vm_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the virtual machine to back up. Changing this forces a new resource to be created.

        > **Note:** After creation, the `source_vm_id` property can be removed without forcing a new resource to be created; however, setting it to a different ID will create a new resource. This allows the source virtual machine to be deleted without having to remove the backup.
        """
        return pulumi.get(self, "source_vm_id")

