# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ServiceAzureBotArgs', 'ServiceAzureBot']

@pulumi.input_type
class ServiceAzureBotArgs:
    def __init__(__self__, *,
                 microsoft_app_id: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 sku: pulumi.Input[_builtins.str],
                 cmk_key_vault_key_url: Optional[pulumi.Input[_builtins.str]] = None,
                 developer_app_insights_api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 developer_app_insights_application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 developer_app_insights_key: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 icon_url: Optional[pulumi.Input[_builtins.str]] = None,
                 local_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 luis_app_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 luis_key: Optional[pulumi.Input[_builtins.str]] = None,
                 microsoft_app_msi_id: Optional[pulumi.Input[_builtins.str]] = None,
                 microsoft_app_tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 microsoft_app_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 streaming_endpoint_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ServiceAzureBot resource.
        :param pulumi.Input[_builtins.str] microsoft_app_id: The Microsoft Application ID for the Azure Bot Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Azure Bot Service should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku: The SKU of the Azure Bot Service. Accepted values are `F0` or `S1`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] cmk_key_vault_key_url: The CMK Key Vault Key URL that will be used to encrypt the Bot with the Customer Managed Encryption Key.
               
               > **Note:** In order to utilize CMEK, you must add the `Key Vault Crypto Service Encryption User` role to the Azure-defined `Bot Service CMEK Prod` Service Principal. You must also enable `soft_delete_enabled` and `purge_protection_enabled` on the `keyvault.KeyVault` that `cmk_key_vault_key_url` refers to. [See Azure Documentation](https://learn.microsoft.com/en-us/azure/bot-service/bot-service-encryption?view=azure-bot-service-4.0#how-to-configure-your-azure-key-vault-instance)
        :param pulumi.Input[_builtins.str] developer_app_insights_api_key: The Application Insights API Key to associate with this Azure Bot Service.
        :param pulumi.Input[_builtins.str] developer_app_insights_application_id: The resource ID of the Application Insights instance to associate with this Azure Bot Service.
        :param pulumi.Input[_builtins.str] developer_app_insights_key: The Application Insight Key to associate with this Azure Bot Service.
        :param pulumi.Input[_builtins.str] display_name: The name that the Azure Bot Service will be displayed as. This defaults to the value set for `name` if not specified.
        :param pulumi.Input[_builtins.str] endpoint: The Azure Bot Service endpoint.
        :param pulumi.Input[_builtins.str] icon_url: The Icon Url of the Azure Bot Service. Defaults to `https://docs.botframework.com/static/devportal/client/images/bot-framework-default.png`.
        :param pulumi.Input[_builtins.bool] local_authentication_enabled: Is local authentication enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: The supported Azure location where the Azure Bot Service should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] luis_app_ids: A list of LUIS App IDs to associate with this Azure Bot Service.
        :param pulumi.Input[_builtins.str] luis_key: The LUIS key to associate with this Azure Bot Service.
        :param pulumi.Input[_builtins.str] microsoft_app_msi_id: The ID of the Microsoft App Managed Identity for this Azure Bot Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] microsoft_app_tenant_id: The Tenant ID of the Microsoft App for this Azure Bot Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] microsoft_app_type: The Microsoft App Type for this Azure Bot Service. Possible values are `MultiTenant`, `SingleTenant` and `UserAssignedMSI`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure Bot Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether public network access is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] streaming_endpoint_enabled: Is the streaming endpoint enabled for this Azure Bot Service. Defaults to `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to this Azure Bot Service.
        """
        pulumi.set(__self__, "microsoft_app_id", microsoft_app_id)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sku", sku)
        if cmk_key_vault_key_url is not None:
            pulumi.set(__self__, "cmk_key_vault_key_url", cmk_key_vault_key_url)
        if developer_app_insights_api_key is not None:
            pulumi.set(__self__, "developer_app_insights_api_key", developer_app_insights_api_key)
        if developer_app_insights_application_id is not None:
            pulumi.set(__self__, "developer_app_insights_application_id", developer_app_insights_application_id)
        if developer_app_insights_key is not None:
            pulumi.set(__self__, "developer_app_insights_key", developer_app_insights_key)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if icon_url is not None:
            pulumi.set(__self__, "icon_url", icon_url)
        if local_authentication_enabled is not None:
            pulumi.set(__self__, "local_authentication_enabled", local_authentication_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if luis_app_ids is not None:
            pulumi.set(__self__, "luis_app_ids", luis_app_ids)
        if luis_key is not None:
            pulumi.set(__self__, "luis_key", luis_key)
        if microsoft_app_msi_id is not None:
            pulumi.set(__self__, "microsoft_app_msi_id", microsoft_app_msi_id)
        if microsoft_app_tenant_id is not None:
            pulumi.set(__self__, "microsoft_app_tenant_id", microsoft_app_tenant_id)
        if microsoft_app_type is not None:
            pulumi.set(__self__, "microsoft_app_type", microsoft_app_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if streaming_endpoint_enabled is not None:
            pulumi.set(__self__, "streaming_endpoint_enabled", streaming_endpoint_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="microsoftAppId")
    def microsoft_app_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Microsoft Application ID for the Azure Bot Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "microsoft_app_id")

    @microsoft_app_id.setter
    def microsoft_app_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "microsoft_app_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the Azure Bot Service should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Input[_builtins.str]:
        """
        The SKU of the Azure Bot Service. Accepted values are `F0` or `S1`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter(name="cmkKeyVaultKeyUrl")
    def cmk_key_vault_key_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CMK Key Vault Key URL that will be used to encrypt the Bot with the Customer Managed Encryption Key.

        > **Note:** In order to utilize CMEK, you must add the `Key Vault Crypto Service Encryption User` role to the Azure-defined `Bot Service CMEK Prod` Service Principal. You must also enable `soft_delete_enabled` and `purge_protection_enabled` on the `keyvault.KeyVault` that `cmk_key_vault_key_url` refers to. [See Azure Documentation](https://learn.microsoft.com/en-us/azure/bot-service/bot-service-encryption?view=azure-bot-service-4.0#how-to-configure-your-azure-key-vault-instance)
        """
        return pulumi.get(self, "cmk_key_vault_key_url")

    @cmk_key_vault_key_url.setter
    def cmk_key_vault_key_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cmk_key_vault_key_url", value)

    @_builtins.property
    @pulumi.getter(name="developerAppInsightsApiKey")
    def developer_app_insights_api_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Application Insights API Key to associate with this Azure Bot Service.
        """
        return pulumi.get(self, "developer_app_insights_api_key")

    @developer_app_insights_api_key.setter
    def developer_app_insights_api_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "developer_app_insights_api_key", value)

    @_builtins.property
    @pulumi.getter(name="developerAppInsightsApplicationId")
    def developer_app_insights_application_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource ID of the Application Insights instance to associate with this Azure Bot Service.
        """
        return pulumi.get(self, "developer_app_insights_application_id")

    @developer_app_insights_application_id.setter
    def developer_app_insights_application_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "developer_app_insights_application_id", value)

    @_builtins.property
    @pulumi.getter(name="developerAppInsightsKey")
    def developer_app_insights_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Application Insight Key to associate with this Azure Bot Service.
        """
        return pulumi.get(self, "developer_app_insights_key")

    @developer_app_insights_key.setter
    def developer_app_insights_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "developer_app_insights_key", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name that the Azure Bot Service will be displayed as. This defaults to the value set for `name` if not specified.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Bot Service endpoint.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter(name="iconUrl")
    def icon_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Icon Url of the Azure Bot Service. Defaults to `https://docs.botframework.com/static/devportal/client/images/bot-framework-default.png`.
        """
        return pulumi.get(self, "icon_url")

    @icon_url.setter
    def icon_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "icon_url", value)

    @_builtins.property
    @pulumi.getter(name="localAuthenticationEnabled")
    def local_authentication_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is local authentication enabled? Defaults to `true`.
        """
        return pulumi.get(self, "local_authentication_enabled")

    @local_authentication_enabled.setter
    def local_authentication_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local_authentication_enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The supported Azure location where the Azure Bot Service should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="luisAppIds")
    def luis_app_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of LUIS App IDs to associate with this Azure Bot Service.
        """
        return pulumi.get(self, "luis_app_ids")

    @luis_app_ids.setter
    def luis_app_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "luis_app_ids", value)

    @_builtins.property
    @pulumi.getter(name="luisKey")
    def luis_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The LUIS key to associate with this Azure Bot Service.
        """
        return pulumi.get(self, "luis_key")

    @luis_key.setter
    def luis_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "luis_key", value)

    @_builtins.property
    @pulumi.getter(name="microsoftAppMsiId")
    def microsoft_app_msi_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Microsoft App Managed Identity for this Azure Bot Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "microsoft_app_msi_id")

    @microsoft_app_msi_id.setter
    def microsoft_app_msi_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "microsoft_app_msi_id", value)

    @_builtins.property
    @pulumi.getter(name="microsoftAppTenantId")
    def microsoft_app_tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Tenant ID of the Microsoft App for this Azure Bot Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "microsoft_app_tenant_id")

    @microsoft_app_tenant_id.setter
    def microsoft_app_tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "microsoft_app_tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="microsoftAppType")
    def microsoft_app_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Microsoft App Type for this Azure Bot Service. Possible values are `MultiTenant`, `SingleTenant` and `UserAssignedMSI`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "microsoft_app_type")

    @microsoft_app_type.setter
    def microsoft_app_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "microsoft_app_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Azure Bot Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether public network access is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="streamingEndpointEnabled")
    def streaming_endpoint_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the streaming endpoint enabled for this Azure Bot Service. Defaults to `false`.
        """
        return pulumi.get(self, "streaming_endpoint_enabled")

    @streaming_endpoint_enabled.setter
    def streaming_endpoint_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "streaming_endpoint_enabled", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to this Azure Bot Service.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ServiceAzureBotState:
    def __init__(__self__, *,
                 cmk_key_vault_key_url: Optional[pulumi.Input[_builtins.str]] = None,
                 developer_app_insights_api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 developer_app_insights_application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 developer_app_insights_key: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 icon_url: Optional[pulumi.Input[_builtins.str]] = None,
                 local_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 luis_app_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 luis_key: Optional[pulumi.Input[_builtins.str]] = None,
                 microsoft_app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 microsoft_app_msi_id: Optional[pulumi.Input[_builtins.str]] = None,
                 microsoft_app_tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 microsoft_app_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 streaming_endpoint_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ServiceAzureBot resources.
        :param pulumi.Input[_builtins.str] cmk_key_vault_key_url: The CMK Key Vault Key URL that will be used to encrypt the Bot with the Customer Managed Encryption Key.
               
               > **Note:** In order to utilize CMEK, you must add the `Key Vault Crypto Service Encryption User` role to the Azure-defined `Bot Service CMEK Prod` Service Principal. You must also enable `soft_delete_enabled` and `purge_protection_enabled` on the `keyvault.KeyVault` that `cmk_key_vault_key_url` refers to. [See Azure Documentation](https://learn.microsoft.com/en-us/azure/bot-service/bot-service-encryption?view=azure-bot-service-4.0#how-to-configure-your-azure-key-vault-instance)
        :param pulumi.Input[_builtins.str] developer_app_insights_api_key: The Application Insights API Key to associate with this Azure Bot Service.
        :param pulumi.Input[_builtins.str] developer_app_insights_application_id: The resource ID of the Application Insights instance to associate with this Azure Bot Service.
        :param pulumi.Input[_builtins.str] developer_app_insights_key: The Application Insight Key to associate with this Azure Bot Service.
        :param pulumi.Input[_builtins.str] display_name: The name that the Azure Bot Service will be displayed as. This defaults to the value set for `name` if not specified.
        :param pulumi.Input[_builtins.str] endpoint: The Azure Bot Service endpoint.
        :param pulumi.Input[_builtins.str] icon_url: The Icon Url of the Azure Bot Service. Defaults to `https://docs.botframework.com/static/devportal/client/images/bot-framework-default.png`.
        :param pulumi.Input[_builtins.bool] local_authentication_enabled: Is local authentication enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: The supported Azure location where the Azure Bot Service should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] luis_app_ids: A list of LUIS App IDs to associate with this Azure Bot Service.
        :param pulumi.Input[_builtins.str] luis_key: The LUIS key to associate with this Azure Bot Service.
        :param pulumi.Input[_builtins.str] microsoft_app_id: The Microsoft Application ID for the Azure Bot Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] microsoft_app_msi_id: The ID of the Microsoft App Managed Identity for this Azure Bot Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] microsoft_app_tenant_id: The Tenant ID of the Microsoft App for this Azure Bot Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] microsoft_app_type: The Microsoft App Type for this Azure Bot Service. Possible values are `MultiTenant`, `SingleTenant` and `UserAssignedMSI`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure Bot Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether public network access is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Azure Bot Service should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku: The SKU of the Azure Bot Service. Accepted values are `F0` or `S1`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] streaming_endpoint_enabled: Is the streaming endpoint enabled for this Azure Bot Service. Defaults to `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to this Azure Bot Service.
        """
        if cmk_key_vault_key_url is not None:
            pulumi.set(__self__, "cmk_key_vault_key_url", cmk_key_vault_key_url)
        if developer_app_insights_api_key is not None:
            pulumi.set(__self__, "developer_app_insights_api_key", developer_app_insights_api_key)
        if developer_app_insights_application_id is not None:
            pulumi.set(__self__, "developer_app_insights_application_id", developer_app_insights_application_id)
        if developer_app_insights_key is not None:
            pulumi.set(__self__, "developer_app_insights_key", developer_app_insights_key)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if icon_url is not None:
            pulumi.set(__self__, "icon_url", icon_url)
        if local_authentication_enabled is not None:
            pulumi.set(__self__, "local_authentication_enabled", local_authentication_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if luis_app_ids is not None:
            pulumi.set(__self__, "luis_app_ids", luis_app_ids)
        if luis_key is not None:
            pulumi.set(__self__, "luis_key", luis_key)
        if microsoft_app_id is not None:
            pulumi.set(__self__, "microsoft_app_id", microsoft_app_id)
        if microsoft_app_msi_id is not None:
            pulumi.set(__self__, "microsoft_app_msi_id", microsoft_app_msi_id)
        if microsoft_app_tenant_id is not None:
            pulumi.set(__self__, "microsoft_app_tenant_id", microsoft_app_tenant_id)
        if microsoft_app_type is not None:
            pulumi.set(__self__, "microsoft_app_type", microsoft_app_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if streaming_endpoint_enabled is not None:
            pulumi.set(__self__, "streaming_endpoint_enabled", streaming_endpoint_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="cmkKeyVaultKeyUrl")
    def cmk_key_vault_key_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CMK Key Vault Key URL that will be used to encrypt the Bot with the Customer Managed Encryption Key.

        > **Note:** In order to utilize CMEK, you must add the `Key Vault Crypto Service Encryption User` role to the Azure-defined `Bot Service CMEK Prod` Service Principal. You must also enable `soft_delete_enabled` and `purge_protection_enabled` on the `keyvault.KeyVault` that `cmk_key_vault_key_url` refers to. [See Azure Documentation](https://learn.microsoft.com/en-us/azure/bot-service/bot-service-encryption?view=azure-bot-service-4.0#how-to-configure-your-azure-key-vault-instance)
        """
        return pulumi.get(self, "cmk_key_vault_key_url")

    @cmk_key_vault_key_url.setter
    def cmk_key_vault_key_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cmk_key_vault_key_url", value)

    @_builtins.property
    @pulumi.getter(name="developerAppInsightsApiKey")
    def developer_app_insights_api_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Application Insights API Key to associate with this Azure Bot Service.
        """
        return pulumi.get(self, "developer_app_insights_api_key")

    @developer_app_insights_api_key.setter
    def developer_app_insights_api_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "developer_app_insights_api_key", value)

    @_builtins.property
    @pulumi.getter(name="developerAppInsightsApplicationId")
    def developer_app_insights_application_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource ID of the Application Insights instance to associate with this Azure Bot Service.
        """
        return pulumi.get(self, "developer_app_insights_application_id")

    @developer_app_insights_application_id.setter
    def developer_app_insights_application_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "developer_app_insights_application_id", value)

    @_builtins.property
    @pulumi.getter(name="developerAppInsightsKey")
    def developer_app_insights_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Application Insight Key to associate with this Azure Bot Service.
        """
        return pulumi.get(self, "developer_app_insights_key")

    @developer_app_insights_key.setter
    def developer_app_insights_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "developer_app_insights_key", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name that the Azure Bot Service will be displayed as. This defaults to the value set for `name` if not specified.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Bot Service endpoint.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter(name="iconUrl")
    def icon_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Icon Url of the Azure Bot Service. Defaults to `https://docs.botframework.com/static/devportal/client/images/bot-framework-default.png`.
        """
        return pulumi.get(self, "icon_url")

    @icon_url.setter
    def icon_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "icon_url", value)

    @_builtins.property
    @pulumi.getter(name="localAuthenticationEnabled")
    def local_authentication_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is local authentication enabled? Defaults to `true`.
        """
        return pulumi.get(self, "local_authentication_enabled")

    @local_authentication_enabled.setter
    def local_authentication_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local_authentication_enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The supported Azure location where the Azure Bot Service should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="luisAppIds")
    def luis_app_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of LUIS App IDs to associate with this Azure Bot Service.
        """
        return pulumi.get(self, "luis_app_ids")

    @luis_app_ids.setter
    def luis_app_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "luis_app_ids", value)

    @_builtins.property
    @pulumi.getter(name="luisKey")
    def luis_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The LUIS key to associate with this Azure Bot Service.
        """
        return pulumi.get(self, "luis_key")

    @luis_key.setter
    def luis_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "luis_key", value)

    @_builtins.property
    @pulumi.getter(name="microsoftAppId")
    def microsoft_app_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Microsoft Application ID for the Azure Bot Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "microsoft_app_id")

    @microsoft_app_id.setter
    def microsoft_app_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "microsoft_app_id", value)

    @_builtins.property
    @pulumi.getter(name="microsoftAppMsiId")
    def microsoft_app_msi_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Microsoft App Managed Identity for this Azure Bot Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "microsoft_app_msi_id")

    @microsoft_app_msi_id.setter
    def microsoft_app_msi_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "microsoft_app_msi_id", value)

    @_builtins.property
    @pulumi.getter(name="microsoftAppTenantId")
    def microsoft_app_tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Tenant ID of the Microsoft App for this Azure Bot Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "microsoft_app_tenant_id")

    @microsoft_app_tenant_id.setter
    def microsoft_app_tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "microsoft_app_tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="microsoftAppType")
    def microsoft_app_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Microsoft App Type for this Azure Bot Service. Possible values are `MultiTenant`, `SingleTenant` and `UserAssignedMSI`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "microsoft_app_type")

    @microsoft_app_type.setter
    def microsoft_app_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "microsoft_app_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Azure Bot Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether public network access is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the Azure Bot Service should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SKU of the Azure Bot Service. Accepted values are `F0` or `S1`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter(name="streamingEndpointEnabled")
    def streaming_endpoint_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the streaming endpoint enabled for this Azure Bot Service. Defaults to `false`.
        """
        return pulumi.get(self, "streaming_endpoint_enabled")

    @streaming_endpoint_enabled.setter
    def streaming_endpoint_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "streaming_endpoint_enabled", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to this Azure Bot Service.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:bot/serviceAzureBot:ServiceAzureBot")
class ServiceAzureBot(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cmk_key_vault_key_url: Optional[pulumi.Input[_builtins.str]] = None,
                 developer_app_insights_api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 developer_app_insights_application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 developer_app_insights_key: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 icon_url: Optional[pulumi.Input[_builtins.str]] = None,
                 local_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 luis_app_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 luis_key: Optional[pulumi.Input[_builtins.str]] = None,
                 microsoft_app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 microsoft_app_msi_id: Optional[pulumi.Input[_builtins.str]] = None,
                 microsoft_app_tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 microsoft_app_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 streaming_endpoint_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an Azure Bot Service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_insights = azure.appinsights.Insights("example",
            name="example-appinsights",
            location=example.location,
            resource_group_name=example.name,
            application_type="web")
        example_api_key = azure.appinsights.ApiKey("example",
            name="example-appinsightsapikey",
            application_insights_id=example_insights.id,
            read_permissions=[
                "aggregate",
                "api",
                "draft",
                "extendqueries",
                "search",
            ])
        current = azure.core.get_client_config()
        example_service_azure_bot = azure.bot.ServiceAzureBot("example",
            name="exampleazurebot",
            resource_group_name=example.name,
            location="global",
            microsoft_app_id=current.client_id,
            sku="F0",
            endpoint="https://example.com",
            developer_app_insights_api_key=example_api_key.api_key,
            developer_app_insights_application_id=example_insights.app_id,
            tags={
                "environment": "test",
            })
        ```

        ## Import

        Azure Bot Services can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:bot/serviceAzureBot:ServiceAzureBot example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.BotService/botServices/botService1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cmk_key_vault_key_url: The CMK Key Vault Key URL that will be used to encrypt the Bot with the Customer Managed Encryption Key.
               
               > **Note:** In order to utilize CMEK, you must add the `Key Vault Crypto Service Encryption User` role to the Azure-defined `Bot Service CMEK Prod` Service Principal. You must also enable `soft_delete_enabled` and `purge_protection_enabled` on the `keyvault.KeyVault` that `cmk_key_vault_key_url` refers to. [See Azure Documentation](https://learn.microsoft.com/en-us/azure/bot-service/bot-service-encryption?view=azure-bot-service-4.0#how-to-configure-your-azure-key-vault-instance)
        :param pulumi.Input[_builtins.str] developer_app_insights_api_key: The Application Insights API Key to associate with this Azure Bot Service.
        :param pulumi.Input[_builtins.str] developer_app_insights_application_id: The resource ID of the Application Insights instance to associate with this Azure Bot Service.
        :param pulumi.Input[_builtins.str] developer_app_insights_key: The Application Insight Key to associate with this Azure Bot Service.
        :param pulumi.Input[_builtins.str] display_name: The name that the Azure Bot Service will be displayed as. This defaults to the value set for `name` if not specified.
        :param pulumi.Input[_builtins.str] endpoint: The Azure Bot Service endpoint.
        :param pulumi.Input[_builtins.str] icon_url: The Icon Url of the Azure Bot Service. Defaults to `https://docs.botframework.com/static/devportal/client/images/bot-framework-default.png`.
        :param pulumi.Input[_builtins.bool] local_authentication_enabled: Is local authentication enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: The supported Azure location where the Azure Bot Service should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] luis_app_ids: A list of LUIS App IDs to associate with this Azure Bot Service.
        :param pulumi.Input[_builtins.str] luis_key: The LUIS key to associate with this Azure Bot Service.
        :param pulumi.Input[_builtins.str] microsoft_app_id: The Microsoft Application ID for the Azure Bot Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] microsoft_app_msi_id: The ID of the Microsoft App Managed Identity for this Azure Bot Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] microsoft_app_tenant_id: The Tenant ID of the Microsoft App for this Azure Bot Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] microsoft_app_type: The Microsoft App Type for this Azure Bot Service. Possible values are `MultiTenant`, `SingleTenant` and `UserAssignedMSI`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure Bot Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether public network access is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Azure Bot Service should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku: The SKU of the Azure Bot Service. Accepted values are `F0` or `S1`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] streaming_endpoint_enabled: Is the streaming endpoint enabled for this Azure Bot Service. Defaults to `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to this Azure Bot Service.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceAzureBotArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure Bot Service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_insights = azure.appinsights.Insights("example",
            name="example-appinsights",
            location=example.location,
            resource_group_name=example.name,
            application_type="web")
        example_api_key = azure.appinsights.ApiKey("example",
            name="example-appinsightsapikey",
            application_insights_id=example_insights.id,
            read_permissions=[
                "aggregate",
                "api",
                "draft",
                "extendqueries",
                "search",
            ])
        current = azure.core.get_client_config()
        example_service_azure_bot = azure.bot.ServiceAzureBot("example",
            name="exampleazurebot",
            resource_group_name=example.name,
            location="global",
            microsoft_app_id=current.client_id,
            sku="F0",
            endpoint="https://example.com",
            developer_app_insights_api_key=example_api_key.api_key,
            developer_app_insights_application_id=example_insights.app_id,
            tags={
                "environment": "test",
            })
        ```

        ## Import

        Azure Bot Services can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:bot/serviceAzureBot:ServiceAzureBot example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.BotService/botServices/botService1
        ```

        :param str resource_name: The name of the resource.
        :param ServiceAzureBotArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceAzureBotArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cmk_key_vault_key_url: Optional[pulumi.Input[_builtins.str]] = None,
                 developer_app_insights_api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 developer_app_insights_application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 developer_app_insights_key: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 icon_url: Optional[pulumi.Input[_builtins.str]] = None,
                 local_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 luis_app_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 luis_key: Optional[pulumi.Input[_builtins.str]] = None,
                 microsoft_app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 microsoft_app_msi_id: Optional[pulumi.Input[_builtins.str]] = None,
                 microsoft_app_tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 microsoft_app_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 streaming_endpoint_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceAzureBotArgs.__new__(ServiceAzureBotArgs)

            __props__.__dict__["cmk_key_vault_key_url"] = cmk_key_vault_key_url
            __props__.__dict__["developer_app_insights_api_key"] = None if developer_app_insights_api_key is None else pulumi.Output.secret(developer_app_insights_api_key)
            __props__.__dict__["developer_app_insights_application_id"] = developer_app_insights_application_id
            __props__.__dict__["developer_app_insights_key"] = developer_app_insights_key
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["endpoint"] = endpoint
            __props__.__dict__["icon_url"] = icon_url
            __props__.__dict__["local_authentication_enabled"] = local_authentication_enabled
            __props__.__dict__["location"] = location
            __props__.__dict__["luis_app_ids"] = luis_app_ids
            __props__.__dict__["luis_key"] = None if luis_key is None else pulumi.Output.secret(luis_key)
            if microsoft_app_id is None and not opts.urn:
                raise TypeError("Missing required property 'microsoft_app_id'")
            __props__.__dict__["microsoft_app_id"] = microsoft_app_id
            __props__.__dict__["microsoft_app_msi_id"] = microsoft_app_msi_id
            __props__.__dict__["microsoft_app_tenant_id"] = microsoft_app_tenant_id
            __props__.__dict__["microsoft_app_type"] = microsoft_app_type
            __props__.__dict__["name"] = name
            __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if sku is None and not opts.urn:
                raise TypeError("Missing required property 'sku'")
            __props__.__dict__["sku"] = sku
            __props__.__dict__["streaming_endpoint_enabled"] = streaming_endpoint_enabled
            __props__.__dict__["tags"] = tags
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["developerAppInsightsApiKey", "luisKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ServiceAzureBot, __self__).__init__(
            'azure:bot/serviceAzureBot:ServiceAzureBot',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cmk_key_vault_key_url: Optional[pulumi.Input[_builtins.str]] = None,
            developer_app_insights_api_key: Optional[pulumi.Input[_builtins.str]] = None,
            developer_app_insights_application_id: Optional[pulumi.Input[_builtins.str]] = None,
            developer_app_insights_key: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            icon_url: Optional[pulumi.Input[_builtins.str]] = None,
            local_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            luis_app_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            luis_key: Optional[pulumi.Input[_builtins.str]] = None,
            microsoft_app_id: Optional[pulumi.Input[_builtins.str]] = None,
            microsoft_app_msi_id: Optional[pulumi.Input[_builtins.str]] = None,
            microsoft_app_tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
            microsoft_app_type: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            sku: Optional[pulumi.Input[_builtins.str]] = None,
            streaming_endpoint_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'ServiceAzureBot':
        """
        Get an existing ServiceAzureBot resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cmk_key_vault_key_url: The CMK Key Vault Key URL that will be used to encrypt the Bot with the Customer Managed Encryption Key.
               
               > **Note:** In order to utilize CMEK, you must add the `Key Vault Crypto Service Encryption User` role to the Azure-defined `Bot Service CMEK Prod` Service Principal. You must also enable `soft_delete_enabled` and `purge_protection_enabled` on the `keyvault.KeyVault` that `cmk_key_vault_key_url` refers to. [See Azure Documentation](https://learn.microsoft.com/en-us/azure/bot-service/bot-service-encryption?view=azure-bot-service-4.0#how-to-configure-your-azure-key-vault-instance)
        :param pulumi.Input[_builtins.str] developer_app_insights_api_key: The Application Insights API Key to associate with this Azure Bot Service.
        :param pulumi.Input[_builtins.str] developer_app_insights_application_id: The resource ID of the Application Insights instance to associate with this Azure Bot Service.
        :param pulumi.Input[_builtins.str] developer_app_insights_key: The Application Insight Key to associate with this Azure Bot Service.
        :param pulumi.Input[_builtins.str] display_name: The name that the Azure Bot Service will be displayed as. This defaults to the value set for `name` if not specified.
        :param pulumi.Input[_builtins.str] endpoint: The Azure Bot Service endpoint.
        :param pulumi.Input[_builtins.str] icon_url: The Icon Url of the Azure Bot Service. Defaults to `https://docs.botframework.com/static/devportal/client/images/bot-framework-default.png`.
        :param pulumi.Input[_builtins.bool] local_authentication_enabled: Is local authentication enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: The supported Azure location where the Azure Bot Service should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] luis_app_ids: A list of LUIS App IDs to associate with this Azure Bot Service.
        :param pulumi.Input[_builtins.str] luis_key: The LUIS key to associate with this Azure Bot Service.
        :param pulumi.Input[_builtins.str] microsoft_app_id: The Microsoft Application ID for the Azure Bot Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] microsoft_app_msi_id: The ID of the Microsoft App Managed Identity for this Azure Bot Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] microsoft_app_tenant_id: The Tenant ID of the Microsoft App for this Azure Bot Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] microsoft_app_type: The Microsoft App Type for this Azure Bot Service. Possible values are `MultiTenant`, `SingleTenant` and `UserAssignedMSI`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure Bot Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether public network access is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Azure Bot Service should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku: The SKU of the Azure Bot Service. Accepted values are `F0` or `S1`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] streaming_endpoint_enabled: Is the streaming endpoint enabled for this Azure Bot Service. Defaults to `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to this Azure Bot Service.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceAzureBotState.__new__(_ServiceAzureBotState)

        __props__.__dict__["cmk_key_vault_key_url"] = cmk_key_vault_key_url
        __props__.__dict__["developer_app_insights_api_key"] = developer_app_insights_api_key
        __props__.__dict__["developer_app_insights_application_id"] = developer_app_insights_application_id
        __props__.__dict__["developer_app_insights_key"] = developer_app_insights_key
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["icon_url"] = icon_url
        __props__.__dict__["local_authentication_enabled"] = local_authentication_enabled
        __props__.__dict__["location"] = location
        __props__.__dict__["luis_app_ids"] = luis_app_ids
        __props__.__dict__["luis_key"] = luis_key
        __props__.__dict__["microsoft_app_id"] = microsoft_app_id
        __props__.__dict__["microsoft_app_msi_id"] = microsoft_app_msi_id
        __props__.__dict__["microsoft_app_tenant_id"] = microsoft_app_tenant_id
        __props__.__dict__["microsoft_app_type"] = microsoft_app_type
        __props__.__dict__["name"] = name
        __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["sku"] = sku
        __props__.__dict__["streaming_endpoint_enabled"] = streaming_endpoint_enabled
        __props__.__dict__["tags"] = tags
        return ServiceAzureBot(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cmkKeyVaultKeyUrl")
    def cmk_key_vault_key_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The CMK Key Vault Key URL that will be used to encrypt the Bot with the Customer Managed Encryption Key.

        > **Note:** In order to utilize CMEK, you must add the `Key Vault Crypto Service Encryption User` role to the Azure-defined `Bot Service CMEK Prod` Service Principal. You must also enable `soft_delete_enabled` and `purge_protection_enabled` on the `keyvault.KeyVault` that `cmk_key_vault_key_url` refers to. [See Azure Documentation](https://learn.microsoft.com/en-us/azure/bot-service/bot-service-encryption?view=azure-bot-service-4.0#how-to-configure-your-azure-key-vault-instance)
        """
        return pulumi.get(self, "cmk_key_vault_key_url")

    @_builtins.property
    @pulumi.getter(name="developerAppInsightsApiKey")
    def developer_app_insights_api_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Application Insights API Key to associate with this Azure Bot Service.
        """
        return pulumi.get(self, "developer_app_insights_api_key")

    @_builtins.property
    @pulumi.getter(name="developerAppInsightsApplicationId")
    def developer_app_insights_application_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource ID of the Application Insights instance to associate with this Azure Bot Service.
        """
        return pulumi.get(self, "developer_app_insights_application_id")

    @_builtins.property
    @pulumi.getter(name="developerAppInsightsKey")
    def developer_app_insights_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Application Insight Key to associate with this Azure Bot Service.
        """
        return pulumi.get(self, "developer_app_insights_key")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name that the Azure Bot Service will be displayed as. This defaults to the value set for `name` if not specified.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Azure Bot Service endpoint.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter(name="iconUrl")
    def icon_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Icon Url of the Azure Bot Service. Defaults to `https://docs.botframework.com/static/devportal/client/images/bot-framework-default.png`.
        """
        return pulumi.get(self, "icon_url")

    @_builtins.property
    @pulumi.getter(name="localAuthenticationEnabled")
    def local_authentication_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is local authentication enabled? Defaults to `true`.
        """
        return pulumi.get(self, "local_authentication_enabled")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The supported Azure location where the Azure Bot Service should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="luisAppIds")
    def luis_app_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of LUIS App IDs to associate with this Azure Bot Service.
        """
        return pulumi.get(self, "luis_app_ids")

    @_builtins.property
    @pulumi.getter(name="luisKey")
    def luis_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The LUIS key to associate with this Azure Bot Service.
        """
        return pulumi.get(self, "luis_key")

    @_builtins.property
    @pulumi.getter(name="microsoftAppId")
    def microsoft_app_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Microsoft Application ID for the Azure Bot Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "microsoft_app_id")

    @_builtins.property
    @pulumi.getter(name="microsoftAppMsiId")
    def microsoft_app_msi_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Microsoft App Managed Identity for this Azure Bot Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "microsoft_app_msi_id")

    @_builtins.property
    @pulumi.getter(name="microsoftAppTenantId")
    def microsoft_app_tenant_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Tenant ID of the Microsoft App for this Azure Bot Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "microsoft_app_tenant_id")

    @_builtins.property
    @pulumi.getter(name="microsoftAppType")
    def microsoft_app_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Microsoft App Type for this Azure Bot Service. Possible values are `MultiTenant`, `SingleTenant` and `UserAssignedMSI`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "microsoft_app_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Azure Bot Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether public network access is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the Azure Bot Service should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Output[_builtins.str]:
        """
        The SKU of the Azure Bot Service. Accepted values are `F0` or `S1`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sku")

    @_builtins.property
    @pulumi.getter(name="streamingEndpointEnabled")
    def streaming_endpoint_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is the streaming endpoint enabled for this Azure Bot Service. Defaults to `false`.
        """
        return pulumi.get(self, "streaming_endpoint_enabled")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to this Azure Bot Service.
        """
        return pulumi.get(self, "tags")

