# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['FrontdoorEndpointArgs', 'FrontdoorEndpoint']

@pulumi.input_type
class FrontdoorEndpointArgs:
    def __init__(__self__, *,
                 cdn_frontdoor_profile_id: pulumi.Input[_builtins.str],
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a FrontdoorEndpoint resource.
        :param pulumi.Input[_builtins.str] cdn_frontdoor_profile_id: The ID of the Front Door Profile within which this Front Door Endpoint should exist. Changing this forces a new Front Door Endpoint to be created.
        :param pulumi.Input[_builtins.bool] enabled: Specifies if this Front Door Endpoint is enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Front Door Endpoint. Changing this forces a new Front Door Endpoint to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies a mapping of tags which should be assigned to the Front Door Endpoint.
        """
        pulumi.set(__self__, "cdn_frontdoor_profile_id", cdn_frontdoor_profile_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="cdnFrontdoorProfileId")
    def cdn_frontdoor_profile_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Front Door Profile within which this Front Door Endpoint should exist. Changing this forces a new Front Door Endpoint to be created.
        """
        return pulumi.get(self, "cdn_frontdoor_profile_id")

    @cdn_frontdoor_profile_id.setter
    def cdn_frontdoor_profile_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cdn_frontdoor_profile_id", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if this Front Door Endpoint is enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Front Door Endpoint. Changing this forces a new Front Door Endpoint to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies a mapping of tags which should be assigned to the Front Door Endpoint.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _FrontdoorEndpointState:
    def __init__(__self__, *,
                 cdn_frontdoor_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering FrontdoorEndpoint resources.
        :param pulumi.Input[_builtins.str] cdn_frontdoor_profile_id: The ID of the Front Door Profile within which this Front Door Endpoint should exist. Changing this forces a new Front Door Endpoint to be created.
        :param pulumi.Input[_builtins.bool] enabled: Specifies if this Front Door Endpoint is enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.str] host_name: The host name of the Front Door Endpoint, in the format `{endpointName}.{dnsZone}` (for example, `contoso.azureedge.net`).
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Front Door Endpoint. Changing this forces a new Front Door Endpoint to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies a mapping of tags which should be assigned to the Front Door Endpoint.
        """
        if cdn_frontdoor_profile_id is not None:
            pulumi.set(__self__, "cdn_frontdoor_profile_id", cdn_frontdoor_profile_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="cdnFrontdoorProfileId")
    def cdn_frontdoor_profile_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Front Door Profile within which this Front Door Endpoint should exist. Changing this forces a new Front Door Endpoint to be created.
        """
        return pulumi.get(self, "cdn_frontdoor_profile_id")

    @cdn_frontdoor_profile_id.setter
    def cdn_frontdoor_profile_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cdn_frontdoor_profile_id", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if this Front Door Endpoint is enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The host name of the Front Door Endpoint, in the format `{endpointName}.{dnsZone}` (for example, `contoso.azureedge.net`).
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Front Door Endpoint. Changing this forces a new Front Door Endpoint to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies a mapping of tags which should be assigned to the Front Door Endpoint.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:cdn/frontdoorEndpoint:FrontdoorEndpoint")
class FrontdoorEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cdn_frontdoor_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Front Door (standard/premium) Endpoint.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-cdn-frontdoor",
            location="West Europe")
        example_frontdoor_profile = azure.cdn.FrontdoorProfile("example",
            name="example-profile",
            resource_group_name=example.name,
            sku_name="Standard_AzureFrontDoor")
        example_frontdoor_endpoint = azure.cdn.FrontdoorEndpoint("example",
            name="example-endpoint",
            cdn_frontdoor_profile_id=example_frontdoor_profile.id,
            tags={
                "ENV": "example",
            })
        ```

        ## Import

        Front Door Endpoints can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cdn/frontdoorEndpoint:FrontdoorEndpoint example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Cdn/profiles/profile1/afdEndpoints/endpoint1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cdn_frontdoor_profile_id: The ID of the Front Door Profile within which this Front Door Endpoint should exist. Changing this forces a new Front Door Endpoint to be created.
        :param pulumi.Input[_builtins.bool] enabled: Specifies if this Front Door Endpoint is enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Front Door Endpoint. Changing this forces a new Front Door Endpoint to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies a mapping of tags which should be assigned to the Front Door Endpoint.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FrontdoorEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Front Door (standard/premium) Endpoint.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-cdn-frontdoor",
            location="West Europe")
        example_frontdoor_profile = azure.cdn.FrontdoorProfile("example",
            name="example-profile",
            resource_group_name=example.name,
            sku_name="Standard_AzureFrontDoor")
        example_frontdoor_endpoint = azure.cdn.FrontdoorEndpoint("example",
            name="example-endpoint",
            cdn_frontdoor_profile_id=example_frontdoor_profile.id,
            tags={
                "ENV": "example",
            })
        ```

        ## Import

        Front Door Endpoints can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cdn/frontdoorEndpoint:FrontdoorEndpoint example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Cdn/profiles/profile1/afdEndpoints/endpoint1
        ```

        :param str resource_name: The name of the resource.
        :param FrontdoorEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FrontdoorEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cdn_frontdoor_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FrontdoorEndpointArgs.__new__(FrontdoorEndpointArgs)

            if cdn_frontdoor_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'cdn_frontdoor_profile_id'")
            __props__.__dict__["cdn_frontdoor_profile_id"] = cdn_frontdoor_profile_id
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["host_name"] = None
        super(FrontdoorEndpoint, __self__).__init__(
            'azure:cdn/frontdoorEndpoint:FrontdoorEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cdn_frontdoor_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            host_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'FrontdoorEndpoint':
        """
        Get an existing FrontdoorEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cdn_frontdoor_profile_id: The ID of the Front Door Profile within which this Front Door Endpoint should exist. Changing this forces a new Front Door Endpoint to be created.
        :param pulumi.Input[_builtins.bool] enabled: Specifies if this Front Door Endpoint is enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.str] host_name: The host name of the Front Door Endpoint, in the format `{endpointName}.{dnsZone}` (for example, `contoso.azureedge.net`).
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Front Door Endpoint. Changing this forces a new Front Door Endpoint to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies a mapping of tags which should be assigned to the Front Door Endpoint.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FrontdoorEndpointState.__new__(_FrontdoorEndpointState)

        __props__.__dict__["cdn_frontdoor_profile_id"] = cdn_frontdoor_profile_id
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["host_name"] = host_name
        __props__.__dict__["name"] = name
        __props__.__dict__["tags"] = tags
        return FrontdoorEndpoint(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cdnFrontdoorProfileId")
    def cdn_frontdoor_profile_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Front Door Profile within which this Front Door Endpoint should exist. Changing this forces a new Front Door Endpoint to be created.
        """
        return pulumi.get(self, "cdn_frontdoor_profile_id")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies if this Front Door Endpoint is enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Output[_builtins.str]:
        """
        The host name of the Front Door Endpoint, in the format `{endpointName}.{dnsZone}` (for example, `contoso.azureedge.net`).
        """
        return pulumi.get(self, "host_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Front Door Endpoint. Changing this forces a new Front Door Endpoint to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies a mapping of tags which should be assigned to the Front Door Endpoint.
        """
        return pulumi.get(self, "tags")

