# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAccountResult',
    'AwaitableGetAccountResult',
    'get_account',
    'get_account_output',
]

@pulumi.output_type
class GetAccountResult:
    """
    A collection of values returned by getAccount.
    """
    def __init__(__self__, endpoint=None, id=None, identities=None, kind=None, local_auth_enabled=None, location=None, name=None, primary_access_key=None, qna_runtime_endpoint=None, resource_group_name=None, secondary_access_key=None, sku_name=None, tags=None):
        if endpoint and not isinstance(endpoint, str):
            raise TypeError("Expected argument 'endpoint' to be a str")
        pulumi.set(__self__, "endpoint", endpoint)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identities and not isinstance(identities, list):
            raise TypeError("Expected argument 'identities' to be a list")
        pulumi.set(__self__, "identities", identities)
        if kind and not isinstance(kind, str):
            raise TypeError("Expected argument 'kind' to be a str")
        pulumi.set(__self__, "kind", kind)
        if local_auth_enabled and not isinstance(local_auth_enabled, bool):
            raise TypeError("Expected argument 'local_auth_enabled' to be a bool")
        pulumi.set(__self__, "local_auth_enabled", local_auth_enabled)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if primary_access_key and not isinstance(primary_access_key, str):
            raise TypeError("Expected argument 'primary_access_key' to be a str")
        pulumi.set(__self__, "primary_access_key", primary_access_key)
        if qna_runtime_endpoint and not isinstance(qna_runtime_endpoint, str):
            raise TypeError("Expected argument 'qna_runtime_endpoint' to be a str")
        pulumi.set(__self__, "qna_runtime_endpoint", qna_runtime_endpoint)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if secondary_access_key and not isinstance(secondary_access_key, str):
            raise TypeError("Expected argument 'secondary_access_key' to be a str")
        pulumi.set(__self__, "secondary_access_key", secondary_access_key)
        if sku_name and not isinstance(sku_name, str):
            raise TypeError("Expected argument 'sku_name' to be a str")
        pulumi.set(__self__, "sku_name", sku_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> _builtins.str:
        """
        The endpoint of the Cognitive Services Account
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identities(self) -> Sequence['outputs.GetAccountIdentityResult']:
        """
        A `identity` block as defined below.
        """
        return pulumi.get(self, "identities")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> _builtins.str:
        """
        The kind of the Cognitive Services Account
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter(name="localAuthEnabled")
    def local_auth_enabled(self) -> _builtins.bool:
        """
        Whether local authentication methods is enabled for the Cognitive Account.
        """
        return pulumi.get(self, "local_auth_enabled")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure location where the Cognitive Services Account exists
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="primaryAccessKey")
    def primary_access_key(self) -> _builtins.str:
        """
        The primary access key of the Cognitive Services Account
        """
        return pulumi.get(self, "primary_access_key")

    @_builtins.property
    @pulumi.getter(name="qnaRuntimeEndpoint")
    def qna_runtime_endpoint(self) -> _builtins.str:
        """
        If `kind` is `QnAMaker` the link to the QNA runtime.
        """
        return pulumi.get(self, "qna_runtime_endpoint")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="secondaryAccessKey")
    def secondary_access_key(self) -> _builtins.str:
        """
        The secondary access key of the Cognitive Services Account
        """
        return pulumi.get(self, "secondary_access_key")

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> _builtins.str:
        """
        The SKU name of the Cognitive Services Account
        """
        return pulumi.get(self, "sku_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A mapping of tags to assigned to the resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetAccountResult(GetAccountResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccountResult(
            endpoint=self.endpoint,
            id=self.id,
            identities=self.identities,
            kind=self.kind,
            local_auth_enabled=self.local_auth_enabled,
            location=self.location,
            name=self.name,
            primary_access_key=self.primary_access_key,
            qna_runtime_endpoint=self.qna_runtime_endpoint,
            resource_group_name=self.resource_group_name,
            secondary_access_key=self.secondary_access_key,
            sku_name=self.sku_name,
            tags=self.tags)


def get_account(name: Optional[_builtins.str] = None,
                resource_group_name: Optional[_builtins.str] = None,
                tags: Optional[Mapping[str, _builtins.str]] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccountResult:
    """
    Use this data source to access information about an existing Cognitive Services Account.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    test = azure.cognitive.get_account(name="example-account",
        resource_group_name="cognitive_account_rg")
    pulumi.export("primaryAccessKey", test.primary_access_key)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.CognitiveServices`: 2024-10-01


    :param _builtins.str name: Specifies the name of the Cognitive Services Account.
    :param _builtins.str resource_group_name: Specifies the name of the resource group where the Cognitive Services Account resides.
    :param Mapping[str, _builtins.str] tags: A mapping of tags to assigned to the resource.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:cognitive/getAccount:getAccount', __args__, opts=opts, typ=GetAccountResult).value

    return AwaitableGetAccountResult(
        endpoint=pulumi.get(__ret__, 'endpoint'),
        id=pulumi.get(__ret__, 'id'),
        identities=pulumi.get(__ret__, 'identities'),
        kind=pulumi.get(__ret__, 'kind'),
        local_auth_enabled=pulumi.get(__ret__, 'local_auth_enabled'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        primary_access_key=pulumi.get(__ret__, 'primary_access_key'),
        qna_runtime_endpoint=pulumi.get(__ret__, 'qna_runtime_endpoint'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        secondary_access_key=pulumi.get(__ret__, 'secondary_access_key'),
        sku_name=pulumi.get(__ret__, 'sku_name'),
        tags=pulumi.get(__ret__, 'tags'))
def get_account_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                       resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                       tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccountResult]:
    """
    Use this data source to access information about an existing Cognitive Services Account.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    test = azure.cognitive.get_account(name="example-account",
        resource_group_name="cognitive_account_rg")
    pulumi.export("primaryAccessKey", test.primary_access_key)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.CognitiveServices`: 2024-10-01


    :param _builtins.str name: Specifies the name of the Cognitive Services Account.
    :param _builtins.str resource_group_name: Specifies the name of the resource group where the Cognitive Services Account resides.
    :param Mapping[str, _builtins.str] tags: A mapping of tags to assigned to the resource.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:cognitive/getAccount:getAccount', __args__, opts=opts, typ=GetAccountResult)
    return __ret__.apply(lambda __response__: GetAccountResult(
        endpoint=pulumi.get(__response__, 'endpoint'),
        id=pulumi.get(__response__, 'id'),
        identities=pulumi.get(__response__, 'identities'),
        kind=pulumi.get(__response__, 'kind'),
        local_auth_enabled=pulumi.get(__response__, 'local_auth_enabled'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        primary_access_key=pulumi.get(__response__, 'primary_access_key'),
        qna_runtime_endpoint=pulumi.get(__response__, 'qna_runtime_endpoint'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        secondary_access_key=pulumi.get(__response__, 'secondary_access_key'),
        sku_name=pulumi.get(__response__, 'sku_name'),
        tags=pulumi.get(__response__, 'tags')))
