# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GalleryApplicationVersionArgs', 'GalleryApplicationVersion']

@pulumi.input_type
class GalleryApplicationVersionArgs:
    def __init__(__self__, *,
                 gallery_application_id: pulumi.Input[_builtins.str],
                 manage_action: pulumi.Input['GalleryApplicationVersionManageActionArgs'],
                 source: pulumi.Input['GalleryApplicationVersionSourceArgs'],
                 target_regions: pulumi.Input[Sequence[pulumi.Input['GalleryApplicationVersionTargetRegionArgs']]],
                 config_file: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_health_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 end_of_life_date: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_from_latest: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 package_file: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a GalleryApplicationVersion resource.
        :param pulumi.Input[_builtins.str] gallery_application_id: The ID of the Gallery Application. Changing this forces a new resource to be created.
        :param pulumi.Input['GalleryApplicationVersionManageActionArgs'] manage_action: A `manage_action` block as defined below.
        :param pulumi.Input['GalleryApplicationVersionSourceArgs'] source: A `source` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['GalleryApplicationVersionTargetRegionArgs']]] target_regions: One or more `target_region` blocks as defined below.
        :param pulumi.Input[_builtins.str] config_file: Specifies the name of the config file on the VM. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] enable_health_check: Should the Gallery Application reports health. Defaults to `false`.
        :param pulumi.Input[_builtins.str] end_of_life_date: The end of life date in RFC3339 format of the Gallery Application Version.
        :param pulumi.Input[_builtins.bool] exclude_from_latest: Should the Gallery Application Version be excluded from the `latest` filter? If set to `true` this Gallery Application Version won't be returned for the `latest` version. Defaults to `false`.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Gallery Application Version exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The version name of the Gallery Application Version, such as `1.0.0`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] package_file: Specifies the name of the package file on the VM. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the Gallery Application Version.
        """
        pulumi.set(__self__, "gallery_application_id", gallery_application_id)
        pulumi.set(__self__, "manage_action", manage_action)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "target_regions", target_regions)
        if config_file is not None:
            pulumi.set(__self__, "config_file", config_file)
        if enable_health_check is not None:
            pulumi.set(__self__, "enable_health_check", enable_health_check)
        if end_of_life_date is not None:
            pulumi.set(__self__, "end_of_life_date", end_of_life_date)
        if exclude_from_latest is not None:
            pulumi.set(__self__, "exclude_from_latest", exclude_from_latest)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if package_file is not None:
            pulumi.set(__self__, "package_file", package_file)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="galleryApplicationId")
    def gallery_application_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Gallery Application. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "gallery_application_id")

    @gallery_application_id.setter
    def gallery_application_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "gallery_application_id", value)

    @_builtins.property
    @pulumi.getter(name="manageAction")
    def manage_action(self) -> pulumi.Input['GalleryApplicationVersionManageActionArgs']:
        """
        A `manage_action` block as defined below.
        """
        return pulumi.get(self, "manage_action")

    @manage_action.setter
    def manage_action(self, value: pulumi.Input['GalleryApplicationVersionManageActionArgs']):
        pulumi.set(self, "manage_action", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Input['GalleryApplicationVersionSourceArgs']:
        """
        A `source` block as defined below.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input['GalleryApplicationVersionSourceArgs']):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter(name="targetRegions")
    def target_regions(self) -> pulumi.Input[Sequence[pulumi.Input['GalleryApplicationVersionTargetRegionArgs']]]:
        """
        One or more `target_region` blocks as defined below.
        """
        return pulumi.get(self, "target_regions")

    @target_regions.setter
    def target_regions(self, value: pulumi.Input[Sequence[pulumi.Input['GalleryApplicationVersionTargetRegionArgs']]]):
        pulumi.set(self, "target_regions", value)

    @_builtins.property
    @pulumi.getter(name="configFile")
    def config_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the config file on the VM. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "config_file")

    @config_file.setter
    def config_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config_file", value)

    @_builtins.property
    @pulumi.getter(name="enableHealthCheck")
    def enable_health_check(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Gallery Application reports health. Defaults to `false`.
        """
        return pulumi.get(self, "enable_health_check")

    @enable_health_check.setter
    def enable_health_check(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_health_check", value)

    @_builtins.property
    @pulumi.getter(name="endOfLifeDate")
    def end_of_life_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The end of life date in RFC3339 format of the Gallery Application Version.
        """
        return pulumi.get(self, "end_of_life_date")

    @end_of_life_date.setter
    def end_of_life_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "end_of_life_date", value)

    @_builtins.property
    @pulumi.getter(name="excludeFromLatest")
    def exclude_from_latest(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Gallery Application Version be excluded from the `latest` filter? If set to `true` this Gallery Application Version won't be returned for the `latest` version. Defaults to `false`.
        """
        return pulumi.get(self, "exclude_from_latest")

    @exclude_from_latest.setter
    def exclude_from_latest(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "exclude_from_latest", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Gallery Application Version exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version name of the Gallery Application Version, such as `1.0.0`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="packageFile")
    def package_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the package file on the VM. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "package_file")

    @package_file.setter
    def package_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "package_file", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the Gallery Application Version.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _GalleryApplicationVersionState:
    def __init__(__self__, *,
                 config_file: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_health_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 end_of_life_date: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_from_latest: Optional[pulumi.Input[_builtins.bool]] = None,
                 gallery_application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 manage_action: Optional[pulumi.Input['GalleryApplicationVersionManageActionArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 package_file: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input['GalleryApplicationVersionSourceArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_regions: Optional[pulumi.Input[Sequence[pulumi.Input['GalleryApplicationVersionTargetRegionArgs']]]] = None):
        """
        Input properties used for looking up and filtering GalleryApplicationVersion resources.
        :param pulumi.Input[_builtins.str] config_file: Specifies the name of the config file on the VM. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] enable_health_check: Should the Gallery Application reports health. Defaults to `false`.
        :param pulumi.Input[_builtins.str] end_of_life_date: The end of life date in RFC3339 format of the Gallery Application Version.
        :param pulumi.Input[_builtins.bool] exclude_from_latest: Should the Gallery Application Version be excluded from the `latest` filter? If set to `true` this Gallery Application Version won't be returned for the `latest` version. Defaults to `false`.
        :param pulumi.Input[_builtins.str] gallery_application_id: The ID of the Gallery Application. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Gallery Application Version exists. Changing this forces a new resource to be created.
        :param pulumi.Input['GalleryApplicationVersionManageActionArgs'] manage_action: A `manage_action` block as defined below.
        :param pulumi.Input[_builtins.str] name: The version name of the Gallery Application Version, such as `1.0.0`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] package_file: Specifies the name of the package file on the VM. Changing this forces a new resource to be created.
        :param pulumi.Input['GalleryApplicationVersionSourceArgs'] source: A `source` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the Gallery Application Version.
        :param pulumi.Input[Sequence[pulumi.Input['GalleryApplicationVersionTargetRegionArgs']]] target_regions: One or more `target_region` blocks as defined below.
        """
        if config_file is not None:
            pulumi.set(__self__, "config_file", config_file)
        if enable_health_check is not None:
            pulumi.set(__self__, "enable_health_check", enable_health_check)
        if end_of_life_date is not None:
            pulumi.set(__self__, "end_of_life_date", end_of_life_date)
        if exclude_from_latest is not None:
            pulumi.set(__self__, "exclude_from_latest", exclude_from_latest)
        if gallery_application_id is not None:
            pulumi.set(__self__, "gallery_application_id", gallery_application_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if manage_action is not None:
            pulumi.set(__self__, "manage_action", manage_action)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if package_file is not None:
            pulumi.set(__self__, "package_file", package_file)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_regions is not None:
            pulumi.set(__self__, "target_regions", target_regions)

    @_builtins.property
    @pulumi.getter(name="configFile")
    def config_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the config file on the VM. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "config_file")

    @config_file.setter
    def config_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config_file", value)

    @_builtins.property
    @pulumi.getter(name="enableHealthCheck")
    def enable_health_check(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Gallery Application reports health. Defaults to `false`.
        """
        return pulumi.get(self, "enable_health_check")

    @enable_health_check.setter
    def enable_health_check(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_health_check", value)

    @_builtins.property
    @pulumi.getter(name="endOfLifeDate")
    def end_of_life_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The end of life date in RFC3339 format of the Gallery Application Version.
        """
        return pulumi.get(self, "end_of_life_date")

    @end_of_life_date.setter
    def end_of_life_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "end_of_life_date", value)

    @_builtins.property
    @pulumi.getter(name="excludeFromLatest")
    def exclude_from_latest(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Gallery Application Version be excluded from the `latest` filter? If set to `true` this Gallery Application Version won't be returned for the `latest` version. Defaults to `false`.
        """
        return pulumi.get(self, "exclude_from_latest")

    @exclude_from_latest.setter
    def exclude_from_latest(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "exclude_from_latest", value)

    @_builtins.property
    @pulumi.getter(name="galleryApplicationId")
    def gallery_application_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Gallery Application. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "gallery_application_id")

    @gallery_application_id.setter
    def gallery_application_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gallery_application_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Gallery Application Version exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="manageAction")
    def manage_action(self) -> Optional[pulumi.Input['GalleryApplicationVersionManageActionArgs']]:
        """
        A `manage_action` block as defined below.
        """
        return pulumi.get(self, "manage_action")

    @manage_action.setter
    def manage_action(self, value: Optional[pulumi.Input['GalleryApplicationVersionManageActionArgs']]):
        pulumi.set(self, "manage_action", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version name of the Gallery Application Version, such as `1.0.0`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="packageFile")
    def package_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the package file on the VM. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "package_file")

    @package_file.setter
    def package_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "package_file", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['GalleryApplicationVersionSourceArgs']]:
        """
        A `source` block as defined below.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['GalleryApplicationVersionSourceArgs']]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the Gallery Application Version.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="targetRegions")
    def target_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GalleryApplicationVersionTargetRegionArgs']]]]:
        """
        One or more `target_region` blocks as defined below.
        """
        return pulumi.get(self, "target_regions")

    @target_regions.setter
    def target_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GalleryApplicationVersionTargetRegionArgs']]]]):
        pulumi.set(self, "target_regions", value)


@pulumi.type_token("azure:compute/galleryApplicationVersion:GalleryApplicationVersion")
class GalleryApplicationVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_file: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_health_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 end_of_life_date: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_from_latest: Optional[pulumi.Input[_builtins.bool]] = None,
                 gallery_application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 manage_action: Optional[pulumi.Input[Union['GalleryApplicationVersionManageActionArgs', 'GalleryApplicationVersionManageActionArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 package_file: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[Union['GalleryApplicationVersionSourceArgs', 'GalleryApplicationVersionSourceArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_regions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GalleryApplicationVersionTargetRegionArgs', 'GalleryApplicationVersionTargetRegionArgsDict']]]]] = None,
                 __props__=None):
        """
        Manages a Gallery Application Version.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West Europe")
        example_shared_image_gallery = azure.compute.SharedImageGallery("example",
            name="examplegallery",
            resource_group_name=example.name,
            location=example.location)
        example_gallery_application = azure.compute.GalleryApplication("example",
            name="example-app",
            gallery_id=example_shared_image_gallery.id,
            location=example.location,
            supported_os_type="Linux")
        example_account = azure.storage.Account("example",
            name="examplestorage",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_container = azure.storage.Container("example",
            name="example-container",
            storage_account_name=example_account.name,
            container_access_type="blob")
        example_blob = azure.storage.Blob("example",
            name="scripts",
            storage_account_name=example_account.name,
            storage_container_name=example_container.name,
            type="Block",
            source_content="[scripts file content]")
        example_gallery_application_version = azure.compute.GalleryApplicationVersion("example",
            name="0.0.1",
            gallery_application_id=example_gallery_application.id,
            location=example_gallery_application.location,
            manage_action={
                "install": "[install command]",
                "remove": "[remove command]",
            },
            source={
                "media_link": example_blob.id,
            },
            target_regions=[{
                "name": example_gallery_application.location,
                "regional_replica_count": 1,
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Compute`: 2022-03-03

        ## Import

        Gallery Application Versions can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:compute/galleryApplicationVersion:GalleryApplicationVersion example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Compute/galleries/gallery1/applications/galleryApplication1/versions/galleryApplicationVersion1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] config_file: Specifies the name of the config file on the VM. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] enable_health_check: Should the Gallery Application reports health. Defaults to `false`.
        :param pulumi.Input[_builtins.str] end_of_life_date: The end of life date in RFC3339 format of the Gallery Application Version.
        :param pulumi.Input[_builtins.bool] exclude_from_latest: Should the Gallery Application Version be excluded from the `latest` filter? If set to `true` this Gallery Application Version won't be returned for the `latest` version. Defaults to `false`.
        :param pulumi.Input[_builtins.str] gallery_application_id: The ID of the Gallery Application. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Gallery Application Version exists. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['GalleryApplicationVersionManageActionArgs', 'GalleryApplicationVersionManageActionArgsDict']] manage_action: A `manage_action` block as defined below.
        :param pulumi.Input[_builtins.str] name: The version name of the Gallery Application Version, such as `1.0.0`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] package_file: Specifies the name of the package file on the VM. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['GalleryApplicationVersionSourceArgs', 'GalleryApplicationVersionSourceArgsDict']] source: A `source` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the Gallery Application Version.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GalleryApplicationVersionTargetRegionArgs', 'GalleryApplicationVersionTargetRegionArgsDict']]]] target_regions: One or more `target_region` blocks as defined below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GalleryApplicationVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Gallery Application Version.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West Europe")
        example_shared_image_gallery = azure.compute.SharedImageGallery("example",
            name="examplegallery",
            resource_group_name=example.name,
            location=example.location)
        example_gallery_application = azure.compute.GalleryApplication("example",
            name="example-app",
            gallery_id=example_shared_image_gallery.id,
            location=example.location,
            supported_os_type="Linux")
        example_account = azure.storage.Account("example",
            name="examplestorage",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_container = azure.storage.Container("example",
            name="example-container",
            storage_account_name=example_account.name,
            container_access_type="blob")
        example_blob = azure.storage.Blob("example",
            name="scripts",
            storage_account_name=example_account.name,
            storage_container_name=example_container.name,
            type="Block",
            source_content="[scripts file content]")
        example_gallery_application_version = azure.compute.GalleryApplicationVersion("example",
            name="0.0.1",
            gallery_application_id=example_gallery_application.id,
            location=example_gallery_application.location,
            manage_action={
                "install": "[install command]",
                "remove": "[remove command]",
            },
            source={
                "media_link": example_blob.id,
            },
            target_regions=[{
                "name": example_gallery_application.location,
                "regional_replica_count": 1,
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Compute`: 2022-03-03

        ## Import

        Gallery Application Versions can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:compute/galleryApplicationVersion:GalleryApplicationVersion example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Compute/galleries/gallery1/applications/galleryApplication1/versions/galleryApplicationVersion1
        ```

        :param str resource_name: The name of the resource.
        :param GalleryApplicationVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GalleryApplicationVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_file: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_health_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 end_of_life_date: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_from_latest: Optional[pulumi.Input[_builtins.bool]] = None,
                 gallery_application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 manage_action: Optional[pulumi.Input[Union['GalleryApplicationVersionManageActionArgs', 'GalleryApplicationVersionManageActionArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 package_file: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[Union['GalleryApplicationVersionSourceArgs', 'GalleryApplicationVersionSourceArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_regions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GalleryApplicationVersionTargetRegionArgs', 'GalleryApplicationVersionTargetRegionArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GalleryApplicationVersionArgs.__new__(GalleryApplicationVersionArgs)

            __props__.__dict__["config_file"] = config_file
            __props__.__dict__["enable_health_check"] = enable_health_check
            __props__.__dict__["end_of_life_date"] = end_of_life_date
            __props__.__dict__["exclude_from_latest"] = exclude_from_latest
            if gallery_application_id is None and not opts.urn:
                raise TypeError("Missing required property 'gallery_application_id'")
            __props__.__dict__["gallery_application_id"] = gallery_application_id
            __props__.__dict__["location"] = location
            if manage_action is None and not opts.urn:
                raise TypeError("Missing required property 'manage_action'")
            __props__.__dict__["manage_action"] = manage_action
            __props__.__dict__["name"] = name
            __props__.__dict__["package_file"] = package_file
            if source is None and not opts.urn:
                raise TypeError("Missing required property 'source'")
            __props__.__dict__["source"] = source
            __props__.__dict__["tags"] = tags
            if target_regions is None and not opts.urn:
                raise TypeError("Missing required property 'target_regions'")
            __props__.__dict__["target_regions"] = target_regions
        super(GalleryApplicationVersion, __self__).__init__(
            'azure:compute/galleryApplicationVersion:GalleryApplicationVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config_file: Optional[pulumi.Input[_builtins.str]] = None,
            enable_health_check: Optional[pulumi.Input[_builtins.bool]] = None,
            end_of_life_date: Optional[pulumi.Input[_builtins.str]] = None,
            exclude_from_latest: Optional[pulumi.Input[_builtins.bool]] = None,
            gallery_application_id: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            manage_action: Optional[pulumi.Input[Union['GalleryApplicationVersionManageActionArgs', 'GalleryApplicationVersionManageActionArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            package_file: Optional[pulumi.Input[_builtins.str]] = None,
            source: Optional[pulumi.Input[Union['GalleryApplicationVersionSourceArgs', 'GalleryApplicationVersionSourceArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            target_regions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GalleryApplicationVersionTargetRegionArgs', 'GalleryApplicationVersionTargetRegionArgsDict']]]]] = None) -> 'GalleryApplicationVersion':
        """
        Get an existing GalleryApplicationVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] config_file: Specifies the name of the config file on the VM. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] enable_health_check: Should the Gallery Application reports health. Defaults to `false`.
        :param pulumi.Input[_builtins.str] end_of_life_date: The end of life date in RFC3339 format of the Gallery Application Version.
        :param pulumi.Input[_builtins.bool] exclude_from_latest: Should the Gallery Application Version be excluded from the `latest` filter? If set to `true` this Gallery Application Version won't be returned for the `latest` version. Defaults to `false`.
        :param pulumi.Input[_builtins.str] gallery_application_id: The ID of the Gallery Application. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Gallery Application Version exists. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['GalleryApplicationVersionManageActionArgs', 'GalleryApplicationVersionManageActionArgsDict']] manage_action: A `manage_action` block as defined below.
        :param pulumi.Input[_builtins.str] name: The version name of the Gallery Application Version, such as `1.0.0`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] package_file: Specifies the name of the package file on the VM. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['GalleryApplicationVersionSourceArgs', 'GalleryApplicationVersionSourceArgsDict']] source: A `source` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the Gallery Application Version.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GalleryApplicationVersionTargetRegionArgs', 'GalleryApplicationVersionTargetRegionArgsDict']]]] target_regions: One or more `target_region` blocks as defined below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GalleryApplicationVersionState.__new__(_GalleryApplicationVersionState)

        __props__.__dict__["config_file"] = config_file
        __props__.__dict__["enable_health_check"] = enable_health_check
        __props__.__dict__["end_of_life_date"] = end_of_life_date
        __props__.__dict__["exclude_from_latest"] = exclude_from_latest
        __props__.__dict__["gallery_application_id"] = gallery_application_id
        __props__.__dict__["location"] = location
        __props__.__dict__["manage_action"] = manage_action
        __props__.__dict__["name"] = name
        __props__.__dict__["package_file"] = package_file
        __props__.__dict__["source"] = source
        __props__.__dict__["tags"] = tags
        __props__.__dict__["target_regions"] = target_regions
        return GalleryApplicationVersion(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="configFile")
    def config_file(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the name of the config file on the VM. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "config_file")

    @_builtins.property
    @pulumi.getter(name="enableHealthCheck")
    def enable_health_check(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the Gallery Application reports health. Defaults to `false`.
        """
        return pulumi.get(self, "enable_health_check")

    @_builtins.property
    @pulumi.getter(name="endOfLifeDate")
    def end_of_life_date(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The end of life date in RFC3339 format of the Gallery Application Version.
        """
        return pulumi.get(self, "end_of_life_date")

    @_builtins.property
    @pulumi.getter(name="excludeFromLatest")
    def exclude_from_latest(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the Gallery Application Version be excluded from the `latest` filter? If set to `true` this Gallery Application Version won't be returned for the `latest` version. Defaults to `false`.
        """
        return pulumi.get(self, "exclude_from_latest")

    @_builtins.property
    @pulumi.getter(name="galleryApplicationId")
    def gallery_application_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Gallery Application. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "gallery_application_id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Gallery Application Version exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="manageAction")
    def manage_action(self) -> pulumi.Output['outputs.GalleryApplicationVersionManageAction']:
        """
        A `manage_action` block as defined below.
        """
        return pulumi.get(self, "manage_action")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The version name of the Gallery Application Version, such as `1.0.0`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="packageFile")
    def package_file(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the name of the package file on the VM. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "package_file")

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Output['outputs.GalleryApplicationVersionSource']:
        """
        A `source` block as defined below.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the Gallery Application Version.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="targetRegions")
    def target_regions(self) -> pulumi.Output[Sequence['outputs.GalleryApplicationVersionTargetRegion']]:
        """
        One or more `target_region` blocks as defined below.
        """
        return pulumi.get(self, "target_regions")

